# CQMCommonExample - Your User Friendly Name for MyContentIG Here v0.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CQMCommonExample**

## Library: CQMCommonExample 

| | |
| :--- | :--- |
| *Official URL*:http://somewhere.org/fhir/uv/mycontentig/Library/CQMCommonExample | *Version*:0.5.3 |
| Draft as of 2025-12-10 | *Computable Name*:CQMCommonExample |

* Metadata: Version
  * ?: 0.5.3
* Metadata: Status
  * ?: Draft
* Metadata: Jurisdiction
  * ?: 001 from[http://unstats.un.org/unsd/methods/m49/m49.htm](http://unstats.un.org/unsd/methods/m49/m49.htm)
* Metadata: Steward (Publisher)
  * ?: HL7 International - [Some] Work Group
* Metadata: Type
  * ?: logic-library from[http://terminology.hl7.org/CodeSystem/library-type](http://terminology.hl7.org/7.0.0/CodeSystem-library-type.html)
* Metadata: Dependency
  * ?: **Description**: Library FHIRHelpers**Resource**:`http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1`**Canonical URL**:http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1
* Metadata: Dependency
  * ?: **Description**: Library QICoreCommon**Resource**:[QICoreCommonExample](Library-QICoreCommonExample.md)**Canonical URL**:http://somewhere.org/fhir/uv/mycontentig/Library/QICoreCommonExample
* Metadata: Dependency
  * ?: **Description**: Value set Emergency Department Visit**Resource**:[Emergency Department Visit](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.292/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.292
* Metadata: Dependency
  * ?: **Description**: Value set Encounter Inpatient**Resource**:[Encounter Inpatient](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.666.5.307/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.666.5.307
* Metadata: Dependency
  * ?: **Description**: Value set Intensive Care Unit**Resource**:[Intensive Care Unit](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1029.206/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1029.206
* Metadata: Dependency
  * ?: **Description**: Value set Observation Services**Resource**:[Observation Services](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1111.143/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1111.143
* Metadata: Dependency
  * ?: **Description**: Value set Outpatient Surgery Service**Resource**:[Outpatient Surgery Service](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1110.38/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1110.38
* Metadata: Dependency
  * ?: **Description**: Value set Present on Admission or Clinically Undetermined**Resource**:[Present on Admission or Clinically Undetermined](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1147.197/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1147.197
* Metadata: Data Requirement
  * ?: **Type**: Patient**Profile(s)**:[QICore Patient](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-patient.html)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, status, status.value, period, location, location.type, condition, condition.reference, condition.reference.value, rank, rank.value**Code Filter(s)**:**Path**: type**ValueSet**:[Encounter Inpatient](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.666.5.307/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, period, location, location.type, condition, condition.reference, condition.reference.value, rank, rank.value**Code Filter(s)**:**Path**: type**ValueSet**:[Outpatient Surgery Service](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1110.38/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, status, status.value, period, location, location.type, condition, condition.reference, condition.reference.value, rank, rank.value**Code Filter(s)**:**Path**: type**ValueSet**:[Observation Services](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1111.143/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, status, status.value, period, location, location.type, condition, condition.reference, condition.reference.value, rank, rank.value**Code Filter(s)**:**Path**: type**ValueSet**:[Emergency Department Visit](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.292/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Location**Profile(s)**:[QICore Location](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-location.html)**Must Support Elements**: id, id.value
* Metadata: Data Requirement
  * ?: **Type**: Condition**Profile(s)**:`http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition`**Must Support Elements**: id, id.value
* Metadata: Data Requirement
  * ?: **Type**: Medication**Profile(s)**:[QICore Medication](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-medication.html)**Must Support Elements**: id, id.value
* Metadata: Parameters
* Metadata: 
  * ?: 
| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| **Name** | **Use** | **Card.** | **Type** | **Documentation** |
| Measurement Period | In | 0..1 | Period |  |
| Patient | Out | 0..1 | Resource |  |
| Inpatient Encounter | Out | 0..* | Resource |  |

* Metadata: Library Content
* Metadata: CQL Content
  * ?: ````library CQMCommonExample version '0.5.3-cibuild' using QICore version '4.1.1' include FHIRHelpers version '4.0.1' called FHIRHelpers include QICoreCommonExample called QICoreCommon valueset "Emergency Department Visit": 'http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.292' valueset "Encounter Inpatient": 'http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.666.5.307' valueset "Intensive Care Unit": 'http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1029.206' valueset "Observation Services": 'http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1111.143' valueset "Outpatient Surgery Service": 'http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1110.38' valueset "Present on Admission or Clinically Undetermined": 'http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1147.197' parameter "Measurement Period" Interval<DateTime> default Interval[@2024-01-01T00:00:00.0, @2025-01-01T00:00:00.0) context Patient define "Inpatient Encounter": [Encounter: "Encounter Inpatient"] EncounterInpatient where EncounterInpatient.status = 'finished' and EncounterInpatient.period ends during day of "Measurement Period" /* @description: Returns an interval of date values extracted from the input interval of date-time values @comment: This function returns an interval constructed using the `date from` extractor on the start and end values of the input date-time interval. Note that using a precision specifier such as `day of` as part of a timing phrase is preferred to communicate intent to perform day-level comparison, as well as for general readability. */ define function "ToDateInterval"(period Interval<DateTime>): Interval[date from start of period, date from end of period] /* @description: Calculates the difference in calendar days between the start and end of the given interval. @deprecated: This function in deprecated. Use the fluent function `lengthInDays()` instead. */ define function "LengthInDays"(Value Interval<DateTime> ): difference in days between start of Value and end of Value /* @description: Calculates the difference in calendar days between the start and end of the given interval. */ define fluent function lengthInDays(Value Interval<DateTime> ): difference in days between start of Value and end of Value /* @description: Returns the most recent emergency department visit, if any, that occurs 1 hour or less prior to the given encounter. @deprecated: This function is deprecated. Use the fluent function `edVisit()` instead. */ define function "ED Visit"(TheEncounter Encounter ): Last( [Encounter: "Emergency Department Visit"] EDVisit where EDVisit.status = 'finished' and EDVisit.period ends 1 hour or less on or before start of TheEncounter.period sort by end of period ) /* @description: Returns the most recent emergency department visit, if any, that occurs 1 hour or less prior to the given encounter. */ define fluent function edVisit(TheEncounter Encounter ): Last( [Encounter: "Emergency Department Visit"] EDVisit where EDVisit.status = 'finished' and EDVisit.period ends 1 hour or less on or before start of TheEncounter.period sort by end of period ) /* @description: Hospitalization returns the total interval for admission to discharge for the given encounter, or for the admission of any immediately prior emergency department visit to the discharge of the given encounter. @deprecated: This function is deprecated. Use the fluent function `hospitalization()` instead. */ define function "Hospitalization"(TheEncounter Encounter ): ( "ED Visit"(TheEncounter) ) X return if X is null then TheEncounter.period else Interval[start of X.period, end of TheEncounter.period) /* @description: Hospitalization returns the total interval for admission to discharge for the given encounter, or for the admission of any immediately prior emergency department visit to the discharge of the given encounter. */ define fluent function hospitalization(TheEncounter Encounter ): (TheEncounter."edVisit"()) X return if X is null then TheEncounter.period else Interval[start of X.period, end of TheEncounter.period] /* @description: Returns list of all locations within an encounter, including locations for immediately prior ED visit. @deprecated: This function is deprecated. Use the fluent function `hospitalizationLocations()` instead. */ define function "Hospitalization Locations"(TheEncounter Encounter ): ( "ED Visit"(TheEncounter) ) EDEncounter return if EDEncounter is null then TheEncounter.location else flatten { EDEncounter.location, TheEncounter.location } /* @description: Returns list of all locations within an encounter, including locations for immediately prior ED visit. */ define fluent function hospitalizationLocations(TheEncounter Encounter ): ( TheEncounter."edVisit"()) EDEncounter return if EDEncounter is null then TheEncounter.location else flatten { EDEncounter.location, TheEncounter.location } /* @description: Returns the length of stay in days (i.e. the number of days between admission and discharge) for the given encounter, or from the admission of any immediately prior emergency department visit to the discharge of the encounter @deprecated: This function is deprecated. Use the fluent function `hospitalizationLengthOfStay()` instead. */ define function "Hospitalization Length of Stay"(TheEncounter Encounter ): LengthInDays("Hospitalization"(TheEncounter)) /* @description: Returns the length of stay in days (i.e. the number of days between admission and discharge) for the given encounter, or from the admission of any immediately prior emergency department visit to the discharge of the encounter */ define fluent function hospitalizationLengthOfStay(TheEncounter Encounter ): TheEncounter."hospitalization"()."lengthInDays"() /* @description: Returns admission time for an encounter or for immediately prior emergency department visit. @deprecated: This function is deprecated. Use the fluent function `hospitalAdmissionTime()` instead. */ define function "Hospital Admission Time"(TheEncounter Encounter ): start of "Hospitalization"(TheEncounter) /* @description: Returns admission time for an encounter or for immediately prior emergency department visit. */ define fluent function hospitalAdmissionTime(TheEncounter Encounter ): start of (TheEncounter."hospitalization"()) /* @description: Hospital Discharge Time returns the discharge time for an encounter @deprecated: This function is deprecated. Use the fluent function `hospitalDischargeTime()` instead. */ define function "Hospital Discharge Time"(TheEncounter Encounter ): end of TheEncounter.period /* @description: Hospital Discharge Time returns the discharge time for an encounter */ define fluent function hospitalDischargeTime(TheEncounter Encounter ): end of TheEncounter.period /* @description: Returns earliest arrival time for an encounter including any prior ED visit. @deprecated: This function is deprecated. Use the fluent function `hospitalArrivalTime()` instead. */ define function "Hospital Arrival Time"(TheEncounter Encounter ): start of First( ("Hospitalization Locations"(TheEncounter) ) HospitalLocation sort by start of period ).period /* @description: Returns earliest arrival time for an encounter including any prior ED visit. */ define fluent function hospitalArrivalTime(TheEncounter Encounter ): start of First( (TheEncounter."hospitalizationLocations"()) HospitalLocation sort by start of period ).period /* @description: Returns the latest departure time for encounter including any prior ED visit. @deprecated: This function is deprecated. Use the fluent function `hospitalDepartureTime()` instead. */ define function "Hospital Departure Time"(TheEncounter Encounter): end of Last( ( "Hospitalization Locations"(TheEncounter) ) HospitalLocation sort by start of period ).period /* @description: Returns the latest departure time for encounter including any prior ED visit. */ define fluent function hospitalDepartureTime(TheEncounter Encounter): end of Last( (TheEncounter."hospitalizationLocations"()) HospitalLocation sort by start of period ).period /* @description: Returns the emergency department arrival time for the encounter. @deprecated. This function is deprecated. Use the fluent function `emergencyDepartmentArrivalTime()` instead. */ define function "Emergency Department Arrival Time"(TheEncounter Encounter): start of ( singleton from ( ( "Hospitalization Locations"(TheEncounter) ) HospitalLocation where GetLocation(HospitalLocation.location).type in "Emergency Department Visit" ) ).period /* @description: Returns the emergency department arrival time for the encounter. */ define fluent function emergencyDepartmentArrivalTime(TheEncounter Encounter): start of ( singleton from ( ( (TheEncounter. "hospitalizationLocations"()) ) HospitalLocation where GetLocation(HospitalLocation.location).type in "Emergency Department Visit" ) ).period /* @description: Hospitalization with Observation and Outpatient Surgery Service returns the total interval from the start of any immediately prior emergency department visit, outpatient surgery visit or observation visit to the discharge of the given encounter. @deprecated: This function is deprecated. Use the fluent function `hospitalizationWithObservationAndOutpatientSurgeryService()` instead. */ define function "HospitalizationWithObservationAndOutpatientSurgeryService"(TheEncounter "Encounter" ): TheEncounter Visit let ObsVisit: Last([Encounter: "Observation Services"] LastObs where LastObs.status = 'finished' and LastObs.period ends 1 hour or less on or before start of Visit.period sort by end of period ), VisitStart: Coalesce(start of ObsVisit.period, start of Visit.period), EDVisit: Last([Encounter: "Emergency Department Visit"] LastED where LastED.status = 'finished' and LastED.period ends 1 hour or less on or before VisitStart sort by end of period ), VisitStartWithED: Coalesce(start of EDVisit.period, VisitStart), OutpatientSurgeryVisit: Last([Encounter: "Outpatient Surgery Service"] LastSurgeryOP where LastSurgeryOP.period ends 1 hour or less on or before VisitStartWithED sort by end of period ) return Interval[Coalesce(start of OutpatientSurgeryVisit.period, VisitStartWithED), end of Visit.period] /* @description: Hospitalization with Observation and Outpatient Surgery Service returns the total interval from the start of any immediately prior emergency department visit, outpatient surgery visit or observation visit to the discharge of the given encounter. */ define fluent function hospitalizationWithObservationAndOutpatientSurgeryService(TheEncounter "Encounter" ): TheEncounter Visit let ObsVisit: Last([Encounter: "Observation Services"] LastObs where LastObs.status = 'finished' and LastObs.period ends 1 hour or less on or before start of Visit.period sort by end of period ), VisitStart: Coalesce(start of ObsVisit.period, start of Visit.period), EDVisit: Last([Encounter: "Emergency Department Visit"] LastED where LastED.status = 'finished' and LastED.period ends 1 hour or less on or before VisitStart sort by end of period ), VisitStartWithED: Coalesce(start of EDVisit.period, VisitStart), OutpatientSurgeryVisit: Last([Encounter: "Outpatient Surgery Service"] LastSurgeryOP where LastSurgeryOP.period ends 1 hour or less on or before VisitStartWithED sort by end of period ) return Interval[Coalesce(start of OutpatientSurgeryVisit.period, VisitStartWithED), end of Visit.period] /* @description: Hospitalization with Observation returns the total interval from the start of any immediately prior emergency department visit through the observation visit to the discharge of the given encounter @deprecated: This function is deprecated. Use the fluent function `hospitalizationWithObservation()` instead. */ define function "HospitalizationWithObservation"(TheEncounter Encounter ): TheEncounter Visit let ObsVisit: Last([Encounter: "Observation Services"] LastObs where LastObs.status = 'finished' and LastObs.period ends 1 hour or less on or before start of Visit.period sort by end of period ), VisitStart: Coalesce(start of ObsVisit.period, start of Visit.period), EDVisit: Last([Encounter: "Emergency Department Visit"] LastED where LastED.status = 'finished' and LastED.period ends 1 hour or less on or before VisitStart sort by end of period ) return Interval[Coalesce(start of EDVisit.period, VisitStart), end of Visit.period] /* @description: Hospitalization with Observation returns the total interval from the start of any immediately prior emergency department visit through the observation visit to the discharge of the given encounter */ define fluent function hospitalizationWithObservation(TheEncounter Encounter ): TheEncounter Visit let ObsVisit: Last([Encounter: "Observation Services"] LastObs where LastObs.status = 'finished' and LastObs.period ends 1 hour or less on or before start of Visit.period sort by end of period ), VisitStart: Coalesce(start of ObsVisit.period, start of Visit.period), EDVisit: Last([Encounter: "Emergency Department Visit"] LastED where LastED.status = 'finished' and LastED.period ends 1 hour or less on or before VisitStart sort by end of period ) return Interval[Coalesce(start of EDVisit.period, VisitStart), end of Visit.period] /* @description: Hospitalization with Observation Length of Stay returns the length in days from the start of any immediately prior emergency department visit through the observation visit to the discharge of the given encounter @deprecated: This function is deprecated. Use the fluent function `hospitalizationWithObservationLengthofStay()` instead. */ define function "HospitalizationWithObservationLengthofStay"(TheEncounter "Encounter" ): "LengthInDays"("HospitalizationWithObservation"(TheEncounter)) /* @description: Hospitalization with Observation Length of Stay returns the length in days from the start of any immediately prior emergency department visit through the observation visit to the discharge of the given encounter */ define fluent function hospitalizationWithObservationLengthofStay(TheEncounter "Encounter" ): ((TheEncounter."hospitalizationWithObservation"(). "lengthInDays"())) /* @description: First Inpatient Intensive Care Unit returns the first intensive care unit for the given encounter, without considering any immediately prior emergency department visit. @deprecated: This function is deprecated. Use the fluent function `firstInpatientIntensiveCareUnit()` instead. */ define function "FirstInpatientIntensiveCareUnit"(Encounter Encounter ): First((Encounter.location)HospitalLocation where GetLocation(HospitalLocation.location).type in "Intensive Care Unit" and HospitalLocation.period during Encounter.period sort by start of period ) /* @description: First Inpatient Intensive Care Unit returns the first intensive care unit for the given encounter, without considering any immediately prior emergency department visit. */ define fluent function firstInpatientIntensiveCareUnit(Encounter Encounter ): First((Encounter.location)HospitalLocation where GetLocation(HospitalLocation.location).type in "Intensive Care Unit" and HospitalLocation.period during Encounter.period sort by start of period ) /* @description: Returns the Condition resource referenced by the `diagnosis.condition` element of the Encounter @deprecated: This function is deprecated. Use the fluent function `encounterDiagnosis()` instead. */ define function "EncounterDiagnosis"(Encounter Encounter ): Encounter.diagnosis D return singleton from ([Condition] C where C.id = D.condition.reference.getId()) /* @description: Returns the Condition resources referenced by the diagnosis element of the Encounter */ define fluent function encounterDiagnosis(Encounter Encounter ): Encounter.diagnosis D return singleton from ([Condition] C where C.id = D.condition.reference.getId()) /* @description: Returns the Condition resource for the given reference @deprecated: This function is deprecated. Use the fluent function `getCondition()` instead */ define function "GetCondition"(reference Reference): singleton from ([Condition] C where C.id = reference.reference.getId()) /* @description: Returns the Condition resource for the given reference */ define fluent function getCondition(reference Reference): singleton from ([Condition] C where C.id = reference.reference.getId()) /* @description: Returns the condition that is specified as the principal diagnosis for the encounter @deprecated: This function is deprecated. Use the fluent function `principalDiagnosis()` instead. */ define function "PrincipalDiagnosis"(Encounter Encounter ): singleton from ((Encounter.diagnosis D where D.rank = 1) PD return singleton from ([Condition] C where C.id = PD.condition.reference.getId()) ) /* @description: Returns the condition that is specified as the principal diagnosis for the encounter */ define fluent function principalDiagnosis(Encounter Encounter ): singleton from ((Encounter.diagnosis D where D.rank = 1) PD return singleton from ([Condition] C where C.id = PD.condition.reference.getId()) ) /* @description: Returns the Location resource specified by the given reference @deprecated: This function is deprecated. Use the fluent function `getLocation()` instead. */ define function "GetLocation"(reference Reference ): singleton from ( [Location] L where L.id = reference.reference.getId() ) /* @description: Returns the Location resource specified by the given reference. */ define fluent function getLocation(reference Reference ): singleton from ( [Location] L where L.id = reference.reference.getId() ) /* @description: Returns the medication code for the given MedicationRequest @deprecated: This function is deprecated. Use the fluent function `getMedicationCode()` instead. */ define function "GetMedicationCode"(request MedicationRequest ): if request.medication is Concept then request.medication as Concept else (singleton from ([Medication] M where M.id = (request.medication as Reference).reference.getId())).code /* @description: Returns the medication code for the given MedicationRequest */ define fluent function getMedicationCode(request MedicationRequest ): if request.medication is Concept then request.medication as Concept else (singleton from ([Medication] M where M.id = (request.medication as Reference).reference.getId())).code````
* Metadata: ELM XML Content
  * ?: ````Encoded data````
* Metadata: ELM JSON Content
  * ?: ````Encoded data````
* Metadata: Generated using version 0.5.3 of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Library",
  "id" : "CQMCommonExample",
  "contained" : [
    {
      "resourceType" : "Parameters",
      "id" : "options",
      "parameter" : [
        {
          "name" : "translatorVersion",
          "valueString" : "3.27.0"
        },
        {
          "name" : "option",
          "valueString" : "EnableAnnotations"
        },
        {
          "name" : "option",
          "valueString" : "EnableLocators"
        },
        {
          "name" : "option",
          "valueString" : "DisableListDemotion"
        },
        {
          "name" : "option",
          "valueString" : "DisableListPromotion"
        },
        {
          "name" : "format",
          "valueString" : "JSON"
        },
        {
          "name" : "format",
          "valueString" : "XML"
        },
        {
          "name" : "analyzeDataRequirements",
          "valueBoolean" : false
        },
        {
          "name" : "collapseDataRequirements",
          "valueBoolean" : true
        },
        {
          "name" : "compatibilityLevel",
          "valueString" : "1.5"
        },
        {
          "name" : "enableCqlOnly",
          "valueBoolean" : false
        },
        {
          "name" : "errorLevel",
          "valueString" : "Info"
        },
        {
          "name" : "signatureLevel",
          "valueString" : "Overloads"
        },
        {
          "name" : "validateUnits",
          "valueBoolean" : true
        },
        {
          "name" : "verifyOnly",
          "valueBoolean" : false
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-cqlOptions",
      "valueReference" : {
        "reference" : "#options"
      }
    }
  ],
  "url" : "http://somewhere.org/fhir/uv/mycontentig/Library/CQMCommonExample",
  "version" : "0.5.3",
  "name" : "CQMCommonExample",
  "status" : "draft",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/library-type",
        "code" : "logic-library"
      }
    ]
  },
  "date" : "2025-12-10T03:14:19+00:00",
  "publisher" : "HL7 International - [Some] Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/Special/committees/[something]"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "relatedArtifact" : [
    {
      "type" : "depends-on",
      "display" : "Library FHIRHelpers",
      "resource" : "http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1"
    },
    {
      "type" : "depends-on",
      "display" : "Library QICoreCommon",
      "resource" : "http://somewhere.org/fhir/uv/mycontentig/Library/QICoreCommonExample"
    },
    {
      "type" : "depends-on",
      "display" : "Value set Emergency Department Visit",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.292"
    },
    {
      "type" : "depends-on",
      "display" : "Value set Encounter Inpatient",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.666.5.307"
    },
    {
      "type" : "depends-on",
      "display" : "Value set Intensive Care Unit",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1029.206"
    },
    {
      "type" : "depends-on",
      "display" : "Value set Observation Services",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1111.143"
    },
    {
      "type" : "depends-on",
      "display" : "Value set Outpatient Surgery Service",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1110.38"
    },
    {
      "type" : "depends-on",
      "display" : "Value set Present on Admission or Clinically Undetermined",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1147.197"
    }
  ],
  "parameter" : [
    {
      "name" : "Measurement Period",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "type" : "Period"
    },
    {
      "name" : "Patient",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "type" : "Resource"
    },
    {
      "name" : "Inpatient Encounter",
      "use" : "out",
      "min" : 0,
      "max" : "*",
      "type" : "Resource"
    }
  ],
  "dataRequirement" : [
    {
      "type" : "Patient",
      "profile" : [
        "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
      ]
    },
    {
      "type" : "Encounter",
      "profile" : [
        "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
      ],
      "mustSupport" : [
        "type",
        "status",
        "status.value",
        "period",
        "location",
        "location.type",
        "condition",
        "condition.reference",
        "condition.reference.value",
        "rank",
        "rank.value"
      ],
      "codeFilter" : [
        {
          "path" : "type",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.666.5.307"
        }
      ]
    },
    {
      "type" : "Encounter",
      "profile" : [
        "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
      ],
      "mustSupport" : [
        "type",
        "period",
        "location",
        "location.type",
        "condition",
        "condition.reference",
        "condition.reference.value",
        "rank",
        "rank.value"
      ],
      "codeFilter" : [
        {
          "path" : "type",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1110.38"
        }
      ]
    },
    {
      "type" : "Encounter",
      "profile" : [
        "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
      ],
      "mustSupport" : [
        "type",
        "status",
        "status.value",
        "period",
        "location",
        "location.type",
        "condition",
        "condition.reference",
        "condition.reference.value",
        "rank",
        "rank.value"
      ],
      "codeFilter" : [
        {
          "path" : "type",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1111.143"
        }
      ]
    },
    {
      "type" : "Encounter",
      "profile" : [
        "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
      ],
      "mustSupport" : [
        "type",
        "status",
        "status.value",
        "period",
        "location",
        "location.type",
        "condition",
        "condition.reference",
        "condition.reference.value",
        "rank",
        "rank.value"
      ],
      "codeFilter" : [
        {
          "path" : "type",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.292"
        }
      ]
    },
    {
      "type" : "Location",
      "profile" : [
        "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-location"
      ],
      "mustSupport" : ["id", "id.value"]
    },
    {
      "type" : "Condition",
      "profile" : [
        "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition"
      ],
      "mustSupport" : ["id", "id.value"]
    },
    {
      "type" : "Medication",
      "profile" : [
        "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medication"
      ],
      "mustSupport" : ["id", "id.value"]
    }
  ],
  "content" : [
    {
      "contentType" : "text/cql",
      "data" : "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",
      "url" : "http://somewhere.org/fhir/uv/mycontentig/CQMCommonExample.cql"
    },
    {
      "contentType" : "application/elm+xml",
      "data" : "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"
    },
    {
      "contentType" : "application/elm+json",
      "data" : "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