# Questionnaire Measure Example - Your User Friendly Name for MyContentIG Here v0.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Questionnaire Measure Example**

## Measure: Questionnaire Measure Example (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://somewhere.org/fhir/uv/mycontentig/Measure/QuestionnaireMeasureExample | *Version*:0.5.3 |
| Draft as of 2025-09-29 | *Computable Name*:QuestionnaireMeasureExample |

 
Example measure illustrating a continuous variable measure calculating scores from multiple questionnaires 

* Metadata: Title
  * ?: Questionnaire Measure Example
* Metadata: Version
  * ?: 0.5.3
* Metadata: Status
  * ?: Draft
* Metadata: Experimental
  * ?: true
* Metadata: Jurisdiction
  * ?: 001 from[http://unstats.un.org/unsd/methods/m49/m49.htm](http://unstats.un.org/unsd/methods/m49/m49.htm)
* Metadata: Steward (Publisher)
  * ?: HL7 International - [Some] Work Group
* Metadata: Description
  * ?: Example measure illustrating a continuous variable measure calculating scores from multiple questionnaires
* Metadata: Measure Scoring
  * ?: Continuous Variable
* Metadata: Improvement Notation
  * ?: increase from[http://terminology.hl7.org/CodeSystem/measure-improvement-notation](http://terminology.hl7.org/7.0.0/CodeSystem-measure-improvement-notation.html)
* Metadata: Measure Type
  * ?: process from[http://terminology.hl7.org/CodeSystem/measure-type](http://terminology.hl7.org/7.0.0/CodeSystem-measure-type.html)
* Metadata: Measure Group (Rate) (ID: group-1)
* Metadata: Initial Population
  * ?: **ID**: 8A48538B-80BB-4E8B-9716-559C657278FD**Description**: No description provided**Criteria**:[Initial Population](#group-1-8A48538B-80BB-4E8B-9716-559C657278FD)
* Metadata: Measure Population
  * ?: **ID**: 8FBD6CFA-99E4-4108-B083-91067C55170E**Description**: No description provided**Criteria**:[Measure Population](#group-1-8FBD6CFA-99E4-4108-B083-91067C55170E)
* Metadata: Measure Observation
  * ?: **ID**: 8B71AD15-47EB-4939-8318-1DF60CABCFD6**Description**: No description provided**Criteria**:[MeasureObservation](#group-1-8B71AD15-47EB-4939-8318-1DF60CABCFD6)**Input Population**: 8FBD6CFA-99E4-4108-B083-91067C55170E**AggregateMethod**: average
* Metadata: Measure Logic
* Metadata: Primary Library
  * ?: [QuestionnaireMeasureExample](Library-QuestionnaireMeasureExample.md)
* Metadata: Contents
  * ?: **[Population Criteria](#population-criteria)****[Logic Definitions](#definitions)****[Terminology](#terminology)****[Dependencies](#dependencies)****[Data Requirements](#data-requirements)****[Parameters](#parameters)**
* Metadata: Population Criteria
* Metadata: Measure Group (Rate) (ID: group-1)
* Metadata: Initial Population
* Metadata: ````define "Initial Population": AgeInYearsAt(start of "Measurement Period") >= 18````[**Definition**](#questionnairemeasureexample-initial-population)
* Metadata: Measure Population
* Metadata: ````// Likely some condition or other relevant characteristic such as a depression diagnosis define "Measure Population": true````[**Definition**](#questionnairemeasureexample-measure-population)
* Metadata: Measure Observation
* Metadata: ````/* Measure observation is a function defined in terms of the types of members of the measure population, Patient in this case. In a population evaluation scenario, the measure observation is evaluated for every member of the population. In an individual report scenario, however, the measure observation is evaluated for the current patient. Note that the patient context is flowing through the call here */ define function "MeasureObservation"(patient Patient): PHQ9Logic.CalculateTotalScore````[**Definition**](#questionnairemeasureexample-measureobservation)
* Metadata: Logic Definitions
* Metadata: Logic Definition
  * ?: **Library Name:**QuestionnaireMeasureExample
* Metadata: ````define "Initial Population": AgeInYearsAt(start of "Measurement Period") >= 18````
* Metadata: Logic Definition
  * ?: **Library Name:**QuestionnaireMeasureExample
* Metadata: ````// Likely some condition or other relevant characteristic such as a depression diagnosis define "Measure Population": true````
* Metadata: Logic Definition
  * ?: **Library Name:**QuestionnaireMeasureExample
* Metadata: ````/* Measure observation is a function defined in terms of the types of members of the measure population, Patient in this case. In a population evaluation scenario, the measure observation is evaluated for every member of the population. In an individual report scenario, however, the measure observation is evaluated for the current patient. Note that the patient context is flowing through the call here */ define function "MeasureObservation"(patient Patient): PHQ9Logic.CalculateTotalScore````
* Metadata: Logic Definition
  * ?: **Library Name:**PHQ9LogicExample
* Metadata: ````// Use the QuestionnaireResponse provided as a parameter if available // Otherwise look it up from the record define "QuestionnaireResponse": if response is not null then response else Last( [QuestionnaireResponse] QR where QR.questionnaire = 'http://somewhere.org/fhir/uv/mycontentig/Questionnaire/phq-9-questionnaire' sort by (authored as FHIR.dateTime) desc )````
* Metadata: Logic Definition
  * ?: **Library Name:**PHQ9LogicExample
* Metadata: ````// NOTE: This ties this logic directly to this particular rendering of the Questionnaire. // Ideally the items would be filtered based on Code of the Item, rather than the LinkId, // but that would require pulling in the Questionnaire because the QuestionnaireResponse // only has the LinkId. define "Responses": "QuestionnaireResponse" QR return QR.item I where I.linkId in { 'LittleInterest', 'FeelingDown', 'TroubleSleeping', 'FeelingTired', 'BadApetite', 'FeelingBadAboutSelf', 'TroubleConcetrating', 'MovingSpeaking' }````
* Metadata: Logic Definition
  * ?: **Library Name:**PHQ9LogicExample
* Metadata: ````define "CalculateTotalScore": Sum("Responses" R return all AnswerCardinality(First(R.answer.value)))````
* Metadata: Logic Definition
  * ?: **Library Name:**PHQ9LogicExample
* Metadata: ````/* @source: https://www.med.umich.edu/1info/FHP/practiceguides/depress/score.pdf */ define function "AnswerCardinality"(answer Coding): case when answer ~ "Not at all" then 0 when answer ~ "Several days" then 1 when answer ~ "More than half the days" then 2 when answer ~ "Nearly every day" then 3 else null end````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````define function ToString(value uri): value.value````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````define function ToString(value string): value.value````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````define function ToCode(coding FHIR.Coding): if coding is null then null else System.Code { code: coding.code.value, system: coding.system.value, version: coding.version.value, display: coding.display.value }````
* Metadata: Terminology
* Metadata: Code System
  * ?: **Description**: Code system LOINC**Resource**:[Logical Observation Identifiers, Names and Codes (LOINC)](http://terminology.hl7.org/5.2.0/CodeSystem-v3-loinc.html)**Canonical URL**:http://loinc.org
* Metadata: Direct Reference Code
  * ?: **Code**: LA6568-5**System**:http://loinc.org
* Metadata: Direct Reference Code
  * ?: **Code**: LA6569-3**System**:http://loinc.org
* Metadata: Direct Reference Code
  * ?: **Code**: LA6570-1**System**:http://loinc.org
* Metadata: Direct Reference Code
  * ?: **Code**: LA6571-9**System**:http://loinc.org
* Metadata: Dependencies
* Metadata: Dependency
  * ?: **Description**: Library PHQ9Logic**Resource**:[PHQ9LogicExample](Library-PHQ9LogicExample.md)**Canonical URL**:http://somewhere.org/fhir/uv/mycontentig/Library/PHQ9LogicExample
* Metadata: Dependency
  * ?: **Description**: Library FHIRHelpers**Resource**:`http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1`**Canonical URL**:http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1
* Metadata: Data Requirements
* Metadata: Data Requirement
  * ?: **Type**: QuestionnaireResponse**Profile(s)**:[QuestionnaireResponse](http://hl7.org/fhir/R4/questionnaireresponse.html)**Must Support Elements**: questionnaire, item, answer
* Metadata: Data Requirement
  * ?: **Type**: Patient**Profile(s)**:[Patient](http://hl7.org/fhir/R4/patient.html)
* Metadata: Parameters
* Metadata: 
  * ?: 
| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| **Name** | **Use** | **Card.** | **Type** | **Documentation** |
| response | In | 0..1 | QuestionnaireResponse |  |
| Measurement Period | In | 0..1 | Period |  |
| Initial Population | Out | 0..1 | boolean |  |
| Measure Population | Out | 0..1 | boolean |  |

* Metadata: Generated using version 0.5.3 of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Measure",
  "id" : "QuestionnaireMeasureExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/computable-measure-cqfm"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Library",
      "id" : "effective-data-requirements",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-directReferenceCode",
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6568-5"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-directReferenceCode",
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6569-3"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-directReferenceCode",
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6570-1"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-directReferenceCode",
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6571-9"
          }
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "PHQ9LogicExample"
            },
            {
              "url" : "name",
              "valueString" : "QuestionnaireResponse"
            },
            {
              "url" : "statement",
              "valueString" : "// Use the QuestionnaireResponse provided as a parameter if available\n// Otherwise look it up from the record\ndefine \"QuestionnaireResponse\":\n  if response is not null then\n    response\n  else\n    Last(\n      [QuestionnaireResponse] QR\n        where QR.questionnaire = 'http://somewhere.org/fhir/uv/mycontentig/Questionnaire/phq-9-questionnaire'\n        sort by (authored as FHIR.dateTime) desc\n    )"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 0
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "PHQ9LogicExample"
            },
            {
              "url" : "name",
              "valueString" : "Responses"
            },
            {
              "url" : "statement",
              "valueString" : "// NOTE: This ties this logic directly to this particular rendering of the Questionnaire.\n// Ideally the items would be filtered based on Code of the Item, rather than the LinkId,\n// but that would require pulling in the Questionnaire because the QuestionnaireResponse\n// only has the LinkId.\ndefine \"Responses\":\n  \"QuestionnaireResponse\" QR\n    return QR.item I where I.linkId in {\n      'LittleInterest',\n      'FeelingDown',\n      'TroubleSleeping',\n      'FeelingTired',\n      'BadApetite',\n      'FeelingBadAboutSelf',\n      'TroubleConcetrating',\n      'MovingSpeaking'\n    }"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 1
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "PHQ9LogicExample"
            },
            {
              "url" : "name",
              "valueString" : "CalculateTotalScore"
            },
            {
              "url" : "statement",
              "valueString" : "define \"CalculateTotalScore\":\n  Sum(\"Responses\" R return all AnswerCardinality(First(R.answer.value)))"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 2
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "QuestionnaireMeasureExample"
            },
            {
              "url" : "name",
              "valueString" : "Initial Population"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Initial Population\":\n  AgeInYearsAt(start of \"Measurement Period\") >= 18"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 3
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "QuestionnaireMeasureExample"
            },
            {
              "url" : "name",
              "valueString" : "Measure Population"
            },
            {
              "url" : "statement",
              "valueString" : "// Likely some condition or other relevant characteristic such as a depression diagnosis\ndefine \"Measure Population\":\n  true"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 4
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "QuestionnaireMeasureExample"
            },
            {
              "url" : "name",
              "valueString" : "MeasureObservation"
            },
            {
              "url" : "statement",
              "valueString" : "/*\nMeasure observation is a function defined in terms of the types of members of the measure\npopulation, Patient in this case. In a population evaluation scenario, the measure\nobservation is evaluated for every member of the population.\n\nIn an individual report scenario, however, the measure observation is evaluated for\nthe current patient. Note that the patient context is flowing through the call here\n*/\ndefine function \"MeasureObservation\"(patient Patient):\n  PHQ9Logic.CalculateTotalScore"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 5
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToString"
            },
            {
              "url" : "statement",
              "valueString" : "define function ToString(value uri): value.value"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 6
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToString"
            },
            {
              "url" : "statement",
              "valueString" : "define function ToString(value string): value.value"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 7
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "PHQ9LogicExample"
            },
            {
              "url" : "name",
              "valueString" : "AnswerCardinality"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@source: https://www.med.umich.edu/1info/FHP/practiceguides/depress/score.pdf\n*/\ndefine function \"AnswerCardinality\"(answer Coding):\n  case\n    when answer ~ \"Not at all\" then 0\n    when answer ~ \"Several days\" then 1\n    when answer ~ \"More than half the days\" then 2\n    when answer ~ \"Nearly every day\" then 3\n    else null\n  end"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 8
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToCode"
            },
            {
              "url" : "statement",
              "valueString" : "define function ToCode(coding FHIR.Coding):\n    if coding is null then\n        null\n    else\n        System.Code {\n          code: coding.code.value,\n          system: coding.system.value,\n          version: coding.version.value,\n          display: coding.display.value\n        }"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 9
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        }
      ],
      "name" : "EffectiveDataRequirements",
      "status" : "active",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/library-type",
            "code" : "module-definition"
          }
        ]
      },
      "relatedArtifact" : [
        {
          "type" : "depends-on",
          "display" : "Library PHQ9Logic",
          "resource" : "http://somewhere.org/fhir/uv/mycontentig/Library/PHQ9LogicExample"
        },
        {
          "type" : "depends-on",
          "display" : "Library FHIRHelpers",
          "resource" : "http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1"
        },
        {
          "type" : "depends-on",
          "display" : "Code system LOINC",
          "resource" : "http://loinc.org"
        }
      ],
      "parameter" : [
        {
          "name" : "response",
          "use" : "in",
          "min" : 0,
          "max" : "1",
          "type" : "QuestionnaireResponse"
        },
        {
          "name" : "Measurement Period",
          "use" : "in",
          "min" : 0,
          "max" : "1",
          "type" : "Period"
        },
        {
          "name" : "Initial Population",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "boolean"
        },
        {
          "name" : "Measure Population",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "boolean"
        }
      ],
      "dataRequirement" : [
        {
          "type" : "QuestionnaireResponse",
          "profile" : [
            "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse"
          ],
          "mustSupport" : ["questionnaire", "item", "answer"]
        },
        {
          "type" : "Patient",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Patient"]
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-softwaresystem",
      "valueReference" : {
        "reference" : "Device/cqf-tooling"
      }
    },
    {
      "url" : "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-effectiveDataRequirements",
      "valueCanonical" : "#effective-data-requirements"
    }
  ],
  "url" : "http://somewhere.org/fhir/uv/mycontentig/Measure/QuestionnaireMeasureExample",
  "version" : "0.5.3",
  "name" : "QuestionnaireMeasureExample",
  "title" : "Questionnaire Measure Example",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-09-29T21:16:55-07:00",
  "publisher" : "HL7 International - [Some] Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/Special/committees/[something]"
        }
      ]
    }
  ],
  "description" : "Example measure illustrating a continuous variable measure calculating scores from multiple questionnaires",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "library" : [
    "http://somewhere.org/fhir/uv/mycontentig/Library/QuestionnaireMeasureExample"
  ],
  "scoring" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/measure-scoring",
        "code" : "continuous-variable",
        "display" : "Continuous Variable"
      }
    ]
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/measure-type",
          "code" : "process"
        }
      ]
    }
  ],
  "improvementNotation" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/measure-improvement-notation",
        "code" : "increase"
      }
    ]
  },
  "group" : [
    {
      "id" : "group-1",
      "population" : [
        {
          "id" : "8A48538B-80BB-4E8B-9716-559C657278FD",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "initial-population",
                "display" : "Initial Population"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Initial Population"
          }
        },
        {
          "id" : "8FBD6CFA-99E4-4108-B083-91067C55170E",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "measure-population",
                "display" : "Measure Population"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Measure Population"
          }
        },
        {
          "id" : "8B71AD15-47EB-4939-8318-1DF60CABCFD6",
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-aggregateMethod",
              "valueCode" : "average"
            },
            {
              "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-criteriaReference",
              "valueString" : "8FBD6CFA-99E4-4108-B083-91067C55170E"
            }
          ],
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "measure-observation",
                "display" : "Measure Observation"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "MeasureObservation"
          }
        }
      ]
    }
  ]
}

```
