# HR Example CV (Measure Name in Details Tab of MADiE UI) - Your User Friendly Name for MyContentIG Here v0.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HR Example CV (Measure Name in Details Tab of MADiE UI)**

## Measure: HR Example CV (Measure Name in Details Tab of MADiE UI) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://somewhere.org/fhir/uv/mycontentig/Measure/HRExampleCVMeasure | *Version*:0.5.3 |
| Draft as of 2025-09-30 | *Computable Name*:HRExampleCVMeasure |
| *Other Identifiers:*Short Name: HRExCV(eCQM Abbreviated Title)DT (use: usual, ), UUID:69cbf966-a8a7-4c0a-8970-b22e45d75cf3 (use: official, ), UUID:f93267bf-fa94-477f-ad0a-22376ffa122e (use: official, ), Endorser: 4EndorsementNumber (use: official, ) | |
| **Usage:**Venue: EH | |
| **Copyright/Legal**:**Copyright Section of Details Tab in MADiE UI*** Free text.
* Character limit not determined.
**Displays “UNKNOWN” if not populated.****QDM Equivalent: Copyright** | |

 
**Description Section of Details Tab in MADiE UI** 
* Free text.
* Character limit not determined.
 
**QDM equivalent: Description** 

 
**Purpose Section of Details Tab in MADiE UI** 
* Free text.
* Character limit not determined.
 
**Conditional field, will not display if not populated.** 
**QDM Equivalent: N/A** 

* Metadata: Title
  * ?: HR Example CV (Measure Name in Details Tab of MADiE UI)
* Metadata: Version
  * ?: 0.5.3
* Metadata: Short Name
  * ?: HRExCV(eCQM Abbreviated Title)DT
* Metadata: GUID (Version Independent)
  * ?: urn:uuid:69cbf966-a8a7-4c0a-8970-b22e45d75cf3
* Metadata: GUID (Version Specific)
  * ?: urn:uuid:f93267bf-fa94-477f-ad0a-22376ffa122e
* Metadata: CMS Consensus Based Entity Identifier
  * ?: 4EndorsementNumber
* Metadata: Effective Period
  * ?: 2026-01-01 through 2026-12-31
* Metadata: Status
  * ?: Draft
* Metadata: Experimental
  * ?: true
* Metadata: Use Context
  * ?: Venue = EH
* Metadata: Jurisdiction
  * ?: 001 from[http://unstats.un.org/unsd/methods/m49/m49.htm](http://unstats.un.org/unsd/methods/m49/m49.htm)
* Metadata: Steward (Publisher)
  * ?: HL7 International - [Some] Work Group
* Metadata: Developer
  * ?: ICF
* Metadata: Description
  * ?: **Description Section of Details Tab in MADiE UI*** Free text.
* Character limit not determined.
**QDM equivalent: Description**
* Metadata: Purpose
  * ?: **Purpose Section of Details Tab in MADiE UI*** Free text.
* Character limit not determined.
**Conditional field, will not display if not populated.****QDM Equivalent: N/A**
* Metadata: Copyright
  * ?: **Copyright Section of Details Tab in MADiE UI*** Free text.
* Character limit not determined.
**Displays "UNKNOWN" if not populated.****QDM Equivalent: Copyright**
* Metadata: Disclaimer
  * ?: **Disclaimer Section of Details Tab in MADiE UI*** Free text.
* Character limit not determined.
**Displays "UNKNOWN" if not populated.****QDM Equivalent: Disclaimer**
* Metadata: Rationale
  * ?: **Rationale Section of Details Tab in MADiE UI*** Free text.
* Character limit not determined.
**Conditional field, will not display if not populated.****QDM Equivalent: Rationale**
* Metadata: Clinical Recommendation Statement
  * ?: **Clinical Recommendation Section of Details Tab in MADiE UI*** Free text.
* Character limit not determined.
**Conditional field, will not display if not populated.****QDM Equivalent: Clinical Recommendation Statement**
* Metadata: Citation
  * ?: **CITATION References Section of Details Tab in MADiE UI*** Type" selected from drop down (Citation or Justification)
* Reference" free text after selection.
* Character limit not determined.
**Conditional field, will not display if not populated.****QDM Equivalent: Reference**
* Metadata: Justification
  * ?: **Description**: **JUSTIFICATION References Section of Details Tab in MADiE UI** * "Type" selected from drop down (Citation or Justification) * "Reference" free text after selection. * Character limit not determined. *Conditional field, will not display if not populated.* **QDM Equivalent: Reference**
* Metadata: Definition
  * ?: Definition Section of Details Tab in MADiE UI "Term" free text. Character limit not determined. QDM Equivalent: ?.: **Definition Section of Details Tab in MADiE UI** * "Definition" free text. * Character limit not determined *Conditional field, will not display if not populated.* **QDM Equivalent: Definition**
* Metadata: Guidance (Usage)
  * ?: **Guidance (Usage) Section of Details Tab in MADiE UI** * Free text. * Character limit not determined. *Conditional field, will not display if not populated.* **QDM Equivalent: Guidance**
* Metadata: Measure Group (Rate) (ID: Group_1)
* Metadata: Summary
  * ?: **Population Criteria 1 Description on Population Criteria Tab of MADiE UI** * Free text. * Character limit not determined. **QDM Equivalent: N/A** **Populates Summary Field in FHIR human readable** | Additional MADiE Page Notes: | |-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | * Measure type selectable from drop down, multi select; for this example selected all options. | | * Population Basis selectable from drop down, single select; for this example, boolean is only one that didn't generate an error. | | * Scoring selectable from dropdown, single select (Cohort, Continuous Variable, Proportion and Ratio). *Note to self, changing scoring deletes all population information.* | | * Aggregate Function selectable from dropdown. | | * Scoring Unit free text entry. | | * Scoring Precision selectable integers. |
* Metadata: Basis
  * ?: boolean
* Metadata: Scoring
  * ?: Continuous Variable
* Metadata: Scoring Unit
  * ?: Scoring Unit Field
* Metadata: Scoring Precision
  * ?: 1
* Metadata: Improvement Notation
  * ?: Increased score indicates improvement
* Metadata: Improvement Notation Guidance
  * ?: **Improvement Notation Description Field of Reporting Section on Population Criteria Tab of MADiE UI*** Free text.
* Character limit not determined.
* Improvement Notation required field selected by dropdown (Increased score indicates improvement and Decreased score indicates improvement).
**QDM Equivalent: Improvement Notation**
* Metadata: Type
  * ?: Intermediate Outcome
* Metadata: Type
  * ?: Outcome
* Metadata: Type
  * ?: Patient Reported Outcome
* Metadata: Type
  * ?: Process
* Metadata: Type
  * ?: Structure
* Metadata: Initial Population
  * ?: **ID**: InitialPopulation_1**Description**:**Initial Population Description Field in Population Criteria Tab of MADiE UI** * Free text. * Character limit not determined. * Initial Population required field selected by dropdown (Defines from CQL Editor Tab). **QDM Equivalent: Initial Population****Criteria**:[Initial Population](#Group_1-InitialPopulation_1)
* Metadata: Measure Population
  * ?: **ID**: MeasurePopulation_1**Description**:**Measure Population Description Field in Population Criteria Tab of MADiE UI** * Free text. * Character limit not determined. * Measure Population required field selected by dropdown (Defines from CQL Editor Tab). **QDM Equivalent: Measure Population****Criteria**:[Measure Population](#Group_1-MeasurePopulation_1)
* Metadata: Measure Population Exclusion
  * ?: **ID**: MeasurePopulationExclusion_1**Description**:**Measure Population Exclusion Description Field in Population Criteria Tab of MADiE UI** * Free text. * Character limit not determined. * Numerator Exclusion is not required field selected by dropdown (Defines from CQL Editor Tab). *Conditional field, will not display if not populated.* **QDM Equivalent: Measure Population Exclusions****Criteria**:[Measure Population Exclusions](#Group_1-MeasurePopulationExclusion_1)
* Metadata: Measure Observation
  * ?: **ID**: MeasureObservation_1**Description**:**Measure Observation Description Field in Population Criteria Tab of MADiE UI** * Free text. * Character limit not determined. * Measure Observation required field selected by dropdown (Defines from CQL Editor Tab). **QDM Equivalent: Measure Observation****Criteria**:[Measure Observation 1](#Group_1-MeasureObservation_1)**Input Population**: MeasurePopulation_1**AggregateMethod**: Sum
* Metadata: Supplemental Data Guidance Guidance
  * ?: <p><strong>Supplemental Data Section of Population Criteria Tab of MADiE UI </strong></p> <ul> <li><p>Free text.</p></li> <li><p>Character limit not determined.</p></li> <li><p>Definition selected from dropdown (Defines in CQL Editor).</p></li> <li><p>For this example, selected SDE Payer, SDE Ethnicity, SDE Race and SDE Sex.</p></li> <li><p>Appears to default to Individual, Subject List, Summary and Data Collection for Include in Report Type.</p></li> </ul> <p><em>Conditional field, will not display if not populated. </em></p> <p><strong>QDM Equivalent: Supplemental Data Elements</strong></p> <p><strong>Populates Supplemental Data Guidance in FHIR human readable</strong></p>
* Metadata: Risk Adjustment Variable Guidance Guidance
  * ?: <p><strong>Risk Adjustment Section of Population Criteria Tab of MADiE UI </strong></p> <ul> <li><p>Free text.</p></li> <li><p>Character limit not determined.</p></li> <li><p>Definition selected from dropdown, multi select (Defines in CQL Editor).</p></li> <li><p>Appears to default to Individual, Subject List, Summary and Data Collection for Include in Report Type.</p></li> </ul> <p><em>Conditional field, will not display if not populated.</em></p> <p><strong>QDM Equivalent: Risk Adjustment</strong></p>
* Metadata: Supplemental Data Elements
* Metadata: Supplemental Data Element
  * ?: **ID**: sde-ethnicity**Usage Code**:Supplemental Data**Description**: SDE Ethnicity**Logic Definition**:[SDE Ethnicity](#hrexamplecvmeasurecqllibrary-sde-ethnicity)
* Metadata: Supplemental Data Element
  * ?: **ID**: sde-payer**Usage Code**:Supplemental Data**Description**: SDE Payer**Logic Definition**:[SDE Payer](#hrexamplecvmeasurecqllibrary-sde-payer)
* Metadata: Supplemental Data Element
  * ?: **ID**: sde-race**Usage Code**:Supplemental Data**Description**: SDE Race**Logic Definition**:[SDE Race](#hrexamplecvmeasurecqllibrary-sde-race)
* Metadata: Supplemental Data Element
  * ?: **ID**: sde-sex**Usage Code**:Supplemental Data**Description**: SDE Sex**Logic Definition**:[SDE Sex](#hrexamplecvmeasurecqllibrary-sde-sex)
* Metadata: Supplemental Data Element
  * ?: **ID**: rav-patient-too-young-at-start-of-measurement-period**Usage Code**:Risk Adjustment Factor**Description**: RAV Patient Too Young at Start of Measurement Period**Logic Definition**:[RAV Patient Too Young at Start of Measurement Period](#hrexamplecvmeasurecqllibrary-rav-patient-too-young-at-start-of-measurement-period)
* Metadata: Measure Logic
* Metadata: Primary Library
  * ?: [HRExampleCVMeasureCQLLibrary](Library-HRExampleCVMeasureCQLLibrary.md)
* Metadata: Contents
  * ?: **[Population Criteria](#population-criteria)****[Logic Definitions](#definitions)****[Terminology](#terminology)****[Dependencies](#dependencies)****[Data Requirements](#data-requirements)****[Parameters](#parameters)**
* Metadata: Population Criteria
* Metadata: Measure Group (Rate) (ID: Group_1)
* Metadata: Initial Population
* Metadata: ````define "Initial Population": AgeInYearsAt(date from end of "Measurement Period" ) in Interval[18, 75]````[**Definition**](#hrexamplecvmeasurecqllibrary-initial-population)
* Metadata: Measure Population
* Metadata: ````define "Measure Population": "Initial Population"````[**Definition**](#hrexamplecvmeasurecqllibrary-measure-population)
* Metadata: Measure Population Exclusion
* Metadata: ````define "Measure Population Exclusions": "Initial Population"````[**Definition**](#hrexamplecvmeasurecqllibrary-measure-population-exclusions)
* Metadata: Measure Observation
* Metadata: ````define function "Measure Observation 1"(): if AgeInYearsAt(date from start of "Measurement Period") >= 18 then 1 else 0````[**Definition**](#hrexamplecvmeasurecqllibrary-measure-observation-1)
* Metadata: Logic Definitions
* Metadata: Logic Definition
  * ?: **Library Name:**SupplementalDataElementsExample
* Metadata: ````define "SDE Sex": case when Patient.gender = 'male' then Code { code: 'M', system: 'http://hl7.org/fhir/v3/AdministrativeGender', display: 'Male' } when Patient.gender = 'female' then Code { code: 'F', system: 'http://hl7.org/fhir/v3/AdministrativeGender', display: 'Female' } else null end````
* Metadata: Logic Definition
  * ?: **Library Name:**SupplementalDataElementsExample
* Metadata: ````define "SDE Payer": [Coverage: type in "Payer Type"] Payer return { code: Payer.type, period: Payer.period }````
* Metadata: Logic Definition
  * ?: **Library Name:**SupplementalDataElementsExample
* Metadata: ````define "SDE Ethnicity": Patient.ethnicity E return Tuple { codes: { E.ombCategory } union E.detailed, display: E.text }````
* Metadata: Logic Definition
  * ?: **Library Name:**SupplementalDataElementsExample
* Metadata: ````define "SDE Race": Patient.race R return Tuple { codes: R.ombCategory union R.detailed, display: R.text }````
* Metadata: Logic Definition
  * ?: **Library Name:**HRExampleCVMeasureCQLLibrary
* Metadata: ````define "SDE Sex": SDE."SDE Sex"````
* Metadata: Logic Definition
  * ?: **Library Name:**HRExampleCVMeasureCQLLibrary
* Metadata: ````define "RAV Patient Too Young at Start of Measurement Period": AgeInYearsAt(date from start of "Measurement Period") < 5````
* Metadata: Logic Definition
  * ?: **Library Name:**HRExampleCVMeasureCQLLibrary
* Metadata: ````define "Initial Population": AgeInYearsAt(date from end of "Measurement Period" ) in Interval[18, 75]````
* Metadata: Logic Definition
  * ?: **Library Name:**HRExampleCVMeasureCQLLibrary
* Metadata: ````define "Measure Population Exclusions": "Initial Population"````
* Metadata: Logic Definition
  * ?: **Library Name:**HRExampleCVMeasureCQLLibrary
* Metadata: ````define "SDE Payer": SDE."SDE Payer"````
* Metadata: Logic Definition
  * ?: **Library Name:**HRExampleCVMeasureCQLLibrary
* Metadata: ````define "SDE Ethnicity": SDE."SDE Ethnicity"````
* Metadata: Logic Definition
  * ?: **Library Name:**HRExampleCVMeasureCQLLibrary
* Metadata: ````define "SDE Race": SDE."SDE Race"````
* Metadata: Logic Definition
  * ?: **Library Name:**HRExampleCVMeasureCQLLibrary
* Metadata: ````define "Measure Population": "Initial Population"````
* Metadata: Logic Definition
  * ?: **Library Name:**HRExampleCVMeasureCQLLibrary
* Metadata: ````define function "Measure Observation 1"(): if AgeInYearsAt(date from start of "Measurement Period") >= 18 then 1 else 0````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````define function ToInterval(period FHIR.Period): if period is null then null else if period."start" is null then Interval(period."start".value, period."end".value] else Interval[period."start".value, period."end".value]````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````define function ToString(value uri): value.value````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````define function ToCode(coding FHIR.Coding): if coding is null then null else System.Code { code: coding.code.value, system: coding.system.value, version: coding.version.value, display: coding.display.value }````
* Metadata: Terminology
* Metadata: Value Set
  * ?: **Description**: Value set Payer Type**Resource**:[Payer](https://vsac.nlm.nih.gov/valueset/2.16.840.1.114222.4.11.3591/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.3591
* Metadata: Dependencies
* Metadata: Dependency
  * ?: **Description**: Library SDE**Resource**:[SupplementalDataElementsExample](Library-SupplementalDataElementsExample.md)**Canonical URL**:http://somewhere.org/fhir/uv/mycontentig/Library/SupplementalDataElementsExample
* Metadata: Dependency
  * ?: **Description**: Library FHIRHelpers**Resource**:`http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1`**Canonical URL**:http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1
* Metadata: Data Requirements
* Metadata: Data Requirement
  * ?: **Type**: Patient**Profile(s)**:[QICore Patient](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-patient.html)**Must Support Elements**: url, extension
* Metadata: Data Requirement
  * ?: **Type**: Coverage**Profile(s)**:[QICore Coverage](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-coverage.html)**Must Support Elements**: type, period**Code Filter(s)**:**Path**: type**ValueSet**:[Payer](https://vsac.nlm.nih.gov/valueset/2.16.840.1.114222.4.11.3591/expansion)
* Metadata: Parameters
* Metadata: 
  * ?: 
| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| **Name** | **Use** | **Card.** | **Type** | **Documentation** |
| Measurement Period | In | 0..1 | Period |  |
| SDE Sex | Out | 0..1 | Coding |  |
| RAV Patient Too Young at Start of Measurement Period | Out | 0..1 | boolean |  |
| Measure Population Exclusions | Out | 0..1 | boolean |  |
| SDE Payer | Out | 0..* | Resource |  |
| Initial Population | Out | 0..1 | boolean |  |
| SDE Ethnicity | Out | 0..1 | Resource |  |
| SDE Race | Out | 0..1 | Resource |  |
| Measure Population | Out | 0..1 | boolean |  |

* Metadata: Generated using version 0.5.3 of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Measure",
  "id" : "HRExampleCVMeasure",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-shareablemeasure",
      "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/computable-measure-cqfm",
      "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/publishable-measure-cqfm",
      "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/executable-measure-cqfm",
      "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cql-measure-cqfm",
      "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/elm-measure-cqfm",
      "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cv-measure-cqfm"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Library",
      "id" : "effective-data-requirements",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupplementalDataElementsExample"
            },
            {
              "url" : "name",
              "valueString" : "SDE Sex"
            },
            {
              "url" : "statement",
              "valueString" : "define \"SDE Sex\":\n  case\n      when Patient.gender = 'male' then Code { code: 'M', system: 'http://hl7.org/fhir/v3/AdministrativeGender', display: 'Male' }\n      when Patient.gender = 'female' then Code { code: 'F', system: 'http://hl7.org/fhir/v3/AdministrativeGender', display: 'Female' }\n      else null\n    end"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 0
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "HRExampleCVMeasureCQLLibrary"
            },
            {
              "url" : "name",
              "valueString" : "SDE Sex"
            },
            {
              "url" : "statement",
              "valueString" : "define \"SDE Sex\":\n  SDE.\"SDE Sex\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 1
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "HRExampleCVMeasureCQLLibrary"
            },
            {
              "url" : "name",
              "valueString" : "RAV Patient Too Young at Start of Measurement Period"
            },
            {
              "url" : "statement",
              "valueString" : "define \"RAV Patient Too Young at Start of Measurement Period\":\n  AgeInYearsAt(date from start of \"Measurement Period\") < 5"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 2
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "HRExampleCVMeasureCQLLibrary"
            },
            {
              "url" : "name",
              "valueString" : "Initial Population"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Initial Population\":\n  AgeInYearsAt(date from \n    end of \"Measurement Period\"\n  ) in Interval[18, 75]"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 3
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "HRExampleCVMeasureCQLLibrary"
            },
            {
              "url" : "name",
              "valueString" : "Measure Population Exclusions"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Measure Population Exclusions\":\n  \"Initial Population\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 4
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupplementalDataElementsExample"
            },
            {
              "url" : "name",
              "valueString" : "SDE Payer"
            },
            {
              "url" : "statement",
              "valueString" : "define \"SDE Payer\":\n  [Coverage: type in \"Payer Type\"] Payer\n    return {\n      code: Payer.type,\n      period: Payer.period\n    }"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 5
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "HRExampleCVMeasureCQLLibrary"
            },
            {
              "url" : "name",
              "valueString" : "SDE Payer"
            },
            {
              "url" : "statement",
              "valueString" : "define \"SDE Payer\":\n  SDE.\"SDE Payer\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 6
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupplementalDataElementsExample"
            },
            {
              "url" : "name",
              "valueString" : "SDE Ethnicity"
            },
            {
              "url" : "statement",
              "valueString" : "define \"SDE Ethnicity\":\n  Patient.ethnicity E\n    return Tuple {\n      codes: { E.ombCategory } union E.detailed,\n      display: E.text\n    }"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 7
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "HRExampleCVMeasureCQLLibrary"
            },
            {
              "url" : "name",
              "valueString" : "SDE Ethnicity"
            },
            {
              "url" : "statement",
              "valueString" : "define \"SDE Ethnicity\":\n  SDE.\"SDE Ethnicity\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 8
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupplementalDataElementsExample"
            },
            {
              "url" : "name",
              "valueString" : "SDE Race"
            },
            {
              "url" : "statement",
              "valueString" : "define \"SDE Race\":\n  Patient.race R\n    return Tuple {\n      codes: R.ombCategory union R.detailed,\n      display: R.text\n    }"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 9
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "HRExampleCVMeasureCQLLibrary"
            },
            {
              "url" : "name",
              "valueString" : "SDE Race"
            },
            {
              "url" : "statement",
              "valueString" : "define \"SDE Race\":\n  SDE.\"SDE Race\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 10
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "HRExampleCVMeasureCQLLibrary"
            },
            {
              "url" : "name",
              "valueString" : "Measure Population"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Measure Population\":\n  \"Initial Population\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 11
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "HRExampleCVMeasureCQLLibrary"
            },
            {
              "url" : "name",
              "valueString" : "Measure Observation 1"
            },
            {
              "url" : "statement",
              "valueString" : "define function \"Measure Observation 1\"():\n  if AgeInYearsAt(date from start of \"Measurement Period\") >= 18 then 1 \n    else 0"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 12
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToInterval"
            },
            {
              "url" : "statement",
              "valueString" : "define function ToInterval(period FHIR.Period):\n    if period is null then\n        null\n    else\n        if period.\"start\" is null then\n            Interval(period.\"start\".value, period.\"end\".value]\n        else\n            Interval[period.\"start\".value, period.\"end\".value]"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 13
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToString"
            },
            {
              "url" : "statement",
              "valueString" : "define function ToString(value uri): value.value"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 14
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToCode"
            },
            {
              "url" : "statement",
              "valueString" : "define function ToCode(coding FHIR.Coding):\n    if coding is null then\n        null\n    else\n        System.Code {\n          code: coding.code.value,\n          system: coding.system.value,\n          version: coding.version.value,\n          display: coding.display.value\n        }"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 15
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        }
      ],
      "name" : "EffectiveDataRequirements",
      "status" : "active",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/library-type",
            "code" : "module-definition"
          }
        ]
      },
      "relatedArtifact" : [
        {
          "type" : "depends-on",
          "display" : "Library SDE",
          "resource" : "http://somewhere.org/fhir/uv/mycontentig/Library/SupplementalDataElementsExample"
        },
        {
          "type" : "depends-on",
          "display" : "Library FHIRHelpers",
          "resource" : "http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Payer Type",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.3591"
        }
      ],
      "parameter" : [
        {
          "name" : "Measurement Period",
          "use" : "in",
          "min" : 0,
          "max" : "1",
          "type" : "Period"
        },
        {
          "name" : "SDE Sex",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "Coding"
        },
        {
          "name" : "RAV Patient Too Young at Start of Measurement Period",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "boolean"
        },
        {
          "name" : "Measure Population Exclusions",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "boolean"
        },
        {
          "name" : "SDE Payer",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "type" : "Resource"
        },
        {
          "name" : "Initial Population",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "boolean"
        },
        {
          "name" : "SDE Ethnicity",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "Resource"
        },
        {
          "name" : "SDE Race",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "Resource"
        },
        {
          "name" : "Measure Population",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "boolean"
        }
      ],
      "dataRequirement" : [
        {
          "type" : "Patient",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
          ],
          "mustSupport" : ["url", "extension"]
        },
        {
          "type" : "Coverage",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-coverage"
          ],
          "mustSupport" : ["type", "period"],
          "codeFilter" : [
            {
              "path" : "type",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.3591"
            }
          ]
        }
      ]
    }
  ],
  "extension" : [
    {
      "id" : "supplementalDataGuidance",
      "extension" : [
        {
          "url" : "guidance",
          "valueString" : "<p><strong>Supplemental Data Section of Population Criteria Tab of MADiE UI </strong></p>\n<ul>\n <li><p>Free text.</p></li>\n <li><p>Character limit not determined.</p></li>\n <li><p>Definition selected from dropdown (Defines in CQL Editor).</p></li>\n <li><p>For this example, selected SDE Payer, SDE Ethnicity, SDE Race and SDE Sex.</p></li>\n <li><p>Appears to default to Individual, Subject List, Summary and Data Collection for Include in Report Type.</p></li>\n</ul>\n<p><em>Conditional field, will not display if not populated. </em></p>\n<p><strong>QDM Equivalent: Supplemental Data Elements</strong></p>\n<p><strong>Populates Supplemental Data Guidance in FHIR human readable</strong></p>"
        },
        {
          "url" : "usage",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-data-usage",
                "code" : "supplemental-data",
                "display" : "Supplemental Data"
              }
            ],
            "text" : "Supplemental Data Guidance"
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-supplementalDataGuidance"
    },
    {
      "id" : "riskAdjustmentVariableGuidance",
      "extension" : [
        {
          "url" : "guidance",
          "valueString" : "<p><strong>Risk Adjustment Section of Population Criteria Tab of MADiE UI </strong></p>\n<ul>\n <li><p>Free text.</p></li>\n <li><p>Character limit not determined.</p></li>\n <li><p>Definition selected from dropdown, multi select (Defines in CQL Editor).</p></li>\n <li><p>Appears to default to Individual, Subject List, Summary and Data Collection for Include in Report Type.</p></li>\n</ul>\n<p><em>Conditional field, will not display if not populated.</em></p>\n<p><strong>QDM Equivalent: Risk Adjustment</strong></p>"
        },
        {
          "url" : "usage",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-data-usage",
                "code" : "risk-adjustment-factor",
                "display" : "Risk Adjustment Factor"
              }
            ],
            "text" : "Risk Adjustment Variable Guidance"
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-supplementalDataGuidance"
    },
    {
      "extension" : [
        {
          "url" : "term",
          "valueString" : "Definition Section of Details Tab in MADiE UI \"Term\" free text. Character limit not determined. QDM Equivalent: ?."
        },
        {
          "url" : "definition",
          "valueMarkdown" : "**Definition Section of Details Tab in MADiE UI**\n\n* \"Definition\" free text.\n\n* Character limit not determined\n\n*Conditional field, will not display if not populated.*\n\n**QDM Equivalent: Definition**"
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-definitionTerm"
    },
    {
      "url" : "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-effectiveDataRequirements",
      "valueCanonical" : "#effective-data-requirements"
    },
    {
      "url" : "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-softwaresystem",
      "valueReference" : {
        "reference" : "Device/cqf-tooling"
      }
    }
  ],
  "url" : "http://somewhere.org/fhir/uv/mycontentig/Measure/HRExampleCVMeasure",
  "identifier" : [
    {
      "use" : "usual",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/artifact-identifier-type",
            "code" : "short-name",
            "display" : "Short Name"
          }
        ]
      },
      "system" : "https://madie.cms.gov/measure/shortName",
      "value" : "HRExCV(eCQM Abbreviated Title)DT"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/artifact-identifier-type",
            "code" : "version-independent",
            "display" : "Version Independent"
          }
        ]
      },
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:uuid:69cbf966-a8a7-4c0a-8970-b22e45d75cf3"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/artifact-identifier-type",
            "code" : "version-specific",
            "display" : "Version Specific"
          }
        ]
      },
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:uuid:f93267bf-fa94-477f-ad0a-22376ffa122e"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/artifact-identifier-type",
            "code" : "endorser",
            "display" : "Endorser"
          }
        ]
      },
      "system" : "https://madie.cms.gov/measure/cbeId",
      "value" : "4EndorsementNumber",
      "assigner" : {
        "display" : "CMS Consensus Based Entity"
      }
    }
  ],
  "version" : "0.5.3",
  "name" : "HRExampleCVMeasure",
  "title" : "HR Example CV (Measure Name in Details Tab of MADiE UI)",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-09-30T04:16:55+00:00",
  "publisher" : "HL7 International - [Some] Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/Special/committees/[something]"
        }
      ]
    }
  ],
  "description" : "**Description Section of Details Tab in MADiE UI**\n\n* Free text.\n\n* Character limit not determined.\n\n**QDM equivalent: Description**",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "venue",
        "display" : "Venue"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/cqfmeasures/CodeSystem/intended-venue-codes",
            "code" : "eh",
            "display" : "EH"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "purpose" : "**Purpose Section of Details Tab in MADiE UI**\n\n* Free text.\n\n* Character limit not determined.\n\n*Conditional field, will not display if not populated.*\n\n**QDM Equivalent: N/A**",
  "usage" : "**Guidance (Usage) Section of Details Tab in MADiE UI**\n\n* Free text.\n\n* Character limit not determined.\n\n*Conditional field, will not display if not populated.*\n\n**QDM Equivalent: Guidance**",
  "copyright" : "**Copyright Section of Details Tab in MADiE UI**\n\n* Free text.\n\n* Character limit not determined.\n\n*Displays \"UNKNOWN\" if not populated.*\n\n**QDM Equivalent: Copyright**",
  "effectivePeriod" : {
    "start" : "2026-01-01",
    "end" : "2026-12-31"
  },
  "author" : [
    {
      "name" : "ICF",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.icf.com/"
        }
      ]
    }
  ],
  "relatedArtifact" : [
    {
      "type" : "citation",
      "citation" : "**CITATION References Section of Details Tab in MADiE UI**\n\n* Type\" selected from drop down (Citation or Justification)\n\n* Reference\" free text after selection.\n\n* Character limit not determined.\n\n*Conditional field, will not display if not populated.*\n\n**QDM Equivalent: Reference**"
    },
    {
      "type" : "justification",
      "display" : "**JUSTIFICATION References Section of Details Tab in MADiE UI**\n\n* \"Type\" selected from drop down (Citation or Justification)\n\n* \"Reference\" free text after selection.\n\n* Character limit not determined.\n\n*Conditional field, will not display if not populated.*\n\n**QDM Equivalent: Reference**"
    }
  ],
  "library" : [
    "http://somewhere.org/fhir/uv/mycontentig/Library/HRExampleCVMeasureCQLLibrary"
  ],
  "disclaimer" : "**Disclaimer Section of Details Tab in MADiE UI**\n\n* Free text.\n\n* Character limit not determined.\n\n*Displays \"UNKNOWN\" if not populated.*\n\n**QDM Equivalent: Disclaimer**",
  "rationale" : "**Rationale Section of Details Tab in MADiE UI**\n\n* Free text.\n\n* Character limit not determined.\n\n*Conditional field, will not display if not populated.*\n\n**QDM Equivalent: Rationale**",
  "clinicalRecommendationStatement" : "**Clinical Recommendation Section of Details Tab in MADiE UI**\n\n* Free text.\n\n* Character limit not determined.\n\n*Conditional field, will not display if not populated.*\n\n**QDM Equivalent: Clinical Recommendation Statement**",
  "group" : [
    {
      "id" : "Group_1",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-scoring",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-scoring",
                "code" : "continuous-variable",
                "display" : "Continuous Variable"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-populationBasis",
          "valueCode" : "boolean"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-scoringUnit",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://unitsofmeasure.org/",
                "code" : "Scoring Unit Field",
                "display" : "Scoring Unit Field"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-type",
                "code" : "intermediate-outcome",
                "display" : "Intermediate Outcome"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-type",
                "code" : "outcome",
                "display" : "Outcome"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-type",
                "code" : "patient-reported-outcome",
                "display" : "Patient Reported Outcome"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-type",
                "code" : "process",
                "display" : "Process"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-type",
                "code" : "structure",
                "display" : "Structure"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-scoringPrecision",
          "valuePositiveInt" : 1
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-improvementNotation",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-improvement-notation",
                "code" : "increase",
                "display" : "Increased score indicates improvement"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-improvementNotationGuidance",
          "valueMarkdown" : "**Improvement Notation Description Field of Reporting Section on Population Criteria Tab of MADiE UI**\n\n* Free text.\n\n* Character limit not determined.\n\n* Improvement Notation required field selected by dropdown (Increased score indicates improvement and Decreased score indicates improvement).\n\n**QDM Equivalent: Improvement Notation**"
        }
      ],
      "description" : "**Population Criteria 1 Description on Population Criteria Tab of MADiE UI**\n\n* Free text.\n\n* Character limit not determined.\n\n**QDM Equivalent: N/A**\n\n**Populates Summary Field in FHIR human readable**\n\n|                                                                        Additional MADiE Page Notes:                                                                         |\n|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------|\n| * Measure type selectable from drop down, multi select; for this example selected all options.                                                                              |\n| * Population Basis selectable from drop down, single select; for this example, boolean is only one that didn't generate an error.                                           |\n| * Scoring selectable from dropdown, single select (Cohort, Continuous Variable, Proportion and Ratio). *Note to self, changing scoring deletes all population information.* |\n| * Aggregate Function selectable from dropdown.                                                                                                                              |\n| * Scoring Unit free text entry.                                                                                                                                             |\n| * Scoring Precision selectable integers.                                                                                                                                    |\n",
      "population" : [
        {
          "id" : "InitialPopulation_1",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "initial-population",
                "display" : "Initial Population"
              }
            ]
          },
          "description" : "**Initial Population Description Field in Population Criteria Tab of MADiE UI**\n\n* Free text.\n\n* Character limit not determined.\n\n* Initial Population required field selected by dropdown (Defines from CQL Editor Tab).\n\n**QDM Equivalent: Initial Population**",
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Initial Population"
          }
        },
        {
          "id" : "MeasurePopulation_1",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "measure-population",
                "display" : "Measure Population"
              }
            ]
          },
          "description" : "**Measure Population Description Field in Population Criteria Tab of MADiE UI**\n\n* Free text.\n\n* Character limit not determined.\n\n* Measure Population required field selected by dropdown (Defines from CQL Editor Tab).\n\n**QDM Equivalent: Measure Population**",
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Measure Population"
          }
        },
        {
          "id" : "MeasurePopulationExclusion_1",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "measure-population-exclusion",
                "display" : "Measure Population Exclusion"
              }
            ]
          },
          "description" : "**Measure Population Exclusion Description Field in Population Criteria Tab of MADiE UI**\n\n* Free text.\n\n* Character limit not determined.\n\n* Numerator Exclusion is not required field selected by dropdown (Defines from CQL Editor Tab).\n\n*Conditional field, will not display if not populated.*\n\n**QDM Equivalent: Measure Population Exclusions**",
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Measure Population Exclusions"
          }
        },
        {
          "id" : "MeasureObservation_1",
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-aggregateMethod",
              "valueString" : "Sum"
            },
            {
              "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-criteriaReference",
              "valueString" : "MeasurePopulation_1"
            }
          ],
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "measure-observation",
                "display" : "Measure Observation"
              }
            ]
          },
          "description" : "**Measure Observation Description Field in Population Criteria Tab of MADiE UI**\n\n* Free text.\n\n* Character limit not determined.\n\n* Measure Observation required field selected by dropdown (Defines from CQL Editor Tab).\n\n**QDM Equivalent: Measure Observation**",
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Measure Observation 1"
          }
        }
      ]
    }
  ],
  "supplementalData" : [
    {
      "id" : "sde-ethnicity",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "individual"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "subject-list"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "summary"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "data-collection"
        }
      ],
      "usage" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/measure-data-usage",
              "code" : "supplemental-data"
            }
          ]
        }
      ],
      "description" : "SDE Ethnicity",
      "criteria" : {
        "language" : "text/cql-identifier",
        "expression" : "SDE Ethnicity"
      }
    },
    {
      "id" : "sde-payer",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "individual"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "subject-list"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "summary"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "data-collection"
        }
      ],
      "usage" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/measure-data-usage",
              "code" : "supplemental-data"
            }
          ]
        }
      ],
      "description" : "SDE Payer",
      "criteria" : {
        "language" : "text/cql-identifier",
        "expression" : "SDE Payer"
      }
    },
    {
      "id" : "sde-race",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "individual"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "subject-list"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "summary"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "data-collection"
        }
      ],
      "usage" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/measure-data-usage",
              "code" : "supplemental-data"
            }
          ]
        }
      ],
      "description" : "SDE Race",
      "criteria" : {
        "language" : "text/cql-identifier",
        "expression" : "SDE Race"
      }
    },
    {
      "id" : "sde-sex",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "individual"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "subject-list"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "summary"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "data-collection"
        }
      ],
      "usage" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/measure-data-usage",
              "code" : "supplemental-data"
            }
          ]
        }
      ],
      "description" : "SDE Sex",
      "criteria" : {
        "language" : "text/cql-identifier",
        "expression" : "SDE Sex"
      }
    },
    {
      "id" : "rav-patient-too-young-at-start-of-measurement-period",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "individual"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "subject-list"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "summary"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-includeInReportType",
          "valueCode" : "data-collection"
        }
      ],
      "usage" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/measure-data-usage",
              "code" : "risk-adjustment-factor"
            }
          ]
        }
      ],
      "description" : "RAV Patient Too Young at Start of Measurement Period",
      "criteria" : {
        "language" : "text/cql-identifier",
        "expression" : "RAV Patient Too Young at Start of Measurement Period"
      }
    }
  ]
}

```
