# HIV Viral Suppression FHIR Example - Your User Friendly Name for MyContentIG Here v0.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HIV Viral Suppression FHIR Example**

## Measure: HIV Viral Suppression FHIR Example 

| | |
| :--- | :--- |
| *Official URL*:http://somewhere.org/fhir/uv/mycontentig/Measure/HIVViralSuppressionFHIRExample | *Version*:0.5.3 |
| Draft as of 2025-09-30 | *Computable Name*:HIVViralSuppressionFHIRExample |
| *Other Identifiers:*Short Name: CMS314FHIR (use: usual, ), UUID:b8aa1302-d225-4dc7-9a3b-ffec45976a3e (use: official, ), UUID:2c92808287dd6f640188b022a80a1e8d (use: official, ), Publisher: 314FHIR (use: official, ) | |
| **Usage:**Clinical Venue: EC | |
| **Copyright/Legal**: This measure was developed by the Health Resources & Services Administration (HRSA) of the U.S. Department of Health & Human Services (HHS). It is in the public domain.Citation of HRSA as the source of the original measure is appreciated. Any modified versions may not be represented as approved, endorsed, or authorized by HRSA or HHS. 42 U.S.C. Section 1320b-10. Users of modified versions should clearly explain how they deviate from HRSA’s original measure.Limited proprietary coding is contained in the Measure specifications for user convenience. Users of proprietary code sets should obtain all necessary licenses from the owners of the code sets.CPT(R) contained in the Measure specifications is copyright 2004-2022 American Medical Association. LOINC(R) is copyright 2004-2022 Regenstrief Institute, Inc. This material contains SNOMED Clinical Terms(R) (SNOMED CT[R]) copyright 2004-2022 International Health Terminology Standards Development Organisation. ICD-10 is copyright 2022 World Health Organization. All Rights Reserved.Due to technical limitations, registered trademarks are indicated by (R) or [R] and unregistered trademarks are indicated by (TM) or [TM]. | |

 
Percentage of patients, regardless of age, diagnosed with HIV prior to or during the first 90 days of the measurement period, with an eligible encounter in the first 240 days of the measurement period, whose last HIV viral load test result was less than 200 copies/mL during the measurement period 

 
UNKNOWN 

* Metadata: Title
  * ?: HIV Viral Suppression FHIR Example
* Metadata: Version
  * ?: 0.5.3
* Metadata: Short Name
  * ?: CMS314FHIR
* Metadata: GUID (Version Independent)
  * ?: urn:uuid:b8aa1302-d225-4dc7-9a3b-ffec45976a3e
* Metadata: GUID (Version Specific)
  * ?: urn:uuid:2c92808287dd6f640188b022a80a1e8d
* Metadata: CMS Identifier
  * ?: 314FHIR
* Metadata: Effective Period
  * ?: 2024-01-01 through 2024-12-31
* Metadata: Approval Date
  * ?: 2023-08-14
* Metadata: Last Review Date
  * ?: 2023-08-14
* Metadata: Status
  * ?: Draft
* Metadata: Use Context
  * ?: venue from[http://terminology.hl7.org/CodeSystem/usage-context-type](http://terminology.hl7.org/7.0.0/CodeSystem-usage-context-type.html)= EC
* Metadata: Jurisdiction
  * ?: 001 from[http://unstats.un.org/unsd/methods/m49/m49.htm](http://unstats.un.org/unsd/methods/m49/m49.htm)
* Metadata: Steward (Publisher)
  * ?: HL7 International - [Some] Work Group
* Metadata: Developer
  * ?: Health Resources & Services Administration
* Metadata: Description
  * ?: Percentage of patients, regardless of age, diagnosed with HIV prior to or during the first 90 days of the measurement period, with an eligible encounter in the first 240 days of the measurement period, whose last HIV viral load test result was less than 200 copies/mL during the measurement period
* Metadata: Copyright
  * ?: This measure was developed by the Health Resources & Services Administration (HRSA) of the U.S. Department of Health & Human Services (HHS). It is in the public domain.Citation of HRSA as the source of the original measure is appreciated. Any modified versions may not be represented as approved, endorsed, or authorized by HRSA or HHS. 42 U.S.C. Section 1320b-10. Users of modified versions should clearly explain how they deviate from HRSA's original measure.Limited proprietary coding is contained in the Measure specifications for user convenience. Users of proprietary code sets should obtain all necessary licenses from the owners of the code sets.CPT(R) contained in the Measure specifications is copyright 2004-2022 American Medical Association. LOINC(R) is copyright 2004-2022 Regenstrief Institute, Inc. This material contains SNOMED Clinical Terms(R) (SNOMED CT[R]) copyright 2004-2022 International Health Terminology Standards Development Organisation. ICD-10 is copyright 2022 World Health Organization. All Rights Reserved.Due to technical limitations, registered trademarks are indicated by (R) or [R] and unregistered trademarks are indicated by (TM) or [TM].
* Metadata: Disclaimer
  * ?: These performance measures are not clinical guidelines and do not establish a standard of medical care, and have not been tested for all potential applications.THE MEASURES AND SPECIFICATIONS ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.Due to technical limitations, registered trademarks are indicated by (R) or [R] and unregistered trademarks are indicated by (TM) or [TM].
* Metadata: Rationale
  * ?: HIV is a communicable infection that leads to a progressive disease with a long asymptomatic period. Approximately 40,000 persons in the United States are newly infected with HIV each year (Centers for Disease Control and Prevention, 2021, p. 51). Without treatment, most persons develop acquired immunodeficiency syndrome (AIDS) within 10 years of HIV infection.HIV viral suppression is a long-standing priority outcome among the HIV community in the United States and around the world. The National HIV/AIDS Strategy for the United States from 2022-2025, developed by the White House Office of National AIDS Policy with input from the HIV community across the United States, prioritizes increasing HIV viral suppression rates to 95% (The White House, 2020). The DHHS Panel on Antiretroviral Guidelines for Adults and Adolescents defines viral suppression as a viral load below the lower limits of detection in its guidelines on virologic failure, and it defines viral suppression as a viral load of less than 200 copies/mL as part of its guidelines for the use of antiretroviral therapy to prevent HIV transmission (Panel on Antiretroviral Guidelines for Adults and Adolescents, 2022).Antiretroviral therapy (ART) delays the progression to AIDS and increases the length of survival. ART reduces HIV-associated morbidity and mortality by maximally inhibiting HIV replication to achieve viral suppression (Hogg et al., 2001; Lundgern et al., 2015). ART has also been shown to reduce transmission of HIV (Rodger et al., 2019). Studies show disparities in rates of viral suppression by race and ethnicity among MSM and among women, with Black and Hispanic or Latino/a study participants having lower rates of viral suppression than White participants (Buchacz et al., 2020; Buchacz et al., 2018; Geter et al., 2018). This measure will help providers direct their attention and quality improvement efforts towards improving HIV viral suppression rates.
* Metadata: Clinical Recommendation Statement
  * ?: Adult guidelines: "The primary goal of antiretroviral therapy (ART) is to prevent HIV-associated morbidity and mortality. This goal is accomplished by using effective ART to achieve and maintain a plasma HIV-1 RNA (viral load) below the quantification limits of commercially available assays. Durable viral suppression improves immune function and overall quality of life, lowers the risk of both AIDS-defining and non-AIDS–defining complications, and allows persons with HIV to live a lifespan approaching that of persons without HIV" (Panel on Antiretroviral Guidelines for Adults and Adolescents, 2022, p. E-1)."ART is recommended for all individuals with HIV to reduce the morbidity and mortality associated with HIV infection and to prevent HIV transmission to sexual partners and infants (AI). ART should be initiated as soon as possible after HIV diagnosis (AI)" (Panel on Antiretroviral Guidelines for Adults and Adolescents, 2022, p. E-2)."The guidelines and the AIDS Clinical Trials Group (ACTG) now define virologic failure as a confirmed viral load >200 copies/mL- a threshold that eliminates most cases of apparent viremia caused by viral load blips or assay variability" (Panel on Antiretroviral Guidelines for Adults and Adolescents, 2022, p. C-6)."Individuals who are adherent to their ARV regimen and do not harbor resistance mutations to the component drugs can generally achieve suppression 8 to 24 weeks after ART initiation; rarely, in some patients it may take longer" (Panel on Antiretroviral Guidelines for Adults and Adolescents, 2022, p. C-6).Pediatric guidelines: "Based on accumulated experience with currently available assays, the current definition of virologic suppression is a plasma viral load below the detection limit of the assay used (generally <20 to 75 copies/mL)" (Panel on Antiretroviral Therapy and Medical Management of Children Living with HIV, 2022, p. D-5)."Temporary viral load elevations ("blips") that are between the level of detection and 200 copies/mL to 500 copies/mL are often detected in adults and children who are on ART; these temporary elevations do not represent virologic failure, as long as the values have returned to below the level of detection when testing is repeated" (Panel on Antiretroviral Therapy and Medical Management of Children Living with HIV, 2022, p. D-5).
* Metadata: Guidance (Usage)
  * ?: HIV viral load data should be captured either as a numeric value or as a character/text value, depending on whether a given viral load result falls above or below the lab's lower limit of detection. For viral loads at or above the lower limit of detection, the viral load should be captured as a numeric value (expressed as the number of copies/mL). For viral loads below the lower limit of detection, the viral load should be populated with a character/text value equivalent to "Below lower limit of detection." The EHR need not record this character value using this exact wording (for example, the character value could be recorded as "<20 copies/mL" or "not detected"), but values below the lower limit of detection should be documented to allow the submitter to accurately map them to a value of "Below lower limit of detection" for reporting purposes. This eCQM is a patient-based measure. This FHIR-based measure has been derived from the QDM-based measure: CMS314v1. Please refer to the HL7 QI-Core Implementation Guide (http://hl7.org/fhir/us/qicore/index.html) for more information on QI-Core and mapping recommendations from QDM to QI-Core 4.1.1 (http://hl7.org/fhir/us/qicore/qdm-to-qicore.html).
* Metadata: Measure Group (Rate) (ID: 64873a03be23a058642d5816)
* Metadata: Basis
  * ?: boolean
* Metadata: Scoring
  * ?: Proportion
* Metadata: Type
  * ?: Outcome
* Metadata: Initial Population
  * ?: **ID**: DF999E50-BAB8-409F-922D-E8FA0E0BD92E**Description**:All patients, regardless of age, diagnosed with HIV prior to or during the first 90 days of the measurement period with at least one eligible encounter in the first 240 days of the measurement period**Criteria**:[Initial Population](#64873a03be23a058642d5816-DF999E50-BAB8-409F-922D-E8FA0E0BD92E)
* Metadata: Denominator
  * ?: **ID**: 2D69A89B-E60C-4878-B1DD-9F27450D603B**Description**:Equals Initial Population**Criteria**:[Denominator](#64873a03be23a058642d5816-2D69A89B-E60C-4878-B1DD-9F27450D603B)
* Metadata: Denominator Exclusion
  * ?: **ID**: 02767a1a-3174-47b6-8c31-84e10114824f**Description**: No description provided
* Metadata: Numerator
  * ?: **ID**: E492BC05-FD48-4459-8574-5CF67CC14C66**Description**:Patients with a last HIV viral load test result of less than 200 copies/mL during the measurement period**Criteria**:[Numerator](#64873a03be23a058642d5816-E492BC05-FD48-4459-8574-5CF67CC14C66)
* Metadata: Numerator Exclusion
  * ?: **ID**: c5d8edbc-2566-4a49-b298-f39723e037c6**Description**: No description provided
* Metadata: Denominator Exception
  * ?: **ID**: 4e8d7586-8625-42d1-9cff-c02d3d4b87f3**Description**: No description provided
* Metadata: Measure Logic
* Metadata: Primary Library
  * ?: [HIVViralSuppressionFHIRExample](Library-HIVViralSuppressionFHIRExample.md)
* Metadata: Contents
  * ?: **[Population Criteria](#population-criteria)****[Logic Definitions](#definitions)****[Terminology](#terminology)****[Dependencies](#dependencies)****[Data Requirements](#data-requirements)****[Parameters](#parameters)**
* Metadata: Population Criteria
* Metadata: Measure Group (Rate) (ID: 64873a03be23a058642d5816)
* Metadata: Initial Population
* Metadata: ````define "Initial Population": "Has Active HIV Diagnosis Before or in First 90 Days of Measurement Period" and "Has Qualifying Encounter During First 240 Days of Measurement Period"````[**Definition**](#hivviralsuppressionfhirexample-initial-population)
* Metadata: Denominator
* Metadata: ````define "Denominator": "Initial Population"````[**Definition**](#hivviralsuppressionfhirexample-denominator)
* Metadata: Numerator
* Metadata: ````define "Numerator": "Most Recent Viral Load Test During Measurement Period".value < 200 '{copies}/mL' or "Most Recent Viral Load Test During Measurement Period".value ~ "Below threshold level (qualifier value)" or "Most Recent Viral Load Test During Measurement Period".value ~ "Not detected (qualifier value)"````[**Definition**](#hivviralsuppressionfhirexample-numerator)
* Metadata: Logic Definitions
* Metadata: Logic Definition
  * ?: **Library Name:**HIVViralSuppressionFHIRExample
* Metadata: ````define "Most Recent Viral Load Test During Measurement Period": Last(["Observation": "HIV Viral Load"] ViralLoad where QICoreCommon."Latest"(ViralLoad.effective) during day of "Measurement Period" sort by start of QICoreCommon."ToInterval"(effective) )````
* Metadata: Logic Definition
  * ?: **Library Name:**HIVViralSuppressionFHIRExample
* Metadata: ````define "Numerator": "Most Recent Viral Load Test During Measurement Period".value < 200 '{copies}/mL' or "Most Recent Viral Load Test During Measurement Period".value ~ "Below threshold level (qualifier value)" or "Most Recent Viral Load Test During Measurement Period".value ~ "Not detected (qualifier value)"````
* Metadata: Logic Definition
  * ?: **Library Name:**HIVViralSuppressionFHIRExample
* Metadata: ````define "Has Active HIV Diagnosis Before or in First 90 Days of Measurement Period": exists ["Condition": "HIV"] HIVDx where QICoreCommon."ToPrevalenceInterval" ( HIVDx ) starts before day of ( start of "Measurement Period" + 90 days )````
* Metadata: Logic Definition
  * ?: **Library Name:**HIVViralSuppressionFHIRExample
* Metadata: ````define "Has Qualifying Encounter During First 240 Days of Measurement Period": exists ( ["Encounter": "Office Visit"] union ["Encounter": "Outpatient Consultation"] union ["Encounter": "Annual Wellness Visit"] union ["Encounter": "Face-to-Face Interaction"] union ["Encounter": "Home Healthcare Services"] union ["Encounter": "Preventive Care Services Established Office Visit, 18 and Up"] union ["Encounter": "Preventive Care Services Initial Office Visit, 18 and Up"] union ["Encounter": "Preventive Care Services, Initial Office Visit, 0 to 17"] union ["Encounter": "Preventive Care, Established Office Visit, 0 to 17"] union ["Encounter": "Telephone Visits"] union ["Encounter": "Preventive Care Services Other"] ) QualifyingEncounter where QualifyingEncounter.period during day of Interval[start of "Measurement Period", start of "Measurement Period" + 240 days]````
* Metadata: Logic Definition
  * ?: **Library Name:**HIVViralSuppressionFHIRExample
* Metadata: ````define "Initial Population": "Has Active HIV Diagnosis Before or in First 90 Days of Measurement Period" and "Has Qualifying Encounter During First 240 Days of Measurement Period"````
* Metadata: Logic Definition
  * ?: **Library Name:**HIVViralSuppressionFHIRExample
* Metadata: ````define "Denominator": "Initial Population"````
* Metadata: Logic Definition
  * ?: **Library Name:**QICoreCommonExample
* Metadata: ````/* @description: Given an interval, returns the ending point if the interval has an ending boundary specified, otherwise, returns the starting point @deprecated: This function is deprecated. Use the fluent function `latest()` instead */ define function "Latest"(choice Choice<DateTime, Quantity, Interval<DateTime>, Interval<Quantity>> ): (choice.toInterval()) period return if (HasEnd(period)) then end of period else start of period````
* Metadata: Logic Definition
  * ?: **Library Name:**QICoreCommonExample
* Metadata: ````/* @description: Normalizes a value that is a choice of timing-valued types to an equivalent interval @comment: Normalizes a choice type of DateTime, Quanitty, Interval<DateTime>, or Interval<Quantity> types to an equivalent interval. This selection of choice types is a superset of the majority of choice types that are used as possible representations for timing-valued elements in QICore, allowing this function to be used across any resource. The input can be provided as a DateTime, Quantity, Interval<DateTime> or Interval<Quantity>. The intent of this function is to provide a clear and concise mechanism to treat single elements that have multiple possible representations as intervals so that logic doesn't have to account for the variability. More complex calculations (such as medication request period or dispense period calculation) need specific guidance and consideration. That guidance may make use of this function, but the focus of this function is on single element calculations where the semantics are unambiguous. If the input is a DateTime, the result a DateTime Interval beginning and ending on that DateTime. If the input is a Quantity, the quantity is expected to be a calendar-duration interpreted as an Age, and the result is a DateTime Interval beginning on the Date the patient turned that age and ending immediately before one year later. If the input is a DateTime Interval, the result is the input. If the input is a Quantity Interval, the quantities are expected to be calendar-durations interpreted as an Age, and the result is a DateTime Interval beginning on the date the patient turned the age given as the start of the quantity interval, and ending immediately before one year later than the date the patient turned the age given as the end of the quantity interval. Any other input will reslt in a null DateTime Interval */ define fluent function toInterval(choice Choice<DateTime, Quantity, Interval<DateTime>, Interval<Quantity>>): case when choice is DateTime then Interval[choice as DateTime, choice as DateTime] when choice is Interval<DateTime> then choice as Interval<DateTime> when choice is Quantity then Interval[Patient.birthDate + (choice as Quantity), Patient.birthDate + (choice as Quantity) + 1 year) when choice is Interval<Quantity> then Interval[Patient.birthDate + (choice.low as Quantity), Patient.birthDate + (choice.high as Quantity) + 1 year) else null as Interval<DateTime> end````
* Metadata: Logic Definition
  * ?: **Library Name:**QICoreCommonExample
* Metadata: ````/* @description: Given an interval, returns true if the interval has an ending boundary specified (i.e. the end of the interval is not null and not the maximum DateTime value) @deprecated: This function is deprecated. Use the fluent function `hasEnd()` instead */ define function "HasEnd"(period Interval<DateTime> ): not ( end of period is null or end of period = maximum DateTime )````
* Metadata: Logic Definition
  * ?: **Library Name:**QICoreCommonExample
* Metadata: ````/* @description: Normalizes a value that is a choice of timing-valued types to an equivalent interval @comment: Normalizes a choice type of DateTime, Quanitty, Interval<DateTime>, or Interval<Quantity> types to an equivalent interval. This selection of choice types is a superset of the majority of choice types that are used as possible representations for timing-valued elements in QICore, allowing this function to be used across any resource. The input can be provided as a DateTime, Quantity, Interval<DateTime> or Interval<Quantity>. The intent of this function is to provide a clear and concise mechanism to treat single elements that have multiple possible representations as intervals so that logic doesn't have to account for the variability. More complex calculations (such as medication request period or dispense period calculation) need specific guidance and consideration. That guidance may make use of this function, but the focus of this function is on single element calculations where the semantics are unambiguous. If the input is a DateTime, the result a DateTime Interval beginning and ending on that DateTime. If the input is a Quantity, the quantity is expected to be a calendar-duration interpreted as an Age, and the result is a DateTime Interval beginning on the Date the patient turned that age and ending immediately before one year later. If the input is a DateTime Interval, the result is the input. If the input is a Quantity Interval, the quantities are expected to be calendar-durations interpreted as an Age, and the result is a DateTime Interval beginning on the date the patient turned the age given as the start of the quantity interval, and ending immediately before one year later than the date the patient turned the age given as the end of the quantity interval. Any other input will reslt in a null DateTime Interval @deprecated: This function is deprecated. Use the fluent function `toInterval()` instead */ define function ToInterval(choice Choice<DateTime, Quantity, Interval<DateTime>, Interval<Quantity>>): case when choice is DateTime then Interval[choice as DateTime, choice as DateTime] when choice is Interval<DateTime> then choice as Interval<DateTime> when choice is Quantity then Interval[Patient.birthDate + (choice as Quantity), Patient.birthDate + (choice as Quantity) + 1 year) when choice is Interval<Quantity> then Interval[Patient.birthDate + (choice.low as Quantity), Patient.birthDate + (choice.high as Quantity) + 1 year) when choice is QICore.Timing then null as Interval<DateTime> else null as Interval<DateTime> end````
* Metadata: Logic Definition
  * ?: **Library Name:**QICoreCommonExample
* Metadata: ````/* @description: Returns an interval representing the normalized prevalence period of a given Condition. @comment: Uses the ToInterval and ToAbatementInterval functions to determine the widest potential interval from onset to abatement as specified in the given Condition. If the condition is active, the resulting interval will have a closed ending boundary. If the condition is not active, the resulting interval will have an open ending boundary. @deprecated: This function is deprecated. Use the `prevalenceInterval()` fluent function instead */ define function ToPrevalenceInterval(condition Condition): if condition.clinicalStatus ~ "active" or condition.clinicalStatus ~ "recurrence" or condition.clinicalStatus ~ "relapse" then Interval[start of ToInterval(condition.onset), end of ToAbatementInterval(condition)] else Interval[start of ToInterval(condition.onset), end of ToAbatementInterval(condition))````
* Metadata: Logic Definition
  * ?: **Library Name:**QICoreCommonExample
* Metadata: ````/* @description: Normalizes a value that is a choice of timing-valued types to an equivalent interval @comment: Normalizes a choice type of DateTime, Quanitty, Interval<DateTime>, or Interval<Quantity> types to an equivalent interval. This selection of choice types is a superset of the majority of choice types that are used as possible representations for timing-valued elements in QICore, allowing this function to be used across any resource. The input can be provided as a DateTime, Quantity, Interval<DateTime> or Interval<Quantity>. The intent of this function is to provide a clear and concise mechanism to treat single elements that have multiple possible representations as intervals so that logic doesn't have to account for the variability. More complex calculations (such as medication request period or dispense period calculation) need specific guidance and consideration. That guidance may make use of this function, but the focus of this function is on single element calculations where the semantics are unambiguous. If the input is a DateTime, the result a DateTime Interval beginning and ending on that DateTime. If the input is a Quantity, the quantity is expected to be a calendar-duration interpreted as an Age, and the result is a DateTime Interval beginning on the Date the patient turned that age and ending immediately before one year later. If the input is a DateTime Interval, the result is the input. If the input is a Quantity Interval, the quantities are expected to be calendar-durations interpreted as an Age, and the result is a DateTime Interval beginning on the date the patient turned the age given as the start of the quantity interval, and ending immediately before one year later than the date the patient turned the age given as the end of the quantity interval. Any other input will reslt in a null DateTime Interval @deprecated: This function is deprecated. Use the fluent function `toInterval()` instead */ define function ToInterval(choice Choice<DateTime, Quantity, Interval<DateTime>, Interval<Quantity>>): case when choice is DateTime then Interval[choice as DateTime, choice as DateTime] when choice is Interval<DateTime> then choice as Interval<DateTime> when choice is Quantity then Interval[Patient.birthDate + (choice as Quantity), Patient.birthDate + (choice as Quantity) + 1 year) when choice is Interval<Quantity> then Interval[Patient.birthDate + (choice.low as Quantity), Patient.birthDate + (choice.high as Quantity) + 1 year) when choice is QICore.Timing then null as Interval<DateTime> else null as Interval<DateTime> end````
* Metadata: Logic Definition
  * ?: **Library Name:**QICoreCommonExample
* Metadata: ````/* @description: Returns an interval representing the normalized abatement of a given Condition. @comment: If the abatement element of the Condition is represented as a DateTime, the result is an interval beginning and ending on that DateTime. If the abatement is represented as a Quantity, the quantity is expected to be a calendar-duration and is interpreted as the age of the patient. The result is an interval from the date the patient turned that age to immediately before one year later. If the abatement is represented as a Quantity Interval, the quantities are expected to be calendar-durations and are interpreted as an age range during which the abatement occurred. The result is an interval from the date the patient turned the starting age of the quantity interval, and ending immediately before one year later than the date the patient turned the ending age of the quantity interval. @deprecated: This function is deprecated. Use the fluent function `abatementInterval()` instead. */ define function ToAbatementInterval(condition Condition): if condition.abatement is DateTime then Interval[condition.abatement as DateTime, condition.abatement as DateTime] else if condition.abatement is Quantity then Interval[Patient.birthDate + (condition.abatement as Quantity), Patient.birthDate + (condition.abatement as Quantity) + 1 year) else if condition.abatement is Interval<Quantity> then Interval[Patient.birthDate + (condition.abatement.low as Quantity), Patient.birthDate + (condition.abatement.high as Quantity) + 1 year) else if condition.abatement is Interval<DateTime> then Interval[condition.abatement.low, condition.abatement.high) else null as Interval<DateTime>````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````define function ToInterval(period FHIR.Period): if period is null then null else if period."start" is null then Interval(period."start".value, period."end".value] else Interval[period."start".value, period."end".value]````
* Metadata: Terminology
* Metadata: Code System
  * ?: **Description**: Code system SNOMEDCT**Resource**:[SNOMED CT (all versions)](http://hl7.org/fhir/R4/codesystem-snomedct.html)**Canonical URL**:http://snomed.info/sct
* Metadata: Code System
  * ?: **Description**: Code system ConditionClinicalStatusCodes**Resource**:[Condition Clinical Status Codes](http://terminology.hl7.org/7.0.0/CodeSystem-condition-clinical.html)**Canonical URL**:http://terminology.hl7.org/CodeSystem/condition-clinical
* Metadata: Value Set
  * ?: **Description**: Value set HIV Viral Load**Resource**:[HIV Viral Load](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.120.12.1002/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.120.12.1002
* Metadata: Value Set
  * ?: **Description**: Value set HIV**Resource**:[HIV](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.120.12.1003/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.120.12.1003
* Metadata: Value Set
  * ?: **Description**: Value set Office Visit**Resource**:[Office Visit](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1001/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1001
* Metadata: Value Set
  * ?: **Description**: Value set Outpatient Consultation**Resource**:[Outpatient Consultation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1008/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1008
* Metadata: Value Set
  * ?: **Description**: Value set Annual Wellness Visit**Resource**:[Annual Wellness Visit](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.526.3.1240/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.526.3.1240
* Metadata: Value Set
  * ?: **Description**: Value set Face-to-Face Interaction**Resource**:[Face-to-Face Interaction](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1048/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1048
* Metadata: Value Set
  * ?: **Description**: Value set Home Healthcare Services**Resource**:[Home Healthcare Services](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1016/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1016
* Metadata: Value Set
  * ?: **Description**: Value set Preventive Care Services Established Office Visit, 18 and Up**Resource**:[Preventive Care Services Established Office Visit, 18 and Up](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1025/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1025
* Metadata: Value Set
  * ?: **Description**: Value set Preventive Care Services Initial Office Visit, 18 and Up**Resource**:[Preventive Care Services Initial Office Visit, 18 and Up](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1023/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1023
* Metadata: Value Set
  * ?: **Description**: Value set Preventive Care Services, Initial Office Visit, 0 to 17**Resource**:[Preventive Care Services, Initial Office Visit, 0 to 17](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1022/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1022
* Metadata: Value Set
  * ?: **Description**: Value set Preventive Care, Established Office Visit, 0 to 17**Resource**:[Preventive Care, Established Office Visit, 0 to 17](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1024/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1024
* Metadata: Value Set
  * ?: **Description**: Value set Telephone Visits**Resource**:[Telephone Visits](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1080/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1080
* Metadata: Value Set
  * ?: **Description**: Value set Preventive Care Services Other**Resource**:[Preventive Care Services Other](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1030/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1030
* Metadata: Direct Reference Code
  * ?: **Display**: Below threshold level (qualifier value)**Code**: 260988000**System**:http://snomed.info/sct
* Metadata: Direct Reference Code
  * ?: **Display**: Not detected (qualifier value)**Code**: 260415000**System**:http://snomed.info/sct
* Metadata: Direct Reference Code
  * ?: **Code**: active**System**:http://terminology.hl7.org/CodeSystem/condition-clinical
* Metadata: Direct Reference Code
  * ?: **Code**: recurrence**System**:http://terminology.hl7.org/CodeSystem/condition-clinical
* Metadata: Direct Reference Code
  * ?: **Code**: relapse**System**:http://terminology.hl7.org/CodeSystem/condition-clinical
* Metadata: Dependencies
* Metadata: Dependency
  * ?: **Description**: Library FHIRHelpers**Resource**:`http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1`**Canonical URL**:http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1
* Metadata: Dependency
  * ?: **Description**: Library QICoreCommon**Resource**:[QICoreCommonExample](Library-QICoreCommonExample.md)**Canonical URL**:http://somewhere.org/fhir/uv/mycontentig/Library/QICoreCommonExample
* Metadata: Data Requirements
* Metadata: Data Requirement
  * ?: **Type**: Patient**Profile(s)**:[QICore Patient](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-patient.html)
* Metadata: Data Requirement
  * ?: **Type**: Observation**Profile(s)**:[QICore Observation](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-observation.html)**Must Support Elements**: code, effective**Code Filter(s)**:**Path**: code**ValueSet**:[HIV Viral Load](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.120.12.1002/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Condition**Profile(s)**:`http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition`**Must Support Elements**: code**Code Filter(s)**:**Path**: code**ValueSet**:[HIV](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.120.12.1003/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, period**Code Filter(s)**:**Path**: type**ValueSet**:[Office Visit](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1001/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, period**Code Filter(s)**:**Path**: type**ValueSet**:[Outpatient Consultation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1008/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, period**Code Filter(s)**:**Path**: type**ValueSet**:[Annual Wellness Visit](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.526.3.1240/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, period**Code Filter(s)**:**Path**: type**ValueSet**:[Face-to-Face Interaction](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1048/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, period**Code Filter(s)**:**Path**: type**ValueSet**:[Home Healthcare Services](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1016/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, period**Code Filter(s)**:**Path**: type**ValueSet**:[Preventive Care Services Established Office Visit, 18 and Up](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1025/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, period**Code Filter(s)**:**Path**: type**ValueSet**:[Preventive Care Services Initial Office Visit, 18 and Up](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1023/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, period**Code Filter(s)**:**Path**: type**ValueSet**:[Preventive Care Services, Initial Office Visit, 0 to 17](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1022/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, period**Code Filter(s)**:**Path**: type**ValueSet**:[Preventive Care, Established Office Visit, 0 to 17](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1024/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, period**Code Filter(s)**:**Path**: type**ValueSet**:[Telephone Visits](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1080/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, period**Code Filter(s)**:**Path**: type**ValueSet**:[Preventive Care Services Other](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.101.12.1030/expansion)
* Metadata: Parameters
* Metadata: 
  * ?: 
| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| **Name** | **Use** | **Card.** | **Type** | **Documentation** |
| Measurement Period | In | 0..1 | Period |  |
| Numerator | Out | 0..1 | boolean |  |
| Denominator | Out | 0..1 | boolean |  |
| Initial Population | Out | 0..1 | boolean |  |

* Metadata: Generated using version 0.5.3 of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Measure",
  "id" : "HIVViralSuppressionFHIRExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/computable-measure-cqfm"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Library",
      "id" : "effective-data-requirements",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-directReferenceCode",
          "valueCoding" : {
            "system" : "http://snomed.info/sct",
            "code" : "260988000",
            "display" : "Below threshold level (qualifier value)"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-directReferenceCode",
          "valueCoding" : {
            "system" : "http://snomed.info/sct",
            "code" : "260415000",
            "display" : "Not detected (qualifier value)"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-directReferenceCode",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
            "code" : "active"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-directReferenceCode",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
            "code" : "recurrence"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-directReferenceCode",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
            "code" : "relapse"
          }
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "HIVViralSuppressionFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "Most Recent Viral Load Test During Measurement Period"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Most Recent Viral Load Test During Measurement Period\":\n  Last([\"Observation\": \"HIV Viral Load\"] ViralLoad\n      where QICoreCommon.\"Latest\"(ViralLoad.effective) during day of \"Measurement Period\"\n      sort by start of QICoreCommon.\"ToInterval\"(effective)\n  )"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 0
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "HIVViralSuppressionFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "Numerator"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Numerator\":\n  \"Most Recent Viral Load Test During Measurement Period\".value < 200 '{copies}/mL'\n    or \"Most Recent Viral Load Test During Measurement Period\".value ~ \"Below threshold level (qualifier value)\"\n    or \"Most Recent Viral Load Test During Measurement Period\".value ~ \"Not detected (qualifier value)\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 1
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "HIVViralSuppressionFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "Has Active HIV Diagnosis Before or in First 90 Days of Measurement Period"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Has Active HIV Diagnosis Before or in First 90 Days of Measurement Period\":\n  exists [\"Condition\": \"HIV\"] HIVDx\n    where QICoreCommon.\"ToPrevalenceInterval\" ( HIVDx ) starts before day of ( start of \"Measurement Period\" + 90 days )"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 2
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "HIVViralSuppressionFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "Has Qualifying Encounter During First 240 Days of Measurement Period"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Has Qualifying Encounter During First 240 Days of Measurement Period\":\n  exists ( [\"Encounter\": \"Office Visit\"]\n    union [\"Encounter\": \"Outpatient Consultation\"]\n    union [\"Encounter\": \"Annual Wellness Visit\"]\n    union [\"Encounter\": \"Face-to-Face Interaction\"]\n    union [\"Encounter\": \"Home Healthcare Services\"]\n    union [\"Encounter\": \"Preventive Care Services Established Office Visit, 18 and Up\"]\n    union [\"Encounter\": \"Preventive Care Services Initial Office Visit, 18 and Up\"]\n    union [\"Encounter\": \"Preventive Care Services, Initial Office Visit, 0 to 17\"]\n    union [\"Encounter\": \"Preventive Care, Established Office Visit, 0 to 17\"]\n    union [\"Encounter\": \"Telephone Visits\"]\n    union [\"Encounter\": \"Preventive Care Services Other\"] ) QualifyingEncounter\n    where QualifyingEncounter.period during day of Interval[start of \"Measurement Period\", start of \"Measurement Period\" + 240 days]"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 3
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "HIVViralSuppressionFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "Initial Population"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Initial Population\":\n  \"Has Active HIV Diagnosis Before or in First 90 Days of Measurement Period\"\n    and \"Has Qualifying Encounter During First 240 Days of Measurement Period\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 4
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "HIVViralSuppressionFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "Denominator"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Denominator\":\n  \"Initial Population\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 5
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "QICoreCommonExample"
            },
            {
              "url" : "name",
              "valueString" : "Latest"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Given an interval, returns the ending point if the interval has an ending boundary specified,\notherwise, returns the starting point\n@deprecated: This function is deprecated. Use the fluent function `latest()` instead\n*/\ndefine function \"Latest\"(choice Choice<DateTime, Quantity, Interval<DateTime>, Interval<Quantity>> ):\n  (choice.toInterval()) period\n    return\n      if (HasEnd(period)) then end of period\n      else start of period"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 6
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "QICoreCommonExample"
            },
            {
              "url" : "name",
              "valueString" : "toInterval"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Normalizes a value that is a choice of timing-valued types to an equivalent interval\n@comment: Normalizes a choice type of DateTime, Quanitty, Interval<DateTime>, or Interval<Quantity> types\nto an equivalent interval. This selection of choice types is a superset of the majority of choice types that are used as possible\nrepresentations for timing-valued elements in QICore, allowing this function to be used across any resource.\nThe input can be provided as a DateTime, Quantity, Interval<DateTime> or Interval<Quantity>.\nThe intent of this function is to provide a clear and concise mechanism to treat single\nelements that have multiple possible representations as intervals so that logic doesn't have to account\nfor the variability. More complex calculations (such as medication request period or dispense period\ncalculation) need specific guidance and consideration. That guidance may make use of this function, but\nthe focus of this function is on single element calculations where the semantics are unambiguous.\nIf the input is a DateTime, the result a DateTime Interval beginning and ending on that DateTime.\nIf the input is a Quantity, the quantity is expected to be a calendar-duration interpreted as an Age,\nand the result is a DateTime Interval beginning on the Date the patient turned that age and ending immediately before one year later.\nIf the input is a DateTime Interval, the result is the input.\nIf the input is a Quantity Interval, the quantities are expected to be calendar-durations interpreted as an Age, and the result\nis a DateTime Interval beginning on the date the patient turned the age given as the start of the quantity interval, and ending\nimmediately before one year later than the date the patient turned the age given as the end of the quantity interval.\nAny other input will reslt in a null DateTime Interval\n*/\ndefine fluent function toInterval(choice Choice<DateTime, Quantity, Interval<DateTime>, Interval<Quantity>>):\n  case\n\t  when choice is DateTime then\n    \tInterval[choice as DateTime, choice as DateTime]\n\t\twhen choice is Interval<DateTime> then\n  \t\tchoice as Interval<DateTime>\n\t\twhen choice is Quantity then\n\t\t  Interval[Patient.birthDate + (choice as Quantity),\n\t\t\t  Patient.birthDate + (choice as Quantity) + 1 year)\n\t\twhen choice is Interval<Quantity> then\n\t\t  Interval[Patient.birthDate + (choice.low as Quantity),\n\t\t\t  Patient.birthDate + (choice.high as Quantity) + 1 year)\n\t\telse\n\t\t\tnull as Interval<DateTime>\n\tend"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 7
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "QICoreCommonExample"
            },
            {
              "url" : "name",
              "valueString" : "HasEnd"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Given an interval, returns true if the interval has an ending boundary specified\n(i.e. the end of the interval is not null and not the maximum DateTime value)\n@deprecated: This function is deprecated. Use the fluent function `hasEnd()` instead\n*/\ndefine function \"HasEnd\"(period Interval<DateTime> ):\n  not (\n    end of period is null\n      or end of period = maximum DateTime\n  )"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 8
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "QICoreCommonExample"
            },
            {
              "url" : "name",
              "valueString" : "ToInterval"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Normalizes a value that is a choice of timing-valued types to an equivalent interval\n@comment: Normalizes a choice type of DateTime, Quanitty, Interval<DateTime>, or Interval<Quantity> types\nto an equivalent interval. This selection of choice types is a superset of the majority of choice types that are used as possible\nrepresentations for timing-valued elements in QICore, allowing this function to be used across any resource.\nThe input can be provided as a DateTime, Quantity, Interval<DateTime> or Interval<Quantity>.\nThe intent of this function is to provide a clear and concise mechanism to treat single\nelements that have multiple possible representations as intervals so that logic doesn't have to account\nfor the variability. More complex calculations (such as medication request period or dispense period\ncalculation) need specific guidance and consideration. That guidance may make use of this function, but\nthe focus of this function is on single element calculations where the semantics are unambiguous.\nIf the input is a DateTime, the result a DateTime Interval beginning and ending on that DateTime.\nIf the input is a Quantity, the quantity is expected to be a calendar-duration interpreted as an Age,\nand the result is a DateTime Interval beginning on the Date the patient turned that age and ending immediately before one year later.\nIf the input is a DateTime Interval, the result is the input.\nIf the input is a Quantity Interval, the quantities are expected to be calendar-durations interpreted as an Age, and the result\nis a DateTime Interval beginning on the date the patient turned the age given as the start of the quantity interval, and ending\nimmediately before one year later than the date the patient turned the age given as the end of the quantity interval.\nAny other input will reslt in a null DateTime Interval\n@deprecated: This function is deprecated. Use the fluent function `toInterval()` instead\n*/\ndefine function ToInterval(choice Choice<DateTime, Quantity, Interval<DateTime>, Interval<Quantity>>):\n  case\n\t  when choice is DateTime then\n    \tInterval[choice as DateTime, choice as DateTime]\n\t\twhen choice is Interval<DateTime> then\n  \t\tchoice as Interval<DateTime>\n\t\twhen choice is Quantity then\n\t\t  Interval[Patient.birthDate + (choice as Quantity),\n\t\t\t  Patient.birthDate + (choice as Quantity) + 1 year)\n\t\twhen choice is Interval<Quantity> then\n\t\t  Interval[Patient.birthDate + (choice.low as Quantity),\n\t\t\t  Patient.birthDate + (choice.high as Quantity) + 1 year)\n\t\twhen choice is QICore.Timing then\n            null as Interval<DateTime>\n\t\telse\n\t\t\tnull as Interval<DateTime>\n\tend"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 9
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "QICoreCommonExample"
            },
            {
              "url" : "name",
              "valueString" : "ToPrevalenceInterval"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Returns an interval representing the normalized prevalence period of a given Condition.\n@comment: Uses the ToInterval and ToAbatementInterval functions to determine the widest potential interval from\nonset to abatement as specified in the given Condition. If the condition is active, the resulting interval will have\na closed ending boundary. If the condition is not active, the resulting interval will have an open ending boundary.\n@deprecated: This function is deprecated. Use the `prevalenceInterval()` fluent function instead\n*/\ndefine function ToPrevalenceInterval(condition Condition):\nif condition.clinicalStatus ~ \"active\"\n  or condition.clinicalStatus ~ \"recurrence\"\n  or condition.clinicalStatus ~ \"relapse\" then\n  Interval[start of ToInterval(condition.onset), end of ToAbatementInterval(condition)]\nelse\n  Interval[start of ToInterval(condition.onset), end of ToAbatementInterval(condition))"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 10
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "QICoreCommonExample"
            },
            {
              "url" : "name",
              "valueString" : "ToInterval"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Normalizes a value that is a choice of timing-valued types to an equivalent interval\n@comment: Normalizes a choice type of DateTime, Quanitty, Interval<DateTime>, or Interval<Quantity> types\nto an equivalent interval. This selection of choice types is a superset of the majority of choice types that are used as possible\nrepresentations for timing-valued elements in QICore, allowing this function to be used across any resource.\nThe input can be provided as a DateTime, Quantity, Interval<DateTime> or Interval<Quantity>.\nThe intent of this function is to provide a clear and concise mechanism to treat single\nelements that have multiple possible representations as intervals so that logic doesn't have to account\nfor the variability. More complex calculations (such as medication request period or dispense period\ncalculation) need specific guidance and consideration. That guidance may make use of this function, but\nthe focus of this function is on single element calculations where the semantics are unambiguous.\nIf the input is a DateTime, the result a DateTime Interval beginning and ending on that DateTime.\nIf the input is a Quantity, the quantity is expected to be a calendar-duration interpreted as an Age,\nand the result is a DateTime Interval beginning on the Date the patient turned that age and ending immediately before one year later.\nIf the input is a DateTime Interval, the result is the input.\nIf the input is a Quantity Interval, the quantities are expected to be calendar-durations interpreted as an Age, and the result\nis a DateTime Interval beginning on the date the patient turned the age given as the start of the quantity interval, and ending\nimmediately before one year later than the date the patient turned the age given as the end of the quantity interval.\nAny other input will reslt in a null DateTime Interval\n@deprecated: This function is deprecated. Use the fluent function `toInterval()` instead\n*/\ndefine function ToInterval(choice Choice<DateTime, Quantity, Interval<DateTime>, Interval<Quantity>>):\n  case\n\t  when choice is DateTime then\n    \tInterval[choice as DateTime, choice as DateTime]\n\t\twhen choice is Interval<DateTime> then\n  \t\tchoice as Interval<DateTime>\n\t\twhen choice is Quantity then\n\t\t  Interval[Patient.birthDate + (choice as Quantity),\n\t\t\t  Patient.birthDate + (choice as Quantity) + 1 year)\n\t\twhen choice is Interval<Quantity> then\n\t\t  Interval[Patient.birthDate + (choice.low as Quantity),\n\t\t\t  Patient.birthDate + (choice.high as Quantity) + 1 year)\n\t\twhen choice is QICore.Timing then\n            null as Interval<DateTime>\n\t\telse\n\t\t\tnull as Interval<DateTime>\n\tend"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 11
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "QICoreCommonExample"
            },
            {
              "url" : "name",
              "valueString" : "ToAbatementInterval"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Returns an interval representing the normalized abatement of a given Condition.\n@comment: If the abatement element of the Condition is represented as a DateTime, the result\nis an interval beginning and ending on that DateTime.\nIf the abatement is represented as a Quantity, the quantity is expected to be a calendar-duration and is interpreted as the age of the patient. The\nresult is an interval from the date the patient turned that age to immediately before one year later.\nIf the abatement is represented as a Quantity Interval, the quantities are expected to be calendar-durations and are interpreted as an age range during\nwhich the abatement occurred. The result is an interval from the date the patient turned the starting age of the quantity interval, and ending immediately\nbefore one year later than the date the patient turned the ending age of the quantity interval.\n@deprecated: This function is deprecated. Use the fluent function `abatementInterval()` instead.\n*/\ndefine function ToAbatementInterval(condition Condition):\n\tif condition.abatement is DateTime then\n\t  Interval[condition.abatement as DateTime, condition.abatement as DateTime]\n\telse if condition.abatement is Quantity then\n\t\tInterval[Patient.birthDate + (condition.abatement as Quantity),\n\t\t\tPatient.birthDate + (condition.abatement as Quantity) + 1 year)\n\telse if condition.abatement is Interval<Quantity> then\n\t  Interval[Patient.birthDate + (condition.abatement.low as Quantity),\n\t\t  Patient.birthDate + (condition.abatement.high as Quantity) + 1 year)\n\telse if condition.abatement is Interval<DateTime> then\n\t  Interval[condition.abatement.low, condition.abatement.high)\n\telse null as Interval<DateTime>"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 12
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToInterval"
            },
            {
              "url" : "statement",
              "valueString" : "define function ToInterval(period FHIR.Period):\n    if period is null then\n        null\n    else\n        if period.\"start\" is null then\n            Interval(period.\"start\".value, period.\"end\".value]\n        else\n            Interval[period.\"start\".value, period.\"end\".value]"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 13
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        }
      ],
      "name" : "EffectiveDataRequirements",
      "status" : "active",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/library-type",
            "code" : "module-definition"
          }
        ]
      },
      "relatedArtifact" : [
        {
          "type" : "depends-on",
          "display" : "Library FHIRHelpers",
          "resource" : "http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1"
        },
        {
          "type" : "depends-on",
          "display" : "Library QICoreCommon",
          "resource" : "http://somewhere.org/fhir/uv/mycontentig/Library/QICoreCommonExample"
        },
        {
          "type" : "depends-on",
          "display" : "Code system SNOMEDCT",
          "resource" : "http://snomed.info/sct"
        },
        {
          "type" : "depends-on",
          "display" : "Code system ConditionClinicalStatusCodes",
          "resource" : "http://terminology.hl7.org/CodeSystem/condition-clinical"
        },
        {
          "type" : "depends-on",
          "display" : "Value set HIV Viral Load",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.120.12.1002"
        },
        {
          "type" : "depends-on",
          "display" : "Value set HIV",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.120.12.1003"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Office Visit",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1001"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Outpatient Consultation",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1008"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Annual Wellness Visit",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.526.3.1240"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Face-to-Face Interaction",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1048"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Home Healthcare Services",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1016"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Preventive Care Services Established Office Visit, 18 and Up",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1025"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Preventive Care Services Initial Office Visit, 18 and Up",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1023"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Preventive Care Services, Initial Office Visit, 0 to 17",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1022"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Preventive Care, Established Office Visit, 0 to 17",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1024"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Telephone Visits",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1080"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Preventive Care Services Other",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1030"
        }
      ],
      "parameter" : [
        {
          "name" : "Measurement Period",
          "use" : "in",
          "min" : 0,
          "max" : "1",
          "type" : "Period"
        },
        {
          "name" : "Numerator",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "boolean"
        },
        {
          "name" : "Denominator",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "boolean"
        },
        {
          "name" : "Initial Population",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "boolean"
        }
      ],
      "dataRequirement" : [
        {
          "type" : "Patient",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
          ]
        },
        {
          "type" : "Observation",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-observation"
          ],
          "mustSupport" : ["code", "effective"],
          "codeFilter" : [
            {
              "path" : "code",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.120.12.1002"
            }
          ]
        },
        {
          "type" : "Condition",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition"
          ],
          "mustSupport" : ["code"],
          "codeFilter" : [
            {
              "path" : "code",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.120.12.1003"
            }
          ]
        },
        {
          "type" : "Encounter",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
          ],
          "mustSupport" : ["type", "period"],
          "codeFilter" : [
            {
              "path" : "type",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1001"
            }
          ]
        },
        {
          "type" : "Encounter",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
          ],
          "mustSupport" : ["type", "period"],
          "codeFilter" : [
            {
              "path" : "type",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1008"
            }
          ]
        },
        {
          "type" : "Encounter",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
          ],
          "mustSupport" : ["type", "period"],
          "codeFilter" : [
            {
              "path" : "type",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.526.3.1240"
            }
          ]
        },
        {
          "type" : "Encounter",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
          ],
          "mustSupport" : ["type", "period"],
          "codeFilter" : [
            {
              "path" : "type",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1048"
            }
          ]
        },
        {
          "type" : "Encounter",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
          ],
          "mustSupport" : ["type", "period"],
          "codeFilter" : [
            {
              "path" : "type",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1016"
            }
          ]
        },
        {
          "type" : "Encounter",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
          ],
          "mustSupport" : ["type", "period"],
          "codeFilter" : [
            {
              "path" : "type",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1025"
            }
          ]
        },
        {
          "type" : "Encounter",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
          ],
          "mustSupport" : ["type", "period"],
          "codeFilter" : [
            {
              "path" : "type",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1023"
            }
          ]
        },
        {
          "type" : "Encounter",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
          ],
          "mustSupport" : ["type", "period"],
          "codeFilter" : [
            {
              "path" : "type",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1022"
            }
          ]
        },
        {
          "type" : "Encounter",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
          ],
          "mustSupport" : ["type", "period"],
          "codeFilter" : [
            {
              "path" : "type",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1024"
            }
          ]
        },
        {
          "type" : "Encounter",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
          ],
          "mustSupport" : ["type", "period"],
          "codeFilter" : [
            {
              "path" : "type",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1080"
            }
          ]
        },
        {
          "type" : "Encounter",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
          ],
          "mustSupport" : ["type", "period"],
          "codeFilter" : [
            {
              "path" : "type",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.101.12.1030"
            }
          ]
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-softwaresystem",
      "valueReference" : {
        "reference" : "Device/cqf-tooling"
      }
    },
    {
      "url" : "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-effectiveDataRequirements",
      "valueCanonical" : "#effective-data-requirements"
    }
  ],
  "url" : "http://somewhere.org/fhir/uv/mycontentig/Measure/HIVViralSuppressionFHIRExample",
  "identifier" : [
    {
      "use" : "usual",
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/cqfmeasures/CodeSystem/identifier-type",
            "code" : "short-name",
            "display" : "Short Name"
          }
        ]
      },
      "system" : "https://madie.cms.gov/measure/shortName",
      "value" : "CMS314FHIR"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/cqfmeasures/CodeSystem/identifier-type",
            "code" : "version-independent",
            "display" : "Version Independent"
          }
        ]
      },
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:uuid:b8aa1302-d225-4dc7-9a3b-ffec45976a3e"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/cqfmeasures/CodeSystem/identifier-type",
            "code" : "version-specific",
            "display" : "Version Specific"
          }
        ]
      },
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:uuid:2c92808287dd6f640188b022a80a1e8d"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/cqfmeasures/CodeSystem/identifier-type",
            "code" : "publisher",
            "display" : "Publisher"
          }
        ]
      },
      "system" : "https://madie.cms.gov/measure/cmsId",
      "value" : "314FHIR",
      "assigner" : {
        "display" : "CMS"
      }
    }
  ],
  "version" : "0.5.3",
  "name" : "HIVViralSuppressionFHIRExample",
  "title" : "HIV Viral Suppression FHIR Example",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-09-30T04:16:55+00:00",
  "publisher" : "HL7 International - [Some] Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/Special/committees/[something]"
        }
      ]
    }
  ],
  "description" : "Percentage of patients, regardless of age, diagnosed with HIV prior to or during the first 90 days of the measurement period, with an eligible encounter in the first 240 days of the measurement period, whose last HIV viral load test result was less than 200 copies/mL during the measurement period",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "venue"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/cqm/ValueSet/intended-venue",
            "code" : "ec",
            "display" : "EC"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "purpose" : "UNKNOWN",
  "usage" : "HIV viral load data should be captured either as a numeric value or as a character/text value, depending on whether a given viral load result falls above or below the lab's lower limit of detection. For viral loads at or above the lower limit of detection, the viral load should be captured as a numeric value (expressed as the number of copies/mL). For viral loads below the lower limit of detection, the viral load should be populated with a character/text value equivalent to \"Below lower limit of detection.\" The EHR need not record this character value using this exact wording (for example, the character value could be recorded as \"<20 copies/mL\" or \"not detected\"), but values below the lower limit of detection should be documented to allow the submitter to accurately map them to a value of \"Below lower limit of detection\" for reporting purposes.\n\nThis eCQM is a patient-based measure.\n\nThis FHIR-based measure has been derived from the QDM-based measure: CMS314v1. \n\nPlease refer to the HL7 QI-Core Implementation Guide (http://hl7.org/fhir/us/qicore/index.html) for more information on QI-Core and mapping recommendations from QDM to QI-Core 4.1.1 (http://hl7.org/fhir/us/qicore/qdm-to-qicore.html).",
  "copyright" : "This measure was developed by the Health Resources & Services Administration (HRSA) of the U.S. Department of Health & Human Services (HHS). It is in the public domain.\n\nCitation of HRSA as the source of the original measure is appreciated. Any modified versions may not be represented as approved, endorsed, or authorized by HRSA or HHS. 42 U.S.C. Section 1320b-10. Users of modified versions should clearly explain how they deviate from HRSA's original measure.\n\nLimited proprietary coding is contained in the Measure specifications for user convenience. Users of proprietary code sets should obtain all necessary licenses from the owners of the code sets. \n\nCPT(R) contained in the Measure specifications is copyright 2004-2022 American Medical Association. LOINC(R) is copyright 2004-2022 Regenstrief Institute, Inc. This material contains SNOMED Clinical Terms(R) (SNOMED CT[R]) copyright 2004-2022 International Health Terminology Standards Development Organisation. ICD-10 is copyright 2022 World Health Organization. All Rights Reserved.\n\nDue to technical limitations, registered trademarks are indicated by (R) or [R] and unregistered trademarks are indicated by (TM) or [TM].",
  "approvalDate" : "2023-08-14",
  "lastReviewDate" : "2023-08-14",
  "effectivePeriod" : {
    "start" : "2024-01-01",
    "end" : "2024-12-31"
  },
  "author" : [
    {
      "name" : "Health Resources & Services Administration",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hrsa.gov/"
        }
      ]
    }
  ],
  "library" : [
    "http://somewhere.org/fhir/uv/mycontentig/Library/HIVViralSuppressionFHIRExample"
  ],
  "disclaimer" : "These performance measures are not clinical guidelines and do not establish a standard of medical care, and have not been tested for all potential applications.\n\nTHE MEASURES AND SPECIFICATIONS ARE PROVIDED \"AS IS\" WITHOUT WARRANTY OF ANY KIND.\n\nDue to technical limitations, registered trademarks are indicated by (R) or [R] and unregistered trademarks are indicated by (TM) or [TM].",
  "rationale" : "HIV is a communicable infection that leads to a progressive disease with a long asymptomatic period. Approximately 40,000 persons in the United States are newly infected with HIV each year (Centers for Disease Control and Prevention, 2021, p. 51). Without treatment, most persons develop acquired immunodeficiency syndrome (AIDS) within 10 years of HIV infection.\n\nHIV viral suppression is a long-standing priority outcome among the HIV community in the United States and around the world. The National HIV/AIDS Strategy for the United States from 2022-2025, developed by the White House Office of National AIDS Policy with input from the HIV community across the United States, prioritizes increasing HIV viral suppression rates to 95% (The White House, 2020). The DHHS Panel on Antiretroviral Guidelines for Adults and Adolescents defines viral suppression as a viral load below the lower limits of detection in its guidelines on virologic failure, and it defines viral suppression as a viral load of less than 200 copies/mL as part of its guidelines for the use of antiretroviral therapy to prevent HIV transmission (Panel on Antiretroviral Guidelines for Adults and Adolescents, 2022).\n\nAntiretroviral therapy (ART) delays the progression to AIDS and increases the length of survival. ART reduces HIV-associated morbidity and mortality by maximally inhibiting HIV replication to achieve viral suppression (Hogg et al., 2001; Lundgern et al., 2015). ART has also been shown to reduce transmission of HIV (Rodger et al., 2019). Studies show disparities in rates of viral suppression by race and ethnicity among MSM and among women, with Black and Hispanic or Latino/a study participants having lower rates of viral suppression than White participants (Buchacz et al., 2020; Buchacz et al., 2018; Geter et al., 2018). This measure will help providers direct their attention and quality improvement efforts towards improving HIV viral suppression rates.",
  "clinicalRecommendationStatement" : "Adult guidelines:\n\"The primary goal of antiretroviral therapy (ART) is to prevent HIV-associated morbidity and mortality. This goal is accomplished by using effective ART to achieve and maintain a plasma HIV-1 RNA (viral load) below the quantification limits of commercially available assays. Durable viral suppression improves immune function and overall quality of life, lowers the risk of both AIDS-defining and non-AIDS–defining complications, and allows persons with HIV to live a lifespan approaching that of persons without HIV\" (Panel on Antiretroviral Guidelines for Adults and Adolescents, 2022, p. E-1).\n\n\"ART is recommended for all individuals with HIV to reduce the morbidity and mortality associated with HIV infection and to prevent HIV transmission to sexual partners and infants (AI). ART should be initiated as soon as possible after HIV diagnosis (AI)\" (Panel on Antiretroviral Guidelines for Adults and Adolescents, 2022, p. E-2).\n\n\"The guidelines and the AIDS Clinical Trials Group (ACTG) now define virologic failure as a confirmed viral load >200 copies/mL- a threshold that eliminates most cases of apparent viremia caused by viral load blips or assay variability\" (Panel on Antiretroviral Guidelines for Adults and Adolescents, 2022, p. C-6).\n\n\"Individuals who are adherent to their ARV regimen and do not harbor resistance mutations to the component drugs can generally achieve suppression 8 to 24 weeks after ART initiation; rarely, in some patients it may take longer\" (Panel on Antiretroviral Guidelines for Adults and Adolescents, 2022, p. C-6).\n\nPediatric guidelines: \n\"Based on accumulated experience with currently available assays, the current definition of virologic suppression is a plasma viral load below the detection limit of the assay used (generally <20 to 75 copies/mL)\" (Panel on Antiretroviral Therapy and Medical Management of Children Living with HIV, 2022, p. D-5).\n\n\"Temporary viral load elevations (\"blips\") that are between the level of detection and 200 copies/mL to 500 copies/mL are often detected in adults and children who are on ART; these temporary elevations do not represent virologic failure, as long as the values have returned to below the level of detection when testing is repeated\" (Panel on Antiretroviral Therapy and Medical Management of Children Living with HIV, 2022, p. D-5).",
  "group" : [
    {
      "id" : "64873a03be23a058642d5816",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-scoring",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-scoring",
                "code" : "proportion",
                "display" : "Proportion"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-populationBasis",
          "valueCode" : "boolean"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-type",
                "code" : "outcome",
                "display" : "Outcome"
              }
            ]
          }
        }
      ],
      "population" : [
        {
          "id" : "DF999E50-BAB8-409F-922D-E8FA0E0BD92E",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "initial-population",
                "display" : "Initial Population"
              }
            ]
          },
          "description" : "All patients, regardless of age, diagnosed with HIV prior to or during the first 90 days of the measurement period with at least one eligible encounter in the first 240 days of the measurement period",
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Initial Population"
          }
        },
        {
          "id" : "2D69A89B-E60C-4878-B1DD-9F27450D603B",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator",
                "display" : "Denominator"
              }
            ]
          },
          "description" : "Equals Initial Population",
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Denominator"
          }
        },
        {
          "id" : "02767a1a-3174-47b6-8c31-84e10114824f",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator-exclusion",
                "display" : "Denominator Exclusion"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier"
          }
        },
        {
          "id" : "E492BC05-FD48-4459-8574-5CF67CC14C66",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "numerator",
                "display" : "Numerator"
              }
            ]
          },
          "description" : "Patients with a last HIV viral load test result of less than 200 copies/mL during the measurement period",
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Numerator"
          }
        },
        {
          "id" : "c5d8edbc-2566-4a49-b298-f39723e037c6",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "numerator-exclusion",
                "display" : "Numerator Exclusion"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier"
          }
        },
        {
          "id" : "4e8d7586-8625-42d1-9cff-c02d3d4b87f3",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator-exception",
                "display" : "Denominator Exception"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier"
          }
        }
      ]
    }
  ]
}

```
