# Home - dQM QICore Content Implementation Guide v2026.0.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://madie.cms.gov/ImplementationGuide/cms.madie | *Version*:2026.0.0 |
| Draft as of 2025-12-02 | *Computable Name*:DQMContentQICore |

### Introduction

This implementation guide is a collection of draft FHIR-based electronic Clinical Quality Measures (eCQM) that conform to the [FHIR Quality Measure IG](http://hl7.org/fhir/us/cqfmeasures)

> NOTE: The measures in this implementation guide are works in progress and should not be considered final specifications or recommendations for guidance. The examples will help guide and direct the process of finding conventions and usage patterns that meet the needs of the various stakeholders in the measure development community.

### Content

This implementation guides contains electronic Clinical Quality Measure (eCQM) specifications, published as FHIR Measure and Library resources.

For a complete listing of the Measures in this IG, refer to the [Measures](measures.md) page.

### Dependencies

### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (cms.madie.r4)](package.r4.tgz) and [R4B (cms.madie.r4b)](package.r4b.tgz) are available.

### Global Profiles

Global Profiles:

* **Type**: [Encounter](http://hl7.org/fhir/R4/encounter.html)
  * **Source**: [hl7.fhir.us.qicore#current](https://build.fhir.org/ig/HL7/fhir-qi-core/)
  * **Profile**: [QICore Encounter](https://build.fhir.org/ig/HL7/fhir-qi-core/StructureDefinition-qicore-encounter.html)
* **Type**: [Immunization](http://hl7.org/fhir/R4/immunization.html)
  * **Source**: [hl7.fhir.us.qicore#current](https://build.fhir.org/ig/HL7/fhir-qi-core/)
  * **Profile**: [QICore Immunization](https://build.fhir.org/ig/HL7/fhir-qi-core/StructureDefinition-qicore-immunization.html)
* **Type**: [Observation](http://hl7.org/fhir/R4/observation.html)
  * **Source**: [hl7.fhir.us.qicore#current](https://build.fhir.org/ig/HL7/fhir-qi-core/)
  * **Profile**: [QICore Simple Observation](https://build.fhir.org/ig/HL7/fhir-qi-core/StructureDefinition-qicore-simple-observation.html)
* **Type**: [Organization](http://hl7.org/fhir/R4/organization.html)
  * **Source**: [hl7.fhir.us.qicore#current](https://build.fhir.org/ig/HL7/fhir-qi-core/)
  * **Profile**: [QICore Organization](https://build.fhir.org/ig/HL7/fhir-qi-core/StructureDefinition-qicore-organization.html)
* **Type**: [Patient](http://hl7.org/fhir/R4/patient.html)
  * **Source**: [hl7.fhir.us.qicore#current](https://build.fhir.org/ig/HL7/fhir-qi-core/)
  * **Profile**: [QICore Patient](https://build.fhir.org/ig/HL7/fhir-qi-core/StructureDefinition-qicore-patient.html)
* **Type**: [Practitioner](http://hl7.org/fhir/R4/practitioner.html)
  * **Source**: [hl7.fhir.us.qicore#current](https://build.fhir.org/ig/HL7/fhir-qi-core/)
  * **Profile**: [QICore Practitioner](https://build.fhir.org/ig/HL7/fhir-qi-core/StructureDefinition-qicore-practitioner.html)
* **Type**: [PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html)
  * **Source**: [hl7.fhir.us.qicore#current](https://build.fhir.org/ig/HL7/fhir-qi-core/)
  * **Profile**: [QICore PractitionerRole](https://build.fhir.org/ig/HL7/fhir-qi-core/StructureDefinition-qicore-practitionerrole.html)

All resources of these types must conform to these profiles.

### IP Statements

This publication includes IP covered under the following statements.

* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [AdvancedIllnessandFrailty](Library-AdvancedIllnessandFrailty.md), [Hospice](Library-Hospice.md) and [PalliativeCare](Library-PalliativeCare.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [LibraryType](http://terminology.hl7.org/7.0.1/CodeSystem-library-type.html): [AdultOutpatientEncounters](Library-AdultOutpatientEncounters.md), [AdvancedIllnessandFrailty](Library-AdvancedIllnessandFrailty.md)...Show 15 more,[BreastCancerScreeningDQMDraft](Library-BreastCancerScreeningDQMDraft.md),[C4BBCommon](Library-C4BBCommon.md),[Hospice](Library-Hospice.md),[Measure/BreastCancerScreeningDQMDraft](Measure-BreastCancerScreeningDQMDraft.md),[Measure/StratificationEncounterExample](Measure-StratificationEncounterExample.md),[Measure/StratificationPatientExample](Measure-StratificationPatientExample.md),[Measure/SupportingEvidenceExample](Measure-SupportingEvidenceExample.md),[PalliativeCare](Library-PalliativeCare.md),[PatientCommon](Library-PatientCommon.md),[QICoreCommon](Library-QICoreCommon.md),[Status](Library-Status.md),[StratificationEncounterExample](Library-StratificationEncounterExample.md),[StratificationPatientExample](Library-StratificationPatientExample.md),[SupplementalDataElements](Library-SupplementalDataElements.md)and[SupportingEvidenceExample](Library-SupportingEvidenceExample.md)
* [Measure Population Type](http://terminology.hl7.org/7.0.1/CodeSystem-measure-population.html): [Measure/BreastCancerScreeningDQMDraft](Measure-BreastCancerScreeningDQMDraft.md), [Measure/StratificationEncounterExample](Measure-StratificationEncounterExample.md), [Measure/StratificationPatientExample](Measure-StratificationPatientExample.md) and [Measure/SupportingEvidenceExample](Measure-SupportingEvidenceExample.md)


