#  - dQM QICore Content Implementation Guide v2026.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* ****

## Measure: 

| | |
| :--- | :--- |
| *Official URL*:https://madie.cms.gov/Measure/StratificationEncounterExample | *Version*:2026.0.0 |
| Draft as of 2026-01-20 | *Computable Name*: |

* Metadata: Version
  * ?: 2026.0.0
* Metadata: Status
  * ?: Draft
* Metadata: Measure Scoring
  * ?: proportion from[http://hl7.org/fhir/measure-scoring](http://hl7.org/fhir/measure-scoring)
* Metadata: Measure Group (Rate) (ID: group-1)
* Metadata: Basis
  * ?: Encounter
* Metadata: Initial Population
  * ?: **ID**: initial-population**Description**: No description provided**Criteria**:[Initial Population](#group-1-initial-population)
* Metadata: Denominator
  * ?: **ID**: denominator**Description**: No description provided**Criteria**:[Denominator](#group-1-denominator)
* Metadata: Numerator
  * ?: **ID**: numerator**Description**: No description provided**Criteria**:[Numerator](#group-1-numerator)
* Metadata: Stratifier
  * ?: **Code**:Criteria-based Age Range Stratifier, 0 to 20 years
* Metadata: Stratifier
  * ?: **Code**:Criteria-based Age Range Stratifier, 21 to 40 years
* Metadata: Stratifier
  * ?: **Code**:Criteria-based Age Range Stratifier, 41+ years
* Metadata: Stratifier
  * ?: **Code**:Value-based Gender and Age Range Stratifier
* Metadata: Measure Logic
* Metadata: Primary Library
  * ?: [Stratification Encounter Example](Library-StratificationEncounterExample.md)
* Metadata: Contents
  * ?: **[Population Criteria](#population-criteria)****[Logic Definitions](#definitions)****[Terminology](#terminology)****[Dependencies](#dependencies)****[Data Requirements](#data-requirements)**
* Metadata: Population Criteria
* Metadata: Measure Group (Rate) (ID: group-1)
* Metadata: Initial Population
* Metadata: ````define "Initial Population": "Well-Visit Encounter"````[**Definition**](#stratificationencounterexample-initial-population)
* Metadata: Denominator
* Metadata: ````define "Denominator": "Well-Visit Encounter"````[**Definition**](#stratificationencounterexample-denominator)
* Metadata: Numerator
* Metadata: ````define "Numerator": "Well-Visit Encounter" E with "Blood Pressure Observation" O such that O.issued during E.period````[**Definition**](#stratificationencounterexample-numerator)
* Metadata: Stratifier
* Metadata: ````/* Criteria-based Stratification */ define "Stratifier P0Y--P21Y": "Well-Visit Encounter" E where Patient.ageInYearsAt(end of E.period) between 0 and 20````[**Definition**](#stratificationencounterexample-stratifier-p0y--p21y)
* Metadata: Stratifier
* Metadata: ````define "Stratifier P21Y--P41Y": "Well-Visit Encounter" E where Patient.ageInYearsAt(end of E.period) between 21 and 40````[**Definition**](#stratificationencounterexample-stratifier-p21y--p41y)
* Metadata: Stratifier
* Metadata: ````define "Stratifier P41Y--P9999Y": "Well-Visit Encounter" E where Patient.ageInYearsAt(end of E.period) >= 41````[**Definition**](#stratificationencounterexample-stratifier-p41y--p9999y)
* Metadata: Logic Definitions
* Metadata: Logic Definition
  * ?: **Library Name:**StratificationEncounterExample
* Metadata: ````define "Well-Visit Encounter": [Encounter] E where E.status = 'finished' and E.period ends during day of "Measurement Period"````
* Metadata: Logic Definition
  * ?: **Library Name:**StratificationEncounterExample
* Metadata: ````define "Blood Pressure Observation": [Observation] O where O.status in { 'final', 'amended', 'corrected' } and O.issued during day of "Measurement Period"````
* Metadata: Logic Definition
  * ?: **Library Name:**StratificationEncounterExample
* Metadata: ````define "Numerator": "Well-Visit Encounter" E with "Blood Pressure Observation" O such that O.issued during E.period````
* Metadata: Logic Definition
  * ?: **Library Name:**StratificationEncounterExample
* Metadata: ````define "Stratifier P21Y--P41Y": "Well-Visit Encounter" E where Patient.ageInYearsAt(end of E.period) between 21 and 40````
* Metadata: Logic Definition
  * ?: **Library Name:**StratificationEncounterExample
* Metadata: ````define "Denominator": "Well-Visit Encounter"````
* Metadata: Logic Definition
  * ?: **Library Name:**StratificationEncounterExample
* Metadata: ````/* Criteria-based Stratification */ define "Stratifier P0Y--P21Y": "Well-Visit Encounter" E where Patient.ageInYearsAt(end of E.period) between 0 and 20````
* Metadata: Logic Definition
  * ?: **Library Name:**StratificationEncounterExample
* Metadata: ````define "Initial Population": "Well-Visit Encounter"````
* Metadata: Logic Definition
  * ?: **Library Name:**StratificationEncounterExample
* Metadata: ````define "Stratifier P41Y--P9999Y": "Well-Visit Encounter" E where Patient.ageInYearsAt(end of E.period) >= 41````
* Metadata: Logic Definition
  * ?: **Library Name:**PatientCommon
* Metadata: ````/* @description: Returns the age in years of the patient, as of the given date @comment: This function returns the number of whole calendar years between the patient birth date and the given date. Regardless of whether the patient has a birthTime, the calculation is performed using only the birth date. If the given date has a time component, it is ignored, on the grounds that birth time is almost universally not considered when determining age in years. */ define fluent function ageInYearsAt(patient Patient, asOf DateTime): CalculateAgeInYearsAt(Patient.birthDate, date from asOf)````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````define function ToString(value EncounterStatus): value.value````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````/* @description: Converts the given [Period](https://hl7.org/fhir/datatypes.html#Period) value to a CQL DateTime Interval @comment: If the start value of the given period is unspecified, the starting boundary of the resulting interval will be open (meaning the start of the interval is unknown, as opposed to interpreted as the beginning of time). */ define function ToInterval(period FHIR.Period): if period is null then null else if period."start" is null then Interval(period."start".value, period."end".value] else Interval[period."start".value, period."end".value]````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````define function ToString(value ObservationStatus): value.value````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````define function ToDateTime(value instant): value.value````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````define function ToDate(value date): value.value````
* Metadata: Terminology
* Metadata: Terminology
  * ?: None
* Metadata: Dependencies
* Metadata: Dependency
  * ?: None
* Metadata: Data Requirements
* Metadata: Data Requirement
  * ?: **Type**: Observation**Profile(s)**:[Observation](http://hl7.org/fhir/R4/observation.html)**Must Support Elements**: status, issued
* Metadata: Data Requirement
  * ?: **Type**: Patient**Profile(s)**:[Patient](http://hl7.org/fhir/R4/patient.html)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[Encounter](http://hl7.org/fhir/R4/encounter.html)**Must Support Elements**: status, period
* Metadata: Generated using version 0.5.0 of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Measure",
  "id" : "StratificationEncounterExample",
  "contained" : [
    {
      "resourceType" : "Library",
      "id" : "effective-data-requirements",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "StratificationEncounterExample"
            },
            {
              "url" : "name",
              "valueString" : "Well-Visit Encounter"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Well-Visit Encounter\":\n  [Encounter] E\n    where E.status = 'finished'\n      and E.period ends during day of \"Measurement Period\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 0
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "StratificationEncounterExample"
            },
            {
              "url" : "name",
              "valueString" : "Blood Pressure Observation"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Blood Pressure Observation\":\n  [Observation] O\n    where O.status in { 'final', 'amended', 'corrected' }\n      and O.issued during day of \"Measurement Period\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 1
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "StratificationEncounterExample"
            },
            {
              "url" : "name",
              "valueString" : "Numerator"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Numerator\":\n  \"Well-Visit Encounter\" E\n    with \"Blood Pressure Observation\" O\n      such that O.issued during E.period"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 2
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "StratificationEncounterExample"
            },
            {
              "url" : "name",
              "valueString" : "Stratifier P21Y--P41Y"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Stratifier P21Y--P41Y\":\n  \"Well-Visit Encounter\" E\n    where Patient.ageInYearsAt(end of E.period) between 21 and 40"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 3
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "StratificationEncounterExample"
            },
            {
              "url" : "name",
              "valueString" : "Denominator"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Denominator\":\n  \"Well-Visit Encounter\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 4
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "StratificationEncounterExample"
            },
            {
              "url" : "name",
              "valueString" : "Stratifier P0Y--P21Y"
            },
            {
              "url" : "statement",
              "valueString" : "/* Criteria-based Stratification */\n\ndefine \"Stratifier P0Y--P21Y\":\n  \"Well-Visit Encounter\" E\n    where Patient.ageInYearsAt(end of E.period) between 0 and 20"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 5
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "StratificationEncounterExample"
            },
            {
              "url" : "name",
              "valueString" : "Initial Population"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Initial Population\":\n  \"Well-Visit Encounter\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 6
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "StratificationEncounterExample"
            },
            {
              "url" : "name",
              "valueString" : "Stratifier P41Y--P9999Y"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Stratifier P41Y--P9999Y\":\n  \"Well-Visit Encounter\" E\n    where Patient.ageInYearsAt(end of E.period) >= 41"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 7
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToString"
            },
            {
              "url" : "statement",
              "valueString" : "define function ToString(value EncounterStatus): value.value"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 8
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToInterval"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Converts the given [Period](https://hl7.org/fhir/datatypes.html#Period)\nvalue to a CQL DateTime Interval\n@comment: If the start value of the given period is unspecified, the starting\nboundary of the resulting interval will be open (meaning the start of the interval\nis unknown, as opposed to interpreted as the beginning of time).\n*/\ndefine function ToInterval(period FHIR.Period):\n    if period is null then\n        null\n    else\n        if period.\"start\" is null then\n            Interval(period.\"start\".value, period.\"end\".value]\n        else\n            Interval[period.\"start\".value, period.\"end\".value]"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 9
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToString"
            },
            {
              "url" : "statement",
              "valueString" : "define function ToString(value ObservationStatus): value.value"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 10
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToDateTime"
            },
            {
              "url" : "statement",
              "valueString" : "define function ToDateTime(value instant): value.value"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 11
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "PatientCommon"
            },
            {
              "url" : "name",
              "valueString" : "ageInYearsAt"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Returns the age in years of the patient, as of the given date\n@comment: This function returns the number of whole calendar years between the patient birth \ndate and the given date. Regardless of whether the patient has a birthTime, the calculation is\nperformed using only the birth date. If the given date has a time component, it is ignored, on \nthe grounds that birth time is almost universally not considered when determining age in years.\n*/\ndefine fluent function ageInYearsAt(patient Patient, asOf DateTime):\n  CalculateAgeInYearsAt(Patient.birthDate, date from asOf)"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 12
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToDate"
            },
            {
              "url" : "statement",
              "valueString" : "define function ToDate(value date): value.value"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 13
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        }
      ],
      "name" : "EffectiveDataRequirements",
      "status" : "active",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/library-type",
            "code" : "module-definition"
          }
        ]
      },
      "relatedArtifact" : [
        {
          "type" : "depends-on",
          "display" : "FHIR model information",
          "resource" : "http://hl7.org/fhir/uv/cql/Library/FHIR-ModelInfo|4.0.1"
        },
        {
          "type" : "depends-on",
          "display" : "Library FHIRHelpers",
          "resource" : "http://hl7.org/fhir/uv/cql/Library/FHIRHelpers|4.0.1"
        },
        {
          "type" : "depends-on",
          "display" : "Library PatientCommon",
          "resource" : "https://madie.cms.gov/Library/PatientCommon"
        },
        {
          "type" : "depends-on",
          "display" : "Library FHIRHelpers",
          "resource" : "http://hl7.org/fhir/uv/cql/Library/FHIRHelpers|4.0.1"
        }
      ],
      "parameter" : [
        {
          "name" : "Measurement Period",
          "use" : "in",
          "min" : 0,
          "max" : "1",
          "type" : "Period"
        },
        {
          "name" : "Numerator",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "type" : "Encounter"
        },
        {
          "name" : "Stratifier P21Y--P41Y",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "type" : "Encounter"
        },
        {
          "name" : "Denominator",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "type" : "Encounter"
        },
        {
          "name" : "Stratifier P0Y--P21Y",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "type" : "Encounter"
        },
        {
          "name" : "Initial Population",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "type" : "Encounter"
        },
        {
          "name" : "Stratifier P41Y--P9999Y",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "type" : "Encounter"
        }
      ],
      "dataRequirement" : [
        {
          "type" : "Encounter",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Encounter"],
          "mustSupport" : ["status", "period"]
        },
        {
          "type" : "Observation",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Observation"],
          "mustSupport" : ["status", "issued"]
        },
        {
          "type" : "Observation",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Observation"],
          "mustSupport" : ["status", "issued"]
        },
        {
          "type" : "Encounter",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Encounter"],
          "mustSupport" : ["status", "period"]
        },
        {
          "type" : "Patient",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Patient"]
        },
        {
          "type" : "Patient",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Patient"]
        },
        {
          "type" : "Encounter",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Encounter"],
          "mustSupport" : ["status", "period"]
        },
        {
          "type" : "Encounter",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Encounter"],
          "mustSupport" : ["status", "period"]
        },
        {
          "type" : "Encounter",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Encounter"],
          "mustSupport" : ["status", "period"]
        },
        {
          "type" : "Encounter",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Encounter"],
          "mustSupport" : ["status", "period"]
        },
        {
          "type" : "Encounter",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Encounter"],
          "mustSupport" : ["status", "period"]
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-effectiveDataRequirements",
      "valueCanonical" : "#effective-data-requirements"
    }
  ],
  "url" : "https://madie.cms.gov/Measure/StratificationEncounterExample",
  "version" : "2026.0.0",
  "status" : "draft",
  "date" : "2026-01-20T14:56:48+00:00",
  "library" : [
    "https://madie.cms.gov/Library/StratificationEncounterExample"
  ],
  "scoring" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/measure-scoring",
        "code" : "proportion"
      }
    ]
  },
  "group" : [
    {
      "id" : "group-1",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-populationBasis",
          "valueCode" : "Encounter"
        }
      ],
      "population" : [
        {
          "id" : "initial-population",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "initial-population",
                "display" : "Initial Population"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Initial Population"
          }
        },
        {
          "id" : "denominator",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator",
                "display" : "Denominator"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Denominator"
          }
        },
        {
          "id" : "numerator",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "numerator",
                "display" : "Numerator"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Numerator"
          }
        }
      ],
      "stratifier" : [
        {
          "code" : {
            "text" : "Criteria-based Age Range Stratifier, 0 to 20 years"
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Stratifier P0Y--P21Y"
          }
        },
        {
          "code" : {
            "text" : "Criteria-based Age Range Stratifier, 21 to 40 years"
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Stratifier P21Y--P41Y"
          }
        },
        {
          "code" : {
            "text" : "Criteria-based Age Range Stratifier, 41+ years"
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Stratifier P41Y--P9999Y"
          }
        },
        {
          "code" : {
            "text" : "Value-based Gender and Age Range Stratifier"
          },
          "component" : [
            {
              "code" : {
                "text" : "Value-based Gender Component Stratifier"
              },
              "criteria" : {
                "language" : "text/cql-identifier",
                "expression" : "Gender Stratifier"
              }
            },
            {
              "code" : {
                "text" : "Value-based Age Range Component Stratifier"
              },
              "criteria" : {
                "language" : "text/cql-identifier",
                "expression" : "Age Range Stratifier"
              }
            }
          ]
        }
      ]
    }
  ]
}

```
