# Artifacts Summary - dQM QICore Content Implementation Guide v2026.0.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Knowledge Artifacts: Measure 

These define measures as part of content in this implementation guide.

| |
| :--- |
| [Measure/BreastCancerScreeningDQMDraft](Measure-BreastCancerScreeningDQMDraft.md) |
| [Measure/StratificationEncounterExample](Measure-StratificationEncounterExample.md) |
| [Measure/StratificationPatientExample](Measure-StratificationPatientExample.md) |
| [Measure/SupportingEvidenceExample](Measure-SupportingEvidenceExample.md) |

### Knowledge Artifacts: Libraries 

These define logic, asset collections and other libraries as part of content in this implementation guide.

| | |
| :--- | :--- |
| [Adult Outpatient Encounters](Library-AdultOutpatientEncounters.md) | Adult outpatient encounters logic. |
| [Advanced Illness and Frailty](Library-AdvancedIllnessandFrailty.md) | AdvancedIllnessandFrailty logic. |
| [Breast Cancer Screening DQM Draft](Library-BreastCancerScreeningDQMDraft.md) | BreastCancerScreeningDQMDraft logic. |
| [Carin Blue Button Common](Library-C4BBCommon.md) | Common terminologies and functions used in Carin Blue Button CQL artifacts. |
| [Hospice](Library-Hospice.md) | Hospice logic. |
| [Palliative Care](Library-PalliativeCare.md) | PalliativeCare logic. |
| [Patient Common](Library-PatientCommon.md) | PatientCommon logic. |
| [QI Core Common](Library-QICoreCommon.md) | Common terminologies and functions used in QICore-based CQL artifacts. |
| [Status](Library-Status.md) | Status logic. |
| [Stratification Encounter Example](Library-StratificationEncounterExample.md) | StratificationEncounterExample logic. |
| [Stratification Patient Example](Library-StratificationPatientExample.md) | StratificationPatientExample logic. |
| [Supplemental Data Elements](Library-SupplementalDataElements.md) | SupplementalDataElements logic. |
| [Supporting Evidence Example](Library-SupportingEvidenceExample.md) | SupportingEvidenceExample logic. |

### Other 

These are resources that are used within this implementation guide that do not fit into one of the other categories.

| | |
| :--- | :--- |
| [Input Expansion Parameters](Parameters-manifest.md) | The input expansion parameters resource for this implementation guide, specifying SNOMED Edition and version. This resource will be contained within the published implementation guide with all pinned references. |

