#  - dQM QICore Content Implementation Guide v2026.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* ****

## Measure: 

| | |
| :--- | :--- |
| *Official URL*:https://madie.cms.gov/Measure/SupportingEvidenceExample | *Version*:2026.0.0 |
| Draft as of 2026-01-20 | *Computable Name*: |

* Metadata: Version
  * ?: 2026.0.0
* Metadata: Status
  * ?: Draft
* Metadata: Measure Scoring
  * ?: ratio from[http://hl7.org/fhir/measure-scoring](http://hl7.org/fhir/measure-scoring)
* Metadata: Measure Group (Rate) (ID: group-1)
* Metadata: Basis
  * ?: boolean
* Metadata: Initial Population
  * ?: **ID**: initial-population**Description**: No description provided**Criteria**:[Initial Population Boolean](#group-1-initial-population)
* Metadata: Denominator
  * ?: **ID**: denominator**Description**: No description provided**Criteria**:[Denominator Boolean](#group-1-denominator)
* Metadata: Denominator-Exclusion
  * ?: **ID**: denominator-exclusion**Description**: No description provided**Criteria**:[Denominator Exclusion Boolean](#group-1-denominator-exclusion)
* Metadata: Numerator Exclusion
  * ?: **ID**: numerator-exclusion**Description**: No description provided**Criteria**:[Numerator Exclusion Boolean](#group-1-numerator-exclusion)
* Metadata: Numerator
  * ?: **ID**: numerator**Description**: No description provided**Criteria**:[Numerator Boolean](#group-1-numerator)
* Metadata: Measure Logic
* Metadata: Primary Library
  * ?: [Supporting Evidence Example](Library-SupportingEvidenceExample.md)
* Metadata: Contents
  * ?: **[Population Criteria](#population-criteria)****[Logic Definitions](#definitions)****[Terminology](#terminology)****[Dependencies](#dependencies)****[Data Requirements](#data-requirements)**
* Metadata: Population Criteria
* Metadata: Measure Group (Rate) (ID: group-1)
* Metadata: Initial Population
* Metadata: ````// boolean population results // has matching encounter define "Initial Population Boolean": exists "All Encounters"````[**Definition**](#supportingevidenceexample-initial-population-boolean)
* Metadata: Denominator
* Metadata: ````define "Denominator Boolean": "Initial Population Boolean"````[**Definition**](#supportingevidenceexample-denominator-boolean)
* Metadata: Denominator-Exclusion
* Metadata: ````define "Denominator Exclusion Boolean": exists "Encounter Cancelled"````[**Definition**](#supportingevidenceexample-denominator-exclusion-boolean)
* Metadata: Numerator Exclusion
* Metadata: ````define "Numerator Exclusion Boolean": exists "Encounter Arrived"````[**Definition**](#supportingevidenceexample-numerator-exclusion-boolean)
* Metadata: Numerator
* Metadata: ````define "Numerator Boolean": exists "Encounters in Period"````[**Definition**](#supportingevidenceexample-numerator-boolean)
* Metadata: Logic Definitions
* Metadata: Logic Definition
  * ?: **Library Name:**SupportingEvidenceExample
* Metadata: ````// main criteria logic define "All Encounters": [Encounter] E````
* Metadata: Logic Definition
  * ?: **Library Name:**SupportingEvidenceExample
* Metadata: ````// boolean population results // has matching encounter define "Initial Population Boolean": exists "All Encounters"````
* Metadata: Logic Definition
  * ?: **Library Name:**SupportingEvidenceExample
* Metadata: ````define "Denominator Boolean": "Initial Population Boolean"````
* Metadata: Logic Definition
  * ?: **Library Name:**SupportingEvidenceExample
* Metadata: ````define "Encounter Arrived": [Encounter] E where E.status = 'arrived'````
* Metadata: Logic Definition
  * ?: **Library Name:**SupportingEvidenceExample
* Metadata: ````define "Numerator Exclusion Boolean": exists "Encounter Arrived"````
* Metadata: Logic Definition
  * ?: **Library Name:**SupportingEvidenceExample
* Metadata: ````define "Encounters in Period": [Encounter] E where E.period during "Measurement Period" and E.status='finished'````
* Metadata: Logic Definition
  * ?: **Library Name:**SupportingEvidenceExample
* Metadata: ````define "Numerator Boolean": exists "Encounters in Period"````
* Metadata: Logic Definition
  * ?: **Library Name:**SupportingEvidenceExample
* Metadata: ````define "Encounter Cancelled": [Encounter] E where E.status = 'cancelled'````
* Metadata: Logic Definition
  * ?: **Library Name:**SupportingEvidenceExample
* Metadata: ````define "Denominator Exclusion Boolean": exists "Encounter Cancelled"````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````define function ToString(value EncounterStatus): value.value````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````/* @description: Converts the given [Period](https://hl7.org/fhir/datatypes.html#Period) value to a CQL DateTime Interval @comment: If the start value of the given period is unspecified, the starting boundary of the resulting interval will be open (meaning the start of the interval is unknown, as opposed to interpreted as the beginning of time). */ define function ToInterval(period FHIR.Period): if period is null then null else if period."start" is null then Interval(period."start".value, period."end".value] else Interval[period."start".value, period."end".value]````
* Metadata: Terminology
* Metadata: Terminology
  * ?: None
* Metadata: Dependencies
* Metadata: Dependency
  * ?: None
* Metadata: Data Requirements
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[Encounter](http://hl7.org/fhir/R4/encounter.html)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[Encounter](http://hl7.org/fhir/R4/encounter.html)**Must Support Elements**: period, status
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[Encounter](http://hl7.org/fhir/R4/encounter.html)**Must Support Elements**: status
* Metadata: Generated using version 0.5.0 of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Measure",
  "id" : "SupportingEvidenceExample",
  "contained" : [
    {
      "resourceType" : "Library",
      "id" : "effective-data-requirements",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupportingEvidenceExample"
            },
            {
              "url" : "name",
              "valueString" : "All Encounters"
            },
            {
              "url" : "statement",
              "valueString" : "// main criteria logic\n\ndefine \"All Encounters\":\n     [Encounter] E"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 0
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupportingEvidenceExample"
            },
            {
              "url" : "name",
              "valueString" : "Initial Population Boolean"
            },
            {
              "url" : "statement",
              "valueString" : "// boolean population results\n// has matching encounter\n\ndefine \"Initial Population Boolean\":\n  exists \"All Encounters\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 1
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupportingEvidenceExample"
            },
            {
              "url" : "name",
              "valueString" : "Denominator Boolean"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Denominator Boolean\":\n    \"Initial Population Boolean\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 2
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupportingEvidenceExample"
            },
            {
              "url" : "name",
              "valueString" : "Encounter Arrived"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Encounter Arrived\":\n    [Encounter] E\n       where E.status = 'arrived'"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 3
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupportingEvidenceExample"
            },
            {
              "url" : "name",
              "valueString" : "Numerator Exclusion Boolean"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Numerator Exclusion Boolean\":\n  exists \"Encounter Arrived\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 4
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupportingEvidenceExample"
            },
            {
              "url" : "name",
              "valueString" : "Encounters in Period"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Encounters in Period\":\n     [Encounter] E\n       where E.period during \"Measurement Period\" and E.status='finished'"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 5
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupportingEvidenceExample"
            },
            {
              "url" : "name",
              "valueString" : "Numerator Boolean"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Numerator Boolean\":\n  exists \"Encounters in Period\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 6
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupportingEvidenceExample"
            },
            {
              "url" : "name",
              "valueString" : "Encounter Cancelled"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Encounter Cancelled\":\n    [Encounter] E\n       where E.status = 'cancelled'"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 7
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupportingEvidenceExample"
            },
            {
              "url" : "name",
              "valueString" : "Denominator Exclusion Boolean"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Denominator Exclusion Boolean\":\n  exists \"Encounter Cancelled\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 8
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToString"
            },
            {
              "url" : "statement",
              "valueString" : "define function ToString(value EncounterStatus): value.value"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 9
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToInterval"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Converts the given [Period](https://hl7.org/fhir/datatypes.html#Period)\nvalue to a CQL DateTime Interval\n@comment: If the start value of the given period is unspecified, the starting\nboundary of the resulting interval will be open (meaning the start of the interval\nis unknown, as opposed to interpreted as the beginning of time).\n*/\ndefine function ToInterval(period FHIR.Period):\n    if period is null then\n        null\n    else\n        if period.\"start\" is null then\n            Interval(period.\"start\".value, period.\"end\".value]\n        else\n            Interval[period.\"start\".value, period.\"end\".value]"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 10
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        }
      ],
      "name" : "EffectiveDataRequirements",
      "status" : "active",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/library-type",
            "code" : "module-definition"
          }
        ]
      },
      "relatedArtifact" : [
        {
          "type" : "depends-on",
          "display" : "FHIR model information",
          "resource" : "http://hl7.org/fhir/uv/cql/Library/FHIR-ModelInfo|4.0.1"
        },
        {
          "type" : "depends-on",
          "display" : "Library FHIRHelpers",
          "resource" : "http://hl7.org/fhir/uv/cql/Library/FHIRHelpers|4.0.1"
        }
      ],
      "parameter" : [
        {
          "name" : "Measurement Period",
          "use" : "in",
          "min" : 0,
          "max" : "1",
          "type" : "Period"
        },
        {
          "name" : "Denominator Boolean",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "boolean"
        },
        {
          "name" : "Numerator Exclusion Boolean",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "boolean"
        },
        {
          "name" : "Initial Population Boolean",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "boolean"
        },
        {
          "name" : "Numerator Boolean",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "boolean"
        },
        {
          "name" : "Denominator Exclusion Boolean",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "boolean"
        }
      ],
      "dataRequirement" : [
        {
          "type" : "Encounter",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Encounter"]
        },
        {
          "type" : "Encounter",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Encounter"],
          "mustSupport" : ["status"]
        },
        {
          "type" : "Encounter",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Encounter"],
          "mustSupport" : ["period", "status"]
        },
        {
          "type" : "Encounter",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Encounter"],
          "mustSupport" : ["status"]
        },
        {
          "type" : "Encounter",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Encounter"]
        },
        {
          "type" : "Encounter",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Encounter"]
        },
        {
          "type" : "Encounter",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Encounter"],
          "mustSupport" : ["status"]
        },
        {
          "type" : "Encounter",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Encounter"],
          "mustSupport" : ["period", "status"]
        },
        {
          "type" : "Encounter",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/Encounter"],
          "mustSupport" : ["status"]
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-effectiveDataRequirements",
      "valueCanonical" : "#effective-data-requirements"
    }
  ],
  "url" : "https://madie.cms.gov/Measure/SupportingEvidenceExample",
  "version" : "2026.0.0",
  "status" : "draft",
  "date" : "2026-01-20T14:56:48+00:00",
  "library" : ["https://madie.cms.gov/Library/SupportingEvidenceExample"],
  "scoring" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/measure-scoring",
        "code" : "ratio"
      }
    ]
  },
  "group" : [
    {
      "id" : "group-1",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-populationBasis",
          "valueCode" : "boolean"
        }
      ],
      "population" : [
        {
          "id" : "initial-population",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "initial-population",
                "display" : "Initial Population"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Initial Population Boolean"
          }
        },
        {
          "id" : "denominator",
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "always-true",
                      "display" : "Always True"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is always true",
                "name" : "AlwaysTrue",
                "language" : "text/cql-identifier",
                "expression" : "always true"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "denominator-resource",
                      "display" : "Denominator Resource"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is a Denominator Resource",
                "name" : "DenominatorResource",
                "language" : "text/cql-identifier",
                "expression" : "Denominator Resource"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "list-of-boolean",
                      "display" : "List of Boolean"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is a list of boolean",
                "name" : "ListOfBoolean",
                "language" : "text/cql-identifier",
                "expression" : "list of boolean"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "string",
                      "display" : "String"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is a string",
                "name" : "String",
                "language" : "text/cql-identifier",
                "expression" : "string"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "date",
                      "display" : "Date"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is a date",
                "name" : "Date",
                "language" : "text/cql-identifier",
                "expression" : "date"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "decimal",
                      "display" : "Decimal"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is a decimal",
                "name" : "Decimal",
                "language" : "text/cql-identifier",
                "expression" : "decimal"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "number",
                      "display" : "Number"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is a number",
                "name" : "Number",
                "language" : "text/cql-identifier",
                "expression" : "number"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "list-of-dates",
                      "display" : "List of Dates"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is a list of dates",
                "name" : "ListOfDates",
                "language" : "text/cql-identifier",
                "expression" : "list of dates"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "list-of-numbers",
                      "display" : "List of Numbers"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is a list of numbers",
                "name" : "ListOfNumbers",
                "language" : "text/cql-identifier",
                "expression" : "list of numbers"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "list-of-string",
                      "display" : "List of String"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is a list of string",
                "name" : "ListOfString",
                "language" : "text/cql-identifier",
                "expression" : "list of string"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "test-tuple",
                      "display" : "Test Tuple"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is a tuple",
                "name" : "TestTuple",
                "language" : "text/cql-identifier",
                "expression" : "test tuple"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "interval",
                      "display" : "Interval"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is an interval",
                "name" : "Interval",
                "language" : "text/cql-identifier",
                "expression" : "interval"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "test-interval-list",
                      "display" : "Test Interval List"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is a list of intervals",
                "name" : "TestIntervalList",
                "language" : "text/cql-identifier",
                "expression" : "TestIntervalList"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "test-decimal-list",
                      "display" : "Test Decimal List"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is a list of decimals",
                "name" : "TestDecimalList",
                "language" : "text/cql-identifier",
                "expression" : "TestDecimalList"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "test-code",
                      "display" : "Test Code"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is a code",
                "name" : "TestCode",
                "language" : "text/cql-identifier",
                "expression" : "test code"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "empty-list-example",
                      "display" : "Empty List Example"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is an empty list",
                "name" : "EmptyListExample",
                "language" : "text/cql-identifier",
                "expression" : "EmptyListExample"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "null-example",
                      "display" : "Null Example"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is a null",
                "name" : "NullExample",
                "language" : "text/cql-identifier",
                "expression" : "NullExample"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "patient-resource",
                      "display" : "Patient Resource"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is a Patient Resource",
                "name" : "PatientResource",
                "language" : "text/cql-identifier",
                "expression" : "PatientRes"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/cqf-supportingEvidenceDefinition",
              "valueExpression" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expressionCode",
                    "valueCoding" : {
                      "system" : "http://example.org/fhir/CodeSystem/example-supporting-evidence-codes",
                      "code" : "list-test-tuple",
                      "display" : "List Test Tuple"
                    }
                  }
                ],
                "description" : "Example of supporting evidence that is a list of tuples",
                "name" : "ListTestTuple",
                "language" : "text/cql-identifier",
                "expression" : "list test tuple"
              }
            }
          ],
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator",
                "display" : "Denominator"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Denominator Boolean"
          }
        },
        {
          "id" : "denominator-exclusion",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator-exclusion",
                "display" : "Denominator-Exclusion"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Denominator Exclusion Boolean"
          }
        },
        {
          "id" : "numerator-exclusion",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "numerator-exclusion",
                "display" : "Numerator Exclusion"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Numerator Exclusion Boolean"
          }
        },
        {
          "id" : "numerator",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "numerator",
                "display" : "Numerator"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Numerator Boolean"
          }
        }
      ]
    }
  ]
}

```
