#  - dQM QICore Content Implementation Guide v2026.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* ****

## Measure: 

| | |
| :--- | :--- |
| *Official URL*:https://madie.cms.gov/Measure/BreastCancerScreeningDQMDraft | *Version*:2026.0.0 |
| Draft as of 2026-01-20 | *Computable Name*: |

* Metadata: Version
  * ?: 2026.0.0
* Metadata: Status
  * ?: Draft
* Metadata: Measure Scoring
  * ?: ratio from[http://hl7.org/fhir/measure-scoring](http://hl7.org/fhir/measure-scoring)
* Metadata: Measure Group (Rate) (ID: group-1)
* Metadata: Basis
  * ?: boolean
* Metadata: Initial Population
  * ?: **ID**: initial-population**Description**: No description provided**Criteria**:[Initial Population Boolean](#group-1-initial-population)
* Metadata: Denominator
  * ?: **ID**: denominator**Description**: No description provided**Criteria**:[Denominator Boolean](#group-1-denominator)
* Metadata: Denominator-Exclusion
  * ?: **ID**: denominator-exclusion**Description**: No description provided**Criteria**:[Denominator Exclusion Boolean](#group-1-denominator-exclusion)
* Metadata: Numerator Exclusion
  * ?: **ID**: numerator-exclusion**Description**: No description provided**Criteria**:[Numerator Exclusion Boolean](#group-1-numerator-exclusion)
* Metadata: Numerator
  * ?: **ID**: numerator**Description**: No description provided**Criteria**:[Numerator Boolean](#group-1-numerator)
* Metadata: Measure Logic
* Metadata: Primary Library
  * ?: [Breast Cancer Screening DQM Draft](Library-BreastCancerScreeningDQMDraft.md)
* Metadata: Contents
  * ?: **[Population Criteria](#population-criteria)****[Logic Definitions](#definitions)****[Terminology](#terminology)****[Dependencies](#dependencies)****[Data Requirements](#data-requirements)**
* Metadata: Population Criteria
* Metadata: Criteria
  * ?: None
* Metadata: Logic Definitions
* Metadata: Logic Definition
  * ?: None
* Metadata: Terminology
* Metadata: Terminology
  * ?: None
* Metadata: Dependencies
* Metadata: Dependency
  * ?: None
* Metadata: Data Requirements
* Metadata: Data Requirement
  * ?: None
* Metadata: Generated using version 0.5.0 of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Measure",
  "id" : "BreastCancerScreeningDQMDraft",
  "contained" : [
    {
      "resourceType" : "Library",
      "id" : "effective-data-requirements",
      "name" : "EffectiveDataRequirements",
      "status" : "active",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/library-type",
            "code" : "module-definition"
          }
        ]
      },
      "relatedArtifact" : [
        {
          "type" : "depends-on",
          "display" : "QICore model information",
          "resource" : "https://madie.cms.gov/Library/QICore-ModelInfo|7.0.2"
        },
        {
          "type" : "depends-on",
          "display" : "USCore model information",
          "resource" : "http://hl7.org/fhir/us/cql/Library/USCore-ModelInfo|7.0.0"
        },
        {
          "type" : "depends-on",
          "display" : "C4BB model information",
          "resource" : "https://madie.cms.gov/Library/C4BB-ModelInfo|2.1.1"
        },
        {
          "type" : "depends-on",
          "display" : "FHIR model information",
          "resource" : "http://hl7.org/fhir/uv/cql/Library/FHIR-ModelInfo|4.0.1"
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-effectiveDataRequirements",
      "valueCanonical" : "#effective-data-requirements"
    }
  ],
  "url" : "https://madie.cms.gov/Measure/BreastCancerScreeningDQMDraft",
  "version" : "2026.0.0",
  "status" : "draft",
  "date" : "2026-01-20T14:56:48+00:00",
  "library" : [
    "https://madie.cms.gov/Library/BreastCancerScreeningDQMDraft"
  ],
  "scoring" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/measure-scoring",
        "code" : "ratio"
      }
    ]
  },
  "group" : [
    {
      "id" : "group-1",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-populationBasis",
          "valueCode" : "boolean"
        }
      ],
      "population" : [
        {
          "id" : "initial-population",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "initial-population",
                "display" : "Initial Population"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Initial Population Boolean"
          }
        },
        {
          "id" : "denominator",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator",
                "display" : "Denominator"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Denominator Boolean"
          }
        },
        {
          "id" : "denominator-exclusion",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator-exclusion",
                "display" : "Denominator-Exclusion"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Denominator Exclusion Boolean"
          }
        },
        {
          "id" : "numerator-exclusion",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "numerator-exclusion",
                "display" : "Numerator Exclusion"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Numerator Exclusion Boolean"
          }
        },
        {
          "id" : "numerator",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "numerator",
                "display" : "Numerator"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Numerator Boolean"
          }
        }
      ]
    }
  ]
}

```
