# QI Core Common - dQM QICore Content Implementation Guide v2026.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QI Core Common**

## Library: QI Core Common 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://madie.cms.gov/Library/QICoreCommon | *Version*:2026.0.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:QICoreCommon |

 
Common terminologies and functions used in QICore-based CQL artifacts. 

* Metadata: Title
  * ?: QI Core Common
* Metadata: Version
  * ?: 2026.0.0
* Metadata: Topic
  * ?: FHIR
* Metadata: Topic
  * ?: CQL
* Metadata: Description
  * ?: Common terminologies and functions used in QICore-based CQL artifacts.
* Metadata: Type
  * ?: logic-library from[http://terminology.hl7.org/CodeSystem/library-type](http://terminology.hl7.org/7.0.1/CodeSystem-library-type.html)
* Metadata: Parameter
  * ?: **Name**: Patient**Use**: Out**Min Cardinality**: 0**Max Cardinality**: 1**Type**: Resource
* Metadata: Library Content
* Metadata: CQL Content
  * ?: ````/* @description: Common terminologies and functions used in QICore-based CQL artifacts @comment: Beginning with QICore STU7, the modelinfo included with the published IG is using [derived modelinfo](https://hl7.org/fhir/uv/cql/using-modelinfo.html#derived-modelinfo) to enable reuse of data elements and libraries defined in the [US Core](https://hl7.org/fhir/us/core) and [US CQL](https://hl7.org/fhir/us/cql) Common IGs. Most of the functionality defined in previous versions of this library are now either in [FHIRCommon](https://hl7.org/fhir/uv/cql/Library-FHIRCommon.html) or [USCoreCommon](https://hl7.org/fhir/us/cql/Library-USCoreCommon.html). NOTE: This library is not published in this IG, it is included here for convenience. The source of truth for this library will be the MADiE environment once it fully supports use of QICore STU7. */ library QICoreCommon version '5.0.0' using QICore version '7.0.2' include hl7.fhir.uv.cql.FHIRHelpers version '4.0.1' include hl7.fhir.uv.cql.FHIRCommon version '2.0.0' codesystem "TaskCodeSystem": 'http://hl7.org/fhir/CodeSystem/task-code' //Task codes code "Fulfill": 'fulfill' from "TaskCodeSystem" display 'Fulfill' context Patient /* @description: Creates a list of integers from 1 to how many days are in the interval. Note, this wont create an index for the final day if it is less than 24 hours. This also includes the first 24 hour period. */ define fluent function toDayNumbers(Period Interval<DateTime>): ( expand { Interval[1, duration in days between start of Period and end of Period]} ) DayNumber return end of DayNumber /* @description: Creates a list of 24 hour long intervals in an interval paired with the index (1 indexed) to which 24 hour interval it is. Note that the result will include intervals that are closed at the beginning and open at the end */ define fluent function daysInPeriod(Period Interval<DateTime>): ( Period.toDayNumbers()) DayIndex let startPeriod: start of Period + (24 hours * (DayIndex - 1)), endPeriod: if (hours between startPeriod and end of Period < 24) then startPeriod else start of Period + (24 hours * DayIndex) return Tuple { dayIndex: DayIndex, dayPeriod: Interval[startPeriod, endPeriod) } /* @description: Returns the sex element as defined for the USCore patient profile @comment: This should be in USCoreCommon (see https://jira.hl7.org/browse/FHIR-53939) */ define fluent function sex(patient Patient): patient.ext('http://hl7.org/fhir/us/core/StructureDefinition/us-core-sex').value as FHIR.code````
* Metadata: ELM XML Content
  * ?: ````Encoded data (38616 characters)````
* Metadata: ELM JSON Content
  * ?: ````Encoded data (69276 characters)````
* Metadata: Generated using version 0.5.0 of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Library",
  "id" : "QICoreCommon",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    }
  ],
  "url" : "https://madie.cms.gov/Library/QICoreCommon",
  "version" : "2026.0.0",
  "name" : "QICoreCommon",
  "title" : "QI Core Common",
  "status" : "active",
  "experimental" : false,
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/library-type",
        "code" : "logic-library"
      }
    ]
  },
  "date" : "2026-01-20T14:56:48+00:00",
  "description" : "Common terminologies and functions used in QICore-based CQL artifacts.",
  "topic" : [
    {
      "text" : "FHIR"
    },
    {
      "text" : "CQL"
    }
  ],
  "relatedArtifact" : [
    {
      "type" : "depends-on",
      "display" : "Model QICore",
      "resource" : "https://madie.cms.gov/Library/QICore-ModelInfo|7.0.2"
    },
    {
      "type" : "depends-on",
      "display" : "Library FHIRHelpers",
      "resource" : "http://hl7.org/fhir/uv/cql/Library/FHIRHelpers|4.0.1"
    },
    {
      "type" : "depends-on",
      "display" : "Library FHIRCommon",
      "resource" : "http://hl7.org/fhir/uv/cql/Library/FHIRCommon|2.0.0"
    },
    {
      "type" : "depends-on",
      "display" : "Code System TaskCodeSystem",
      "resource" : "http://hl7.org/fhir/CodeSystem/task-code"
    }
  ],
  "parameter" : [
    {
      "name" : "Patient",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "type" : "Resource"
    }
  ],
  "content" : [
    {
      "contentType" : "text/cql",
      "data" : "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"
    },
    {
      "contentType" : "application/elm+xml",
      "data" : "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"
    },
    {
      "contentType" : "application/elm+json",
      "data" : "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"
    }
  ]
}

```
