# Patient Common - dQM QICore Content Implementation Guide v2026.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient Common**

## Library: Patient Common 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://madie.cms.gov/Library/PatientCommon | *Version*:2026.0.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:PatientCommon |

 
PatientCommon logic. 

* Metadata: Title
  * ?: Patient Common
* Metadata: Version
  * ?: 2026.0.0
* Metadata: Topic
  * ?: FHIR
* Metadata: Topic
  * ?: CQL
* Metadata: Description
  * ?: PatientCommon logic.
* Metadata: Type
  * ?: logic-library from[http://terminology.hl7.org/CodeSystem/library-type](http://terminology.hl7.org/7.0.1/CodeSystem-library-type.html)
* Metadata: Parameter
  * ?: **Name**: Patient**Use**: Out**Min Cardinality**: 0**Max Cardinality**: 1**Type**: Patient
* Metadata: Library Content
* Metadata: CQL Content
  * ?: ````/* @description: Common patient fluent functions @comment: These are currently in the CI Build of US CQL, reproduced here for ease of reference */ library PatientCommon using FHIR version '4.0.1' include hl7.fhir.uv.cql.FHIRHelpers version '4.0.1' include hl7.fhir.uv.cql.FHIRCommon version '2.0.0' context Patient /* @description: Returns the age in days of the patient as of the given date, using birth time if known @comment: This function returns the number of whole days between the patient birth date and the asOf date. If the patient has a birthTime, the calculation is performed using the birthDateTime, and the time component of the asOf parameter is considered. Note that when the birth time is known, timezone offset normalization will be used. */ define fluent function ageInDaysAt(patient Patient, asOf DateTime): if patient.birthTime() is not null then CalculateAgeInDaysAt(Patient.birthDateTime(), asOf) else CalculateAgeInDaysAt(Patient.birthDate, date from asOf) /* @description: Returns the current age in days of the patient, using birth time if known @comment: This function returns the number of whole days between the patient birth date and the current date. If the patient has a birthTime, the calculation is performed using the birthDateTime and Now(), otherwise the calculation is performed using Today(). Note that when the birth time is known, timezone offset normalization will be used. */ define fluent function ageInDays(patient Patient): if patient.birthTime() is not null then CalculateAgeInDaysAt(Patient.birthDateTime(), Now()) else CalculateAgeInDaysAt(Patient.birthDate, Today()) /* @description: Returns the age in months of the patient as of the given date, using birth time if known @comment: This function returns the number of whole calendar months between the patient birth date and the asOf date. If the patient has a birthTime, the calculation is performed using the birthDateTime, and the time component of the asOf parameter is considered. Note that when the birth time is known, timezone offset normalization will be used. */ define fluent function ageInMonthsAt(patient Patient, asOf DateTime): if patient.birthTime() is not null then CalculateAgeInMonthsAt(Patient.birthDateTime(), asOf) else CalculateAgeInMonthsAt(Patient.birthDate, date from asOf) /* @description: Returns the current age in months of the patient, using birth time if known @comment: This function returns the number of whole calendar months between the patient birth date and the current date. If the patient has a birthTime, the calculation is performed using the birthDateTime and Now(), otherwise the calculation is performed using Today(). Note that when the birth time is known, timezone offset normalization will be used. */ define fluent function ageInMonths(patient Patient): if patient.birthTime() is not null then CalculateAgeInMonthsAt(Patient.birthDateTime(), Now()) else CalculateAgeInMonthsAt(Patient.birthDate, Today()) /* @description: Returns the age in years of the patient, as of the given date @comment: This function returns the number of whole calendar years between the patient birth date and the given date. Regardless of whether the patient has a birthTime, the calculation is performed using only the birth date. If the given date has a time component, it is ignored, on the grounds that birth time is almost universally not considered when determining age in years. */ define fluent function ageInYearsAt(patient Patient, asOf DateTime): CalculateAgeInYearsAt(Patient.birthDate, date from asOf) /* @description: Returns the current age in years of the patient @comment: This function returns the number of whole calendar years between the patient birth date and the current date. Regardless of whether the patient has a birthTime, the calculation is performed using only the birth date and Today(), on the grounds that birth time is almost universally not considered when determining age in years. */ define fluent function ageInYears(patient Patient): CalculateAgeInYearsAt(Patient.birthDate, Today())````
* Metadata: ELM XML Content
  * ?: ````Encoded data (45848 characters)````
* Metadata: ELM JSON Content
  * ?: ````Encoded data (80344 characters)````
* Metadata: Generated using version 0.5.0 of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Library",
  "id" : "PatientCommon",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    }
  ],
  "url" : "https://madie.cms.gov/Library/PatientCommon",
  "version" : "2026.0.0",
  "name" : "PatientCommon",
  "title" : "Patient Common",
  "status" : "active",
  "experimental" : false,
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/library-type",
        "code" : "logic-library"
      }
    ]
  },
  "date" : "2026-01-20T14:56:48+00:00",
  "description" : "PatientCommon logic.",
  "topic" : [
    {
      "text" : "FHIR"
    },
    {
      "text" : "CQL"
    }
  ],
  "relatedArtifact" : [
    {
      "type" : "depends-on",
      "display" : "Library FHIRHelpers",
      "resource" : "http://hl7.org/fhir/uv/cql/Library/FHIRHelpers|4.0.1"
    },
    {
      "type" : "depends-on",
      "display" : "Library FHIRCommon",
      "resource" : "http://hl7.org/fhir/uv/cql/Library/FHIRCommon|2.0.0"
    }
  ],
  "parameter" : [
    {
      "name" : "Patient",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "type" : "Patient"
    }
  ],
  "content" : [
    {
      "contentType" : "text/cql",
      "data" : "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"
    },
    {
      "contentType" : "application/elm+xml",
      "data" : "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"
    },
    {
      "contentType" : "application/elm+json",
      "data" : "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"
    }
  ]
}

```
