# Artifacts Summary - Your User Friendly Name for MyIG Here v0.2.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Requirements: Actor Definitions 

The following artifacts define the types of individuals and/or systems that will interact as part of the use cases covered by this implementation guide.

| | |
| :--- | :--- |
| [Example Server](ActorDefinition-example.md) | Client Actor |

### Knowledge Artifacts: Libraries 

These define logic, asset collections and other libraries as part of content in this implementation guide.

| | |
| :--- | :--- |
| [Example CQL Library](Library-example.md) | Some example library |
| [Example Library](Library-example-sql.md) | A test example |
| [Example Library Image](Library-example-image.md) | A test image example |

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [My Logical Model](StructureDefinition-MyLogical.md) | Logical Model |

### Structures: Questionnaires 

These define forms used by systems conforming to this implementation guide to capture or expose data to end users.

| |
| :--- |
| [Cancer Quality Forum Questionnaire 2012](Questionnaire-example.md) |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [My Favorite Patient Profile](StructureDefinition-mypatient.md) | Overriding description because we can |
| [My Observation Profile](StructureDefinition-myObservation.md) | A profile showing the use of XML to author profiles |
| [MyPractitionerName](StructureDefinition-mypractitioner.md) | Description for the profile page |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [My awesome extension](StructureDefinition-ext-myExtension.md) | What this extension means. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Value set for no code system](ValueSet-valueset-no-codesystem.md) | A sample value set where there's no known code system |
| [ValueSet fake](ValueSet-valueset-fake.md) | A fake value |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [CodeSystem fake](CodeSystem-cs-fake.md) | A fake code system |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Example of Logical Model](Binary-logical-example.md) | Example showing example content for a logical model |
| [Observation patient example](Observation-example.md) | Example showing slicing |
| [Simple patient example](Patient-example.md) | A simple example showing how examples are defined and referenced |

### Other 

These are resources that are used within this implementation guide that do not fit into one of the other categories.

| | |
| :--- | :--- |
| [Example binary](Binary-example.md) | Example showing binary content |
| [Example of Binary Image](Binary-image-example.md) | Example showing example content for an image |

