/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ASCIIMathTeXImg {
    private int AMnestingDepth;
    private int AMpreviousSymbol;
    private int AMcurrentSymbol;
    private static final int CONST = 0;
    private static final int UNARY = 1;
    private static final int BINARY = 2;
    private static final int INFIX = 3;
    private static final int LEFTBRACKET = 4;
    private static final int RIGHTBRACKET = 5;
    private static final int SPACE = 6;
    private static final int UNDEROVER = 7;
    private static final int DEFINITION = 8;
    private static final int LEFTRIGHT = 9;
    private static final int TEXT = 10;
    private static final Tupple AMsqrt = new Tupple("sqrt", "msqrt", "sqrt", null, 1, new String[0]);
    private static final Tupple AMroot = new Tupple("root", "mroot", "root", null, 2, new String[0]);
    private static final Tupple AMfrac = new Tupple("frac", "mfrac", "/", null, 2, new String[0]);
    private static final Tupple AMdiv = new Tupple("/", "mfrac", "/", null, 3, new String[0]);
    private static final Tupple AMover = new Tupple("stackrel", "mover", "stackrel", null, 2, new String[0]);
    private static final Tupple AMsub = new Tupple("_", "msub", "_", null, 3, new String[0]);
    private static final Tupple AMsup = new Tupple("^", "msup", "^", null, 3, new String[0]);
    private static final Tupple AMtext = new Tupple("text", "mtext", "text", null, 10, new String[0]);
    private static final Tupple AMmbox = new Tupple("mbox", "mtext", "mbox", null, 10, new String[0]);
    private static final Tupple AMquote = new Tupple("\"", "mtext", "mbox", null, 10, new String[0]);
    private static final List<Tupple> AMsymbols = new ArrayList<Tupple>(Arrays.asList(new Tupple("alpha", "mi", "\u03b1", null, 0, new String[0]), new Tupple("beta", "mi", "\u03b2", null, 0, new String[0]), new Tupple("chi", "mi", "\u03c7", null, 0, new String[0]), new Tupple("delta", "mi", "\u03b4", null, 0, new String[0]), new Tupple("Delta", "mo", "\u0394", null, 0, new String[0]), new Tupple("epsi", "mi", "\u03b5", "epsilon", 0, new String[0]), new Tupple("varepsilon", "mi", "\u025b", null, 0, new String[0]), new Tupple("eta", "mi", "\u03b7", null, 0, new String[0]), new Tupple("gamma", "mi", "\u03b3", null, 0, new String[0]), new Tupple("Gamma", "mo", "\u0393", null, 0, new String[0]), new Tupple("iota", "mi", "\u03b9", null, 0, new String[0]), new Tupple("kappa", "mi", "\u03ba", null, 0, new String[0]), new Tupple("lambda", "mi", "\u03bb", null, 0, new String[0]), new Tupple("Lambda", "mo", "\u039b", null, 0, new String[0]), new Tupple("lamda", "mi", "lambda", null, 8, new String[0]), new Tupple("Lamda", "mi", "Lambda", null, 8, new String[0]), new Tupple("mu", "mi", "\u03bc", null, 0, new String[0]), new Tupple("nu", "mi", "\u03bd", null, 0, new String[0]), new Tupple("omega", "mi", "\u03c9", null, 0, new String[0]), new Tupple("Omega", "mo", "\u03a9", null, 0, new String[0]), new Tupple("phi", "mi", "\u03c6", null, 0, new String[0]), new Tupple("varphi", "mi", "\u03d5", null, 0, new String[0]), new Tupple("Phi", "mo", "\u03a6", null, 0, new String[0]), new Tupple("pi", "mi", "\u03c0", null, 0, new String[0]), new Tupple("Pi", "mo", "\u03a0", null, 0, new String[0]), new Tupple("psi", "mi", "\u03c8", null, 0, new String[0]), new Tupple("Psi", "mi", "\u03a8", null, 0, new String[0]), new Tupple("rho", "mi", "\u03c1", null, 0, new String[0]), new Tupple("sigma", "mi", "\u03c3", null, 0, new String[0]), new Tupple("Sigma", "mo", "\u03a3", null, 0, new String[0]), new Tupple("tau", "mi", "\u03c4", null, 0, new String[0]), new Tupple("theta", "mi", "\u03b8", null, 0, new String[0]), new Tupple("vartheta", "mi", "\u03d1", null, 0, new String[0]), new Tupple("Theta", "mo", "\u0398", null, 0, new String[0]), new Tupple("upsilon", "mi", "\u03c5", null, 0, new String[0]), new Tupple("xi", "mi", "\u03be", null, 0, new String[0]), new Tupple("Xi", "mo", "\u039e", null, 0, new String[0]), new Tupple("zeta", "mi", "\u03b6", null, 0, new String[0]), new Tupple("*", "mo", "\u22c5", "cdot", 0, new String[0]), new Tupple("**", "mo", "\u2217", "ast", 0, new String[0]), new Tupple("***", "mo", "\u22c6", "star", 0, new String[0]), new Tupple("//", "mo", "/", "/", 0, new String[]{"val", "notexcopy"}), new Tupple("\\\\", "mo", "\\", "backslash", 0, new String[0]), new Tupple("setminus", "mo", "\\", null, 0, new String[0]), new Tupple("xx", "mo", "\u00d7", "times", 0, new String[0]), new Tupple("|><", "mo", "\u22c9", "ltimes", 0, new String[0]), new Tupple("><|", "mo", "\u22ca", "rtimes", 0, new String[0]), new Tupple("|><|", "mo", "\u22c8", "bowtie", 0, new String[0]), new Tupple("-:", "mo", "\u00f7", "div", 0, new String[0]), new Tupple("divide", "mo", "-:", null, 8, new String[0]), new Tupple("@", "mo", "\u2218", "circ", 0, new String[0]), new Tupple("o+", "mo", "\u2295", "oplus", 0, new String[0]), new Tupple("ox", "mo", "\u2297", "otimes", 0, new String[0]), new Tupple("o.", "mo", "\u2299", "odot", 0, new String[0]), new Tupple("sum", "mo", "\u2211", null, 7, new String[0]), new Tupple("prod", "mo", "\u220f", null, 7, new String[0]), new Tupple("^^", "mo", "\u2227", "wedge", 0, new String[0]), new Tupple("^^^", "mo", "\u22c0", "bigwedge", 7, new String[0]), new Tupple("vv", "mo", "\u2228", "vee", 0, new String[0]), new Tupple("vvv", "mo", "\u22c1", "bigvee", 7, new String[0]), new Tupple("nn", "mo", "\u2229", "cap", 0, new String[0]), new Tupple("nnn", "mo", "\u22c2", "bigcap", 7, new String[0]), new Tupple("uu", "mo", "\u222a", "cup", 0, new String[0]), new Tupple("uuu", "mo", "\u22c3", "bigcup", 7, new String[0]), new Tupple("overset", "mover", "stackrel", null, 2, new String[0]), new Tupple("underset", "munder", "stackrel", null, 2, new String[0]), new Tupple("!=", "mo", "\u2260", "ne", 0, new String[0]), new Tupple(":=", "mo", ":=", null, 0, new String[0]), new Tupple("lt", "mo", "<", null, 0, new String[0]), new Tupple("gt", "mo", ">", null, 0, new String[0]), new Tupple("<=", "mo", "\u2264", "le", 0, new String[0]), new Tupple("lt=", "mo", "\u2264", "leq", 0, new String[0]), new Tupple("gt=", "mo", "\u2265", "geq", 0, new String[0]), new Tupple(">=", "mo", "\u2265", "ge", 0, new String[0]), new Tupple("-<", "mo", "\u227a", "prec", 0, new String[0]), new Tupple("-lt", "mo", "\u227a", null, 0, new String[0]), new Tupple(">-", "mo", "\u227b", "succ", 0, new String[0]), new Tupple("-<=", "mo", "\u2aaf", "preceq", 0, new String[0]), new Tupple(">-=", "mo", "\u2ab0", "succeq", 0, new String[0]), new Tupple("in", "mo", "\u2208", null, 0, new String[0]), new Tupple("!in", "mo", "\u2209", "notin", 0, new String[0]), new Tupple("sub", "mo", "\u2282", "subset", 0, new String[0]), new Tupple("sup", "mo", "\u2283", "supset", 0, new String[0]), new Tupple("sube", "mo", "\u2286", "subseteq", 0, new String[0]), new Tupple("supe", "mo", "\u2287", "supseteq", 0, new String[0]), new Tupple("-=", "mo", "\u2261", "equiv", 0, new String[0]), new Tupple("~=", "mo", "\u2245", "stackrel{\\sim}{=}", 0, new String[0]), new Tupple("cong", "mo", "~=", null, 8, new String[0]), new Tupple("~~", "mo", "\u2248", "approx", 0, new String[0]), new Tupple("prop", "mo", "\u221d", "propto", 0, new String[0]), new Tupple("and", "mtext", "and", null, 6, new String[0]), new Tupple("or", "mtext", "or", null, 6, new String[0]), new Tupple("not", "mo", "\u00ac", "neg", 0, new String[0]), new Tupple("=>", "mo", "\u21d2", "Rightarrow", 0, new String[0]), new Tupple("implies", "mo", "=>", null, 8, new String[0]), new Tupple("if", "mo", "if", null, 6, new String[0]), new Tupple("<=>", "mo", "\u21d4", "Leftrightarrow", 0, new String[0]), new Tupple("iff", "mo", "<=>", null, 8, new String[0]), new Tupple("AA", "mo", "\u2200", "forall", 0, new String[0]), new Tupple("EE", "mo", "\u2203", "exists", 0, new String[0]), new Tupple("_|_", "mo", "\u22a5", "bot", 0, new String[0]), new Tupple("TT", "mo", "\u22a4", "top", 0, new String[0]), new Tupple("|--", "mo", "\u22a2", "vdash", 0, new String[0]), new Tupple("|==", "mo", "\u22a8", "models", 0, new String[0]), new Tupple("(", "mo", "(", null, 4, new String[]{"val"}), new Tupple(")", "mo", ")", null, 5, new String[]{"val"}), new Tupple("[", "mo", "[", null, 4, new String[]{"val"}), new Tupple("]", "mo", "]", null, 5, new String[]{"val"}), new Tupple("{", "mo", "{", "lbrace", 4, new String[0]), new Tupple("}", "mo", "}", "rbrace", 5, new String[0]), new Tupple("|", "mo", "|", null, 9, new String[]{"val"}), new Tupple("(:", "mo", "\u2329", "langle", 4, new String[0]), new Tupple(":)", "mo", "\u232a", "rangle", 5, new String[0]), new Tupple("<<", "mo", "\u2329", "langle", 4, new String[0]), new Tupple(">>", "mo", "\u232a", "rangle", 5, new String[0]), new Tupple("{:", "mo", "{:", null, 4, new String[]{"invisible"}), new Tupple(":}", "mo", ":}", null, 5, new String[]{"invisible"}), new Tupple("int", "mo", "\u222b", null, 0, new String[0]), new Tupple("dx", "mi", "{:d x:}", null, 8, new String[0]), new Tupple("dy", "mi", "{:d y:}", null, 8, new String[0]), new Tupple("dz", "mi", "{:d z:}", null, 8, new String[0]), new Tupple("dt", "mi", "{:d t:}", null, 8, new String[0]), new Tupple("oint", "mo", "\u222e", null, 0, new String[0]), new Tupple("del", "mo", "\u2202", "partial", 0, new String[0]), new Tupple("grad", "mo", "\u2207", "nabla", 0, new String[0]), new Tupple("+-", "mo", "\u00b1", "pm", 0, new String[0]), new Tupple("O/", "mo", "\u2205", "emptyset", 0, new String[0]), new Tupple("oo", "mo", "\u221e", "infty", 0, new String[0]), new Tupple("aleph", "mo", "\u2135", null, 0, new String[0]), new Tupple("...", "mo", "...", "ldots", 0, new String[0]), new Tupple(":.", "mo", "\u2234", "therefore", 0, new String[0]), new Tupple(":'", "mo", "\u2235", "because", 0, new String[0]), new Tupple("/_", "mo", "\u2220", "angle", 0, new String[0]), new Tupple("/_\\", "mo", "\u25b3", "triangle", 0, new String[0]), new Tupple("\\ ", "mo", "\u00a0", null, 0, new String[]{"val"}), new Tupple("frown", "mo", "\u2322", null, 0, new String[0]), new Tupple("%", "mo", "%", "%", 0, new String[]{"notexcopy"}), new Tupple("quad", "mo", "\u00a0\u00a0", null, 0, new String[0]), new Tupple("qquad", "mo", "\u00a0\u00a0\u00a0\u00a0", null, 0, new String[0]), new Tupple("cdots", "mo", "\u22ef", null, 0, new String[0]), new Tupple("vdots", "mo", "\u22ee", null, 0, new String[0]), new Tupple("ddots", "mo", "\u22f1", null, 0, new String[0]), new Tupple("diamond", "mo", "\u22c4", null, 0, new String[0]), new Tupple("square", "mo", "\u25a1", "boxempty", 0, new String[0]), new Tupple("|__", "mo", "\u230a", "lfloor", 0, new String[0]), new Tupple("__|", "mo", "\u230b", "rfloor", 0, new String[0]), new Tupple("|~", "mo", "\u2308", "lceil", 0, new String[0]), new Tupple("lceiling", "mo", "|~", null, 8, new String[0]), new Tupple("~|", "mo", "\u2309", "rceil", 0, new String[0]), new Tupple("rceiling", "mo", "~|", null, 8, new String[0]), new Tupple("CC", "mo", "\u2102", "mathbb{C}", 0, new String[]{"notexcopy"}), new Tupple("NN", "mo", "\u2115", "mathbb{N}", 0, new String[]{"notexcopy"}), new Tupple("QQ", "mo", "\u211a", "mathbb{Q}", 0, new String[]{"notexcopy"}), new Tupple("RR", "mo", "\u211d", "mathbb{R}", 0, new String[]{"notexcopy"}), new Tupple("ZZ", "mo", "\u2124", "mathbb{Z}", 0, new String[]{"notexcopy"}), new Tupple("f", "mi", "f", null, 1, new String[]{"func", "val"}), new Tupple("g", "mi", "g", null, 1, new String[]{"func", "val"}), new Tupple("''", "mo", "''", null, 0, new String[]{"val"}), new Tupple("'''", "mo", "'''", null, 0, new String[]{"val"}), new Tupple("''''", "mo", "''''", null, 0, new String[]{"val"}), new Tupple("lim", "mo", "lim", null, 7, new String[0]), new Tupple("Lim", "mo", "Lim", null, 7, new String[0]), new Tupple("sin", "mo", "sin", null, 1, new String[]{"func"}), new Tupple("cos", "mo", "cos", null, 1, new String[]{"func"}), new Tupple("tan", "mo", "tan", null, 1, new String[]{"func"}), new Tupple("arcsin", "mo", "arcsin", null, 1, new String[]{"func"}), new Tupple("arccos", "mo", "arccos", null, 1, new String[]{"func"}), new Tupple("arctan", "mo", "arctan", null, 1, new String[]{"func"}), new Tupple("sinh", "mo", "sinh", null, 1, new String[]{"func"}), new Tupple("cosh", "mo", "cosh", null, 1, new String[]{"func"}), new Tupple("tanh", "mo", "tanh", null, 1, new String[]{"func"}), new Tupple("cot", "mo", "cot", null, 1, new String[]{"func"}), new Tupple("coth", "mo", "coth", null, 1, new String[]{"func"}), new Tupple("sech", "mo", "sech", null, 1, new String[]{"func"}), new Tupple("csch", "mo", "csch", null, 1, new String[]{"func"}), new Tupple("sec", "mo", "sec", null, 1, new String[]{"func"}), new Tupple("csc", "mo", "csc", null, 1, new String[]{"func"}), new Tupple("log", "mo", "log", null, 1, new String[]{"func"}), new Tupple("ln", "mo", "ln", null, 1, new String[]{"func"}), new Tupple(new String[]{"|", "|"}, "abs", "mo", "abs", null, 1, new String[]{"notexcopy"}), new Tupple(new String[]{"\\|", "\\|"}, "norm", "mo", "norm", null, 1, new String[]{"notexcopy"}), new Tupple(new String[]{"\\lfloor", "\\rfloor"}, "floor", "mo", "floor", null, 1, new String[]{"notexcopy"}), new Tupple(new String[]{"\\lceil", "\\rceil"}, "ceil", "mo", "ceil", null, 1, new String[]{"notexcopy"}), new Tupple("Sin", "mo", "sin", null, 1, new String[]{"func"}), new Tupple("Cos", "mo", "cos", null, 1, new String[]{"func"}), new Tupple("Tan", "mo", "tan", null, 1, new String[]{"func"}), new Tupple("Arcsin", "mo", "arcsin", null, 1, new String[]{"func"}), new Tupple("Arccos", "mo", "arccos", null, 1, new String[]{"func"}), new Tupple("Arctan", "mo", "arctan", null, 1, new String[]{"func"}), new Tupple("Sinh", "mo", "sinh", null, 1, new String[]{"func"}), new Tupple("Sosh", "mo", "cosh", null, 1, new String[]{"func"}), new Tupple("Tanh", "mo", "tanh", null, 1, new String[]{"func"}), new Tupple("Cot", "mo", "cot", null, 1, new String[]{"func"}), new Tupple("Sec", "mo", "sec", null, 1, new String[]{"func"}), new Tupple("Csc", "mo", "csc", null, 1, new String[]{"func"}), new Tupple("Log", "mo", "log", null, 1, new String[]{"func"}), new Tupple("Ln", "mo", "ln", null, 1, new String[]{"func"}), new Tupple(new String[]{"|", "|"}, "Abs", "mo", "abs", null, 1, new String[]{"notexcopy"}), new Tupple("det", "mo", "det", null, 1, new String[]{"func"}), new Tupple("exp", "mo", "exp", null, 1, new String[]{"func"}), new Tupple("dim", "mo", "dim", null, 0, new String[0]), new Tupple("mod", "mo", "mod", "text{mod}", 0, new String[]{"notexcopy"}), new Tupple("gcd", "mo", "gcd", null, 1, new String[]{"func"}), new Tupple("lcm", "mo", "lcm", "text{lcm}", 1, new String[]{"func", "notexcopy"}), new Tupple("lub", "mo", "lub", null, 0, new String[0]), new Tupple("glb", "mo", "glb", null, 0, new String[0]), new Tupple("min", "mo", "min", null, 7, new String[0]), new Tupple("max", "mo", "max", null, 7, new String[0]), new Tupple("uarr", "mo", "\u2191", "uparrow", 0, new String[0]), new Tupple("darr", "mo", "\u2193", "downarrow", 0, new String[0]), new Tupple("rarr", "mo", "\u2192", "rightarrow", 0, new String[0]), new Tupple("->", "mo", "\u2192", "to", 0, new String[0]), new Tupple(">->", "mo", "\u21a3", "rightarrowtail", 0, new String[0]), new Tupple("->>", "mo", "\u21a0", "twoheadrightarrow", 0, new String[0]), new Tupple(">->>", "mo", "\u2916", "twoheadrightarrowtail", 0, new String[0]), new Tupple("|->", "mo", "\u21a6", "mapsto", 0, new String[0]), new Tupple("larr", "mo", "\u2190", "leftarrow", 0, new String[0]), new Tupple("harr", "mo", "\u2194", "leftrightarrow", 0, new String[0]), new Tupple("rArr", "mo", "\u21d2", "Rightarrow", 0, new String[0]), new Tupple("lArr", "mo", "\u21d0", "Leftarrow", 0, new String[0]), new Tupple("hArr", "mo", "\u21d4", "Leftrightarrow", 0, new String[0]), AMsqrt, AMroot, AMfrac, AMdiv, AMover, AMsub, AMsup, new Tupple("cancel", "menclose", "cancel", null, 1, new String[0]), new Tupple("Sqrt", "msqrt", "sqrt", null, 1, new String[0]), new Tupple("hat", "mover", "^", null, 1, new String[]{"acc"}), new Tupple("bar", "mover", "\u00af", "overline", 1, new String[]{"acc"}), new Tupple("vec", "mover", "\u2192", null, 1, new String[]{"acc"}), new Tupple("tilde", "mover", "~", null, 1, new String[]{"acc"}), new Tupple("dot", "mover", ".", null, 1, new String[]{"acc"}), new Tupple("ddot", "mover", "..", null, 1, new String[]{"acc"}), new Tupple("ul", "munder", "\u0332", "underline", 1, new String[]{"acc"}), new Tupple("ubrace", "munder", "\u23df", "underbrace", 1, new String[]{"acc"}), new Tupple("obrace", "mover", "\u23de", "overbrace", 1, new String[]{"acc"}), AMtext, AMmbox, AMquote, new Tupple("color", "mstyle", null, null, 2, new String[0])));
    private static String[] AMnames;

    private String slice(String str, int start, int end) {
        if (end > str.length()) {
            return str.substring(start);
        }
        return str.substring(start, end);
    }

    private String slice(String str, int start) {
        return str.substring(start);
    }

    private String substr(String str, int pos, int len) {
        if (pos + len > str.length()) {
            return str.substring(pos);
        }
        return str.substring(pos, pos + len);
    }

    private static void AMinitSymbols() {
        int symlen = AMsymbols.size();
        for (int i = 0; i < symlen; ++i) {
            if (AMsymbols.get(i).tex == null || AMsymbols.get(i).hasFlag("notexcopy")) continue;
            Tupple tmp = AMsymbols.get(i).hasFlag("acc") ? new Tupple(AMsymbols.get(i).tex, AMsymbols.get(i).tag, AMsymbols.get(i).output, null, AMsymbols.get(i).ttype, new String[]{"acc"}) : new Tupple(AMsymbols.get(i).tex, AMsymbols.get(i).tag, AMsymbols.get(i).output, null, AMsymbols.get(i).ttype, new String[0]);
            AMsymbols.add(tmp);
        }
        ASCIIMathTeXImg.refreshSymbols();
    }

    private static void refreshSymbols() {
        Collections.sort(AMsymbols, new Comparator<Tupple>(){

            @Override
            public int compare(Tupple o1, Tupple o2) {
                return o1.input.compareTo(o2.input);
            }
        });
        AMnames = new String[AMsymbols.size()];
        for (int i = 0; i < AMsymbols.size(); ++i) {
            ASCIIMathTeXImg.AMnames[i] = AMsymbols.get(i).input;
        }
    }

    private String AMremoveCharsAndBlanks(String str, int n) {
        int i;
        String st = str.length() > n && str.charAt(n) == '\\' && str.charAt(n + 1) != '\\' && str.charAt(n + 1) != ' ' ? this.slice(str, n + 1) : this.slice(str, n);
        for (i = 0; i < st.length() && st.charAt(i) <= ' '; ++i) {
        }
        return this.slice(st, i);
    }

    private int AMposition(String[] arr, String str, int n) {
        int i = 0;
        if (n == 0) {
            n = -1;
            int h = arr.length;
            while (n + 1 < h) {
                int m = n + h >> 1;
                if (arr[m].compareTo(str) < 0) {
                    n = m;
                    continue;
                }
                h = m;
            }
            return h;
        }
        for (i = n; i < arr.length && arr[i].compareTo(str) < 0; ++i) {
        }
        return i;
    }

    private Tupple AMgetSymbol(String str) {
        String tagst;
        String st;
        int k = 0;
        int j = 0;
        int mk = 0;
        String match = "";
        boolean more = true;
        for (int i = 1; i <= str.length() && more; ++i) {
            st = str.substring(0, i);
            k = this.AMposition(AMnames, st, j = k);
            if (k < AMnames.length && this.slice(str, 0, AMnames[k].length()).equals(AMnames[k])) {
                match = AMnames[k];
                mk = k;
                i = match.length();
            }
            more = k < AMnames.length && this.slice(str, 0, AMnames[k].length()).compareTo(AMnames[k]) >= 0;
        }
        this.AMpreviousSymbol = this.AMcurrentSymbol;
        if (!match.equals("")) {
            this.AMcurrentSymbol = AMsymbols.get(mk).ttype;
            return AMsymbols.get(mk);
        }
        this.AMcurrentSymbol = 0;
        st = this.slice(str, 0, 1);
        boolean integ = true;
        for (k = 1; "0".compareTo(st) <= 0 && st.compareTo("9") <= 0 && k <= str.length(); ++k) {
            st = this.slice(str, k, k + 1);
        }
        if (st.equals(".") && "0".compareTo(st = this.slice(str, k, k + 1)) <= 0 && st.compareTo("9") <= 0) {
            integ = false;
            ++k;
            while ("0".compareTo(st) <= 0 && st.compareTo("9") <= 0 && k <= str.length()) {
                st = this.slice(str, k, k + 1);
                ++k;
            }
        }
        if (integ && k > 1 || k > 2) {
            st = this.slice(str, 0, k - 1);
            tagst = "mn";
        } else {
            k = 2;
            st = this.slice(str, 0, 1);
            String string = tagst = !("A".compareTo(st) <= 0 && st.compareTo("Z") <= 0 || "a".compareTo(st) <= 0 && st.compareTo("z") <= 0) ? "mo" : "mi";
        }
        if (st.equals("-") && this.AMpreviousSymbol == 3) {
            this.AMcurrentSymbol = 3;
            return new Tupple(st, tagst, st, null, 1, new String[]{"func", "val"});
        }
        return new Tupple(st, tagst, st, null, 0, new String[]{"val"});
    }

    private String AMTremoveBrackets(String node) {
        if (node.charAt(0) == '{' && node.charAt(node.length() - 1) == '}') {
            int leftchop = 0;
            String st = this.substr(node, 1, 5);
            if (st.equals("\\left")) {
                st = "" + node.charAt(6);
                if (st.equals("(") || st.equals("[") || st.equals("{")) {
                    leftchop = 7;
                } else {
                    st = this.substr(node, 6, 7);
                    if (st.equals("\\lbrace")) {
                        leftchop = 13;
                    }
                }
            } else {
                st = "" + node.charAt(1);
                if (st.equals("(") || st.equals("[")) {
                    leftchop = 2;
                }
            }
            if (leftchop > 0) {
                st = node.substring(node.length() - 8);
                if (st.equals("\\right)}") || st.equals("\\right]}") || st.equals("\\right.}")) {
                    node = "{" + node.substring(leftchop);
                    node = node.substring(0, node.length() - 8) + "}";
                } else if (st.equals("\\rbrace}")) {
                    node = "{" + node.substring(leftchop);
                    node = node.substring(0, node.length() - 14) + "}";
                }
            }
        }
        return node;
    }

    private String AMTgetTeXsymbol(Tupple symb) {
        String pre = symb.hasFlag("val") ? "" : "\\";
        if (symb.tex == null) {
            return pre + symb.input;
        }
        return pre + symb.tex;
    }

    private String[] AMTparseSexpr(String str) {
        String newFrag = "";
        Tupple symbol = this.AMgetSymbol(str = this.AMremoveCharsAndBlanks(str, 0));
        if (symbol == null || symbol.ttype == 5 && this.AMnestingDepth > 0) {
            return new String[]{null, str};
        }
        if (symbol.ttype == 8) {
            str = symbol.output + this.AMremoveCharsAndBlanks(str, symbol.input.length());
            symbol = this.AMgetSymbol(str);
        }
        switch (symbol.ttype) {
            case 0: 
            case 7: {
                str = this.AMremoveCharsAndBlanks(str, symbol.input.length());
                String texsymbol = this.AMTgetTeXsymbol(symbol);
                if (texsymbol.charAt(0) == '\\' || symbol.tag.equals("mo")) {
                    return new String[]{texsymbol, str};
                }
                return new String[]{"{" + texsymbol + "}", str};
            }
            case 4: {
                String node;
                ++this.AMnestingDepth;
                str = this.AMremoveCharsAndBlanks(str, symbol.input.length());
                String[] result = this.AMTparseExpr(str, true);
                --this.AMnestingDepth;
                int leftchop = 0;
                if (this.substr(result[0], 0, 6).equals("\\right")) {
                    String st = "" + result[0].charAt(6);
                    if (st.equals(")") || st.equals("]") || st.equals("}")) {
                        leftchop = 6;
                    } else if (st == ".") {
                        leftchop = 7;
                    } else {
                        st = this.substr(result[0], 6, 7);
                        if (st.equals("\\rbrace")) {
                            leftchop = 13;
                        }
                    }
                }
                if (leftchop > 0) {
                    result[0] = result[0].substring(leftchop);
                    node = symbol.hasFlag("invisible") ? "{" + result[0] + "}" : "{" + this.AMTgetTeXsymbol(symbol) + result[0] + "}";
                } else {
                    node = symbol.hasFlag("invisible") ? "{\\left." + result[0] + "}" : "{\\left" + this.AMTgetTeXsymbol(symbol) + result[0] + "}";
                }
                return new String[]{node, result[1]};
            }
            case 10: {
                String st;
                int i;
                if (symbol != AMquote) {
                    str = this.AMremoveCharsAndBlanks(str, symbol.input.length());
                }
                if ((i = str.charAt(0) == '{' ? str.indexOf("}") : (str.charAt(0) == '(' ? str.indexOf(")") : (str.charAt(0) == '[' ? str.indexOf("]") : (symbol == AMquote ? str.substring(1).indexOf("\"") + 1 : 0)))) == -1) {
                    i = str.length();
                }
                if ((st = str.substring(1, i)).charAt(0) == ' ') {
                    newFrag = "\\ ";
                }
                newFrag = newFrag + "\\text{" + st + "}";
                if (st.charAt(st.length() - 1) == ' ') {
                    newFrag = newFrag + "\\ ";
                }
                str = this.AMremoveCharsAndBlanks(str, i + 1);
                return new String[]{newFrag, str};
            }
            case 1: {
                str = this.AMremoveCharsAndBlanks(str, symbol.input.length());
                String[] result = this.AMTparseSexpr(str);
                if (result[0] == null) {
                    return new String[]{"{" + this.AMTgetTeXsymbol(symbol) + "}", str};
                }
                if (symbol.hasFlag("func")) {
                    String st = "" + str.charAt(0);
                    if (st.equals("^") || st.equals("_") || st.equals("/") || st.equals("|") || st.equals(",") || symbol.input.length() == 1 && symbol.input.matches("\\w") && !st.equals("(")) {
                        return new String[]{"{" + this.AMTgetTeXsymbol(symbol) + "}", str};
                    }
                    String node = "{" + this.AMTgetTeXsymbol(symbol) + "{" + result[0] + "}}";
                    return new String[]{node, result[1]};
                }
                result[0] = this.AMTremoveBrackets(result[0]);
                if (symbol.input.equals("sqrt")) {
                    return new String[]{"\\sqrt{" + result[0] + "}", result[1]};
                }
                if (symbol.input.equals("cancel")) {
                    return new String[]{"\\cancel{" + result[0] + "}", result[1]};
                }
                if (symbol.rewriteleftright != null) {
                    return new String[]{"{\\left" + symbol.rewriteleftright[0] + result[0] + "\\right" + symbol.rewriteleftright[1] + '}', result[1]};
                }
                if (symbol.hasFlag("acc")) {
                    return new String[]{this.AMTgetTeXsymbol(symbol) + "{" + result[0] + "}", result[1]};
                }
                return new String[]{"{" + this.AMTgetTeXsymbol(symbol) + "{" + result[0] + "}}", result[1]};
            }
            case 2: {
                str = this.AMremoveCharsAndBlanks(str, symbol.input.length());
                String[] result = this.AMTparseSexpr(str);
                if (result[0] == null) {
                    return new String[]{'{' + this.AMTgetTeXsymbol(symbol) + '}', str};
                }
                result[0] = this.AMTremoveBrackets(result[0]);
                String[] result2 = this.AMTparseSexpr(result[1]);
                if (result2[0] == null) {
                    return new String[]{'{' + this.AMTgetTeXsymbol(symbol) + '}', str};
                }
                result2[0] = this.AMTremoveBrackets(result2[0]);
                newFrag = symbol.input.equals("color") ? "{\\color{" + result[0].replaceAll("[\\{\\}]", "") + "}" + result2[0] + "}" : (symbol.input.equals("root") ? "{\\sqrt[" + result[0] + "]{" + result2[0] + "}}" : "{" + this.AMTgetTeXsymbol(symbol) + "{" + result[0] + "}{" + result2[0] + "}}");
                return new String[]{newFrag, result2[1]};
            }
            case 3: {
                str = this.AMremoveCharsAndBlanks(str, symbol.input.length());
                return new String[]{symbol.output, str};
            }
            case 6: {
                str = this.AMremoveCharsAndBlanks(str, symbol.input.length());
                return new String[]{"{\\quad\\text{" + symbol.input + "}\\quad}", str};
            }
            case 9: {
                ++this.AMnestingDepth;
                str = this.AMremoveCharsAndBlanks(str, symbol.input.length());
                String[] result = this.AMTparseExpr(str, false);
                --this.AMnestingDepth;
                String st = "" + result[0].charAt(result[0].length() - 1);
                if (st.equals("|")) {
                    String node = "{\\left|" + result[0] + "}";
                    return new String[]{node, result[1]};
                }
                String node = "{\\mid}";
                return new String[]{node, str};
            }
        }
        str = this.AMremoveCharsAndBlanks(str, symbol.input.length());
        return new String[]{"{" + this.AMTgetTeXsymbol(symbol) + "}", str};
    }

    private String[] AMTparseIexpr(String str) {
        str = this.AMremoveCharsAndBlanks(str, 0);
        Tupple sym1 = this.AMgetSymbol(str);
        String[] result = this.AMTparseSexpr(str);
        String node = result[0];
        str = result[1];
        Tupple symbol = this.AMgetSymbol(str);
        if (symbol.ttype == 3 && !symbol.input.equals("/")) {
            Tupple sym2;
            result = this.AMTparseSexpr(str = this.AMremoveCharsAndBlanks(str, symbol.input.length()));
            result[0] = result[0] == null ? "{}" : this.AMTremoveBrackets(result[0]);
            str = result[1];
            if (symbol.input.equals("_")) {
                sym2 = this.AMgetSymbol(str);
                if (sym2.input.equals("^")) {
                    str = this.AMremoveCharsAndBlanks(str, sym2.input.length());
                    String[] res2 = this.AMTparseSexpr(str);
                    res2[0] = this.AMTremoveBrackets(res2[0]);
                    str = res2[1];
                    node = "{" + node;
                    node = node + "_{" + result[0] + "}";
                    node = node + "^{" + res2[0] + "}";
                    node = node + "}";
                } else {
                    node = node + "_{" + result[0] + "}";
                }
            } else {
                node = node + "^{" + result[0] + "}";
            }
            if (sym1.hasFlag("func") && (sym2 = this.AMgetSymbol(str)).ttype != 3 && sym2.ttype != 5) {
                result = this.AMTparseIexpr(str);
                node = "{" + node + result[0] + "}";
                str = result[1];
            }
        }
        return new String[]{node, str};
    }

    private String[] AMTparseExpr(String str, boolean rightbracket) {
        String node;
        Tupple symbol;
        String newFrag = "";
        boolean addedright = false;
        do {
            str = this.AMremoveCharsAndBlanks(str, 0);
            String[] result = this.AMTparseIexpr(str);
            node = result[0];
            str = result[1];
            symbol = this.AMgetSymbol(str);
            if (symbol.ttype == 3 && symbol.input.equals("/")) {
                result = this.AMTparseIexpr(str = this.AMremoveCharsAndBlanks(str, symbol.input.length()));
                result[0] = result[0] == null ? "{}" : this.AMTremoveBrackets(result[0]);
                str = result[1];
                node = this.AMTremoveBrackets(node);
                node = "\\frac{" + node + "}";
                node = node + "{" + result[0] + "}";
                newFrag = newFrag + node;
                symbol = this.AMgetSymbol(str);
                continue;
            }
            if (node == null) continue;
            newFrag = newFrag + node;
        } while ((symbol.ttype != 5 && (symbol.ttype != 9 || rightbracket) || this.AMnestingDepth == 0) && (symbol.output == null || !symbol.output.equals("")));
        if (symbol.ttype == 5 || symbol.ttype == 9) {
            char left;
            char right;
            int len = newFrag.length();
            if (len > 2 && newFrag.charAt(0) == '{' && newFrag.indexOf(44) > 0 && ((right = newFrag.charAt(len - 2)) == ')' || right == ']') && ((left = newFrag.charAt(6)) == '(' && right == ')' && !symbol.output.equals("}") || left == '[' && right == ']')) {
                String mxout = "\\begin{matrix}";
                ArrayList<Integer> pos = new ArrayList<Integer>();
                pos.add(0);
                boolean matrix = true;
                int mxnestingd = 0;
                ArrayList<ArrayList<Integer>> subpos = new ArrayList<ArrayList<Integer>>();
                subpos.add(new ArrayList<Integer>(Arrays.asList(0)));
                int lastsubposstart = 0;
                int mxanynestingd = 0;
                for (int i = 1; i < len - 1; ++i) {
                    if (newFrag.charAt(i) == left) {
                        ++mxnestingd;
                    }
                    if (newFrag.charAt(i) == right && --mxnestingd == 0 && i + 3 < newFrag.length() && newFrag.charAt(i + 2) == ',' && newFrag.charAt(i + 3) == '{') {
                        pos.add(i + 2);
                        lastsubposstart = i + 2;
                        while (subpos.size() <= lastsubposstart) {
                            subpos.add(null);
                        }
                        subpos.set(lastsubposstart, new ArrayList<Integer>(Arrays.asList(i + 2)));
                    }
                    if (newFrag.charAt(i) == '[' || newFrag.charAt(i) == '(' || newFrag.charAt(i) == '{') {
                        ++mxanynestingd;
                    }
                    if (newFrag.charAt(i) == ']' || newFrag.charAt(i) == ')' || newFrag.charAt(i) == '}') {
                        --mxanynestingd;
                    }
                    if (newFrag.charAt(i) == ',' && mxanynestingd == 1) {
                        ((List)subpos.get(lastsubposstart)).add(i);
                    }
                    if (mxanynestingd >= 0) continue;
                    if (lastsubposstart == i + 1) {
                        ++i;
                        continue;
                    }
                    matrix = false;
                }
                pos.add(len);
                int lastmxsubcnt = -1;
                if (mxnestingd == 0 && pos.size() > 0 && matrix) {
                    for (int i = 0; i < pos.size() - 1; ++i) {
                        int j;
                        ArrayList<String> subarr = null;
                        if (i > 0) {
                            mxout = mxout + "\\\\";
                        }
                        if (i == 0) {
                            if (((List)subpos.get((Integer)pos.get(i))).size() == 1) {
                                subarr = new ArrayList<String>(Arrays.asList(this.substr(newFrag, (Integer)pos.get(i) + 7, (Integer)pos.get(i + 1) - (Integer)pos.get(i) - 15)));
                            } else {
                                subarr = new ArrayList<String>(Arrays.asList(newFrag.substring((Integer)pos.get(i) + 7, (Integer)((List)subpos.get((Integer)pos.get(i))).get(1))));
                                for (j = 2; j < ((List)subpos.get((Integer)pos.get(i))).size(); ++j) {
                                    subarr.add(newFrag.substring((Integer)((List)subpos.get((Integer)pos.get(i))).get(j - 1) + 1, (Integer)((List)subpos.get((Integer)pos.get(i))).get(j)));
                                }
                                subarr.add(newFrag.substring((Integer)((List)subpos.get((Integer)pos.get(i))).get(((List)subpos.get((Integer)pos.get(i))).size() - 1) + 1, (Integer)pos.get(i + 1) - 8));
                            }
                        } else if (((List)subpos.get((Integer)pos.get(i))).size() == 1) {
                            subarr = new ArrayList<String>(Arrays.asList(this.substr(newFrag, (Integer)pos.get(i) + 8, (Integer)pos.get(i + 1) - (Integer)pos.get(i) - 16)));
                        } else {
                            subarr = new ArrayList<String>(Arrays.asList(newFrag.substring((Integer)pos.get(i) + 8, (Integer)((List)subpos.get((Integer)pos.get(i))).get(1))));
                            for (j = 2; j < ((List)subpos.get((Integer)pos.get(i))).size(); ++j) {
                                subarr.add(newFrag.substring((Integer)((List)subpos.get(i)).get(j - 1) + 1, (Integer)((List)subpos.get(i)).get(j)));
                            }
                            subarr.add(newFrag.substring((Integer)((List)subpos.get((Integer)pos.get(i))).get(((List)subpos.get((Integer)pos.get(i))).size() - 1) + 1, (Integer)pos.get(i + 1) - 8));
                        }
                        if (lastmxsubcnt > 0 && subarr.size() != lastmxsubcnt) {
                            matrix = false;
                        } else if (lastmxsubcnt == -1) {
                            lastmxsubcnt = subarr.size();
                        }
                        for (int z = 0; z < subarr.size(); ++z) {
                            mxout = mxout + (String)subarr.get(z);
                            if (z >= subarr.size() - 1) continue;
                            mxout = mxout + "&";
                        }
                    }
                }
                mxout = mxout + "\\end{matrix}";
                if (matrix) {
                    newFrag = mxout;
                }
            }
            str = this.AMremoveCharsAndBlanks(str, symbol.input.length());
            if (!symbol.hasFlag("invisible")) {
                node = "\\right" + this.AMTgetTeXsymbol(symbol);
                newFrag = newFrag + node;
                addedright = true;
            } else {
                newFrag = newFrag + "\\right.";
                addedright = true;
            }
        }
        if (this.AMnestingDepth > 0 && !addedright) {
            newFrag = newFrag + "\\right.";
        }
        return new String[]{newFrag, str};
    }

    private String patchColor(String latex) {
        return latex.replace("\\color{", "\\textcolor{");
    }

    public String getTeX(String asciiMathInput) {
        this.AMnestingDepth = 0;
        this.AMpreviousSymbol = 0;
        this.AMcurrentSymbol = 0;
        String result = this.AMTparseExpr(asciiMathInput, false)[0];
        return this.patchColor(result);
    }

    static {
        ASCIIMathTeXImg.AMinitSymbols();
    }

    static class Tupple {
        private final String input;
        private final String tag;
        private final String output;
        private final String tex;
        private final int ttype;
        private final String[] rewriteleftright;
        private final Collection<String> flags;

        private Tupple(String[] rewriteleftright, String input, String tag, String output, String tex, int ttype, String ... flags) {
            this.input = input;
            this.tag = tag;
            this.output = output;
            this.tex = tex;
            this.ttype = ttype;
            this.flags = Arrays.asList(flags);
            this.rewriteleftright = rewriteleftright;
        }

        private Tupple(String input, String tag, String output, String tex, int ttype, String ... flags) {
            this.input = input;
            this.tag = tag;
            this.output = output;
            this.tex = tex;
            this.ttype = ttype;
            this.flags = Arrays.asList(flags);
            this.rewriteleftright = null;
        }

        public boolean hasFlag(String flagName) {
            return this.flags.contains(flagName);
        }
    }
}

