/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.regexdiagram;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.ebnf.ETile;
import net.sourceforge.plantuml.ebnf.ETileAlternation;
import net.sourceforge.plantuml.ebnf.ETileBox;
import net.sourceforge.plantuml.ebnf.ETileConcatenation;
import net.sourceforge.plantuml.ebnf.ETileLookAheadOrBehind;
import net.sourceforge.plantuml.ebnf.ETileNamedGroup;
import net.sourceforge.plantuml.ebnf.ETileOneOrMore;
import net.sourceforge.plantuml.ebnf.ETileOptional2;
import net.sourceforge.plantuml.ebnf.ETileRegexGroup;
import net.sourceforge.plantuml.ebnf.ETileRegexGroupAllBut;
import net.sourceforge.plantuml.ebnf.ETileZeroOrMore;
import net.sourceforge.plantuml.ebnf.Symbol;
import net.sourceforge.plantuml.jsondiagram.StyleExtractor;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.regexdiagram.GroupSplitter;
import net.sourceforge.plantuml.regexdiagram.ReToken;
import net.sourceforge.plantuml.regexdiagram.ReTokenType;
import net.sourceforge.plantuml.regexdiagram.RegexExpression;
import net.sourceforge.plantuml.regexdiagram.RegexParsingException;
import net.sourceforge.plantuml.regexdiagram.ShuntingYard;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.parser.StyleParsingException;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.CharInspector;

public class PSystemRegex
extends TitledDiagram {
    private final Deque<ETile> stack = new ArrayDeque<ETile>();
    private final FontConfiguration fontConfiguration;
    private final Style style;
    private final HColorSet colorSet;
    private final HColor lineColor;

    public PSystemRegex(UmlSource source, PreprocessingArtifact preprocessing) {
        super(source, UmlDiagramType.REGEX, null, preprocessing);
        StyleExtractor styleExtractor = new StyleExtractor(source.iterator2());
        ISkinParam skinParam = this.getSkinParam();
        try {
            styleExtractor.applyStyles(skinParam);
        }
        catch (StyleParsingException e) {
            e.printStackTrace();
        }
        this.style = ETile.getStyleSignature().getMergedStyle(skinParam.getCurrentStyleBuilder());
        this.fontConfiguration = this.style.getFontConfiguration(skinParam.getIHtmlColorSet());
        this.colorSet = skinParam.getIHtmlColorSet();
        this.lineColor = this.style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Regular Expression)");
    }

    @Override
    protected ImageData exportDiagramNow(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextMainBlock(fileFormatOption)).write(os);
    }

    @Override
    protected TextBlock getTextMainBlock(FileFormatOption fileFormatOption) {
        final ETile peekFirst = this.stack.peekFirst();
        AbstractTextBlock tb = new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                peekFirst.drawU(ug.apply(PSystemRegex.this.lineColor));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return peekFirst.calculateDimension(stringBounder);
            }
        };
        return TextBlockUtils.addBackcolor(tb, null);
    }

    public CommandExecutionResult addBlocLines(BlocLines from) {
        try {
            CharInspector it = from.inspector();
            List<ReToken> parsed1 = RegexExpression.parse(it);
            List<ReToken> parsed2 = this.addImplicitConcatenation(parsed1);
            ShuntingYard shuntingYard = new ShuntingYard(parsed2.iterator());
            List<ReToken> result = shuntingYard.getOuputQueue();
            for (ReToken token : result) {
                if (token.getType() == ReTokenType.SIMPLE_CHAR) {
                    this.pushEtileBox(token, Symbol.TERMINAL_STRING1);
                    continue;
                }
                if (token.getType() == ReTokenType.ESCAPED_CHAR) {
                    this.pushEtileBox(token, Symbol.TERMINAL_STRING1);
                    continue;
                }
                if (token.getType() == ReTokenType.GROUP) {
                    this.pushRegexGroup(token);
                    continue;
                }
                if (token.getType() == ReTokenType.LOOK_AHEAD) {
                    this.lookAheadOrBehind(token.getData());
                    continue;
                }
                if (token.getType() == ReTokenType.LOOK_BEHIND) {
                    this.lookAheadOrBehind(token.getData());
                    continue;
                }
                if (token.getType() == ReTokenType.NAMED_GROUP) {
                    this.namedGroup(token.getData());
                    continue;
                }
                if (token.getType() == ReTokenType.CLASS) {
                    this.pushEtileBox(token, Symbol.LITTERAL);
                    continue;
                }
                if (token.getType() == ReTokenType.ANCHOR) {
                    this.pushEtileBox(token, Symbol.LITTERAL);
                    continue;
                }
                if (token.getType() == ReTokenType.CONCATENATION_IMPLICIT) {
                    this.concatenation();
                    continue;
                }
                if (token.getType() == ReTokenType.ALTERNATIVE) {
                    this.alternation();
                    continue;
                }
                if (token.getType() == ReTokenType.QUANTIFIER && token.getData().startsWith("*")) {
                    this.repetitionZeroOrMore();
                    continue;
                }
                if (token.getType() == ReTokenType.QUANTIFIER && token.getData().startsWith("+")) {
                    this.repetitionOneOrMore();
                    continue;
                }
                if (token.getType() == ReTokenType.QUANTIFIER && token.getData().startsWith("?")) {
                    this.optional();
                    continue;
                }
                if (token.getType() == ReTokenType.QUANTIFIER && token.getData().startsWith("{")) {
                    this.repetitionOneOrMore(token.getData());
                    continue;
                }
                throw new RegexParsingException(token.toString());
            }
        }
        catch (RegexParsingException ex) {
            return CommandExecutionResult.error("Error parsing: " + ex.getMessage());
        }
        return CommandExecutionResult.ok();
    }

    private List<ReToken> addImplicitConcatenation(List<ReToken> list) {
        ArrayList<ReToken> result = new ArrayList<ReToken>();
        for (ReToken token : list) {
            if (result.size() > 0 && ReTokenType.needImplicitConcatenation(((ReToken)result.get(result.size() - 1)).getType(), token.getType())) {
                result.add(new ReToken(ReTokenType.CONCATENATION_IMPLICIT, ""));
            }
            result.add(token);
        }
        return result;
    }

    private void pushEtileBox(ReToken element, Symbol type) {
        this.stack.addFirst(new ETileBox(element.getData(), type, this.fontConfiguration, this.style, this.colorSet, this.getSkinParam(), this.getPreprocessingArtifact().getOption()));
    }

    private void pushRegexGroup(ReToken element) {
        List<String> elements = new GroupSplitter().split(element.getData());
        if (elements.get(0).equals("^")) {
            this.stack.addFirst(new ETileRegexGroupAllBut(elements, this.fontConfiguration, this.style, this.colorSet, this.getSkinParam()));
        } else {
            this.stack.addFirst(new ETileRegexGroup(elements, this.fontConfiguration, this.style, this.colorSet, this.getSkinParam()));
        }
    }

    private void lookAheadOrBehind(String name) {
        ETile arg1 = this.stack.removeFirst();
        this.stack.addFirst(new ETileLookAheadOrBehind(arg1, this.fontConfiguration, this.style, this.colorSet, name));
    }

    private void namedGroup(String name) {
        ETile arg1 = this.stack.removeFirst();
        this.stack.addFirst(new ETileNamedGroup(arg1, this.fontConfiguration, this.colorSet, this.getSkinParam(), name));
    }

    private void repetitionZeroOrMore() {
        ETile arg1 = this.stack.removeFirst();
        this.stack.addFirst(new ETileZeroOrMore(arg1, this.getSkinParam()));
    }

    private void optional() {
        ETile arg1 = this.stack.removeFirst();
        this.stack.addFirst(new ETileOptional2(arg1, this.getSkinParam()));
    }

    private void repetitionOneOrMore() {
        ETile arg1 = this.stack.removeFirst();
        this.stack.addFirst(new ETileOneOrMore(arg1));
    }

    private void repetitionOneOrMore(String repetition) {
        ETile arg1 = this.stack.removeFirst();
        this.stack.addFirst(new ETileOneOrMore(arg1, repetition, this.fontConfiguration.bigger(-2.0), this.getSkinParam()));
    }

    private void alternation() {
        ETile arg1 = this.stack.removeFirst();
        ETile arg2 = this.stack.removeFirst();
        if (arg1 instanceof ETileAlternation) {
            arg1.push(arg2);
            this.stack.addFirst(arg1);
        } else if (arg2 instanceof ETileAlternation) {
            arg2.push(arg1);
            this.stack.addFirst(arg2);
        } else {
            ETileAlternation concat = new ETileAlternation();
            ((ETile)concat).push(arg1);
            ((ETile)concat).push(arg2);
            this.stack.addFirst(concat);
        }
    }

    private void concatenation() {
        ETile arg1 = this.stack.removeFirst();
        ETile arg2 = this.stack.removeFirst();
        if (this.isBoxMergeable(arg1) && this.isBoxMergeable(arg2)) {
            ETileBox box1 = (ETileBox)arg1;
            ETileBox box2 = (ETileBox)arg2;
            this.stack.addFirst(box2.mergeWith(box1));
            return;
        }
        if (this.isConcatenation1Mergeable(arg1) && this.isBoxMergeable(arg2)) {
            ETileConcatenation concat1 = (ETileConcatenation)arg1;
            ETileBox box1 = (ETileBox)concat1.getFirst();
            ETileBox box2 = (ETileBox)arg2;
            concat1.overideFirst(box2.mergeWith(box1));
            this.stack.addFirst(concat1);
            return;
        }
        if (arg1 instanceof ETileConcatenation) {
            arg1.push(arg2);
            this.stack.addFirst(arg1);
        } else {
            ETileConcatenation concat = new ETileConcatenation();
            ((ETile)concat).push(arg1);
            ((ETile)concat).push(arg2);
            this.stack.addFirst(concat);
        }
    }

    private boolean isConcatenation1Mergeable(ETile tile) {
        if (tile instanceof ETileConcatenation) {
            ETileConcatenation concat = (ETileConcatenation)tile;
            return this.isBoxMergeable(concat.getFirst());
        }
        return false;
    }

    private boolean isBoxMergeable(ETile tile) {
        if (tile instanceof ETileBox) {
            ETileBox box = (ETileBox)tile;
            return box.getSymbol() == Symbol.TERMINAL_STRING1;
        }
        return false;
    }
}

