/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.picoweb;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.picoweb.BadRequest400;

public class ReceivedHTTPRequest {
    private static final String CONTENT_LENGTH_HEADER = "content-length: ";
    private String method;
    private String path;
    private byte[] body;

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public byte[] getBody() {
        return this.body;
    }

    public static ReceivedHTTPRequest fromStream(InputStream in) throws IOException {
        String line;
        ReceivedHTTPRequest request = new ReceivedHTTPRequest();
        String requestLine = ReceivedHTTPRequest.readLine(in);
        StringTokenizer tokenizer = new StringTokenizer(requestLine);
        if (tokenizer.countTokens() != 3) {
            throw new BadRequest400("Bad request line");
        }
        request.method = tokenizer.nextToken().toUpperCase();
        request.path = tokenizer.nextToken();
        int contentLength = 0;
        while (!(line = ReceivedHTTPRequest.readLine(in)).isEmpty()) {
            if (!line.toLowerCase().startsWith(CONTENT_LENGTH_HEADER)) continue;
            contentLength = ReceivedHTTPRequest.parseContentLengthHeader(line);
        }
        request.body = ReceivedHTTPRequest.readBody(in, contentLength);
        return request;
    }

    private static int parseContentLengthHeader(String line) throws IOException {
        int contentLength;
        try {
            contentLength = Integer.parseInt(line.substring(CONTENT_LENGTH_HEADER.length()).trim());
        }
        catch (NumberFormatException e) {
            throw new BadRequest400("Invalid content length");
        }
        if (contentLength < 0) {
            throw new BadRequest400("Negative content length");
        }
        return contentLength;
    }

    private static byte[] readBody(InputStream in, int contentLength) throws IOException {
        int count;
        if (contentLength == 0) {
            return new byte[0];
        }
        byte[] body = new byte[contentLength];
        int offset = 0;
        for (int n = 0; n < contentLength; n += count) {
            count = in.read(body, offset + n, contentLength - n);
            if (count >= 0) continue;
            throw new BadRequest400("Body too short");
        }
        return body;
    }

    private static String readLine(InputStream in) throws IOException {
        int c;
        StringBuilder builder = new StringBuilder();
        while ((c = in.read()) != -1 && c != 10) {
            builder.append((char)c);
        }
        if (builder.length() > 0 && builder.charAt(builder.length() - 1) == '\r') {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }
}

