/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.api.cheerpj.v1;

import com.plantuml.api.cheerpj.JsonResult;
import com.plantuml.api.cheerpj.StringBounderCanvas;
import com.plantuml.api.cheerpj.Utils;
import com.plantuml.api.cheerpj.WasmLog;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.g2d.UGraphicG2d;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.preproc.Defines;

public class DirectDraw {
    public static Frame frame;
    public static Graphics2D g2d;
    private static int frameWidth;
    private static int frameHeight;

    public static Object initArea(int width, int height) {
        long start;
        WasmLog.start = start = System.currentTimeMillis();
        WasmLog.log("initCanvas");
        if (g2d == null) {
            frameWidth = width;
            frameHeight = height;
            frame = new Frame();
            frame.setUndecorated(true);
            frame.setSize(frameWidth, frameHeight);
            frame.setLayout(null);
            frame.setVisible(true);
            g2d = (Graphics2D)frame.getGraphics();
            WasmLog.log("initCanvas done = " + frame);
            return 45;
        }
        WasmLog.log("initCanvas skipped because it has already been done");
        return 47;
    }

    public static Object draw(String mode, String text) {
        long start;
        WasmLog.start = start = System.currentTimeMillis();
        try {
            text = Utils.cleanText(text);
            BlockUmlBuilder builder = new BlockUmlBuilder(Collections.emptyList(), StandardCharsets.UTF_8, Defines.createEmpty(), (Reader)new StringReader(text), null, "string");
            List<BlockUml> blocks = builder.getBlockUmls();
            if (blocks.size() == 0) {
                return JsonResult.noDataFound(start);
            }
            WasmLog.log("...loading data...");
            Diagram system = blocks.get(0).getDiagram();
            if (system instanceof PSystemError) {
                ErrorUml error = ((PSystemError)system).getFirstError();
                WasmLog.log("[" + error.getPosition() + "] " + error.getError());
                return JsonResult.fromError(start, (PSystemError)system);
            }
            WasmLog.log("...processing...");
            HColor back = HColors.simple(Color.WHITE);
            StringBounderCanvas stringBounder = new StringBounderCanvas(g2d);
            UGraphicG2d ug = new UGraphicG2d(back, ColorMapper.IDENTITY, stringBounder, g2d, 1.0, FileFormat.PNG);
            WasmLog.log("...cleaning...");
            ug.apply(back).apply(back.bg()).draw(URectangle.build(frameWidth, frameHeight));
            WasmLog.log("...drawing...");
            system.exportDiagramGraphic(ug, new FileFormatOption(FileFormat.PNG));
            WasmLog.log("done!");
            return JsonResult.ok(start, null, system);
        }
        catch (Throwable t) {
            WasmLog.log("Fatal error " + t);
            return JsonResult.fromCrash(start, t);
        }
    }
}

