# 專門術語 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## 專門術語

這頁列出本IG必須及可能需要使用的所有專門術語(terminology)

### 值集(ValueSets)

* [LOINC Code Document Section值集](ValueSet-loinc-doc-section-code.md)
* [LOINC Code Document Type值集](ValueSet-loinc-type-doc-code.md)
* [LOINC Document Class值集](ValueSet-loinc-document-classcodes.md)
* [LOINC生命體徵值集](ValueSet-vital-signs-tw.md)
* [臺灣核心-實驗室檢驗檢查值集](ValueSet-laboratory-code-tw.md)
* [LOINC實驗室檢驗檢查值集](ValueSet-loinc-observation-code.md)
* [LOINC篩檢與評估值集](ValueSet-loinc-survey-codes.md)
* [LOINC + HL7 NullFlavor妊娠計畫值集](ValueSet-loinc-pregnancy-intent-code.md)
* [RxNorm藥品代碼值集](ValueSet-medication-rxnorm-tw.md)
* [HL7 OrderableDrugForm藥品劑型值集](ValueSet-v3-orderableDrugForm.md)
* [SNOMED CT診斷代碼值集](ValueSet-condition-code-sct-tw.md)
* [對應至 SNOMED CT之就醫科別 + 診療科別值集](ValueSet-medical-department-sct-tw.md)
* [SNOMED CT + HL7 NullFlavor性傾向值集](ValueSet-snomed-sexual-orientation-code.md)
* [SNOMED CT + HL7 NullFlavor妊娠狀態值集](ValueSet-snomed-pregnancy-status-code.md)
* [SNOMED CT + LOINC吸菸狀態種類向值集](ValueSet-smoking-status-type-code.md)
* [SNOMED CT + 臺灣健保署給藥途徑值集](ValueSet-medication-path-sct-tw.md)
* [SNOMED CT + 臺灣醫事司醫事人員類別值集](ValueSet-health-professional-sct-tw.md)
* [SNOMED CT 吸菸狀態綜合評估值集](ValueSet-smoking-status-comprehensive-code.md)
* [無法對應至 SNOMED CT之臺灣健保署就醫科別值集](ValueSet-medical-consultation-department-tw.md)
* [無法對應至 SNOMED CT之臺灣健保署診療科別值集](ValueSet-medical-treatment-department-tw.md)
* [HL7 TimingAbbreviation + 臺灣健保署藥品使用頻率值集](ValueSet-medication-frequency-hl7-tw.md)
* [HL7 Provenance participant type + 臺灣衛福部資訊處Provenance參與類型](ValueSet-provenance-participant-type-hl7-tw.md)
* [IdentifierType + 臺灣衛福部資訊處識別碼類型值集](ValueSet-identifier-type-tw.md)
* [臺灣壽險公會傷害保險個人職業分類表值集](ValueSet-occupation-lia-roc-tw.md)
* [臺灣勞動部職業標準分類值集](ValueSet-occupation-mol-tw.md)
* [行政院主計總處行業分類值集](ValueSet-industry-dgbas-tw.md)
* [臺灣戶政司婚姻狀態值集](ValueSet-marital-status-tw.md)
* [臺灣醫事司醫事人員類別值集](ValueSet-health-professional-tw.md)
* [臺灣醫事司醫事機構代碼值集](ValueSet-organization-identifier-tw.md)
* [臺灣衛福部資訊處類型代碼值集](ValueSet-category-code-tw.md)
* [臺灣衛福部資訊處Narrative狀態值集](ValueSet-narrative-status.md)
* [臺灣衛福部資訊處Observation Clinical Result類型值集](ValueSet-observation-clinical-result-category.md)
* [臺灣衛福部資訊處Observation Screening Assessment類型值集](ValueSet-observation-screening-assessment-category.md)
* [臺灣衛福部資訊處ServiceRequest類型值集](ValueSet-serviceRequest-category.md)
* [臺灣中華郵政3碼郵遞區號值集](ValueSet-postal-code3-tw.md)
* [臺灣中華郵政5碼郵遞區號值集](ValueSet-postal-code5-tw.md)
* [臺灣中華郵政6碼郵遞區號值集](ValueSet-postal-code6-tw.md)
* [臺灣健保署2001年中文版ICD-9-CM值集](ValueSet-icd-9-cm-2001-tw.md)
* [臺灣健保署2014年中文版ICD-10-CM值集](ValueSet-icd-10-cm-2014-tw.md)
* [臺灣健保署2014年中文版ICD-10-PCS值集](ValueSet-icd-10-pcs-2014-tw.md)
* [臺灣健保署2021年中文版ICD-10-CM值集](ValueSet-icd-10-cm-2021-tw.md)
* [臺灣健保署2021年中文版ICD-10-PCS值集](ValueSet-icd-10-pcs-2021-tw.md)
* [臺灣健保署2023年中文版ICD-10-CM值集](ValueSet-icd-10-cm-2023-tw.md)
* [臺灣健保署2023年中文版ICD-10-PCS值集](ValueSet-icd-10-pcs-2023-tw.md)
* [臺灣健保署用藥品項代碼值集](ValueSet-medication-nhi-tw.md)
* [臺灣健保署中藥用藥品項值集](ValueSet-nhi-medication-ch-herb-tw.md)
* [臺灣健保署就醫科別值集](ValueSet-medical-consultation-department-nhi-tw.md)
* [臺灣健保署藥品使用頻率值集](ValueSet-medication-frequency-nhi-tw.md)
* [臺灣健保署診療科別值集](ValueSet-medical-treatment-department-nhi-tw.md)
* [臺灣健保署醫療服務給付項目-處置或手術值集](ValueSet-procedure-tw.md)
* [臺灣健保署醫療服務給付項目-檢驗值集](ValueSet-laboratory-category-tw.md)
* [臺灣健保署給藥途徑值集](ValueSet-medication-path-tw.md)
* [臺灣食藥署藥品及醫療器材代碼值集](ValueSet-medication-fda-tw.md)
* [臺灣食藥署藥品藥理治療分類ATC碼值集](ValueSet-medcation-atc-tw.md)

### 代碼系統(CodeSystems)

* [臺灣壽險公會傷害保險個人職業分類表](CodeSystem-occupation-lia-roc-tw.md)
* [臺灣勞動部職業標準分類](CodeSystem-occupation-mol-tw.md)
* [行政院主計總處行業分類](CodeSystem-industry-dgbas-tw.md)
* [臺灣醫事司醫事人員類別](CodeSystem-health-professional-tw.md)
* [臺灣醫事司醫事機構代碼](CodeSystem-organization-identifier-tw.md)
* [臺灣戶政司婚姻狀態](CodeSystem-marital-status-tw.md)
* [臺灣衛福部資訊處識別碼類型](CodeSystem-v2-0203.md)
* [臺灣衛福部資訊處照護計畫類別](CodeSystem-careplan-category-tw.md)
* [臺灣衛福部資訊處類型代碼](CodeSystem-category-code-tw.md)
* [臺灣衛福部資訊處Provenance參與類型](CodeSystem-provenance-participant-type-tw.md)
* [臺灣中華郵政3碼郵遞區號](CodeSystem-postal-code3-tw.md)
* [臺灣中華郵政5碼郵遞區號](CodeSystem-postal-code5-tw.md)
* [臺灣中華郵政6碼郵遞區號](CodeSystem-postal-code6-tw.md)
* [臺灣健保署2001年中文版ICD-9-CM](CodeSystem-icd-9-cm-2001-tw.md)
* [臺灣健保署2014年中文版ICD-10-CM](CodeSystem-icd-10-cm-2014-tw.md)
* [臺灣健保署2014年中文版ICD-10-PCS](CodeSystem-icd-10-pcs-2014-tw.md)
* [臺灣健保署2021年中文版ICD-10-CM](CodeSystem-icd-10-cm-2021-tw.md)
* [臺灣健保署2021年中文版ICD-10-PCS](CodeSystem-icd-10-pcs-2021-tw.md)
* [臺灣健保署2023年中文版ICD-10-CM](CodeSystem-icd-10-cm-2023-tw.md)
* [臺灣健保署2023年中文版ICD-10-PCS](CodeSystem-icd-10-pcs-2023-tw.md)
* [臺灣健保署用藥品項](CodeSystem-medication-nhi-tw.md)
* [臺灣健保署中藥用藥品項](CodeSystem-nhi-medication-ch-herb-tw.md)
* [臺灣健保署就醫科別](CodeSystem-medical-consultation-department-nhi-tw.md)
* [臺灣健保署藥品使用頻率](CodeSystem-medication-frequency-nhi-tw.md)
* [臺灣健保署診療科別](CodeSystem-medical-treatment-department-nhi-tw.md)
* [臺灣健保署醫療服務給付項目](CodeSystem-medical-service-payment-tw.md)
* [臺灣健保署給藥途徑](CodeSystem-medication-path-tw.md)
* [臺灣食藥署藥品許可證](CodeSystem-medication-fda-tw.md)
* [臺灣食藥署醫療器材許可證](CodeSystem-medication-device-fda-tw.md)
* [臺灣食藥署藥品藥理治療分類ATC碼](CodeSystem-medcation-atc-tw.md)

### 概念對應(ConceptMaps)

* [臺灣健保署診療科別代碼對應SNOMED CT](ConceptMap-medical-treatment-department-nhi-tw.md)
* [臺灣健保署就醫科別代碼對應SNOMED CT](ConceptMap-medical-consultation-department-nhi-tw.md)
* [臺灣健保署給藥途徑代碼對應SNOMED CT](ConceptMap-medication-path-tw.md)
* [臺灣健保署藥品使用頻率代碼對應對應HL7 TimingAbbreviation](ConceptMap-medication-frequency-tw.md)
* [臺灣醫事司醫事人員類別代碼對應SNOMED CT及臺灣醫事司醫事人員類別](ConceptMap-health-professional-tw.md)
* [臺灣戶政司婚姻狀態代碼對應HL7 MaritalStatus](ConceptMap-marital-status-tw.md)

