# 應用說明 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## 應用說明

| | |
| :--- | :--- |
|  | *Computable Name*: |

因考量實作需求，於2025/12/09異動以下內容：
1. 修正多項QA錯誤：
* 包含CapabilityStatement列表顯示、Immunization範例、新增AcquisitionModality定義、移除ConceptMap版本限制，並優化ImagingStudy與Observation Profile。
* 修正 TW Core Observation Treatment Intervention Preference 範例 (`obs-treatment-intervention-preference-example`)，`performer` 參照由 Patient 改為 Practitioner。
* TW Core Observation Occupation Profile：修正 `MolOccupation` 資料項目中職業代碼系統網址 (CodeSystem URL) 為 `https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/occupation-mol-tw`。
* 修正 臺灣健保署2023年中文版ICD-10-CM 與 臺灣健保署2023年中文版ICD-10-PCS 代碼系統網址 (CodeSystem URL)。
* 修正 臺灣健保署2014年中文版ICD-10-PCS、臺灣健保署中藥用藥品項 與 臺灣健保署健保用藥品項代碼 拼字錯誤。

1. 強化代碼集(ValueSet)內容：
* LOINC相關代碼 (LOINC Observation Code、LOINC Survey Code)：調整篩選條件 (CLASSTYPE) 的值，由文字描述 ("Laboratory class", "Clinical class", "Surveys") 改為對應的代碼 ("1", "2", "4")。
* TW Core Medication Path SCT：新增「口服」代碼 (`$TWMedicationPath#PO`)。
* TW Core Vital Signs：新增 4 項 LOINC 代碼，包含血氧 (`59408-5`)、頭圍百分位 (`8289-1`)、BMI百分位 (`59576-9`) 及體重身長比 (`77606-2`)。

1. 新增臺灣核心-心電圖(TW Core Observation ECG) Profile及相關範例。
1. 新增臺灣核心-實驗室檢驗檢查值集。
1. 更新 TWCDI。
1. 更新代碼系統臺灣健保署用藥品項。
請留意這些異動，以避免影響您的實作。

### 介紹

臺灣核心實作指引（Taiwan Core Implementation Guide，簡稱TW core IG）採用HL7® FHIR® standard（Fast Healthcare Interoperability Resources）IG建置方法，在[FHIR R4.0.1](http://hl7.org/fhir/R4/)之標準基礎上，參考了[國際病人摘要（International Patient Summary，IPS）1.1.0-CI Build](https://build.fhir.org/ig/HL7/fhir-ips/)及[美國核心實作指引（US Core Implementation Guide）](https://www.hl7.org/fhir/us/core/)，進一步定義適用於臺灣健康照護資料交換需求的Resources（類似資料表）、其中的資料項目（意即欄位）、基數（意即0..1、0..*、1..1或1..*）、資料類型（文字、日期時間、代碼等）、可綁定的代碼（及其綁定的強制程度）及查詢參數等，旨在提供健康照護資訊系統開發與實作者以TW Core IG為基礎，再進一步訂定其實務專案所需之資料交換格式以應用於專案中。TW Core IG的實作方式有兩種：

1. **僅支援Profiles**：系統僅支援TW Core Profiles以呈現健康照護相關資料。
1. **支援Profiles + RESTful互動**：系統支援TW Core Profiles及RESTful互動以呈現健康照護相關資料。

### 背景

TW Core IG由衛生福利部(以下簡稱衛福部)資訊處2022年3月招標之「111年度智慧健康雲專案辦公室營運案專案」及2025年3月招標之「114年度次世代數位醫療平臺專案辦公室」經費支應下建置，TW Core IG註冊於[國際平臺](http://fhir.org/guides/registry/)及衛生福利部資訊處之[IG管理平臺](https://twcore.mohw.gov.tw/twregistry/#/data)以供查找與參考。

鑑於TW Core IG設計之初，FHIR R5處於投票階段、國際應用多採用 R4 、以及R5相關配套工具尚未成熟，故TW Core IG的設計主要以FHIR R4.0.1 為基礎，並同時參考其他國家作法以規劃TW Core IG 網站。為使制訂之IG符合臺灣的實作需求，TW Core IG 內容將在未來的版本中持續更新，各版本亦將附有版本異動說明。

### 衛福部資訊處在 TW Core IG 的角色與發展主責

衛福部資訊處作為台灣醫療及健康照護資訊標準化的主要推動單位，在TW Core IG的制定和發展中扮演了核心角色，主要包括：
* **領導 TW Core IG 的標準制定**：積極協調其所屬機關、平行機構、醫療機構、學術單位及相關專業組織，以確保 TW Core IG 能夠滿足台灣的醫療服務、健康照護、公共衛生、臨床研究等領域資訊交換的核心資料需求，並與國際標準（如 FHIR及相關配套專門術語標準）接軌。
* **監督國際標準專門術語之維護與運作**：負責監督國際標準專門術語（如 SNOMED CT、LOINC 等）的維護與更新，確保這些術語在 TW Core IG 的應用中保持一致性與準確性，並且與國際標準的變動同步發展，以促進台灣醫療資訊體系的國際接軌。
* **納入資訊安全相關規範於TW Core IG**：積極將各種交易的稽核日誌(audit logs)、[FHIR通訊安全（Communications Security）](https://http://hl7.org/fhir/R4/security.html#http)、[SMART App執行框架（launch framework）](http://www.hl7.org/fhir/smart-app-launch/history.cfml)納入TW Core IG的資訊安全性規範，以提升台灣醫療機構在智慧型應用程式和跨機構數據共享中的應用能力，從而支持更安全且一致的健康資訊交換，強化互通性和資料整合。
* **推廣 TW Core IG 於實務專案的應用**：致力於推動相關補助計畫，提供可公用的標準技術工具、並鼓勵醫療機構及相關機構採用及繼承 TW Core IG，實現台灣醫療資料的高度互通與共享，以增進資料使用效率及醫療品質。

衛福部資訊處的長期任務：

* **持續更新與維護**：根據國內外醫療需求、技術進步及國際標準的變化，定期更新TW Core IG及相關國際標準專門術語，並適時納入必要的規範，以確保 TW Core 標準不僅符合當前醫療資訊技術的發展，亦能滿足未來醫療服務的需求。
* **推廣與應用**：協助全台醫療機構及相關單位採用並遵循 TW Core 標準，以確保這些標準被廣泛應用於臨床與公共衛生資料的傳輸與共享，促進台灣醫療資訊的整體應用效率。
* **促進全台醫療資訊的可互通性**：持續強化台灣醫療資訊的標準化，確保醫療資料能在不同機構間無縫共享，以提升醫療服務品質。

### 繼承 TW Core IG 版本的考量

關於實務專案型FHIR IG是否需要繼承最新版本TW Core IG或者要等[TW Core IG持續建置版本 (CI-build)](https://build.fhir.org/ig/cctwFHIRterm/MOHW_TWCoreIG_Build/index.html)正式定版後作繼承？通常，各專案可依據各自專案的需求決定，但 IG 設計師需審慎評估，以決定是否繼承最新版TW Core IG： 
(1) 須留意TW Core IG的CI-build版本是否影響專案資料欄位或值集範圍設計，建議可預先在設計階段納入CI-build的設計概念及內容，待CI-Build發布新版時可直接繼承，以減少更新繼承對規格設計造成影響、 
(2) 須評估專案型IG是否需要[申請註冊](https://emr.mohw.gov.tw/myemr/Html/EmrInfo#emrinfo_0)於衛生福利部資訊處 [IG 管理平臺](https://twcore.mohw.gov.tw/twregistry/#/data)以供各界參閱以及讓您的專案IG出現於國際HL7提供的線上免費驗證工具 ([https://validator.fhir.org/](https://validator.fhir.org/)) 中的IG驗證清單中，增加驗證的方便性。若要申請註冊且無特殊理由下，則建議使用審查期間最新版之TW Core IG版本。 

不論如何，基於全國健康照護資料標準化及促進資料可互通，**「強力建議」**實務專案型IG 繼承最新版TW Core IG，以確保您的IG規格與全國一致，亦可避免後續人工檢核專案IG與TW Core IG是否一致之工作量。 

2024年5月起依據衛生福利部資訊處電子病歷標準發展工作小組決議，預計每年正式更版一至二次，由於資料標準化是一個持續演進的過程，TW Core IG 亦會持續接受各界意見並評估適用性後放修改於[TW Core IG持續建置版本 (CI-build)](https://build.fhir.org/ig/cctwFHIRterm/MOHW_TWCoreIG_Build/index.html)，經確認後才會更新為正式版本，需請 IG 設計師 留意此一異動對您所設計IG之影響。

### 如何閱讀這個實作指引（IG）

TW Core IG之網站架構圖如下圖所示。各功能說明如下：

* **[應用說明](index.md)**：TW Core IG介紹及背景說明。
* **[規範文件](artifacts.md)** 
* **[能力聲明](capabilitystatements.md)**：應用TW Core IG於建置業務目的使用的FHIR Server時，該FHIR Server必須及建議應該支援的操作功能。 
* **[查詢參數及操作定義](searchparameters-and-operation.md)**：查詢FHIR Server的Profiles時，針對各Profiles可使用的查詢參數及操作定義。 
* **[邏輯模型](models.md)**：TW Core IG的所有邏輯模型（Logical Models），各邏輯模型會定義相應情境下使用的所有資料欄位。為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。 
* **[FHIR Profiles及Extensions](profiles-and-extensions.md)**： 
* TW Core IG的所有Profiles之定義與範例及Extensions。
* 各資料項目不同實作強制程度的Terminology。
* 各資料項目的限制（Constraints）。
* 查詢依據TW Core IG實作之FHIR Server的特定Profiles時，可使用的查詢參數。
* 有哪些Profiles具有查詢參數以及Server必須支援哪些必要的查詢參數功能。
 
* **[專門術語](terminologies.md)**：TW Core IG網站所使用的專門術語，包括代碼系統（Code Systems）及值集（Value Sets），內容主要依據全國專門術語服務平臺（TW terminology services）建置。 
 
* **[範例](examples.md)**：遵從TW Core IG所定義Profiles之範例。
* **[結構定義與範例檔下載](downloads.md)**：實作者若不偏好使用FHIR RESTful API驗證資料是否遵從Profiles，可直接下載所需的格式驗證檔，包括XML、JSON及Turtle三種格式，亦可於此下載完整範例。
* **[安全性](security.md)**：主要說明採用TW Core IG網站進行實作時，有關資料存取授權的作法。
* **[驗證教學](validates.md)**：如何驗證實作檔是否遵從TW Core IG規範。
* **[版本異動](https://twcore.mohw.gov.tw/ig/twcore/history.html)**：若TW Core IG網站的版本有所異動，皆可透過[異動說明頁](https://twcore.mohw.gov.tw/ig/twcore/history.html)得以瞭解版本間的異動差異。

-------

### 專有名詞定義

#### Profiles 相關

| | | |
| :--- | :--- | :--- |
| Name | 名稱 | resource的資料項目名稱（意即XML元素名稱；JSON或RDF屬性名稱）。有些名稱末端為[x]，圖示為，意即可以選擇適用的資料類型表述該資料項目內容值,故需依據資料類型填入適當的內容值，例如Patient.multipleBirth[x]。![](index/multipleX.png)如果系統只知病人是否多胞胎，則資料項目名稱為multipleBirthBoolean，內容值為「true」；如果系統中有病人多胞胎之出生順序為第2序位，則資料項目名稱為multipleBirthInteger，內容值為「2」。更多符號說明，請參閱[FHIR官網相關說明](http://hl7.org/fhir/R4/formats.html#table)。 |
| Flags | 標記 | 一組有關影響實作者如何操作資料項目的資訊，範例如下。 |
| ![](index/MustSupport.png) | 必須支援（MustSupport），表示用戶端（Client）所傳送之資料項目，伺服端（Server）必須有能力接收並儲存此資料項目。繼承使用時可再依據專案需求，對MS做出延伸定義，但必須於應用說明說明其延伸定義的具體說明。詳可參閱[MustSupport](http://hl7.org/fhir/R4/conformance-rules.html#mustSupport)。 | |
| ![](index/modifier.png) | 表示此資料項目可能會完全修正或改變其他資料項目的意涵，需特別留意。詳可參閱[Modifier](http://hl7.org/fhir/R4/conformance-rules.html#isModifier)。 | |
| ![](index/summary.png) | 表示此資料項目為摘要的一部分，詳可參閱[Summary searches](http://hl7.org/fhir/R4/search.html#summary)。 | |
| ![](index/constraints.png) | 表示此資料項目受規範設定的限制（constraints）影響，例如：Patient.name的限制為「name.text（完整中文姓名）」或name.family（英文姓）或者兩者必須填寫」，詳可參閱[Constraints](http://hl7.org/fhir/R4/conformance-rules.html#constraints)。![](index/constraints_example1.png) | |
| Card. | 基數 | 此資料項目允許出現在這個resource的最小至最大次數，意即例如某一資料項目的基數若為0..1，表示可不填寫或至多填入1筆；若為1..1，表示必須（只能）填入1筆；若為0..*，表示可不填寫或填入多筆（不限筆數）；若為1..*，表示至少要填入1筆或填入多筆（不限筆數）。 |
| Type | 資料類型 | 資料項目的資料類型（可超連結至該型別的定義），例如：boolean、integer、dateTime等。 |
| Description &Constraints | 描述與限制 | 此資料項目的描述及詳細的限制。尤其編碼的資料項目可使用何種代碼填寫，如果有特定需要綁定的代碼，則會以Binding陳述。 |

#### 限制與綁定值集（ValueSet）

如下圖所示，Patient.name的限制為「name.text（完整中文姓名）」或name.family（英文姓）或者兩者必須填寫」；Patient.name.use要求使用NameUse這個值集，而且要求使用（Required）使用該值集中的任一代碼，TW Core Patient規定必須填入「official」。
![](index/constraints_example2.png)

#### 綁定值集（value set）的強度

| | | |
| :--- | :--- | :--- |
| Required | 要求使用 | 應填入值集中的其中一個代碼 |
| Extensible | 可擴充 | 應填入值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。 |
| Preferred | 鼓勵使用 | 鼓勵使用值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。 |
| Example | 範例 | 可參考值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。 |
如下圖所示，telecom.system應使用ContactPointSystem代碼表（或稱代碼系統）中的其中一個代碼，telecom.use及gender也都有應該搭配使用的代碼表，否則以此IG驗證格式時會出現錯誤訊息。

#### 遵從度用語（Conformance Language），或可理解為「應遵從規範的程度」

FHIR使用RFC 2119中定義的遵從度動詞**必須（SHALL）**、**建議應該（SHOULD）**和**可能可以（MAY）**。而FHIR與RFC 2119不同的是，FHIR允許不同的應用程式因使用可選功能的方式而無法達到可互操作性，特別是： 

1. **必須（SHALL）**：所有實作絕對要遵從要求。

2. **必須沒有（SHALL NOT）**：所有實作絕對禁止的要求。

3. **建議應該（SHOULD）/建議不應該（SHOULD NOT）**：實作者在特定實作的情境下考慮的最佳或建議實作方法；雖然忽略一個項目可能有正當理由，但在選擇不同的程序之前，必須了解並慎重衡量所有含義。 

4. **可能可以（MAY）**：這是實作者真正可選的要求；可根據實作者的決定使用或不使用，不會造成任何影響。

#### FHIR 發佈和版本劃分

（資料來源：[Versions - FHIR v4.3.0 （hl7.org）](https://www.hl7.org/fhir/versions.html)） 

FHIR的新版本的發佈週期約為18-24個月，此頻率主要基於需向實作者諮詢、開發和審查新內容、以及ANSI批准的標準所需的正式投票和核對過程所需的時間，這個發佈週期也確保了有機會將實作者對標準規範早期版本的回饋意見納入後續版本，在滿足實作者需求的情況下，偶爾也會出現時間較短的有限範圍的發佈。 

每個新版本都有一個獨特的版本號。FHIR的版本政策是基於[Semantic versioning](http://semver.org/)（或可閱讀下表精簡整理），但由於FHIR是一個標準規範，而不是一個軟體API，因此有一些區別。


FHIR有單一的開發版本，它經由HL7管理的開發週期，每個主要的開發週期都透過正式投票（或不止一次）後才發佈新的標準規範。從版本控管的角度來看，每份發佈的標準規範都是開發主幹的一個分支，然後隨著HL7對發佈的標準規範的維護，其本身可能會發生進一步的改變（儘管這種改變通常是最小的，僅限於必要的技術修正或安全警示）。 

每個FHIR版本由4個部分組成的字串來識別：major.minor.patch-label。 IG的實作亦遵循此規則，其中的major異動將由「**電子病歷交換標準工作小組**」決定，minor及patch可由相關工作小組討論後作調整：

* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: major
  * ?: 當HL7將FHIR作為一個重要的新規格版本發佈時，如FHIR試用版（Trial Use）或標準規範版（Normative），就會增加此序號。
  * ?: 
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 第1次的試用版（Trial Use）是第0版
  * ?: 以0.1.0開始進行版本控管
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 第2次發行（DSTU）是第1版
  * ?: 當所有profiles為FMM2時
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 第3次發行（STU）是第3版（依據實作者要求以統一major序號故跳過「2」）
  * ?: 當所有profiles為FMM3時
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 第4次發行（Normative + STU）是第4版
  * ?: 當所有profiles為FMM4時
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 第5次發行（STU）是第5版
  * ?: 當所有profiles為FMM5時
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: minor
  * ?: 包括微小實質改變的修改（可能包括有限的破壞性改變）
  * ?: 在既有版本上，新增StructureDefinition內容時
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 只要有新版本（major）發佈，minor就重置為0，而在開發分支中為1。
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● HL7不會對已發佈的版本進行重大改變（技術性修正），所以這些版本總是有一個版本號X.n.0。
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 開發中的版本是持續分析、辯論、投票和反復修改，因此可預期STU內容可能會有改變。 FHIR第4B版（僅STU改變）為4.3.0版本。
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: patch
  * ?: 表示更新，包括對先前版本的技術性修正
  * ?: 針對既有版本的StructureDefinition作修改及刪除時
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 只要minor版本改變，patch就會被重置為0例如：4.0.1代表對4.0.0版本的第一次技術性修正 。
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: label
  * ?: 版本末端有一個標籤，代表一個正在建立的標準規範的 「工作 」版本，並正在建立到指定的發行版本；例如，5.0.0-ballot1、5.0.0-snapshot2等。
  * ?: 目前仍持續在修訂與新增TW Core IG內容，故label為cibuild。
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 標籤前端的序號表示在投票、審查結束後的「預期」版本序號。
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● label可以是任何字串，然而典型的標籤是：

### 作者與貢獻者

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| 作者 | v1.0.0 | 衛生福利部資訊處 | 次世代數位醫療平臺專案辦公室 | 次世代數位醫療平臺專案辦公室 | [medstandard@itri.org.tw](mailto:medstandard@itri.org.tw)[線上提問專區 | 臺灣醫療資訊標準大平台](https://medstandard.mohw.gov.tw/online-inquiry) |
| 貢獻者 | v0.1.1、v0.2.0、v0.2.1、v0.2.2、v0.3.0、v0.3.1、v0.3.2 | 李麗惠（Li-Hui Lee） | 國立臺北護理健康大學－健康事業管理系（Department of Health Care Management, National Taipei University of Nursing and Health Sciences） | [cclhlee@gmail.com](mailto:cclhlee@gmail.com)[cclhlee@ntunhs.edu.tw](mailto:cclhlee@ntunhs.edu.tw) | |
| 貢獻者 | v0.1.1、v0.2.0、v0.2.1、v0.2.2、v0.3.0、v0.3.1、v0.3.2 | 曾鈺珈（Yu-Jia Tseng） | [yujia151645@gmail.com](mailto:yujia151645@gmail.com) | | |
| 貢獻者 | v0.1.1、v0.2.0 | 林伃瑤（Yu-Yao Lin） | [a28485251@gmail.com](mailto:yujia151645@gmail.com)[082114224@ntunhs.edu.tw](mailto:082114224@ntunhs.edu.tw) | | |
| 貢獻者 | v0.2.0、v0.2.1、v0.2.2、v0.3.0、v0.3.1、v0.3.2 | 李奇安（Chi-An Lee） | [ec460520@gmail.com](mailto:ec460520@gmail.com) | | |
| 貢獻者 | v0.1.1 | 歐陽渝（Yang-Yu Ou） | [ouyangyu0326@gmail.com](mailto:ouyangyu0326@gmail.com) | | |
| 貢獻者 | v0.1.1、v0.2.0 | 連中岳（Chung-Yueh Lien） | 國立臺北護理健康大學－資訊管理系（Department of Information Management, National Taipei University of Nursing and Health Sciences） | [chungyueh@ntunhs.edu.tw](mailto:chungyueh@ntunhs.edu.tw) | |
| 貢獻者 | v0.1.1 | 徐建業（Chien-Yeh Hsu） | [cyhsu@ntunhs.edu.tw](mailto:cyhsu@ntunhs.edu.tw) | | |
| 貢獻者 | v0.1.1 | 陳欣怡（Hsin-Yi Chen） | [c86976@gmail.com](mailto:c86976@gmail.com) | | |
| 貢獻者 | v0.1.1 | 郭俐君（Li-Chun Kuo） | [lily220487@gmail.com](mailto:lily220487@gmail.com) | | |
| 貢獻者 | v0.1.1 | 丁子芸（Tzu-Yun Ting） | [aewqoo832456@gmail.com](mailto:aewqoo832456@gmail.com) | | |
| 貢獻者 | v0.2.0 | 陳杏宜（Hsin-Yi Chen） | [bii901231@gmail.com](mailto:aewqoo832456@gmail.com) | | |
| 貢獻者 | v0.2.0 | 蔡姍紜（Shan-Yun Tsai） | [appletsai319@gmail.com](mailto:aewqoo832456@gmail.com) | | |
| 貢獻者 | v0.2.0 | 黃睿駿（Hrui-Jun Huang） | [a27114171@gmail.com](mailto:aewqoo832456@gmail.com) | | |
| | | | | | |



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "tw.gov.mohw.twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ImplementationGuide/tw.gov.mohw.twcore",
  "version" : "1.0.0",
  "name" : "TWCore",
  "title" : "臺灣核心實作指引(TW Core IG)",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-07T07:13:09+00:00",
  "publisher" : "衛生福利部",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心實作指引(TW Core IG)",
  "packageId" : "tw.gov.mohw.twcore",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "ips",
      "uri" : "http://hl7.org/fhir/uv/ips/ImplementationGuide/hl7.fhir.uv.ips",
      "packageId" : "hl7.fhir.uv.ips",
      "version" : "1.1.0"
    },
    {
      "id" : "sdc",
      "uri" : "http://hl7.org/fhir/uv/sdc/ImplementationGuide/hl7.fhir.uv.sdc",
      "packageId" : "hl7.fhir.uv.sdc",
      "version" : "3.0.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2022+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU 1.0.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "default-version"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "default-publisher"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "n/a"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://twcore.mohw.gov.tw/ig/twcore/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.9.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2022+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU 1.0.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "default-version"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "default-publisher"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "n/a"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://twcore.mohw.gov.tw/ig/twcore/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/all-nut-example"
        },
        "name" : "堅果過敏或不耐症",
        "description" : "依據臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) Profile呈現堅果過敏之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/AllergyIntolerance-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/all-seafood-example"
        },
        "name" : "海鮮過敏或不耐症",
        "description" : "依據臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) Profile呈現海鮮過敏之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/AllergyIntolerance-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/all-medication-example"
        },
        "name" : "藥物過敏或不耐症",
        "description" : "依據臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) Profile呈現藥物過敏之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/AllergyIntolerance-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/all-cat-example"
        },
        "name" : "貓毛過敏或不耐症",
        "description" : "依據臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) Profile呈現貓毛過敏之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/AllergyIntolerance-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bun-example"
        },
        "name" : "Transaction",
        "description" : "依據臺灣核心-資料交換基本單位(TW Core Bundle) Profile呈現資料交換基本單位 type=transaction之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bun-document-example"
        },
        "name" : "Document",
        "description" : "依據臺灣核心-資料交換基本單位-文件 (TW Core Bundle Document) Profile呈現資料交換基本單位 type=document之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-document-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bun-document-uuid-example"
        },
        "name" : "Document(uuid)",
        "description" : "依據臺灣核心-資料交換基本單位-文件 (TW Core Bundle Document) Profile呈現資料交換基本單位 type=document之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-document-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bun-message-request-example"
        },
        "name" : "Message request(傳送)",
        "description" : "依據臺灣核心-資料交換基本單位-訊息傳送(TW Core Bundle Message) Profile呈現資料交換基本單位 type=message request之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-message-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bun-message-response-example"
        },
        "name" : "Message response(回應)",
        "description" : "依據臺灣核心-資料交換基本單位-訊息傳送(TW Core Bundle Message) Profile呈現資料交換基本單位 type=message response之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-message-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Composition"
          }
        ],
        "reference" : {
          "reference" : "Composition/com-example"
        },
        "name" : "陳加玲的病摘",
        "description" : "依據臺灣核心-臨床文件架構(TW Core Composition) Profile呈現陳加玲的病摘之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Composition-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Composition"
          }
        ],
        "reference" : {
          "reference" : "Composition/com-surgery-example"
        },
        "name" : "手術摘要報告",
        "description" : "依據臺灣核心-臨床文件架構(TW Core Composition) Profile呈現手術摘要報告之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Composition-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/con-example"
        },
        "name" : "病情、問題或診斷資料",
        "description" : "依據臺灣核心-病情、問題或診斷(TW Core Condition) Profile呈現病情、問題或診斷之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Coverage"
          }
        ],
        "reference" : {
          "reference" : "Coverage/coverage-example"
        },
        "name" : "給付範圍",
        "description" : "依據臺灣核心-給付範圍（TW Core Coverage）Profile呈現給付範圍之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Coverage-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-clinical-result-example"
        },
        "name" : "臨床檢驗檢查",
        "description" : "依據臺灣核心-臨床檢驗檢查（TW Core Observation Clinical Result）Profile呈現臨床檢驗檢查之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-clinical-result-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Immunization"
          }
        ],
        "reference" : {
          "reference" : "Immunization/imm-example"
        },
        "name" : "疫苗接種",
        "description" : "依據臺灣核心-疫苗接種（TW Core Immunization）Profile呈現疫苗接種之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Immunization-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DiagnosticReport"
          }
        ],
        "reference" : {
          "reference" : "DiagnosticReport/dia-example"
        },
        "name" : "診斷報告資料",
        "description" : "依據臺灣核心-診斷報告(TW Core DiagnosticReport) Profile呈現診斷報告之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DiagnosticReport-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/doc-outpatient-example"
        },
        "name" : "門診紀錄",
        "description" : "依據臺灣核心-文件參照(TW Core DocumentReference) Profile呈現門診紀錄之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/doc-wound-example"
        },
        "name" : "驗傷報告",
        "description" : "依據臺灣核心-文件參照(TW Core DocumentReference) Profile呈現驗傷報告之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/enc-example"
        },
        "name" : "就醫資料",
        "description" : "依據臺灣核心-就醫事件(TW Core Encounter) Profile呈現就醫之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Goal"
          }
        ],
        "reference" : {
          "reference" : "Goal/goa-example"
        },
        "name" : "目標",
        "description" : "依據臺灣核心-目標（TW Core Goal）Profile呈現目標之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Goal-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ImagingStudy"
          }
        ],
        "reference" : {
          "reference" : "ImagingStudy/img-example"
        },
        "name" : "腹部超音波",
        "description" : "依據臺灣核心-影像檢查(TW Core ImagingStudy) Profile呈現腹部超音波之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ImagingStudy"
          }
        ],
        "reference" : {
          "reference" : "ImagingStudy/img-ct-example"
        },
        "name" : "胸椎電腦斷層掃描",
        "description" : "依據臺灣核心-影像檢查(TW Core ImagingStudy) Profile呈現胸椎電腦斷層掃描之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ImagingStudy"
          }
        ],
        "reference" : {
          "reference" : "ImagingStudy/img-mr-example"
        },
        "name" : "雙側乳房磁振造影",
        "description" : "依據臺灣核心-影像檢查(TW Core ImagingStudy) Profile呈現雙側乳房磁振造影之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ImagingStudy"
          }
        ],
        "reference" : {
          "reference" : "ImagingStudy/img-pet-example"
        },
        "name" : "Positron emission tomography",
        "description" : "依據臺灣核心-影像檢查(TW Core ImagingStudy) Profile呈現Positron emission tomography之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ImagingStudy"
          }
        ],
        "reference" : {
          "reference" : "ImagingStudy/img-sm-example"
        },
        "name" : "Slide Microscopy",
        "description" : "依據臺灣核心-影像檢查(TW Core ImagingStudy) Profile呈現Slide Microscopy之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/loc-ent-example"
        },
        "name" : "衛生福利部臺北醫院耳鼻喉科地點資料",
        "description" : "依據臺灣核心-地點(TW Core Location) Profile呈現衛生福利部臺北醫院耳鼻喉科之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/loc-er-example"
        },
        "name" : "衛生福利部臺北醫院急診室地點資料",
        "description" : "依據臺灣核心-地點(TW Core Location) Profile呈現衛生福利部臺北醫院急診室之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/loc-hrad-example"
        },
        "name" : "衛生福利部臺北醫院X光室地點資料",
        "description" : "依據臺灣核心-地點(TW Core Location) Profile呈現衛生福利部臺北醫院X光室之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/loc-oph-example"
        },
        "name" : "明捷眼科診所地點資料",
        "description" : "依據臺灣核心-地點(TW Core Location) Profile呈現明捷眼科診所之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/loc-pharm-example"
        },
        "name" : "第二藥局地點資料",
        "description" : "依據臺灣核心-地點(TW Core Location) Profile呈現第二藥局之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Media"
          }
        ],
        "reference" : {
          "reference" : "Media/media-example"
        },
        "name" : "腦部MRI",
        "description" : "依據臺灣核心-多媒體(TW Core Media) Profile呈現多媒體之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Media-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/med-example"
        },
        "name" : "藥品資料",
        "description" : "依據臺灣核心-藥品(TW Core Medication) Profile呈現藥品之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Medication-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/med-req-ref-example"
        },
        "name" : "藥品請求資料(medicationReference)",
        "description" : "依據臺灣核心-藥品請求(TW Core MedicationRequest) Profile呈現藥品請求(medicationReference)之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/med-req-cod-example"
        },
        "name" : "藥品請求資料(medicationCodeableConcept)",
        "description" : "依據臺灣核心-藥品請求(TW Core MedicationRequest) Profile呈現藥品請求(medicationCodeableConcept)之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/med-dis-ref-example"
        },
        "name" : "阿立批挫藥品配藥資料",
        "description" : "依據臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) Profile呈現阿立批挫藥品配藥資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationDispense-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/med-dis-injection-example"
        },
        "name" : "爽胰達注射劑100單位+50微克藥品配藥資料",
        "description" : "依據臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) Profile呈現爽胰達注射劑100單位+50微克藥品配藥資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationDispense-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/med-dis-inflamed-example"
        },
        "name" : "鹽酸四環素眼藥膏藥品配藥資料",
        "description" : "依據臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) Profile呈現鹽酸四環素眼藥膏藥品配藥資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationDispense-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/med-dis-drop-example"
        },
        "name" : "每瞳令-普益點眼液藥品配藥資料",
        "description" : "依據臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) Profile呈現每瞳令-普益點眼液藥品配藥資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationDispense-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/med-sta-example"
        },
        "name" : "胰臟炎的用藥聲明資料",
        "description" : "依據臺灣核心-用藥聲明(TW Core MedicationStatement) Profile呈現胰臟炎的用藥聲明資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationStatement-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/med-sta-drop-example"
        },
        "name" : "近視的用藥聲明資料",
        "description" : "依據臺灣核心-用藥聲明(TW Core MedicationStatement) Profile呈現近視的用藥聲明資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationStatement-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/med-sta-inflamed-example"
        },
        "name" : "慢性結膜炎的用藥聲明資料",
        "description" : "依據臺灣核心-用藥聲明(TW Core MedicationStatement) Profile呈現慢性結膜炎的用藥聲明資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationStatement-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/med-sta-injection-example"
        },
        "name" : "第一型糖尿病的用藥聲明資料",
        "description" : "依據臺灣核心-用藥聲明(TW Core MedicationStatement) Profile呈現第一型糖尿病的用藥聲明資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationStatement-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MessageHeader"
          }
        ],
        "reference" : {
          "reference" : "MessageHeader/mes-request-example"
        },
        "name" : "訊息表頭－request (傳送)",
        "description" : "依據臺灣核心-訊息表頭(TW Core MessageHeader) Profile呈現訊息表頭－request資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MessageHeader-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MessageHeader"
          }
        ],
        "reference" : {
          "reference" : "MessageHeader/mes-response-example"
        },
        "name" : "訊息表頭－response (回應)",
        "description" : "依據臺灣核心-訊息表頭(TW Core MessageHeader) Profile呈現訊息表頭－response資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MessageHeader-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-lab-example"
        },
        "name" : "實驗室檢驗檢查-使用臺灣醫療服務給付項目-檢驗值集代碼",
        "description" : "依據臺灣核心-檢驗檢查(TW Core Observation Laboratory Result) Profile呈現檢驗檢查之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-laboratoryResult-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-loinc-example"
        },
        "name" : "實驗室檢驗檢查-使用LOINC實驗室檢驗檢查代碼",
        "description" : "依據臺灣核心-檢驗檢查(TW Core Observation Laboratory Result) Profile呈現檢驗檢查之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-laboratoryResult-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-bloodPressure-example"
        },
        "name" : "生命體徵資料-血壓",
        "description" : "依據臺灣核心-血壓(TW Core Observation Blood Pressure) Profile呈現血壓之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-bloodPressure-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-ecg-example"
        },
        "name" : "心電圖檢查",
        "description" : "依據臺灣核心-心電圖(TW Core Observation ECG) Profile呈現心電圖檢查之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-ecg-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-bmi-example"
        },
        "name" : "生命體徵資料-身體質量指數",
        "description" : "依據臺灣核心-身體質量指數(TW Core Observation BMI) Profile呈現身體質量指數之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-bmi-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-vital"
        },
        "name" : "生命體徵資料-身體質量指數",
        "description" : "依據臺灣核心-生命體徵(TW Core Observation Vital Signs) Profile呈現身體質量指數之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-vitalSigns-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-averageBloodPressure-example"
        },
        "name" : "平均血壓",
        "description" : "依據臺灣核心-平均血壓(TW Core Observation Average Blood Pressure) Profile呈現平均血壓之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-averageBloodPressure-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-careExp-example"
        },
        "name" : "病人照護偏好註記",
        "description" : "依據臺灣核心-病人照護偏好註記(TW Core Observation Care Experience Preference) Profile呈現病人照護偏好註記之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-careExperiencePreference-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-occupation-example"
        },
        "name" : "職業",
        "description" : "依據臺灣核心-職業(TW Core Simple Observation) Profile呈現職業之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-occupation-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-simple-example"
        },
        "name" : "通用檢驗檢查",
        "description" : "依據臺灣核心-通用檢驗檢查(TW Core Simple Observation) Profile呈現通用檢驗檢查之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-simple-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-pregnancy-intent-example"
        },
        "name" : "妊娠計畫",
        "description" : "依據臺灣核心-妊娠計畫(TW Core Observation Pregnancy Intent) Profile呈現妊娠計畫之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pregnancy-intent-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-pregnancy-status-example"
        },
        "name" : "妊娠狀態",
        "description" : "依據臺灣核心-妊娠狀態(TW Core Observation Pregnancy Status) Profile呈現妊娠狀態之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pregnancy-status-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-screening-assessment-example"
        },
        "name" : "健康狀態篩檢與評估",
        "description" : "依據臺灣核心-健康狀態篩檢與評估(TW Core Observation Screening Assessment) Profile呈現健康狀態篩檢與評估之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-screening-assessment-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-sexual-orientation-example"
        },
        "name" : "性傾向",
        "description" : "依據臺灣核心-性傾向(TW Core Observation Sexual Orientation)呈現性傾向之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-sexual-orientation-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-head-circumference-example"
        },
        "name" : "生命體徵資料-頭圍",
        "description" : "依據臺灣核心-頭圍(TW Core Observation Head Circumference)呈現頭圍之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-head-circumference-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-heart-rate-example"
        },
        "name" : "生命體徵資料-心率",
        "description" : "依據臺灣核心-心率(TW Core Observation Heart Rate)呈現心率之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-heart-rate-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-height-example"
        },
        "name" : "生命體徵資料-身高",
        "description" : "依據臺灣核心-身高(TW Core Observation Body Height)呈現身高之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-body-height-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-pediatric-bmi-age-example"
        },
        "name" : "生命體徵資料-兒童及青少年身體質量指數",
        "description" : "依據臺灣核心-兒童及青少年身體質量指數(TW Core Pediatric BMI for Age Observation)呈現兒童及青少年身體質量指數之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pediatric-bmi-age-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-pediatric-weight-height-example"
        },
        "name" : "生命體徵資料-兒童生長曲線",
        "description" : "依據臺灣核心-兒童生長曲線（TW Core Pediatric Weight for Height Observation）呈現兒童生長曲線之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pediatric-weight-height-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-pulse-oximetry-example"
        },
        "name" : "生命體徵資料-脈搏血氧飽和度",
        "description" : "依據臺灣核心-脈搏血氧飽和度(TW Core Observation Pulse Oximetry)呈現脈搏血氧飽和度之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pulse-oximetry-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-temperature-example"
        },
        "name" : "生命體徵資料-體溫",
        "description" : "依據臺灣核心-體溫(TW Core Observation Body Temperature)呈現體溫之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-body-temperature-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-weight-example"
        },
        "name" : "生命體徵資料-體重",
        "description" : "依據臺灣核心-體重(TW Core Observation Body Weight)呈現體重之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-body-weight-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-ofc-percentile-example"
        },
        "name" : "生命體徵資料-臺灣核心-兒童頭圍百分位數",
        "description" : "依據臺灣核心-兒童頭圍百分位數（TW Core Observation Pediatric Head Occipital Frontal Circumference Percentile）Profile呈現兒童頭圍百分位數之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pediatric-head-circumference-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-respiratory-rate-example"
        },
        "name" : "生命體徵資料-臺灣核心-呼吸速率",
        "description" : "依據臺灣核心-呼吸速率（TW Core Observation Respiratory Rate）Profile呈現呼吸速率之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-respiratory-rate-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-smoking-status-example"
        },
        "name" : "吸菸狀態",
        "description" : "依據臺灣核心-吸菸狀態（TW Core Smoking Status Observation）Profile呈現吸菸狀態之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-smoking-status-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-treatment-intervention-preference-example"
        },
        "name" : "病人治療偏好註記",
        "description" : "依據臺灣核心-病人治療偏好註記（TW Core Observation Treatment Intervention Preference）Profile呈現病人治療偏好註記之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-treatment-intervention-preference-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/dev-example"
        },
        "name" : "植入式裝置",
        "description" : "依據臺灣核心-植入式裝置(TW Core Simple Observation) Profile呈現植入式裝置之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Device-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/org-example"
        },
        "name" : "機構基本資料",
        "description" : "依據臺灣核心-機構(TW Core Organization) Profile呈現機構基本資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/org-govt-example"
        },
        "name" : "政府機構基本資料",
        "description" : "依據臺灣核心-政府機構(TW Core Organization Government) Profile呈現政府機構基本資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-govt-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/org-hosp-example"
        },
        "name" : "醫事機構基本資料",
        "description" : "依據臺灣核心-醫事機構(TW Core Organization Hospital Department) Profile呈現醫事機構基本資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-hosp-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/org-co-example"
        },
        "name" : "公司行號基本資料",
        "description" : "依據臺灣核心-公司行號(TW Core Organization Company) Profile呈現公司行號基本資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-co-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/pat-example"
        },
        "name" : "病人基本資料-身分證字號及病歷號",
        "description" : "依據臺灣核心-病人(TW Core Patient) Profile呈現病人基本資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/pat-child-example"
        },
        "name" : "病人(兒童)基本資料-身分證字號及病歷號",
        "description" : "依據臺灣核心-病人(TW Core Patient) Profile呈現病人(兒童)基本資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/pat-residentNumber-example"
        },
        "name" : "病人基本資料-居留證號碼及病歷號",
        "description" : "依據臺灣核心-病人(TW Core Patient) Profile呈現病人基本資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/pra-dr-example"
        },
        "name" : "醫師",
        "description" : "依據臺灣核心-健康照護服務提供者(TW Core Practitioner) Profile呈現醫師基本資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/pra-nurse-example"
        },
        "name" : "護士",
        "description" : "依據臺灣核心-健康照護服務提供者(TW Core Practitioner) Profile呈現護士基本資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/pra-phc-example"
        },
        "name" : "藥師",
        "description" : "依據臺灣核心-健康照護服務提供者(TW Core Practitioner) Profile呈現藥師基本資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/pra-radio-example"
        },
        "name" : "醫事放射師",
        "description" : "依據臺灣核心-健康照護服務提供者(TW Core Practitioner) Profile呈現醫事放射師基本資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/praro-dr-example"
        },
        "name" : "醫師",
        "description" : "依據臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) Profile呈現醫師基本資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/praro-nurse-example"
        },
        "name" : "護士",
        "description" : "依據臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) Profile呈現護士基本資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/praro-phc-example"
        },
        "name" : "藥師",
        "description" : "依據臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) Profile呈現藥師基本資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/praro-radio-example"
        },
        "name" : "醫事放射師",
        "description" : "依據臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) Profile呈現醫事放射師基本資料之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/pro-example"
        },
        "name" : "子宮超音波",
        "description" : "依據臺灣核心-處置或手術(TW Core Procedure) Profile呈現子宮超音波之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/pro-appendectomy-example"
        },
        "name" : "闌尾切除",
        "description" : "依據臺灣核心-處置或手術(TW Core Procedure) Profile呈現闌尾切除之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/pov-example"
        },
        "name" : "出處",
        "description" : "依據臺灣核心-出處（TW Core Provenance）Profile呈現出處之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Provenance-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/spe-blood-example"
        },
        "name" : "血液檢體",
        "description" : "依據臺灣核心-檢體(TW Core Specimen) Profile呈現血液檢體之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/spe-stool-example"
        },
        "name" : "糞便檢體",
        "description" : "依據臺灣核心-檢體(TW Core Specimen) Profile呈現糞便檢體之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/spe-ur-example"
        },
        "name" : "尿液檢體",
        "description" : "依據臺灣核心-檢體(TW Core Specimen) Profile呈現尿液檢體之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/spe-ance-example"
        },
        "name" : "組織檢體",
        "description" : "依據臺灣核心-檢體(TW Core Specimen) Profile呈現組織檢體採集之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "RelatedPerson"
          }
        ],
        "reference" : {
          "reference" : "RelatedPerson/rel-example"
        },
        "name" : "相關人士",
        "description" : "依據臺灣核心-相關人士(TW Core RelatedPerson)呈現相關人士之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "QuestionnaireResponse"
          }
        ],
        "reference" : {
          "reference" : "QuestionnaireResponse/qr-example"
        },
        "name" : "問卷題目回覆",
        "description" : "依據臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）Profile呈現問卷題目回覆之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/QuestionnaireResponse-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/sr-example"
        },
        "name" : "服務請求",
        "description" : "依據臺灣核心-服務請求（TW Core ServiceRequest）Profile呈服務請求之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ServiceRequest-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CarePlan"
          }
        ],
        "reference" : {
          "reference" : "CarePlan/careplan-example"
        },
        "name" : "照護計畫",
        "description" : "依據臺灣核心-照護計畫（TW Core CarePlan）Profile呈現照護計畫之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CareTeam"
          }
        ],
        "reference" : {
          "reference" : "CareTeam/careteam-example"
        },
        "name" : "照護團隊",
        "description" : "依據臺灣核心-照護團隊（TW Core CareTeam）Profile呈現照護團隊之範例",
        "exampleCanonical" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Organization-twcore"
        },
        "name" : "TW Core Organization",
        "description" : "此臺灣核心-機構（TW Core Organization）Profile說明本IG如何進一步定義FHIR的Organization Resource以呈現機構基本資料。",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Address-tw"
        },
        "name" : "TW Core Address",
        "description" : "此臺灣核心-地址（TW Core Address） Profile說明本IG如何進一步定義FHIR的Address資料類型以呈現臺灣地址。  \n本Profile之擴充的資料項目（Extension）為參照[初診基本資料表](https://www.eck.org.tw/wp-content/uploads/2019/10/ECK_FIRSTVIEW_INFOR.pdf)之欄位與[中華郵政地址英譯寫法](https://www.post.gov.tw/post/internet/Postal/sz_a_e_ta1.jsp)，若貴機構有詳細地址資訊之需求，可依情況填選；若無需區分詳細地址資訊，可使用原生欄位`text`、`line`、`district`呈現。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/tw-postal-code"
        },
        "name" : "TW Postal code",
        "description" : "臺灣郵遞區號",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/tw-village"
        },
        "name" : "TW Village",
        "description" : "臺灣地址欄位-村(里)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/tw-neighborhood"
        },
        "name" : "TW Neighborhood",
        "description" : "臺灣地址欄位-鄰",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/tw-section"
        },
        "name" : "TW Section",
        "description" : "臺灣地址欄位-段",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/tw-lane"
        },
        "name" : "TW Lane",
        "description" : "臺灣地址欄位-巷",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/tw-alley"
        },
        "name" : "TW Alley",
        "description" : "臺灣地址欄位-弄",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/tw-number"
        },
        "name" : "TW Number",
        "description" : "臺灣地址欄位-號",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/tw-floor"
        },
        "name" : "TW Floor",
        "description" : "臺灣地址欄位-樓",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/tw-room"
        },
        "name" : "TW Room",
        "description" : "臺灣地址欄位-室",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/CapabilityStatementTWCoreServer"
        },
        "name" : "臺灣核心-伺服端(TW Core Server)",
        "description" : "臺灣核心實作指引(TW Core IG)伺服端(Server)之能力聲明"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/CapabilityStatementTWCoreClient"
        },
        "name" : "臺灣核心-用戶端(TW Core Client)",
        "description" : "臺灣核心實作指引(TW Core IG)用戶端(Client)之能力聲明"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/AllergyIntolerance-id"
        },
        "name" : "AllergyIntolerance ID",
        "description" : "過敏或不耐症的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/AllergyIntolerance-clinical-status"
        },
        "name" : "AllergyIntolerance Clinical-Status",
        "description" : "過敏或不耐症的臨床狀態(clinicalStatus)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Bundle-id"
        },
        "name" : "Bundle ID",
        "description" : "Bundle的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Bundle-identifier"
        },
        "name" : "Bundle identifier",
        "description" : "Bundle的唯一識別碼(identifier)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Composition-id"
        },
        "name" : "Composition ID",
        "description" : "臨床文件架構的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Composition-status"
        },
        "name" : "Composition status",
        "description" : "臨床文件架構的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Composition-type"
        },
        "name" : "Composition type",
        "description" : "臨床文件架構的型別(type)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Composition-subject"
        },
        "name" : "Composition subject",
        "description" : "臨床文件架構的病人(subject)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Condition-id"
        },
        "name" : "Condition ID",
        "description" : "病情、問題或診斷的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Condition-clinical-status"
        },
        "name" : "Condition ClinicalStatus",
        "description" : "病情、問題或診斷的臨床狀態(clinicalStatus)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Condition-code"
        },
        "name" : "Condition Code",
        "description" : "病情、問題或診斷的識別(code)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Condition-subject"
        },
        "name" : "Condition Subject",
        "description" : "有此病情、問題或診斷的病人(subject)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Condition-onset-date"
        },
        "name" : "Condition OnsetDate",
        "description" : "病情、問題或診斷的日期(onset)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Condition-abatement-date"
        },
        "name" : "Condition AbatementDate",
        "description" : "病情、問題或診斷解決/緩解的日期(abatement)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Condition-severity"
        },
        "name" : "Condition Severity",
        "description" : "病情、問題或診斷的主觀嚴重程度(severity)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/DiagnosticReport-id"
        },
        "name" : "DiagnosticReport ID",
        "description" : "診斷報告的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/DiagnosticReport-status"
        },
        "name" : "DiagnosticReport Status",
        "description" : "診斷報告的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/DiagnosticReport-subject"
        },
        "name" : "DiagnosticReport Subject",
        "description" : "診斷報告的對象(subject)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/DiagnosticReport-category"
        },
        "name" : "DiagnosticReport Category",
        "description" : "診斷報告的類別(category)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/DiagnosticReport-code"
        },
        "name" : "DiagnosticReport Code",
        "description" : "診斷報告的代碼(code)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/DiagnosticReport-date"
        },
        "name" : "DiagnosticReport Date",
        "description" : "診斷報告的時間(date)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/DocumentReference-id"
        },
        "name" : "DocumentReference ID",
        "description" : "文件參照的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/DocumentReference-status"
        },
        "name" : "DocumentReference Status",
        "description" : "文件參照的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/DocumentReference-subject"
        },
        "name" : "DocumentReference Subject",
        "description" : "文件參照的對象(subject)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Encounter-id"
        },
        "name" : "Encounter ID",
        "description" : "就醫的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Encounter-class"
        },
        "name" : "Encounter Class",
        "description" : "病人就醫的分類(class)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Encounter-date"
        },
        "name" : "Encounter Date",
        "description" : "就醫的時間(date)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Encounter-identifier"
        },
        "name" : "Encounter Identifier",
        "description" : "就醫事件的識別碼(identifier)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Encounter-location"
        },
        "name" : "Encounter Location",
        "description" : "病人曾去過的一個或多個地點(location)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Encounter-subject"
        },
        "name" : "Encounter Subject",
        "description" : "就醫的病人(subject)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Encounter-status"
        },
        "name" : "Encounter Status",
        "description" : "就醫現況(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/ImagingStudy-id"
        },
        "name" : "ImagingStudy ID",
        "description" : "影像檢查的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/ImagingStudy-status"
        },
        "name" : "ImagingStudy Status",
        "description" : "影像檢查的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/ImagingStudy-subject"
        },
        "name" : "ImagingStudy Subject",
        "description" : "影像檢查的對象(subject)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/ImagingStudy-encounter"
        },
        "name" : "ImagingStudy encounter",
        "description" : "影像檢查的就醫事件(encounter)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/ImagingStudy-started"
        },
        "name" : "ImagingStudy started",
        "description" : "影像檢查的開始日期（時間）(started)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Location-id"
        },
        "name" : "Location ID",
        "description" : "地點的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Location-name"
        },
        "name" : "Location name",
        "description" : "地點的名稱(name)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Location-address"
        },
        "name" : "Location address",
        "description" : "地點的地址(address)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Media-id"
        },
        "name" : "Media ID",
        "description" : "多媒體的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Media-status"
        },
        "name" : "Media Status",
        "description" : "多媒體的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Media-subject"
        },
        "name" : "Media Subject",
        "description" : "多媒體的對象(subject)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Medication-id"
        },
        "name" : "Medication ID",
        "description" : "藥品的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Medication-code"
        },
        "name" : "Medication Code",
        "description" : "藥品的代碼(code)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MedicationRequest-id"
        },
        "name" : "MedicationRequest ID",
        "description" : "藥品請求的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MedicationRequest-status"
        },
        "name" : "MedicationRequest Status",
        "description" : "藥品請求的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MedicationRequest-intent"
        },
        "name" : "MedicationRequest Intent",
        "description" : "藥品請求的意圖(intent)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MedicationRequest-subject"
        },
        "name" : "MedicationRequest Subject",
        "description" : "藥品請求的對象(subject)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MedicationRequest-medication"
        },
        "name" : "MedicationRequest medication",
        "description" : "藥品請求的藥品(medication)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MedicationRequest-encounter"
        },
        "name" : "MedicationRequest Encounter",
        "description" : "藥品請求的就醫事件(encounter)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MedicationRequest-authoredon"
        },
        "name" : "MedicationRequest Authoredon",
        "description" : "藥品請求的最初請求時間(authoredon)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MedicationDispense-id"
        },
        "name" : "MedicationDispense ID",
        "description" : "配藥/調劑藥品的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MedicationDispense-status"
        },
        "name" : "MedicationDispense Status",
        "description" : "配藥/調劑藥品的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MedicationDispense-subject"
        },
        "name" : "MedicationDispense Subject",
        "description" : "配藥/調劑藥品的對象(subject)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MedicationDispense-medication"
        },
        "name" : "MedicationDispense medication",
        "description" : "配藥/調劑藥品的藥品(medication)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MedicationStatement-id"
        },
        "name" : "MedicationStatement ID",
        "description" : "用藥聲明的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MedicationStatement-status"
        },
        "name" : "MedicationStatement Status",
        "description" : "用藥聲明的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MedicationStatement-subject"
        },
        "name" : "MedicationStatement Subject",
        "description" : "用藥聲明的對象(subject)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MedicationStatement-medication"
        },
        "name" : "MedicationStatement medication",
        "description" : "用藥聲明的藥品(medication)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MessageHeader-id"
        },
        "name" : "MessageHeader ID",
        "description" : "訊息表頭的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MessageHeader-author"
        },
        "name" : "MessageHeader Author",
        "description" : "訊息表頭的撰寫者(author)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/MessageHeader-sender"
        },
        "name" : "MessageHeader sender",
        "description" : "訊息表頭的傳送單位(sender)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Observation-id"
        },
        "name" : "Observation ID",
        "description" : "檢驗檢查的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Observation-category"
        },
        "name" : "Observation Category",
        "description" : "檢驗檢查的類別(category)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Observation-clinical-code"
        },
        "name" : "Observation Code",
        "description" : "檢驗檢查項目(code)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Observation-date"
        },
        "name" : "Observation Date",
        "description" : "檢驗檢查的日期（時間）(effective)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Observation-performer"
        },
        "name" : "Observation Performer",
        "description" : "執行檢驗檢查的人員(performer)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Observation-status"
        },
        "name" : "Observation Status",
        "description" : "檢驗檢查的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Observation-subject"
        },
        "name" : "Observation Subject",
        "description" : "檢驗檢查有關的對象及（或）事物(subject)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Organization-id"
        },
        "name" : "Organization ID",
        "description" : "機構的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Organization-identifier"
        },
        "name" : "Organization Identifier",
        "description" : "機構的唯一識別碼(identifier)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Organization-name"
        },
        "name" : "Organization Name",
        "description" : "機構的名稱(name)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Organization-type"
        },
        "name" : "Organization Type",
        "description" : "機構的型別(type)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Patient-id"
        },
        "name" : "Patient ID",
        "description" : "病人的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Patient-birthdate"
        },
        "name" : "Patient Birthdate",
        "description" : "病人的出生日期(birthdate)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Patient-gender"
        },
        "name" : "Patient Gender",
        "description" : "病人的性別(gender)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Patient-identifier"
        },
        "name" : "Patient Identifier",
        "description" : "病人的身份識別碼(identifier)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Patient-name"
        },
        "name" : "Patient Name",
        "description" : "病人的姓名(name)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Practitioner-id"
        },
        "name" : "Practitioner ID",
        "description" : "健康照護服務提供者的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Practitioner-identifier"
        },
        "name" : "Practitioner Identifier",
        "description" : "健康照護服務提供者的識別碼(identifier)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Practitioner-name"
        },
        "name" : "Practitioner Name",
        "description" : "健康照護服務提供者的姓名(name)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/PractitionerRole-id"
        },
        "name" : "PractitionerRole ID",
        "description" : "健康照護服務提供者角色的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/PractitionerRole-identifier"
        },
        "name" : "PractitionerRole Identifier",
        "description" : "健康照護服務提供者角色的識別碼(identifier)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/PractitionerRole-specialty"
        },
        "name" : "PractitionerRole Specialty",
        "description" : "健康照護服務提供者角色的專業(specialty)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Procedure-id"
        },
        "name" : "Procedure ID",
        "description" : "處置或手術的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Procedure-code"
        },
        "name" : "Procedure Code",
        "description" : "處置或手術的識別碼(code)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Procedure-status"
        },
        "name" : "Procedure Status",
        "description" : "處置或手術或的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Procedure-subject"
        },
        "name" : "Procedure Subject",
        "description" : "處置或手術服務的對象(subject)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Procedure-date"
        },
        "name" : "Procedure Date",
        "description" : "處置或手術的日期(date)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Specimen-id"
        },
        "name" : "Specimen ID",
        "description" : "檢體的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Specimen-status"
        },
        "name" : "Specimen Status",
        "description" : "檢體的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Specimen-identifier"
        },
        "name" : "Specimen identifier",
        "description" : "檢體的識別碼(identifier)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Specimen-subject"
        },
        "name" : "Specimen subject",
        "description" : "檢體的病人(subject)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Observation-patient"
        },
        "name" : "Observation patient",
        "description" : "檢驗檢查有關的對象(patient)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Observation-lastupdated"
        },
        "name" : "Observation lastupdated",
        "description" : "檢驗檢查的最後更新日期（時間）(lastupdated)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Device-patient"
        },
        "name" : "Device patient",
        "description" : "裝置的使用對象(patient)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Device-type"
        },
        "name" : "Device type",
        "description" : "裝置的類型(type)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Device-status"
        },
        "name" : "Device status",
        "description" : "裝置的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/RelatedPerson-id"
        },
        "name" : "RelatedPerson ID",
        "description" : "相關人士的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/RelatedPerson-patient"
        },
        "name" : "RelatedPerson patient",
        "description" : "與該相關人士有關係的病人(patient)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/RelatedPerson-name"
        },
        "name" : "RelatedPerson name",
        "description" : "相關人士的姓名(name)，該查詢可能與 HumanName 中的任何字串匹配，包括完整的中文姓名(text)、英文姓(family)、英文名(given)、姓名前面的頭銜(prefix)、姓名後面的稱謂(suffix)。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Coverage-patient"
        },
        "name" : "Coverage patient",
        "description" : "保險的對象(patient)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/CarePlan-patient"
        },
        "name" : "CarePlan patient",
        "description" : "照護計畫的對象(patient)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/CarePlan-category"
        },
        "name" : "CarePlan category",
        "description" : "照護計畫的類別(category)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/CarePlan-date"
        },
        "name" : "CarePlan date",
        "description" : "照護計畫的期間(period)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/CarePlan-status"
        },
        "name" : "CarePlan status",
        "description" : "照護計畫的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/CareTeam-patient"
        },
        "name" : "CareTeam patient",
        "description" : "照護團隊的對象(patient)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/CareTeam-status"
        },
        "name" : "CareTeam status",
        "description" : "照護團隊的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/CareTeam-role"
        },
        "name" : "CareTeam role",
        "description" : "照護團隊的角色(role)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Goal-patient"
        },
        "name" : "Goal patient",
        "description" : "目標的對象(patient)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Goal-lifecycle-status"
        },
        "name" : "Goal lifecycle status",
        "description" : "目標在其整個生命週期中的狀態(lifecycle-status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Goal-target-date"
        },
        "name" : "Goal target date",
        "description" : "目標的預計達成時間(target.dueDate)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Goal-description"
        },
        "name" : "Goal description",
        "description" : "描述目標的代碼或文字(description)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Immunization-patient"
        },
        "name" : "Immunization patient",
        "description" : "疫苗接種的對象(patient)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Immunization-date"
        },
        "name" : "Immunization date",
        "description" : "疫苗接種的時間(occurrence)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Immunization-status"
        },
        "name" : "Immunization status",
        "description" : "疫苗接種的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/ServiceRequest-patient"
        },
        "name" : "ServiceRequest patient",
        "description" : "服務請求的對象(patient)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/ServiceRequest-id"
        },
        "name" : "ServiceRequest id",
        "description" : "服務請求的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/ServiceRequest-category"
        },
        "name" : "ServiceRequest category",
        "description" : "服務請求的類別(category)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/ServiceRequest-code"
        },
        "name" : "ServiceRequest code",
        "description" : "服務請求項目(code)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/ServiceRequest-authored"
        },
        "name" : "ServiceRequest authored",
        "description" : "簽署服務請求的日期(authored)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/ServiceRequest-status"
        },
        "name" : "ServiceRequest status",
        "description" : "服務請求的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/QuestionnaireResponse-patient"
        },
        "name" : "QuestionnaireResponse patient",
        "description" : "問卷題目回覆的對象(patient)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/QuestionnaireResponse-id"
        },
        "name" : "QuestionnaireResponse id",
        "description" : "問卷題目回覆的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/QuestionnaireResponse-status"
        },
        "name" : "QuestionnaireResponse status",
        "description" : "問卷題目回覆的狀態(status)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/QuestionnaireResponse-authored"
        },
        "name" : "QuestionnaireResponse authored",
        "description" : "問卷題目回覆的日期(authored)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/QuestionnaireResponse-questionnaire"
        },
        "name" : "QuestionnaireResponse questionnaire",
        "description" : "問卷題目回覆的問卷(questionnaire)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Provenance-patient"
        },
        "name" : "Provenance Patient",
        "description" : "出處的對象(patient)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Provenance-id"
        },
        "name" : "Provenance ID",
        "description" : "出處的邏輯性ID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/careplan-category-tw"
        },
        "name" : "臺灣衛福部資訊處照護計畫類別",
        "description" : "臺灣衛福部資訊處照護計畫類別"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/category-code-tw"
        },
        "name" : "臺灣衛福部資訊處類型代碼",
        "description" : "臺灣衛福部資訊處類型代碼， \n代碼出版日期：2024-08-31；資料所屬單位：衛生福利部資訊處。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/health-professional-tw"
        },
        "name" : "臺灣醫事司醫事人員類別",
        "description" : "臺灣醫事司醫事人員類別，參照至[醫事人員基本資料檔](https://www.google.com/url?client=internal-element-cse&cx=012254495936870409035:lzvyrg0mtim&q=https://www.mohw.gov.tw/dl-40452-1441ca2e-cde9-4345-b681-f9a20d5176b5.html&sa=U&ved=2ahUKEwjg5MCYrZn5AhUTI6YKHV6mC_s4FBAWegQIBBAC&usg=AOvVaw1q62t2W0hhdi0WC6e_nh1m)中的「人員類別（2022/01/28修訂）」。\n\n代碼出版日期：2022-01-28；資料所屬單位：衛生福利部醫事司。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/icd-10-cm-2014-tw"
        },
        "name" : "臺灣健保署2014年中文版ICD-10-CM",
        "description" : "臺灣健保署2014年中文版ICD-10-CM，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。    \n代碼出版日期：2022-07-19；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/icd-10-cm-2021-tw"
        },
        "name" : "臺灣健保署2021年中文版ICD-10-CM",
        "description" : "臺灣健保署2021年中文版ICD-10-CM，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。      \n代碼出版日期：2022-07-29；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/icd-10-cm-2023-tw"
        },
        "name" : "臺灣健保署2023年中文版ICD-10-CM",
        "description" : "臺灣健保署2023年中文版ICD-10-CM，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。      \n代碼出版日期：2024-01-31；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/icd-10-pcs-2014-tw"
        },
        "name" : "臺灣健保署2014年中文版ICD-10-PCS",
        "description" : "臺灣健保署2014年中文版ICD-10-PCS，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。  \n代碼出版日期：2017-07-19；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/icd-10-pcs-2021-tw"
        },
        "name" : "臺灣健保署2021年中文版ICD-10-PCS",
        "description" : "臺灣健保署2021年中文版ICD-10-PCS，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。       \n代碼出版日期：2022-07-29；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/icd-10-pcs-2023-tw"
        },
        "name" : "臺灣健保署2023年中文版ICD-10-PCS",
        "description" : "臺灣健保署2023年中文版ICD-10-PCS，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。      \n代碼出版日期：2024-01-31；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/icd-9-cm-2001-tw"
        },
        "name" : "臺灣健保署2001年中文版ICD-9-CM",
        "description" : "臺灣健保署2001年中文版ICD-9-CM，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。  \n代碼出版日期：2023-05-09；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/industry-dgbas-tw"
        },
        "name" : "行政院主計總處行業分類",
        "description" : "行政院主計總處行業分類，參照至行政院主計總處的[行業統計分類(第11次修正)](https://ws.dgbas.gov.tw/001/Upload/463/attachment/11195/90015/012221854690wg0x9i.pdf)\n代碼出版日期：2021-01-01；資料所屬單位：行政院主計總處。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/marital-status-tw"
        },
        "name" : "臺灣戶政司婚姻狀態",
        "description" : "臺灣戶政司婚姻狀態，參照至[戶役政資訊系統資料代碼內容清單](https://www.ris.gov.tw/documents/html/5/1/168.html)中的「婚姻狀況代碼」。 \n\n代碼出版日期：2019-05-22；資料所屬單位：內政部戶政司。\n\n代碼文字標示之施行法，係指司法院釋字第748號解釋施行法。 \n \n*因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。*"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medcation-atc-tw"
        },
        "name" : "臺灣食藥署藥品藥理治療分類ATC碼",
        "description" : "臺灣食藥署藥品藥理治療分類ATC碼，參照至[藥品藥理治療分類ATC碼資料集](https://data.gov.tw/dataset/9119)，資料提供單位：衛生福利部食品藥物管理署。  \n\n此代碼為WHO ATC(http://www.whocc.no/atc)中未涵蓋之代碼，為符合國內代碼使用，故將未被定義之代碼另外呈現。  \n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medical-consultation-department-nhi-tw"
        },
        "name" : "臺灣健保署就醫科別",
        "description" : "臺灣健保署就醫科別，參照至[健保署檔案譯碼簿](https://www.nhi.gov.tw/ch/cp-1880-20811-3142-1.html)中的「就醫科別（2022/8/2版本）」。\n\n代碼出版日期：2024-05-27；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medical-service-payment-tw"
        },
        "name" : "臺灣健保署醫療服務給付項目",
        "description" : "臺灣健保署醫療服務給付項目，參照至[全民健康保險醫療服務給付項目及支付標準](https://www.nhi.gov.tw/ch/cp-5943-f1cce-2821-1.html)中的「醫療服務給付項目(113.05.01生效) (113.04.23更新)」。  \n\n代碼出版日期：2022-07-01；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「生效日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medical-treatment-department-nhi-tw"
        },
        "name" : "臺灣健保署診療科別",
        "description" : "臺灣健保署診療科別，參照至[健保署檔案譯碼簿](https://www.nhi.gov.tw/ch/cp-1880-20811-3142-1.html)中的「診療科別（2022/8/2版本）」。   \n\n代碼出版日期：2024-05-27；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medication-device-fda-tw"
        },
        "name" : "臺灣食藥署醫療器材許可證",
        "description" : "臺灣食藥署醫療器材許可證，參照自[https://data.fda.gov.tw/frontsite/data/DataAction.do?method=doDetail&infoId=68](https://data.fda.gov.tw/frontsite/data/DataAction.do?method=doDetail&infoId=68)  \n代碼出版日期：2022-08-08-08；資料所屬單位：衛生福利部食品藥物管理署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－臺灣食藥署醫療器材許可證](https://fhir.mohw.gov.tw/ts/codesystemRead.jsp?id=medication-device-fda-tw&status=active&version=2022-08-08-08&metaId=1&codeStatus=use&show=Y)查閱\n\n\n* 2024/7/8異動說明：2024-06-06版的臺灣食藥署醫療器材許可證代碼中新增、刪除、修改代碼量較大會使載入頁面時間較長，完整異動代碼說明請至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medication-fda-tw"
        },
        "name" : "臺灣食藥署藥品許可證",
        "description" : "臺灣食藥署藥品許可證，參照自[https://data.fda.gov.tw/frontsite/data/DataAction.do?method=doDetail&infoId=36](https://data.fda.gov.tw/frontsite/data/DataAction.do?method=doDetail&infoId=36)  \n代碼出版日期：2022-08-03-03；資料所屬單位：衛生福利部食品藥物管理署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medication-frequency-nhi-tw"
        },
        "name" : "臺灣健保署藥品使用頻率",
        "description" : "臺灣健保署藥品使用頻率，參照至[健保署檔案譯碼簿](https://www.nhi.gov.tw/ch/cp-1880-20811-3142-1.html)中的「藥品使用頻率（2022/8/2版本）」。\n\n代碼出版日期：2024-05-27；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medication-nhi-tw"
        },
        "name" : "臺灣健保署用藥品項",
        "description" : "臺灣健保署用藥品項代碼，參照自[健保用藥品項](https://www.nhi.gov.tw/ch/lp-2466-1.html)中的「健保用藥品項114年5月查詢檔(帶走所有壓縮檔114.4.30更新)」。  \n\n代碼出版日期：2025-04-30；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*  \n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處僅擷取部分代碼，完整代碼可至完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medication-path-tw"
        },
        "name" : "臺灣健保署給藥途徑",
        "description" : "臺灣健保署給藥途徑，[健保署檔案譯碼簿](https://www.nhi.gov.tw/ch/cp-1880-20811-3142-1.html)中的「給藥途徑/作用部位（2022/8/2版本）」。  \n\n代碼出版日期：2024-06-04；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/nhi-medication-ch-herb-tw"
        },
        "name" : "臺灣健保署中藥用藥品項",
        "description" : "臺灣健保署中藥用藥品項，參照自[中藥用藥品項表](https://www.nhi.gov.tw/ch/cp-14300-03585-2467-1.html)中的「單方(113.06.01更新)」及「複方(113.04.01更新)」。\n代碼出版日期：2024-05-31；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*  \n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/occupation-lia-roc-tw"
        },
        "name" : "臺灣壽險公會傷害保險個人職業分類表",
        "description" : "臺灣壽險公會傷害保險個人職業分類表，參照至[中華民國人壽保險商業同業公會](https://www.lia-roc.org.tw/)\n代碼出版日期：2023-06-01；資料所屬單位：中華民國人壽保險商業同業公會。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/occupation-mol-tw"
        },
        "name" : "臺灣勞動部職業標準分類",
        "description" : "臺灣勞動部職業標準分類，參照至[中華民國勞動部](https://www.mol.gov.tw/1607/2458/2510/)的[職業標準分類(第6次修訂)](https://statdb.mol.gov.tw/html/svy12/1236menu.htm)\n代碼出版日期：2010-05-01；資料所屬單位：中華民國勞動部。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/organization-identifier-tw"
        },
        "name" : "臺灣醫事司醫事機構代碼",
        "description" : "臺灣醫事司醫事機構代碼，參照至[衛生福利部醫事司](https://dep.mohw.gov.tw/DOMA/cp-4926-54415-106.html)的[醫療機構與人員基本資料20231231.csv](https://www.mohw.gov.tw/dl-87760-1a0f2eab-c96a-4839-950d-beb93d903b6f.html)  \n[醫事機構代碼查詢系統](https://rao.mohw.gov.tw/AgencyCode.aspx?FD1=txtAgency_qry&FD2=txtAgencyName_qry)\n代碼出版日期：2020-06-11；資料所屬單位：衛生福利部醫事司。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/postal-code3-tw"
        },
        "name" : "臺灣中華郵政3碼郵遞區號",
        "description" : "臺灣中華郵政3碼郵遞區號，參照自[郵遞區號(含轉碼軟體)](https://www.post.gov.tw/post/internet/Download/index.jsp?ID=220306)中的「臺灣地區郵遞區號前3碼一覽表 103/12(Excel版)」。屬性命名以與國際的等級一致為主，未採用中華郵政提供之英文名稱。   \n代碼出版日期：2015-01-22；資料所屬單位：中華郵政。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/postal-code5-tw"
        },
        "name" : "臺灣中華郵政5碼郵遞區號",
        "description" : "臺灣中華郵政5碼郵遞區號，參照自[郵遞區號(含轉碼軟體)](https://www.post.gov.tw/post/internet/Download/index.jsp?ID=220306)中的『3+3郵遞區號查詢應用系統』。屬性命名以與國際的等級一致為主，未採用中華郵政提供之英文名稱。  \n代碼出版日期：2022-06-21；資料所屬單位：中華郵政。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/postal-code6-tw"
        },
        "name" : "臺灣中華郵政6碼郵遞區號",
        "description" : "臺灣中華郵政6碼郵遞區號，參照自[郵遞區號(含轉碼軟體)](https://www.post.gov.tw/post/internet/Download/index.jsp?ID=220306)中的『3+3郵遞區號查詢應用系統』。屬性命名以與國際的等級一致為主，未採用中華郵政提供之英文名稱。    \n代碼出版日期：2020-10-22；資料所屬單位：中華郵政。\n\n*因原始資料無代碼版本資訊，故使用其公開授權聲明之「更新日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/provenance-participant-type-tw"
        },
        "name" : "臺灣衛福部資訊處Provenance參與類型",
        "description" : "臺灣衛福部資訊處Provenance參與類型。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0203"
        },
        "name" : "臺灣衛福部資訊處識別碼類型",
        "description" : "臺灣衛福部資訊處識別碼類型，  \n代碼出版日期：2022-07-31；資料所屬單位：衛生福利部資訊處。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/health-professional-tw"
        },
        "name" : "臺灣醫事司醫事人員類別代碼對應SNOMED CT及臺灣醫事司醫事人員類別",
        "description" : "此對應表為臺灣醫事司醫事人員類別代碼對應至國際標準碼SNOMED CT，供實作者於撰寫程式以自動化對應或轉代碼時使用。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/marital-status-tw"
        },
        "name" : "臺灣戶政司婚姻狀態代碼對應HL7 MaritalStatus",
        "description" : "此對應表為臺灣戶政司婚姻狀態代碼對應至國際標準碼HL7 MaritalStatus，供實作者於撰寫程式以自動化對應或轉代碼時使用。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/medical-consultation-department-nhi-tw"
        },
        "name" : "臺灣健保署就醫科別代碼對應SNOMED CT",
        "description" : "此對應表為臺灣健保署就醫科別代碼對應至國際標準碼SNOMED CT，供實作者於撰寫程式以自動化對應或轉代碼時使用。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/medical-treatment-department-nhi-tw"
        },
        "name" : "臺灣健保署診療科別代碼對應SNOMED CT",
        "description" : "此對應表為臺灣健保署診療科別代碼對應至國際標準碼SNOMED CT，供實作者於撰寫程式以自動化對應或轉代碼時使用。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/medication-frequency-tw"
        },
        "name" : "臺灣健保署藥品使用頻率代碼對應對應HL7 TimingAbbreviation",
        "description" : "此對應表為臺灣健保署藥品使用頻率代碼對應對應HL7 TimingAbbreviation，供實作者於撰寫程式以自動化對應或轉代碼時使用。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/medication-path-tw"
        },
        "name" : "臺灣健保署給藥途徑代碼對應SNOMED CT",
        "description" : "此對應表為臺灣健保署給藥途徑代碼對應至國際標準碼SNOMED CT，供實作者於撰寫程式以自動化對應或轉代碼時使用。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/Patient-everything"
        },
        "name" : "讀取病人(Patient)紀錄",
        "description" : "此操作用於回傳與調用與病人相關的所有Resources。回傳的Bundle type為「searchset」。至少將會回傳病人Resource本身，以及伺服器中具有的與病人相關且可供給使用者使用的任何其他Resources。伺服器將回傳支援紀錄所需的任何Resources，例如：相關的健康照護服務提供者(Practitioners)、藥品(Medications)、位置(Locations)及機構(Organizations)等。\n\n使用此項操作(operation)的目的是提供病人存取他們的完整紀錄，或者給健康照護提供結或其他使用者執行大量資料下載。伺服器建議應該(SHOULD)至少回傳它所擁有的、已確定的病人compartment的resources、以及從這些resources所參照的任何resources。包括二進制文件和附件。在臺灣，目前沒有強制的規定，但不排除未來有其他專案要求使用。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AllergyIntolerance-twcore"
        },
        "name" : "TW Core AllergyIntolerance",
        "description" : "此臺灣核心-過敏或不耐症（TW Core AllergyIntolerance） Profile說明本IG如何進一步定義FHIR的AllergyIntolerance Resource以呈現過敏與不耐症的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Bundle-document-twcore"
        },
        "name" : "TW Core Bundle Document",
        "description" : "此臺灣核心-資料交換基本單位-文件（TW Core Bundle Document） Profile說明本IG如何進一步定義臺灣核心-資料交換基本單位(TW Core Bundle） Profile以呈現 Bundle 文件 的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Bundle-message-twcore"
        },
        "name" : "TW Core Bundle Message",
        "description" : "此臺灣核心-資料交換基本單位-訊息（TW Core Bundle Message） Profile說明本IG如何進一步定義臺灣核心-資料交換基本單位(TW Core Bundle） Profile以呈現 Bundle Message 的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Bundle-twcore"
        },
        "name" : "TW Core Bundle",
        "description" : "此臺灣核心-資料交換基本單位（TW Core Bundle） Profile說明本IG如何進一步定義FHIR的Bundle Resource以呈現資料交換基本單位的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CarePlan-twcore"
        },
        "name" : "TW Core CarePlan",
        "description" : "此臺灣核心-照護計畫(TW Core CarePlan) Profile 說明本 IG 如何進一步定義 FHIR 的 CarePlan Resource 以呈現照護計畫資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CareTeam-twcore"
        },
        "name" : "TW Core CareTeam",
        "description" : "此臺灣核心-照護團隊(TW Core CareTeam) Profile 說明本 IG 如何進一步定義 FHIR 的 CareTeam Resource 以呈現照護團隊資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CodeableConcept-tw"
        },
        "name" : "TW CodeableConcept",
        "description" : "此臺灣CodeableConcept Profile說明本IG如何進一步定義FHIR的CodeableConcept資料類型以呈現CodeableConcept  [[*FMM1*](http://build.fhir.org/versions.html#maturity)]"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Coding-tw"
        },
        "name" : "TW Coding",
        "description" : "此臺灣Coding Profile說明本IG如何進一步定義FHIR的Coding資料類型以呈現Coding  [[*FMM1*](http://build.fhir.org/versions.html#maturity)]"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Composition-twcore"
        },
        "name" : "TW Core Composition",
        "description" : "此臺灣核心-臨床文件架構（TW Core Composition） Profile說明本IG如何進一步定義FHIR的Composition Resource以呈現臨床文件架構的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Condition-twcore"
        },
        "name" : "TW Core Condition",
        "description" : "此臺灣核心-病情、問題或診斷（TW Core Condition） Profile說明本IG如何進一步定義FHIR的Condition Resource以呈現有關病情、問題或診斷的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Coverage-twcore"
        },
        "name" : "TW Core Coverage",
        "description" : "此臺灣核心-給付範圍(TW Core Coverage) Profile 說明本 IG 如何進一步定義 FHIR 的 Coverage Resource 以呈現給付範圍資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Device-twcore"
        },
        "name" : "TW Core Implantable Device",
        "description" : "此臺灣核心-植入式裝置（TW Core Implantable Device） Profile說明本IG如何進一步定義FHIR的Device Resource以呈現植入式裝置資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DiagnosticReport-twcore"
        },
        "name" : "TW Core DiagnosticReport",
        "description" : "此臺灣核心-診斷報告（TW Core DiagnosticReport） Profile說明本IG如何進一步定義FHIR的DiagnosticReport Resource以呈現診斷報告。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DocumentReference-twcore"
        },
        "name" : "TW Core DocumentReference",
        "description" : "此臺灣核心-文件參照（TW Core DocumentReference） Profile說明本IG如何進一步定義FHIR的DocumentReference Resource以呈現文件參照的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Encounter-twcore"
        },
        "name" : "TW Core Encounter",
        "description" : "此臺灣核心-就醫事件（TW Core Encounter） Profile說明本IG如何進一步定義FHIR的Encounter Resource以呈現就醫事件。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Goal-twcore"
        },
        "name" : "TW Core Goal",
        "description" : "此臺灣核心-目標（TW Core Goal） Profile說明本IG如何進一步定義FHIR的Goal Resource以呈現目標資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ImagingStudy-twcore"
        },
        "name" : "TW Core ImagingStudy",
        "description" : "此臺灣核心-影像檢查（TW Core ImagingStudy） Profile說明本IG如何進一步定義FHIR的ImagingStudy Resource以呈現影像檢查的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Immunization-twcore"
        },
        "name" : "TW Core Immunization",
        "description" : "此臺灣核心-疫苗接種 (TW Core Immunization) Profile 說明本 IG 如何進一步定義 FHIR 的 Immunization Resource 以呈現疫苗接種資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Location-twcore"
        },
        "name" : "TW Core  Location",
        "description" : "此臺灣核心-地點（TW Core  Location） Profile說明本IG如何進一步定義FHIR的Location Resource以呈現地點的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Media-twcore"
        },
        "name" : "TW Core Media",
        "description" : "此臺灣核心-多媒體（TW Core Media） Profile說明本IG如何進一步定義FHIR的Media Resource以呈現多媒體的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Medication-twcore"
        },
        "name" : "TW Core Medication",
        "description" : "此臺灣核心-藥品（TW Core Medication） Profile說明本IG如何進一步定義FHIR的Medication Resource以呈現藥品的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationDispense-twcore"
        },
        "name" : "TW Core MedicationDispense",
        "description" : "此臺灣核心-配藥或藥品調劑（TW Core MedicationDispense） Profile說明本IG如何進一步定義FHIR的MedicationDispense Resource以呈現配藥或藥品調劑的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationRequest-twcore"
        },
        "name" : "TW Core MedicationRequest",
        "description" : "此臺灣核心-藥品請求（TW Core MedicationRequest） Profile說明本IG如何進一步定義FHIR的MedicationRequest Resource以呈現藥品請求的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationStatement-twcore"
        },
        "name" : "TW Core  MedicationStatement",
        "description" : "此臺灣核心-用藥聲明（TW Core  MedicationStatement） Profile說明本IG如何進一步定義FHIR的MedicationStatement Resource以呈現用藥聲明的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MessageHeader-twcore"
        },
        "name" : "TW Core MessageHeader",
        "description" : "此臺灣核心-訊息表頭（TW Core MessageHeader） Profile說明本IG如何進一步定義FHIR的MessageHeader Resource以呈現訊息表頭的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-averageBloodPressure-twcore"
        },
        "name" : "TW Core Observation Average Blood Pressure",
        "description" : "此臺灣核心-平均血壓（TW Core Observation Average Blood Pressure）Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現平均血壓資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-bloodPressure-twcore"
        },
        "name" : "TW Core Observation Blood Pressure",
        "description" : "此臺灣核心-血壓（TW Core Observation Blood Pressure） Profile說明本IG如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile以呈現血壓資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-bmi-twcore"
        },
        "name" : "TW Core Observation BMI",
        "description" : "此臺灣核心-身體質量指數（TW Core Observation BMI） Profile說明本IG如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile以呈現身體質量指數資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-body-height-twcore"
        },
        "name" : "TW Core Observation Body Height",
        "description" : "此臺灣核心-身高 (TW Core Observation Body Height) Profile 說明本 IG 如何進一步定義臺灣核心-生命體徵 (TW Core Observation Vital Signs) Profile 以呈現身高資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-body-temperature-twcore"
        },
        "name" : "TW Core Observation Body Temperature",
        "description" : "此臺灣核心-體溫 (TW Core Observation Body Temperature) Profile 說明本 IG 如何進一步定義臺灣核心-生命體徵 (TW Core Observation Vital Signs) Profile 以呈現體溫資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-body-weight-twcore"
        },
        "name" : "TW Core Observation Body Weight",
        "description" : "此臺灣核心-體重（TW Core Observation Body Weight）Profile 說明本 IG 如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs）Profile 以呈現體重資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-careExperiencePreference-twcore"
        },
        "name" : "TW Core Observation Care Experience Preference",
        "description" : "此臺灣核心-病人照護偏好註記（TW Core Observation Care Experience Preference）Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現照護經驗偏好資料。  \n(可填寫文字或代碼等說明)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-clinical-result-twcore"
        },
        "name" : "TW Core Observation Clinical Result",
        "description" : "此臺灣核心-臨床檢驗檢查（TW Core Observation Clinical Result） Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現臨床檢驗檢查資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-ecg-twcore"
        },
        "name" : "TW Core Observation ECG",
        "description" : "此臺灣核心-心電圖（TW Core Observation ECG） Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現心電圖（ECG/EKG）資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-head-circumference-twcore"
        },
        "name" : "TW Core Observation Head Circumference",
        "description" : "此臺灣核心-頭圍（TW Core Observation Head Circumference） Profile說明本IG如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile以呈現頭圍資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-heart-rate-twcore"
        },
        "name" : "TW Core Observation Heart Rate",
        "description" : "此臺灣核心-心率 (TW Core Observation Heart Rate) Profile 說明本 IG 如何進一步定義臺灣核心-生命體徵 (TW Core Observation Vital Signs) Profile 以呈現心率資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-laboratoryResult-twcore"
        },
        "name" : "TW Core Observation Laboratory Result",
        "description" : "此臺灣核心-實驗室檢驗檢查（TW Core Observation Laboratory Result） Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現檢驗檢查資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-occupation-twcore"
        },
        "name" : "TW Core Observation Occupation",
        "description" : "此臺灣核心-職業（TW Core Observation Occupation） Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現職業資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-pediatric-bmi-age-twcore"
        },
        "name" : "TW Core Pediatric BMI for Age Observation",
        "description" : "此臺灣核心-兒童及青少年身體質量指數 (TW Core Pediatric BMI for Age Observation) Profile 說明本 IG 如何進一步定義臺灣核心-生命體徵 (TW Core Observation Vital Signs) Profile 以呈現兒童及青少年身體質量指數資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-pediatric-head-circumference-twcore"
        },
        "name" : "TW Core Observation Pediatric Head Occipital Frontal Circumference Percentile",
        "description" : "此臺灣核心-兒童頭圍百分位數（TW Core Observation Pediatric Head Occipital Frontal Circumference Percentile） Profile 說明本IG如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile 以呈現兒童頭圍百分位數資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-pediatric-weight-height-twcore"
        },
        "name" : "TW Core Pediatric Weight for Height Observation",
        "description" : "此臺灣核心-兒童生長曲線（TW Core Pediatric Weight for Height Observation）Profile說明本IG如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile以呈現兒童生長曲線資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-pregnancy-intent-twcore"
        },
        "name" : "TW Core Observation Pregnancy Intent",
        "description" : "此臺灣核心-妊娠計畫（TW Core Observation Pregnancy Intent） Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現妊娠計畫資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-pregnancy-status-twcore"
        },
        "name" : "TW Core Observation Pregnancy Status",
        "description" : "此臺灣核心-妊娠狀態 (TW Core Observation Pregnancy Status) Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現妊娠狀態資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-pulse-oximetry-twcore"
        },
        "name" : "TW Core Observation Pulse Oximetry",
        "description" : "此臺灣核心-脈搏血氧飽和度（TW Core Observation Pulse Oximetry）Profile 說明本 IG 如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile 以呈現脈搏血氧飽和度資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-respiratory-rate-twcore"
        },
        "name" : "TW Core Observation Respiratory Rate",
        "description" : "此臺灣核心-呼吸速率（TW Core Observation Respiratory Rate）Profile 說明本IG如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile 以呈現呼吸速率資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-screening-assessment-twcore"
        },
        "name" : "TW Core Observation Screening Assessment",
        "description" : "此臺灣核心-健康狀態篩檢與評估 (TW Core Observation Screening Assessment) Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現健康狀態篩檢與評估資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-sexual-orientation-twcore"
        },
        "name" : "TW Core Observation Sexual Orientation",
        "description" : "此臺灣核心-性傾向 (TW Core Observation Sexual Orientation) Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現性傾向資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-simple-twcore"
        },
        "name" : "TW Core Simple Observation",
        "description" : "此臺灣核心-通用檢驗檢查（TW Core Simple Observation） Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現通用檢驗檢查資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-smoking-status-twcore"
        },
        "name" : "TW Core Observation Smoking Status",
        "description" : "此臺灣核心-吸菸狀態 (TW Core Observation Smoking Status) Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現吸菸狀態資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-treatment-intervention-preference-twcore"
        },
        "name" : "TW Core Observation Treatment Intervention Preference",
        "description" : "此臺灣核心-病人治療偏好註記（TW Core Observation Treatment Intervention Preference） Profile說明本IG如何進一步定義FHIR的Observation Profile以呈現病人治療偏好註記資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-vitalSigns-twcore"
        },
        "name" : "TW Core Observation Vital Signs",
        "description" : "此臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile說明本IG如何進一步定義FHIR的Vital Signs Profile以呈現生命體徵資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Organization-co-twcore"
        },
        "name" : "TW Core Organization Company",
        "description" : "此臺灣核心-公司行號（TW Core Organization Company） Profile說明本IG如何進一步定義臺灣核心-機構（TW Core Organization） Profile以呈現機構基本資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Organization-govt-twcore"
        },
        "name" : "TW Core Organization Government",
        "description" : "此臺灣核心-政府機構（TW Core Organization Government） Profile說明本IG如何進一步定義臺灣核心-機構（TW Core Organization） Profile以呈現機構基本資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Organization-hosp-twcore"
        },
        "name" : "TW Core Organization Hospital Department",
        "description" : "此臺灣核心-醫事機構（TW Core Organization Hospital Department） Profile說明本IG如何進一步定義臺灣核心-機構（TW Core Organization） Profile以呈現機構基本資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Patient-twcore"
        },
        "name" : "TW Core Patient",
        "description" : "此臺灣核心-病人（TW Core Patient） Profile說明本IG如何進一步定義FHIR的Patient Resource以呈現基本資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Practitioner-twcore"
        },
        "name" : "TW Core Practitioner",
        "description" : "tifier:residentNumber欄位的identifier.system改為 = http://www.immigration.gov.tw。  \n\n此臺灣核心-健康照護服務提供者（TW Core Practitioner） Profile說明本IG如何進一步定義FHIR的Practitioner Resource以呈現健康照護服務提供者基本資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PractitionerRole-twcore"
        },
        "name" : "TW Core PractitionerRole",
        "description" : "此臺灣核心-健康照護服務提供者角色（TW Core PractitionerRole） Profile說明本IG如何進一步定義FHIR的PractitionerRole Resource以呈現健康照護服務提供者角色的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Procedure-twcore"
        },
        "name" : "TW Core Procedure",
        "description" : "此臺灣核心-處置或手術（TW Core Procedure） Profile說明本IG如何進一步定義FHIR的Procedure Resource以呈現處置或手術基本資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Provenance-twcore"
        },
        "name" : "TW Core Provenance",
        "description" : "此臺灣核心-出處（TW Core Provenance） Profile說明本IG如何進一步定義FHIR的Provenance Resource以呈現出處資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/QuestionnaireResponse-twcore"
        },
        "name" : "TW Core QuestionnaireResponse",
        "description" : "此臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）Profile說明本IG如何進一步定義FHIR的QuestionnaireResponse  Resource以呈現問卷題目回覆資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/RelatedPerson-twcore"
        },
        "name" : "TW Core RelatedPerson",
        "description" : "此臺灣核心-相關人士（TW Core RelatedPerson） Profile說明本IG如何進一步定義FHIR的RelatedPerson Resource以呈現相關人士資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ServiceRequest-twcore"
        },
        "name" : "TW Core ServiceRequest",
        "description" : "此臺灣核心-服務請求（TW Core ServiceRequest） Profile說明本IG如何進一步定義FHIR的ServiceRequest Resource以呈現服務請求資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Specimen-twcore"
        },
        "name" : "TW Core Specimen",
        "description" : "此臺灣核心-檢體（TW Core Specimen） Profile說明本IG如何進一步定義FHIR的Specimen Resource以呈現檢體的詳細資料。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWAllergyIntolerance"
        },
        "name" : "臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) 之資料模型",
        "description" : "臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWBundle"
        },
        "name" : "臺灣核心-資料交換基本單位(TW Core Bundle) 之資料模型",
        "description" : "臺灣核心-資料交換基本單位(TW Core Bundle) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWComposition"
        },
        "name" : "臺灣核心-臨床文件架構(TW Core Composition) 之資料模型",
        "description" : "臺灣核心-臨床文件架構(TW Core Composition) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWCondition"
        },
        "name" : "臺灣核心-病情、問題或診斷(TW Core Condition) 之資料模型",
        "description" : "臺灣核心-病情、問題或診斷(TW Core Condition) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWDiagnosticReport"
        },
        "name" : "臺灣核心-診斷報告(TW Core DiagnosticReport) 之資料模型",
        "description" : "臺灣核心-診斷報告(TW Core DiagnosticReport) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWDocumentReference"
        },
        "name" : "臺灣核心-文件參照(TW Core DocumentReference) 之資料模型",
        "description" : "臺灣核心-文件參照(TW Core DocumentReference) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWEncounter"
        },
        "name" : "臺灣核心-就醫事件(TW Core Encounter) 之資料模型",
        "description" : "臺灣核心-就醫事件(TW Core Encounter) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWImagingStudy"
        },
        "name" : "臺灣核心-影像檢查(TW Core ImagingStudy) 之資料模型",
        "description" : "臺灣核心-影像檢查(TW Core ImagingStudy) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWLocation"
        },
        "name" : "臺灣核心-地點(TW Core Location) 之資料模型",
        "description" : "臺灣核心-地點(TW Core Location) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWMedia"
        },
        "name" : "臺灣核心-多媒體(TW Core Media) 之資料模型",
        "description" : "臺灣核心-多媒體(TW Core Media) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWMedication"
        },
        "name" : "臺灣核心-藥品(TW Core Medication) 之資料模型",
        "description" : "臺灣核心-藥品(TW Core Medication) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWMedicationDispense"
        },
        "name" : "臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) 之資料模型",
        "description" : "臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWMedicationRequest"
        },
        "name" : "臺灣核心-藥品請求(TW Core MedicationRequest) 之資料模型",
        "description" : "臺灣核心-藥品請求(TW Core MedicationRequest) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWMedicationStatement"
        },
        "name" : "臺灣核心-用藥聲明(TW Core  MedicationStatement) 之資料模型",
        "description" : "臺灣核心-用藥聲明(TW Core  MedicationStatement) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWMessageHeader"
        },
        "name" : "臺灣核心-訊息表頭(TW Core MessageHeader) 之資料模型",
        "description" : "臺灣核心-訊息表頭(TW Core MessageHeader) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWObservation"
        },
        "name" : "臺灣核心-檢驗檢查(TW Core Observation) 之資料模型",
        "description" : "臺灣核心-檢驗檢查(TW Core Observation) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWOrganization"
        },
        "name" : "臺灣核心-機構(TW Core Organization)之資料模型",
        "description" : "臺灣核心-機構(TW Core Organization)之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWPatient"
        },
        "name" : "臺灣核心-病人(TW Core Patient)之資料模型",
        "description" : "臺灣核心-病人(TW Core Patient)之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWPractitioner"
        },
        "name" : "臺灣核心-健康照護服務提供者(TW Core Practitioner)之資料模型",
        "description" : "臺灣核心-健康照護服務提供者(TW Core Practitioner)之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWPractitionerRole"
        },
        "name" : "臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) 之資料模型",
        "description" : "臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWProcedure"
        },
        "name" : "臺灣核心-處置或手術(TW Core Procedure)之資料模型",
        "description" : "臺灣核心-處置或手術(TW Core Procedure)之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TWSpecimen"
        },
        "name" : "臺灣核心-檢體(TW Core Specimen) 之資料模型",
        "description" : "臺灣核心-檢體(TW Core Specimen) 之資料模型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/identifier-suffix"
        },
        "name" : "Identifier Suffix",
        "description" : "- 增加Practitioner.identifier.type.coding.code欄位也可使用此Extension，以利實務專案使用  \n\n識別碼後綴詞"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/person-age"
        },
        "name" : "Person Age",
        "description" : "年齡"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/questionnaire-url"
        },
        "name" : "Questionnaire Url",
        "description" : "Questionnaire URI"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/AcquisitionModality"
        },
        "name" : "Acquisition Modality",
        "description" : "此值集為 DICOM CID 29 Acquisition Modality 的本地定義，用於解決 IG Publisher 無法解析外部連結的問題。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/category-code-tw"
        },
        "name" : "臺灣衛福部資訊處類型代碼值集",
        "description" : "臺灣衛福部資訊處類型代碼值集"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/condition-code-sct-tw"
        },
        "name" : "SNOMED CT診斷代碼值集",
        "description" : "SNOMED CT診斷代碼值集。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/health-professional-sct-tw"
        },
        "name" : "SNOMED CT + 臺灣醫事司醫事人員類別值集",
        "description" : "SNOMED CT + 臺灣醫事司醫事人員類別值集。\n\n此值集優先採用國際標準碼，國際標準碼未能表述之概念則以普遍被使用的臺灣醫事司醫事人員類別標準碼表述，請實作者留意。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/health-professional-tw"
        },
        "name" : "臺灣醫事司醫事人員類別值集",
        "description" : "臺灣醫事人員類別值集。\n資料所屬單位：衛生福利部醫事司。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/icd-10-cm-2014-tw"
        },
        "name" : "臺灣健保署2014年中文版ICD-10-CM值集",
        "description" : "臺灣健保署2014年中文版ICD-10-CM值集。\n資料所屬單位：衛生福利部中央健康保險署。\n\n\n此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/icd-10-cm-2021-tw"
        },
        "name" : "臺灣健保署2021年中文版ICD-10-CM值集",
        "description" : "臺灣健保署2021年中文版ICD-10-CM值集。\n資料所屬單位：衛生福利部中央健康保險署。\n\n此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/icd-10-cm-2023-tw"
        },
        "name" : "臺灣健保署2023年中文版ICD-10-CM值集",
        "description" : "臺灣健保署2023年中文版ICD-10-CM值集。\n資料所屬單位：衛生福利部中央健康保險署。\n\n此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/icd-10-pcs-2014-tw"
        },
        "name" : "臺灣健保署2014年中文版ICD-10-PCS值集",
        "description" : "臺灣健保署2014年中文版ICD-10-PCS值集。\n資料所屬單位：衛生福利部中央健康保險署。\n\n此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/icd-10-pcs-2021-tw"
        },
        "name" : "臺灣健保署2021年中文版ICD-10-PCS值集",
        "description" : "臺灣健保署2021年中文版ICD-10-PCS值集。\n資料所屬單位：衛生福利部中央健康保險署。\n\n此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/icd-10-pcs-2023-tw"
        },
        "name" : "臺灣健保署2023年中文版ICD-10-PCS值集",
        "description" : "臺灣健保署2023年中文版ICD-10-PCS值集。\n資料所屬單位：衛生福利部中央健康保險署。\n\n此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/icd-9-cm-2001-tw"
        },
        "name" : "臺灣健保署2001年中文版ICD-9-CM值集",
        "description" : "臺灣健保署2001年中文版ICD-9-CM值集。\n資料所屬單位：衛生福利部中央健康保險署。\n\n\n此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－臺灣健保署2001年中文版ICD-9-CM值集](https://fhir.mohw.gov.tw/ts/valuesetRead.jsp?id=icd-9-cm-2001-tw&status=active&version=2023-05-09&metaId=1&composeId=0&composeSystem=0&composeVersion=0&pageSet=preview)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/identifier-type-tw"
        },
        "name" : "IdentifierType + 臺灣衛福部資訊處識別碼類型值集",
        "description" : "IdentifierType + 臺灣衛福部資訊處識別碼類型值集"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/industry-dgbas-tw"
        },
        "name" : "行政院主計總處行業分類值集",
        "description" : "行政院主計總處行業分類值集"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/laboratory-category-tw"
        },
        "name" : "臺灣健保署醫療服務給付項目-檢驗值集",
        "description" : "臺灣健保署醫療服務給付項目-檢驗值集。\n資料所屬單位：衛生福利部中央健康保險署。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/laboratory-code-tw"
        },
        "name" : "臺灣核心-實驗室檢驗檢查值集",
        "description" : "臺灣核心-實驗室檢驗檢查值集，包含LOINC與臺灣健保署醫療服務給付項目-檢驗代碼。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/loinc-doc-section-code"
        },
        "name" : "LOINC Code Document Section值集",
        "description" : "LOINC Code Document Section值集。\n代碼版本：2.81；代碼更新日期：2025-12-01；資料所屬單位：Regenstrief Institute。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/loinc-document-classcodes"
        },
        "name" : "LOINC Document Class值集",
        "description" : "LOINC Document Class值集。\n代碼版本：2.81；代碼更新日期：2025-12-01；資料所屬單位：Regenstrief Institute。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/loinc-observation-code"
        },
        "name" : "LOINC實驗室檢驗檢查值集",
        "description" : "LOINC實驗室檢驗檢查值集。  \n代碼版本：2.81；代碼更新日期：2025-12-01；資料所屬單位：Regenstrief Institute。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/loinc-pregnancy-intent-code"
        },
        "name" : "LOINC +  HL7 NullFlavor妊娠計畫值集",
        "description" : "LOINC +  HL7 NullFlavor妊娠計畫值集。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/loinc-survey-codes"
        },
        "name" : "LOINC篩檢與評估值集",
        "description" : "LOINC篩檢與評估值集。\n代碼版本：2.81；代碼更新日期：2025-12-01；資料所屬單位：Regenstrief Institute。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/loinc-type-doc-code"
        },
        "name" : "LOINC Code Document Type值集",
        "description" : "LOINC Code Document Type值集。  \n代碼版本：2.81；代碼更新日期：2025-12-01；資料所屬單位：Regenstrief Institute。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/marital-status-tw"
        },
        "name" : "臺灣戶政司婚姻狀態值集",
        "description" : "臺灣戶政司婚姻狀態值集。\n資料所屬單位：衛生福利部醫事司。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medcation-atc-tw"
        },
        "name" : "臺灣食藥署藥品藥理治療分類ATC碼值集",
        "description" : "臺灣食藥署藥品藥理治療分類ATC碼值集。\n資料提供單位：衛生福利部食品藥物管理署。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medical-consultation-department-nhi-tw"
        },
        "name" : "臺灣健保署就醫科別值集",
        "description" : "臺灣健保署就醫科別值集。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medical-consultation-department-tw"
        },
        "name" : "無法對應至SNOMED CT之臺灣健保署就醫科別值集",
        "description" : "無法對應至SNOMED CT之臺灣健保署就醫科別值集。\n\n此值集優先採用國際標準碼，國際標準碼未能表述之概念則以普遍被使用的臺灣健保署標準碼表述，請實作者留意。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medical-department-sct-tw"
        },
        "name" : "對應至 SNOMED CT之就醫科別 + 診療科別值集",
        "description" : "因就醫科別與診療科別對應到之國際標準碼 SNOMED CT有共通代碼，因此本值集將兩者的對應代碼整合於同一值集中。  \n\n另為便於使用者更清晰地辨識「[就醫科別](ValueSet-medical-department-sct-tw.html#就醫科別對應表)」及「[診療科別](ValueSet-medical-department-sct-tw.html#診療科別對應表)」的各別完整值集範圍，請參閱以下兩個表格，代碼使用原則為：若想表達的語意有國際代碼可表述，便採用國際代碼；若無對應的國際代碼可表述，則採用健保署編訂的代碼。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medical-treatment-department-nhi-tw"
        },
        "name" : "臺灣健保署診療科別值集",
        "description" : "臺灣健保署診療科別值集。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medical-treatment-department-tw"
        },
        "name" : "無法對應至SNOMED CT之臺灣健保署診療科別值集",
        "description" : "無法對應至SNOMED CT之臺灣健保署診療科別值集。\n\n此值集優先採用國際標準碼，國際標準碼未能表述之概念則以普遍被使用的臺灣健保署標準碼表述，請實作者留意。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medication-fda-tw"
        },
        "name" : "臺灣食藥署藥品及醫療器材代碼值集",
        "description" : "臺灣食藥署藥品及醫療器材代碼值集  \n資料所屬單位：衛生福利部食品藥物管理署。\n\n此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medication-frequency-hl7-tw"
        },
        "name" : "HL7 TimingAbbreviation + 臺灣健保署藥品使用頻率值集",
        "description" : "HL7 TimingAbbreviation + 臺灣健保署藥品使用頻率值集。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medication-frequency-nhi-tw"
        },
        "name" : "臺灣健保署藥品使用頻率值集",
        "description" : "臺灣健保署藥品使用頻率值集   \n資料所屬單位：衛生福利部中央健康保險署。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medication-nhi-tw"
        },
        "name" : "臺灣健保署用藥品項代碼值集",
        "description" : "臺灣健保署用藥品項代碼值集\n資料所屬單位：衛生福利部中央健康保險署。\n\n\n此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medication-path-sct-tw"
        },
        "name" : "SNOMED CT + 臺灣健保署給藥途徑值集",
        "description" : "SNOMED CT + 臺灣健保署給藥途徑值集。\n\n此值集優先採用國際標準碼，國際標準碼未能表述之概念，則以普遍被使用的臺灣健保署給藥途徑代碼表述，請實作者留意。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medication-path-tw"
        },
        "name" : "臺灣健保署給藥途徑值集",
        "description" : "臺灣健保署給藥途徑值集   \n資料所屬單位：衛生福利部中央健康保險署。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medication-rxnorm-tw"
        },
        "name" : "RxNorm藥品代碼值集",
        "description" : "RxNorm藥品代碼值集   \n資料所屬單位：Unified Medical Language System® (UMLS®)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/narrative-status"
        },
        "name" : "臺灣衛福部資訊處Narrative狀態值集",
        "description" : "臺灣衛福部資訊處Narrative狀態值集"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/nhi-medication-ch-herb-tw"
        },
        "name" : "臺灣健保署中藥用藥品項值集",
        "description" : "臺灣健保署中藥用藥品項值集。\n資料所屬單位：衛生福利部中央健康保險署。\n\n\n此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－臺灣健保署健保中藥用藥品項值集](https://fhir.mohw.gov.tw/ts/valuesetRead.jsp?id=medication-nhi-tw&status=active&version=2022-07-28&metaId=1&composeId=0&composeSystem=0&composeVersion=0&pageSet=preview)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/observation-clinical-result-category"
        },
        "name" : "臺灣衛福部資訊處Observation Clinical Result類型值集",
        "description" : "臺灣衛福部資訊處Observation Clinical Result類型值集"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/observation-screening-assessment-category"
        },
        "name" : "臺灣衛福部資訊處Observation Screening Assessment類型值集",
        "description" : "臺灣衛福部資訊處Observation Screening Assessment類型值集"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/occupation-lia-roc-tw"
        },
        "name" : "臺灣壽險公會傷害保險個人職業分類表值集",
        "description" : "臺灣壽險公會傷害保險個人職業分類表值集"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/occupation-mol-tw"
        },
        "name" : "臺灣勞動部職業標準分類值集",
        "description" : "臺灣勞動部職業標準分類值集"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/organization-identifier-tw"
        },
        "name" : "臺灣醫事司醫事機構代碼值集",
        "description" : "臺灣醫事司醫事機構代碼值集。 \n資料所屬單位：衛生福利部中央健康保險署。\n\n此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/postal-code3-tw"
        },
        "name" : "臺灣中華郵政3碼郵遞區號值集",
        "description" : "臺灣中華郵政3碼郵遞區號值集。  \n資料所屬單位：中華郵政。\n\n此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/postal-code5-tw"
        },
        "name" : "臺灣中華郵政5碼郵遞區號值集",
        "description" : "臺灣中華郵政5碼郵遞區號值集。  \n資料所屬單位：中華郵政。\n\n此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/postal-code6-tw"
        },
        "name" : "臺灣中華郵政6碼郵遞區號值集",
        "description" : "臺灣中華郵政6碼郵遞區號值集。  \n資料所屬單位：中華郵政。\n\n此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/procedure-tw"
        },
        "name" : "臺灣健保署醫療服務給付項目-處置或手術值集",
        "description" : "臺灣健保署醫療服務給付項目-處置或手術值集。\n資料所屬單位：衛生福利部中央健康保險署。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/provenance-participant-type-hl7-tw"
        },
        "name" : "HL7 Provenance participant type + 臺灣衛福部資訊處Provenance參與類型",
        "description" : "HL7 Provenance participant type + 臺灣衛福部資訊處Provenance參與類型"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/serviceRequest-category"
        },
        "name" : "臺灣衛福部資訊處ServiceRequest類型值集",
        "description" : "臺灣衛福部資訊處ServiceRequest類型值集"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/smoking-status-comprehensive-code"
        },
        "name" : "SNOMED CT 吸菸狀態綜合評估值集",
        "description" : "SNOMED CT + HL7 NullFlavor 性傾向值集。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/smoking-status-type-code"
        },
        "name" : "SNOMED CT + LOINC 吸菸狀態種類向值集",
        "description" : "SNOMED CT + LOINC 吸菸狀態種類向值集。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/snomed-pregnancy-status-code"
        },
        "name" : "SNOMED CT + HL7 NullFlavor妊娠狀態值集",
        "description" : "SNOMED CT + HL7 NullFlavor妊娠狀態值集。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/snomed-sexual-orientation-code"
        },
        "name" : "SNOMED CT + HL7 NullFlavor 性傾向值集",
        "description" : "SNOMED CT + HL7 NullFlavor 性傾向值集。"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v3-orderableDrugForm"
        },
        "name" : "HL7 OrderableDrugForm藥品劑型值集",
        "description" : "HL7 OrderableDrugForm藥品劑型值集。   \n資料所屬單位：Health Level 7"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vital-signs-tw"
        },
        "name" : "LOINC生命體徵值集",
        "description" : "LOINC生命體徵值集。"
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "目錄",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "應用說明",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "capabilitystatements.html"
            }
          ],
          "nameUrl" : "capabilitystatements.html",
          "title" : "能力聲明",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "searchparameters-and-operation.html"
            }
          ],
          "nameUrl" : "searchparameters-and-operation.html",
          "title" : "查詢參數及操作定義",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "models.html"
            }
          ],
          "nameUrl" : "models.html",
          "title" : "邏輯模型",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "profiles-and-extensions.html"
            }
          ],
          "nameUrl" : "profiles-and-extensions.html",
          "title" : "FHIR Profiles及Extensions",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "terminologies.html"
            }
          ],
          "nameUrl" : "terminologies.html",
          "title" : "專門術語",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples.html"
            }
          ],
          "nameUrl" : "examples.html",
          "title" : "範例",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "結構定義與範例檔下載頁",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "security.html"
            }
          ],
          "nameUrl" : "security.html",
          "title" : "安全性",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "TWCDI.html"
            }
          ],
          "nameUrl" : "TWCDI.html",
          "title" : "TWCDI",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "validates.html"
            }
          ],
          "nameUrl" : "validates.html",
          "title" : "驗證教學",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "artifacts.html"
            }
          ],
          "nameUrl" : "artifacts.html",
          "title" : "規範文件",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "ImplementationGuide-tw.gov.mohw.twcore.html"
            }
          ],
          "nameUrl" : "ImplementationGuide-tw.gov.mohw.twcore.html",
          "title" : "TW Core ImplementationGuide Resource",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
