# 範例 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## 範例

以下為臺灣核心實作指引（TW Core IG）所有Profiles的範例。

### AllergyIntolerance

* [堅果過敏或不耐症](AllergyIntolerance-all-nut-example.md)：依據臺灣核心-過敏或不耐症（TW Core AllergyIntolerance）Profile呈現堅果過敏之範例
* [海鮮過敏或不耐症](AllergyIntolerance-all-seafood-example.md)：依據臺灣核心-過敏或不耐症（TW Core AllergyIntolerance）Profile呈現海鮮過敏之範例
* [藥物過敏或不耐症](AllergyIntolerance-all-medication-example.md)：依據臺灣核心-過敏或不耐症（TW Core AllergyIntolerance）Profile呈現藥物過敏之範例
* [貓毛過敏或不耐症](AllergyIntolerance-all-cat-example.md)：依據臺灣核心-過敏或不耐症（TW Core AllergyIntolerance）Profile呈現貓毛過敏之範例

### Bundle

* [Transaction](Bundle-bun-example.md)：依據臺灣核心-資料交換基本單位（TW Core Bundle）Profile呈現資料交換基本單位 type=transaction之範例
* [Document](Bundle-bun-document-example.md)：依據臺灣核心-資料交換基本單位-文件（TW Core Bundle Document）Profile呈現資料交換基本單位 type=document之範例
* [Document（uuid）](Bundle-bun-document-uuid-example.md)：依據臺灣核心-資料交換基本單位-文件（TW Core Bundle Document）Profile呈現資料交換基本單位 type=document之範例
* [Message request（傳送）](Bundle-bun-message-request-example.md)：依據臺灣核心-資料交換基本單位-訊息傳送（TW Core Bundle Message）Profile呈現資料交換基本單位 type=message request之範例
* [Message response（回應）](Bundle-bun-message-response-example.md)：依據臺灣核心-資料交換基本單位-訊息傳送（TW Core Bundle Message）Profile呈現資料交換基本單位 type=message response之範例

### CarePlan

* [照護計畫](CarePlan-careplan-example.md)：依據臺灣核心-照護計畫（TW Core CarePlan）Profile呈現照護計畫之範例

### CareTeam

* [照護團隊](CareTeam-careteam-example.md)：依據臺灣核心-照護團隊（TW Core CareTeam）Profile呈現照護團隊之範例

### Composition

* [陳加玲的病摘](Composition-com-example.md)：依據臺灣核心-臨床文件架構（TW Core Composition）Profile呈現陳加玲的病摘之範例
* [手術摘要報告](Composition-com-surgery-example.md)：依據臺灣核心-臨床文件架構（TW Core Composition）Profile呈現手術摘要報告之範例

### Condition

* [病情、問題或診斷的詳細資料](Condition-con-example.md)：依據臺灣核心-病情、問題或診斷（TW Core Condition）Profile呈現病情、問題或診斷之範例

### Coverage

* [給付範圍](Coverage-coverage-example.md)：依據臺灣核心-給付範圍（TW Core Coverage）Profile呈現給付範圍之範例

### Device

* [植入式裝置](Device-dev-example.md)：依據臺灣核心-植入式裝置（TW Core Simple Observation）Profile呈現植入式裝置之範例

### DiagnosticReport

* [診斷報告](DiagnosticReport-dia-example.md)：依據臺灣核心-診斷報告（TW Core DiagnosticReport）Profile呈現診斷報告之範例

### DocumentReference

* [門診紀錄](DocumentReference-doc-outpatient-example.md)：依據臺灣核心-文件參照（TW Core DocumentReference）Profile呈現門診紀錄之範例
* [驗傷報告](DocumentReference-doc-wound-example.md)：依據臺灣核心-文件參照（TW Core DocumentReference）Profile呈現驗傷報告之範例

### Encounter

* [就醫的詳細資料](Encounter-enc-example.md)：依據臺灣核心-就醫事件（TW Core Encounter）Profile呈現就醫之範例

### Goal

* [目標](Goal-goa-example.md)：依據臺灣核心-目標（TW Core Goal）Profile呈現目標之範例

### ImagingStudy

* [腹部超音波](ImagingStudy-img-example.md)：依據臺灣核心-影像檢查（TW Core ImagingStudy）Profile呈現腹部超音波之範例
* [胸椎電腦斷層掃描](ImagingStudy-img-ct-example.md)：依據臺灣核心-影像檢查（TW Core ImagingStudy）Profile呈現胸椎電腦斷層掃描之範例
* [雙側乳房磁振造影](ImagingStudy-img-mr-example.md)：依據臺灣核心-影像檢查（TW Core ImagingStudy）Profile呈現雙側乳房磁振造影之範例
* [Positron emission tomography](ImagingStudy-img-pet-example.md)：依據臺灣核心-影像檢查（TW Core ImagingStudy）Profile呈現Slide Microscopy之範例
* [Slide Microscopy](ImagingStudy-img-sm-example.md)：依據臺灣核心-影像檢查（TW Core ImagingStudy）Profile呈現Positron emission tomography之範例

### Immunization

* [疫苗接種](Immunization-imm-example.md)：依據臺灣核心-疫苗接種（TW Core Immunization）Profile呈現疫苗接種之範例

### Location

* [衛生福利部臺北醫院耳鼻喉科](Location-loc-ent-example.md)：依據臺灣核心-地點（TW Core Location）Profile呈現衛生福利部臺北醫院耳鼻喉科之範例
* [衛生福利部臺北醫院急診室](Location-loc-er-example.md)：依據臺灣核心-地點（TW Core Location）Profile呈現衛生福利部臺北醫院急診室之範例
* [衛生福利部臺北醫院X光室](Location-loc-hrad-example.md)：依據臺灣核心-地點（TW Core Location）Profile呈現衛生福利部臺北醫院X光室之範例
* [明捷眼科診所](Location-loc-oph-example.md)：依據臺灣核心-地點（TW Core Location）Profile呈現明捷眼科診所之範例
* [第二藥局](Location-loc-pharm-example.md)：依據臺灣核心-地點（TW Core Location）Profile呈現第二藥局之範例

### Media

* [腦部MRI](Media-media-example.md)：依據臺灣核心-多媒體（TW Core Media）Profile呈現Media之範例

### Medication

* [藥品的詳細資料](Medication-med-example.md)：依據臺灣核心-藥品（TW Core Medication）Profile呈現藥品之範例

### MedicationRequest

* [藥品請求的詳細資料（medicationReference）](MedicationRequest-med-req-ref-example.md)：依據臺灣核心-藥品請求（TW Core MedicationRequest）Profile呈現藥品請求(medicationReference)之範例
* [藥品請求的詳細資料（medicationCodeableConcept）](MedicationRequest-med-req-cod-example.md)：依據臺灣核心-藥品請求（TW Core MedicationRequest）Profile呈現藥品請求(medicationCodeableConcept)之範例

### MedicationDispense

* [阿立批挫藥品配藥（medicationReference）](MedicationDispense-med-dis-ref-example.md)：依據臺灣核心-配藥或藥品調劑（TW Core MedicationDispense）Profile呈現阿立批挫藥品配藥資料之範例
* [爽胰達注射劑100單位+50微克藥品配藥（medicationCodeableConcept）](MedicationDispense-med-dis-injection-example.md)：依據臺灣核心-配藥或藥品調劑（TW Core MedicationDispense）Profile呈現爽胰達注射劑100單位+50微克藥品配藥資料之範例
* [鹽酸四環素眼藥膏藥品配藥（medicationCodeableConcept）](MedicationDispense-med-dis-inflamed-example.md)：依據臺灣核心-配藥或藥品調劑（TW Core MedicationDispense）Profile呈現鹽酸四環素眼藥膏藥品配藥資料之範例
* [每瞳令-普益點眼液藥品配藥（medicationCodeableConcept）](MedicationDispense-med-dis-drop-example.md)：依據臺灣核心-配藥或藥品調劑（TW Core MedicationDispense）Profile呈現每瞳令-普益點眼液藥品配藥資料之範例

### MedicationStatement

* [胰臟炎](MedicationStatement-med-sta-example.md)：依據臺灣核心-用藥聲明（TW Core MedicationStatement）Profile呈現胰臟炎的用藥聲明資料之範例
* [近視](MedicationStatement-med-sta-drop-example.md)：依據臺灣核心-用藥聲明（TW Core MedicationStatement）Profile呈現近視的用藥聲明資料之範例
* [慢性結膜炎](MedicationStatement-med-sta-inflamed-example.md)：依據臺灣核心-用藥聲明（TW Core MedicationStatement）Profile呈現慢性結膜炎的用藥聲明資料之範例
* [第一型糖尿病](MedicationStatement-med-sta-injection-example.md)：依據臺灣核心-用藥聲明（TW Core MedicationStatement）Profile呈現第一型糖尿病的用藥聲明資料之範例

### MessageHeader

* [request (傳送）](MessageHeader-mes-request-example.md)：依據臺灣核心-訊息表頭（TW Core MessageHeader）Profile呈現訊息表頭－request資料之範例
* [response (回應）](MessageHeader-mes-response-example.md)：依據臺灣核心-訊息表頭（TW Core MessageHeader）Profile呈現訊息表頭－response資料之範例

### Observation

* [平均血壓](Observation-obs-averageBloodPressure-example.md)：依據臺灣核心-平均血壓(TW Core Observation Average Blood Pressure) Profile呈現平均血壓之範例
* [病人照護偏好註記](Observation-obs-careExp-example.md)：依據臺灣核心-病人照護偏好註記(TW Core Observation Care Experience Preference) Profile呈現病人照護偏好註記之範例
* [臨床檢驗檢查](Observation-obs-clinical-result-example.md)：依據臺灣核心-臨床檢驗檢查（TW Core Observation Clinical Result）Profile呈現臨床檢驗檢查之範例
* [心電圖檢查](Observation-obs-ecg-example.md)：依據臺灣核心-心電圖（TW Core Observation ECG）Profile呈現心電圖檢查之範例
* [實驗室檢驗檢查-使用臺灣醫療服務給付項目-檢驗值集代碼](Observation-obs-lab-example.md)：依據臺灣核心-實驗室檢驗檢查（TW Core Observation Laboratory Result）Profile呈現檢驗檢查之範例
* [實驗室檢驗檢查-使用LOINC實驗室檢驗檢查代碼](Observation-obs-loinc-example.md)：依據臺灣核心-實驗室檢驗檢查（TW Core Observation Laboratory Result）Profile呈現檢驗檢查之範例
* [職業](Observation-obs-occupation-example.md)：依據臺灣核心-職業(TW Core Simple Observation) Profile呈現職業之範例
* [妊娠計畫](Observation-obs-pregnancy-intent-example.md)：依據臺灣核心-妊娠計畫(TW Core Observation Pregnancy Intent) Profile呈現妊娠計畫之範例
* [妊娠狀態](Observation-obs-pregnancy-status-example.md)：依據臺灣核心-妊娠狀態(TW Core Observation Pregnancy Status) Profile呈現妊娠狀態之範例
* [健康狀態篩檢與評估](Observation-obs-screening-assessment-example.md)：依據臺灣核心-健康狀態篩檢與評估(TW Core Observation Screening Assessment) Profile呈現健康狀態篩檢與評估之範例
* [性傾向](Observation-obs-sexual-orientation-example.md)：依據臺灣核心-性傾向(TW Core Observation Sexual Orientation)呈現性傾向之範例
* [通用檢驗檢查](Observation-obs-simple-example.md)：依據臺灣核心-通用檢驗檢查(TW Core Simple Observation) Profile呈現通用檢驗檢查之範例
* [吸菸狀態](Observation-obs-smoking-status-example.md)：依據臺灣核心-吸菸狀態（TW Core Smoking Status Observation）Profile呈現吸菸狀態之範例
* [病人治療偏好註記](Observation-obs-treatment-intervention-preference-example.md)：依據臺灣核心-病人治療偏好註記（TW Core Observation Treatment Intervention Preference）Profile呈現病人治療偏好註記之範例
* [生命體徵資料-兒童及青少年身體質量指數](Observation-obs-pediatric-bmi-age-example.md)：依據臺灣核心-兒童及青少年身體質量指數(TW Core Pediatric BMI for Age Observation)呈現兒童及青少年身體質量指數之範例
* [生命體徵資料-兒童生長曲線](Observation-obs-pediatric-weight-height-example.md)：依據臺灣核心-兒童生長曲線（TW Core Pediatric Weight for Height Observation）呈現兒童生長曲線之範例
* [生命體徵資料-血壓](Observation-obs-bloodPressure-example.md)：依據臺灣核心-血壓（TW Core Observation Blood Pressure）Profile呈現血壓之範例
* [生命體徵資料-身體質量指數](Observation-obs-bmi-example.md)：依據臺灣核心-身體質量指數（TW Core Observation BMI）Profile呈現身體質量指數之範例
* [生命體徵資料-身高](Observation-obs-height-example.md)：依據臺灣核心-身高(TW Core Observation Body Height)呈現身高之範例
* [生命體徵資料-體溫](Observation-obs-temperature-example.md)：依據臺灣核心-體溫(TW Core Observation Body Temperature)呈現體溫之範例
* [生命體徵資料-體重](Observation-obs-weight-example.md)：依據臺灣核心-體重(TW Core Observation Body Weight)呈現體重之範例
* [生命體徵資料-頭圍](Observation-obs-head-circumference-example.md)：依據臺灣核心-頭圍(TW Core Observation Head Circumference)呈現頭圍之範例
* [生命體徵資料-心率](Observation-obs-heart-rate-example.md)：依據臺灣核心-心率(TW Core Observation Heart Rate)呈現心率之範例
* [生命體徵資料-脈搏血氧飽和度](Observation-obs-pulse-oximetry-example.md)：依據臺灣核心-脈搏血氧飽和度(TW Core Observation Pulse Oximetry)呈現脈搏血氧飽和度之範例
* [生命體徵資料-呼吸速率](Observation-obs-respiratory-rate-example.md)：依據臺灣核心-呼吸速率（TW Core Observation Respiratory Rate）Profile呈現呼吸速率之範例
* [生命體徵資料-兒童頭圍百分位數](Observation-obs-ofc-percentile-example.md)：依據臺灣核心-兒童頭圍百分位數（TW Core Observation Pediatric Head Occipital Frontal Circumference Percentile）Profile呈現兒童頭圍百分位數之範例

### Organization

* [機構基本資料](Organization-org-example.md)：依據臺灣核心-機構（TW Core Organization）Profile呈現機構基本資料之範例
* [政府機構基本資料](Organization-org-govt-example.md)：依據臺灣核心-政府機構（TW Core Organization Government）Profile呈現政府機構基本資料之範例
* [醫事機構基本資料](Organization-org-hosp-example.md)：依據臺灣核心-醫事機構（TW Core Organization Hospital Department）Profile呈現醫事機構基本資料之範例
* [公司行號基本資料](Organization-org-co-example.md)：依據臺灣核心-公司行號（TW Core Organization Insurance Company）Profile呈現公司行號基本資料之範例

### Patient

* [病人基本資料-身分證字號及病歷號](Patient-pat-example.md)：依據臺灣核心-病人（TW Core Patient）Profile呈現病人身分證字號及病歷號之範例
* [病人基本資料-居留證號碼及病歷號](Patient-pat-residentNumber-example.md)：依據臺灣核心-病人（TW Core Patient）Profile呈現病人居留證號碼及病歷號之範例
* [病人(兒童)基本資料-身分證字號及病歷號](Patient-pat-child-example.md)：依據臺灣核心-病人（TW Core Patient）Profile呈現病人(兒童)身分證字號及病歷號之範例

### Practitioner

* [醫師](Practitioner-pra-dr-example.md)：依據臺灣核心-健康照護服務提供者（TW Core Practitioner）Profile呈現醫師基本資料之範例
* [護士](Practitioner-pra-nurse-example.md)：依據臺灣核心-健康照護服務提供者（TW Core Practitioner）Profile呈現護士基本資料之範例
* [藥師](Practitioner-pra-phc-example.md)：依據臺灣核心-健康照護服務提供者（TW Core Practitioner）Profile呈現藥師基本資料之範例
* [醫事放射師](Practitioner-pra-radio-example.md)：依據臺灣核心-健康照護服務提供者（TW Core Practitioner）Profile呈現醫事放射師基本資料之範例

### PractitionerRole

* [醫師](PractitionerRole-praro-dr-example.md)：依據臺灣核心-健康照護服務提供者角色（TW Core PractitionerRole）Profile呈現醫師角色基本資料之範例
* [護士](PractitionerRole-praro-nurse-example.md)：依據臺灣核心-健康照護服務提供者角色（TW Core PractitionerRole）Profile呈現護士角色基本資料之範例
* [藥師](PractitionerRole-praro-phc-example.md)：依據臺灣核心-健康照護服務提供者角色（TW Core PractitionerRole）Profile呈現藥師角色基本資料之範例
* [醫事放射師](PractitionerRole-praro-radio-example.md)：依據臺灣核心-健康照護服務提供者角色（TW Core PractitionerRole）Profile呈現醫事放射師角色基本資料之範例

### Procedure

* [子宮超音波](Procedure-pro-example.md)：依據臺灣核心-處置或手術（TW Core Procedure）Profile呈現子宮超音波之範例
* [闌尾切除](Procedure-pro-appendectomy-example.md)：依據臺灣核心-處置或手術（TW Core Procedure）Profile呈現闌尾切除之範例

### Provenance

* [出處](Provenance-pov-example.md)：依據臺灣核心-出處（TW Core Provenance）Profile呈現出處之範例

### QuestionnaireResponse

* [問卷題目回覆](QuestionnaireResponse-qr-example.md)：依據臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）Profile呈現問卷題目回覆之範例

### RelatedPerson

* [相關人士](RelatedPerson-rel-example.md)：依據臺灣核心-相關人士（TW Core RelatedPerson）Profile呈相關人士之範例

### ServiceRequest

* [服務請求](ServiceRequest-sr-example.md)：依據臺灣核心-服務請求（TW Core ServiceRequest）Profile呈服務請求之範例

### Specimen

* [血液檢體](Specimen-spe-blood-example.md)：依據臺灣核心-檢體（TW Core Specimen）Profile呈現血液檢體之範例
* [糞便檢體](Specimen-spe-stool-example.md)：依據臺灣核心-檢體（TW Core Specimen）Profile呈現糞便檢體之範例
* [尿液檢體](Specimen-spe-ur-example.md)：依據臺灣核心-檢體（TW Core Specimen）Profile呈現尿液檢體之範例
* [組織檢體](Specimen-spe-ance-example.md)：依據臺灣核心-檢體（TW Core Specimen）Profile呈現組織檢體採集之範例

