# HL7 TimingAbbreviation + 臺灣健保署藥品使用頻率值集 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: HL7 TimingAbbreviation + 臺灣健保署藥品使用頻率值集 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-frequency-hl7-tw | *Version*:0.3.0 |
| Active as of 2024-01-16 | *Computable Name*:TWMedicationFrequencyHL7 |
| **Copyright/Legal**: 衛生福利部 | |

 
HL7 TimingAbbreviation + 臺灣健保署藥品使用頻率值集。 

 **References** 

* [TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md)
* [TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md)
* [TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "medication-frequency-hl7-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-frequency-hl7-tw",
  "version" : "0.3.0",
  "name" : "TWMedicationFrequencyHL7",
  "title" : "HL7 TimingAbbreviation + 臺灣健保署藥品使用頻率值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-01-16",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "HL7 TimingAbbreviation + 臺灣健保署藥品使用頻率值集。",
  "copyright" : "衛生福利部",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-GTSAbbreviation"
      },
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-frequency-nhi-tw",
        "concept" : [
          {
            "code" : "MCDxDy",
            "display" : "月經第x天至第y天使用(x,y=1,2,3….)"
          },
          {
            "code" : "QxW",
            "display" : "每x星期一次(x,y=1,2,3,4,….)"
          },
          {
            "code" : "STAT",
            "display" : "立刻使用"
          },
          {
            "code" : "ASORDER",
            "display" : "依照醫師指示使用"
          },
          {
            "code" : "QxH",
            "display" : "每x小時使用一次(x=1,2,3,4…)"
          },
          {
            "code" : "QxMN",
            "display" : "每x分鐘使用一次(x=1,2,3,4…)"
          },
          {
            "code" : "QAM&HS",
            "display" : "上午使用一次且睡前一次"
          },
          {
            "code" : "QAM&PM",
            "display" : "每日上、下午各使用一次"
          },
          {
            "code" : "BID&HS",
            "display" : "每日二次且睡前一次"
          },
          {
            "code" : "TID&HS",
            "display" : "每日三次且睡前一次"
          },
          {
            "code" : "AC",
            "display" : "飯前"
          },
          {
            "code" : "ACxH",
            "display" : "飯前x小時使用"
          },
          {
            "code" : "ACxM",
            "display" : "飯前x分鐘使用"
          },
          {
            "code" : "PC",
            "display" : "飯後"
          },
          {
            "code" : "PCxH",
            "display" : "飯後x小時使用"
          },
          {
            "code" : "PCxM",
            "display" : "飯後x分鐘使用"
          },
          {
            "code" : "PRN",
            "display" : "需要時使用"
          },
          {
            "code" : "QxHPRN",
            "display" : "需要時每x小時使用一次"
          },
          {
            "code" : "yWzD",
            "display" : "每y星期用z天(y,z=1,2,3….)"
          },
          {
            "code" : "QW(x,y,z..)",
            "display" : "每星期x,y,z…使用(x,y,z為一至六、日)"
          },
          {
            "code" : "QxD",
            "display" : "每x日一次(x=2,3,4,…)"
          },
          {
            "code" : "QxM",
            "display" : "每x月一次(x,y=1,2,3,4,….)"
          },
          {
            "code" : "ONCE",
            "display" : "單次給藥"
          },
          {
            "code" : "BIW",
            "display" : "每週二次"
          },
          {
            "code" : "TIW",
            "display" : "每週三次"
          },
          {
            "code" : "QN",
            "display" : "每晚使用一次"
          },
          {
            "code" : "QPM&HS",
            "display" : "下午使用一次且睡前一次"
          },
          {
            "code" : "TID",
            "display" : "每日三次"
          },
          {
            "code" : "Q24H",
            "display" : "每24小時使用1次"
          },
          {
            "code" : "Q30H",
            "display" : "每30小時使用1次"
          },
          {
            "code" : "Q48H",
            "display" : "每48小時使用1次"
          },
          {
            "code" : "QW(1)",
            "display" : "每週一使用"
          },
          {
            "code" : "QW(2)",
            "display" : "每週二使用"
          },
          {
            "code" : "QW(3)",
            "display" : "每週三使用"
          },
          {
            "code" : "QW(4)",
            "display" : "每週四使用"
          },
          {
            "code" : "QW(5)",
            "display" : "每週五使用"
          },
          {
            "code" : "QW(6)",
            "display" : "每週六使用"
          },
          {
            "code" : "QW(7)",
            "display" : "每週日使用"
          },
          {
            "code" : "QW(1,2)",
            "display" : "每週一和週二使用"
          },
          {
            "code" : "QW(1,3)",
            "display" : "每週一和週三使用"
          },
          {
            "code" : "QW(1,4)",
            "display" : "每週一和週四使用"
          },
          {
            "code" : "QW(1,5)",
            "display" : "每週一和週五使用"
          },
          {
            "code" : "QW(1,6)",
            "display" : "每週一和週六使用"
          },
          {
            "code" : "QW(1,7)",
            "display" : "每週一和週日使用"
          },
          {
            "code" : "QW(2,3)",
            "display" : "每週二和週三使用"
          },
          {
            "code" : "QW(2,4)",
            "display" : "每週二和週四使用"
          },
          {
            "code" : "QW(2,5)",
            "display" : "每週二和週五使用"
          },
          {
            "code" : "QW(2,6)",
            "display" : "每週二和週六使用"
          },
          {
            "code" : "QW(2,7)",
            "display" : "每週二和週日使用"
          },
          {
            "code" : "QW(3,4)",
            "display" : "每週三和週四使用"
          },
          {
            "code" : "QW(3,5)",
            "display" : "每週三和週五使用"
          },
          {
            "code" : "QW(3,6)",
            "display" : "每週三和週六使用"
          },
          {
            "code" : "QW(3,7)",
            "display" : "每週三和週日使用"
          },
          {
            "code" : "QW(4,5)",
            "display" : "每週四和週五使用"
          },
          {
            "code" : "QW(4,6)",
            "display" : "每週四和週六使用"
          },
          {
            "code" : "QW(4,7)",
            "display" : "每週四和週日使用"
          },
          {
            "code" : "QW(5,6)",
            "display" : "每週五和週六使用"
          },
          {
            "code" : "QW(5,7)",
            "display" : "每週五和週日使用"
          },
          {
            "code" : "QW(6,7)",
            "display" : "每週六和週日使用"
          },
          {
            "code" : "QW(1,2,3)",
            "display" : "每週一、二和三使用"
          },
          {
            "code" : "QW(1,2,4)",
            "display" : "每週一、二和四使用"
          },
          {
            "code" : "QW(1,2,5)",
            "display" : "每週一、二和五使用"
          },
          {
            "code" : "QW(1,2,6)",
            "display" : "每週一、二和六使用"
          },
          {
            "code" : "QW(1,2,7)",
            "display" : "每週一、二和日使用"
          },
          {
            "code" : "QW(1,3,4)",
            "display" : "每週一、三和四使用"
          },
          {
            "code" : "QW(1,3,5)",
            "display" : "每週一、三和五使用"
          },
          {
            "code" : "QW(1,3,6)",
            "display" : "每週一、三和六使用"
          },
          {
            "code" : "QW(1,3,7)",
            "display" : "每週一、三和日使用"
          },
          {
            "code" : "QW(1,4,5)",
            "display" : "每週一、四和五使用"
          },
          {
            "code" : "QW(1,4,6)",
            "display" : "每週一、四和六使用"
          },
          {
            "code" : "QW(1,4,7)",
            "display" : "每週一、四和日使用"
          },
          {
            "code" : "QW(1,5,6)",
            "display" : "每週一、五和六使用"
          },
          {
            "code" : "QW(1,5,7)",
            "display" : "每週一、五和日使用"
          },
          {
            "code" : "QW(1,6,7)",
            "display" : "每週一、六和日使用"
          },
          {
            "code" : "QW(2,3,4)",
            "display" : "每週二、三和四使用"
          },
          {
            "code" : "QW(2,3,5)",
            "display" : "每週二、三和五使用"
          },
          {
            "code" : "QW(2,3,6)",
            "display" : "每週二、三和六使用"
          },
          {
            "code" : "QW(2,3,7)",
            "display" : "每週二、三和日使用"
          },
          {
            "code" : "QW(2,4,5)",
            "display" : "每週二、四和五使用"
          },
          {
            "code" : "QW(2,4,6)",
            "display" : "每週二、四和六使用"
          },
          {
            "code" : "QW(2,4,7)",
            "display" : "每週二、四和日使用"
          },
          {
            "code" : "QW(2,5,6)",
            "display" : "每週二、五和六使用"
          },
          {
            "code" : "QW(2,5,7)",
            "display" : "每週二、五和日使用"
          },
          {
            "code" : "QW(2,6,7)",
            "display" : "每週二、六和日使用"
          },
          {
            "code" : "QW(3,4,5)",
            "display" : "每週三、四和五使用"
          },
          {
            "code" : "QW(3,4,6)",
            "display" : "每週三、四和六使用"
          },
          {
            "code" : "QW(3,4,7)",
            "display" : "每週三、四和日使用"
          },
          {
            "code" : "QW(3,5,6)",
            "display" : "每週三、五和六使用"
          },
          {
            "code" : "QW(3,5,7)",
            "display" : "每週三、五和日使用"
          },
          {
            "code" : "QW(3,6,7)",
            "display" : "每週三、六和日使用"
          },
          {
            "code" : "QW(4,5,6)",
            "display" : "每週四、五和六使用"
          },
          {
            "code" : "QW(4,5,7)",
            "display" : "每週四、五和日使用"
          },
          {
            "code" : "QW(4,6,7)",
            "display" : "每週四、六和日使用"
          },
          {
            "code" : "QW(5,6,7)",
            "display" : "每週五、六和日使用"
          },
          {
            "code" : "QW(1,2,3,4)",
            "display" : "每週一、二、三和四使用"
          },
          {
            "code" : "QW(1,2,3,5)",
            "display" : "每週一、二、三和五使用"
          },
          {
            "code" : "QW(1,2,3,6)",
            "display" : "每週一、二、三和六使用"
          },
          {
            "code" : "QW(1,2,3,7)",
            "display" : "每週一、二、三和日使用"
          },
          {
            "code" : "QW(1,2,4,5)",
            "display" : "每週一、二、四和五使用"
          },
          {
            "code" : "QW(1,2,4,6)",
            "display" : "每週一、二、四和六使用"
          },
          {
            "code" : "QW(1,2,4,7)",
            "display" : "每週一、二、四和日使用"
          },
          {
            "code" : "QW(1,2,5,6)",
            "display" : "每週一、二、五和六使用"
          },
          {
            "code" : "QW(1,2,5,7)",
            "display" : "每週一、二、五和日使用"
          },
          {
            "code" : "QW(1,2,6,7)",
            "display" : "每週一、二、六和日使用"
          },
          {
            "code" : "QW(1,3,4,5)",
            "display" : "每週一、三、四和五使用"
          },
          {
            "code" : "QW(1,3,4,6)",
            "display" : "每週一、三、四和六使用"
          },
          {
            "code" : "QW(1,3,4,7)",
            "display" : "每週一、三、四和日使用"
          },
          {
            "code" : "QW(1,3,5,6)",
            "display" : "每週一、三、五和六使用"
          },
          {
            "code" : "QW(1,3,5,7)",
            "display" : "每週一、三、五和日使用"
          },
          {
            "code" : "QW(1,3,6,7)",
            "display" : "每週一、三、六和日使用"
          },
          {
            "code" : "QW(1,4,5,6)",
            "display" : "每週一、四、五和六使用"
          },
          {
            "code" : "QW(1,4,5,7)",
            "display" : "每週一、四、五和日使用"
          },
          {
            "code" : "QW(1,4,6,7)",
            "display" : "每週一、四、六和日使用"
          },
          {
            "code" : "QW(1,5,6,7)",
            "display" : "每週一、五、六和日使用"
          },
          {
            "code" : "QW(2,3,4,5)",
            "display" : "每週二、三、四和五使用"
          },
          {
            "code" : "QW(2,3,4,6)",
            "display" : "每週二、三、四和六使用"
          },
          {
            "code" : "QW(2,3,4,7)",
            "display" : "每週二、三、四和日使用"
          },
          {
            "code" : "QW(2,3,5,6)",
            "display" : "每週二、三、五和六使用"
          },
          {
            "code" : "QW(2,3,5,7)",
            "display" : "每週二、三、五和日使用"
          },
          {
            "code" : "QW(2,3,6,7)",
            "display" : "每週二、三、六和日使用"
          },
          {
            "code" : "QW(2,4,5,6)",
            "display" : "每週二、四、五和六使用"
          },
          {
            "code" : "QW(2,4,5,7)",
            "display" : "每週二、四、五和日使用"
          },
          {
            "code" : "QW(2,4,6,7)",
            "display" : "每週二、四、六和日使用"
          },
          {
            "code" : "QW(2,5,6,7)",
            "display" : "每週二、五、六和日使用"
          },
          {
            "code" : "QW(3,4,5,6)",
            "display" : "每週三、四、五和六使用"
          },
          {
            "code" : "QW(3,4,5,7)",
            "display" : "每週三、四、五和日使用"
          },
          {
            "code" : "QW(3,4,6,7)",
            "display" : "每週三、四、六和日使用"
          },
          {
            "code" : "QW(3,5,6,7)",
            "display" : "每週三、五、六和日使用"
          },
          {
            "code" : "QW(4,5,6,7)",
            "display" : "每週四、五、六和日使用"
          },
          {
            "code" : "QW(1,2,3,4,5)",
            "display" : "每週一、二、三、四和五使用"
          },
          {
            "code" : "QW(1,2,3,4,6)",
            "display" : "每週一、二、三、四和六使用"
          },
          {
            "code" : "QW(1,2,3,4,7)",
            "display" : "每週一、二、三、四和日使用"
          },
          {
            "code" : "QW(1,2,3,5,6)",
            "display" : "每週一、二、三、五和六使用"
          },
          {
            "code" : "QW(1,2,3,5,7)",
            "display" : "每週一、二、三、五和日使用"
          },
          {
            "code" : "QW(1,2,3,6,7)",
            "display" : "每週一、二、三、六和日使用"
          },
          {
            "code" : "QW(1,2,4,5,6)",
            "display" : "每週一、二、四、五和六使用"
          },
          {
            "code" : "QW(1,2,4,5,7)",
            "display" : "每週一、二、四、五和日使用"
          },
          {
            "code" : "QW(1,2,4,6,7)",
            "display" : "每週一、二、四、六和日使用"
          },
          {
            "code" : "QW(1,2,5,6,7)",
            "display" : "每週一、二、五、六和日使用"
          },
          {
            "code" : "QW(1,3,4,5,6)",
            "display" : "每週一、三、四、五和六使用"
          },
          {
            "code" : "QW(1,3,4,5,7)",
            "display" : "每週一、三、四、五和日使用"
          },
          {
            "code" : "QW(1,3,4,6,7)",
            "display" : "每週一、三、四、六和日使用"
          },
          {
            "code" : "QW(1,3,5,6,7)",
            "display" : "每週一、三、五、六和日使用"
          },
          {
            "code" : "QW(1,4,5,6,7)",
            "display" : "每週一、四、五、六和日使用"
          },
          {
            "code" : "QW(2,3,4,5,6)",
            "display" : "每週二、三、四、五和六使用"
          },
          {
            "code" : "QW(2,3,4,5,7)",
            "display" : "每週二、三、四、五和日使用"
          },
          {
            "code" : "QW(2,3,4,6,7)",
            "display" : "每週二、三、四、六和日使用"
          },
          {
            "code" : "QW(2,3,5,6,7)",
            "display" : "每週二、三、五、六和日使用"
          },
          {
            "code" : "QW(2,4,5,6,7)",
            "display" : "每週二、四、五、六和日使用"
          },
          {
            "code" : "QW(3,4,5,6,7)",
            "display" : "每週三、四、五、六和日使用"
          },
          {
            "code" : "QW(1,2,3,4,5,6)",
            "display" : "每週一、二、三、四、五和六使用"
          },
          {
            "code" : "QW(1,2,3,4,5,7)",
            "display" : "每週一、二、三、四、五和日使用"
          },
          {
            "code" : "QW(1,2,3,4,6,7)",
            "display" : "每週一、二、三、四、六和日使用"
          },
          {
            "code" : "QW(1,2,3,5,6,7)",
            "display" : "每週一、二、三、五、六和日使用"
          },
          {
            "code" : "QW(1,2,4,5,6,7)",
            "display" : "每週一、二、四、五、六和日使用"
          },
          {
            "code" : "QW(1,3,4,5,6,7)",
            "display" : "每週一、三、四、五、六和日使用"
          },
          {
            "code" : "QW(2,3,4,5,6,7)",
            "display" : "每週二、三、四、五、六和日使用"
          },
          {
            "code" : "QW(1,2,3,4,5,6,7)",
            "display" : "每週一、二、三、四、五、六和日使用"
          },
          {
            "code" : "1W1D",
            "display" : "每1週用1天"
          },
          {
            "code" : "1W2D",
            "display" : "每1週用2天"
          },
          {
            "code" : "1W3D",
            "display" : "每1週用3天"
          },
          {
            "code" : "1W4D",
            "display" : "每1週用4天"
          },
          {
            "code" : "1W5D",
            "display" : "每1週用5天"
          },
          {
            "code" : "1W6D",
            "display" : "每1週用6天"
          },
          {
            "code" : "2W1D",
            "display" : "每2週用1天"
          },
          {
            "code" : "2W2D",
            "display" : "每2週用2天"
          },
          {
            "code" : "2W3D",
            "display" : "每2週用3天"
          },
          {
            "code" : "2W4D",
            "display" : "每2週用4天"
          },
          {
            "code" : "2W5D",
            "display" : "每2週用5天"
          },
          {
            "code" : "2W6D",
            "display" : "每2週用6天"
          },
          {
            "code" : "2W7D",
            "display" : "每2週用7天"
          },
          {
            "code" : "2W8D",
            "display" : "每2週用8天"
          },
          {
            "code" : "2W9D",
            "display" : "每2週用9天"
          },
          {
            "code" : "2W10D",
            "display" : "每2週用10天"
          },
          {
            "code" : "3W1D",
            "display" : "每3週用1天"
          },
          {
            "code" : "3W2D",
            "display" : "每3週用2天"
          },
          {
            "code" : "3W3D",
            "display" : "每3週用3天"
          },
          {
            "code" : "3W4D",
            "display" : "每3週用4天"
          },
          {
            "code" : "3W5D",
            "display" : "每3週用5天"
          },
          {
            "code" : "3W6D",
            "display" : "每3週用6天"
          },
          {
            "code" : "3W7D",
            "display" : "每3週用7天"
          },
          {
            "code" : "3W8D",
            "display" : "每3週用8天"
          },
          {
            "code" : "3W9D",
            "display" : "每3週用9天"
          },
          {
            "code" : "3W10D",
            "display" : "每3週用10天"
          },
          {
            "code" : "4W1D",
            "display" : "每4週用1天"
          },
          {
            "code" : "4W2D",
            "display" : "每4週用2天"
          },
          {
            "code" : "4W3D",
            "display" : "每4週用3天"
          },
          {
            "code" : "4W4D",
            "display" : "每4週用4天"
          },
          {
            "code" : "4W5D",
            "display" : "每4週用5天"
          },
          {
            "code" : "4W6D",
            "display" : "每4週用6天"
          },
          {
            "code" : "4W7D",
            "display" : "每4週用7天"
          },
          {
            "code" : "4W8D",
            "display" : "每4週用8天"
          },
          {
            "code" : "43W9D",
            "display" : "每4週用9天"
          },
          {
            "code" : "4W10D",
            "display" : "每4週用10天"
          },
          {
            "code" : "MCD1D1",
            "display" : "月經第1天至第1天使用"
          },
          {
            "code" : "MCD1D2",
            "display" : "月經第1天至第2天使用"
          },
          {
            "code" : "MCD1D3",
            "display" : "月經第1天至第3天使用"
          },
          {
            "code" : "MCD1D4",
            "display" : "月經第1天至第4天使用"
          },
          {
            "code" : "MCD1D5",
            "display" : "月經第1天至第5天使用"
          },
          {
            "code" : "MCD1D6",
            "display" : "月經第1天至第6天使用"
          },
          {
            "code" : "MCD1D7",
            "display" : "月經第1天至第7天使用"
          },
          {
            "code" : "MCD2D2",
            "display" : "月經第2天至第2天使用"
          },
          {
            "code" : "MCD2D3",
            "display" : "月經第2天至第3天使用"
          },
          {
            "code" : "MCD2D4",
            "display" : "月經第2天至第4天使用"
          },
          {
            "code" : "MCD2D5",
            "display" : "月經第2天至第5天使用"
          },
          {
            "code" : "MCD2D6",
            "display" : "月經第2天至第6天使用"
          },
          {
            "code" : "MCD2D7",
            "display" : "月經第2天至第7天使用"
          },
          {
            "code" : "MCD3D3",
            "display" : "月經第3天至第3天使用"
          },
          {
            "code" : "MCD3D4",
            "display" : "月經第3天至第4天使用"
          },
          {
            "code" : "MCD3D5",
            "display" : "月經第3天至第5天使用"
          },
          {
            "code" : "MCD3D6",
            "display" : "月經第3天至第6天使用"
          },
          {
            "code" : "MCD3D7",
            "display" : "月經第3天至第7天使用"
          },
          {
            "code" : "MCD4D4",
            "display" : "月經第4天至第4天使用"
          },
          {
            "code" : "MCD4D5",
            "display" : "月經第4天至第5天使用"
          },
          {
            "code" : "MCD4D6",
            "display" : "月經第4天至第6天使用"
          },
          {
            "code" : "MCD4D7",
            "display" : "月經第4天至第7天使用"
          },
          {
            "code" : "MCD5D5",
            "display" : "月經第5天至第5天使用"
          },
          {
            "code" : "MCD5D6",
            "display" : "月經第5天至第6天使用"
          },
          {
            "code" : "MCD5D7",
            "display" : "月經第5天至第7天使用"
          },
          {
            "code" : "MCD6D6",
            "display" : "月經第6天至第6天使用"
          },
          {
            "code" : "MCD6D7",
            "display" : "月經第6天至第7天使用"
          },
          {
            "code" : "MCD7D7",
            "display" : "月經第7天至第7天使用"
          },
          {
            "code" : "Q2D",
            "display" : "每2日一次"
          },
          {
            "code" : "Q3D",
            "display" : "每3日一次"
          },
          {
            "code" : "Q4D",
            "display" : "每4日一次"
          },
          {
            "code" : "Q5D",
            "display" : "每5日一次"
          },
          {
            "code" : "Q6D",
            "display" : "每6日一次"
          },
          {
            "code" : "Q7D",
            "display" : "每7日一次"
          },
          {
            "code" : "Q8D",
            "display" : "每8日一次"
          },
          {
            "code" : "Q9D",
            "display" : "每9日一次"
          },
          {
            "code" : "Q10D",
            "display" : "每10日一次"
          },
          {
            "code" : "Q11D",
            "display" : "每11日一次"
          },
          {
            "code" : "Q12D",
            "display" : "每12日一次"
          },
          {
            "code" : "Q13D",
            "display" : "每13日一次"
          },
          {
            "code" : "Q14D",
            "display" : "每14日一次"
          },
          {
            "code" : "Q15D",
            "display" : "每15日一次"
          },
          {
            "code" : "Q16D",
            "display" : "每16日一次"
          },
          {
            "code" : "Q17D",
            "display" : "每17日一次"
          },
          {
            "code" : "Q18D",
            "display" : "每18日一次"
          },
          {
            "code" : "Q19D",
            "display" : "每19日一次"
          },
          {
            "code" : "Q20D",
            "display" : "每20日一次"
          },
          {
            "code" : "Q21D",
            "display" : "每21日一次"
          },
          {
            "code" : "Q22D",
            "display" : "每22日一次"
          },
          {
            "code" : "Q23D",
            "display" : "每23日一次"
          },
          {
            "code" : "Q24D",
            "display" : "每24日一次"
          },
          {
            "code" : "Q25D",
            "display" : "每25日一次"
          },
          {
            "code" : "Q26D",
            "display" : "每26日一次"
          },
          {
            "code" : "Q27D",
            "display" : "每27日一次"
          },
          {
            "code" : "Q28D",
            "display" : "每28日一次"
          },
          {
            "code" : "Q29D",
            "display" : "每29日一次"
          },
          {
            "code" : "Q1M",
            "display" : "每1月一次"
          },
          {
            "code" : "Q2M",
            "display" : "每2月一次"
          },
          {
            "code" : "Q3M",
            "display" : "每3月一次"
          },
          {
            "code" : "Q4M",
            "display" : "每4月一次"
          },
          {
            "code" : "Q5M",
            "display" : "每5月一次"
          },
          {
            "code" : "Q6M",
            "display" : "每6月一次"
          },
          {
            "code" : "Q7M",
            "display" : "每7月一次"
          },
          {
            "code" : "Q8M",
            "display" : "每8月一次"
          },
          {
            "code" : "Q9M",
            "display" : "每9月一次"
          },
          {
            "code" : "Q10M",
            "display" : "每10月一次"
          },
          {
            "code" : "Q11M",
            "display" : "每11月一次"
          },
          {
            "code" : "Q1W",
            "display" : "每1週一次"
          },
          {
            "code" : "Q2W",
            "display" : "每2週一次"
          },
          {
            "code" : "Q3W",
            "display" : "每3週一次"
          },
          {
            "code" : "Q4W",
            "display" : "每4週一次"
          },
          {
            "code" : "Q5W",
            "display" : "每5週一次"
          },
          {
            "code" : "Q6W",
            "display" : "每6週一次"
          },
          {
            "code" : "Q7W",
            "display" : "每7週一次"
          },
          {
            "code" : "Q8W",
            "display" : "每8週一次"
          },
          {
            "code" : "Q9W",
            "display" : "每9週一次"
          },
          {
            "code" : "Q10W",
            "display" : "每10週一次"
          },
          {
            "code" : "Q11W",
            "display" : "每11週一次"
          },
          {
            "code" : "Q12W",
            "display" : "每12週一次"
          },
          {
            "code" : "Q13W",
            "display" : "每13週一次"
          },
          {
            "code" : "Q14W",
            "display" : "每14週一次"
          },
          {
            "code" : "Q15W",
            "display" : "每15週一次"
          },
          {
            "code" : "Q16W",
            "display" : "每16週一次"
          },
          {
            "code" : "Q17W",
            "display" : "每17週一次"
          },
          {
            "code" : "Q18W",
            "display" : "每18週一次"
          },
          {
            "code" : "Q19W",
            "display" : "每19週一次"
          },
          {
            "code" : "Q20W",
            "display" : "每20週一次"
          },
          {
            "code" : "Q21W",
            "display" : "每21週一次"
          },
          {
            "code" : "Q22W",
            "display" : "每22週一次"
          },
          {
            "code" : "Q23W",
            "display" : "每23週一次"
          },
          {
            "code" : "Q24W",
            "display" : "每24週一次"
          },
          {
            "code" : "Q25W",
            "display" : "每25週一次"
          },
          {
            "code" : "Q26W",
            "display" : "每26週一次"
          },
          {
            "code" : "Q27W",
            "display" : "每27週一次"
          },
          {
            "code" : "Q28W",
            "display" : "每28週一次"
          },
          {
            "code" : "Q29W",
            "display" : "每29週一次"
          },
          {
            "code" : "Q30W",
            "display" : "每30週一次"
          },
          {
            "code" : "Q31W",
            "display" : "每31週一次"
          },
          {
            "code" : "Q32W",
            "display" : "每32週一次"
          },
          {
            "code" : "Q33W",
            "display" : "每33週一次"
          },
          {
            "code" : "Q34W",
            "display" : "每34週一次"
          },
          {
            "code" : "Q35W",
            "display" : "每35週一次"
          },
          {
            "code" : "Q36W",
            "display" : "每36週一次"
          },
          {
            "code" : "Q37W",
            "display" : "每37週一次"
          },
          {
            "code" : "Q38W",
            "display" : "每38週一次"
          },
          {
            "code" : "Q39W",
            "display" : "每39週一次"
          },
          {
            "code" : "Q40W",
            "display" : "每40週一次"
          },
          {
            "code" : "Q41W",
            "display" : "每41週一次"
          },
          {
            "code" : "Q42W",
            "display" : "每42週一次"
          },
          {
            "code" : "Q43W",
            "display" : "每43週一次"
          },
          {
            "code" : "Q44W",
            "display" : "每44週一次"
          },
          {
            "code" : "Q45W",
            "display" : "每45週一次"
          },
          {
            "code" : "Q46W",
            "display" : "每46週一次"
          },
          {
            "code" : "Q47W",
            "display" : "每47週一次"
          },
          {
            "code" : "Q48W",
            "display" : "每48週一次"
          },
          {
            "code" : "Q49W",
            "display" : "每49週一次"
          },
          {
            "code" : "Q50W",
            "display" : "每50週一次"
          },
          {
            "code" : "Q51W",
            "display" : "每51週一次"
          },
          {
            "code" : "Q1H",
            "display" : "每1小時使用一次"
          },
          {
            "code" : "Q2H",
            "display" : "每2小時使用一次"
          },
          {
            "code" : "Q3H",
            "display" : "每3小時使用一次"
          },
          {
            "code" : "Q4H",
            "display" : "每4小時使用一次"
          },
          {
            "code" : "Q5H",
            "display" : "每5小時使用一次"
          },
          {
            "code" : "Q6H",
            "display" : "每6小時使用一次"
          },
          {
            "code" : "Q7H",
            "display" : "每7小時使用一次"
          },
          {
            "code" : "Q8H",
            "display" : "每8小時使用一次"
          },
          {
            "code" : "Q9H",
            "display" : "每9小時使用一次"
          },
          {
            "code" : "Q10H",
            "display" : "每10小時使用一次"
          },
          {
            "code" : "Q11H",
            "display" : "每11小時使用一次"
          },
          {
            "code" : "Q12H",
            "display" : "每12小時使用一次"
          },
          {
            "code" : "Q13H",
            "display" : "每13小時使用一次"
          },
          {
            "code" : "Q14H",
            "display" : "每14小時使用一次"
          },
          {
            "code" : "Q15H",
            "display" : "每15小時使用一次"
          },
          {
            "code" : "Q16H",
            "display" : "每16小時使用一次"
          },
          {
            "code" : "Q17H",
            "display" : "每17小時使用一次"
          },
          {
            "code" : "Q18H",
            "display" : "每18小時使用一次"
          },
          {
            "code" : "Q19H",
            "display" : "每19小時使用一次"
          },
          {
            "code" : "Q20H",
            "display" : "每20小時使用一次"
          },
          {
            "code" : "Q21H",
            "display" : "每21小時使用一次"
          },
          {
            "code" : "Q22H",
            "display" : "每22小時使用一次"
          },
          {
            "code" : "Q23H",
            "display" : "每23小時使用一次"
          },
          {
            "code" : "Q1MN",
            "display" : "每1分鐘使用一次"
          },
          {
            "code" : "Q2MN",
            "display" : "每2分鐘使用一次"
          },
          {
            "code" : "Q3MN",
            "display" : "每3分鐘使用一次"
          },
          {
            "code" : "Q4MN",
            "display" : "每4分鐘使用一次"
          },
          {
            "code" : "Q5MN",
            "display" : "每5分鐘使用一次"
          },
          {
            "code" : "Q6MN",
            "display" : "每6分鐘使用一次"
          },
          {
            "code" : "Q7MN",
            "display" : "每7分鐘使用一次"
          },
          {
            "code" : "Q8MN",
            "display" : "每8分鐘使用一次"
          },
          {
            "code" : "Q9MN",
            "display" : "每9分鐘使用一次"
          },
          {
            "code" : "Q10MN",
            "display" : "每10分鐘使用一次"
          },
          {
            "code" : "Q11MN",
            "display" : "每11分鐘使用一次"
          },
          {
            "code" : "Q12MN",
            "display" : "每12分鐘使用一次"
          },
          {
            "code" : "Q13MN",
            "display" : "每13分鐘使用一次"
          },
          {
            "code" : "Q14MN",
            "display" : "每14分鐘使用一次"
          },
          {
            "code" : "Q15MN",
            "display" : "每15分鐘使用一次"
          },
          {
            "code" : "Q16MN",
            "display" : "每16分鐘使用一次"
          },
          {
            "code" : "Q17MN",
            "display" : "每17分鐘使用一次"
          },
          {
            "code" : "Q18MN",
            "display" : "每18分鐘使用一次"
          },
          {
            "code" : "Q19MN",
            "display" : "每19分鐘使用一次"
          },
          {
            "code" : "Q20MN",
            "display" : "每20分鐘使用一次"
          },
          {
            "code" : "Q21MN",
            "display" : "每21分鐘使用一次"
          },
          {
            "code" : "Q22MN",
            "display" : "每22分鐘使用一次"
          },
          {
            "code" : "Q23MN",
            "display" : "每23分鐘使用一次"
          },
          {
            "code" : "Q24MN",
            "display" : "每24分鐘使用一次"
          },
          {
            "code" : "Q25MN",
            "display" : "每25分鐘使用一次"
          },
          {
            "code" : "Q26MN",
            "display" : "每26分鐘使用一次"
          },
          {
            "code" : "Q27MN",
            "display" : "每27分鐘使用一次"
          },
          {
            "code" : "Q28MN",
            "display" : "每28分鐘使用一次"
          },
          {
            "code" : "Q29MN",
            "display" : "每29分鐘使用一次"
          },
          {
            "code" : "Q30MN",
            "display" : "每30分鐘使用一次"
          },
          {
            "code" : "Q31MN",
            "display" : "每31分鐘使用一次"
          },
          {
            "code" : "Q32MN",
            "display" : "每32分鐘使用一次"
          },
          {
            "code" : "Q33MN",
            "display" : "每33分鐘使用一次"
          },
          {
            "code" : "Q34MN",
            "display" : "每34分鐘使用一次"
          },
          {
            "code" : "Q35MN",
            "display" : "每35分鐘使用一次"
          },
          {
            "code" : "Q36MN",
            "display" : "欽36分鐘使用一次"
          },
          {
            "code" : "Q37MN",
            "display" : "每37分鐘使用一次"
          },
          {
            "code" : "Q38MN",
            "display" : "每38分鐘使用一次"
          },
          {
            "code" : "Q39MN",
            "display" : "每39分鐘使用一次"
          },
          {
            "code" : "Q40MN",
            "display" : "每40分鐘使用一次"
          },
          {
            "code" : "Q41MN",
            "display" : "每41分鐘使用一次"
          },
          {
            "code" : "Q42MN",
            "display" : "每42分鐘使用一次"
          },
          {
            "code" : "Q43MN",
            "display" : "每43分鐘使用一次"
          },
          {
            "code" : "Q44MN",
            "display" : "每44分鐘使用一次"
          },
          {
            "code" : "Q45MN",
            "display" : "每45分鐘使用一次"
          },
          {
            "code" : "Q46MN",
            "display" : "每46分鐘使用一次"
          },
          {
            "code" : "Q47MN",
            "display" : "每47分鐘使用一次"
          },
          {
            "code" : "Q48MN",
            "display" : "每48分鐘使用一次"
          },
          {
            "code" : "Q49MN",
            "display" : "每49分鐘使用一次"
          },
          {
            "code" : "Q50MN",
            "display" : "每50分鐘使用一次"
          },
          {
            "code" : "Q51MN",
            "display" : "每51分鐘使用一次"
          },
          {
            "code" : "Q52MN",
            "display" : "每52分鐘使用一次"
          },
          {
            "code" : "Q53MN",
            "display" : "每53分鐘使用一次"
          },
          {
            "code" : "Q54MN",
            "display" : "每54分鐘使用一次"
          },
          {
            "code" : "Q55MN",
            "display" : "每55分鐘使用一次"
          },
          {
            "code" : "Q56MN",
            "display" : "每56分鐘使用一次"
          },
          {
            "code" : "Q57MN",
            "display" : "每57分鐘使用一次"
          },
          {
            "code" : "Q58MN",
            "display" : "每58分鐘使用一次"
          },
          {
            "code" : "Q59MN",
            "display" : "每59分鐘使用一次"
          },
          {
            "code" : "AC1H",
            "display" : "飯前1小時使用"
          },
          {
            "code" : "AC2H",
            "display" : "飯前2小時使用"
          },
          {
            "code" : "AC3H",
            "display" : "飯前3小時使用"
          },
          {
            "code" : "AC4H",
            "display" : "飯前4小時使用"
          },
          {
            "code" : "AC5H",
            "display" : "飯前5小時使用"
          },
          {
            "code" : "AC6H",
            "display" : "飯前6小時使用"
          },
          {
            "code" : "AC7H",
            "display" : "飯前7小時使用"
          },
          {
            "code" : "AC8H",
            "display" : "飯前8小時使用"
          },
          {
            "code" : "AC9H",
            "display" : "飯前9小時使用"
          },
          {
            "code" : "AC10H",
            "display" : "飯前10小時使用"
          },
          {
            "code" : "AC11H",
            "display" : "飯前11小時使用"
          },
          {
            "code" : "AC12H",
            "display" : "飯前12小時使用"
          },
          {
            "code" : "AC13H",
            "display" : "飯前13小時使用"
          },
          {
            "code" : "AC14H",
            "display" : "飯前14小時使用"
          },
          {
            "code" : "AC15H",
            "display" : "飯前15小時使用"
          },
          {
            "code" : "AC16H",
            "display" : "飯前16小時使用"
          },
          {
            "code" : "AC17H",
            "display" : "飯前17小時使用"
          },
          {
            "code" : "AC18H",
            "display" : "飯前18小時使用"
          },
          {
            "code" : "AC19H",
            "display" : "飯前19小時使用"
          },
          {
            "code" : "AC20H",
            "display" : "飯前20小時使用"
          },
          {
            "code" : "AC21H",
            "display" : "飯前21小時使用"
          },
          {
            "code" : "AC22H",
            "display" : "飯前22小時使用"
          },
          {
            "code" : "AC23H",
            "display" : "飯前23小時使用"
          },
          {
            "code" : "AC1M",
            "display" : "飯前1分鐘使用"
          },
          {
            "code" : "AC2M",
            "display" : "飯前2分鐘使用"
          },
          {
            "code" : "AC3M",
            "display" : "飯前3分鐘使用"
          },
          {
            "code" : "AC4M",
            "display" : "飯前4分鐘使用"
          },
          {
            "code" : "AC5M",
            "display" : "飯前5分鐘使用"
          },
          {
            "code" : "AC6M",
            "display" : "飯前6分鐘使用"
          },
          {
            "code" : "AC7M",
            "display" : "飯前7分鐘使用"
          },
          {
            "code" : "AC8M",
            "display" : "飯前8分鐘使用"
          },
          {
            "code" : "AC9M",
            "display" : "飯前9分鐘使用"
          },
          {
            "code" : "AC10M",
            "display" : "飯前10分鐘使用"
          },
          {
            "code" : "AC11M",
            "display" : "飯前11分鐘使用"
          },
          {
            "code" : "AC12M",
            "display" : "飯前12分鐘使用"
          },
          {
            "code" : "AC13M",
            "display" : "飯前13分鐘使用"
          },
          {
            "code" : "AC14M",
            "display" : "飯前14分鐘使用"
          },
          {
            "code" : "AC15M",
            "display" : "飯前15分鐘使用"
          },
          {
            "code" : "AC16M",
            "display" : "飯前16分鐘使用"
          },
          {
            "code" : "AC17M",
            "display" : "飯前17分鐘使用"
          },
          {
            "code" : "AC18M",
            "display" : "飯前18分鐘使用"
          },
          {
            "code" : "AC19M",
            "display" : "飯前19分鐘使用"
          },
          {
            "code" : "AC20M",
            "display" : "飯前20分鐘使用"
          },
          {
            "code" : "AC21M",
            "display" : "飯前21分鐘使用"
          },
          {
            "code" : "AC22M",
            "display" : "飯前22分鐘使用"
          },
          {
            "code" : "AC23M",
            "display" : "飯前23分鐘使用"
          },
          {
            "code" : "AC24M",
            "display" : "飯前24分鐘使用"
          },
          {
            "code" : "AC25M",
            "display" : "飯前25分鐘使用"
          },
          {
            "code" : "AC26M",
            "display" : "飯前26分鐘使用"
          },
          {
            "code" : "AC27M",
            "display" : "飯前27分鐘使用"
          },
          {
            "code" : "AC28M",
            "display" : "飯前28分鐘使用"
          },
          {
            "code" : "AC29M",
            "display" : "飯前29分鐘使用"
          },
          {
            "code" : "AC30M",
            "display" : "飯前30分鐘使用"
          },
          {
            "code" : "AC31M",
            "display" : "飯前31分鐘使用"
          },
          {
            "code" : "AC32M",
            "display" : "飯前32分鐘使用"
          },
          {
            "code" : "AC33M",
            "display" : "飯前33分鐘使用"
          },
          {
            "code" : "AC34M",
            "display" : "飯前34分鐘使用"
          },
          {
            "code" : "AC35M",
            "display" : "飯前35分鐘使用"
          },
          {
            "code" : "AC36M",
            "display" : "飯前36分鐘使用"
          },
          {
            "code" : "AC37M",
            "display" : "飯前37分鐘使用"
          },
          {
            "code" : "AC38M",
            "display" : "飯前38分鐘使用"
          },
          {
            "code" : "AC39M",
            "display" : "飯前39分鐘使用"
          },
          {
            "code" : "AC40M",
            "display" : "飯前40分鐘使用"
          },
          {
            "code" : "AC41M",
            "display" : "飯前41分鐘使用"
          },
          {
            "code" : "AC42M",
            "display" : "飯前42分鐘使用"
          },
          {
            "code" : "AC43M",
            "display" : "飯前43分鐘使用"
          },
          {
            "code" : "AC44M",
            "display" : "飯前44分鐘使用"
          },
          {
            "code" : "AC45M",
            "display" : "飯前45分鐘使用"
          },
          {
            "code" : "AC46M",
            "display" : "飯前46分鐘使用"
          },
          {
            "code" : "AC47M",
            "display" : "飯前47分鐘使用"
          },
          {
            "code" : "AC48M",
            "display" : "飯前48分鐘使用"
          },
          {
            "code" : "AC49M",
            "display" : "飯前49分鐘使用"
          },
          {
            "code" : "AC50M",
            "display" : "飯前50分鐘使用"
          },
          {
            "code" : "AC51M",
            "display" : "飯前51分鐘使用"
          },
          {
            "code" : "AC52M",
            "display" : "飯前52分鐘使用"
          },
          {
            "code" : "AC53M",
            "display" : "飯前53分鐘使用"
          },
          {
            "code" : "AC54M",
            "display" : "飯前54分鐘使用"
          },
          {
            "code" : "AC55M",
            "display" : "飯前55分鐘使用"
          },
          {
            "code" : "AC56M",
            "display" : "飯前56分鐘使用"
          },
          {
            "code" : "AC57M",
            "display" : "飯前57分鐘使用"
          },
          {
            "code" : "AC58M",
            "display" : "飯前58分鐘使用"
          },
          {
            "code" : "AC59M",
            "display" : "飯前59分鐘使用"
          },
          {
            "code" : "PC1H",
            "display" : "飯後1小時使用"
          },
          {
            "code" : "PC2H",
            "display" : "飯後2小時使用"
          },
          {
            "code" : "PC3H",
            "display" : "飯後3小時使用"
          },
          {
            "code" : "PC4H",
            "display" : "飯後4小時使用"
          },
          {
            "code" : "PC5H",
            "display" : "飯後5小時使用"
          },
          {
            "code" : "PC6H",
            "display" : "飯後6小時使用"
          },
          {
            "code" : "PC7H",
            "display" : "飯後7小時使用"
          },
          {
            "code" : "PC8H",
            "display" : "飯後8小時使用"
          },
          {
            "code" : "PC9H",
            "display" : "飯後9小時使用"
          },
          {
            "code" : "PC10H",
            "display" : "飯後10小時使用"
          },
          {
            "code" : "PC11H",
            "display" : "飯後11小時使用"
          },
          {
            "code" : "PC12H",
            "display" : "飯後12小時使用"
          },
          {
            "code" : "PC13H",
            "display" : "飯後13小時使用"
          },
          {
            "code" : "PC14H",
            "display" : "飯後14小時使用"
          },
          {
            "code" : "PC15H",
            "display" : "飯後15小時使用"
          },
          {
            "code" : "PC16H",
            "display" : "飯後16小時使用"
          },
          {
            "code" : "PC17H",
            "display" : "飯後17小時使用"
          },
          {
            "code" : "PC18H",
            "display" : "飯後18小時使用"
          },
          {
            "code" : "PC19H",
            "display" : "飯後19小時使用"
          },
          {
            "code" : "PC20H",
            "display" : "飯後20小時使用"
          },
          {
            "code" : "PC21H",
            "display" : "飯後21小時使用"
          },
          {
            "code" : "PC22H",
            "display" : "飯後22小時使用"
          },
          {
            "code" : "PC23H",
            "display" : "飯後23小時使用"
          },
          {
            "code" : "PC1M",
            "display" : "飯後1分鐘使用"
          },
          {
            "code" : "PC2M",
            "display" : "飯後2分鐘使用"
          },
          {
            "code" : "PC3M",
            "display" : "飯後3分鐘使用"
          },
          {
            "code" : "PC4M",
            "display" : "飯後4分鐘使用"
          },
          {
            "code" : "PC5M",
            "display" : "飯後5分鐘使用"
          },
          {
            "code" : "PC6M",
            "display" : "飯後6分鐘使用"
          },
          {
            "code" : "PC7M",
            "display" : "飯後7分鐘使用"
          },
          {
            "code" : "PC8M",
            "display" : "飯後8分鐘使用"
          },
          {
            "code" : "PC9M",
            "display" : "飯後9分鐘使用"
          },
          {
            "code" : "PC10M",
            "display" : "飯後10分鐘使用"
          },
          {
            "code" : "PC11M",
            "display" : "飯後11分鐘使用"
          },
          {
            "code" : "PC12M",
            "display" : "飯後12分鐘使用"
          },
          {
            "code" : "PC13M",
            "display" : "飯後13分鐘使用"
          },
          {
            "code" : "PC14M",
            "display" : "飯後14分鐘使用"
          },
          {
            "code" : "PC15M",
            "display" : "飯後15分鐘使用"
          },
          {
            "code" : "PC16M",
            "display" : "飯後16分鐘使用"
          },
          {
            "code" : "PC17M",
            "display" : "飯後17分鐘使用"
          },
          {
            "code" : "PC18M",
            "display" : "飯後18分鐘使用"
          },
          {
            "code" : "PC19M",
            "display" : "飯後19分鐘使用"
          },
          {
            "code" : "PC20M",
            "display" : "飯後20分鐘使用"
          },
          {
            "code" : "PC21M",
            "display" : "飯後21分鐘使用"
          },
          {
            "code" : "PC22M",
            "display" : "飯後22分鐘使用"
          },
          {
            "code" : "PC23M",
            "display" : "飯後23分鐘使用"
          },
          {
            "code" : "PC24M",
            "display" : "飯後24分鐘使用"
          },
          {
            "code" : "PC25M",
            "display" : "飯後25分鐘使用"
          },
          {
            "code" : "PC26M",
            "display" : "飯後26分鐘使用"
          },
          {
            "code" : "PC27M",
            "display" : "飯後27分鐘使用"
          },
          {
            "code" : "PC28M",
            "display" : "飯後28分鐘使用"
          },
          {
            "code" : "PC29M",
            "display" : "飯後29分鐘使用"
          },
          {
            "code" : "PC30M",
            "display" : "飯後30分鐘使用"
          },
          {
            "code" : "PC31M",
            "display" : "飯後31分鐘使用"
          },
          {
            "code" : "PC32M",
            "display" : "飯後32分鐘使用"
          },
          {
            "code" : "PC33M",
            "display" : "飯後33分鐘使用"
          },
          {
            "code" : "PC34M",
            "display" : "飯後34分鐘使用"
          },
          {
            "code" : "PC35M",
            "display" : "飯後35分鐘使用"
          },
          {
            "code" : "PC36M",
            "display" : "飯後36分鐘使用"
          },
          {
            "code" : "PC37M",
            "display" : "飯後37分鐘使用"
          },
          {
            "code" : "PC38M",
            "display" : "飯後38分鐘使用"
          },
          {
            "code" : "PC39M",
            "display" : "飯後39分鐘使用"
          },
          {
            "code" : "PC40M",
            "display" : "飯後40分鐘使用"
          },
          {
            "code" : "PC41M",
            "display" : "飯後41分鐘使用"
          },
          {
            "code" : "PC42M",
            "display" : "飯後42分鐘使用"
          },
          {
            "code" : "PC43M",
            "display" : "飯後43分鐘使用"
          },
          {
            "code" : "PC44M",
            "display" : "飯後44分鐘使用"
          },
          {
            "code" : "PC45M",
            "display" : "飯後45分鐘使用"
          },
          {
            "code" : "PC46M",
            "display" : "飯後46分鐘使用"
          },
          {
            "code" : "PC47M",
            "display" : "飯後47分鐘使用"
          },
          {
            "code" : "PC48M",
            "display" : "飯後48分鐘使用"
          },
          {
            "code" : "PC49M",
            "display" : "飯後49分鐘使用"
          },
          {
            "code" : "PC50M",
            "display" : "飯後50分鐘使用"
          },
          {
            "code" : "PC51M",
            "display" : "飯後51分鐘使用"
          },
          {
            "code" : "PC52M",
            "display" : "飯後52分鐘使用"
          },
          {
            "code" : "PC53M",
            "display" : "飯後53分鐘使用"
          },
          {
            "code" : "PC54M",
            "display" : "飯後54分鐘使用"
          },
          {
            "code" : "PC55M",
            "display" : "飯後55分鐘使用"
          },
          {
            "code" : "PC56M",
            "display" : "飯後56分鐘使用"
          },
          {
            "code" : "PC57M",
            "display" : "飯後57分鐘使用"
          },
          {
            "code" : "PC58M",
            "display" : "飯後58分鐘使用"
          },
          {
            "code" : "PC59M",
            "display" : "飯後59分鐘使用"
          },
          {
            "code" : "Q1HPRN",
            "display" : "需要時每1小時使用一次"
          },
          {
            "code" : "Q2HPRN",
            "display" : "需要時每2小時使用一次"
          },
          {
            "code" : "Q3HPRN",
            "display" : "需要時每3小時使用一次"
          },
          {
            "code" : "Q4HPRN",
            "display" : "需要時每4小時使用一次"
          },
          {
            "code" : "Q5HPRN",
            "display" : "需要時每5小時使用一次"
          },
          {
            "code" : "Q6HPRN",
            "display" : "需要時每6小時使用一次"
          },
          {
            "code" : "Q7HPRN",
            "display" : "需要時每7小時使用一次"
          },
          {
            "code" : "Q8HPRN",
            "display" : "需要時每8小時使用一次"
          },
          {
            "code" : "Q9HPRN",
            "display" : "需要時每9小時使用一次"
          },
          {
            "code" : "Q10HPRN",
            "display" : "需要時每10小時使用一次"
          },
          {
            "code" : "Q11HPRN",
            "display" : "需要時每11小時使用一次"
          },
          {
            "code" : "Q12HPRN",
            "display" : "需要時每12小時使用一次"
          },
          {
            "code" : "Q13HPRN",
            "display" : "需要時每13小時使用一次"
          },
          {
            "code" : "Q14HPRN",
            "display" : "需要時每14小時使用一次"
          },
          {
            "code" : "Q15HPRN",
            "display" : "需要時每15小時使用一次"
          },
          {
            "code" : "Q16HPRN",
            "display" : "需要時每16小時使用一次"
          },
          {
            "code" : "Q17HPRN",
            "display" : "需要時每17小時使用一次"
          },
          {
            "code" : "Q18HPRN",
            "display" : "需要時每18小時使用一次"
          },
          {
            "code" : "Q19HPRN",
            "display" : "需要時每19小時使用一次"
          },
          {
            "code" : "Q20HPRN",
            "display" : "需要時每20小時使用一次"
          },
          {
            "code" : "Q21HPRN",
            "display" : "需要時每21小時使用一次"
          },
          {
            "code" : "Q22HPRN",
            "display" : "需要時每22小時使用一次"
          },
          {
            "code" : "Q23HPRN",
            "display" : "需要時每23小時使用一次"
          }
        ]
      }
    ]
  }
}

```
