# 無法對應至SNOMED CT之臺灣健保署診療科別值集 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: 無法對應至SNOMED CT之臺灣健保署診療科別值集 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medical-treatment-department-tw | *Version*:0.3.0 |
| Active as of 2024-05-27 | *Computable Name*:TWMedicalTreatmentDepartment |

 
無法對應至SNOMED CT之臺灣健保署診療科別值集。 
此值集優先採用國際標準碼，國際標準碼未能表述之概念則以普遍被使用的臺灣健保署標準碼表述，請實作者留意。 

 **References** 

* [TW Core Encounter](StructureDefinition-Encounter-twcore.md)
* [TW Core PractitionerRole](StructureDefinition-PractitionerRole-twcore.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "medical-treatment-department-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medical-treatment-department-tw",
  "version" : "0.3.0",
  "name" : "TWMedicalTreatmentDepartment",
  "title" : "無法對應至SNOMED CT之臺灣健保署診療科別值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-05-27",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "無法對應至SNOMED CT之臺灣健保署診療科別值集。\n\n此值集優先採用國際標準碼，國際標準碼未能表述之概念則以普遍被使用的臺灣健保署標準碼表述，請實作者留意。\n",
  "compose" : {
    "include" : [
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-treatment-department-nhi-tw",
        "concept" : [
          {
            "code" : "00",
            "display" : "不分科"
          },
          {
            "code" : "2A",
            "display" : "結核科"
          },
          {
            "code" : "2B",
            "display" : "洗腎科"
          },
          {
            "code" : "41",
            "display" : "牙體復形科"
          },
          {
            "code" : "44",
            "display" : "贋復補綴牙科"
          },
          {
            "code" : "48",
            "display" : "口腔診斷科"
          },
          {
            "code" : "49",
            "display" : "口腔病理科"
          },
          {
            "code" : "50",
            "display" : "家庭牙醫科"
          },
          {
            "code" : "51",
            "display" : "特殊需求者口腔醫學科"
          },
          {
            "code" : "60",
            "display" : "中醫一般科"
          },
          {
            "code" : "86",
            "display" : "放射診斷科"
          }
        ]
      }
    ]
  }
}

```
