# 臺灣食藥署藥品藥理治療分類ATC碼值集 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: 臺灣食藥署藥品藥理治療分類ATC碼值集 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medcation-atc-tw | *Version*:2022-10-24 |
| Active as of 2014-09-19 | *Computable Name*:TWMedcationATC |

 
臺灣食藥署藥品藥理治療分類ATC碼值集。 資料提供單位：衛生福利部食品藥物管理署。 

 **References** 

* [TW Core Medication](StructureDefinition-Medication-twcore.md)
* [TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md)
* [TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md)
* [TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "medcation-atc-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medcation-atc-tw",
  "version" : "2022-10-24",
  "name" : "TWMedcationATC",
  "title" : "臺灣食藥署藥品藥理治療分類ATC碼值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-09-19",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣食藥署藥品藥理治療分類ATC碼值集。\n資料提供單位：衛生福利部食品藥物管理署。",
  "compose" : {
    "include" : [
      {
        "system" : "http://www.whocc.no/atc",
        "concept" : [
          {
            "code" : "A01AB14",
            "display" : "benzoxonium chloride"
          },
          {
            "code" : "A02AA05",
            "display" : "magnesium silicate"
          },
          {
            "code" : "A02AD01",
            "display" : "ordinary salt combinations"
          },
          {
            "code" : "A02AG",
            "display" : "Antacids with antispasmodics"
          },
          {
            "code" : "A02BD05",
            "display" : "omeprazole, amoxicillin and clarithromycin"
          },
          {
            "code" : "A02BD10",
            "display" : "lansoprazole, amoxicillin and levofloxacin"
          },
          {
            "code" : "A02BX02",
            "display" : "sucralfate"
          },
          {
            "code" : "A02BX03",
            "display" : "pirenzepine"
          },
          {
            "code" : "A03AD01",
            "display" : "papaverine"
          },
          {
            "code" : "A03AX",
            "display" : "Other drugs for functional gastrointestinal disorders"
          },
          {
            "code" : "A03AX58",
            "display" : "alverine, combinations"
          },
          {
            "code" : "A03CB31",
            "display" : "hyoscyamine and psycholeptics"
          },
          {
            "code" : "A04AD01",
            "display" : "scopolamine"
          },
          {
            "code" : "A05AA03",
            "display" : "cholic acid"
          },
          {
            "code" : "A05AX02",
            "display" : "hymecromone"
          },
          {
            "code" : "A05BA04",
            "display" : "citiolone"
          },
          {
            "code" : "A06AB20",
            "display" : "contact laxatives in combination"
          },
          {
            "code" : "A06AB52",
            "display" : "bisacodyl, combinations"
          },
          {
            "code" : "A06AD10",
            "display" : "mineral salts in combination"
          },
          {
            "code" : "A06AG10",
            "display" : "docusate sodium, incl. combinations"
          },
          {
            "code" : "A07AA08",
            "display" : "kanamycin"
          },
          {
            "code" : "A07AC01",
            "display" : "miconazole"
          },
          {
            "code" : "A07DA02",
            "display" : "opium"
          },
          {
            "code" : "A07E",
            "display" : "INTESTINAL ANTIINFLAMMATORY AGENTS"
          },
          {
            "code" : "A07EA03",
            "display" : "prednisone"
          },
          {
            "code" : "A07EA07",
            "display" : "beclometasone"
          },
          {
            "code" : "A07EC01",
            "display" : "sulfasalazine"
          },
          {
            "code" : "A07FA51",
            "display" : "lactic acid producing organisms, combinations"
          },
          {
            "code" : "A09AB02",
            "display" : "betaine hydrochloride"
          },
          {
            "code" : "A10AB04",
            "display" : "insulin lispro"
          },
          {
            "code" : "A10AB05",
            "display" : "insulin aspart"
          },
          {
            "code" : "A10BB08",
            "display" : "gliquidone"
          },
          {
            "code" : "A10BD11",
            "display" : "metformin and linagliptin"
          },
          {
            "code" : "A10BD24",
            "display" : "sitagliptin and ertugliflozin"
          },
          {
            "code" : "A10BK03",
            "display" : "empagliflozin"
          },
          {
            "code" : "A11AA",
            "display" : "Multivitamins with minerals"
          },
          {
            "code" : "A11CC55",
            "display" : "colecalciferol, combinations"
          },
          {
            "code" : "A11DA03",
            "display" : "benfotiamine"
          },
          {
            "code" : "A11DB",
            "display" : "Vitamin B1 in combination with vitamin B6 and/or vitamin B12"
          },
          {
            "code" : "A11G",
            "display" : "ASCORBIC ACID (VITAMIN C), INCL. COMBINATIONS"
          },
          {
            "code" : "A11JA",
            "display" : "Combinations of vitamins"
          },
          {
            "code" : "A11JB",
            "display" : "Vitamins with minerals"
          },
          {
            "code" : "A12AA09",
            "display" : "calcium citrate lysine complex"
          },
          {
            "code" : "A12BA02",
            "display" : "potassium citrate"
          },
          {
            "code" : "A12BA04",
            "display" : "potassium hydrogencarbonate"
          },
          {
            "code" : "A12BA51",
            "display" : "potassium chloride, combinations"
          },
          {
            "code" : "A12CB",
            "display" : "Zinc"
          },
          {
            "code" : "A13A",
            "display" : "TONICS"
          },
          {
            "code" : "A14AA02",
            "display" : "stanozolol"
          },
          {
            "code" : "A16AA",
            "display" : "Amino acids and derivatives"
          },
          {
            "code" : "A16AB02",
            "display" : "imiglucerase"
          },
          {
            "code" : "A16AB04",
            "display" : "agalsidase beta"
          },
          {
            "code" : "A16AB09",
            "display" : "idursulfase"
          },
          {
            "code" : "A16AB17",
            "display" : "cerliponase alfa"
          },
          {
            "code" : "B01AB04",
            "display" : "dalteparin"
          },
          {
            "code" : "B01AC16",
            "display" : "eptifibatide"
          },
          {
            "code" : "B01AD02",
            "display" : "alteplase"
          },
          {
            "code" : "B01AD04",
            "display" : "urokinase"
          },
          {
            "code" : "B02AB01",
            "display" : "aprotinin"
          },
          {
            "code" : "B02B",
            "display" : "VITAMIN K AND OTHER HEMOSTATICS"
          },
          {
            "code" : "B02BD02",
            "display" : "coagulation factor VIII"
          },
          {
            "code" : "B02BX01",
            "display" : "etamsylate"
          },
          {
            "code" : "B03AA12",
            "display" : "ferrous sodium citrate"
          },
          {
            "code" : "B03BA",
            "display" : "Vitamin B12 (cyanocobalamin and analogues)"
          },
          {
            "code" : "B05BA02",
            "display" : "fat emulsions"
          },
          {
            "code" : "B05BB01",
            "display" : "electrolytes"
          },
          {
            "code" : "B05BB04",
            "display" : "electrolytes in combination with other drugs"
          },
          {
            "code" : "B05BC01",
            "display" : "mannitol"
          },
          {
            "code" : "B05CA03",
            "display" : "nitrofural"
          },
          {
            "code" : "B05CX03",
            "display" : "glycine"
          },
          {
            "code" : "B05D",
            "display" : "PERITONEAL DIALYTICS"
          },
          {
            "code" : "B05DA",
            "display" : "Isotonic solutions"
          },
          {
            "code" : "B05X",
            "display" : "I.V. SOLUTION ADDITIVES"
          },
          {
            "code" : "B05XA08",
            "display" : "sodium acetate"
          },
          {
            "code" : "B05XA09",
            "display" : "sodium phosphate"
          },
          {
            "code" : "B05XA17",
            "display" : "potassium acetate"
          },
          {
            "code" : "B05XX02",
            "display" : "trometamol"
          },
          {
            "code" : "B05Z",
            "display" : "HEMODIALYTICS AND HEMOFILTRATES"
          },
          {
            "code" : "B06A",
            "display" : "OTHER HEMATOLOGICAL AGENTS"
          },
          {
            "code" : "B06AC01",
            "display" : "c1-inhibitor, plasma derived"
          },
          {
            "code" : "C01AA04",
            "display" : "digitoxin"
          },
          {
            "code" : "C01BC03",
            "display" : "propafenone"
          },
          {
            "code" : "C01CA01",
            "display" : "etilefrine"
          },
          {
            "code" : "C01CA17",
            "display" : "midodrine"
          },
          {
            "code" : "C01CE02",
            "display" : "milrinone"
          },
          {
            "code" : "C01DA05",
            "display" : "pentaerithrityl tetranitrate"
          },
          {
            "code" : "C01DA08",
            "display" : "isosorbide dinitrate"
          },
          {
            "code" : "C01EB10",
            "display" : "adenosine"
          },
          {
            "code" : "C01EB17",
            "display" : "ivabradine"
          },
          {
            "code" : "C02AB",
            "display" : "Methyldopa"
          },
          {
            "code" : "C02CC02",
            "display" : "guanethidine"
          },
          {
            "code" : "C02DA01",
            "display" : "diazoxide"
          },
          {
            "code" : "C02KX05",
            "display" : "riociguat"
          },
          {
            "code" : "C02LE01",
            "display" : "prazosin and diuretics"
          },
          {
            "code" : "C02LG02",
            "display" : "hydralazine and diuretics"
          },
          {
            "code" : "C03BA11",
            "display" : "indapamide"
          },
          {
            "code" : "C03CA01",
            "display" : "furosemide"
          },
          {
            "code" : "C03CB01",
            "display" : "furosemide and potassium"
          },
          {
            "code" : "C03DA04",
            "display" : "eplerenone"
          },
          {
            "code" : "C03DB01",
            "display" : "amiloride"
          },
          {
            "code" : "C03EA01",
            "display" : "hydrochlorothiazide and potassium-sparing agents"
          },
          {
            "code" : "C03EB01",
            "display" : "furosemide and potassium-sparing agents"
          },
          {
            "code" : "C04AA02",
            "display" : "buphenine"
          },
          {
            "code" : "C04AE",
            "display" : "Ergot alkaloids"
          },
          {
            "code" : "A01AA01",
            "display" : "sodium fluoride"
          },
          {
            "code" : "A01AB09",
            "display" : "miconazole"
          },
          {
            "code" : "A01AB11",
            "display" : "various"
          },
          {
            "code" : "A01AB22",
            "display" : "doxycycline"
          },
          {
            "code" : "A01AC54",
            "display" : "prednisolone, combinations"
          },
          {
            "code" : "A02AB",
            "display" : "Aluminium compounds"
          },
          {
            "code" : "A02AC",
            "display" : "Calcium compounds"
          },
          {
            "code" : "A02AD",
            "display" : "Combinations and complexes of aluminium, calcium and magnesium compounds"
          },
          {
            "code" : "A02AF01",
            "display" : "magaldrate and antiflatulents"
          },
          {
            "code" : "A02BC01",
            "display" : "omeprazole"
          },
          {
            "code" : "A02BC53",
            "display" : "lansoprazole, combinations"
          },
          {
            "code" : "A03AB19",
            "display" : "timepidium bromide"
          },
          {
            "code" : "A03AX04",
            "display" : "pinaverium"
          },
          {
            "code" : "A03DB04",
            "display" : "butylscopolamine and analgesics"
          },
          {
            "code" : "A04AA03",
            "display" : "tropisetron"
          },
          {
            "code" : "A05AX",
            "display" : "Other drugs for bile therapy"
          },
          {
            "code" : "A05B",
            "display" : "LIVER THERAPY, LIPOTROPICS"
          },
          {
            "code" : "A05BA03",
            "display" : "silymarin"
          },
          {
            "code" : "A05C",
            "display" : "DRUGS FOR BILE THERAPY AND LIPOTROPICS IN COMBINATION"
          },
          {
            "code" : "A06AB",
            "display" : "Contact laxatives"
          },
          {
            "code" : "A06AB04",
            "display" : "phenolphthalein"
          },
          {
            "code" : "A06AD02",
            "display" : "magnesium oxide"
          },
          {
            "code" : "A06AD13",
            "display" : "sodium sulfate"
          },
          {
            "code" : "A06AG01",
            "display" : "sodium phosphate"
          },
          {
            "code" : "A06AG20",
            "display" : "combinations"
          },
          {
            "code" : "A06AX05",
            "display" : "prucalopride"
          },
          {
            "code" : "A07EA01",
            "display" : "prednisolone"
          },
          {
            "code" : "A07FA",
            "display" : "Antidiarrheal microorganisms"
          },
          {
            "code" : "A08AB01",
            "display" : "orlistat"
          },
          {
            "code" : "A09A",
            "display" : "DIGESTIVES, INCL. ENZYMES"
          },
          {
            "code" : "A09AB03",
            "display" : "hydrochloric acid"
          },
          {
            "code" : "A09AC",
            "display" : "Enzyme and acid preparations, combinations"
          },
          {
            "code" : "A10A",
            "display" : "INSULINS AND ANALOGUES"
          },
          {
            "code" : "A10AB03",
            "display" : "insulin (pork)"
          },
          {
            "code" : "A10AE05",
            "display" : "insulin detemir"
          },
          {
            "code" : "A10BB09",
            "display" : "gliclazide"
          },
          {
            "code" : "A10BD03",
            "display" : "metformin and rosiglitazone"
          },
          {
            "code" : "A10BD19",
            "display" : "linagliptin and empagliflozin"
          },
          {
            "code" : "A10BF02",
            "display" : "miglitol"
          },
          {
            "code" : "A10BG02",
            "display" : "rosiglitazone"
          },
          {
            "code" : "A10BX08",
            "display" : "mitiglinide"
          },
          {
            "code" : "A11A",
            "display" : "MULTIVITAMINS, COMBINATIONS"
          },
          {
            "code" : "A11AA02",
            "display" : "multivitamins and calcium"
          },
          {
            "code" : "A11BA",
            "display" : "Multivitamins, plain"
          },
          {
            "code" : "A11CC",
            "display" : "Vitamin D and analogues"
          },
          {
            "code" : "A11CC01",
            "display" : "ergocalciferol"
          },
          {
            "code" : "A11CC03",
            "display" : "alfacalcidol"
          },
          {
            "code" : "A11DA01",
            "display" : "thiamine (vit B1)"
          },
          {
            "code" : "A11GA",
            "display" : "Ascorbic acid (vitamin C), plain"
          },
          {
            "code" : "A11H",
            "display" : "OTHER PLAIN VITAMIN PREPARATIONS"
          },
          {
            "code" : "A11HA",
            "display" : "Other plain vitamin preparations"
          },
          {
            "code" : "A11HA07",
            "display" : "inositol"
          },
          {
            "code" : "A11JC",
            "display" : "Vitamins, other combinations"
          },
          {
            "code" : "A12",
            "display" : "MINERAL SUPPLEMENTS"
          },
          {
            "code" : "A12AA08",
            "display" : "calcium glycerylphosphate"
          },
          {
            "code" : "A12AA20",
            "display" : "calcium (different salts in combination)"
          },
          {
            "code" : "A12CA01",
            "display" : "sodium chloride"
          },
          {
            "code" : "A12CB02",
            "display" : "zinc gluconate"
          },
          {
            "code" : "A12CC01",
            "display" : "magnesium chloride"
          },
          {
            "code" : "B01AC05",
            "display" : "ticlopidine"
          },
          {
            "code" : "B01AC21",
            "display" : "treprostinil"
          },
          {
            "code" : "B02BA02",
            "display" : "menadione"
          },
          {
            "code" : "B02BB",
            "display" : "Fibrinogen"
          },
          {
            "code" : "B02BX",
            "display" : "Other systemic hemostatics"
          },
          {
            "code" : "B02BX04",
            "display" : "romiplostim"
          },
          {
            "code" : "B03AB02",
            "display" : "saccharated iron oxide"
          },
          {
            "code" : "B03AD",
            "display" : "Iron in combination with folic acid"
          },
          {
            "code" : "B03BA05",
            "display" : "mecobalamin"
          },
          {
            "code" : "B03BB51",
            "display" : "folic acid, combinations"
          },
          {
            "code" : "B05BA10",
            "display" : "combinations"
          },
          {
            "code" : "B05C",
            "display" : "IRRIGATING SOLUTIONS"
          },
          {
            "code" : "B05CA04",
            "display" : "sulfamethizole"
          },
          {
            "code" : "B05XA31",
            "display" : "electrolytes in combination with other drugs"
          },
          {
            "code" : "B05XB03",
            "display" : "lysine"
          },
          {
            "code" : "B05ZB",
            "display" : "Hemofiltrates"
          },
          {
            "code" : "B06AB",
            "display" : "Heme products"
          },
          {
            "code" : "C01EA",
            "display" : "Prostaglandins"
          },
          {
            "code" : "C02AB01",
            "display" : "methyldopa (levorotatory)"
          },
          {
            "code" : "C02KX01",
            "display" : "bosentan"
          },
          {
            "code" : "C02LA01",
            "display" : "reserpine and diuretics"
          },
          {
            "code" : "C02LA51",
            "display" : "reserpine and diuretics, combinations with other drugs"
          },
          {
            "code" : "C03AA04",
            "display" : "chlorothiazide"
          },
          {
            "code" : "C04AE01",
            "display" : "ergoloid mesylates"
          },
          {
            "code" : "C04AX11",
            "display" : "bencyclane"
          },
          {
            "code" : "C05A",
            "display" : "AGENTS FOR TREATMENT OF HEMORRHOIDS AND ANAL FISSURES FOR TOPICAL USE"
          },
          {
            "code" : "C05AA10",
            "display" : "fluocinolone acetonide"
          },
          {
            "code" : "C05AD03",
            "display" : "benzocaine"
          },
          {
            "code" : "C05AX01",
            "display" : "aluminium preparations"
          },
          {
            "code" : "C05CX",
            "display" : "Other capillary stabilizing agents"
          },
          {
            "code" : "C07AA01",
            "display" : "alprenolol"
          },
          {
            "code" : "C07AA15",
            "display" : "carteolol"
          },
          {
            "code" : "C08CA09",
            "display" : "lacidipine"
          },
          {
            "code" : "C08CA15",
            "display" : "benidipine"
          },
          {
            "code" : "C09CA01",
            "display" : "losartan"
          },
          {
            "code" : "C09CA04",
            "display" : "irbesartan"
          },
          {
            "code" : "C09DA",
            "display" : "Angiotensin II receptor blockers (ARBs) and diuretics"
          },
          {
            "code" : "C09DB02",
            "display" : "olmesartan medoxomil and amlodipine"
          },
          {
            "code" : "C09DB09",
            "display" : "fimasartan and amlodipine"
          },
          {
            "code" : "C09DX04",
            "display" : "valsartan and sacubitril"
          },
          {
            "code" : "C09DX07",
            "display" : "irbesartan, amlodipine and hydrochlorothiazide"
          },
          {
            "code" : "C09XA52",
            "display" : "aliskiren and hydrochlorothiazide"
          },
          {
            "code" : "A02AA01",
            "display" : "magnesium carbonate"
          },
          {
            "code" : "A02AB03",
            "display" : "aluminium phosphate"
          },
          {
            "code" : "A02AB07",
            "display" : "aluminium glycinate"
          },
          {
            "code" : "A02AD03",
            "display" : "almagate"
          },
          {
            "code" : "A02BA01",
            "display" : "cimetidine"
          },
          {
            "code" : "A02BA02",
            "display" : "ranitidine"
          },
          {
            "code" : "A02BA06",
            "display" : "roxatidine"
          },
          {
            "code" : "A02BC04",
            "display" : "rabeprazole"
          },
          {
            "code" : "A02BD01",
            "display" : "omeprazole, amoxicillin and metronidazole"
          },
          {
            "code" : "A02BD09",
            "display" : "lansoprazole, clarithromycin and tinidazole"
          },
          {
            "code" : "A02BD13",
            "display" : "rabeprazole, amoxicillin and metronidazole"
          },
          {
            "code" : "A02BX04",
            "display" : "methiosulfonium chloride"
          },
          {
            "code" : "A03AA30",
            "display" : "piperidolate"
          },
          {
            "code" : "A03AB",
            "display" : "Synthetic anticholinergics, quaternary ammonium compounds"
          },
          {
            "code" : "A03AB05",
            "display" : "propantheline"
          },
          {
            "code" : "A03AB17",
            "display" : "tiemonium iodide"
          },
          {
            "code" : "A03AB21",
            "display" : "fenpiverinium"
          },
          {
            "code" : "A03AD",
            "display" : "Papaverine and derivatives"
          },
          {
            "code" : "A03BA04",
            "display" : "belladonna total alkaloids"
          },
          {
            "code" : "A03FA04",
            "display" : "bromopride"
          },
          {
            "code" : "A04AD02",
            "display" : "cerium oxalate"
          },
          {
            "code" : "A06A",
            "display" : "DRUGS FOR CONSTIPATION"
          },
          {
            "code" : "A06AC08",
            "display" : "polycarbophil calcium"
          },
          {
            "code" : "A06AD",
            "display" : "Osmotically acting laxatives"
          },
          {
            "code" : "A06AG07",
            "display" : "sorbitol"
          },
          {
            "code" : "A07AA09",
            "display" : "vancomycin"
          },
          {
            "code" : "A07BC04",
            "display" : "attapulgite"
          },
          {
            "code" : "A07EA02",
            "display" : "hydrocortisone"
          },
          {
            "code" : "A07X",
            "display" : "OTHER ANTIDIARRHEALS"
          },
          {
            "code" : "A07XA51",
            "display" : "albumin tannate, combinations"
          },
          {
            "code" : "A09AA01",
            "display" : "diastase"
          },
          {
            "code" : "A09AB04",
            "display" : "citric acid"
          },
          {
            "code" : "A10AE01",
            "display" : "insulin (human)"
          },
          {
            "code" : "A10BB",
            "display" : "Sulfonylureas"
          },
          {
            "code" : "A10BB12",
            "display" : "glimepiride"
          },
          {
            "code" : "A10BD02",
            "display" : "metformin and sulfonylureas"
          },
          {
            "code" : "A10BD18",
            "display" : "metformin and gemigliptin"
          },
          {
            "code" : "A10BH04",
            "display" : "alogliptin"
          },
          {
            "code" : "A10BK01",
            "display" : "dapagliflozin"
          },
          {
            "code" : "A10BX03",
            "display" : "nateglinide"
          },
          {
            "code" : "A11EC",
            "display" : "Vitamin B-complex with minerals"
          },
          {
            "code" : "A11EX",
            "display" : "Vitamin B-complex, other combinations"
          },
          {
            "code" : "A11HA31",
            "display" : "calcium pantothenate"
          },
          {
            "code" : "A11J",
            "display" : "OTHER VITAMIN PRODUCTS, COMBINATIONS"
          },
          {
            "code" : "A12CC03",
            "display" : "magnesium gluconate"
          },
          {
            "code" : "A16AB03",
            "display" : "agalsidase alfa"
          },
          {
            "code" : "A16AX05",
            "display" : "zinc acetate"
          },
          {
            "code" : "A16AX06",
            "display" : "miglustat"
          },
          {
            "code" : "B01AB02",
            "display" : "antithrombin III"
          },
          {
            "code" : "B01AD12",
            "display" : "protein C"
          },
          {
            "code" : "B02AA02",
            "display" : "tranexamic acid"
          },
          {
            "code" : "B02BB01",
            "display" : "fibrinogen, human"
          },
          {
            "code" : "B02BC01",
            "display" : "absorbable gelatin sponge"
          },
          {
            "code" : "B02BC09",
            "display" : "epinephrine"
          },
          {
            "code" : "B02BD04",
            "display" : "coagulation factor IX"
          },
          {
            "code" : "B02BD10",
            "display" : "von Willebrand factor"
          },
          {
            "code" : "B03AB07",
            "display" : "chondroitin sulfate-iron complex"
          },
          {
            "code" : "B03BA02",
            "display" : "cyanocobalamin tannin complex"
          },
          {
            "code" : "B03XA03",
            "display" : "methoxy polyethylene glycol-epoetin beta"
          },
          {
            "code" : "B05AA01",
            "display" : "albumin"
          },
          {
            "code" : "B05AA02",
            "display" : "other plasma protein fractions"
          },
          {
            "code" : "B05CX04",
            "display" : "mannitol"
          },
          {
            "code" : "B05XA01",
            "display" : "potassium chloride"
          },
          {
            "code" : "B05XA02",
            "display" : "sodium bicarbonate"
          },
          {
            "code" : "B05XA11",
            "display" : "magnesium chloride"
          },
          {
            "code" : "B06AA55",
            "display" : "streptokinase, combinations"
          },
          {
            "code" : "C01AA05",
            "display" : "digoxin"
          },
          {
            "code" : "C01BB01",
            "display" : "lidocaine"
          },
          {
            "code" : "C01BB02",
            "display" : "mexiletine"
          },
          {
            "code" : "C01BD",
            "display" : "Antiarrhythmics, class III"
          },
          {
            "code" : "C01CX08",
            "display" : "levosimendan"
          },
          {
            "code" : "C01DA02",
            "display" : "glyceryl trinitrate"
          },
          {
            "code" : "C01DX16",
            "display" : "nicorandil"
          },
          {
            "code" : "C01EB16",
            "display" : "ibuprofen"
          },
          {
            "code" : "C02KX02",
            "display" : "ambrisentan"
          },
          {
            "code" : "C02KX04",
            "display" : "macitentan"
          },
          {
            "code" : "C02LC01",
            "display" : "clonidine and diuretics"
          },
          {
            "code" : "C02LG51",
            "display" : "dihydralazine and diuretics, combinations with other drugs"
          },
          {
            "code" : "C03AA",
            "display" : "Thiazides, plain"
          },
          {
            "code" : "C03BA02",
            "display" : "quinethazone"
          },
          {
            "code" : "C03CB02",
            "display" : "bumetanide and potassium"
          },
          {
            "code" : "C03DB02",
            "display" : "triamterene"
          },
          {
            "code" : "C04AE54",
            "display" : "dihydroergocristine, combinations"
          },
          {
            "code" : "C04AX10",
            "display" : "moxisylyte"
          },
          {
            "code" : "C05AD",
            "display" : "Local anesthetics"
          },
          {
            "code" : "C05BA01",
            "display" : "organo-heparinoid"
          },
          {
            "code" : "C05BA03",
            "display" : "heparin"
          },
          {
            "code" : "C05CA53",
            "display" : "diosmin, combinations"
          },
          {
            "code" : "C07AA05",
            "display" : "propranolol"
          },
          {
            "code" : "C07CB03",
            "display" : "atenolol and other diuretics"
          },
          {
            "code" : "C07CB53",
            "display" : "atenolol and other diuretics, combinations"
          },
          {
            "code" : "C07DB01",
            "display" : "atenolol, thiazides and other diuretics"
          },
          {
            "code" : "C07FB13",
            "display" : "metoprolol and amlodipine"
          },
          {
            "code" : "C08CA08",
            "display" : "nitrendipine"
          },
          {
            "code" : "C08GA01",
            "display" : "nifedipine and diuretics"
          },
          {
            "code" : "C09AA07",
            "display" : "benazepril"
          },
          {
            "code" : "C09BX01",
            "display" : "perindopril, amlodipine and indapamide"
          },
          {
            "code" : "C09CA07",
            "display" : "telmisartan"
          },
          {
            "code" : "C09CA09",
            "display" : "azilsartan medoxomil"
          },
          {
            "code" : "C09DA08",
            "display" : "olmesartan medoxomil and diuretics"
          },
          {
            "code" : "C09DB07",
            "display" : "candesartan and amlodipine"
          },
          {
            "code" : "A01AA51",
            "display" : "sodium fluoride, combinations"
          },
          {
            "code" : "A01AB06",
            "display" : "domiphen"
          },
          {
            "code" : "A02AA",
            "display" : "Magnesium compounds"
          },
          {
            "code" : "A02AA02",
            "display" : "magnesium oxide"
          },
          {
            "code" : "A02AB10",
            "display" : "combinations"
          },
          {
            "code" : "A02AC01",
            "display" : "calcium carbonate"
          },
          {
            "code" : "A02BA03",
            "display" : "famotidine"
          },
          {
            "code" : "A02BA53",
            "display" : "famotidine, combinations"
          },
          {
            "code" : "A02BB01",
            "display" : "misoprostol"
          },
          {
            "code" : "A02BC03",
            "display" : "lansoprazole"
          },
          {
            "code" : "A02BC05",
            "display" : "esomeprazole"
          },
          {
            "code" : "A02BD06",
            "display" : "esomeprazole, amoxicillin and clarithromycin"
          },
          {
            "code" : "A02BD08",
            "display" : "bismuth subcitrate, tetracycline and metronidazole"
          },
          {
            "code" : "A02BD12",
            "display" : "rabeprazole, amoxicillin and clarithromycin"
          },
          {
            "code" : "A02BX06",
            "display" : "proglumide"
          },
          {
            "code" : "A03AA05",
            "display" : "trimebutine"
          },
          {
            "code" : "A03AB02",
            "display" : "glycopyrronium bromide"
          },
          {
            "code" : "A03AB12",
            "display" : "mepenzolate"
          },
          {
            "code" : "A03BA",
            "display" : "Belladonna alkaloids, tertiary amines"
          },
          {
            "code" : "A03BA01",
            "display" : "atropine"
          },
          {
            "code" : "A03BB",
            "display" : "Belladonna alkaloids, semisynthetic, quaternary ammonium compounds"
          },
          {
            "code" : "A03BB01",
            "display" : "butylscopolamine"
          },
          {
            "code" : "A03C",
            "display" : "ANTISPASMODICS IN COMBINATION WITH PSYCHOLEPTICS"
          },
          {
            "code" : "A04AA05",
            "display" : "palonosetron"
          },
          {
            "code" : "A04AD",
            "display" : "Other antiemetics"
          },
          {
            "code" : "A05AA",
            "display" : "Bile acids and derivatives"
          },
          {
            "code" : "A05AX03",
            "display" : "cyclobutyrol"
          },
          {
            "code" : "A05BA",
            "display" : "Liver therapy"
          },
          {
            "code" : "A05BA08",
            "display" : "glycyrrhizic acid"
          },
          {
            "code" : "A06AB06",
            "display" : "senna glycosides"
          },
          {
            "code" : "A06AC01",
            "display" : "ispaghula (psylla seeds)"
          },
          {
            "code" : "A06AD01",
            "display" : "magnesium carbonate"
          },
          {
            "code" : "A06AD12",
            "display" : "lactitol"
          },
          {
            "code" : "A06AD18",
            "display" : "sorbitol"
          },
          {
            "code" : "A06AG02",
            "display" : "bisacodyl"
          },
          {
            "code" : "A07AA10",
            "display" : "colistin"
          },
          {
            "code" : "A07AX",
            "display" : "Other intestinal antiinfectives"
          },
          {
            "code" : "A07BA",
            "display" : "Charcoal preparations"
          },
          {
            "code" : "A07BC02",
            "display" : "kaolin"
          },
          {
            "code" : "A07XA01",
            "display" : "albumin tannate"
          },
          {
            "code" : "A07XA04",
            "display" : "racecadotril"
          },
          {
            "code" : "A10AB06",
            "display" : "insulin glulisine"
          },
          {
            "code" : "A10AD04",
            "display" : "insulin lispro"
          },
          {
            "code" : "A10AD30",
            "display" : "combinations"
          },
          {
            "code" : "A10BB02",
            "display" : "chlorpropamide"
          },
          {
            "code" : "A10BB07",
            "display" : "glipizide"
          },
          {
            "code" : "A10BD05",
            "display" : "metformin and pioglitazone"
          },
          {
            "code" : "A10BD06",
            "display" : "glimepiride and pioglitazone"
          },
          {
            "code" : "A10BD12",
            "display" : "pioglitazone and sitagliptin"
          },
          {
            "code" : "A10BD14",
            "display" : "metformin and repaglinide"
          },
          {
            "code" : "A10BJ05",
            "display" : "dulaglutide"
          },
          {
            "code" : "A11AA03",
            "display" : "multivitamins and other minerals, incl. combinations"
          },
          {
            "code" : "A11CB",
            "display" : "Vitamin A and D in combination"
          },
          {
            "code" : "A12AA03",
            "display" : "calcium gluconate"
          },
          {
            "code" : "A12CA",
            "display" : "Sodium"
          },
          {
            "code" : "A12CC",
            "display" : "Magnesium"
          },
          {
            "code" : "A12CC10",
            "display" : "magnesium oxide"
          },
          {
            "code" : "A12CX",
            "display" : "Other mineral products"
          },
          {
            "code" : "A14AA03",
            "display" : "metandienone"
          },
          {
            "code" : "A16AA01",
            "display" : "levocarnitine"
          },
          {
            "code" : "A16AB05",
            "display" : "laronidase"
          },
          {
            "code" : "A16AX01",
            "display" : "thioctic acid"
          },
          {
            "code" : "A16AX12",
            "display" : "trientine"
          },
          {
            "code" : "B01AA03",
            "display" : "warfarin"
          },
          {
            "code" : "B01AB",
            "display" : "Heparin group"
          },
          {
            "code" : "B01AB01",
            "display" : "heparin"
          },
          {
            "code" : "B01AC07",
            "display" : "dipyridamole"
          },
          {
            "code" : "B01AF01",
            "display" : "rivaroxaban"
          },
          {
            "code" : "B02BD",
            "display" : "Blood coagulation factors"
          },
          {
            "code" : "B02BD03",
            "display" : "factor VIII inhibitor bypassing activity"
          },
          {
            "code" : "B03AB01",
            "display" : "ferric sodium citrate"
          },
          {
            "code" : "B03AD03",
            "display" : "ferrous sulfate"
          },
          {
            "code" : "B03BA51",
            "display" : "cyanocobalamin, combinations"
          },
          {
            "code" : "B03BA53",
            "display" : "hydroxocobalamin, combinations"
          },
          {
            "code" : "B03XA",
            "display" : "Other antianemic preparations"
          },
          {
            "code" : "B05BA03",
            "display" : "carbohydrates"
          },
          {
            "code" : "B05BB02",
            "display" : "electrolytes with carbohydrates"
          },
          {
            "code" : "B05CB03",
            "display" : "magnesium citrate"
          },
          {
            "code" : "B05CB04",
            "display" : "sodium bicarbonate"
          },
          {
            "code" : "B05CX01",
            "display" : "glucose"
          },
          {
            "code" : "B05DB",
            "display" : "Hypertonic solutions"
          },
          {
            "code" : "B05XA07",
            "display" : "calcium chloride"
          },
          {
            "code" : "B05XA30",
            "display" : "combinations of electrolytes"
          },
          {
            "code" : "B05XB",
            "display" : "Amino acids"
          },
          {
            "code" : "B06AA",
            "display" : "Enzymes"
          },
          {
            "code" : "B06AC02",
            "display" : "icatibant"
          },
          {
            "code" : "C01BA03",
            "display" : "disopyramide"
          },
          {
            "code" : "C01CA06",
            "display" : "phenylephrine"
          },
          {
            "code" : "C01CA07",
            "display" : "dobutamine"
          },
          {
            "code" : "C01CA26",
            "display" : "ephedrine"
          },
          {
            "code" : "C01DX22",
            "display" : "vericiguat"
          },
          {
            "code" : "C01EB18",
            "display" : "ranolazine"
          },
          {
            "code" : "C02AC01",
            "display" : "clonidine"
          },
          {
            "code" : "C02DB02",
            "display" : "hydralazine"
          },
          {
            "code" : "C02DD01",
            "display" : "nitroprusside"
          },
          {
            "code" : "C02KX52",
            "display" : "ambrisentan and tadalafil"
          },
          {
            "code" : "C03AA05",
            "display" : "polythiazide"
          },
          {
            "code" : "C03AA06",
            "display" : "trichlormethiazide"
          },
          {
            "code" : "C03BA05",
            "display" : "mefruside"
          },
          {
            "code" : "C03CA02",
            "display" : "bumetanide"
          },
          {
            "code" : "C03CA04",
            "display" : "torasemide"
          },
          {
            "code" : "C04AC03",
            "display" : "inositol nicotinate"
          },
          {
            "code" : "C04AE02",
            "display" : "nicergoline"
          },
          {
            "code" : "C05AA01",
            "display" : "hydrocortisone"
          },
          {
            "code" : "C05AD05",
            "display" : "procaine"
          },
          {
            "code" : "C05BA",
            "display" : "Heparins or heparinoids for topical use"
          },
          {
            "code" : "C05CA03",
            "display" : "diosmin"
          },
          {
            "code" : "C05CX03",
            "display" : "Hippocastani semen"
          },
          {
            "code" : "C07AA06",
            "display" : "timolol"
          },
          {
            "code" : "A01AA",
            "display" : "Caries prophylactic agents"
          },
          {
            "code" : "A01AB13",
            "display" : "tetracycline"
          },
          {
            "code" : "A01AB21",
            "display" : "chlortetracycline"
          },
          {
            "code" : "A01AB23",
            "display" : "minocycline"
          },
          {
            "code" : "A01AC",
            "display" : "Corticosteroids for local oral treatment"
          },
          {
            "code" : "A01AC03",
            "display" : "hydrocortisone"
          },
          {
            "code" : "A01AD01",
            "display" : "epinephrine"
          },
          {
            "code" : "A01AD05",
            "display" : "acetylsalicylic acid"
          },
          {
            "code" : "A02AA03",
            "display" : "magnesium peroxide"
          },
          {
            "code" : "A02AB02",
            "display" : "algeldrate"
          },
          {
            "code" : "A02AD05",
            "display" : "almasilate"
          },
          {
            "code" : "A02BA51",
            "display" : "cimetidine, combinations"
          },
          {
            "code" : "A02BD04",
            "display" : "pantoprazole, amoxicillin and clarithromycin"
          },
          {
            "code" : "A02BD14",
            "display" : "vonoprazan, amoxicillin and clarithromycin"
          },
          {
            "code" : "A03AA01",
            "display" : "oxyphencyclimine"
          },
          {
            "code" : "A03AA03",
            "display" : "camylofin"
          },
          {
            "code" : "A03AA04",
            "display" : "mebeverine"
          },
          {
            "code" : "A03AB18",
            "display" : "prifinium bromide"
          },
          {
            "code" : "A03B",
            "display" : "BELLADONNA AND DERIVATIVES, PLAIN"
          },
          {
            "code" : "A03CA02",
            "display" : "clidinium and psycholeptics"
          },
          {
            "code" : "A03CB02",
            "display" : "belladonna total alkaloids and psycholeptics"
          },
          {
            "code" : "A03CB04",
            "display" : "homatropine methylbromide and psycholeptics"
          },
          {
            "code" : "A03ED",
            "display" : "Antispasmodics in combination with other drugs"
          },
          {
            "code" : "A03FA",
            "display" : "Propulsives"
          },
          {
            "code" : "A03FA01",
            "display" : "metoclopramide"
          },
          {
            "code" : "A03FA03",
            "display" : "domperidone"
          },
          {
            "code" : "A05",
            "display" : "BILE AND LIVER THERAPY"
          },
          {
            "code" : "A05AA02",
            "display" : "ursodeoxycholic acid"
          },
          {
            "code" : "A06AB08",
            "display" : "sodium picosulfate"
          },
          {
            "code" : "A06AB30",
            "display" : "contact laxatives in combination with belladonna alkaloids"
          },
          {
            "code" : "A06AB56",
            "display" : "senna glycosides, combinations"
          },
          {
            "code" : "A06AC03",
            "display" : "sterculia"
          },
          {
            "code" : "A06AD04",
            "display" : "magnesium sulfate"
          },
          {
            "code" : "A06AD11",
            "display" : "lactulose"
          },
          {
            "code" : "A06AD15",
            "display" : "macrogol"
          },
          {
            "code" : "A06AD16",
            "display" : "mannitol"
          },
          {
            "code" : "A06AH05",
            "display" : "naldemedine"
          },
          {
            "code" : "A06AX",
            "display" : "Other drugs for constipation"
          },
          {
            "code" : "A07AA01",
            "display" : "neomycin"
          },
          {
            "code" : "A07AA51",
            "display" : "neomycin, combinations"
          },
          {
            "code" : "A07BC05",
            "display" : "diosmectite"
          },
          {
            "code" : "A07DA03",
            "display" : "loperamide"
          },
          {
            "code" : "A07EB01",
            "display" : "cromoglicic acid"
          },
          {
            "code" : "A08AA10",
            "display" : "sibutramine"
          },
          {
            "code" : "A09AC02",
            "display" : "multienzymes and acid preparations"
          },
          {
            "code" : "A10AC03",
            "display" : "insulin (pork)"
          },
          {
            "code" : "A10AE04",
            "display" : "insulin glargine"
          },
          {
            "code" : "A10BB01",
            "display" : "glibenclamide"
          },
          {
            "code" : "A10BD07",
            "display" : "metformin and sitagliptin"
          },
          {
            "code" : "A10BD22",
            "display" : "metformin and evogliptin"
          },
          {
            "code" : "A10BH02",
            "display" : "vildagliptin"
          },
          {
            "code" : "A10BH05",
            "display" : "linagliptin"
          },
          {
            "code" : "A10BJ01",
            "display" : "exenatide"
          },
          {
            "code" : "A10BX01",
            "display" : "guar gum"
          },
          {
            "code" : "A10BX02",
            "display" : "repaglinide"
          },
          {
            "code" : "A11AB",
            "display" : "Multivitamins, other combinations"
          },
          {
            "code" : "A11C",
            "display" : "VITAMIN A AND D, INCL. COMBINATIONS OF THE TWO"
          },
          {
            "code" : "A11CA02",
            "display" : "betacarotene"
          },
          {
            "code" : "A11EB",
            "display" : "Vitamin B-complex with vitamin C"
          },
          {
            "code" : "A11HA01",
            "display" : "nicotinamide"
          },
          {
            "code" : "A11HA03",
            "display" : "tocopherol (vit E)"
          },
          {
            "code" : "A11HA32",
            "display" : "pantethine"
          },
          {
            "code" : "A12AA",
            "display" : "Calcium"
          },
          {
            "code" : "A12AA01",
            "display" : "calcium phosphate"
          },
          {
            "code" : "A12CE02",
            "display" : "sodium selenite"
          },
          {
            "code" : "A14AB01",
            "display" : "nandrolone"
          },
          {
            "code" : "A16AA05",
            "display" : "carglumic acid"
          },
          {
            "code" : "A16AA06",
            "display" : "betaine"
          },
          {
            "code" : "A16AX03",
            "display" : "sodium phenylbutyrate"
          },
          {
            "code" : "A16AX07",
            "display" : "sapropterin"
          },
          {
            "code" : "B01AA02",
            "display" : "phenindione"
          },
          {
            "code" : "B01AB05",
            "display" : "enoxaparin"
          },
          {
            "code" : "B01AB06",
            "display" : "nadroparin"
          },
          {
            "code" : "B01AC04",
            "display" : "clopidogrel"
          },
          {
            "code" : "B01AC06",
            "display" : "acetylsalicylic acid"
          },
          {
            "code" : "B01AC13",
            "display" : "abciximab"
          },
          {
            "code" : "B01AD11",
            "display" : "tenecteplase"
          },
          {
            "code" : "B01AF02",
            "display" : "apixaban"
          },
          {
            "code" : "B02AA01",
            "display" : "aminocaproic acid"
          },
          {
            "code" : "B02BD05",
            "display" : "coagulation factor VII"
          },
          {
            "code" : "B02BX02",
            "display" : "carbazochrome"
          },
          {
            "code" : "B03A",
            "display" : "IRON PREPARATIONS"
          },
          {
            "code" : "B03BA01",
            "display" : "cyanocobalamin"
          },
          {
            "code" : "B03BA03",
            "display" : "hydroxocobalamin"
          },
          {
            "code" : "B03XA01",
            "display" : "erythropoietin"
          },
          {
            "code" : "B05AA05",
            "display" : "dextran"
          },
          {
            "code" : "B05AA06",
            "display" : "gelatin agents"
          },
          {
            "code" : "B05AA07",
            "display" : "hydroxyethylstarch"
          },
          {
            "code" : "B05BC",
            "display" : "Solutions producing osmotic diuresis"
          },
          {
            "code" : "B05CA01",
            "display" : "cetylpyridinium"
          },
          {
            "code" : "B05CA02",
            "display" : "chlorhexidine"
          },
          {
            "code" : "B05CA08",
            "display" : "ethacridine lactate"
          },
          {
            "code" : "B05XA05",
            "display" : "magnesium sulfate"
          },
          {
            "code" : "B05XX",
            "display" : "Other i.v. solution additives"
          },
          {
            "code" : "B05ZA",
            "display" : "Hemodialytics, concentrates"
          },
          {
            "code" : "B06AA07",
            "display" : "trypsin"
          },
          {
            "code" : "C01AC01",
            "display" : "g-strophanthin"
          },
          {
            "code" : "C01CA03",
            "display" : "norepinephrine"
          },
          {
            "code" : "C01CA04",
            "display" : "dopamine"
          },
          {
            "code" : "C01CA30",
            "display" : "combinations"
          },
          {
            "code" : "C01DA14",
            "display" : "isosorbide mononitrate"
          },
          {
            "code" : "C01EB09",
            "display" : "ubidecarenone"
          },
          {
            "code" : "C02AA01",
            "display" : "rescinnamine"
          },
          {
            "code" : "C02AA02",
            "display" : "reserpine"
          },
          {
            "code" : "C02CA",
            "display" : "Alpha-adrenoreceptor antagonists"
          },
          {
            "code" : "C02DC01",
            "display" : "minoxidil"
          },
          {
            "code" : "C03BA03",
            "display" : "clopamide"
          },
          {
            "code" : "C03BA04",
            "display" : "chlortalidone"
          },
          {
            "code" : "C03CC01",
            "display" : "etacrynic acid"
          },
          {
            "code" : "A01AB04",
            "display" : "amphotericin B"
          },
          {
            "code" : "A01AB12",
            "display" : "hexetidine"
          },
          {
            "code" : "A01AB17",
            "display" : "metronidazole"
          },
          {
            "code" : "A01AD02",
            "display" : "benzydamine"
          },
          {
            "code" : "A02AB04",
            "display" : "dihydroxialumini sodium carbonate"
          },
          {
            "code" : "A02AD04",
            "display" : "hydrotalcite"
          },
          {
            "code" : "A02BD11",
            "display" : "pantoprazole, amoxicillin, clarithromycin and metronidazole"
          },
          {
            "code" : "A02BD15",
            "display" : "vonoprazan, amoxicillin and metronidazole"
          },
          {
            "code" : "A03AA07",
            "display" : "dicycloverine"
          },
          {
            "code" : "A03AX13",
            "display" : "silicones"
          },
          {
            "code" : "A03AX14",
            "display" : "valethamate"
          },
          {
            "code" : "A03BA03",
            "display" : "hyoscyamine"
          },
          {
            "code" : "A03BB03",
            "display" : "methylscopolamine"
          },
          {
            "code" : "A03CB03",
            "display" : "atropine and psycholeptics"
          },
          {
            "code" : "A03DA06",
            "display" : "trospium and analgesics"
          },
          {
            "code" : "A03EA",
            "display" : "Antispasmodics, psycholeptics and analgesics in combination"
          },
          {
            "code" : "A04AA01",
            "display" : "ondansetron"
          },
          {
            "code" : "A06AA02",
            "display" : "docusate sodium"
          },
          {
            "code" : "A06AG04",
            "display" : "glycerol"
          },
          {
            "code" : "A07",
            "display" : "ANTIDIARRHEALS, INTESTINAL ANTIINFLAMMATORY/ANTIINFECTIVE AGENTS"
          },
          {
            "code" : "A07AA05",
            "display" : "polymyxin B"
          },
          {
            "code" : "A07AA12",
            "display" : "fidaxomicin"
          },
          {
            "code" : "A07AX03",
            "display" : "nifuroxazide"
          },
          {
            "code" : "A07FA01",
            "display" : "lactic acid producing organisms"
          },
          {
            "code" : "A07XA",
            "display" : "Other antidiarrheals"
          },
          {
            "code" : "A09AA",
            "display" : "Enzyme preparations"
          },
          {
            "code" : "A09AA03",
            "display" : "pepsin"
          },
          {
            "code" : "A09AA04",
            "display" : "tilactase"
          },
          {
            "code" : "A10AD05",
            "display" : "insulin aspart"
          },
          {
            "code" : "A10BA02",
            "display" : "metformin"
          },
          {
            "code" : "A10BB04",
            "display" : "glibornuride"
          },
          {
            "code" : "A10BB05",
            "display" : "tolazamide"
          },
          {
            "code" : "A10BD09",
            "display" : "pioglitazone and alogliptin"
          },
          {
            "code" : "A10BD10",
            "display" : "metformin and saxagliptin"
          },
          {
            "code" : "A10BD13",
            "display" : "metformin and alogliptin"
          },
          {
            "code" : "A10BD16",
            "display" : "metformin and canagliflozin"
          },
          {
            "code" : "A10BD17",
            "display" : "metformin and acarbose"
          },
          {
            "code" : "A10BD21",
            "display" : "saxagliptin and dapagliflozin"
          },
          {
            "code" : "A10BD26",
            "display" : "metformin and lobeglitazone"
          },
          {
            "code" : "A10BF01",
            "display" : "acarbose"
          },
          {
            "code" : "A10BH01",
            "display" : "sitagliptin"
          },
          {
            "code" : "A10BH03",
            "display" : "saxagliptin"
          },
          {
            "code" : "A10BH51",
            "display" : "sitagliptin and simvastatin"
          },
          {
            "code" : "A10BH52",
            "display" : "gemigliptin and rosuvastatin"
          },
          {
            "code" : "A10BJ02",
            "display" : "liraglutide"
          },
          {
            "code" : "A11CC04",
            "display" : "calcitriol"
          },
          {
            "code" : "A11CC20",
            "display" : "combinations"
          },
          {
            "code" : "A11EA",
            "display" : "Vitamin B-complex, plain"
          },
          {
            "code" : "A11GB",
            "display" : "Ascorbic acid (vitamin C), combinations"
          },
          {
            "code" : "A11HA02",
            "display" : "pyridoxine (vit B6)"
          },
          {
            "code" : "A11HA05",
            "display" : "biotin"
          },
          {
            "code" : "A12AA04",
            "display" : "calcium carbonate"
          },
          {
            "code" : "A12AA05",
            "display" : "calcium lactate"
          },
          {
            "code" : "A12BA01",
            "display" : "potassium chloride"
          },
          {
            "code" : "A12BA05",
            "display" : "potassium gluconate"
          },
          {
            "code" : "A12CB01",
            "display" : "zinc sulfate"
          },
          {
            "code" : "A16AX",
            "display" : "Various alimentary tract and metabolism products"
          },
          {
            "code" : "A16AX10",
            "display" : "eliglustat"
          },
          {
            "code" : "B01AC",
            "display" : "Platelet aggregation inhibitors excl. heparin"
          },
          {
            "code" : "B01AC11",
            "display" : "iloprost"
          },
          {
            "code" : "B01AC24",
            "display" : "ticagrelor"
          },
          {
            "code" : "B01AC30",
            "display" : "combinations"
          },
          {
            "code" : "B01AX05",
            "display" : "fondaparinux"
          },
          {
            "code" : "B02BA",
            "display" : "Vitamin K"
          },
          {
            "code" : "B02BC06",
            "display" : "thrombin"
          },
          {
            "code" : "B03AB",
            "display" : "Iron trivalent, oral preparations"
          },
          {
            "code" : "B03AB04",
            "display" : "ferric hydroxide"
          },
          {
            "code" : "B03AB05",
            "display" : "ferric oxide polymaltose complexes"
          },
          {
            "code" : "B03AD02",
            "display" : "ferrous fumarate"
          },
          {
            "code" : "B03AE04",
            "display" : "iron, multivitamins and minerals"
          },
          {
            "code" : "B03XA02",
            "display" : "darbepoetin alfa"
          },
          {
            "code" : "B05BC02",
            "display" : "carbamide"
          },
          {
            "code" : "B05CA09",
            "display" : "neomycin"
          },
          {
            "code" : "B05CB10",
            "display" : "combinations"
          },
          {
            "code" : "B05XA",
            "display" : "Electrolyte solutions"
          },
          {
            "code" : "B05XA03",
            "display" : "sodium chloride"
          },
          {
            "code" : "B05XB02",
            "display" : "alanyl glutamine"
          },
          {
            "code" : "B05XC",
            "display" : "Vitamins"
          },
          {
            "code" : "B06AA04",
            "display" : "chymotrypsin"
          },
          {
            "code" : "B06AC05",
            "display" : "lanadelumab"
          },
          {
            "code" : "C01AA08",
            "display" : "metildigoxin"
          },
          {
            "code" : "C01CA",
            "display" : "Adrenergic and dopaminergic agents"
          },
          {
            "code" : "C01CA02",
            "display" : "isoprenaline"
          },
          {
            "code" : "C01CA25",
            "display" : "amezinium metilsulfate"
          },
          {
            "code" : "C02AB02",
            "display" : "methyldopa (racemic)"
          },
          {
            "code" : "C02CA01",
            "display" : "prazosin"
          },
          {
            "code" : "C03AA01",
            "display" : "bendroflumethiazide"
          },
          {
            "code" : "C03AA03",
            "display" : "hydrochlorothiazide"
          },
          {
            "code" : "C03AX01",
            "display" : "hydrochlorothiazide, combinations"
          },
          {
            "code" : "C04AA01",
            "display" : "isoxsuprine"
          },
          {
            "code" : "C04AF01",
            "display" : "kallidinogenase"
          },
          {
            "code" : "C04AX",
            "display" : "Other peripheral vasodilators"
          },
          {
            "code" : "C05AB",
            "display" : "Antibiotics"
          },
          {
            "code" : "C05AD01",
            "display" : "lidocaine"
          },
          {
            "code" : "C05AX05",
            "display" : "tribenoside"
          },
          {
            "code" : "C05BB04",
            "display" : "sodium tetradecyl sulfate"
          },
          {
            "code" : "C05BB56",
            "display" : "glucose, combinations"
          },
          {
            "code" : "C07AA07",
            "display" : "sotalol"
          },
          {
            "code" : "C07BB03",
            "display" : "atenolol and thiazides"
          },
          {
            "code" : "C07FB02",
            "display" : "metoprolol and felodipine"
          },
          {
            "code" : "C07FB07",
            "display" : "bisoprolol and amlodipine"
          },
          {
            "code" : "C08CA03",
            "display" : "isradipine"
          },
          {
            "code" : "C08CA04",
            "display" : "nicardipine"
          },
          {
            "code" : "C08CA13",
            "display" : "lercanidipine"
          },
          {
            "code" : "C09AA04",
            "display" : "perindopril"
          },
          {
            "code" : "C09AA05",
            "display" : "ramipril"
          },
          {
            "code" : "C04AX20",
            "display" : "buflomedil"
          },
          {
            "code" : "C05AA04",
            "display" : "prednisolone"
          },
          {
            "code" : "C05AD07",
            "display" : "pramocaine"
          },
          {
            "code" : "C05AE03",
            "display" : "diltiazem"
          },
          {
            "code" : "C05AX04",
            "display" : "zinc preparations"
          },
          {
            "code" : "C05BA53",
            "display" : "heparin, combinations"
          },
          {
            "code" : "C05BB02",
            "display" : "polidocanol"
          },
          {
            "code" : "C05BB05",
            "display" : "phenol"
          },
          {
            "code" : "C07FB03",
            "display" : "atenolol and nifedipine"
          },
          {
            "code" : "C07FX02",
            "display" : "sotalol and acetylsalicylic acid"
          },
          {
            "code" : "C07FX04",
            "display" : "bisoprolol and acetylsalicylic acid"
          },
          {
            "code" : "C08CA07",
            "display" : "nisoldipine"
          },
          {
            "code" : "C08DA01",
            "display" : "verapamil"
          },
          {
            "code" : "C09CA02",
            "display" : "eprosartan"
          },
          {
            "code" : "C09CA03",
            "display" : "valsartan"
          },
          {
            "code" : "C09DB01",
            "display" : "valsartan and amlodipine"
          },
          {
            "code" : "C09DB04",
            "display" : "telmisartan and amlodipine"
          },
          {
            "code" : "C09DX03",
            "display" : "olmesartan medoxomil, amlodipine and hydrochlorothiazide"
          },
          {
            "code" : "C10AB04",
            "display" : "gemfibrozil"
          },
          {
            "code" : "C10AC01",
            "display" : "colestyramine"
          },
          {
            "code" : "C10AD02",
            "display" : "nicotinic acid"
          },
          {
            "code" : "C10AD52",
            "display" : "nicotinic acid, combinations"
          },
          {
            "code" : "C10AX",
            "display" : "Other lipid modifying agents"
          },
          {
            "code" : "C10BA03",
            "display" : "pravastatin and fenofibrate"
          },
          {
            "code" : "C10BX06",
            "display" : "atorvastatin, acetylsalicylic acid and ramipril"
          },
          {
            "code" : "C10BX13",
            "display" : "rosuvastatin, perindopril and indapamide"
          },
          {
            "code" : "C10BX14",
            "display" : "rosuvastatin, amlodipine and perindopril"
          },
          {
            "code" : "D01AC11",
            "display" : "oxiconazole"
          },
          {
            "code" : "D01AC20",
            "display" : "imidazoles/triazoles in combination with corticosteroids"
          },
          {
            "code" : "D01AE12",
            "display" : "salicylic acid"
          },
          {
            "code" : "D01AE22",
            "display" : "naftifine"
          },
          {
            "code" : "D01BA01",
            "display" : "griseofulvin"
          },
          {
            "code" : "D03AX06",
            "display" : "becaplermin"
          },
          {
            "code" : "D03AX14",
            "display" : "Centella asiatica herba"
          },
          {
            "code" : "D04A",
            "display" : "ANTIPRURITICS, INCL. ANTIHISTAMINES, ANESTHETICS, ETC."
          },
          {
            "code" : "D05AX03",
            "display" : "calcitriol"
          },
          {
            "code" : "D06AA",
            "display" : "Tetracycline and derivatives"
          },
          {
            "code" : "D06AA03",
            "display" : "oxytetracycline"
          },
          {
            "code" : "D06AX01",
            "display" : "fusidic acid"
          },
          {
            "code" : "D06AX04",
            "display" : "neomycin"
          },
          {
            "code" : "D06BA51",
            "display" : "silver sulfadiazine, combinations"
          },
          {
            "code" : "D07AA01",
            "display" : "methylprednisolone"
          },
          {
            "code" : "D07AB11",
            "display" : "hydrocortisone buteprate"
          },
          {
            "code" : "D07AB19",
            "display" : "dexamethasone"
          },
          {
            "code" : "D07AC09",
            "display" : "budesonide"
          },
          {
            "code" : "D07AC17",
            "display" : "fluticasone"
          },
          {
            "code" : "D07BC02",
            "display" : "fluocinolone acetonide and antiseptics"
          },
          {
            "code" : "D07CB01",
            "display" : "triamcinolone and antibiotics"
          },
          {
            "code" : "D07CC",
            "display" : "Corticosteroids, potent, combinations with antibiotics"
          },
          {
            "code" : "D07CC05",
            "display" : "fluocinonide and antibiotics"
          },
          {
            "code" : "D07XA",
            "display" : "Corticosteroids, weak, other combinations"
          },
          {
            "code" : "D07XC01",
            "display" : "betamethasone"
          },
          {
            "code" : "D08AC02",
            "display" : "chlorhexidine"
          },
          {
            "code" : "D08AE01",
            "display" : "hexachlorophene"
          },
          {
            "code" : "D08AJ",
            "display" : "Quaternary ammonium compounds"
          },
          {
            "code" : "D08AJ01",
            "display" : "benzalkonium"
          },
          {
            "code" : "D09AA01",
            "display" : "framycetin"
          },
          {
            "code" : "D10AB",
            "display" : "Preparations containing sulfur"
          },
          {
            "code" : "D10AD01",
            "display" : "tretinoin"
          },
          {
            "code" : "D10AD03",
            "display" : "adapalene"
          },
          {
            "code" : "D10AD53",
            "display" : "adapalene, combinations"
          },
          {
            "code" : "D10AF",
            "display" : "Antiinfectives for treatment of acne"
          },
          {
            "code" : "D11A",
            "display" : "OTHER DERMATOLOGICAL PREPARATIONS"
          },
          {
            "code" : "D11AA",
            "display" : "Antihidrotics"
          },
          {
            "code" : "D11AF",
            "display" : "Wart and anti-corn preparations"
          },
          {
            "code" : "G01AF12",
            "display" : "fenticonazole"
          },
          {
            "code" : "G01AF19",
            "display" : "sertaconazole"
          },
          {
            "code" : "G01AX05",
            "display" : "nifuratel"
          },
          {
            "code" : "G02AB01",
            "display" : "methylergometrine"
          },
          {
            "code" : "G02AD04",
            "display" : "carboprost"
          },
          {
            "code" : "G02CB01",
            "display" : "bromocriptine"
          },
          {
            "code" : "G02CC03",
            "display" : "benzydamine"
          },
          {
            "code" : "G03AA",
            "display" : "Progestogens and estrogens, fixed combinations"
          },
          {
            "code" : "G03AA09",
            "display" : "desogestrel and ethinylestradiol"
          },
          {
            "code" : "G03AA10",
            "display" : "gestodene and ethinylestradiol"
          },
          {
            "code" : "G03AB09",
            "display" : "norgestimate and ethinylestradiol"
          },
          {
            "code" : "G03AD01",
            "display" : "levonorgestrel"
          },
          {
            "code" : "G03B",
            "display" : "ANDROGENS"
          },
          {
            "code" : "G03DC01",
            "display" : "allylestrenol"
          },
          {
            "code" : "G03DC03",
            "display" : "lynestrenol"
          },
          {
            "code" : "G03FA17",
            "display" : "drospirenone and estrogen"
          },
          {
            "code" : "G03XA01",
            "display" : "danazol"
          },
          {
            "code" : "G03XB01",
            "display" : "mifepristone"
          },
          {
            "code" : "G04CA52",
            "display" : "tamsulosin and dutasteride"
          },
          {
            "code" : "H02AB05",
            "display" : "paramethasone"
          },
          {
            "code" : "H05BX02",
            "display" : "paricalcitol"
          },
          {
            "code" : "H05BX04",
            "display" : "etelcalcetide"
          },
          {
            "code" : "J01AA02",
            "display" : "doxycycline"
          },
          {
            "code" : "J01CA02",
            "display" : "pivampicillin"
          },
          {
            "code" : "J01CA05",
            "display" : "carindacillin"
          },
          {
            "code" : "J01CF02",
            "display" : "cloxacillin"
          },
          {
            "code" : "J01DB03",
            "display" : "cefalotin"
          },
          {
            "code" : "J01DB08",
            "display" : "cefapirin"
          },
          {
            "code" : "J01DC02",
            "display" : "cefuroxime"
          },
          {
            "code" : "J01DC10",
            "display" : "cefprozil"
          },
          {
            "code" : "J01DD01",
            "display" : "cefotaxime"
          },
          {
            "code" : "J01DD05",
            "display" : "cefmenoxime"
          },
          {
            "code" : "J01DD06",
            "display" : "latamoxef"
          },
          {
            "code" : "J01DD08",
            "display" : "cefixime"
          },
          {
            "code" : "J01DD62",
            "display" : "cefoperazone and beta-lactamase inhibitor"
          },
          {
            "code" : "J01DI54",
            "display" : "ceftolozane and beta-lactamase inhibitor"
          },
          {
            "code" : "J01EB02",
            "display" : "sulfamethizole"
          },
          {
            "code" : "J01ED05",
            "display" : "sulfamethoxypyridazine"
          },
          {
            "code" : "A01AB",
            "display" : "Antiinfectives and antiseptics for local oral treatment"
          },
          {
            "code" : "A01AB03",
            "display" : "chlorhexidine"
          },
          {
            "code" : "A01AB18",
            "display" : "clotrimazole"
          },
          {
            "code" : "A01AC01",
            "display" : "triamcinolone"
          },
          {
            "code" : "A01AD11",
            "display" : "various"
          },
          {
            "code" : "A02A",
            "display" : "ANTACIDS"
          },
          {
            "code" : "A02AA10",
            "display" : "combinations"
          },
          {
            "code" : "A02AF",
            "display" : "Antacids with antiflatulents"
          },
          {
            "code" : "A02BC54",
            "display" : "rabeprazole, combinations"
          },
          {
            "code" : "A02BD02",
            "display" : "lansoprazole, tetracycline and metronidazole"
          },
          {
            "code" : "A02BX01",
            "display" : "carbenoxolone"
          },
          {
            "code" : "A02BX05",
            "display" : "bismuth subcitrate"
          },
          {
            "code" : "A02BX07",
            "display" : "gefarnate"
          },
          {
            "code" : "A02X",
            "display" : "OTHER DRUGS FOR ACID RELATED DISORDERS"
          },
          {
            "code" : "A03AB14",
            "display" : "pipenzolate"
          },
          {
            "code" : "A03AC",
            "display" : "Synthetic antispasmodics, amides with tertiary amines"
          },
          {
            "code" : "A03BB06",
            "display" : "homatropine methylbromide"
          },
          {
            "code" : "A03CA34",
            "display" : "propantheline and psycholeptics"
          },
          {
            "code" : "A03FA09",
            "display" : "mosapride"
          },
          {
            "code" : "A04AA55",
            "display" : "palonosetron, combinations"
          },
          {
            "code" : "A04AD12",
            "display" : "aprepitant"
          },
          {
            "code" : "A05AA01",
            "display" : "chenodeoxycholic acid"
          },
          {
            "code" : "A06AB05",
            "display" : "castor oil"
          },
          {
            "code" : "A06AB57",
            "display" : "cascara, combinations"
          },
          {
            "code" : "A06AC",
            "display" : "Bulk-forming laxatives"
          },
          {
            "code" : "A06AD17",
            "display" : "sodium phosphate"
          },
          {
            "code" : "A07AA07",
            "display" : "amphotericin B"
          },
          {
            "code" : "A07BA01",
            "display" : "medicinal charcoal"
          },
          {
            "code" : "A07BC01",
            "display" : "pectin"
          },
          {
            "code" : "A07DA",
            "display" : "Antipropulsives"
          },
          {
            "code" : "A07EA06",
            "display" : "budesonide"
          },
          {
            "code" : "A08AA",
            "display" : "Centrally acting antiobesity products"
          },
          {
            "code" : "A10AB01",
            "display" : "insulin (human)"
          },
          {
            "code" : "A10AD01",
            "display" : "insulin (human)"
          },
          {
            "code" : "A10BB31",
            "display" : "acetohexamide"
          },
          {
            "code" : "A10BD04",
            "display" : "glimepiride and rosiglitazone"
          },
          {
            "code" : "A10BD08",
            "display" : "metformin and vildagliptin"
          },
          {
            "code" : "A10BD15",
            "display" : "metformin and dapagliflozin"
          },
          {
            "code" : "A10BD20",
            "display" : "metformin and empagliflozin"
          },
          {
            "code" : "A10BD23",
            "display" : "metformin and ertugliflozin"
          },
          {
            "code" : "A10BG03",
            "display" : "pioglitazone"
          },
          {
            "code" : "A11AA04",
            "display" : "multivitamins and trace elements"
          },
          {
            "code" : "A11CA",
            "display" : "Vitamin A, plain"
          },
          {
            "code" : "A11CC05",
            "display" : "colecalciferol"
          },
          {
            "code" : "A11GA01",
            "display" : "ascorbic acid (vit C)"
          },
          {
            "code" : "A11GB01",
            "display" : "ascorbic acid (vit C) and calcium"
          },
          {
            "code" : "A11HA04",
            "display" : "riboflavin (vit B2)"
          },
          {
            "code" : "A11HA30",
            "display" : "dexpanthenol"
          },
          {
            "code" : "A12AX",
            "display" : "Calcium, combinations with vitamin D and/or other drugs"
          },
          {
            "code" : "A12BA",
            "display" : "Potassium"
          },
          {
            "code" : "A12CC09",
            "display" : "magnesium orotate"
          },
          {
            "code" : "A12CD",
            "display" : "Fluoride"
          },
          {
            "code" : "A12CD01",
            "display" : "sodium fluoride"
          },
          {
            "code" : "A16AX14",
            "display" : "migalastat"
          },
          {
            "code" : "B01AB10",
            "display" : "tinzaparin"
          },
          {
            "code" : "B01AC17",
            "display" : "tirofiban"
          },
          {
            "code" : "B01AC23",
            "display" : "cilostazol"
          },
          {
            "code" : "B01AD",
            "display" : "Enzymes"
          },
          {
            "code" : "B01AD01",
            "display" : "streptokinase"
          },
          {
            "code" : "B01AE07",
            "display" : "dabigatran etexilate"
          },
          {
            "code" : "B01AF",
            "display" : "Direct factor Xa inhibitors"
          },
          {
            "code" : "B02AA",
            "display" : "Amino acids"
          },
          {
            "code" : "B02BC30",
            "display" : "combinations"
          },
          {
            "code" : "B02BD01",
            "display" : "coagulation factor IX, II, VII and X in combination"
          },
          {
            "code" : "B02BD06",
            "display" : "von Willebrand factor and coagulation factor VIII in combination"
          },
          {
            "code" : "B02BD30",
            "display" : "thrombin"
          },
          {
            "code" : "B03AA03",
            "display" : "ferrous gluconate"
          },
          {
            "code" : "B03AE01",
            "display" : "iron, vitamin B12 and folic acid"
          },
          {
            "code" : "B03AE02",
            "display" : "iron, multivitamins and folic acid"
          },
          {
            "code" : "B03AE10",
            "display" : "various combinations"
          },
          {
            "code" : "B03BA04",
            "display" : "cobamamide"
          },
          {
            "code" : "B05BA",
            "display" : "Solutions for parenteral nutrition"
          },
          {
            "code" : "B05BA01",
            "display" : "amino acids"
          },
          {
            "code" : "B05CB",
            "display" : "Salt solutions"
          },
          {
            "code" : "B05XA12",
            "display" : "zinc chloride"
          },
          {
            "code" : "C01BA01",
            "display" : "quinidine"
          },
          {
            "code" : "C01BA02",
            "display" : "procainamide"
          },
          {
            "code" : "C01BA05",
            "display" : "ajmaline"
          },
          {
            "code" : "C01BC04",
            "display" : "flecainide"
          },
          {
            "code" : "C02CA04",
            "display" : "doxazosin"
          },
          {
            "code" : "C02DB",
            "display" : "Hydrazinophthalazine derivatives"
          },
          {
            "code" : "C03AA07",
            "display" : "cyclopenthiazide"
          },
          {
            "code" : "C04AD02",
            "display" : "xantinol nicotinate"
          },
          {
            "code" : "C04AX02",
            "display" : "phenoxybenzamine"
          },
          {
            "code" : "C05AA09",
            "display" : "dexamethasone"
          },
          {
            "code" : "C05AA12",
            "display" : "triamcinolone"
          },
          {
            "code" : "C05AD02",
            "display" : "tetracaine"
          },
          {
            "code" : "C05AE02",
            "display" : "isosorbide dinitrate"
          },
          {
            "code" : "C05AX02",
            "display" : "bismuth preparations, combinations"
          },
          {
            "code" : "C07AB03",
            "display" : "atenolol"
          },
          {
            "code" : "C07AB12",
            "display" : "nebivolol"
          },
          {
            "code" : "C07AG01",
            "display" : "labetalol"
          },
          {
            "code" : "C08CA01",
            "display" : "amlodipine"
          },
          {
            "code" : "C08DA51",
            "display" : "verapamil, combinations"
          },
          {
            "code" : "C08DB01",
            "display" : "diltiazem"
          },
          {
            "code" : "C09AA02",
            "display" : "enalapril"
          },
          {
            "code" : "C09BA02",
            "display" : "enalapril and diuretics"
          },
          {
            "code" : "C09BB04",
            "display" : "perindopril and amlodipine"
          },
          {
            "code" : "C09BB07",
            "display" : "ramipril and amlodipine"
          },
          {
            "code" : "C09DA03",
            "display" : "valsartan and diuretics"
          },
          {
            "code" : "C09XA02",
            "display" : "aliskiren"
          },
          {
            "code" : "C10AA02",
            "display" : "lovastatin"
          },
          {
            "code" : "C10AB01",
            "display" : "clofibrate"
          },
          {
            "code" : "C10AB05",
            "display" : "fenofibrate"
          },
          {
            "code" : "C10AA03",
            "display" : "pravastatin"
          },
          {
            "code" : "C10AX06",
            "display" : "omega-3-triglycerides incl. other esters and acids"
          },
          {
            "code" : "D01AC",
            "display" : "Imidazole and triazole derivatives"
          },
          {
            "code" : "D01AC05",
            "display" : "isoconazole"
          },
          {
            "code" : "D01AC15",
            "display" : "fluconazole"
          },
          {
            "code" : "D01AE15",
            "display" : "terbinafine"
          },
          {
            "code" : "D01AE20",
            "display" : "combinations"
          },
          {
            "code" : "D02AF",
            "display" : "Salicylic acid preparations"
          },
          {
            "code" : "D03BA01",
            "display" : "trypsin"
          },
          {
            "code" : "D04",
            "display" : "ANTIPRURITICS, INCL. ANTIHISTAMINES, ANESTHETICS, ETC."
          },
          {
            "code" : "D04AA10",
            "display" : "promethazine"
          },
          {
            "code" : "D04AB02",
            "display" : "cinchocaine"
          },
          {
            "code" : "D04AX",
            "display" : "Other antipruritics"
          },
          {
            "code" : "D06BA01",
            "display" : "silver sulfadiazine"
          },
          {
            "code" : "D06BB03",
            "display" : "aciclovir"
          },
          {
            "code" : "D07AA02",
            "display" : "hydrocortisone"
          },
          {
            "code" : "D07AA03",
            "display" : "prednisolone"
          },
          {
            "code" : "D07AC03",
            "display" : "desoximetasone"
          },
          {
            "code" : "D07AC06",
            "display" : "diflucortolone"
          },
          {
            "code" : "D07AC13",
            "display" : "mometasone"
          },
          {
            "code" : "D07AD02",
            "display" : "halcinonide"
          },
          {
            "code" : "D07BB",
            "display" : "Corticosteroids, moderately potent, combinations with antiseptics"
          },
          {
            "code" : "D07BB03",
            "display" : "triamcinolone and antiseptics"
          },
          {
            "code" : "D07BC01",
            "display" : "betamethasone and antiseptics"
          },
          {
            "code" : "D07CB05",
            "display" : "flumetasone and antibiotics"
          },
          {
            "code" : "D07CC01",
            "display" : "betamethasone and antibiotics"
          },
          {
            "code" : "D07CC06",
            "display" : "fluocortolone and antibiotics"
          },
          {
            "code" : "D07XA01",
            "display" : "hydrocortisone"
          },
          {
            "code" : "D08AD",
            "display" : "Boric acid products"
          },
          {
            "code" : "D08AE05",
            "display" : "chloroxylenol"
          },
          {
            "code" : "D08AG",
            "display" : "Iodine products"
          },
          {
            "code" : "D08AH01",
            "display" : "dequalinium"
          },
          {
            "code" : "D08AX05",
            "display" : "isopropanol"
          },
          {
            "code" : "D08AX06",
            "display" : "potassium permanganate"
          },
          {
            "code" : "D10AF01",
            "display" : "clindamycin"
          },
          {
            "code" : "D10AF52",
            "display" : "erythromycin, combinations"
          },
          {
            "code" : "D11AC01",
            "display" : "cetrimide"
          },
          {
            "code" : "D11AX01",
            "display" : "minoxidil"
          },
          {
            "code" : "D11AX11",
            "display" : "hydroquinone"
          },
          {
            "code" : "D11AX22",
            "display" : "ivermectin"
          },
          {
            "code" : "G01AA51",
            "display" : "nystatin, combinations"
          },
          {
            "code" : "G01AB",
            "display" : "Arsenic compounds"
          },
          {
            "code" : "G01AD",
            "display" : "Organic acids"
          },
          {
            "code" : "G01AF02",
            "display" : "clotrimazole"
          },
          {
            "code" : "G01AF55",
            "display" : "econazole, combinations"
          },
          {
            "code" : "G02C",
            "display" : "OTHER GYNECOLOGICALS"
          },
          {
            "code" : "G03AA06",
            "display" : "norgestrel and ethinylestradiol"
          },
          {
            "code" : "G03AA12",
            "display" : "drospirenone and ethinylestradiol"
          },
          {
            "code" : "G03AC03",
            "display" : "levonorgestrel"
          },
          {
            "code" : "G03AC10",
            "display" : "drospirenone"
          },
          {
            "code" : "G03BA02",
            "display" : "methyltestosterone"
          },
          {
            "code" : "G03BB01",
            "display" : "mesterolone"
          },
          {
            "code" : "G03CA53",
            "display" : "estradiol, combinations"
          },
          {
            "code" : "G03CB",
            "display" : "Synthetic estrogens, plain"
          },
          {
            "code" : "G03D",
            "display" : "PROGESTOGENS"
          },
          {
            "code" : "G03DB04",
            "display" : "nomegestrol"
          },
          {
            "code" : "G03FA10",
            "display" : "norgestrel and estrogen"
          },
          {
            "code" : "G03FB06",
            "display" : "medroxyprogesterone and estrogen"
          },
          {
            "code" : "G03HA01",
            "display" : "cyproterone"
          },
          {
            "code" : "G03XX01",
            "display" : "prasterone"
          },
          {
            "code" : "G04BD02",
            "display" : "flavoxate"
          },
          {
            "code" : "G04BD06",
            "display" : "propiverine"
          },
          {
            "code" : "G04BD08",
            "display" : "solifenacin"
          },
          {
            "code" : "G04BD12",
            "display" : "mirabegron"
          },
          {
            "code" : "G04BE10",
            "display" : "avanafil"
          },
          {
            "code" : "G04CA04",
            "display" : "silodosin"
          },
          {
            "code" : "G04CA51",
            "display" : "alfuzosin and finasteride"
          },
          {
            "code" : "H01CC01",
            "display" : "ganirelix"
          },
          {
            "code" : "H03CA",
            "display" : "Iodine therapy"
          },
          {
            "code" : "H05BA01",
            "display" : "calcitonin (salmon synthetic)"
          },
          {
            "code" : "J01AA07",
            "display" : "tetracycline"
          },
          {
            "code" : "J01AA08",
            "display" : "minocycline"
          },
          {
            "code" : "J01CA01",
            "display" : "ampicillin"
          },
          {
            "code" : "J01CA03",
            "display" : "carbenicillin"
          },
          {
            "code" : "J01CA06",
            "display" : "bacampicillin"
          },
          {
            "code" : "J01CA12",
            "display" : "piperacillin"
          },
          {
            "code" : "J01CA18",
            "display" : "hetacillin"
          },
          {
            "code" : "J01CE30",
            "display" : "combinations"
          },
          {
            "code" : "J01CF01",
            "display" : "dicloxacillin"
          },
          {
            "code" : "J01CG",
            "display" : "Beta-lactamase inhibitors"
          },
          {
            "code" : "J01DB09",
            "display" : "cefradine"
          },
          {
            "code" : "J01DC04",
            "display" : "cefaclor"
          },
          {
            "code" : "J01DD52",
            "display" : "ceftazidime and beta-lactamase inhibitor"
          },
          {
            "code" : "J01DE01",
            "display" : "cefepime"
          },
          {
            "code" : "J01DH51",
            "display" : "imipenem and cilastatin"
          },
          {
            "code" : "J01EB",
            "display" : "Short-acting sulfonamides"
          },
          {
            "code" : "J01EE",
            "display" : "Combinations of sulfonamides and trimethoprim, incl. derivatives"
          },
          {
            "code" : "J01GB03",
            "display" : "gentamicin"
          },
          {
            "code" : "J01GB06",
            "display" : "amikacin"
          },
          {
            "code" : "J01GB11",
            "display" : "isepamicin"
          },
          {
            "code" : "J01MA03",
            "display" : "pefloxacin"
          },
          {
            "code" : "J01MB07",
            "display" : "flumequine"
          },
          {
            "code" : "J01MB08",
            "display" : "nemonoxacin"
          },
          {
            "code" : "J01RA01",
            "display" : "penicillins, combinations with other antibacterials"
          },
          {
            "code" : "J01RA02",
            "display" : "sulfonamides, combinations with other antibacterials (excl. trimethoprim)"
          },
          {
            "code" : "J01XC01",
            "display" : "fusidic acid"
          },
          {
            "code" : "J01XX09",
            "display" : "daptomycin"
          },
          {
            "code" : "J02AB",
            "display" : "Imidazole derivatives"
          },
          {
            "code" : "J05AP55",
            "display" : "sofosbuvir and velpatasvir"
          },
          {
            "code" : "J05AR08",
            "display" : "emtricitabine, tenofovir disoproxil and rilpivirine"
          },
          {
            "code" : "J05AX05",
            "display" : "inosine pranobex"
          },
          {
            "code" : "J05AX09",
            "display" : "maraviroc"
          },
          {
            "code" : "J06BA",
            "display" : "Immunoglobulins, normal human"
          },
          {
            "code" : "J06BB02",
            "display" : "tetanus immunoglobulin"
          },
          {
            "code" : "J07AE",
            "display" : "Cholera vaccines"
          },
          {
            "code" : "C09DX06",
            "display" : "candesartan, amlodipine and hydrochlorothiazide"
          },
          {
            "code" : "C09XA54",
            "display" : "aliskiren, amlodipine and hydrochlorothiazide"
          },
          {
            "code" : "C10AB11",
            "display" : "choline fenofibrate"
          },
          {
            "code" : "C10BX05",
            "display" : "rosuvastatin and acetylsalicylic acid"
          },
          {
            "code" : "C10BX11",
            "display" : "atorvastatin, amlodipine and perindopril"
          },
          {
            "code" : "C10BX18",
            "display" : "atorvastatin, amlodipine and ramipril"
          },
          {
            "code" : "D01AC01",
            "display" : "clotrimazole"
          },
          {
            "code" : "D01AC09",
            "display" : "sulconazole"
          },
          {
            "code" : "D01AC12",
            "display" : "fenticonazole"
          },
          {
            "code" : "D01AE04",
            "display" : "undecylenic acid"
          },
          {
            "code" : "D03AX03",
            "display" : "dexpanthenol"
          },
          {
            "code" : "D03BA",
            "display" : "Proteolytic enzymes"
          },
          {
            "code" : "D05AC01",
            "display" : "dithranol"
          },
          {
            "code" : "D05AX02",
            "display" : "calcipotriol"
          },
          {
            "code" : "D05BA02",
            "display" : "methoxsalen"
          },
          {
            "code" : "D06AA01",
            "display" : "demeclocycline"
          },
          {
            "code" : "D06AX05",
            "display" : "bacitracin"
          },
          {
            "code" : "D06AX08",
            "display" : "tyrothricin"
          },
          {
            "code" : "D06AX09",
            "display" : "mupirocin"
          },
          {
            "code" : "D06BB05",
            "display" : "inosine"
          },
          {
            "code" : "D06BX01",
            "display" : "metronidazole"
          },
          {
            "code" : "D07AB02",
            "display" : "hydrocortisone butyrate"
          },
          {
            "code" : "D07AC02",
            "display" : "fluclorolone"
          },
          {
            "code" : "D07AC07",
            "display" : "fludroxycortide"
          },
          {
            "code" : "D07AC10",
            "display" : "diflorasone"
          },
          {
            "code" : "D07BA01",
            "display" : "prednisolone and antiseptics"
          },
          {
            "code" : "D07BA04",
            "display" : "hydrocortisone and antiseptics"
          },
          {
            "code" : "D07BC04",
            "display" : "diflucortolone and antiseptics"
          },
          {
            "code" : "D07CC04",
            "display" : "beclometasone and antibiotics"
          },
          {
            "code" : "D08AB",
            "display" : "Aluminium agents"
          },
          {
            "code" : "D08AC",
            "display" : "Biguanides and amidines"
          },
          {
            "code" : "D08AE03",
            "display" : "phenol"
          },
          {
            "code" : "D08AF01",
            "display" : "nitrofural"
          },
          {
            "code" : "D08AH03",
            "display" : "oxyquinoline"
          },
          {
            "code" : "D08AJ08",
            "display" : "benzethonium chloride"
          },
          {
            "code" : "D10AD51",
            "display" : "tretinoin, combinations"
          },
          {
            "code" : "D10AF02",
            "display" : "erythromycin"
          },
          {
            "code" : "D10AF05",
            "display" : "nadifloxacin"
          },
          {
            "code" : "D11AC03",
            "display" : "selenium compounds"
          },
          {
            "code" : "D11AH03",
            "display" : "cromoglicic acid"
          },
          {
            "code" : "D11AX21",
            "display" : "brimonidine"
          },
          {
            "code" : "D11AX24",
            "display" : "deoxycholic acid"
          },
          {
            "code" : "G01AA",
            "display" : "Antibiotics"
          },
          {
            "code" : "G01AA03",
            "display" : "amphotericin B"
          },
          {
            "code" : "G01AX06",
            "display" : "furazolidone"
          },
          {
            "code" : "G01AX12",
            "display" : "ciclopirox"
          },
          {
            "code" : "G02AB02",
            "display" : "ergot alkaloids"
          },
          {
            "code" : "G02AD02",
            "display" : "dinoprostone"
          },
          {
            "code" : "G02CB02",
            "display" : "lisuride"
          },
          {
            "code" : "G02CB05",
            "display" : "metergoline"
          },
          {
            "code" : "G03AA11",
            "display" : "norgestimate and ethinylestradiol"
          },
          {
            "code" : "G03AC",
            "display" : "Progestogens"
          },
          {
            "code" : "G03AC02",
            "display" : "lynestrenol"
          },
          {
            "code" : "G03AC05",
            "display" : "megestrol"
          },
          {
            "code" : "G03BB02",
            "display" : "androstanolone"
          },
          {
            "code" : "G03CA57",
            "display" : "conjugated estrogens"
          },
          {
            "code" : "G03CC",
            "display" : "Estrogens, combinations with other drugs"
          },
          {
            "code" : "G03DA04",
            "display" : "progesterone"
          },
          {
            "code" : "G03DB01",
            "display" : "dydrogesterone"
          },
          {
            "code" : "G03EK01",
            "display" : "methyltestosterone"
          },
          {
            "code" : "G03FA05",
            "display" : "methylnortestosterone and estrogen"
          },
          {
            "code" : "G03GA02",
            "display" : "human menopausal gonadotrophin"
          },
          {
            "code" : "G03GA05",
            "display" : "follitropin alfa"
          },
          {
            "code" : "G03GA09",
            "display" : "corifollitropin alfa"
          },
          {
            "code" : "G03GA30",
            "display" : "combinations"
          },
          {
            "code" : "G03XB02",
            "display" : "ulipristal"
          },
          {
            "code" : "G03XC02",
            "display" : "bazedoxifene"
          },
          {
            "code" : "G04BC",
            "display" : "Urinary concrement solvents"
          },
          {
            "code" : "G04BE01",
            "display" : "alprostadil"
          },
          {
            "code" : "G04CA01",
            "display" : "alfuzosin"
          },
          {
            "code" : "H01CB03",
            "display" : "lanreotide"
          },
          {
            "code" : "H02AB01",
            "display" : "betamethasone"
          },
          {
            "code" : "H02AB04",
            "display" : "methylprednisolone"
          },
          {
            "code" : "H02AB07",
            "display" : "prednisone"
          },
          {
            "code" : "H04AA01",
            "display" : "glucagon"
          },
          {
            "code" : "J01AA09",
            "display" : "rolitetracycline"
          },
          {
            "code" : "J01BA02",
            "display" : "thiamphenicol"
          },
          {
            "code" : "J01CA09",
            "display" : "azlocillin"
          },
          {
            "code" : "J01CE10",
            "display" : "benzathine phenoxymethylpenicillin"
          },
          {
            "code" : "J01DB05",
            "display" : "cefadroxil"
          },
          {
            "code" : "J01DC05",
            "display" : "cefotetan"
          },
          {
            "code" : "J01DC09",
            "display" : "cefmetazole"
          },
          {
            "code" : "J01DD04",
            "display" : "ceftriaxone"
          },
          {
            "code" : "J01DD12",
            "display" : "cefoperazone"
          },
          {
            "code" : "J01DH03",
            "display" : "ertapenem"
          },
          {
            "code" : "J01DH04",
            "display" : "doripenem"
          },
          {
            "code" : "J01DI02",
            "display" : "ceftaroline fosamil"
          },
          {
            "code" : "J01EB20",
            "display" : "combinations"
          },
          {
            "code" : "J01EC",
            "display" : "Intermediate-acting sulfonamides"
          },
          {
            "code" : "J01EC02",
            "display" : "sulfadiazine"
          },
          {
            "code" : "J01ED20",
            "display" : "combinations"
          },
          {
            "code" : "J01EE01",
            "display" : "sulfamethoxazole and trimethoprim"
          },
          {
            "code" : "J01FA07",
            "display" : "josamycin"
          },
          {
            "code" : "J01GB09",
            "display" : "dibekacin"
          },
          {
            "code" : "J01MA04",
            "display" : "enoxacin"
          },
          {
            "code" : "J01MA06",
            "display" : "norfloxacin"
          },
          {
            "code" : "J01RA07",
            "display" : "azithromycin, fluconazole and secnidazole"
          },
          {
            "code" : "J01RA10",
            "display" : "ciprofloxacin and metronidazole"
          },
          {
            "code" : "J01XX",
            "display" : "Other antibacterials"
          },
          {
            "code" : "J01XX08",
            "display" : "linezolid"
          },
          {
            "code" : "J02AA01",
            "display" : "amphotericin B"
          },
          {
            "code" : "J02AC01",
            "display" : "fluconazole"
          },
          {
            "code" : "J04AA03",
            "display" : "calcium aminosalicylate"
          },
          {
            "code" : "J04AB03",
            "display" : "rifamycin"
          },
          {
            "code" : "J04AK05",
            "display" : "bedaquiline"
          },
          {
            "code" : "J04AM05",
            "display" : "rifampicin, pyrazinamide and isoniazid"
          },
          {
            "code" : "J05AE09",
            "display" : "tipranavir"
          },
          {
            "code" : "J05AF02",
            "display" : "didanosine"
          },
          {
            "code" : "J05AF07",
            "display" : "tenofovir disoproxil"
          },
          {
            "code" : "J05AR07",
            "display" : "stavudine, lamivudine and nevirapine"
          },
          {
            "code" : "C07AA12",
            "display" : "nadolol"
          },
          {
            "code" : "C07AB02",
            "display" : "metoprolol"
          },
          {
            "code" : "C07AG02",
            "display" : "carvedilol"
          },
          {
            "code" : "C07DA06",
            "display" : "timolol, thiazides and other diuretics"
          },
          {
            "code" : "C07FB12",
            "display" : "nebivolol and amlodipine"
          },
          {
            "code" : "C07FX03",
            "display" : "metoprolol and acetylsalicylic acid"
          },
          {
            "code" : "C08CA05",
            "display" : "nifedipine"
          },
          {
            "code" : "C08CA51",
            "display" : "amlodipine and celecoxib"
          },
          {
            "code" : "C09AA06",
            "display" : "quinapril"
          },
          {
            "code" : "C09BA04",
            "display" : "perindopril and diuretics"
          },
          {
            "code" : "C09BB",
            "display" : "ACE inhibitors and calcium channel blockers"
          },
          {
            "code" : "C09BB02",
            "display" : "enalapril and lercanidipine"
          },
          {
            "code" : "C09BB03",
            "display" : "lisinopril and amlodipine"
          },
          {
            "code" : "C09BB05",
            "display" : "ramipril and felodipine"
          },
          {
            "code" : "C09BX03",
            "display" : "ramipril, amlodipine and hydrochlorothiazide"
          },
          {
            "code" : "C09CA08",
            "display" : "olmesartan medoxomil"
          },
          {
            "code" : "C09DA01",
            "display" : "losartan and diuretics"
          },
          {
            "code" : "C10AB03",
            "display" : "aluminium clofibrate"
          },
          {
            "code" : "C10AD",
            "display" : "Nicotinic acid and derivatives"
          },
          {
            "code" : "C10BA08",
            "display" : "atorvastatin and omega-3 fatty acids"
          },
          {
            "code" : "C10BX07",
            "display" : "rosuvastatin, amlodipine and lisinopril"
          },
          {
            "code" : "C10BX08",
            "display" : "atorvastatin and acetylsalicylic acid"
          },
          {
            "code" : "C10BX10",
            "display" : "rosuvastatin and valsartan"
          },
          {
            "code" : "C10BX12",
            "display" : "atorvastatin, acetylsalicylic acid and perindopril"
          },
          {
            "code" : "D01AA20",
            "display" : "combinations"
          },
          {
            "code" : "D02AE01",
            "display" : "carbamide"
          },
          {
            "code" : "D02AX",
            "display" : "Other emollients and protectives"
          },
          {
            "code" : "D03AX",
            "display" : "Other cicatrizants"
          },
          {
            "code" : "D04AA",
            "display" : "Antihistamines for topical use"
          },
          {
            "code" : "D05AA",
            "display" : "Tars"
          },
          {
            "code" : "D05BB01",
            "display" : "etretinate"
          },
          {
            "code" : "D06AX02",
            "display" : "chloramphenicol"
          },
          {
            "code" : "D06AX07",
            "display" : "gentamicin"
          },
          {
            "code" : "D06BA",
            "display" : "Sulfonamides"
          },
          {
            "code" : "D06BA03",
            "display" : "mafenide"
          },
          {
            "code" : "D06BA06",
            "display" : "sulfamerazine"
          },
          {
            "code" : "D06BB07",
            "display" : "lysozyme"
          },
          {
            "code" : "D07AB01",
            "display" : "clobetasone"
          },
          {
            "code" : "D07AB03",
            "display" : "flumetasone"
          },
          {
            "code" : "D07AB09",
            "display" : "triamcinolone"
          },
          {
            "code" : "D07AC05",
            "display" : "fluocortolone"
          },
          {
            "code" : "D07AC16",
            "display" : "hydrocortisone aceponate"
          },
          {
            "code" : "D07AD01",
            "display" : "clobetasol"
          },
          {
            "code" : "D07XB02",
            "display" : "triamcinolone"
          },
          {
            "code" : "D07XC",
            "display" : "Corticosteroids, potent, other combinations"
          },
          {
            "code" : "D07XC04",
            "display" : "diflucortolone"
          },
          {
            "code" : "D08A",
            "display" : "ANTISEPTICS AND DISINFECTANTS"
          },
          {
            "code" : "D08AE02",
            "display" : "policresulen"
          },
          {
            "code" : "D08AG03",
            "display" : "iodine"
          },
          {
            "code" : "D08AH30",
            "display" : "clioquinol"
          },
          {
            "code" : "D09AA06",
            "display" : "triclosan"
          },
          {
            "code" : "D09AA10",
            "display" : "clioquinol"
          },
          {
            "code" : "D09AA12",
            "display" : "chlorhexidine"
          },
          {
            "code" : "D10A",
            "display" : "ANTI-ACNE PREPARATIONS FOR TOPICAL USE"
          },
          {
            "code" : "D10AX03",
            "display" : "azelaic acid"
          },
          {
            "code" : "D11AH02",
            "display" : "pimecrolimus"
          },
          {
            "code" : "D11AH05",
            "display" : "dupilumab"
          },
          {
            "code" : "D11AX",
            "display" : "Other dermatologicals"
          },
          {
            "code" : "D11AX03",
            "display" : "calcium gluconate"
          },
          {
            "code" : "G01AA05",
            "display" : "chloramphenicol"
          },
          {
            "code" : "G01AD01",
            "display" : "lactic acid"
          },
          {
            "code" : "G01AF01",
            "display" : "metronidazole"
          },
          {
            "code" : "G01AF15",
            "display" : "butoconazole"
          },
          {
            "code" : "G01AG02",
            "display" : "terconazole"
          },
          {
            "code" : "G02AD01",
            "display" : "dinoprost"
          },
          {
            "code" : "G02AD05",
            "display" : "sulprostone"
          },
          {
            "code" : "G02CA01",
            "display" : "ritodrine"
          },
          {
            "code" : "G02CB03",
            "display" : "cabergoline"
          },
          {
            "code" : "G03AA01",
            "display" : "etynodiol and ethinylestradiol"
          },
          {
            "code" : "G03AA03",
            "display" : "lynestrenol and ethinylestradiol"
          },
          {
            "code" : "G03AA05",
            "display" : "norethisterone and ethinylestradiol"
          },
          {
            "code" : "G03AA07",
            "display" : "levonorgestrel and ethinylestradiol"
          },
          {
            "code" : "G03AB02",
            "display" : "lynestrenol and ethinylestradiol"
          },
          {
            "code" : "G03AB05",
            "display" : "desogestrel and ethinylestradiol"
          },
          {
            "code" : "G03AC01",
            "display" : "norethisterone"
          },
          {
            "code" : "G03AC08",
            "display" : "etonogestrel"
          },
          {
            "code" : "G03AD02",
            "display" : "ulipristal"
          },
          {
            "code" : "G03BA",
            "display" : "3-oxoandrosten (4) derivatives"
          },
          {
            "code" : "G03BA03",
            "display" : "testosterone"
          },
          {
            "code" : "G03CA03",
            "display" : "estradiol"
          },
          {
            "code" : "G03EA02",
            "display" : "testosterone and estrogen"
          },
          {
            "code" : "G03FA02",
            "display" : "hydroxyprogesterone and estrogen"
          },
          {
            "code" : "G03FB01",
            "display" : "norgestrel and estrogen"
          },
          {
            "code" : "G03GA",
            "display" : "Gonadotropins"
          },
          {
            "code" : "G04BD07",
            "display" : "tolterodine"
          },
          {
            "code" : "G04BE02",
            "display" : "papaverine"
          },
          {
            "code" : "G04BE07",
            "display" : "apomorphine"
          },
          {
            "code" : "G04BX",
            "display" : "Other urologicals"
          },
          {
            "code" : "G04BX01",
            "display" : "magnesium hydroxide"
          },
          {
            "code" : "G04CB01",
            "display" : "finasteride"
          },
          {
            "code" : "G04CB02",
            "display" : "dutasteride"
          },
          {
            "code" : "H01AB01",
            "display" : "thyrotropin alfa"
          },
          {
            "code" : "H02AB10",
            "display" : "cortisone"
          },
          {
            "code" : "J01AA06",
            "display" : "oxytetracycline"
          },
          {
            "code" : "J01CA",
            "display" : "Penicillins with extended spectrum"
          },
          {
            "code" : "J01CE09",
            "display" : "procaine benzylpenicillin"
          },
          {
            "code" : "J01CR01",
            "display" : "ampicillin and beta-lactamase inhibitor"
          },
          {
            "code" : "J01DC03",
            "display" : "cefamandole"
          },
          {
            "code" : "J01DC06",
            "display" : "cefonicid"
          },
          {
            "code" : "J01DC08",
            "display" : "loracarbef"
          },
          {
            "code" : "J01DD13",
            "display" : "cefpodoxime"
          },
          {
            "code" : "J01ED01",
            "display" : "sulfadimethoxine"
          },
          {
            "code" : "J01EE02",
            "display" : "sulfadiazine and trimethoprim"
          },
          {
            "code" : "J01EE07",
            "display" : "sulfamerazine and trimethoprim"
          },
          {
            "code" : "C03DA01",
            "display" : "spironolactone"
          },
          {
            "code" : "C03EA",
            "display" : "Low-ceiling diuretics and potassium-sparing agents"
          },
          {
            "code" : "C04AC01",
            "display" : "nicotinic acid"
          },
          {
            "code" : "C04AE04",
            "display" : "dihydroergocristine"
          },
          {
            "code" : "C04AX01",
            "display" : "cyclandelate"
          },
          {
            "code" : "C05AA",
            "display" : "Corticosteroids"
          },
          {
            "code" : "C05AA05",
            "display" : "betamethasone"
          },
          {
            "code" : "C05AA08",
            "display" : "fluocortolone"
          },
          {
            "code" : "C05BA51",
            "display" : "heparinoid, combinations"
          },
          {
            "code" : "C07AB07",
            "display" : "bisoprolol"
          },
          {
            "code" : "C07AB09",
            "display" : "esmolol"
          },
          {
            "code" : "C07FX06",
            "display" : "carvedilol and ivabradine"
          },
          {
            "code" : "C08CA02",
            "display" : "felodipine"
          },
          {
            "code" : "C08CA06",
            "display" : "nimodipine"
          },
          {
            "code" : "C09AA01",
            "display" : "captopril"
          },
          {
            "code" : "C09BA03",
            "display" : "lisinopril and diuretics"
          },
          {
            "code" : "C09BB06",
            "display" : "enalapril and nitrendipine"
          },
          {
            "code" : "C09BB10",
            "display" : "trandolapril and verapamil"
          },
          {
            "code" : "C09BX04",
            "display" : "perindopril, bisoprolol and amlodipine"
          },
          {
            "code" : "C09CA06",
            "display" : "candesartan"
          },
          {
            "code" : "C09DA06",
            "display" : "candesartan and diuretics"
          },
          {
            "code" : "C09DB05",
            "display" : "irbesartan and amlodipine"
          },
          {
            "code" : "C09DX02",
            "display" : "valsartan and aliskiren"
          },
          {
            "code" : "C10AA04",
            "display" : "fluvastatin"
          },
          {
            "code" : "C10AD01",
            "display" : "niceritrol"
          },
          {
            "code" : "C10AD06",
            "display" : "acipimox"
          },
          {
            "code" : "C10BA06",
            "display" : "rosuvastatin and ezetimibe"
          },
          {
            "code" : "C10BX03",
            "display" : "atorvastatin and amlodipine"
          },
          {
            "code" : "C10BX15",
            "display" : "atorvastatin and perindopril"
          },
          {
            "code" : "D01AA08",
            "display" : "griseofulvin"
          },
          {
            "code" : "D01AC02",
            "display" : "miconazole"
          },
          {
            "code" : "D01AC52",
            "display" : "miconazole, combinations"
          },
          {
            "code" : "D01AE02",
            "display" : "methylrosaniline"
          },
          {
            "code" : "D01AE16",
            "display" : "amorolfine"
          },
          {
            "code" : "D03A",
            "display" : "CICATRIZANTS"
          },
          {
            "code" : "D03AX09",
            "display" : "crilanomer"
          },
          {
            "code" : "D04AA09",
            "display" : "chloropyramine"
          },
          {
            "code" : "D04AA32",
            "display" : "diphenhydramine"
          },
          {
            "code" : "D04AB",
            "display" : "Anesthetics for topical use"
          },
          {
            "code" : "D04AB06",
            "display" : "tetracaine"
          },
          {
            "code" : "D04AB07",
            "display" : "pramocaine"
          },
          {
            "code" : "D04AX01",
            "display" : "doxepin"
          },
          {
            "code" : "D05BA",
            "display" : "Psoralens for systemic use"
          },
          {
            "code" : "D06AX12",
            "display" : "amikacin"
          },
          {
            "code" : "D06BB53",
            "display" : "aciclovir, combinations"
          },
          {
            "code" : "D06BX02",
            "display" : "ingenol mebutate"
          },
          {
            "code" : "D06C",
            "display" : "ANTIBIOTICS AND CHEMOTHERAPEUTICS, COMBINATIONS"
          },
          {
            "code" : "D07AB06",
            "display" : "fluorometholone"
          },
          {
            "code" : "D07AC15",
            "display" : "beclometasone"
          },
          {
            "code" : "D07CA03",
            "display" : "prednisolone and antibiotics"
          },
          {
            "code" : "D07XB",
            "display" : "Corticosteroids, moderately potent, other combinations"
          },
          {
            "code" : "D07XB01",
            "display" : "flumetasone"
          },
          {
            "code" : "D07XB05",
            "display" : "dexamethasone"
          },
          {
            "code" : "D08AA01",
            "display" : "ethacridine lactate"
          },
          {
            "code" : "D08AG02",
            "display" : "povidone-iodine"
          },
          {
            "code" : "D08AJ03",
            "display" : "cetylpyridinium"
          },
          {
            "code" : "D08AX",
            "display" : "Other antiseptics and disinfectants"
          },
          {
            "code" : "D10AA01",
            "display" : "fluorometholone"
          },
          {
            "code" : "D10AD54",
            "display" : "isotretinoin, combinations"
          },
          {
            "code" : "D10AF03",
            "display" : "chloramphenicol"
          },
          {
            "code" : "D10AF51",
            "display" : "clindamycin, combinations"
          },
          {
            "code" : "D10AX30",
            "display" : "various combinations"
          },
          {
            "code" : "D11AC06",
            "display" : "povidone-iodine"
          },
          {
            "code" : "D11AX10",
            "display" : "finasteride"
          },
          {
            "code" : "G01AA01",
            "display" : "nystatin"
          },
          {
            "code" : "G01AC02",
            "display" : "clioquinol"
          },
          {
            "code" : "G01AF07",
            "display" : "isoconazole"
          },
          {
            "code" : "G01AF08",
            "display" : "tioconazole"
          },
          {
            "code" : "G01AF11",
            "display" : "ketoconazole"
          },
          {
            "code" : "G01AX",
            "display" : "Other antiinfectives and antiseptics"
          },
          {
            "code" : "G02CC01",
            "display" : "ibuprofen"
          },
          {
            "code" : "G02CX01",
            "display" : "atosiban"
          },
          {
            "code" : "G03AA08",
            "display" : "medroxyprogesterone and ethinylestradiol"
          },
          {
            "code" : "G03AA15",
            "display" : "chlormadinone and ethinylestradiol"
          },
          {
            "code" : "G03AB07",
            "display" : "chlormadinone and ethinylestradiol"
          },
          {
            "code" : "G03AB08",
            "display" : "dienogest and estradiol"
          },
          {
            "code" : "G03AC06",
            "display" : "medroxyprogesterone"
          },
          {
            "code" : "G03CA04",
            "display" : "estriol"
          },
          {
            "code" : "G03DC06",
            "display" : "etynodiol"
          },
          {
            "code" : "G03FA01",
            "display" : "norethisterone and estrogen"
          },
          {
            "code" : "G03GA08",
            "display" : "choriogonadotropin alfa"
          },
          {
            "code" : "G03HB01",
            "display" : "cyproterone and estrogen"
          },
          {
            "code" : "G04BE03",
            "display" : "sildenafil"
          },
          {
            "code" : "G04BE09",
            "display" : "vardenafil"
          },
          {
            "code" : "G04CX",
            "display" : "Other drugs used in benign prostatic hypertrophy"
          },
          {
            "code" : "H01AC01",
            "display" : "somatropin"
          },
          {
            "code" : "H01CB02",
            "display" : "octreotide"
          },
          {
            "code" : "H02AB06",
            "display" : "prednisolone"
          },
          {
            "code" : "H02CA03",
            "display" : "ketoconazole"
          },
          {
            "code" : "H03BB01",
            "display" : "carbimazole"
          },
          {
            "code" : "H03BB02",
            "display" : "thiamazole"
          },
          {
            "code" : "J01CE01",
            "display" : "benzylpenicillin"
          },
          {
            "code" : "J01CG02",
            "display" : "tazobactam"
          },
          {
            "code" : "J01CR02",
            "display" : "amoxicillin and beta-lactamase inhibitor"
          },
          {
            "code" : "J01CR03",
            "display" : "ticarcillin and beta-lactamase inhibitor"
          },
          {
            "code" : "J01CR05",
            "display" : "piperacillin and beta-lactamase inhibitor"
          },
          {
            "code" : "J01D",
            "display" : "OTHER BETA-LACTAM ANTIBACTERIALS"
          },
          {
            "code" : "J01DB01",
            "display" : "cefalexin"
          },
          {
            "code" : "J01DB02",
            "display" : "cefaloridine"
          },
          {
            "code" : "J01DC07",
            "display" : "cefotiam"
          },
          {
            "code" : "J01DD07",
            "display" : "ceftizoxime"
          },
          {
            "code" : "J01DD14",
            "display" : "ceftibuten"
          },
          {
            "code" : "J01DE02",
            "display" : "cefpirome"
          },
          {
            "code" : "J01EA01",
            "display" : "trimethoprim"
          },
          {
            "code" : "J01EB01",
            "display" : "sulfaisodimidine"
          },
          {
            "code" : "C09AA09",
            "display" : "fosinopril"
          },
          {
            "code" : "C09AA10",
            "display" : "trandolapril"
          },
          {
            "code" : "C09AA16",
            "display" : "imidapril"
          },
          {
            "code" : "C09DA07",
            "display" : "telmisartan and diuretics"
          },
          {
            "code" : "C09DB08",
            "display" : "valsartan and lercanidipine"
          },
          {
            "code" : "C09DX01",
            "display" : "valsartan, amlodipine and hydrochlorothiazide"
          },
          {
            "code" : "C10AA07",
            "display" : "rosuvastatin"
          },
          {
            "code" : "C10AA08",
            "display" : "pitavastatin"
          },
          {
            "code" : "C10AC02",
            "display" : "colestipol"
          },
          {
            "code" : "C10AX09",
            "display" : "ezetimibe"
          },
          {
            "code" : "C10AX14",
            "display" : "alirocumab"
          },
          {
            "code" : "C10BA01",
            "display" : "lovastatin and nicotinic acid"
          },
          {
            "code" : "C10BA02",
            "display" : "simvastatin and ezetimibe"
          },
          {
            "code" : "C10BX17",
            "display" : "rosuvastatin and ramipril"
          },
          {
            "code" : "D01A",
            "display" : "ANTIFUNGALS FOR TOPICAL USE"
          },
          {
            "code" : "D01AA02",
            "display" : "natamycin"
          },
          {
            "code" : "D01AC14",
            "display" : "sertaconazole"
          },
          {
            "code" : "D01AE07",
            "display" : "chlorphenesin"
          },
          {
            "code" : "D01AE23",
            "display" : "butenafine"
          },
          {
            "code" : "D02AC",
            "display" : "Soft paraffin and fat products"
          },
          {
            "code" : "D04AB01",
            "display" : "lidocaine"
          },
          {
            "code" : "D06AA04",
            "display" : "tetracycline"
          },
          {
            "code" : "D06BA04",
            "display" : "sulfamethizole"
          },
          {
            "code" : "D07AA",
            "display" : "Corticosteroids, weak (group I)"
          },
          {
            "code" : "D07AC04",
            "display" : "fluocinolone acetonide"
          },
          {
            "code" : "D07AC11",
            "display" : "amcinonide"
          },
          {
            "code" : "D07BB01",
            "display" : "flumetasone and antiseptics"
          },
          {
            "code" : "D07CA01",
            "display" : "hydrocortisone and antibiotics"
          },
          {
            "code" : "D07CA02",
            "display" : "methylprednisolone and antibiotics"
          },
          {
            "code" : "D07CC02",
            "display" : "fluocinolone acetonide and antibiotics"
          },
          {
            "code" : "D07X",
            "display" : "CORTICOSTEROIDS, OTHER COMBINATIONS"
          },
          {
            "code" : "D07XB04",
            "display" : "fluorometholone"
          },
          {
            "code" : "D07XC03",
            "display" : "mometasone"
          },
          {
            "code" : "D08AX01",
            "display" : "hydrogen peroxide"
          },
          {
            "code" : "D08AX53",
            "display" : "propanol, combinations"
          },
          {
            "code" : "D09AA02",
            "display" : "fusidic acid"
          },
          {
            "code" : "D10AA02",
            "display" : "methylprednisolone"
          },
          {
            "code" : "D10AA03",
            "display" : "dexamethasone"
          },
          {
            "code" : "D10AB02",
            "display" : "sulfur"
          },
          {
            "code" : "D10AB05",
            "display" : "mesulfen"
          },
          {
            "code" : "D10AX",
            "display" : "Other anti-acne preparations for topical use"
          },
          {
            "code" : "D10BA01",
            "display" : "isotretinoin"
          },
          {
            "code" : "D11AX13",
            "display" : "monobenzone"
          },
          {
            "code" : "D11AX26",
            "display" : "caffeine"
          },
          {
            "code" : "G01AA07",
            "display" : "oxytetracycline"
          },
          {
            "code" : "G01AC",
            "display" : "Quinoline derivatives"
          },
          {
            "code" : "G01AF06",
            "display" : "ornidazole"
          },
          {
            "code" : "G01AX11",
            "display" : "povidone-iodine"
          },
          {
            "code" : "G02B",
            "display" : "CONTRACEPTIVES FOR TOPICAL USE"
          },
          {
            "code" : "G03",
            "display" : "SEX HORMONES AND MODULATORS OF THE GENITAL SYSTEM"
          },
          {
            "code" : "G03AA04",
            "display" : "megestrol and ethinylestradiol"
          },
          {
            "code" : "G03AA14",
            "display" : "nomegestrol and estradiol"
          },
          {
            "code" : "G03AA16",
            "display" : "dienogest and ethinylestradiol"
          },
          {
            "code" : "G03AB01",
            "display" : "megestrol and ethinylestradiol"
          },
          {
            "code" : "G03AC09",
            "display" : "desogestrel"
          },
          {
            "code" : "G03BA01",
            "display" : "fluoxymesterone"
          },
          {
            "code" : "G03CA07",
            "display" : "estrone"
          },
          {
            "code" : "G03CX01",
            "display" : "tibolone"
          },
          {
            "code" : "G03DB02",
            "display" : "megestrol"
          },
          {
            "code" : "G03DC02",
            "display" : "norethisterone"
          },
          {
            "code" : "G03FA13",
            "display" : "norgestimate and estrogen"
          },
          {
            "code" : "G03FA15",
            "display" : "dienogest and estrogen"
          },
          {
            "code" : "G03GA01",
            "display" : "chorionic gonadotrophin"
          },
          {
            "code" : "G03GA03",
            "display" : "serum gonadotrophin"
          },
          {
            "code" : "G03GA04",
            "display" : "urofollitropin"
          },
          {
            "code" : "G03XA02",
            "display" : "gestrinone"
          },
          {
            "code" : "G03XC01",
            "display" : "raloxifene"
          },
          {
            "code" : "G04BA01",
            "display" : "ammonium chloride"
          },
          {
            "code" : "G04BD",
            "display" : "Drugs for urinary frequency and incontinence"
          },
          {
            "code" : "G04BD04",
            "display" : "oxybutynin"
          },
          {
            "code" : "G04BX14",
            "display" : "dapoxetine"
          },
          {
            "code" : "G04BX15",
            "display" : "pentosan polysulfate sodium"
          },
          {
            "code" : "H01BA02",
            "display" : "desmopressin"
          },
          {
            "code" : "H01BA04",
            "display" : "terlipressin"
          },
          {
            "code" : "H01CB01",
            "display" : "somatostatin"
          },
          {
            "code" : "H02AA02",
            "display" : "fludrocortisone"
          },
          {
            "code" : "H02AB",
            "display" : "Glucocorticoids"
          },
          {
            "code" : "H02AB03",
            "display" : "fluocortolone"
          },
          {
            "code" : "H02AB08",
            "display" : "triamcinolone"
          },
          {
            "code" : "H02AB09",
            "display" : "hydrocortisone"
          },
          {
            "code" : "H03AA05",
            "display" : "thyroid gland preparations"
          },
          {
            "code" : "H05AA02",
            "display" : "teriparatide"
          },
          {
            "code" : "J01AA03",
            "display" : "chlortetracycline"
          },
          {
            "code" : "J01AA12",
            "display" : "tigecycline"
          },
          {
            "code" : "J01BA01",
            "display" : "chloramphenicol"
          },
          {
            "code" : "J01CA15",
            "display" : "talampicillin"
          },
          {
            "code" : "J01CF04",
            "display" : "oxacillin"
          },
          {
            "code" : "J01DD51",
            "display" : "cefotaxime and beta-lactamase inhibitor"
          },
          {
            "code" : "J01DD54",
            "display" : "ceftriaxone, combinations"
          },
          {
            "code" : "J01EB03",
            "display" : "sulfadimidine"
          },
          {
            "code" : "J01EB06",
            "display" : "sulfanilamide"
          },
          {
            "code" : "J01FF02",
            "display" : "lincomycin"
          },
          {
            "code" : "J01GA01",
            "display" : "streptomycin"
          },
          {
            "code" : "J01GB04",
            "display" : "kanamycin"
          },
          {
            "code" : "J01MA15",
            "display" : "gemifloxacin"
          },
          {
            "code" : "J01RA05",
            "display" : "levofloxacin and ornidazole"
          },
          {
            "code" : "J01XB01",
            "display" : "colistin"
          },
          {
            "code" : "J01XX01",
            "display" : "fosfomycin"
          },
          {
            "code" : "J01XX04",
            "display" : "spectinomycin"
          },
          {
            "code" : "J04AK02",
            "display" : "ethambutol"
          },
          {
            "code" : "J04AM03",
            "display" : "ethambutol and isoniazid"
          },
          {
            "code" : "J04AM07",
            "display" : "rifampicin, ethambutol and isoniazid"
          },
          {
            "code" : "J05AF09",
            "display" : "emtricitabine"
          },
          {
            "code" : "J05AF10",
            "display" : "entecavir"
          },
          {
            "code" : "J05AJ01",
            "display" : "raltegravir"
          },
          {
            "code" : "J05AR09",
            "display" : "emtricitabine, tenofovir disoproxil, elvitegravir and cobicistat"
          },
          {
            "code" : "J01EE04",
            "display" : "sulfamoxole and trimethoprim"
          },
          {
            "code" : "J01MA14",
            "display" : "moxifloxacin"
          },
          {
            "code" : "J01MB02",
            "display" : "nalidixic acid"
          },
          {
            "code" : "J01MB04",
            "display" : "pipemidic acid"
          },
          {
            "code" : "J01RA06",
            "display" : "cefepime and amikacin"
          },
          {
            "code" : "J01RA11",
            "display" : "ciprofloxacin and tinidazole"
          },
          {
            "code" : "J01RA12",
            "display" : "ciprofloxacin and ornidazole"
          },
          {
            "code" : "J01XD02",
            "display" : "tinidazole"
          },
          {
            "code" : "J01XX05",
            "display" : "methenamine"
          },
          {
            "code" : "J01XX07",
            "display" : "nitroxoline"
          },
          {
            "code" : "J01XX12",
            "display" : "lefamulin"
          },
          {
            "code" : "J04AC01",
            "display" : "isoniazid"
          },
          {
            "code" : "J04AM02",
            "display" : "rifampicin and isoniazid"
          },
          {
            "code" : "J05AE10",
            "display" : "darunavir"
          },
          {
            "code" : "J05AF06",
            "display" : "abacavir"
          },
          {
            "code" : "J05AG03",
            "display" : "efavirenz"
          },
          {
            "code" : "J05AJ03",
            "display" : "dolutegravir"
          },
          {
            "code" : "J05AJ04",
            "display" : "cabotegravir"
          },
          {
            "code" : "J05AR01",
            "display" : "zidovudine and lamivudine"
          },
          {
            "code" : "J05AR16",
            "display" : "lamivudine and raltegravir"
          },
          {
            "code" : "J05AR22",
            "display" : "emtricitabine, tenofovir alafenamide, darunavir and cobicistat"
          },
          {
            "code" : "J05AX02",
            "display" : "lysozyme"
          },
          {
            "code" : "J06BA02",
            "display" : "immunoglobulins, normal human, for intravascular adm."
          },
          {
            "code" : "J07AG51",
            "display" : "haemophilus influenzae B, combinations with toxoids"
          },
          {
            "code" : "J07BB",
            "display" : "Influenza vaccines"
          },
          {
            "code" : "J07BB01",
            "display" : "influenza, inactivated, whole virus"
          },
          {
            "code" : "L01AA02",
            "display" : "chlorambucil"
          },
          {
            "code" : "L01AX03",
            "display" : "temozolomide"
          },
          {
            "code" : "L01BB05",
            "display" : "fludarabine"
          },
          {
            "code" : "L01BC07",
            "display" : "azacitidine"
          },
          {
            "code" : "L01CE01",
            "display" : "topotecan"
          },
          {
            "code" : "L01EB01",
            "display" : "gefitinib"
          },
          {
            "code" : "L01EH01",
            "display" : "lapatinib"
          },
          {
            "code" : "L01EL03",
            "display" : "zanubrutinib"
          },
          {
            "code" : "L01EX04",
            "display" : "vandetanib"
          },
          {
            "code" : "L01EX09",
            "display" : "nintedanib"
          },
          {
            "code" : "L01EX10",
            "display" : "midostaurin"
          },
          {
            "code" : "L01EX19",
            "display" : "ripretinib"
          },
          {
            "code" : "L01XC11",
            "display" : "ipilimumab"
          },
          {
            "code" : "L01XC17",
            "display" : "nivolumab"
          },
          {
            "code" : "L01XC18",
            "display" : "pembrolizumab"
          },
          {
            "code" : "L01XC23",
            "display" : "elotuzumab"
          },
          {
            "code" : "L01XD01",
            "display" : "porfimer sodium"
          },
          {
            "code" : "L01XG03",
            "display" : "ixazomib"
          },
          {
            "code" : "L01XX66",
            "display" : "selinexor"
          },
          {
            "code" : "L02AE01",
            "display" : "buserelin"
          },
          {
            "code" : "L02BG03",
            "display" : "anastrozole"
          },
          {
            "code" : "L02BX03",
            "display" : "abiraterone"
          },
          {
            "code" : "L03AX16",
            "display" : "plerixafor"
          },
          {
            "code" : "L04AA",
            "display" : "Selective immunosuppressants"
          },
          {
            "code" : "L04AA25",
            "display" : "eculizumab"
          },
          {
            "code" : "L04AA29",
            "display" : "tofacitinib"
          },
          {
            "code" : "L04AA31",
            "display" : "teriflunomide"
          },
          {
            "code" : "L04AA33",
            "display" : "vedolizumab"
          },
          {
            "code" : "L04AC18",
            "display" : "risankizumab"
          },
          {
            "code" : "L04AD01",
            "display" : "ciclosporin"
          },
          {
            "code" : "L04AX04",
            "display" : "lenalidomide"
          },
          {
            "code" : "M01AB06",
            "display" : "alclofenac"
          },
          {
            "code" : "M01AB55",
            "display" : "diclofenac, combinations"
          },
          {
            "code" : "M01AC05",
            "display" : "lornoxicam"
          },
          {
            "code" : "M01AG01",
            "display" : "mefenamic acid"
          },
          {
            "code" : "M01AG03",
            "display" : "flufenamic acid"
          },
          {
            "code" : "M02AA25",
            "display" : "aceclofenac"
          },
          {
            "code" : "M02AB",
            "display" : "Capsaicin and similar agents"
          },
          {
            "code" : "M03BA02",
            "display" : "carisoprodol"
          },
          {
            "code" : "M03BB",
            "display" : "Oxazol, thiazine, and triazine derivatives"
          },
          {
            "code" : "M03BB02",
            "display" : "chlormezanone"
          },
          {
            "code" : "M03BB73",
            "display" : "chlorzoxazone, combinations with psycholeptics"
          },
          {
            "code" : "M03CA01",
            "display" : "dantrolene"
          },
          {
            "code" : "M04AA01",
            "display" : "allopurinol"
          },
          {
            "code" : "M05BA01",
            "display" : "etidronic acid"
          },
          {
            "code" : "M05BB03",
            "display" : "alendronic acid and colecalciferol"
          },
          {
            "code" : "M05BB09",
            "display" : "ibandronic acid and colecalciferol"
          },
          {
            "code" : "M09AB03",
            "display" : "bromelains"
          },
          {
            "code" : "N01AB04",
            "display" : "enflurane"
          },
          {
            "code" : "N01AB06",
            "display" : "isoflurane"
          },
          {
            "code" : "N01AB08",
            "display" : "sevoflurane"
          },
          {
            "code" : "N01AH01",
            "display" : "fentanyl"
          },
          {
            "code" : "N01B",
            "display" : "ANESTHETICS, LOCAL"
          },
          {
            "code" : "N01BB03",
            "display" : "mepivacaine"
          },
          {
            "code" : "N01BB09",
            "display" : "ropivacaine"
          },
          {
            "code" : "N02AB03",
            "display" : "fentanyl"
          },
          {
            "code" : "N02AC54",
            "display" : "dextropropoxyphene, combinations excl. psycholeptics"
          },
          {
            "code" : "N02AE01",
            "display" : "buprenorphine"
          },
          {
            "code" : "N02AJ14",
            "display" : "tramadol and dexketoprofen"
          },
          {
            "code" : "N02AJ18",
            "display" : "oxycodone and acetylsalicylic acid"
          },
          {
            "code" : "N02BA11",
            "display" : "diflunisal"
          },
          {
            "code" : "N02BA77",
            "display" : "ethenzamide, combinations with psycholeptics"
          },
          {
            "code" : "N02CA72",
            "display" : "ergotamine, combinations with psycholeptics"
          },
          {
            "code" : "N02CX02",
            "display" : "clonidine"
          },
          {
            "code" : "N03AX18",
            "display" : "lacosamide"
          },
          {
            "code" : "N04A",
            "display" : "ANTICHOLINERGIC AGENTS"
          },
          {
            "code" : "N04BB01",
            "display" : "amantadine"
          },
          {
            "code" : "N04BD01",
            "display" : "selegiline"
          },
          {
            "code" : "N05AE04",
            "display" : "ziprasidone"
          },
          {
            "code" : "N05AE05",
            "display" : "lurasidone"
          },
          {
            "code" : "N05AH03",
            "display" : "olanzapine"
          },
          {
            "code" : "N05AX13",
            "display" : "paliperidone"
          },
          {
            "code" : "N05BA16",
            "display" : "nordazepam"
          },
          {
            "code" : "N05CA02",
            "display" : "amobarbital"
          },
          {
            "code" : "N05CD03",
            "display" : "flunitrazepam"
          },
          {
            "code" : "N05CD05",
            "display" : "triazolam"
          },
          {
            "code" : "N05CM11",
            "display" : "bromides"
          },
          {
            "code" : "N05CM18",
            "display" : "dexmedetomidine"
          },
          {
            "code" : "N06AB06",
            "display" : "sertraline"
          },
          {
            "code" : "N06BA04",
            "display" : "methylphenidate"
          },
          {
            "code" : "N06BA07",
            "display" : "modafinil"
          },
          {
            "code" : "N06DA03",
            "display" : "rivastigmine"
          },
          {
            "code" : "J07AF01",
            "display" : "diphtheria toxoid"
          },
          {
            "code" : "J07AL02",
            "display" : "pneumococcus, purified polysaccharides antigen conjugated"
          },
          {
            "code" : "J07AL52",
            "display" : "pneumococcus purified polysaccharides antigen and haemophilus influenzae, conjugated"
          },
          {
            "code" : "J07AM01",
            "display" : "tetanus toxoid"
          },
          {
            "code" : "J07BF02",
            "display" : "poliomyelitis oral, trivalent, live attenuated"
          },
          {
            "code" : "J07BK01",
            "display" : "varicella, live attenuated"
          },
          {
            "code" : "J07CA",
            "display" : "Bacterial and viral vaccines, combined"
          },
          {
            "code" : "L01AA09",
            "display" : "bendamustine"
          },
          {
            "code" : "L01AC01",
            "display" : "thiotepa"
          },
          {
            "code" : "L01AD01",
            "display" : "carmustine"
          },
          {
            "code" : "L01BA04",
            "display" : "pemetrexed"
          },
          {
            "code" : "L01BC53",
            "display" : "tegafur, combinations"
          },
          {
            "code" : "L01DB02",
            "display" : "daunorubicin"
          },
          {
            "code" : "L01EB03",
            "display" : "afatinib"
          },
          {
            "code" : "L01EC01",
            "display" : "vemurafenib"
          },
          {
            "code" : "L01EE04",
            "display" : "selumetinib"
          },
          {
            "code" : "L01EF01",
            "display" : "palbociclib"
          },
          {
            "code" : "L01EM02",
            "display" : "copanlisib"
          },
          {
            "code" : "L01EX08",
            "display" : "lenvatinib"
          },
          {
            "code" : "L01XA03",
            "display" : "oxaliplatin"
          },
          {
            "code" : "L01XC13",
            "display" : "pertuzumab"
          },
          {
            "code" : "L01XH01",
            "display" : "vorinostat"
          },
          {
            "code" : "L01XX05",
            "display" : "hydroxycarbamide"
          },
          {
            "code" : "L01XX33",
            "display" : "celecoxib"
          },
          {
            "code" : "L02AE02",
            "display" : "leuprorelin"
          },
          {
            "code" : "L02BA03",
            "display" : "fulvestrant"
          },
          {
            "code" : "L02BB01",
            "display" : "flutamide"
          },
          {
            "code" : "L02BB05",
            "display" : "apalutamide"
          },
          {
            "code" : "L02BG04",
            "display" : "letrozole"
          },
          {
            "code" : "L02BG06",
            "display" : "exemestane"
          },
          {
            "code" : "L04AA06",
            "display" : "mycophenolic acid"
          },
          {
            "code" : "L04AA26",
            "display" : "belimumab"
          },
          {
            "code" : "L04AB07",
            "display" : "opinercept"
          },
          {
            "code" : "L04AX",
            "display" : "Other immunosuppressants"
          },
          {
            "code" : "L04AX03",
            "display" : "methotrexate"
          },
          {
            "code" : "M01AB16",
            "display" : "aceclofenac"
          },
          {
            "code" : "M01AB51",
            "display" : "indometacin, combinations"
          },
          {
            "code" : "M01AC01",
            "display" : "piroxicam"
          },
          {
            "code" : "M01AE08",
            "display" : "pirprofen"
          },
          {
            "code" : "M01AE12",
            "display" : "oxaprozin"
          },
          {
            "code" : "M01AX02",
            "display" : "niflumic acid"
          },
          {
            "code" : "M02AA07",
            "display" : "piroxicam"
          },
          {
            "code" : "M03BA01",
            "display" : "phenprobamate"
          },
          {
            "code" : "M03BX01",
            "display" : "baclofen"
          },
          {
            "code" : "M09AX07",
            "display" : "nusinersen"
          },
          {
            "code" : "M09AX10",
            "display" : "risdiplam"
          },
          {
            "code" : "N01AX03",
            "display" : "ketamine"
          },
          {
            "code" : "N01BC01",
            "display" : "cocaine"
          },
          {
            "code" : "N02AA51",
            "display" : "morphine, combinations"
          },
          {
            "code" : "N02AA59",
            "display" : "codeine, combinations excl. psycholeptics"
          },
          {
            "code" : "N02AB02",
            "display" : "pethidine"
          },
          {
            "code" : "N02AC04",
            "display" : "dextropropoxyphene"
          },
          {
            "code" : "N02AC52",
            "display" : "methadone, combinations excl. psycholeptics"
          },
          {
            "code" : "N02AF02",
            "display" : "nalbuphine"
          },
          {
            "code" : "N02AG",
            "display" : "Opioids in combination with antispasmodics"
          },
          {
            "code" : "N02AG01",
            "display" : "morphine and antispasmodics"
          },
          {
            "code" : "N02AJ06",
            "display" : "codeine and paracetamol"
          },
          {
            "code" : "N02BA05",
            "display" : "salicylamide"
          },
          {
            "code" : "N02BA06",
            "display" : "salsalate"
          },
          {
            "code" : "N02BA51",
            "display" : "acetylsalicylic acid, combinations excl. psycholeptics"
          },
          {
            "code" : "N02BA71",
            "display" : "acetylsalicylic acid, combinations with psycholeptics"
          },
          {
            "code" : "N02BB01",
            "display" : "phenazone"
          },
          {
            "code" : "N02BB54",
            "display" : "propyphenazone, combinations excl. psycholeptics"
          },
          {
            "code" : "N02BE",
            "display" : "Anilides"
          },
          {
            "code" : "N02BE53",
            "display" : "phenacetin, combinations excl. psycholeptics"
          },
          {
            "code" : "N02CA52",
            "display" : "ergotamine, combinations excl. psycholeptics"
          },
          {
            "code" : "N02CC01",
            "display" : "sumatriptan"
          },
          {
            "code" : "N02CC03",
            "display" : "zolmitriptan"
          },
          {
            "code" : "N03AA",
            "display" : "Barbiturates and derivatives"
          },
          {
            "code" : "N03AG01",
            "display" : "valproic acid"
          },
          {
            "code" : "N04AC01",
            "display" : "benzatropine"
          },
          {
            "code" : "N04BA02",
            "display" : "levodopa and decarboxylase inhibitor"
          },
          {
            "code" : "N04BA03",
            "display" : "levodopa, decarboxylase inhibitor and COMT inhibitor"
          },
          {
            "code" : "N04BA05",
            "display" : "melevodopa and decarboxylase inhibitor"
          },
          {
            "code" : "N05AA02",
            "display" : "levomepromazine"
          },
          {
            "code" : "N05AC02",
            "display" : "thioridazine"
          },
          {
            "code" : "N05AF05",
            "display" : "zuclopenthixol"
          },
          {
            "code" : "N05AH02",
            "display" : "clozapine"
          },
          {
            "code" : "N05AL07",
            "display" : "levosulpiride"
          },
          {
            "code" : "N05AX11",
            "display" : "zotepine"
          },
          {
            "code" : "N05AX12",
            "display" : "aripiprazole"
          },
          {
            "code" : "N05BA01",
            "display" : "diazepam"
          },
          {
            "code" : "N05BA03",
            "display" : "medazepam"
          },
          {
            "code" : "N05CD02",
            "display" : "nitrazepam"
          },
          {
            "code" : "N05CD06",
            "display" : "lormetazepam"
          },
          {
            "code" : "N05CF01",
            "display" : "zopiclone"
          },
          {
            "code" : "N05CH02",
            "display" : "ramelteon"
          },
          {
            "code" : "N05CX01",
            "display" : "meprobamate, combinations"
          },
          {
            "code" : "N06AA02",
            "display" : "imipramine"
          },
          {
            "code" : "N06AA06",
            "display" : "trimipramine"
          },
          {
            "code" : "N06AB05",
            "display" : "paroxetine"
          },
          {
            "code" : "N06AX06",
            "display" : "nefazodone"
          },
          {
            "code" : "N06AX17",
            "display" : "milnacipran"
          },
          {
            "code" : "N06BX01",
            "display" : "meclofenoxate"
          },
          {
            "code" : "N06DA53",
            "display" : "donepezil, memantine and Ginkgo folium"
          },
          {
            "code" : "N07AB02",
            "display" : "bethanechol"
          },
          {
            "code" : "N07BA01",
            "display" : "nicotine"
          },
          {
            "code" : "N07BB04",
            "display" : "naltrexone"
          },
          {
            "code" : "N07BC01",
            "display" : "buprenorphine"
          },
          {
            "code" : "P02BX",
            "display" : "Other antitrematodal agents"
          },
          {
            "code" : "P02C",
            "display" : "ANTINEMATODAL AGENTS"
          },
          {
            "code" : "P02CB01",
            "display" : "piperazine"
          },
          {
            "code" : "R01AA05",
            "display" : "oxymetazoline"
          },
          {
            "code" : "R01AB07",
            "display" : "oxymetazoline"
          },
          {
            "code" : "R01AD53",
            "display" : "dexamethasone, combinations"
          },
          {
            "code" : "R01AX",
            "display" : "Other nasal preparations"
          },
          {
            "code" : "R01BA",
            "display" : "Sympathomimetics"
          },
          {
            "code" : "C10BA07",
            "display" : "rosuvastatin and omega-3 fatty acids"
          },
          {
            "code" : "C10BA09",
            "display" : "rosuvastatin and fenofibrate"
          },
          {
            "code" : "C10BX02",
            "display" : "pravastatin and acetylsalicylic acid"
          },
          {
            "code" : "C10BX09",
            "display" : "rosuvastatin and amlodipine"
          },
          {
            "code" : "D01AC03",
            "display" : "econazole"
          },
          {
            "code" : "D01AC07",
            "display" : "tioconazole"
          },
          {
            "code" : "D01AE",
            "display" : "Other antifungals for topical use"
          },
          {
            "code" : "D01AE13",
            "display" : "selenium sulfide"
          },
          {
            "code" : "D02AE51",
            "display" : "carbamide, combinations"
          },
          {
            "code" : "D02BB01",
            "display" : "betacarotene"
          },
          {
            "code" : "D03AX10",
            "display" : "enoxolone"
          },
          {
            "code" : "D03BA03",
            "display" : "bromelains"
          },
          {
            "code" : "D04AA02",
            "display" : "mepyramine"
          },
          {
            "code" : "D04AB04",
            "display" : "benzocaine"
          },
          {
            "code" : "D05AC51",
            "display" : "dithranol, combinations"
          },
          {
            "code" : "D05BA01",
            "display" : "trioxysalen"
          },
          {
            "code" : "D05BB02",
            "display" : "acitretin"
          },
          {
            "code" : "D06BA05",
            "display" : "sulfanilamide"
          },
          {
            "code" : "D06BB04",
            "display" : "podophyllotoxin"
          },
          {
            "code" : "D06BB10",
            "display" : "imiquimod"
          },
          {
            "code" : "D06BX",
            "display" : "Other chemotherapeutics"
          },
          {
            "code" : "D07AC01",
            "display" : "betamethasone"
          },
          {
            "code" : "D07AC08",
            "display" : "fluocinonide"
          },
          {
            "code" : "D07AC14",
            "display" : "methylprednisolone aceponate"
          },
          {
            "code" : "D07CB04",
            "display" : "dexamethasone and antibiotics"
          },
          {
            "code" : "D07XC02",
            "display" : "desoximetasone"
          },
          {
            "code" : "D08AC52",
            "display" : "chlorhexidine, combinations"
          },
          {
            "code" : "D08AE04",
            "display" : "triclosan"
          },
          {
            "code" : "D08AK04",
            "display" : "merbromin"
          },
          {
            "code" : "D08AK06",
            "display" : "thiomersal"
          },
          {
            "code" : "D08AX08",
            "display" : "ethanol"
          },
          {
            "code" : "D09AA03",
            "display" : "nitrofural"
          },
          {
            "code" : "D09AA07",
            "display" : "cetylpyridinium"
          },
          {
            "code" : "D09AA11",
            "display" : "benzalkonium"
          },
          {
            "code" : "D10AD02",
            "display" : "retinol"
          },
          {
            "code" : "D11AH01",
            "display" : "tacrolimus"
          },
          {
            "code" : "D11AX12",
            "display" : "pyrithione zinc"
          },
          {
            "code" : "G01AA10",
            "display" : "clindamycin"
          },
          {
            "code" : "G01AF05",
            "display" : "econazole"
          },
          {
            "code" : "G01AX03",
            "display" : "policresulen"
          },
          {
            "code" : "G02AD06",
            "display" : "misoprostol"
          },
          {
            "code" : "G02CA03",
            "display" : "fenoterol"
          },
          {
            "code" : "G03AA13",
            "display" : "norelgestromin and ethinylestradiol"
          },
          {
            "code" : "G03AA18",
            "display" : "drospirenone and estetrol"
          },
          {
            "code" : "G03AB03",
            "display" : "levonorgestrel and ethinylestradiol"
          },
          {
            "code" : "G03AB04",
            "display" : "norethisterone and ethinylestradiol"
          },
          {
            "code" : "G03AB06",
            "display" : "gestodene and ethinylestradiol"
          },
          {
            "code" : "G03DA02",
            "display" : "medroxyprogesterone"
          },
          {
            "code" : "G03DA03",
            "display" : "hydroxyprogesterone"
          },
          {
            "code" : "G03DB08",
            "display" : "dienogest"
          },
          {
            "code" : "G03EA01",
            "display" : "methyltestosterone and estrogen"
          },
          {
            "code" : "G03EB",
            "display" : "Androgen, progestogen and estrogen in combination"
          },
          {
            "code" : "G03FA12",
            "display" : "medroxyprogesterone and estrogen"
          },
          {
            "code" : "G03FB05",
            "display" : "norethisterone and estrogen"
          },
          {
            "code" : "G03GA06",
            "display" : "follitropin beta"
          },
          {
            "code" : "G04BA03",
            "display" : "calcium chloride"
          },
          {
            "code" : "G04BD09",
            "display" : "trospium"
          },
          {
            "code" : "G04BE08",
            "display" : "tadalafil"
          },
          {
            "code" : "G04CA54",
            "display" : "tamsulosin and tadalafil"
          },
          {
            "code" : "H01AC03",
            "display" : "mecasermin"
          },
          {
            "code" : "H01BA01",
            "display" : "vasopressin (argipressin)"
          },
          {
            "code" : "H01BB02",
            "display" : "oxytocin"
          },
          {
            "code" : "H01BB03",
            "display" : "carbetocin"
          },
          {
            "code" : "H01CB05",
            "display" : "pasireotide"
          },
          {
            "code" : "H03AA01",
            "display" : "levothyroxine sodium"
          },
          {
            "code" : "H03AA02",
            "display" : "liothyronine sodium"
          },
          {
            "code" : "H03BA02",
            "display" : "propylthiouracil"
          },
          {
            "code" : "J01AA01",
            "display" : "demeclocycline"
          },
          {
            "code" : "J01CA04",
            "display" : "amoxicillin"
          },
          {
            "code" : "J01CA08",
            "display" : "pivmecillinam"
          },
          {
            "code" : "J01CA16",
            "display" : "sulbenicillin"
          },
          {
            "code" : "J01CA51",
            "display" : "ampicillin, combinations"
          },
          {
            "code" : "J01CF05",
            "display" : "flucloxacillin"
          },
          {
            "code" : "J01CG01",
            "display" : "sulbactam"
          },
          {
            "code" : "J01CR04",
            "display" : "sultamicillin"
          },
          {
            "code" : "J01DB04",
            "display" : "cefazolin"
          },
          {
            "code" : "J01DC01",
            "display" : "cefoxitin"
          },
          {
            "code" : "J01DD02",
            "display" : "ceftazidime"
          },
          {
            "code" : "J01DF01",
            "display" : "aztreonam"
          },
          {
            "code" : "J01DH02",
            "display" : "meropenem"
          },
          {
            "code" : "J01EB05",
            "display" : "sulfafurazole"
          },
          {
            "code" : "J01EC01",
            "display" : "sulfamethoxazole"
          },
          {
            "code" : "J01EC20",
            "display" : "combinations"
          },
          {
            "code" : "J01EE05",
            "display" : "sulfadimidine and trimethoprim"
          },
          {
            "code" : "J01FA03",
            "display" : "midecamycin"
          },
          {
            "code" : "J01FA08",
            "display" : "troleandomycin"
          },
          {
            "code" : "J01FA09",
            "display" : "clarithromycin"
          },
          {
            "code" : "J01GB01",
            "display" : "tobramycin"
          },
          {
            "code" : "J01GB05",
            "display" : "neomycin"
          },
          {
            "code" : "J01MA12",
            "display" : "levofloxacin"
          },
          {
            "code" : "J01MB06",
            "display" : "cinoxacin"
          },
          {
            "code" : "J01RA03",
            "display" : "cefuroxime and metronidazole"
          },
          {
            "code" : "J02AB01",
            "display" : "miconazole"
          },
          {
            "code" : "J02AX",
            "display" : "Other antimycotics for systemic use"
          },
          {
            "code" : "J04AK01",
            "display" : "pyrazinamide"
          },
          {
            "code" : "J05AB14",
            "display" : "valganciclovir"
          },
          {
            "code" : "J05AE08",
            "display" : "atazanavir"
          },
          {
            "code" : "J05AF03",
            "display" : "zalcitabine"
          },
          {
            "code" : "J05AF04",
            "display" : "stavudine"
          },
          {
            "code" : "J05AR12",
            "display" : "lamivudine and tenofovir disoproxil"
          },
          {
            "code" : "J06BB01",
            "display" : "anti-D (rh) immunoglobulin"
          },
          {
            "code" : "J07AH10",
            "display" : "meningococcus A, purified polysaccharides antigen conjugated"
          },
          {
            "code" : "J07BF",
            "display" : "Poliomyelitis vaccines"
          },
          {
            "code" : "J07BH01",
            "display" : "rota virus, live attenuated"
          },
          {
            "code" : "J07CA09",
            "display" : "diphtheria-haemophilus influenzae B-pertussis-poliomyelitis-tetanus-hepatitis B"
          },
          {
            "code" : "L01BA01",
            "display" : "methotrexate"
          },
          {
            "code" : "L01BC06",
            "display" : "capecitabine"
          },
          {
            "code" : "L01BC08",
            "display" : "decitabine"
          },
          {
            "code" : "L01DC01",
            "display" : "bleomycin"
          },
          {
            "code" : "A01AA04",
            "display" : "stannous fluoride"
          },
          {
            "code" : "A01AB08",
            "display" : "neomycin"
          },
          {
            "code" : "A01AC02",
            "display" : "dexamethasone"
          },
          {
            "code" : "A01AD",
            "display" : "Other agents for local oral treatment"
          },
          {
            "code" : "A02AA04",
            "display" : "magnesium hydroxide"
          },
          {
            "code" : "A02AB01",
            "display" : "aluminium hydroxide"
          },
          {
            "code" : "A02AD02",
            "display" : "magaldrate"
          },
          {
            "code" : "A02AF02",
            "display" : "ordinary salt combinations and antiflatulents"
          },
          {
            "code" : "A02AH",
            "display" : "Antacids with sodium bicarbonate"
          },
          {
            "code" : "A02AX",
            "display" : "Antacids, other combinations"
          },
          {
            "code" : "A02BA04",
            "display" : "nizatidine"
          },
          {
            "code" : "A02BC02",
            "display" : "pantoprazole"
          },
          {
            "code" : "A02BC06",
            "display" : "dexlansoprazole"
          },
          {
            "code" : "A02BC08",
            "display" : "vonoprazan"
          },
          {
            "code" : "A02BD03",
            "display" : "lansoprazole, amoxicillin and metronidazole"
          },
          {
            "code" : "A02BD07",
            "display" : "lansoprazole, amoxicillin and clarithromycin"
          },
          {
            "code" : "A02BX",
            "display" : "Other drugs for peptic ulcer and gastro-oesophageal reflux disease (GORD)"
          },
          {
            "code" : "A02BX12",
            "display" : "bismuth subnitrate"
          },
          {
            "code" : "A02BX13",
            "display" : "alginic acid"
          },
          {
            "code" : "A03",
            "display" : "DRUGS FOR FUNCTIONAL GASTROINTESTINAL DISORDERS"
          },
          {
            "code" : "A03AA",
            "display" : "Synthetic anticholinergics, esters with tertiary amino group"
          },
          {
            "code" : "A03AB06",
            "display" : "otilonium bromide"
          },
          {
            "code" : "A03AX03",
            "display" : "chlorbenzoxamine"
          },
          {
            "code" : "A03AX08",
            "display" : "alverine"
          },
          {
            "code" : "A03CC",
            "display" : "Other antispasmodics in combination with psycholeptics"
          },
          {
            "code" : "A04AA",
            "display" : "Serotonin (5HT3) antagonists"
          },
          {
            "code" : "A04AA02",
            "display" : "granisetron"
          },
          {
            "code" : "A04AD51",
            "display" : "scopolamine, combinations"
          },
          {
            "code" : "A05BA01",
            "display" : "arginine glutamate"
          },
          {
            "code" : "A06AB02",
            "display" : "bisacodyl"
          },
          {
            "code" : "A06AB07",
            "display" : "cascara"
          },
          {
            "code" : "A06AB58",
            "display" : "sodium picosulfate, combinations"
          },
          {
            "code" : "A06AC53",
            "display" : "sterculia, combinations"
          },
          {
            "code" : "A06AG",
            "display" : "Enemas"
          },
          {
            "code" : "A07AA02",
            "display" : "nystatin"
          },
          {
            "code" : "A07AA04",
            "display" : "streptomycin"
          },
          {
            "code" : "A07BB",
            "display" : "Bismuth preparations"
          },
          {
            "code" : "A07BC",
            "display" : "Other intestinal adsorbents"
          },
          {
            "code" : "A07BC30",
            "display" : "combinations"
          },
          {
            "code" : "A07CA",
            "display" : "Oral rehydration salt formulations"
          },
          {
            "code" : "A07DA52",
            "display" : "morphine, combinations"
          },
          {
            "code" : "A07EA04",
            "display" : "betamethasone"
          },
          {
            "code" : "A07EC02",
            "display" : "mesalazine"
          },
          {
            "code" : "A07EC04",
            "display" : "balsalazide"
          },
          {
            "code" : "A08AA11",
            "display" : "lorcaserin"
          },
          {
            "code" : "A09AA02",
            "display" : "multienzymes (lipase, protease etc.)"
          },
          {
            "code" : "A09AB01",
            "display" : "glutamic acid hydrochloride"
          },
          {
            "code" : "A10AC01",
            "display" : "insulin (human)"
          },
          {
            "code" : "A10AD",
            "display" : "Insulins and analogues for injection, intermediate- or long-acting combined with fast-acting"
          },
          {
            "code" : "A10BA03",
            "display" : "buformin"
          },
          {
            "code" : "A10BB03",
            "display" : "tolbutamide"
          },
          {
            "code" : "A10BD",
            "display" : "Combinations of oral blood glucose lowering drugs"
          },
          {
            "code" : "A10BD25",
            "display" : "metformin, saxagliptin and dapagliflozin"
          },
          {
            "code" : "A11AA01",
            "display" : "multivitamins and iron"
          },
          {
            "code" : "A11CA01",
            "display" : "retinol (vit A)"
          },
          {
            "code" : "A11DA",
            "display" : "Vitamin B1, plain"
          },
          {
            "code" : "A11HA06",
            "display" : "pyridoxal phosphate"
          },
          {
            "code" : "A12AA07",
            "display" : "calcium chloride"
          },
          {
            "code" : "A12AA10",
            "display" : "calcium glucoheptonate"
          },
          {
            "code" : "A12AA13",
            "display" : "calcium citrate"
          },
          {
            "code" : "A12CC02",
            "display" : "magnesium sulfate"
          },
          {
            "code" : "A12CC05",
            "display" : "magnesium aspartate"
          },
          {
            "code" : "A12CE",
            "display" : "Selenium"
          },
          {
            "code" : "A14AA",
            "display" : "Androstan derivatives"
          },
          {
            "code" : "A14AA08",
            "display" : "oxandrolone"
          },
          {
            "code" : "A16A",
            "display" : "OTHER ALIMENTARY TRACT AND METABOLISM PRODUCTS"
          },
          {
            "code" : "A16AA03",
            "display" : "glutamine"
          },
          {
            "code" : "A16AX02",
            "display" : "anethole trithione"
          },
          {
            "code" : "B01AB51",
            "display" : "heparin, combinations"
          },
          {
            "code" : "B01AC09",
            "display" : "epoprostenol"
          },
          {
            "code" : "B01AC56",
            "display" : "acetylsalicylic acid, combinations with proton pump inhibitors"
          },
          {
            "code" : "B01AE06",
            "display" : "bivalirudin"
          },
          {
            "code" : "B01AX",
            "display" : "Other antithrombotic agents"
          },
          {
            "code" : "B02BA01",
            "display" : "phytomenadione"
          },
          {
            "code" : "B02BD07",
            "display" : "coagulation factor XIII"
          },
          {
            "code" : "B02BD08",
            "display" : "coagulation factor VIIa"
          },
          {
            "code" : "B02BD13",
            "display" : "coagulation factor X"
          },
          {
            "code" : "B02BX05",
            "display" : "eltrombopag"
          },
          {
            "code" : "B03AA",
            "display" : "Iron bivalent, oral preparations"
          },
          {
            "code" : "B03AA02",
            "display" : "ferrous fumarate"
          },
          {
            "code" : "B03AA07",
            "display" : "ferrous sulfate"
          },
          {
            "code" : "B03AC",
            "display" : "Iron, parenteral preparations"
          },
          {
            "code" : "B03AE",
            "display" : "Iron in other combinations"
          },
          {
            "code" : "B03BB01",
            "display" : "folic acid"
          },
          {
            "code" : "B05AA",
            "display" : "Blood substitutes and plasma protein fractions"
          },
          {
            "code" : "B05CB01",
            "display" : "sodium chloride"
          },
          {
            "code" : "B05CB02",
            "display" : "sodium citrate"
          },
          {
            "code" : "B05CX",
            "display" : "Other irrigating solutions"
          },
          {
            "code" : "B05CX02",
            "display" : "sorbitol"
          },
          {
            "code" : "B05XA06",
            "display" : "potassium phosphate, incl. combinations with other potassium salts"
          },
          {
            "code" : "B05XA14",
            "display" : "sodium glycerophosphate"
          },
          {
            "code" : "B05XA16",
            "display" : "cardioplegia solutions"
          },
          {
            "code" : "B05XB01",
            "display" : "arginine hydrochloride"
          },
          {
            "code" : "C01BD01",
            "display" : "amiodarone"
          },
          {
            "code" : "C01BD02",
            "display" : "bretylium tosilate"
          },
          {
            "code" : "J06BB04",
            "display" : "hepatitis B immunoglobulin"
          },
          {
            "code" : "J06BB09",
            "display" : "cytomegalovirus immunoglobulin"
          },
          {
            "code" : "J07AG01",
            "display" : "haemophilus influenzae B, purified antigen conjugated"
          },
          {
            "code" : "J07AJ",
            "display" : "Pertussis vaccines"
          },
          {
            "code" : "J07AM51",
            "display" : "tetanus toxoid, combinations with diphtheria toxoid"
          },
          {
            "code" : "J07AP",
            "display" : "Typhoid vaccines"
          },
          {
            "code" : "J07BB02",
            "display" : "influenza, inactivated, split virus or surface antigen"
          },
          {
            "code" : "J07BC20",
            "display" : "combinations"
          },
          {
            "code" : "J07BD52",
            "display" : "measles, combinations with mumps and rubella, live attenuated"
          },
          {
            "code" : "J07BK03",
            "display" : "zoster, purified antigen"
          },
          {
            "code" : "J07BM01",
            "display" : "papillomavirus (human types 6, 11, 16, 18)"
          },
          {
            "code" : "J07BM02",
            "display" : "papillomavirus (human types 16, 18)"
          },
          {
            "code" : "J07CA02",
            "display" : "diphtheria-pertussis-poliomyelitis-tetanus"
          },
          {
            "code" : "J07CA06",
            "display" : "diphtheria-haemophilus influenzae B-pertussis-poliomyelitis-tetanus"
          },
          {
            "code" : "L01AX04",
            "display" : "dacarbazine"
          },
          {
            "code" : "L01CA01",
            "display" : "vinblastine"
          },
          {
            "code" : "L01CE02",
            "display" : "irinotecan"
          },
          {
            "code" : "L01DB07",
            "display" : "mitoxantrone"
          },
          {
            "code" : "L01ED04",
            "display" : "brigatinib"
          },
          {
            "code" : "L01ED05",
            "display" : "lorlatinib"
          },
          {
            "code" : "L01EF02",
            "display" : "ribociclib"
          },
          {
            "code" : "L01EX01",
            "display" : "sunitinib"
          },
          {
            "code" : "L01EX13",
            "display" : "gilteritinib"
          },
          {
            "code" : "L01XA01",
            "display" : "cisplatin"
          },
          {
            "code" : "L01XC15",
            "display" : "obinutuzumab"
          },
          {
            "code" : "L01XX",
            "display" : "Other antineoplastic agents"
          },
          {
            "code" : "L01XX71",
            "display" : "tisagenlecleucel"
          },
          {
            "code" : "L02AA",
            "display" : "Estrogens"
          },
          {
            "code" : "L02BB03",
            "display" : "bicalutamide"
          },
          {
            "code" : "L02BB06",
            "display" : "darolutamide"
          },
          {
            "code" : "L04AA27",
            "display" : "fingolimod"
          },
          {
            "code" : "L04AB01",
            "display" : "etanercept"
          },
          {
            "code" : "L04AB05",
            "display" : "certolizumab pegol"
          },
          {
            "code" : "L04AC08",
            "display" : "canakinumab"
          },
          {
            "code" : "M01AB03",
            "display" : "tolmetin"
          },
          {
            "code" : "M01AC02",
            "display" : "tenoxicam"
          },
          {
            "code" : "M01AC06",
            "display" : "meloxicam"
          },
          {
            "code" : "M01AE02",
            "display" : "naproxen"
          },
          {
            "code" : "M01AE03",
            "display" : "ketoprofen"
          },
          {
            "code" : "M01AE53",
            "display" : "ketoprofen, combinations"
          },
          {
            "code" : "M01AG02",
            "display" : "tolfenamic acid"
          },
          {
            "code" : "M01AH05",
            "display" : "etoricoxib"
          },
          {
            "code" : "M01AX01",
            "display" : "nabumetone"
          },
          {
            "code" : "M01BA03",
            "display" : "acetylsalicylic acid and corticosteroids"
          },
          {
            "code" : "M02AA12",
            "display" : "naproxen"
          },
          {
            "code" : "M02AB01",
            "display" : "capsaicin"
          },
          {
            "code" : "M03BA03",
            "display" : "methocarbamol"
          },
          {
            "code" : "M03BX03",
            "display" : "pridinol"
          },
          {
            "code" : "M04AB01",
            "display" : "probenecid"
          },
          {
            "code" : "M05BA02",
            "display" : "clodronic acid"
          },
          {
            "code" : "M05BA06",
            "display" : "ibandronic acid"
          },
          {
            "code" : "M05BB07",
            "display" : "risedronic acid and colecalciferol"
          },
          {
            "code" : "M05BX05",
            "display" : "burosumab"
          },
          {
            "code" : "M05BX53",
            "display" : "strontium ranelate and colecalciferol"
          },
          {
            "code" : "N01BB06",
            "display" : "cinchocaine"
          },
          {
            "code" : "N01BB53",
            "display" : "mepivacaine, combinations"
          },
          {
            "code" : "N01BB58",
            "display" : "articaine, combinations"
          },
          {
            "code" : "N01BX",
            "display" : "Other local anesthetics"
          },
          {
            "code" : "N02AA01",
            "display" : "morphine"
          },
          {
            "code" : "N02AA05",
            "display" : "oxycodone"
          },
          {
            "code" : "N02AF01",
            "display" : "butorphanol"
          },
          {
            "code" : "N02AJ09",
            "display" : "codeine and other non-opioid analgesics"
          },
          {
            "code" : "N02AJ13",
            "display" : "tramadol and paracetamol"
          },
          {
            "code" : "N02BA04",
            "display" : "sodium salicylate"
          },
          {
            "code" : "N02BE01",
            "display" : "paracetamol"
          },
          {
            "code" : "N03AE01",
            "display" : "clonazepam"
          },
          {
            "code" : "N03AF01",
            "display" : "carbamazepine"
          },
          {
            "code" : "N03AF02",
            "display" : "oxcarbazepine"
          },
          {
            "code" : "N03AX09",
            "display" : "lamotrigine"
          },
          {
            "code" : "N04BA",
            "display" : "Dopa and dopa derivatives"
          },
          {
            "code" : "N04BD03",
            "display" : "safinamide"
          },
          {
            "code" : "N05AA01",
            "display" : "chlorpromazine"
          },
          {
            "code" : "N05AA05",
            "display" : "triflupromazine"
          },
          {
            "code" : "N05AF01",
            "display" : "flupentixol"
          },
          {
            "code" : "N05AL05",
            "display" : "amisulpride"
          },
          {
            "code" : "N05BA",
            "display" : "Benzodiazepine derivatives"
          },
          {
            "code" : "N05BA09",
            "display" : "clobazam"
          },
          {
            "code" : "N05BA11",
            "display" : "prazepam"
          },
          {
            "code" : "N05BA22",
            "display" : "cloxazolam"
          },
          {
            "code" : "N05CD04",
            "display" : "estazolam"
          },
          {
            "code" : "N05CF03",
            "display" : "zaleplon"
          },
          {
            "code" : "N06AA03",
            "display" : "imipramine oxide"
          },
          {
            "code" : "N06AA16",
            "display" : "dosulepin"
          },
          {
            "code" : "N06AB04",
            "display" : "citalopram"
          },
          {
            "code" : "N06AX16",
            "display" : "venlafaxine"
          },
          {
            "code" : "N06CA02",
            "display" : "melitracen and psycholeptics"
          },
          {
            "code" : "N06DA04",
            "display" : "galantamine"
          },
          {
            "code" : "N07AA01",
            "display" : "neostigmine"
          },
          {
            "code" : "N07AX01",
            "display" : "pilocarpine"
          },
          {
            "code" : "N07BA03",
            "display" : "varenicline"
          },
          {
            "code" : "N07CA02",
            "display" : "cinnarizine"
          },
          {
            "code" : "N07XX06",
            "display" : "tetrabenazine"
          },
          {
            "code" : "N07XX11",
            "display" : "pitolisant"
          },
          {
            "code" : "N07XX59",
            "display" : "dextromethorphan, combinations"
          },
          {
            "code" : "P01AA02",
            "display" : "clioquinol"
          },
          {
            "code" : "P01AB01",
            "display" : "metronidazole"
          },
          {
            "code" : "P03AA",
            "display" : "Sulfur containing products"
          },
          {
            "code" : "P03AB02",
            "display" : "lindane"
          },
          {
            "code" : "P03AC03",
            "display" : "phenothrin"
          },
          {
            "code" : "R01AA07",
            "display" : "xylometazoline"
          },
          {
            "code" : "R01AB06",
            "display" : "xylometazoline"
          },
          {
            "code" : "R01AC02",
            "display" : "levocabastine"
          },
          {
            "code" : "R01AD",
            "display" : "Corticosteroids"
          },
          {
            "code" : "R01AD01",
            "display" : "beclometasone"
          },
          {
            "code" : "R01AD12",
            "display" : "fluticasone furoate"
          },
          {
            "code" : "R01AX02",
            "display" : "retinol"
          },
          {
            "code" : "R02AA02",
            "display" : "dequalinium"
          },
          {
            "code" : "R02AB02",
            "display" : "tyrothricin"
          },
          {
            "code" : "R02AX02",
            "display" : "ibuprofen"
          },
          {
            "code" : "R03AK01",
            "display" : "epinephrine and other drugs for obstructive airway diseases"
          },
          {
            "code" : "R01BA02",
            "display" : "pseudoephedrine"
          },
          {
            "code" : "R02AA16",
            "display" : "benzalkonium"
          },
          {
            "code" : "R03AB02",
            "display" : "isoprenaline"
          },
          {
            "code" : "R03AC04",
            "display" : "fenoterol"
          },
          {
            "code" : "R03AC12",
            "display" : "salmeterol"
          },
          {
            "code" : "R03AC16",
            "display" : "procaterol"
          },
          {
            "code" : "R03AL03",
            "display" : "vilanterol and umeclidinium bromide"
          },
          {
            "code" : "R03AL11",
            "display" : "formoterol, glycopyrronium bromide and budesonide"
          },
          {
            "code" : "R03AL12",
            "display" : "indacaterol, glycopyrronium bromide and mometasone"
          },
          {
            "code" : "R03CC53",
            "display" : "terbutaline, combinations"
          },
          {
            "code" : "R03DB05",
            "display" : "aminophylline and adrenergics"
          },
          {
            "code" : "R03DX03",
            "display" : "fenspiride"
          },
          {
            "code" : "R05CA",
            "display" : "Expectorants"
          },
          {
            "code" : "R05CA08",
            "display" : "creosote"
          },
          {
            "code" : "R05CA10",
            "display" : "combinations"
          },
          {
            "code" : "R05DA",
            "display" : "Opium alkaloids and derivatives"
          },
          {
            "code" : "R05DA05",
            "display" : "opium alkaloids with morphine"
          },
          {
            "code" : "R06AA57",
            "display" : "diphenylpyraline, combinations"
          },
          {
            "code" : "R06AX26",
            "display" : "fexofenadine"
          },
          {
            "code" : "R06AX27",
            "display" : "desloratadine"
          },
          {
            "code" : "R07AB02",
            "display" : "nikethamide"
          },
          {
            "code" : "S01AA19",
            "display" : "ampicillin"
          },
          {
            "code" : "S01AA27",
            "display" : "cefuroxime"
          },
          {
            "code" : "S01AA30",
            "display" : "combinations of different antibiotics"
          },
          {
            "code" : "S01AB04",
            "display" : "sulfacetamide"
          },
          {
            "code" : "S01AX04",
            "display" : "nitrofural"
          },
          {
            "code" : "S01BA03",
            "display" : "cortisone"
          },
          {
            "code" : "S01BA04",
            "display" : "prednisolone"
          },
          {
            "code" : "S01BA09",
            "display" : "clobetasone"
          },
          {
            "code" : "S01BA15",
            "display" : "fluocinolone acetonide"
          },
          {
            "code" : "S01BB02",
            "display" : "prednisolone and mydriatics"
          },
          {
            "code" : "S01BC11",
            "display" : "bromfenac"
          },
          {
            "code" : "S01CA05",
            "display" : "betamethasone and antiinfectives"
          },
          {
            "code" : "S01CA10",
            "display" : "fluocinolone acetonide and antiinfectives"
          },
          {
            "code" : "S01CB02",
            "display" : "prednisolone"
          },
          {
            "code" : "S01CC01",
            "display" : "diclofenac and antiinfectives"
          },
          {
            "code" : "S01EB02",
            "display" : "carbachol"
          },
          {
            "code" : "S01ED51",
            "display" : "timolol, combinations"
          },
          {
            "code" : "S01EE02",
            "display" : "unoprostone"
          },
          {
            "code" : "S01FA02",
            "display" : "scopolamine"
          },
          {
            "code" : "S01GA03",
            "display" : "xylometazoline"
          },
          {
            "code" : "S01GX05",
            "display" : "lodoxamide"
          },
          {
            "code" : "S01GX10",
            "display" : "epinastine"
          },
          {
            "code" : "S01HA05",
            "display" : "procaine"
          },
          {
            "code" : "S01KA",
            "display" : "Viscoelastic substances"
          },
          {
            "code" : "S01LA05",
            "display" : "aflibercept"
          },
          {
            "code" : "S01XA08",
            "display" : "acetylcysteine"
          },
          {
            "code" : "S01XA15",
            "display" : "ascorbic acid"
          },
          {
            "code" : "S02AA07",
            "display" : "neomycin"
          },
          {
            "code" : "S02CA03",
            "display" : "hydrocortisone and antiinfectives"
          },
          {
            "code" : "S03AA08",
            "display" : "chloramphenicol"
          },
          {
            "code" : "V03AB01",
            "display" : "ipecacuanha"
          },
          {
            "code" : "V03AB02",
            "display" : "nalorphine"
          },
          {
            "code" : "V03AB04",
            "display" : "pralidoxime"
          },
          {
            "code" : "V03AB17",
            "display" : "methylthioninium chloride"
          },
          {
            "code" : "V03AB21",
            "display" : "potassium iodide"
          },
          {
            "code" : "V03AB26",
            "display" : "methionine"
          },
          {
            "code" : "V03AE01",
            "display" : "polystyrene sulfonate"
          },
          {
            "code" : "V03AX03",
            "display" : "cobicistat"
          },
          {
            "code" : "V04CE01",
            "display" : "galactose"
          },
          {
            "code" : "V04CX09",
            "display" : "patent blue"
          },
          {
            "code" : "V06DC02",
            "display" : "fructose"
          },
          {
            "code" : "V09EX",
            "display" : "Other respiratory system diagnostic radiopharmaceuticals"
          },
          {
            "code" : "V09FX02",
            "display" : "sodium iodide (123I)"
          },
          {
            "code" : "V09X",
            "display" : "OTHER DIAGNOSTIC RADIOPHARMACEUTICALS"
          },
          {
            "code" : "V09XA01",
            "display" : "iodine (131I) norcholesterol"
          },
          {
            "code" : "C01CA24",
            "display" : "epinephrine"
          },
          {
            "code" : "C01DX02",
            "display" : "prenylamine"
          },
          {
            "code" : "C01EA01",
            "display" : "alprostadil"
          },
          {
            "code" : "C01EB03",
            "display" : "indometacin"
          },
          {
            "code" : "C01EB21",
            "display" : "regadenoson"
          },
          {
            "code" : "C02AA52",
            "display" : "reserpine, combinations"
          },
          {
            "code" : "C03AA02",
            "display" : "hydroflumethiazide"
          },
          {
            "code" : "C03AB03",
            "display" : "hydrochlorothiazide and potassium"
          },
          {
            "code" : "C03BA08",
            "display" : "metolazone"
          },
          {
            "code" : "C03EB02",
            "display" : "bumetanide and potassium-sparing agents"
          },
          {
            "code" : "C03XA01",
            "display" : "tolvaptan"
          },
          {
            "code" : "C04AC",
            "display" : "Nicotinic acid and derivatives"
          },
          {
            "code" : "C04AD03",
            "display" : "pentoxifylline"
          },
          {
            "code" : "C05",
            "display" : "VASOPROTECTIVES"
          },
          {
            "code" : "C05AA06",
            "display" : "fluorometholone"
          },
          {
            "code" : "C05AA11",
            "display" : "fluocinonide"
          },
          {
            "code" : "C05AD04",
            "display" : "cinchocaine"
          },
          {
            "code" : "C05AX",
            "display" : "Other agents for treatment of hemorrhoids and anal fissures for topical use"
          },
          {
            "code" : "C05B",
            "display" : "ANTIVARICOSE THERAPY"
          },
          {
            "code" : "C05CA",
            "display" : "Bioflavonoids"
          },
          {
            "code" : "C05CA01",
            "display" : "rutoside"
          },
          {
            "code" : "C05CA04",
            "display" : "troxerutin"
          },
          {
            "code" : "C07AA",
            "display" : "Beta blocking agents, non-selective"
          },
          {
            "code" : "C07AA02",
            "display" : "oxprenolol"
          },
          {
            "code" : "C07AA03",
            "display" : "pindolol"
          },
          {
            "code" : "C07AA16",
            "display" : "tertatolol"
          },
          {
            "code" : "C07AB04",
            "display" : "acebutolol"
          },
          {
            "code" : "C07AB05",
            "display" : "betaxolol"
          },
          {
            "code" : "C07BA06",
            "display" : "timolol and thiazides"
          },
          {
            "code" : "C08CA12",
            "display" : "barnidipine"
          },
          {
            "code" : "C08CA55",
            "display" : "nifedipine, combinations"
          },
          {
            "code" : "C08GA02",
            "display" : "amlodipine and diuretics"
          },
          {
            "code" : "C09AA03",
            "display" : "lisinopril"
          },
          {
            "code" : "C09AA08",
            "display" : "cilazapril"
          },
          {
            "code" : "C09DA04",
            "display" : "irbesartan and diuretics"
          },
          {
            "code" : "C09DB06",
            "display" : "losartan and amlodipine"
          },
          {
            "code" : "C09DX05",
            "display" : "valsartan and nebivolol"
          },
          {
            "code" : "C09XA53",
            "display" : "aliskiren and amlodipine"
          },
          {
            "code" : "C10AA01",
            "display" : "simvastatin"
          },
          {
            "code" : "C10AA05",
            "display" : "atorvastatin"
          },
          {
            "code" : "C10AB02",
            "display" : "bezafibrate"
          },
          {
            "code" : "C10AB06",
            "display" : "simfibrate"
          },
          {
            "code" : "C10AB09",
            "display" : "etofibrate"
          },
          {
            "code" : "C10AC",
            "display" : "Bile acid sequestrants"
          },
          {
            "code" : "C10AC04",
            "display" : "colesevelam"
          },
          {
            "code" : "C10AX02",
            "display" : "probucol"
          },
          {
            "code" : "C10AX12",
            "display" : "lomitapide"
          },
          {
            "code" : "C10AX13",
            "display" : "evolocumab"
          },
          {
            "code" : "C10BA04",
            "display" : "simvastatin and fenofibrate"
          },
          {
            "code" : "C10BA05",
            "display" : "atorvastatin and ezetimibe"
          },
          {
            "code" : "C10BX01",
            "display" : "simvastatin and acetylsalicylic acid"
          },
          {
            "code" : "C10BX04",
            "display" : "simvastatin, acetylsalicylic acid and ramipril"
          },
          {
            "code" : "C10BX16",
            "display" : "rosuvastatin and fimasartan"
          },
          {
            "code" : "D01AA01",
            "display" : "nystatin"
          },
          {
            "code" : "D01AC08",
            "display" : "ketoconazole"
          },
          {
            "code" : "D01AC10",
            "display" : "bifonazole"
          },
          {
            "code" : "D01AE14",
            "display" : "ciclopirox"
          },
          {
            "code" : "D01AE18",
            "display" : "tolnaftate"
          },
          {
            "code" : "D01AE54",
            "display" : "undecylenic acid, combinations"
          },
          {
            "code" : "D01BA02",
            "display" : "terbinafine"
          },
          {
            "code" : "D02AB",
            "display" : "Zinc products"
          },
          {
            "code" : "D02AE",
            "display" : "Carbamide products"
          },
          {
            "code" : "D02BA02",
            "display" : "octinoxate"
          },
          {
            "code" : "D03",
            "display" : "PREPARATIONS FOR TREATMENT OF WOUNDS AND ULCERS"
          },
          {
            "code" : "D03AA",
            "display" : "Cod-liver oil ointments"
          },
          {
            "code" : "D03AX01",
            "display" : "cadexomer iodine"
          },
          {
            "code" : "D03AX04",
            "display" : "calcium pantothenate"
          },
          {
            "code" : "D03B",
            "display" : "ENZYMES"
          },
          {
            "code" : "D04AA14",
            "display" : "clemastine"
          },
          {
            "code" : "D04AA34",
            "display" : "chlorphenoxamine"
          },
          {
            "code" : "D05AX05",
            "display" : "tazarotene"
          },
          {
            "code" : "D05AX52",
            "display" : "calcipotriol, combinations"
          },
          {
            "code" : "D06AA02",
            "display" : "chlortetracycline"
          },
          {
            "code" : "D06AX",
            "display" : "Other antibiotics for topical use"
          },
          {
            "code" : "D06BB02",
            "display" : "tromantadine"
          },
          {
            "code" : "D06BB06",
            "display" : "penciclovir"
          },
          {
            "code" : "D07BB04",
            "display" : "hydrocortisone butyrate and antiseptics"
          },
          {
            "code" : "D07CA",
            "display" : "Corticosteroids, weak, combinations with antibiotics"
          },
          {
            "code" : "D07CD01",
            "display" : "clobetasol and antibiotics"
          },
          {
            "code" : "D07XA02",
            "display" : "prednisolone"
          },
          {
            "code" : "D08AE",
            "display" : "Phenol and derivatives"
          },
          {
            "code" : "D08AJ02",
            "display" : "cetrimonium"
          },
          {
            "code" : "D08AJ04",
            "display" : "cetrimide"
          },
          {
            "code" : "D08AJ58",
            "display" : "benzethonium chloride, combinations"
          },
          {
            "code" : "D09AA",
            "display" : "Medicated dressings with antiinfectives"
          },
          {
            "code" : "D09AA09",
            "display" : "povidone-iodine"
          },
          {
            "code" : "D10AD",
            "display" : "Retinoids for topical use in acne"
          },
          {
            "code" : "D10AD04",
            "display" : "isotretinoin"
          },
          {
            "code" : "D10AE01",
            "display" : "benzoyl peroxide"
          },
          {
            "code" : "D10AE51",
            "display" : "benzoyl peroxide, combinations"
          },
          {
            "code" : "D10AX02",
            "display" : "resorcinol"
          },
          {
            "code" : "D11AC",
            "display" : "Medicated shampoos"
          },
          {
            "code" : "D11AE",
            "display" : "Androgens for topical use"
          },
          {
            "code" : "D11AH06",
            "display" : "crisaborole"
          },
          {
            "code" : "D11AX05",
            "display" : "magnesium sulfate"
          },
          {
            "code" : "D11AX18",
            "display" : "diclofenac"
          },
          {
            "code" : "D11AX57",
            "display" : "collagen, combinations"
          },
          {
            "code" : "G01AD03",
            "display" : "ascorbic acid"
          },
          {
            "code" : "G01AE01",
            "display" : "sulfatolamide"
          },
          {
            "code" : "G01AF04",
            "display" : "miconazole"
          },
          {
            "code" : "G01AX02",
            "display" : "inosine"
          },
          {
            "code" : "G02AB",
            "display" : "Ergot alkaloids"
          },
          {
            "code" : "G02AB03",
            "display" : "ergometrine"
          },
          {
            "code" : "G02AC01",
            "display" : "methylergometrine and oxytocin"
          },
          {
            "code" : "G02AD",
            "display" : "Prostaglandins"
          },
          {
            "code" : "G02CC02",
            "display" : "naproxen"
          },
          {
            "code" : "G03AA02",
            "display" : "quingestanol and ethinylestradiol"
          },
          {
            "code" : "J01FA06",
            "display" : "roxithromycin"
          },
          {
            "code" : "J01FA10",
            "display" : "azithromycin"
          },
          {
            "code" : "J01MA02",
            "display" : "ciprofloxacin"
          },
          {
            "code" : "J01MB05",
            "display" : "oxolinic acid"
          },
          {
            "code" : "J01XA02",
            "display" : "teicoplanin"
          },
          {
            "code" : "J01XX11",
            "display" : "tedizolid"
          },
          {
            "code" : "J02AC04",
            "display" : "posaconazole"
          },
          {
            "code" : "J02AX05",
            "display" : "micafungin"
          },
          {
            "code" : "J04AA",
            "display" : "Aminosalicylic acid and derivatives"
          },
          {
            "code" : "J04AB02",
            "display" : "rifampicin"
          },
          {
            "code" : "J04BA02",
            "display" : "dapsone"
          },
          {
            "code" : "J05AB",
            "display" : "Nucleosides and nucleotides excl. reverse transcriptase inhibitors"
          },
          {
            "code" : "J05AE",
            "display" : "Protease inhibitors"
          },
          {
            "code" : "J05AE03",
            "display" : "ritonavir"
          },
          {
            "code" : "J05AP07",
            "display" : "daclatasvir"
          },
          {
            "code" : "J05AP08",
            "display" : "sofosbuvir"
          },
          {
            "code" : "J05AP51",
            "display" : "sofosbuvir and ledipasvir"
          },
          {
            "code" : "J05AP56",
            "display" : "sofosbuvir, velpatasvir and voxilaprevir"
          },
          {
            "code" : "J05AR25",
            "display" : "lamivudine and dolutegravir"
          },
          {
            "code" : "J05AX29",
            "display" : "fostemsavir"
          },
          {
            "code" : "J06B",
            "display" : "IMMUNOGLOBULINS"
          },
          {
            "code" : "J07AG52",
            "display" : "haemophilus influenzae B, combinations with pertussis and toxoids"
          },
          {
            "code" : "J07AH07",
            "display" : "meningococcus C, purified polysaccharides antigen conjugated"
          },
          {
            "code" : "J07AH08",
            "display" : "meningococcus A,C,Y,W-135, tetravalent purified polysaccharides antigen conjugated"
          },
          {
            "code" : "J07AL01",
            "display" : "pneumococcus, purified polysaccharides antigen"
          },
          {
            "code" : "J07BD01",
            "display" : "measles, live attenuated"
          },
          {
            "code" : "J07BF01",
            "display" : "poliomyelitis oral, monovalent, live attenuated"
          },
          {
            "code" : "J07BF03",
            "display" : "poliomyelitis, trivalent, inactivated, whole virus"
          },
          {
            "code" : "J07BF04",
            "display" : "poliomyelitis oral, bivalent, live attenuated"
          },
          {
            "code" : "L01BB03",
            "display" : "tioguanine"
          },
          {
            "code" : "L01BB06",
            "display" : "clofarabine"
          },
          {
            "code" : "L01BC",
            "display" : "Pyrimidine analogues"
          },
          {
            "code" : "L01BC52",
            "display" : "fluorouracil, combinations"
          },
          {
            "code" : "L01CA02",
            "display" : "vincristine"
          },
          {
            "code" : "L01CB01",
            "display" : "etoposide"
          },
          {
            "code" : "L01CD01",
            "display" : "paclitaxel"
          },
          {
            "code" : "L01DB03",
            "display" : "epirubicin"
          },
          {
            "code" : "L01EA05",
            "display" : "ponatinib"
          },
          {
            "code" : "L01EB02",
            "display" : "erlotinib"
          },
          {
            "code" : "L01EH02",
            "display" : "neratinib"
          },
          {
            "code" : "L01EX14",
            "display" : "entrectinib"
          },
          {
            "code" : "L01EX18",
            "display" : "avapritinib"
          },
          {
            "code" : "L01XC06",
            "display" : "cetuximab"
          },
          {
            "code" : "L01XC07",
            "display" : "bevacizumab"
          },
          {
            "code" : "L01XC16",
            "display" : "dinutuximab beta"
          },
          {
            "code" : "L01XC21",
            "display" : "ramucirumab"
          },
          {
            "code" : "L01XC28",
            "display" : "durvalumab"
          },
          {
            "code" : "L01XC41",
            "display" : "trastuzumab deruxtecan"
          },
          {
            "code" : "L01XG02",
            "display" : "carfilzomib"
          },
          {
            "code" : "L01XK04",
            "display" : "talazoparib"
          },
          {
            "code" : "L01XX41",
            "display" : "eribulin"
          },
          {
            "code" : "L01XX44",
            "display" : "aflibercept"
          },
          {
            "code" : "L01XY02",
            "display" : "pertuzumab and trastuzumab"
          },
          {
            "code" : "L02AB02",
            "display" : "medroxyprogesterone"
          },
          {
            "code" : "L02AE04",
            "display" : "triptorelin"
          },
          {
            "code" : "L02BA01",
            "display" : "tamoxifen"
          },
          {
            "code" : "L02BA02",
            "display" : "toremifene"
          },
          {
            "code" : "L03AA02",
            "display" : "filgrastim"
          },
          {
            "code" : "L03AA10",
            "display" : "lenograstim"
          },
          {
            "code" : "L03AA13",
            "display" : "pegfilgrastim"
          },
          {
            "code" : "L03AB08",
            "display" : "interferon beta-1b"
          },
          {
            "code" : "L04AA13",
            "display" : "leflunomide"
          },
          {
            "code" : "L04AA23",
            "display" : "natalizumab"
          },
          {
            "code" : "L04AA24",
            "display" : "abatacept"
          },
          {
            "code" : "L04AX06",
            "display" : "pomalidomide"
          },
          {
            "code" : "L04AX07",
            "display" : "dimethyl fumarate"
          },
          {
            "code" : "M01AB01",
            "display" : "indometacin"
          },
          {
            "code" : "M01AB02",
            "display" : "sulindac"
          },
          {
            "code" : "M01AC56",
            "display" : "meloxicam, combinations"
          },
          {
            "code" : "M01AE16",
            "display" : "alminoprofen"
          },
          {
            "code" : "M01AH01",
            "display" : "celecoxib"
          },
          {
            "code" : "M01AX07",
            "display" : "benzydamine"
          },
          {
            "code" : "M02A",
            "display" : "TOPICAL PRODUCTS FOR JOINT AND MUSCULAR PAIN"
          },
          {
            "code" : "M02AA26",
            "display" : "nimesulide"
          },
          {
            "code" : "M03BA52",
            "display" : "carisoprodol, combinations excl. psycholeptics"
          },
          {
            "code" : "M03BC51",
            "display" : "orphenadrine, combinations"
          },
          {
            "code" : "M03BX02",
            "display" : "tizanidine"
          },
          {
            "code" : "M05BB04",
            "display" : "risedronic acid, calcium and colecalciferol, sequential"
          },
          {
            "code" : "M05BB06",
            "display" : "alendronic acid and alfacalcidol, sequential"
          },
          {
            "code" : "N01AF01",
            "display" : "methohexital"
          },
          {
            "code" : "N01AX13",
            "display" : "nitrous oxide"
          },
          {
            "code" : "N01BA",
            "display" : "Esters of aminobenzoic acid"
          },
          {
            "code" : "N01BB01",
            "display" : "bupivacaine"
          },
          {
            "code" : "N02AJ01",
            "display" : "dihydrocodeine and paracetamol"
          },
          {
            "code" : "N02BA03",
            "display" : "choline salicylate"
          },
          {
            "code" : "N02BB03",
            "display" : "aminophenazone"
          },
          {
            "code" : "N02BE03",
            "display" : "phenacetin"
          },
          {
            "code" : "N02BE71",
            "display" : "paracetamol, combinations with psycholeptics"
          },
          {
            "code" : "N02BG06",
            "display" : "nefopam"
          },
          {
            "code" : "N02BG09",
            "display" : "methoxyflurane"
          },
          {
            "code" : "N02CA01",
            "display" : "dihydroergotamine"
          },
          {
            "code" : "N02CC04",
            "display" : "rizatriptan"
          },
          {
            "code" : "N03AB02",
            "display" : "phenytoin"
          },
          {
            "code" : "N03AG04",
            "display" : "vigabatrin"
          },
          {
            "code" : "N03AX15",
            "display" : "zonisamide"
          },
          {
            "code" : "N03AX22",
            "display" : "perampanel"
          },
          {
            "code" : "N04BA06",
            "display" : "etilevodopa and decarboxylase inhibitor"
          },
          {
            "code" : "N04BC02",
            "display" : "pergolide"
          },
          {
            "code" : "N05AB03",
            "display" : "perphenazine"
          },
          {
            "code" : "N05AD01",
            "display" : "haloperidol"
          },
          {
            "code" : "N05BA12",
            "display" : "alprazolam"
          },
          {
            "code" : "N05CA01",
            "display" : "pentobarbital"
          },
          {
            "code" : "N05CC01",
            "display" : "chloral hydrate"
          },
          {
            "code" : "N05CF02",
            "display" : "zolpidem"
          },
          {
            "code" : "L01EA03",
            "display" : "nilotinib"
          },
          {
            "code" : "L01EC02",
            "display" : "dabrafenib"
          },
          {
            "code" : "L01ED03",
            "display" : "alectinib"
          },
          {
            "code" : "L01EF03",
            "display" : "abemaciclib"
          },
          {
            "code" : "L01EX02",
            "display" : "sorafenib"
          },
          {
            "code" : "L01EX03",
            "display" : "pazopanib"
          },
          {
            "code" : "L01EX15",
            "display" : "pexidartinib"
          },
          {
            "code" : "L01EX20",
            "display" : "pemigatinib"
          },
          {
            "code" : "L01XC03",
            "display" : "trastuzumab"
          },
          {
            "code" : "L01XC12",
            "display" : "brentuximab vedotin"
          },
          {
            "code" : "L01XC19",
            "display" : "blinatumomab"
          },
          {
            "code" : "L01XG01",
            "display" : "bortezomib"
          },
          {
            "code" : "L01XX27",
            "display" : "arsenic trioxide"
          },
          {
            "code" : "L02AA03",
            "display" : "ethinylestradiol"
          },
          {
            "code" : "L02AB01",
            "display" : "megestrol"
          },
          {
            "code" : "L02BG01",
            "display" : "aminoglutethimide"
          },
          {
            "code" : "L03AB10",
            "display" : "peginterferon alfa-2b"
          },
          {
            "code" : "L03AX15",
            "display" : "mifamurtide"
          },
          {
            "code" : "L04AA04",
            "display" : "antithymocyte immunoglobulin (rabbit)"
          },
          {
            "code" : "L04AA21",
            "display" : "efalizumab"
          },
          {
            "code" : "L04AA40",
            "display" : "cladribine"
          },
          {
            "code" : "L04AA42",
            "display" : "siponimod"
          },
          {
            "code" : "L04AA44",
            "display" : "upadacitinib"
          },
          {
            "code" : "L04AB04",
            "display" : "adalimumab"
          },
          {
            "code" : "L04AC05",
            "display" : "ustekinumab"
          },
          {
            "code" : "M01AA01",
            "display" : "phenylbutazone"
          },
          {
            "code" : "M01AB08",
            "display" : "etodolac"
          },
          {
            "code" : "M01AB11",
            "display" : "acemetacin"
          },
          {
            "code" : "M01AE04",
            "display" : "fenoprofen"
          },
          {
            "code" : "M01AE17",
            "display" : "dexketoprofen"
          },
          {
            "code" : "M01AH04",
            "display" : "parecoxib"
          },
          {
            "code" : "M01BX",
            "display" : "Other antiinflammatory/antirheumatic agents in combination with other drugs"
          },
          {
            "code" : "M02AA05",
            "display" : "benzydamine"
          },
          {
            "code" : "M02AA09",
            "display" : "bufexamac"
          },
          {
            "code" : "M02AA21",
            "display" : "tolmetin"
          },
          {
            "code" : "M02AX",
            "display" : "Other topical products for joint and muscular pain"
          },
          {
            "code" : "M03AB01",
            "display" : "suxamethonium"
          },
          {
            "code" : "M03AC10",
            "display" : "mivacurium chloride"
          },
          {
            "code" : "M03AC11",
            "display" : "cisatracurium"
          },
          {
            "code" : "M03AX01",
            "display" : "botulinum toxin"
          },
          {
            "code" : "M03BX08",
            "display" : "cyclobenzaprine"
          },
          {
            "code" : "M03BX09",
            "display" : "eperisone"
          },
          {
            "code" : "M04AB",
            "display" : "Preparations increasing uric acid excretion"
          },
          {
            "code" : "M04AB02",
            "display" : "sulfinpyrazone"
          },
          {
            "code" : "M05BA03",
            "display" : "pamidronic acid"
          },
          {
            "code" : "M05BA04",
            "display" : "alendronic acid"
          },
          {
            "code" : "M05BA07",
            "display" : "risedronic acid"
          },
          {
            "code" : "M05BX03",
            "display" : "strontium ranelate"
          },
          {
            "code" : "M09AB",
            "display" : "Enzymes"
          },
          {
            "code" : "N01AH02",
            "display" : "alfentanil"
          },
          {
            "code" : "N01AH06",
            "display" : "remifentanil"
          },
          {
            "code" : "N01BA03",
            "display" : "tetracaine"
          },
          {
            "code" : "N01BB08",
            "display" : "articaine"
          },
          {
            "code" : "N01BB10",
            "display" : "levobupivacaine"
          },
          {
            "code" : "N01BB51",
            "display" : "bupivacaine, combinations"
          },
          {
            "code" : "N02AA02",
            "display" : "opium"
          },
          {
            "code" : "N02AA03",
            "display" : "hydromorphone"
          },
          {
            "code" : "N02AJ02",
            "display" : "dihydrocodeine and acetylsalicylic acid"
          },
          {
            "code" : "N02BA01",
            "display" : "acetylsalicylic acid"
          },
          {
            "code" : "N02BA75",
            "display" : "salicylamide, combinations with psycholeptics"
          },
          {
            "code" : "N02BB04",
            "display" : "propyphenazone"
          },
          {
            "code" : "N02BE05",
            "display" : "propacetamol"
          },
          {
            "code" : "N02BE51",
            "display" : "paracetamol, combinations excl. psycholeptics"
          },
          {
            "code" : "N02BE54",
            "display" : "bucetin, combinations excl. psycholeptics"
          },
          {
            "code" : "N02CA02",
            "display" : "ergotamine"
          },
          {
            "code" : "N03AG06",
            "display" : "tiagabine"
          },
          {
            "code" : "N03AX14",
            "display" : "levetiracetam"
          },
          {
            "code" : "N03AX16",
            "display" : "pregabalin"
          },
          {
            "code" : "N04AA01",
            "display" : "trihexyphenidyl"
          },
          {
            "code" : "N04BC05",
            "display" : "pramipexole"
          },
          {
            "code" : "N04BC09",
            "display" : "rotigotine"
          },
          {
            "code" : "N04BX04",
            "display" : "opicapone"
          },
          {
            "code" : "N05AB02",
            "display" : "fluphenazine"
          },
          {
            "code" : "N05AB06",
            "display" : "trifluoperazine"
          },
          {
            "code" : "N05AD08",
            "display" : "droperidol"
          },
          {
            "code" : "N05AH04",
            "display" : "quetiapine"
          },
          {
            "code" : "N05AL01",
            "display" : "sulpiride"
          },
          {
            "code" : "N05BA02",
            "display" : "chlordiazepoxide"
          },
          {
            "code" : "N05BA05",
            "display" : "potassium clorazepate"
          },
          {
            "code" : "N05BB01",
            "display" : "hydroxyzine"
          },
          {
            "code" : "N05BC01",
            "display" : "meprobamate"
          },
          {
            "code" : "N05BD01",
            "display" : "benzoctamine"
          },
          {
            "code" : "N05BE01",
            "display" : "buspirone"
          },
          {
            "code" : "N05CA19",
            "display" : "thiopental"
          },
          {
            "code" : "N05CD",
            "display" : "Benzodiazepine derivatives"
          },
          {
            "code" : "N05CD08",
            "display" : "midazolam"
          },
          {
            "code" : "N05CM",
            "display" : "Other hypnotics and sedatives"
          },
          {
            "code" : "N06AA10",
            "display" : "nortriptyline"
          },
          {
            "code" : "N06AA14",
            "display" : "melitracen"
          },
          {
            "code" : "N06AX12",
            "display" : "bupropion"
          },
          {
            "code" : "N06AX21",
            "display" : "duloxetine"
          },
          {
            "code" : "N06BC01",
            "display" : "caffeine"
          },
          {
            "code" : "N06BX06",
            "display" : "citicoline"
          },
          {
            "code" : "N06DA02",
            "display" : "donepezil"
          },
          {
            "code" : "N06DX01",
            "display" : "memantine"
          },
          {
            "code" : "N07CA",
            "display" : "Antivertigo preparations"
          },
          {
            "code" : "N07CA01",
            "display" : "betahistine"
          },
          {
            "code" : "N07XX02",
            "display" : "riluzole"
          },
          {
            "code" : "P01CX01",
            "display" : "pentamidine isethionate"
          },
          {
            "code" : "P02BA01",
            "display" : "praziquantel"
          },
          {
            "code" : "P02CX01",
            "display" : "pyrvinium"
          },
          {
            "code" : "R01AA04",
            "display" : "phenylephrine"
          },
          {
            "code" : "R01AA09",
            "display" : "tramazoline"
          },
          {
            "code" : "R01AB05",
            "display" : "ephedrine"
          },
          {
            "code" : "R01AC01",
            "display" : "cromoglicic acid"
          },
          {
            "code" : "R01AD03",
            "display" : "dexamethasone"
          },
          {
            "code" : "R01AD07",
            "display" : "tixocortol"
          },
          {
            "code" : "R01AX03",
            "display" : "ipratropium bromide"
          },
          {
            "code" : "R02AA",
            "display" : "Antiseptics"
          },
          {
            "code" : "R03AK08",
            "display" : "formoterol and beclometasone"
          },
          {
            "code" : "R03AK12",
            "display" : "salmeterol and budesonide"
          },
          {
            "code" : "R03BA04",
            "display" : "betamethasone"
          },
          {
            "code" : "R03BA07",
            "display" : "mometasone"
          },
          {
            "code" : "R03BB05",
            "display" : "aclidinium bromide"
          },
          {
            "code" : "R03CC07",
            "display" : "pirbuterol"
          },
          {
            "code" : "R03DA04",
            "display" : "theophylline"
          },
          {
            "code" : "R03DC53",
            "display" : "montelukast, combinations"
          },
          {
            "code" : "J01ED",
            "display" : "Long-acting sulfonamides"
          },
          {
            "code" : "J01ED03",
            "display" : "sulfametomidine"
          },
          {
            "code" : "J01ED07",
            "display" : "sulfamerazine"
          },
          {
            "code" : "J01EE03",
            "display" : "sulfametrole and trimethoprim"
          },
          {
            "code" : "J01FA01",
            "display" : "erythromycin"
          },
          {
            "code" : "J01FA05",
            "display" : "oleandomycin"
          },
          {
            "code" : "J01FF01",
            "display" : "clindamycin"
          },
          {
            "code" : "J01MA09",
            "display" : "sparfloxacin"
          },
          {
            "code" : "J01XA01",
            "display" : "vancomycin"
          },
          {
            "code" : "J01XB02",
            "display" : "polymyxin B"
          },
          {
            "code" : "J01XX10",
            "display" : "bacitracin"
          },
          {
            "code" : "J02AB02",
            "display" : "ketoconazole"
          },
          {
            "code" : "J02AC05",
            "display" : "isavuconazole"
          },
          {
            "code" : "J02AX01",
            "display" : "flucytosine"
          },
          {
            "code" : "J02AX04",
            "display" : "caspofungin"
          },
          {
            "code" : "J04AB01",
            "display" : "cycloserine"
          },
          {
            "code" : "J04AB05",
            "display" : "rifapentine"
          },
          {
            "code" : "J04AM06",
            "display" : "rifampicin, pyrazinamide, ethambutol and isoniazid"
          },
          {
            "code" : "J05AB09",
            "display" : "famciclovir"
          },
          {
            "code" : "J05AB11",
            "display" : "valaciclovir"
          },
          {
            "code" : "J05AE02",
            "display" : "indinavir"
          },
          {
            "code" : "J05AE04",
            "display" : "nelfinavir"
          },
          {
            "code" : "J05AF01",
            "display" : "zidovudine"
          },
          {
            "code" : "J05AF11",
            "display" : "telbivudine"
          },
          {
            "code" : "J05AG04",
            "display" : "etravirine"
          },
          {
            "code" : "J05AG05",
            "display" : "rilpivirine"
          },
          {
            "code" : "J05AH01",
            "display" : "zanamivir"
          },
          {
            "code" : "J05AH03",
            "display" : "peramivir"
          },
          {
            "code" : "J05AR02",
            "display" : "lamivudine and abacavir"
          },
          {
            "code" : "J05AR03",
            "display" : "tenofovir disoproxil and emtricitabine"
          },
          {
            "code" : "J05AR04",
            "display" : "zidovudine, lamivudine and abacavir"
          },
          {
            "code" : "J05AR05",
            "display" : "zidovudine, lamivudine and nevirapine"
          },
          {
            "code" : "J05AR06",
            "display" : "emtricitabine, tenofovir disoproxil and efavirenz"
          },
          {
            "code" : "J05AR18",
            "display" : "emtricitabine, tenofovir alafenamide, elvitegravir and cobicistat"
          },
          {
            "code" : "J07AG",
            "display" : "Haemophilus influenzae B vaccines"
          },
          {
            "code" : "J07AL",
            "display" : "Pneumococcal vaccines"
          },
          {
            "code" : "J07AX",
            "display" : "Other bacterial vaccines"
          },
          {
            "code" : "J07BD54",
            "display" : "measles, combinations with mumps, rubella and varicella, live attenuated"
          },
          {
            "code" : "J07BJ01",
            "display" : "rubella, live attenuated"
          },
          {
            "code" : "L01AA03",
            "display" : "melphalan"
          },
          {
            "code" : "L01AB01",
            "display" : "busulfan"
          },
          {
            "code" : "L01BA03",
            "display" : "raltitrexed"
          },
          {
            "code" : "L01BC03",
            "display" : "tegafur"
          },
          {
            "code" : "L01BC05",
            "display" : "gemcitabine"
          },
          {
            "code" : "L01CA03",
            "display" : "vindesine"
          },
          {
            "code" : "L01DA01",
            "display" : "dactinomycin"
          },
          {
            "code" : "L01DB01",
            "display" : "doxorubicin"
          },
          {
            "code" : "L01DC03",
            "display" : "mitomycin"
          },
          {
            "code" : "L01ED01",
            "display" : "crizotinib"
          },
          {
            "code" : "L01EE01",
            "display" : "trametinib"
          },
          {
            "code" : "L01EJ02",
            "display" : "fedratinib"
          },
          {
            "code" : "L01EK01",
            "display" : "axitinib"
          },
          {
            "code" : "L01EX12",
            "display" : "larotrectinib"
          },
          {
            "code" : "L01EX16",
            "display" : "erdafitinib"
          },
          {
            "code" : "L01XB01",
            "display" : "procarbazine"
          },
          {
            "code" : "L01XC02",
            "display" : "rituximab"
          },
          {
            "code" : "L01XC10",
            "display" : "ofatumumab"
          },
          {
            "code" : "L01XC38",
            "display" : "isatuximab"
          },
          {
            "code" : "L03AB09",
            "display" : "interferon alfacon-1"
          },
          {
            "code" : "L03AC01",
            "display" : "aldesleukin"
          },
          {
            "code" : "L03AX03",
            "display" : "BCG vaccine"
          },
          {
            "code" : "L04AA45",
            "display" : "filgotinib"
          },
          {
            "code" : "L04AB06",
            "display" : "golimumab"
          },
          {
            "code" : "L04AC07",
            "display" : "tocilizumab"
          },
          {
            "code" : "L04AC11",
            "display" : "siltuximab"
          },
          {
            "code" : "L04AC19",
            "display" : "satralizumab"
          },
          {
            "code" : "L04AX02",
            "display" : "thalidomide"
          },
          {
            "code" : "M01AB17",
            "display" : "bufexamac"
          },
          {
            "code" : "M01AE07",
            "display" : "suprofen"
          },
          {
            "code" : "M01AE11",
            "display" : "tiaprofenic acid"
          },
          {
            "code" : "M01AE56",
            "display" : "naproxen and misoprostol"
          },
          {
            "code" : "M01AX",
            "display" : "Other antiinflammatory and antirheumatic agents, non-steroids"
          },
          {
            "code" : "M01AX05",
            "display" : "glucosamine"
          },
          {
            "code" : "M01AX17",
            "display" : "nimesulide"
          },
          {
            "code" : "M01AX25",
            "display" : "chondroitin sulfate"
          },
          {
            "code" : "M01CC01",
            "display" : "penicillamine"
          },
          {
            "code" : "M02AA",
            "display" : "Antiinflammatory preparations, non-steroids for topical use"
          },
          {
            "code" : "M02AA06",
            "display" : "etofenamate"
          },
          {
            "code" : "M02AA13",
            "display" : "ibuprofen"
          },
          {
            "code" : "M02AA23",
            "display" : "indometacin"
          },
          {
            "code" : "M03BB52",
            "display" : "chlormezanone, combinations excl. psycholeptics"
          },
          {
            "code" : "M04A",
            "display" : "ANTIGOUT PREPARATIONS"
          },
          {
            "code" : "M05BB05",
            "display" : "alendronic acid, calcium and colecalciferol, sequential"
          },
          {
            "code" : "M05BX06",
            "display" : "romosozumab"
          },
          {
            "code" : "N01AF",
            "display" : "Barbiturates, plain"
          },
          {
            "code" : "N01BB02",
            "display" : "lidocaine"
          },
          {
            "code" : "N01BB04",
            "display" : "prilocaine"
          },
          {
            "code" : "N01BB20",
            "display" : "combinations"
          },
          {
            "code" : "N01BB52",
            "display" : "lidocaine, combinations"
          },
          {
            "code" : "N01BX03",
            "display" : "phenol"
          },
          {
            "code" : "N01BX04",
            "display" : "capsaicin"
          },
          {
            "code" : "N02AA",
            "display" : "Natural opium alkaloids"
          },
          {
            "code" : "N02B",
            "display" : "OTHER ANALGESICS AND ANTIPYRETICS"
          },
          {
            "code" : "N02BB52",
            "display" : "metamizole sodium, combinations excl. psycholeptics"
          },
          {
            "code" : "N02BE74",
            "display" : "bucetin, combinations with psycholeptics"
          },
          {
            "code" : "N02CD02",
            "display" : "galcanezumab"
          },
          {
            "code" : "N02CX",
            "display" : "Other antimigraine preparations"
          },
          {
            "code" : "N03AA03",
            "display" : "primidone"
          },
          {
            "code" : "N03AX24",
            "display" : "cannabidiol"
          },
          {
            "code" : "N04BC03",
            "display" : "dihydroergocryptine mesylate"
          },
          {
            "code" : "N04BC04",
            "display" : "ropinirole"
          },
          {
            "code" : "N04BC07",
            "display" : "apomorphine"
          },
          {
            "code" : "N04BD02",
            "display" : "rasagiline"
          },
          {
            "code" : "N04BX02",
            "display" : "entacapone"
          },
          {
            "code" : "N05AB",
            "display" : "Phenothiazines with piperazine structure"
          },
          {
            "code" : "R03AL07",
            "display" : "formoterol and glycopyrronium bromide"
          },
          {
            "code" : "R03BA08",
            "display" : "ciclesonide"
          },
          {
            "code" : "R03BB07",
            "display" : "umeclidinium bromide"
          },
          {
            "code" : "R03CC05",
            "display" : "hexoprenaline"
          },
          {
            "code" : "R03DA03",
            "display" : "proxyphylline"
          },
          {
            "code" : "R03DC03",
            "display" : "montelukast"
          },
          {
            "code" : "R03DX09",
            "display" : "mepolizumab"
          },
          {
            "code" : "R05DA07",
            "display" : "noscapine"
          },
          {
            "code" : "R05DA09",
            "display" : "dextromethorphan"
          },
          {
            "code" : "R05DA20",
            "display" : "combinations"
          },
          {
            "code" : "R05DB20",
            "display" : "combinations"
          },
          {
            "code" : "R05FB",
            "display" : "Other cough suppressants and expectorants"
          },
          {
            "code" : "R05FB01",
            "display" : "cough suppressants and mucolytics"
          },
          {
            "code" : "R06AA",
            "display" : "Aminoalkyl ethers"
          },
          {
            "code" : "R06AA02",
            "display" : "diphenhydramine"
          },
          {
            "code" : "R06AA09",
            "display" : "doxylamine"
          },
          {
            "code" : "R06AE05",
            "display" : "meclozine"
          },
          {
            "code" : "R06AE55",
            "display" : "meclozine, combinations"
          },
          {
            "code" : "R06AX02",
            "display" : "cyproheptadine"
          },
          {
            "code" : "R06AX04",
            "display" : "phenindamine"
          },
          {
            "code" : "R07AX",
            "display" : "Other respiratory system products"
          },
          {
            "code" : "S01AA05",
            "display" : "tyrothricin"
          },
          {
            "code" : "S01AA20",
            "display" : "antibiotics in combination with other drugs"
          },
          {
            "code" : "S01AA21",
            "display" : "amikacin"
          },
          {
            "code" : "S01AE01",
            "display" : "ofloxacin"
          },
          {
            "code" : "S01AE07",
            "display" : "moxifloxacin"
          },
          {
            "code" : "S01BC03",
            "display" : "diclofenac"
          },
          {
            "code" : "S01CB04",
            "display" : "betamethasone"
          },
          {
            "code" : "S01EA04",
            "display" : "clonidine"
          },
          {
            "code" : "S01EA05",
            "display" : "brimonidine"
          },
          {
            "code" : "S01ED55",
            "display" : "carteolol, combinations"
          },
          {
            "code" : "S01EE03",
            "display" : "bimatoprost"
          },
          {
            "code" : "S01FA01",
            "display" : "atropine"
          },
          {
            "code" : "S01KA02",
            "display" : "hypromellose"
          },
          {
            "code" : "S01L",
            "display" : "OCULAR VASCULAR DISORDER AGENTS"
          },
          {
            "code" : "S01LA04",
            "display" : "ranibizumab"
          },
          {
            "code" : "S01XA06",
            "display" : "ethylmorphine"
          },
          {
            "code" : "S01XA13",
            "display" : "alteplase"
          },
          {
            "code" : "S01XA14",
            "display" : "heparin"
          },
          {
            "code" : "S01XA25",
            "display" : "lifitegrast"
          },
          {
            "code" : "S02AA01",
            "display" : "chloramphenicol"
          },
          {
            "code" : "S02AA03",
            "display" : "boric acid"
          },
          {
            "code" : "S02AA11",
            "display" : "polymyxin B"
          },
          {
            "code" : "S02CA06",
            "display" : "dexamethasone and antiinfectives"
          },
          {
            "code" : "S03AA01",
            "display" : "neomycin"
          },
          {
            "code" : "S03CA02",
            "display" : "prednisolone and antiinfectives"
          },
          {
            "code" : "V01AA09",
            "display" : "textiles"
          },
          {
            "code" : "V01AA11",
            "display" : "animals"
          },
          {
            "code" : "V03",
            "display" : "ALL OTHER THERAPEUTIC PRODUCTS"
          },
          {
            "code" : "V03AB25",
            "display" : "flumazenil"
          },
          {
            "code" : "V03AB33",
            "display" : "hydroxocobalamin"
          },
          {
            "code" : "V03AE",
            "display" : "Drugs for treatment of hyperkalemia and hyperphosphatemia"
          },
          {
            "code" : "V03AE02",
            "display" : "sevelamer"
          },
          {
            "code" : "V04CC02",
            "display" : "magnesium sulfate"
          },
          {
            "code" : "V06DD",
            "display" : "Amino acids, incl. combinations with polypeptides"
          },
          {
            "code" : "V06DE",
            "display" : "Amino acids/carbohydrates/minerals/vitamins, combinations"
          },
          {
            "code" : "V07A",
            "display" : "ALL OTHER NON-THERAPEUTIC PRODUCTS"
          },
          {
            "code" : "V08AA05",
            "display" : "ioxitalamic acid"
          },
          {
            "code" : "V08AB06",
            "display" : "iotrolan"
          },
          {
            "code" : "V08CA02",
            "display" : "gadoteric acid"
          },
          {
            "code" : "V08CA05",
            "display" : "mangafodipir"
          },
          {
            "code" : "V08CA10",
            "display" : "gadoxetic acid"
          },
          {
            "code" : "V08CB03",
            "display" : "iron oxide, nanoparticles"
          },
          {
            "code" : "V08DA01",
            "display" : "perflutren, human albumin microspheres"
          },
          {
            "code" : "V09BA02",
            "display" : "technetium (99mTc) medronic acid"
          },
          {
            "code" : "V09EX03",
            "display" : "xenon (133Xe) gas"
          },
          {
            "code" : "V09FX01",
            "display" : "technetium (99mTc) pertechnetate"
          },
          {
            "code" : "V09GA",
            "display" : "Technetium (99mTc) compounds"
          },
          {
            "code" : "V09IB01",
            "display" : "indium (111In) pentetreotide"
          },
          {
            "code" : "V09XX",
            "display" : "Various diagnostic radiopharmaceuticals"
          },
          {
            "code" : "V10XX03",
            "display" : "radium (223Ra) dichloride"
          },
          {
            "code" : "G03AA17",
            "display" : "medroxyprogesterone and estradiol"
          },
          {
            "code" : "G03AB",
            "display" : "Progestogens and estrogens, sequential preparations"
          },
          {
            "code" : "G03CA01",
            "display" : "ethinylestradiol"
          },
          {
            "code" : "G03DA",
            "display" : "Pregnen (4) derivatives"
          },
          {
            "code" : "G03DB03",
            "display" : "medrogestone"
          },
          {
            "code" : "G03FA04",
            "display" : "progesterone and estrogen"
          },
          {
            "code" : "G03FB09",
            "display" : "levonorgestrel and estrogen"
          },
          {
            "code" : "G03GA07",
            "display" : "lutropin alfa"
          },
          {
            "code" : "G03GA10",
            "display" : "follitropin delta"
          },
          {
            "code" : "G03GB02",
            "display" : "clomifene"
          },
          {
            "code" : "G04BX06",
            "display" : "phenazopyridine"
          },
          {
            "code" : "G04CA02",
            "display" : "tamsulosin"
          },
          {
            "code" : "G04CA03",
            "display" : "terazosin"
          },
          {
            "code" : "G04CA53",
            "display" : "tamsulosin and solifenacin"
          },
          {
            "code" : "H01CA02",
            "display" : "nafarelin"
          },
          {
            "code" : "H01CC02",
            "display" : "cetrorelix"
          },
          {
            "code" : "H02AB02",
            "display" : "dexamethasone"
          },
          {
            "code" : "H02BX",
            "display" : "Corticosteroids for systemic use, combinations"
          },
          {
            "code" : "H02BX01",
            "display" : "methylprednisolone, combinations"
          },
          {
            "code" : "H05BX01",
            "display" : "cinacalcet"
          },
          {
            "code" : "H05BX03",
            "display" : "doxercalciferol"
          },
          {
            "code" : "J01AA04",
            "display" : "lymecycline"
          },
          {
            "code" : "J01CA13",
            "display" : "ticarcillin"
          },
          {
            "code" : "J01CE02",
            "display" : "phenoxymethylpenicillin"
          },
          {
            "code" : "J01CE08",
            "display" : "benzathine benzylpenicillin"
          },
          {
            "code" : "J01CR",
            "display" : "Combinations of penicillins, incl. beta-lactamase inhibitors"
          },
          {
            "code" : "J01CR50",
            "display" : "combinations of penicillins"
          },
          {
            "code" : "J01DB07",
            "display" : "cefatrizine"
          },
          {
            "code" : "J01DC14",
            "display" : "flomoxef"
          },
          {
            "code" : "J01DH",
            "display" : "Carbapenems"
          },
          {
            "code" : "J01EE06",
            "display" : "sulfadiazine and tetroxoprim"
          },
          {
            "code" : "J01FA",
            "display" : "Macrolides"
          },
          {
            "code" : "J01FA15",
            "display" : "telithromycin"
          },
          {
            "code" : "J01GB07",
            "display" : "netilmicin"
          },
          {
            "code" : "J01GB08",
            "display" : "sisomicin"
          },
          {
            "code" : "J01MA01",
            "display" : "ofloxacin"
          },
          {
            "code" : "J01MA07",
            "display" : "lomefloxacin"
          },
          {
            "code" : "J01RA04",
            "display" : "spiramycin and metronidazole"
          },
          {
            "code" : "J01XD01",
            "display" : "metronidazole"
          },
          {
            "code" : "J01XD03",
            "display" : "ornidazole"
          },
          {
            "code" : "J01XE01",
            "display" : "nitrofurantoin"
          },
          {
            "code" : "J02AC",
            "display" : "Triazole and tetrazole derivatives"
          },
          {
            "code" : "J02AC02",
            "display" : "itraconazole"
          },
          {
            "code" : "J02AC03",
            "display" : "voriconazole"
          },
          {
            "code" : "J02AX06",
            "display" : "anidulafungin"
          },
          {
            "code" : "J04AB04",
            "display" : "rifabutin"
          },
          {
            "code" : "J04AC51",
            "display" : "isoniazid, combinations"
          },
          {
            "code" : "J04AD01",
            "display" : "protionamide"
          },
          {
            "code" : "J04AD02",
            "display" : "tiocarlide"
          },
          {
            "code" : "J05AB01",
            "display" : "aciclovir"
          },
          {
            "code" : "J05AB06",
            "display" : "ganciclovir"
          },
          {
            "code" : "J05AE01",
            "display" : "saquinavir"
          },
          {
            "code" : "J05AF05",
            "display" : "lamivudine"
          },
          {
            "code" : "J05AF08",
            "display" : "adefovir dipivoxil"
          },
          {
            "code" : "J05AF13",
            "display" : "tenofovir alafenamide"
          },
          {
            "code" : "J05AG01",
            "display" : "nevirapine"
          },
          {
            "code" : "J05AH02",
            "display" : "oseltamivir"
          },
          {
            "code" : "J05AP57",
            "display" : "glecaprevir and pibrentasvir"
          },
          {
            "code" : "J05AR10",
            "display" : "lopinavir and ritonavir"
          },
          {
            "code" : "J05AR13",
            "display" : "lamivudine, abacavir and dolutegravir"
          },
          {
            "code" : "J05AR19",
            "display" : "emtricitabine, tenofovir alafenamide and rilpivirine"
          },
          {
            "code" : "J05AR24",
            "display" : "lamivudine, tenofovir disoproxil and doravirine"
          },
          {
            "code" : "J05AX07",
            "display" : "enfuvirtide"
          },
          {
            "code" : "J05AX18",
            "display" : "letermovir"
          },
          {
            "code" : "J06AA03",
            "display" : "snake venom antiserum"
          },
          {
            "code" : "J07",
            "display" : "VACCINES"
          },
          {
            "code" : "J07AH02",
            "display" : "other meningococcal monovalent purified polysaccharides antigen"
          },
          {
            "code" : "J07AH09",
            "display" : "meningococcus B, multicomponent vaccine"
          },
          {
            "code" : "J07AJ02",
            "display" : "pertussis, purified antigen"
          },
          {
            "code" : "J07BC01",
            "display" : "hepatitis B, purified antigen"
          },
          {
            "code" : "J07BE01",
            "display" : "mumps, live attenuated"
          },
          {
            "code" : "J07BG01",
            "display" : "rabies, inactivated, whole virus"
          },
          {
            "code" : "J07BM",
            "display" : "Papillomavirus vaccines"
          },
          {
            "code" : "J07BM03",
            "display" : "papillomavirus (human types 6, 11, 16, 18, 31, 33, 45, 52, 58)"
          },
          {
            "code" : "L01AA06",
            "display" : "ifosfamide"
          },
          {
            "code" : "L01BA05",
            "display" : "pralatrexate"
          },
          {
            "code" : "L01BB04",
            "display" : "cladribine"
          },
          {
            "code" : "L01BC02",
            "display" : "fluorouracil"
          },
          {
            "code" : "L01CA04",
            "display" : "vinorelbine"
          },
          {
            "code" : "L01CD02",
            "display" : "docetaxel"
          },
          {
            "code" : "L01DC04",
            "display" : "ixabepilone"
          },
          {
            "code" : "L01EA02",
            "display" : "dasatinib"
          },
          {
            "code" : "L01EB07",
            "display" : "dacomitinib"
          },
          {
            "code" : "L01EG02",
            "display" : "everolimus"
          },
          {
            "code" : "L01EX05",
            "display" : "regorafenib"
          },
          {
            "code" : "L01EX07",
            "display" : "cabozantinib"
          },
          {
            "code" : "L01EX17",
            "display" : "capmatinib"
          },
          {
            "code" : "L01EX21",
            "display" : "tepotinib"
          },
          {
            "code" : "L01XA02",
            "display" : "carboplatin"
          },
          {
            "code" : "L01XD04",
            "display" : "aminolevulinic acid"
          },
          {
            "code" : "L01XK01",
            "display" : "olaparib"
          },
          {
            "code" : "L01XX11",
            "display" : "estramustine"
          },
          {
            "code" : "L01XX35",
            "display" : "anagrelide"
          },
          {
            "code" : "L02AA01",
            "display" : "diethylstilbestrol"
          },
          {
            "code" : "L02BB04",
            "display" : "enzalutamide"
          },
          {
            "code" : "L03AB04",
            "display" : "interferon alfa-2a"
          },
          {
            "code" : "L03AB07",
            "display" : "interferon beta-1a"
          },
          {
            "code" : "L04AA10",
            "display" : "sirolimus"
          },
          {
            "code" : "L04AA18",
            "display" : "everolimus"
          },
          {
            "code" : "M01AA03",
            "display" : "oxyphenbutazone"
          },
          {
            "code" : "M01AE05",
            "display" : "fenbufen"
          },
          {
            "code" : "M01AE09",
            "display" : "flurbiprofen"
          },
          {
            "code" : "M01AE52",
            "display" : "naproxen and esomeprazole"
          },
          {
            "code" : "M02AA17",
            "display" : "niflumic acid"
          },
          {
            "code" : "M02AA18",
            "display" : "meclofenamic acid"
          },
          {
            "code" : "N05CM01",
            "display" : "methaqualone"
          },
          {
            "code" : "N05CM05",
            "display" : "scopolamine"
          },
          {
            "code" : "N06AA04",
            "display" : "clomipramine"
          },
          {
            "code" : "N06AB10",
            "display" : "escitalopram"
          },
          {
            "code" : "N06AX11",
            "display" : "mirtazapine"
          },
          {
            "code" : "N06BX02",
            "display" : "pyritinol"
          },
          {
            "code" : "N06DX",
            "display" : "Other anti-dementia drugs"
          },
          {
            "code" : "P01AB51",
            "display" : "metronidazole and furazolidone"
          },
          {
            "code" : "P01CC02",
            "display" : "nitrofural"
          },
          {
            "code" : "P03AA03",
            "display" : "mesulfen"
          },
          {
            "code" : "P03AC52",
            "display" : "bioallethrin, combinations"
          },
          {
            "code" : "R01A",
            "display" : "DECONGESTANTS AND OTHER NASAL PREPARATIONS FOR TOPICAL USE"
          },
          {
            "code" : "R01AA02",
            "display" : "cyclopentamine"
          },
          {
            "code" : "R01AA14",
            "display" : "epinephrine"
          },
          {
            "code" : "R01AD09",
            "display" : "mometasone"
          },
          {
            "code" : "R01AD52",
            "display" : "prednisolone, combinations"
          },
          {
            "code" : "R02AA05",
            "display" : "chlorhexidine"
          },
          {
            "code" : "R02AA20",
            "display" : "various"
          },
          {
            "code" : "R02AD01",
            "display" : "benzocaine"
          },
          {
            "code" : "R02AX",
            "display" : "Other throat preparations"
          },
          {
            "code" : "R03A",
            "display" : "ADRENERGICS, INHALANTS"
          },
          {
            "code" : "R03AB03",
            "display" : "orciprenaline"
          },
          {
            "code" : "R03AC02",
            "display" : "salbutamol"
          },
          {
            "code" : "R03AC18",
            "display" : "indacaterol"
          },
          {
            "code" : "R03AK10",
            "display" : "vilanterol and fluticasone furoate"
          },
          {
            "code" : "R03AK11",
            "display" : "formoterol and fluticasone"
          },
          {
            "code" : "R03BA05",
            "display" : "fluticasone"
          },
          {
            "code" : "R03BX01",
            "display" : "fenspiride"
          },
          {
            "code" : "R03CB",
            "display" : "Non-selective beta-adrenoreceptor agonists"
          },
          {
            "code" : "R03CB53",
            "display" : "orciprenaline, combinations"
          },
          {
            "code" : "R03CC02",
            "display" : "salbutamol"
          },
          {
            "code" : "R03CC13",
            "display" : "clenbuterol"
          },
          {
            "code" : "R03DA05",
            "display" : "aminophylline"
          },
          {
            "code" : "R03DA51",
            "display" : "diprophylline, combinations"
          },
          {
            "code" : "R03DX05",
            "display" : "omalizumab"
          },
          {
            "code" : "R05CA03",
            "display" : "guaifenesin"
          },
          {
            "code" : "R05CB",
            "display" : "Mucolytics"
          },
          {
            "code" : "R05DB02",
            "display" : "benproperine"
          },
          {
            "code" : "R05F",
            "display" : "COUGH SUPPRESSANTS AND EXPECTORANTS, COMBINATIONS"
          },
          {
            "code" : "R06AA52",
            "display" : "diphenhydramine, combinations"
          },
          {
            "code" : "R06AD01",
            "display" : "alimemazine"
          },
          {
            "code" : "R06AE",
            "display" : "Piperazine derivatives"
          },
          {
            "code" : "S01AA17",
            "display" : "erythromycin"
          },
          {
            "code" : "S01AA26",
            "display" : "azithromycin"
          },
          {
            "code" : "S01AX",
            "display" : "Other antiinfectives"
          },
          {
            "code" : "S01B",
            "display" : "ANTIINFLAMMATORY AGENTS"
          },
          {
            "code" : "S01BB01",
            "display" : "hydrocortisone and mydriatics"
          },
          {
            "code" : "S01BC04",
            "display" : "flurbiprofen"
          },
          {
            "code" : "S01BC06",
            "display" : "piroxicam"
          },
          {
            "code" : "S01CA",
            "display" : "Corticosteroids and antiinfectives in combination"
          },
          {
            "code" : "S01CB01",
            "display" : "dexamethasone"
          },
          {
            "code" : "S01CB03",
            "display" : "hydrocortisone"
          },
          {
            "code" : "S01ED01",
            "display" : "timolol"
          },
          {
            "code" : "S01EE05",
            "display" : "tafluprost"
          },
          {
            "code" : "S01FA56",
            "display" : "tropicamide, combinations"
          },
          {
            "code" : "S01GA04",
            "display" : "oxymetazoline"
          },
          {
            "code" : "S01GA05",
            "display" : "phenylephrine"
          },
          {
            "code" : "S01HA",
            "display" : "Local anesthetics"
          },
          {
            "code" : "S01HA07",
            "display" : "lidocaine"
          },
          {
            "code" : "S01XA",
            "display" : "Other ophthalmologicals"
          },
          {
            "code" : "S01XA18",
            "display" : "ciclosporin"
          },
          {
            "code" : "S02CA05",
            "display" : "fluocinolone acetonide and antiinfectives"
          },
          {
            "code" : "S03BA01",
            "display" : "dexamethasone"
          },
          {
            "code" : "V03AB",
            "display" : "Antidotes"
          },
          {
            "code" : "V03AB05",
            "display" : "prednisolone and promethazine"
          },
          {
            "code" : "V03AC02",
            "display" : "deferiprone"
          },
          {
            "code" : "V03AE03",
            "display" : "lanthanum carbonate"
          },
          {
            "code" : "V03AX",
            "display" : "Other therapeutic products"
          },
          {
            "code" : "V04CA01",
            "display" : "tolbutamide"
          },
          {
            "code" : "V04CF01",
            "display" : "tuberculin"
          },
          {
            "code" : "V04CJ02",
            "display" : "protirelin"
          },
          {
            "code" : "V06DX",
            "display" : "Other combinations of nutrients"
          },
          {
            "code" : "V08AB07",
            "display" : "ioversol"
          },
          {
            "code" : "V08AB11",
            "display" : "iobitridol"
          },
          {
            "code" : "V08CA09",
            "display" : "gadobutrol"
          },
          {
            "code" : "V09",
            "display" : "DIAGNOSTIC RADIOPHARMACEUTICALS"
          },
          {
            "code" : "V09AA01",
            "display" : "technetium (99mTc) exametazime"
          },
          {
            "code" : "V09AA02",
            "display" : "technetium (99mTc) bicisate"
          },
          {
            "code" : "V09FX",
            "display" : "Various thyroid diagnostic radiopharmaceuticals"
          },
          {
            "code" : "V09XX01",
            "display" : "cobalt (57Co) cyanocobalamine"
          },
          {
            "code" : "V10XA",
            "display" : "Iodine (131I) compounds"
          },
          {
            "code" : "N05AB04",
            "display" : "prochlorperazine"
          },
          {
            "code" : "N05AF02",
            "display" : "clopenthixol"
          },
          {
            "code" : "N05AG02",
            "display" : "pimozide"
          },
          {
            "code" : "N05AN01",
            "display" : "lithium"
          },
          {
            "code" : "N05BA08",
            "display" : "bromazepam"
          },
          {
            "code" : "N05CA10",
            "display" : "cyclobarbital"
          },
          {
            "code" : "N05CD09",
            "display" : "brotizolam"
          },
          {
            "code" : "N05CD15",
            "display" : "nimetazepam"
          },
          {
            "code" : "N05CF04",
            "display" : "eszopiclone"
          },
          {
            "code" : "N06AA09",
            "display" : "amitriptyline"
          },
          {
            "code" : "N06AG02",
            "display" : "moclobemide"
          },
          {
            "code" : "N06AX01",
            "display" : "oxitriptan"
          },
          {
            "code" : "N06AX05",
            "display" : "trazodone"
          },
          {
            "code" : "N06AX18",
            "display" : "reboxetine"
          },
          {
            "code" : "N06BA09",
            "display" : "atomoxetine"
          },
          {
            "code" : "N06BX03",
            "display" : "piracetam"
          },
          {
            "code" : "N06CA01",
            "display" : "amitriptyline and psycholeptics"
          },
          {
            "code" : "N06DA01",
            "display" : "tacrine"
          },
          {
            "code" : "N07BC02",
            "display" : "methadone"
          },
          {
            "code" : "P01AB02",
            "display" : "tinidazole"
          },
          {
            "code" : "P01AR",
            "display" : "Arsenic compounds"
          },
          {
            "code" : "P01BA02",
            "display" : "hydroxychloroquine"
          },
          {
            "code" : "P01BC01",
            "display" : "quinine"
          },
          {
            "code" : "P01CB01",
            "display" : "meglumine antimonate"
          },
          {
            "code" : "R01AA08",
            "display" : "naphazoline"
          },
          {
            "code" : "R01AB01",
            "display" : "phenylephrine"
          },
          {
            "code" : "R01AD02",
            "display" : "prednisolone"
          },
          {
            "code" : "R01BA03",
            "display" : "phenylephrine"
          },
          {
            "code" : "R02AA06",
            "display" : "cetylpyridinium"
          },
          {
            "code" : "R02AX01",
            "display" : "flurbiprofen"
          },
          {
            "code" : "R03AC06",
            "display" : "hexoprenaline"
          },
          {
            "code" : "R03AK04",
            "display" : "salbutamol and sodium cromoglicate"
          },
          {
            "code" : "R03AL01",
            "display" : "fenoterol and ipratropium bromide"
          },
          {
            "code" : "R03AL04",
            "display" : "indacaterol and glycopyrronium bromide"
          },
          {
            "code" : "R03BA06",
            "display" : "triamcinolone"
          },
          {
            "code" : "R03BB01",
            "display" : "ipratropium bromide"
          },
          {
            "code" : "R03CC09",
            "display" : "tretoquinol"
          },
          {
            "code" : "R03CK",
            "display" : "Adrenergics and other drugs for obstructive airway diseases"
          },
          {
            "code" : "R03DA",
            "display" : "Xanthines"
          },
          {
            "code" : "R03DA01",
            "display" : "diprophylline"
          },
          {
            "code" : "R03DA02",
            "display" : "choline theophyllinate"
          },
          {
            "code" : "R03DA20",
            "display" : "combinations of xanthines"
          },
          {
            "code" : "R03DB01",
            "display" : "diprophylline and adrenergics"
          },
          {
            "code" : "R05DA04",
            "display" : "codeine"
          },
          {
            "code" : "R05DB01",
            "display" : "benzonatate"
          },
          {
            "code" : "R05DB04",
            "display" : "isoaminile"
          },
          {
            "code" : "R05DB05",
            "display" : "pentoxyverine"
          },
          {
            "code" : "R05FA01",
            "display" : "opium derivatives and mucolytics"
          },
          {
            "code" : "R06AA06",
            "display" : "chlorphenoxamine"
          },
          {
            "code" : "R06AB02",
            "display" : "dexchlorpheniramine"
          },
          {
            "code" : "R06AD02",
            "display" : "promethazine"
          },
          {
            "code" : "R06AD07",
            "display" : "mequitazine"
          },
          {
            "code" : "R06AE03",
            "display" : "cyclizine"
          },
          {
            "code" : "R06AE07",
            "display" : "cetirizine"
          },
          {
            "code" : "R06AX13",
            "display" : "loratadine"
          },
          {
            "code" : "R06AX17",
            "display" : "ketotifen"
          },
          {
            "code" : "R06AX29",
            "display" : "bilastine"
          },
          {
            "code" : "R07AB01",
            "display" : "doxapram"
          },
          {
            "code" : "S01AA09",
            "display" : "tetracycline"
          },
          {
            "code" : "S01AA12",
            "display" : "tobramycin"
          },
          {
            "code" : "S01AD01",
            "display" : "idoxuridine"
          },
          {
            "code" : "S01AE02",
            "display" : "norfloxacin"
          },
          {
            "code" : "S01BA02",
            "display" : "hydrocortisone"
          },
          {
            "code" : "S01BA13",
            "display" : "rimexolone"
          },
          {
            "code" : "S01BC",
            "display" : "Antiinflammatory agents, non-steroids"
          },
          {
            "code" : "S01BC01",
            "display" : "indometacin"
          },
          {
            "code" : "S01BC08",
            "display" : "salicylic acid"
          },
          {
            "code" : "S01C",
            "display" : "ANTIINFLAMMATORY AGENTS AND ANTIINFECTIVES IN COMBINATION"
          },
          {
            "code" : "S01CA01",
            "display" : "dexamethasone and antiinfectives"
          },
          {
            "code" : "S01E",
            "display" : "ANTIGLAUCOMA PREPARATIONS AND MIOTICS"
          },
          {
            "code" : "S01EA01",
            "display" : "epinephrine"
          },
          {
            "code" : "S01EA51",
            "display" : "epinephrine, combinations"
          },
          {
            "code" : "S01EB06",
            "display" : "neostigmine"
          },
          {
            "code" : "S01ED02",
            "display" : "betaxolol"
          },
          {
            "code" : "S01GA01",
            "display" : "naphazoline"
          },
          {
            "code" : "S01GA07",
            "display" : "brimonidine"
          },
          {
            "code" : "S01GA53",
            "display" : "xylometazoline, combinations"
          },
          {
            "code" : "S01GX",
            "display" : "Other antiallergics"
          },
          {
            "code" : "S01GX08",
            "display" : "ketotifen"
          },
          {
            "code" : "S01GX09",
            "display" : "olopatadine"
          },
          {
            "code" : "S01HA06",
            "display" : "cinchocaine"
          },
          {
            "code" : "S01XA02",
            "display" : "retinol"
          },
          {
            "code" : "S01XA05",
            "display" : "sodium edetate"
          },
          {
            "code" : "S02BA07",
            "display" : "betamethasone"
          },
          {
            "code" : "S02CA04",
            "display" : "triamcinolone and antiinfectives"
          },
          {
            "code" : "S02DA",
            "display" : "Analgesics and anesthetics"
          },
          {
            "code" : "S03AA02",
            "display" : "tetracycline"
          },
          {
            "code" : "S03AA03",
            "display" : "polymyxin B"
          },
          {
            "code" : "S03AA04",
            "display" : "chlorhexidine"
          },
          {
            "code" : "V03AE08",
            "display" : "ferric citrate"
          },
          {
            "code" : "V03AF04",
            "display" : "calcium levofolinate"
          },
          {
            "code" : "V03AF05",
            "display" : "amifostine"
          },
          {
            "code" : "V03AN01",
            "display" : "oxygen"
          },
          {
            "code" : "V04CD03",
            "display" : "sermorelin"
          },
          {
            "code" : "V04CM01",
            "display" : "gonadorelin"
          },
          {
            "code" : "V04CX",
            "display" : "Other diagnostic agents"
          },
          {
            "code" : "V04CX01",
            "display" : "indocyanine green"
          },
          {
            "code" : "V07AB",
            "display" : "Solvents and diluting agents, incl. irrigating solutions"
          },
          {
            "code" : "V08AB02",
            "display" : "iohexol"
          },
          {
            "code" : "V08CA08",
            "display" : "gadobenic acid"
          },
          {
            "code" : "V08CX",
            "display" : "Other magnetic resonance imaging contrast media"
          },
          {
            "code" : "R03DX",
            "display" : "Other systemic drugs for obstructive airway diseases"
          },
          {
            "code" : "R05CA02",
            "display" : "potassium iodide"
          },
          {
            "code" : "R05DB",
            "display" : "Other cough suppressants"
          },
          {
            "code" : "R05DB09",
            "display" : "oxeladin"
          },
          {
            "code" : "R05DB21",
            "display" : "cloperastine"
          },
          {
            "code" : "R06AB54",
            "display" : "chlorphenamine, combinations"
          },
          {
            "code" : "R06AC04",
            "display" : "tripelennamine"
          },
          {
            "code" : "R06AX25",
            "display" : "mizolastine"
          },
          {
            "code" : "S01AA",
            "display" : "Antibiotics"
          },
          {
            "code" : "S01AA01",
            "display" : "chloramphenicol"
          },
          {
            "code" : "S01AA04",
            "display" : "oxytetracycline"
          },
          {
            "code" : "S01AA10",
            "display" : "natamycin"
          },
          {
            "code" : "S01AA11",
            "display" : "gentamicin"
          },
          {
            "code" : "S01AA14",
            "display" : "benzylpenicillin"
          },
          {
            "code" : "S01AB01",
            "display" : "sulfamethizole"
          },
          {
            "code" : "S01AD03",
            "display" : "aciclovir"
          },
          {
            "code" : "S01AE03",
            "display" : "ciprofloxacin"
          },
          {
            "code" : "S01AX09",
            "display" : "chlorhexidine"
          },
          {
            "code" : "S01BA01",
            "display" : "dexamethasone"
          },
          {
            "code" : "S01EB01",
            "display" : "pilocarpine"
          },
          {
            "code" : "S01EC01",
            "display" : "acetazolamide"
          },
          {
            "code" : "S01EE01",
            "display" : "latanoprost"
          },
          {
            "code" : "S01EX",
            "display" : "Other antiglaucoma preparations"
          },
          {
            "code" : "S01FA05",
            "display" : "homatropine"
          },
          {
            "code" : "S01GA",
            "display" : "Sympathomimetics used as decongestants"
          },
          {
            "code" : "S01HA03",
            "display" : "tetracaine"
          },
          {
            "code" : "S01XA03",
            "display" : "sodium chloride, hypertonic"
          },
          {
            "code" : "S01XA04",
            "display" : "potassium iodide"
          },
          {
            "code" : "S02AA",
            "display" : "Antiinfectives"
          },
          {
            "code" : "S02AA05",
            "display" : "clioquinol"
          },
          {
            "code" : "S02BA",
            "display" : "Corticosteroids"
          },
          {
            "code" : "S02BA03",
            "display" : "prednisolone"
          },
          {
            "code" : "S02BA08",
            "display" : "fluocinolone acetonide"
          },
          {
            "code" : "S02DA01",
            "display" : "lidocaine"
          },
          {
            "code" : "S03AA07",
            "display" : "ciprofloxacin"
          },
          {
            "code" : "V03AB03",
            "display" : "edetates"
          },
          {
            "code" : "V03AE07",
            "display" : "calcium acetate"
          },
          {
            "code" : "V03AF01",
            "display" : "mesna"
          },
          {
            "code" : "V03AF03",
            "display" : "calcium folinate"
          },
          {
            "code" : "V04CL",
            "display" : "Tests for allergic diseases"
          },
          {
            "code" : "V04CX02",
            "display" : "folic acid"
          },
          {
            "code" : "V06",
            "display" : "GENERAL NUTRIENTS"
          },
          {
            "code" : "V06DC",
            "display" : "Carbohydrates"
          },
          {
            "code" : "V07",
            "display" : "ALL OTHER NON-THERAPEUTIC PRODUCTS"
          },
          {
            "code" : "V08",
            "display" : "CONTRAST MEDIA"
          },
          {
            "code" : "V08A",
            "display" : "X-RAY CONTRAST MEDIA, IODINATED"
          },
          {
            "code" : "V08AA01",
            "display" : "diatrizoic acid"
          },
          {
            "code" : "V08AB04",
            "display" : "iopamidol"
          },
          {
            "code" : "V08AB05",
            "display" : "iopromide"
          },
          {
            "code" : "V08BA",
            "display" : "Barium sulfate containing X-ray contrast media"
          },
          {
            "code" : "V08CA03",
            "display" : "gadodiamide"
          },
          {
            "code" : "V09A",
            "display" : "CENTRAL NERVOUS SYSTEM"
          },
          {
            "code" : "V09BA03",
            "display" : "technetium (99mTc) pyrophosphate"
          },
          {
            "code" : "V09CA",
            "display" : "Technetium (99mTc) compounds"
          },
          {
            "code" : "V09CX02",
            "display" : "sodium iodohippurate (131I)"
          },
          {
            "code" : "V09GA04",
            "display" : "technetium (99mTc) human albumin"
          },
          {
            "code" : "V09IX06",
            "display" : "sodium fluoride (18F)"
          },
          {
            "code" : "M02AA19",
            "display" : "flurbiprofen"
          },
          {
            "code" : "M03AC01",
            "display" : "pancuronium"
          },
          {
            "code" : "M03AC03",
            "display" : "vecuronium"
          },
          {
            "code" : "M03AC04",
            "display" : "atracurium"
          },
          {
            "code" : "M03B",
            "display" : "MUSCLE RELAXANTS, CENTRALLY ACTING AGENTS"
          },
          {
            "code" : "M03BX04",
            "display" : "tolperisone"
          },
          {
            "code" : "M04AA03",
            "display" : "febuxostat"
          },
          {
            "code" : "M04AB03",
            "display" : "benzbromarone"
          },
          {
            "code" : "M04AC01",
            "display" : "colchicine"
          },
          {
            "code" : "M05BB08",
            "display" : "zoledronic acid, calcium and colecalciferol, sequential"
          },
          {
            "code" : "M05BX04",
            "display" : "denosumab"
          },
          {
            "code" : "N01AF03",
            "display" : "thiopental"
          },
          {
            "code" : "N01AH03",
            "display" : "sufentanil"
          },
          {
            "code" : "N01AH51",
            "display" : "fentanyl, combinations"
          },
          {
            "code" : "N01AX07",
            "display" : "etomidate"
          },
          {
            "code" : "N01AX10",
            "display" : "propofol"
          },
          {
            "code" : "N01BA02",
            "display" : "procaine"
          },
          {
            "code" : "N01BA05",
            "display" : "benzocaine"
          },
          {
            "code" : "N01BA52",
            "display" : "procaine, combinations"
          },
          {
            "code" : "N01BB",
            "display" : "Amides"
          },
          {
            "code" : "N01BB54",
            "display" : "prilocaine, combinations"
          },
          {
            "code" : "N02AA55",
            "display" : "oxycodone and naloxone"
          },
          {
            "code" : "N02AA56",
            "display" : "oxycodone and naltrexone"
          },
          {
            "code" : "N02AA79",
            "display" : "codeine, combinations with psycholeptics"
          },
          {
            "code" : "N02AF",
            "display" : "Morphinan derivatives"
          },
          {
            "code" : "N02AJ15",
            "display" : "tramadol and other non-opioid analgesics"
          },
          {
            "code" : "N02BA07",
            "display" : "ethenzamide"
          },
          {
            "code" : "N02BB",
            "display" : "Pyrazolones"
          },
          {
            "code" : "N02BB74",
            "display" : "propyphenazone, combinations with psycholeptics"
          },
          {
            "code" : "N02BG",
            "display" : "Other analgesics and antipyretics"
          },
          {
            "code" : "N02BG11",
            "display" : "mirogabalin"
          },
          {
            "code" : "N02CX05",
            "display" : "dimetotiazine"
          },
          {
            "code" : "N03AA02",
            "display" : "phenobarbital"
          },
          {
            "code" : "N03AB52",
            "display" : "phenytoin, combinations"
          },
          {
            "code" : "N04BC01",
            "display" : "bromocriptine"
          },
          {
            "code" : "N04BC06",
            "display" : "cabergoline"
          },
          {
            "code" : "N05BA17",
            "display" : "fludiazepam"
          },
          {
            "code" : "N05CA06",
            "display" : "secobarbital"
          },
          {
            "code" : "N05CD01",
            "display" : "flurazepam"
          },
          {
            "code" : "N05CM03",
            "display" : "bromisoval"
          },
          {
            "code" : "N05CM12",
            "display" : "apronal"
          },
          {
            "code" : "N06AA12",
            "display" : "doxepin"
          },
          {
            "code" : "N06AA21",
            "display" : "maprotiline"
          },
          {
            "code" : "N06AB08",
            "display" : "fluvoxamine"
          },
          {
            "code" : "N06AX03",
            "display" : "mianserin"
          },
          {
            "code" : "N06DX02",
            "display" : "Ginkgo folium"
          },
          {
            "code" : "N07AA51",
            "display" : "neostigmine, combinations"
          },
          {
            "code" : "N07AX03",
            "display" : "cevimeline"
          },
          {
            "code" : "N07BB03",
            "display" : "acamprosate"
          },
          {
            "code" : "N07CA03",
            "display" : "flunarizine"
          },
          {
            "code" : "P01AB06",
            "display" : "nimorazole"
          },
          {
            "code" : "P01AX02",
            "display" : "emetine"
          },
          {
            "code" : "P01BC02",
            "display" : "mefloquine"
          },
          {
            "code" : "P02",
            "display" : "ANTHELMINTICS"
          },
          {
            "code" : "P02CC01",
            "display" : "pyrantel"
          },
          {
            "code" : "P02CE01",
            "display" : "levamisole"
          },
          {
            "code" : "P02CF01",
            "display" : "ivermectin"
          },
          {
            "code" : "P02CX",
            "display" : "Other antinematodals"
          },
          {
            "code" : "P03BX01",
            "display" : "diethyltoluamide"
          },
          {
            "code" : "R01AA03",
            "display" : "ephedrine"
          },
          {
            "code" : "R01AB",
            "display" : "Sympathomimetics, combinations excl. corticosteroids"
          },
          {
            "code" : "R01AC",
            "display" : "Antiallergic agents, excl. corticosteroids"
          },
          {
            "code" : "R01AC03",
            "display" : "azelastine"
          },
          {
            "code" : "R01AC04",
            "display" : "antazoline"
          },
          {
            "code" : "R01AD06",
            "display" : "betamethasone"
          },
          {
            "code" : "R01AX06",
            "display" : "mupirocin"
          },
          {
            "code" : "R01BA51",
            "display" : "phenylpropanolamine, combinations"
          },
          {
            "code" : "R01BA52",
            "display" : "pseudoephedrine, combinations"
          },
          {
            "code" : "R02AB01",
            "display" : "neomycin"
          },
          {
            "code" : "R02AB03",
            "display" : "fusafungine"
          },
          {
            "code" : "R02AB30",
            "display" : "gramicidin"
          },
          {
            "code" : "R02AD03",
            "display" : "cocaine"
          },
          {
            "code" : "R03AC",
            "display" : "Selective beta-2-adrenoreceptor agonists"
          },
          {
            "code" : "R03AC03",
            "display" : "terbutaline"
          },
          {
            "code" : "R03AC09",
            "display" : "tretoquinol"
          },
          {
            "code" : "R03CB02",
            "display" : "methoxyphenamine"
          },
          {
            "code" : "R03CB03",
            "display" : "orciprenaline"
          },
          {
            "code" : "R03CC",
            "display" : "Selective beta-2-adrenoreceptor agonists"
          },
          {
            "code" : "R03CC03",
            "display" : "terbutaline"
          },
          {
            "code" : "R03CC08",
            "display" : "procaterol"
          },
          {
            "code" : "R03DB",
            "display" : "Xanthines and adrenergics"
          },
          {
            "code" : "R03DB04",
            "display" : "theophylline and adrenergics"
          },
          {
            "code" : "R03DX10",
            "display" : "benralizumab"
          },
          {
            "code" : "R05CA06",
            "display" : "senega"
          },
          {
            "code" : "R05CB01",
            "display" : "acetylcysteine"
          },
          {
            "code" : "R05CB03",
            "display" : "carbocisteine"
          },
          {
            "code" : "R05CB04",
            "display" : "eprazinone"
          },
          {
            "code" : "R05CB05",
            "display" : "mesna"
          },
          {
            "code" : "R05CB15",
            "display" : "erdosteine"
          },
          {
            "code" : "R05CB16",
            "display" : "mannitol"
          },
          {
            "code" : "R05DA11",
            "display" : "dimemorfan"
          },
          {
            "code" : "R05DB07",
            "display" : "oxolamine"
          },
          {
            "code" : "R05X",
            "display" : "OTHER COLD PREPARATIONS"
          },
          {
            "code" : "R06AA07",
            "display" : "diphenylpyraline"
          },
          {
            "code" : "R06AB51",
            "display" : "brompheniramine, combinations"
          },
          {
            "code" : "R06AB52",
            "display" : "dexchlorpheniramine, combinations"
          },
          {
            "code" : "R06AD52",
            "display" : "promethazine, combinations"
          },
          {
            "code" : "R06AE01",
            "display" : "buclizine"
          },
          {
            "code" : "R06AE04",
            "display" : "chlorcyclizine"
          },
          {
            "code" : "R06AE51",
            "display" : "buclizine, combinations"
          },
          {
            "code" : "R06AX",
            "display" : "Other antihistamines for systemic use"
          },
          {
            "code" : "R06AX07",
            "display" : "triprolidine"
          },
          {
            "code" : "R06AX09",
            "display" : "azatadine"
          },
          {
            "code" : "R06AX11",
            "display" : "astemizole"
          },
          {
            "code" : "S01AA13",
            "display" : "fusidic acid"
          },
          {
            "code" : "S01AA18",
            "display" : "polymyxin B"
          },
          {
            "code" : "S01AA24",
            "display" : "kanamycin"
          },
          {
            "code" : "S01AE04",
            "display" : "lomefloxacin"
          },
          {
            "code" : "S01AX07",
            "display" : "sodium borate"
          },
          {
            "code" : "S01AX18",
            "display" : "povidone-iodine"
          },
          {
            "code" : "S01BA06",
            "display" : "betamethasone"
          },
          {
            "code" : "S01BA07",
            "display" : "fluorometholone"
          },
          {
            "code" : "S01BB04",
            "display" : "betamethasone and mydriatics"
          },
          {
            "code" : "J05AR11",
            "display" : "lamivudine, tenofovir disoproxil and efavirenz"
          },
          {
            "code" : "J05AR20",
            "display" : "emtricitabine, tenofovir alafenamide and bictegravir"
          },
          {
            "code" : "J05AR21",
            "display" : "dolutegravir and rilpivirine"
          },
          {
            "code" : "J05AR27",
            "display" : "lamivudine, tenofovir disoproxil and dolutegravir"
          },
          {
            "code" : "J06BB16",
            "display" : "palivizumab"
          },
          {
            "code" : "J07AJ51",
            "display" : "pertussis, inactivated, whole cell, combinations with toxoids"
          },
          {
            "code" : "J07BA02",
            "display" : "encephalitis, Japanese, inactivated, whole virus"
          },
          {
            "code" : "J07BC02",
            "display" : "hepatitis A, inactivated, whole virus"
          },
          {
            "code" : "J07BH02",
            "display" : "rota virus, pentavalent, live, reassorted"
          },
          {
            "code" : "J07BK02",
            "display" : "zoster, live attenuated"
          },
          {
            "code" : "L01AA01",
            "display" : "cyclophosphamide"
          },
          {
            "code" : "L01BB02",
            "display" : "mercaptopurine"
          },
          {
            "code" : "L01BC01",
            "display" : "cytarabine"
          },
          {
            "code" : "L01CB02",
            "display" : "teniposide"
          },
          {
            "code" : "L01CD04",
            "display" : "cabazitaxel"
          },
          {
            "code" : "L01DB06",
            "display" : "idarubicin"
          },
          {
            "code" : "L01EA01",
            "display" : "imatinib"
          },
          {
            "code" : "L01EB04",
            "display" : "osimertinib"
          },
          {
            "code" : "L01ED02",
            "display" : "ceritinib"
          },
          {
            "code" : "L01EE02",
            "display" : "cobimetinib"
          },
          {
            "code" : "L01EG01",
            "display" : "temsirolimus"
          },
          {
            "code" : "L01EJ01",
            "display" : "ruxolitinib"
          },
          {
            "code" : "L01EL01",
            "display" : "ibrutinib"
          },
          {
            "code" : "L01XC08",
            "display" : "panitumumab"
          },
          {
            "code" : "L01XF01",
            "display" : "tretinoin"
          },
          {
            "code" : "L01XJ01",
            "display" : "vismodegib"
          },
          {
            "code" : "L01XK02",
            "display" : "niraparib"
          },
          {
            "code" : "L01XX02",
            "display" : "asparaginase"
          },
          {
            "code" : "L02AA04",
            "display" : "fosfestrol"
          },
          {
            "code" : "L02AE03",
            "display" : "goserelin"
          },
          {
            "code" : "L02AE51",
            "display" : "leuprorelin and bicalutamide"
          },
          {
            "code" : "L02BX02",
            "display" : "degarelix"
          },
          {
            "code" : "L03AA03",
            "display" : "molgramostim"
          },
          {
            "code" : "L03AB05",
            "display" : "interferon alfa-2b"
          },
          {
            "code" : "L03AB11",
            "display" : "peginterferon alfa-2a"
          },
          {
            "code" : "L03AB15",
            "display" : "ropeginterferon alfa-2b"
          },
          {
            "code" : "L03AX13",
            "display" : "glatiramer acetate"
          },
          {
            "code" : "L04AA02",
            "display" : "muromonab-CD3"
          },
          {
            "code" : "L04AA38",
            "display" : "ozanimod"
          },
          {
            "code" : "L04AA43",
            "display" : "ravulizumab"
          },
          {
            "code" : "L04AA47",
            "display" : "inebilizumab"
          },
          {
            "code" : "L04AB02",
            "display" : "infliximab"
          },
          {
            "code" : "L04AC01",
            "display" : "daclizumab"
          },
          {
            "code" : "L04AC10",
            "display" : "secukinumab"
          },
          {
            "code" : "L04AD02",
            "display" : "tacrolimus"
          },
          {
            "code" : "L04AX01",
            "display" : "azathioprine"
          },
          {
            "code" : "L04AX05",
            "display" : "pirfenidone"
          },
          {
            "code" : "M01AB05",
            "display" : "diclofenac"
          },
          {
            "code" : "M01AB15",
            "display" : "ketorolac"
          },
          {
            "code" : "M01AE01",
            "display" : "ibuprofen"
          },
          {
            "code" : "M01AE51",
            "display" : "ibuprofen, combinations"
          },
          {
            "code" : "M01AG04",
            "display" : "meclofenamic acid"
          },
          {
            "code" : "M01CB01",
            "display" : "sodium aurothiomalate"
          },
          {
            "code" : "M02AA10",
            "display" : "ketoprofen"
          },
          {
            "code" : "M02AA15",
            "display" : "diclofenac"
          },
          {
            "code" : "M02AC",
            "display" : "Preparations with salicylic acid derivatives"
          },
          {
            "code" : "M03AA01",
            "display" : "alcuronium"
          },
          {
            "code" : "M03AC09",
            "display" : "rocuronium bromide"
          },
          {
            "code" : "M03BB03",
            "display" : "chlorzoxazone"
          },
          {
            "code" : "M03BB53",
            "display" : "chlorzoxazone, combinations excl. psycholeptics"
          },
          {
            "code" : "M03BC01",
            "display" : "orphenadrine (citrate)"
          },
          {
            "code" : "M03BX",
            "display" : "Other centrally acting agents"
          },
          {
            "code" : "M03BX06",
            "display" : "mephenesin"
          },
          {
            "code" : "M05BA08",
            "display" : "zoledronic acid"
          },
          {
            "code" : "N01AB01",
            "display" : "halothane"
          },
          {
            "code" : "N01AB07",
            "display" : "desflurane"
          },
          {
            "code" : "N01BA01",
            "display" : "metabutethamine"
          },
          {
            "code" : "N02AJ07",
            "display" : "codeine and acetylsalicylic acid"
          },
          {
            "code" : "N02AJ08",
            "display" : "codeine and ibuprofen"
          },
          {
            "code" : "N02AJ17",
            "display" : "oxycodone and paracetamol"
          },
          {
            "code" : "N02AJ19",
            "display" : "oxycodone and ibuprofen"
          },
          {
            "code" : "N02AX02",
            "display" : "tramadol"
          },
          {
            "code" : "N02AX06",
            "display" : "tapentadol"
          },
          {
            "code" : "N02BA",
            "display" : "Salicylic acid and derivatives"
          },
          {
            "code" : "N02BA55",
            "display" : "salicylamide, combinations excl. psycholeptics"
          },
          {
            "code" : "N02BA57",
            "display" : "ethenzamide, combinations excl. psycholeptics"
          },
          {
            "code" : "N02BB02",
            "display" : "metamizole sodium"
          },
          {
            "code" : "N02BE04",
            "display" : "bucetin"
          },
          {
            "code" : "N02CC02",
            "display" : "naratriptan"
          },
          {
            "code" : "N02CC06",
            "display" : "eletriptan"
          },
          {
            "code" : "N03AF03",
            "display" : "rufinamide"
          },
          {
            "code" : "N03AG",
            "display" : "Fatty acid derivatives"
          },
          {
            "code" : "N03AX11",
            "display" : "topiramate"
          },
          {
            "code" : "N03AX12",
            "display" : "gabapentin"
          },
          {
            "code" : "N04AA02",
            "display" : "biperiden"
          },
          {
            "code" : "N04AB02",
            "display" : "orphenadrine (chloride)"
          },
          {
            "code" : "N04BA01",
            "display" : "levodopa"
          },
          {
            "code" : "N05AF03",
            "display" : "chlorprothixene"
          },
          {
            "code" : "N05AF04",
            "display" : "tiotixene"
          },
          {
            "code" : "N05AH01",
            "display" : "loxapine"
          },
          {
            "code" : "N05AH06",
            "display" : "clotiapine"
          },
          {
            "code" : "N05AX08",
            "display" : "risperidone"
          },
          {
            "code" : "N05BA04",
            "display" : "oxazepam"
          },
          {
            "code" : "N05BA06",
            "display" : "lorazepam"
          },
          {
            "code" : "N05BX01",
            "display" : "mephenoxalone"
          },
          {
            "code" : "N05CA21",
            "display" : "allobarbital"
          },
          {
            "code" : "N06AB03",
            "display" : "fluoxetine"
          },
          {
            "code" : "N06AX22",
            "display" : "agomelatine"
          },
          {
            "code" : "N06AX26",
            "display" : "vortioxetine"
          },
          {
            "code" : "N06AX27",
            "display" : "esketamine"
          },
          {
            "code" : "N07BC51",
            "display" : "buprenorphine, combinations"
          },
          {
            "code" : "P01AX",
            "display" : "Other agents against amoebiasis and other protozoal diseases"
          },
          {
            "code" : "P01AX07",
            "display" : "trimetrexate"
          },
          {
            "code" : "P03AX",
            "display" : "Other ectoparasiticides, incl. scabicides"
          },
          {
            "code" : "P03BX",
            "display" : "Other insecticides and repellents"
          },
          {
            "code" : "R01AD05",
            "display" : "budesonide"
          },
          {
            "code" : "R01AD08",
            "display" : "fluticasone"
          },
          {
            "code" : "S01CA02",
            "display" : "prednisolone and antiinfectives"
          },
          {
            "code" : "S01CA07",
            "display" : "fluorometholone and antiinfectives"
          },
          {
            "code" : "S01CB05",
            "display" : "fluorometholone"
          },
          {
            "code" : "S01CC02",
            "display" : "indometacin and antiinfectives"
          },
          {
            "code" : "S01EA02",
            "display" : "dipivefrine"
          },
          {
            "code" : "S01EC03",
            "display" : "dorzolamide"
          },
          {
            "code" : "S01EC04",
            "display" : "brinzolamide"
          },
          {
            "code" : "S01ED04",
            "display" : "metipranolol"
          },
          {
            "code" : "S01F",
            "display" : "MYDRIATICS AND CYCLOPLEGICS"
          },
          {
            "code" : "S01GX01",
            "display" : "cromoglicic acid"
          },
          {
            "code" : "S01GX06",
            "display" : "emedastine"
          },
          {
            "code" : "S01HA01",
            "display" : "cocaine"
          },
          {
            "code" : "S01JA01",
            "display" : "fluorescein"
          },
          {
            "code" : "S01KX01",
            "display" : "chymotrypsin"
          },
          {
            "code" : "S01LA01",
            "display" : "verteporfin"
          },
          {
            "code" : "S01LA06",
            "display" : "brolucizumab"
          },
          {
            "code" : "S01XA11",
            "display" : "nandrolone"
          },
          {
            "code" : "S01XA20",
            "display" : "artificial tears and other indifferent preparations"
          },
          {
            "code" : "S02AA09",
            "display" : "chlorhexidine"
          },
          {
            "code" : "S02AA30",
            "display" : "antiinfectives, combinations"
          },
          {
            "code" : "S02CA",
            "display" : "Corticosteroids and antiinfectives in combination"
          },
          {
            "code" : "S03BA02",
            "display" : "prednisolone"
          },
          {
            "code" : "S03BA03",
            "display" : "betamethasone"
          },
          {
            "code" : "V01AA03",
            "display" : "house dust mites"
          },
          {
            "code" : "V03A",
            "display" : "ALL OTHER THERAPEUTIC PRODUCTS"
          },
          {
            "code" : "V03AB14",
            "display" : "protamine"
          },
          {
            "code" : "V03AB32",
            "display" : "glutathione"
          },
          {
            "code" : "V03AB34",
            "display" : "fomepizole"
          },
          {
            "code" : "V03AB35",
            "display" : "sugammadex"
          },
          {
            "code" : "V03AC01",
            "display" : "deferoxamine"
          },
          {
            "code" : "V03AN02",
            "display" : "carbon dioxide"
          },
          {
            "code" : "V03AZ01",
            "display" : "ethanol"
          },
          {
            "code" : "V04",
            "display" : "DIAGNOSTIC AGENTS"
          },
          {
            "code" : "V04CA02",
            "display" : "glucose"
          },
          {
            "code" : "V04CB01",
            "display" : "vitamin A concentrates"
          },
          {
            "code" : "V04CJ01",
            "display" : "thyrotropin"
          },
          {
            "code" : "V04CX03",
            "display" : "methacholine"
          },
          {
            "code" : "V06B",
            "display" : "PROTEIN SUPPLEMENTS"
          },
          {
            "code" : "V06DC01",
            "display" : "glucose"
          },
          {
            "code" : "V07AC",
            "display" : "Blood transfusion, auxiliary products"
          },
          {
            "code" : "V07AX",
            "display" : "Washing agents etc."
          },
          {
            "code" : "V07AY",
            "display" : "Other non-therapeutic auxiliary products"
          },
          {
            "code" : "V08AB09",
            "display" : "iodixanol"
          },
          {
            "code" : "V08BA01",
            "display" : "barium sulfate with suspending agents"
          },
          {
            "code" : "V08CA01",
            "display" : "gadopentetic acid"
          },
          {
            "code" : "V09CA01",
            "display" : "technetium (99mTc) pentetic acid"
          },
          {
            "code" : "V09GX",
            "display" : "Other cardiovascular system diagnostic radiopharmaceuticals"
          },
          {
            "code" : "V09IX04",
            "display" : "fludeoxyglucose (18F)"
          },
          {
            "code" : "V09XX02",
            "display" : "cobalt (58Co) cyanocobalamine"
          },
          {
            "code" : "V10XX04",
            "display" : "lutetium (177Lu) oxodotreotide"
          },
          {
            "code" : "R01AD11",
            "display" : "triamcinolone"
          },
          {
            "code" : "R01AD58",
            "display" : "fluticasone, combinations"
          },
          {
            "code" : "R01AD59",
            "display" : "mometasone, combinations"
          },
          {
            "code" : "R01BA53",
            "display" : "phenylephrine, combinations"
          },
          {
            "code" : "R02A",
            "display" : "THROAT PREPARATIONS"
          },
          {
            "code" : "R02AA15",
            "display" : "povidone-iodine"
          },
          {
            "code" : "R02AA19",
            "display" : "phenol"
          },
          {
            "code" : "R02AB04",
            "display" : "bacitracin"
          },
          {
            "code" : "R03AA01",
            "display" : "epinephrine"
          },
          {
            "code" : "R03AK07",
            "display" : "formoterol and budesonide"
          },
          {
            "code" : "R03AK09",
            "display" : "formoterol and mometasone"
          },
          {
            "code" : "R03AK14",
            "display" : "indacaterol and mometasone"
          },
          {
            "code" : "R03AL06",
            "display" : "olodaterol and tiotropium bromide"
          },
          {
            "code" : "R03AL08",
            "display" : "vilanterol, umeclidinium bromide and fluticasone furoate"
          },
          {
            "code" : "R03BB06",
            "display" : "glycopyrronium bromide"
          },
          {
            "code" : "R03BC01",
            "display" : "cromoglicic acid"
          },
          {
            "code" : "R03CA",
            "display" : "Alpha- and beta-adrenoreceptor agonists"
          },
          {
            "code" : "R03CC12",
            "display" : "bambuterol"
          },
          {
            "code" : "R03DA54",
            "display" : "theophylline, combinations excl. psycholeptics"
          },
          {
            "code" : "R03DA74",
            "display" : "theophylline, combinations with psycholeptics"
          },
          {
            "code" : "R03DC01",
            "display" : "zafirlukast"
          },
          {
            "code" : "R03DX07",
            "display" : "roflumilast"
          },
          {
            "code" : "R05CA07",
            "display" : "antimony pentasulfide"
          },
          {
            "code" : "R05CA09",
            "display" : "guaiacolsulfonate"
          },
          {
            "code" : "R05CB02",
            "display" : "bromhexine"
          },
          {
            "code" : "R05CB06",
            "display" : "ambroxol"
          },
          {
            "code" : "R05CB10",
            "display" : "combinations"
          },
          {
            "code" : "R05DB13",
            "display" : "butamirate"
          },
          {
            "code" : "R05FA",
            "display" : "Opium derivatives and expectorants"
          },
          {
            "code" : "R05FB02",
            "display" : "cough suppressants and expectorants"
          },
          {
            "code" : "R06AA04",
            "display" : "clemastine"
          },
          {
            "code" : "R06AB01",
            "display" : "brompheniramine"
          },
          {
            "code" : "R06AB04",
            "display" : "chlorphenamine"
          },
          {
            "code" : "R06AB05",
            "display" : "pheniramine"
          },
          {
            "code" : "R06AE09",
            "display" : "levocetirizine"
          },
          {
            "code" : "R06AK",
            "display" : "Combinations of antihistamines"
          },
          {
            "code" : "R06AX15",
            "display" : "mebhydrolin"
          },
          {
            "code" : "R06AX22",
            "display" : "ebastine"
          },
          {
            "code" : "R06AX58",
            "display" : "pyrrobutamine, combinations"
          },
          {
            "code" : "R07AA01",
            "display" : "colfosceril palmitate"
          },
          {
            "code" : "S01A",
            "display" : "ANTIINFECTIVES"
          },
          {
            "code" : "S01AA02",
            "display" : "chlortetracycline"
          },
          {
            "code" : "S01AA03",
            "display" : "neomycin"
          },
          {
            "code" : "S01BA14",
            "display" : "loteprednol"
          },
          {
            "code" : "S01ED03",
            "display" : "levobunolol"
          },
          {
            "code" : "S01EE06",
            "display" : "latanoprostene bunod"
          },
          {
            "code" : "S01FA03",
            "display" : "methylscopolamine"
          },
          {
            "code" : "S01FB01",
            "display" : "phenylephrine"
          },
          {
            "code" : "S01GA52",
            "display" : "tetryzoline, combinations"
          },
          {
            "code" : "S01GA55",
            "display" : "phenylephrine, combinations"
          },
          {
            "code" : "S01HA02",
            "display" : "oxybuprocaine"
          },
          {
            "code" : "S01HA04",
            "display" : "proxymetacaine"
          },
          {
            "code" : "S01XA12",
            "display" : "dexpanthenol"
          },
          {
            "code" : "S02AA02",
            "display" : "nitrofural"
          },
          {
            "code" : "S02AA14",
            "display" : "gentamicin"
          },
          {
            "code" : "S02AA15",
            "display" : "ciprofloxacin"
          },
          {
            "code" : "S02BA06",
            "display" : "dexamethasone"
          },
          {
            "code" : "S02DA04",
            "display" : "cinchocaine"
          },
          {
            "code" : "S03AA06",
            "display" : "gentamicin"
          },
          {
            "code" : "S03CA04",
            "display" : "hydrocortisone and antiinfectives"
          },
          {
            "code" : "S03CA06",
            "display" : "betamethasone and antiinfectives"
          },
          {
            "code" : "V01AA",
            "display" : "Allergen extracts"
          },
          {
            "code" : "V01AA02",
            "display" : "grass pollen"
          },
          {
            "code" : "V01AA05",
            "display" : "tree pollen"
          },
          {
            "code" : "V03AB15",
            "display" : "naloxone"
          },
          {
            "code" : "V03AB16",
            "display" : "ethanol"
          },
          {
            "code" : "V03AC03",
            "display" : "deferasirox"
          },
          {
            "code" : "V03AE04",
            "display" : "calcium acetate and magnesium carbonate"
          },
          {
            "code" : "V03AF07",
            "display" : "rasburicase"
          },
          {
            "code" : "V04CC01",
            "display" : "sorbitol"
          },
          {
            "code" : "V04CX05",
            "display" : "13C-urea"
          },
          {
            "code" : "V06D",
            "display" : "OTHER NUTRIENTS"
          },
          {
            "code" : "V08AB",
            "display" : "Watersoluble, nephrotropic, low osmolar X-ray contrast media"
          },
          {
            "code" : "V08AD01",
            "display" : "ethyl esters of iodised fatty acids"
          },
          {
            "code" : "V08CA06",
            "display" : "gadoversetamide"
          },
          {
            "code" : "V08DA06",
            "display" : "perflubutane, phospholipid microspheres"
          },
          {
            "code" : "V09BA",
            "display" : "Technetium (99mTc) compounds"
          },
          {
            "code" : "V09DB07",
            "display" : "technetium (99mTc) phytate"
          },
          {
            "code" : "V09FX03",
            "display" : "sodium iodide (131I)"
          },
          {
            "code" : "V09GX01",
            "display" : "thallium (201Tl) chloride"
          },
          {
            "code" : "V09IA",
            "display" : "Technetium (99mTc) compounds"
          },
          {
            "code" : "V09IB",
            "display" : "Indium (111In) compounds"
          },
          {
            "code" : "V09IX12",
            "display" : "fluciclovine (18F)"
          },
          {
            "code" : "V09XA",
            "display" : "Iodine (131I) compounds"
          },
          {
            "code" : "N07AA02",
            "display" : "pyridostigmine"
          },
          {
            "code" : "N07XX08",
            "display" : "tafamidis"
          },
          {
            "code" : "P01AB03",
            "display" : "ornidazole"
          },
          {
            "code" : "P02CA01",
            "display" : "mebendazole"
          },
          {
            "code" : "P03AC02",
            "display" : "bioallethrin"
          },
          {
            "code" : "P03AX01",
            "display" : "benzyl benzoate"
          },
          {
            "code" : "P03AX05",
            "display" : "dimeticone"
          },
          {
            "code" : "R01AA06",
            "display" : "tetryzoline"
          },
          {
            "code" : "R01AB02",
            "display" : "naphazoline"
          },
          {
            "code" : "R01AD60",
            "display" : "hydrocortisone, combinations"
          },
          {
            "code" : "R01BA01",
            "display" : "phenylpropanolamine"
          },
          {
            "code" : "R02AD02",
            "display" : "lidocaine"
          },
          {
            "code" : "R03AC13",
            "display" : "formoterol"
          },
          {
            "code" : "R03AC19",
            "display" : "olodaterol"
          },
          {
            "code" : "R03AK06",
            "display" : "salmeterol and fluticasone"
          },
          {
            "code" : "R03AK13",
            "display" : "salbutamol and beclometasone"
          },
          {
            "code" : "R03AL02",
            "display" : "salbutamol and ipratropium bromide"
          },
          {
            "code" : "R03BA01",
            "display" : "beclometasone"
          },
          {
            "code" : "R03BA02",
            "display" : "budesonide"
          },
          {
            "code" : "R03BA09",
            "display" : "fluticasone furoate"
          },
          {
            "code" : "R03BB04",
            "display" : "tiotropium bromide"
          },
          {
            "code" : "R03CA02",
            "display" : "ephedrine"
          },
          {
            "code" : "R03CB01",
            "display" : "isoprenaline"
          },
          {
            "code" : "R03CC04",
            "display" : "fenoterol"
          },
          {
            "code" : "R05CA04",
            "display" : "ipecacuanha"
          },
          {
            "code" : "R05DA01",
            "display" : "ethylmorphine"
          },
          {
            "code" : "R05DB10",
            "display" : "clofedanol"
          },
          {
            "code" : "R05DB16",
            "display" : "dibunate"
          },
          {
            "code" : "R05DB24",
            "display" : "tipepidine"
          },
          {
            "code" : "R05FA02",
            "display" : "opium derivatives and expectorants"
          },
          {
            "code" : "R06AA08",
            "display" : "carbinoxamine"
          },
          {
            "code" : "R06AA59",
            "display" : "doxylamine, combinations"
          },
          {
            "code" : "R06AC01",
            "display" : "mepyramine"
          },
          {
            "code" : "R06AE06",
            "display" : "oxatomide"
          },
          {
            "code" : "R07AA02",
            "display" : "natural phospholipids"
          },
          {
            "code" : "R07AB05",
            "display" : "bemegride"
          },
          {
            "code" : "S01AA23",
            "display" : "netilmicin"
          },
          {
            "code" : "S01AB",
            "display" : "Sulfonamides"
          },
          {
            "code" : "S01AE05",
            "display" : "levofloxacin"
          },
          {
            "code" : "S01AX03",
            "display" : "zinc compounds"
          },
          {
            "code" : "S01BA05",
            "display" : "triamcinolone"
          },
          {
            "code" : "S01BC05",
            "display" : "ketorolac"
          },
          {
            "code" : "S01BC10",
            "display" : "nepafenac"
          },
          {
            "code" : "S01CA03",
            "display" : "hydrocortisone and antiinfectives"
          },
          {
            "code" : "S01CA08",
            "display" : "methylprednisolone and antiinfectives"
          },
          {
            "code" : "S01EC54",
            "display" : "brinzolamide, combinations"
          },
          {
            "code" : "S01ED05",
            "display" : "carteolol"
          },
          {
            "code" : "S01ED54",
            "display" : "metipranolol, combinations"
          },
          {
            "code" : "S01EE04",
            "display" : "travoprost"
          },
          {
            "code" : "S01FA04",
            "display" : "cyclopentolate"
          },
          {
            "code" : "S01FA06",
            "display" : "tropicamide"
          },
          {
            "code" : "S01FB02",
            "display" : "ephedrine"
          },
          {
            "code" : "S01GA02",
            "display" : "tetryzoline"
          },
          {
            "code" : "S01GA51",
            "display" : "naphazoline, combinations"
          },
          {
            "code" : "S01LA03",
            "display" : "pegaptanib"
          },
          {
            "code" : "S01X",
            "display" : "OTHER OPHTHALMOLOGICALS"
          },
          {
            "code" : "S01XA10",
            "display" : "inosine"
          },
          {
            "code" : "S01XA22",
            "display" : "ocriplasmin"
          },
          {
            "code" : "S02AA08",
            "display" : "tetracycline"
          },
          {
            "code" : "S02AA13",
            "display" : "miconazole"
          },
          {
            "code" : "S02AA16",
            "display" : "ofloxacin"
          },
          {
            "code" : "S02BA01",
            "display" : "hydrocortisone"
          },
          {
            "code" : "S02CA01",
            "display" : "prednisolone and antiinfectives"
          },
          {
            "code" : "S02DA02",
            "display" : "cocaine"
          },
          {
            "code" : "S02DC",
            "display" : "Indifferent preparations"
          },
          {
            "code" : "V01AA08",
            "display" : "food"
          },
          {
            "code" : "V03AB06",
            "display" : "thiosulfate"
          },
          {
            "code" : "V03AB23",
            "display" : "acetylcysteine"
          },
          {
            "code" : "V04CG30",
            "display" : "caffeine and sodium benzoate"
          },
          {
            "code" : "V08AA04",
            "display" : "iotalamic acid"
          },
          {
            "code" : "V08BA02",
            "display" : "barium sulfate without suspending agents"
          },
          {
            "code" : "V08DA05",
            "display" : "sulfur hexafluoride, phospholipid microspheres"
          },
          {
            "code" : "V09AA",
            "display" : "Technetium (99mTc) compounds"
          },
          {
            "code" : "V09G",
            "display" : "CARDIOVASCULAR SYSTEM"
          },
          {
            "code" : "V09GX03",
            "display" : "chromium (51Cr) chromate labelled cells"
          },
          {
            "code" : "V09HX01",
            "display" : "gallium (67Ga) citrate"
          },
          {
            "code" : "V09IX",
            "display" : "Other diagnostic radiopharmaceuticals for tumour detection"
          },
          {
            "code" : "V10AA",
            "display" : "Yttrium (90Y) compounds"
          },
          {
            "code" : "V10XA01",
            "display" : "sodium iodide (131I)"
          }
        ]
      }
    ]
  }
}

```
