# LOINC + HL7 NullFlavor妊娠計畫值集 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: LOINC + HL7 NullFlavor妊娠計畫值集 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/loinc-pregnancy-intent-code | *Version*:0.3.0 |
| Active as of 2026-01-07 | *Computable Name*:LOINCPregnancyIntentCode |
| **Copyright/Legal**: This content LOINC® is copyright © 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use | |

 
LOINC + HL7 NullFlavor妊娠計畫值集。 

 **References** 

* [TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "loinc-pregnancy-intent-code",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/loinc-pregnancy-intent-code",
  "version" : "0.3.0",
  "name" : "LOINCPregnancyIntentCode",
  "title" : "LOINC +  HL7 NullFlavor妊娠計畫值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "LOINC +  HL7 NullFlavor妊娠計畫值集。",
  "copyright" : "This content LOINC® is copyright © 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "LA26438-4",
            "display" : "Yes, I want to become pregnant"
          },
          {
            "code" : "LA26439-2",
            "display" : "I'm OK either way"
          },
          {
            "code" : "LA26440-0",
            "display" : "No, I don't want to become pregnant"
          },
          {
            "code" : "LA14072-5",
            "display" : "Unsure"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
        "concept" : [
          {
            "code" : "UNK"
          }
        ]
      }
    ]
  }
}

```
