# LOINC實驗室檢驗檢查值集 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: LOINC實驗室檢驗檢查值集 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/loinc-observation-code | *Version*:2.81 |
| Active as of 2025-12-01 | *Computable Name*:LOINCObservationCode |
| **Copyright/Legal**: This content LOINC® is copyright © 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use | |

 
LOINC實驗室檢驗檢查值集。
代碼版本：2.81；代碼更新日期：2025-12-01；資料所屬單位：Regenstrief Institute。 

 **References** 

* Included into [TWLaboratoryCode](ValueSet-laboratory-code-tw.md)
* [TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "loinc-observation-code",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/loinc-observation-code",
  "version" : "2.81",
  "name" : "LOINCObservationCode",
  "title" : "LOINC實驗室檢驗檢查值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-01",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "LOINC實驗室檢驗檢查值集。  \n代碼版本：2.81；代碼更新日期：2025-12-01；資料所屬單位：Regenstrief Institute。",
  "copyright" : "This content LOINC® is copyright © 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "filter" : [
          {
            "property" : "CLASSTYPE",
            "op" : "=",
            "value" : "1"
          }
        ]
      },
      {
        "system" : "http://loinc.org",
        "filter" : [
          {
            "property" : "CLASSTYPE",
            "op" : "=",
            "value" : "2"
          }
        ]
      }
    ]
  }
}

```
