# LOINC Code Document Section值集 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: LOINC Code Document Section值集 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/loinc-doc-section-code | *Version*:2.81 |
| Active as of 2025-12-01 | *Computable Name*:LOINCDocumentSection |
| **Copyright/Legal**: This content LOINC® is copyright © 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use | |

 
LOINC Code Document Section值集。 代碼版本：2.81；代碼更新日期：2025-12-01；資料所屬單位：Regenstrief Institute。 

 **References** 

* [TW Core Composition](StructureDefinition-Composition-twcore.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "loinc-doc-section-code",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/loinc-doc-section-code",
  "version" : "2.81",
  "name" : "LOINCDocumentSection",
  "title" : "LOINC Code Document Section值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-01",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "LOINC Code Document Section值集。\n代碼版本：2.81；代碼更新日期：2025-12-01；資料所屬單位：Regenstrief Institute。",
  "copyright" : "This content LOINC® is copyright © 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "10154-3"
          },
          {
            "code" : "10157-6"
          },
          {
            "code" : "10160-0"
          },
          {
            "code" : "10164-2"
          },
          {
            "code" : "10183-2"
          },
          {
            "code" : "10184-0"
          },
          {
            "code" : "10187-3"
          },
          {
            "code" : "10210-3"
          },
          {
            "code" : "10216-0"
          },
          {
            "code" : "10218-6"
          },
          {
            "code" : "10223-6"
          },
          {
            "code" : "10222-8"
          },
          {
            "code" : "11329-0"
          },
          {
            "code" : "11348-0"
          },
          {
            "code" : "11369-6"
          },
          {
            "code" : "57852-6"
          },
          {
            "code" : "11493-4"
          },
          {
            "code" : "11535-2"
          },
          {
            "code" : "11537-8"
          },
          {
            "code" : "18776-5"
          },
          {
            "code" : "18841-7"
          },
          {
            "code" : "29299-5"
          },
          {
            "code" : "29545-1"
          },
          {
            "code" : "29549-3"
          },
          {
            "code" : "29554-3"
          },
          {
            "code" : "29762-2"
          },
          {
            "code" : "30954-2"
          },
          {
            "code" : "42344-2"
          },
          {
            "code" : "42346-7"
          },
          {
            "code" : "42348-3"
          },
          {
            "code" : "42349-1"
          },
          {
            "code" : "46240-8"
          },
          {
            "code" : "46241-6"
          },
          {
            "code" : "46264-8"
          },
          {
            "code" : "47420-5"
          },
          {
            "code" : "47519-4"
          },
          {
            "code" : "48765-2"
          },
          {
            "code" : "48768-6"
          },
          {
            "code" : "51848-0"
          },
          {
            "code" : "55109-3"
          },
          {
            "code" : "55122-6"
          },
          {
            "code" : "59768-2"
          },
          {
            "code" : "59769-0"
          },
          {
            "code" : "59770-8"
          },
          {
            "code" : "59771-6"
          },
          {
            "code" : "59772-4"
          },
          {
            "code" : "59773-2"
          },
          {
            "code" : "59775-7"
          },
          {
            "code" : "59776-5"
          },
          {
            "code" : "61149-1"
          },
          {
            "code" : "61150-9"
          },
          {
            "code" : "69730-0"
          },
          {
            "code" : "8648-8"
          },
          {
            "code" : "8653-8"
          },
          {
            "code" : "8716-3"
          }
        ]
      }
    ]
  }
}

```
