# SNOMED CT + 臺灣醫事司醫事人員類別值集 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: SNOMED CT + 臺灣醫事司醫事人員類別值集 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/health-professional-sct-tw | *Version*:0.3.0 |
| Active as of 2022-01-28 | *Computable Name*:TWHealthProfessionalSCT |

 
SNOMED CT + 臺灣醫事司醫事人員類別值集。 
此值集優先採用國際標準碼，國際標準碼未能表述之概念則以普遍被使用的臺灣醫事司醫事人員類別標準碼表述，請實作者留意。 

 **References** 

* [TW Core Practitioner](StructureDefinition-Practitioner-twcore.md)
* [TW Core PractitionerRole](StructureDefinition-PractitionerRole-twcore.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "health-professional-sct-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/health-professional-sct-tw",
  "version" : "0.3.0",
  "name" : "TWHealthProfessionalSCT",
  "title" : "SNOMED CT + 臺灣醫事司醫事人員類別值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-01-28",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "SNOMED CT + 臺灣醫事司醫事人員類別值集。\n\n此值集優先採用國際標準碼，國際標準碼未能表述之概念則以普遍被使用的臺灣醫事司醫事人員類別標準碼表述，請實作者留意。",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "223366009"
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "394802001"
          },
          {
            "code" : "159026005"
          },
          {
            "code" : "160008000"
          },
          {
            "code" : "309418004"
          },
          {
            "code" : "28229004"
          },
          {
            "code" : "21365001"
          },
          {
            "code" : "46255001"
          },
          {
            "code" : "159040006"
          },
          {
            "code" : "224535009"
          },
          {
            "code" : "106292003"
          },
          {
            "code" : "309453006"
          },
          {
            "code" : "224536005"
          },
          {
            "code" : "61246008"
          },
          {
            "code" : "24430003"
          },
          {
            "code" : "224607000"
          },
          {
            "code" : "66862007"
          },
          {
            "code" : "442867008"
          },
          {
            "code" : "224587008"
          },
          {
            "code" : "310191001"
          },
          {
            "code" : "40127002"
          }
        ]
      },
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/health-professional-tw",
        "concept" : [
          {
            "code" : "4",
            "display" : "牙體技術生"
          },
          {
            "code" : "6",
            "display" : "驗光生"
          },
          {
            "code" : "B",
            "display" : "中醫師"
          },
          {
            "code" : "K",
            "display" : "醫事檢驗生"
          },
          {
            "code" : "L",
            "display" : "鑲牙生"
          },
          {
            "code" : "M",
            "display" : "中藥員"
          },
          {
            "code" : "N",
            "display" : "齒模員"
          },
          {
            "code" : "O",
            "display" : "非醫事人員"
          },
          {
            "code" : "P",
            "display" : "接骨員"
          },
          {
            "code" : "T",
            "display" : "醫事放射士"
          },
          {
            "code" : "U",
            "display" : "物理治療生"
          },
          {
            "code" : "X",
            "display" : "諮商心理師"
          }
        ]
      }
    ]
  }
}

```
