# Acquisition Modality - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: Acquisition Modality 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/AcquisitionModality | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:AcquisitionModality |

 
此值集為 DICOM CID 29 Acquisition Modality 的本地定義，用於解決 IG Publisher 無法解析外部連結的問題。 

 **References** 

* [TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "AcquisitionModality",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/AcquisitionModality",
  "version" : "1.0.0",
  "name" : "AcquisitionModality",
  "title" : "Acquisition Modality",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此值集為 DICOM CID 29 Acquisition Modality 的本地定義，用於解決 IG Publisher 無法解析外部連結的問題。",
  "compose" : {
    "include" : [
      {
        "system" : "http://dicom.nema.org/resources/ontology/DCM"
      }
    ]
  }
}

```
