# Person Age - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Extension: Person Age 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/person-age | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:PersonAge |

年齡

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [TW Core Patient](StructureDefinition-Patient-twcore.md)
* Examples for this Extension: [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md), [Bundle/bun-example](Bundle-bun-example.md), [Bundle/bun-message-request-example](Bundle-bun-message-request-example.md)...Show 2 more,[Patient/pat-child-example](Patient-pat-child-example.md)and[Patient/pat-example](Patient-pat-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/person-age)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-person-age.csv), [Excel](StructureDefinition-person-age.xlsx), [Schematron](StructureDefinition-person-age.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "person-age",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/person-age",
  "version" : "1.0.0",
  "name" : "PersonAge",
  "title" : "Person Age",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "年齡",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "年齡",
        "definition" : "年齡"
      },
      {
        "id" : "Extension.id",
        "path" : "Extension.id",
        "short" : "唯一可識別ID，以供資料項目間相互參照。",
        "definition" : "resource中資料項目的唯一ID（用於內部參照）。這可以是任何不含空格的字串。"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "short" : "擴充的資料項目名稱",
        "definition" : "擴充的資料項目之定義連結—一個邏輯名稱或URL",
        "comment" : "此定義可直接指向可計算的或人類可讀的擴充資料項目的定義，也可以是其他規範中聲明的邏輯URI。此定義**必須（SHALL）** 定義擴充的結構定義的URI。",
        "fixedUri" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/person-age"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "擴充的資料項目的內容值",
        "definition" : "擴充的資料項目的內容值—必須是一組受限制的data type中的一個（清單請見[Extensibility](http://hl7.org/fhir/2021Mar/extensibility.html)）",
        "type" : [
          {
            "code" : "Age"
          }
        ]
      }
    ]
  }
}

```
