# 臺灣核心-處置或手術(TW Core Procedure)之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-處置或手術(TW Core Procedure)之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWProcedure | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWProcedureModel |

 
臺灣核心-處置或手術(TW Core Procedure)之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWProcedure)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWProcedure.csv), [Excel](StructureDefinition-TWProcedure.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWProcedure",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWProcedure",
  "version" : "1.0.0",
  "name" : "TWProcedureModel",
  "title" : "臺灣核心-處置或手術(TW Core Procedure)之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-處置或手術(TW Core Procedure)之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWProcedure",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWProcedure",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWProcedure",
        "path" : "TWProcedure",
        "short" : "臺灣核心-處置或手術(TW Core Procedure)之資料模型",
        "definition" : "臺灣核心-處置或手術(TW Core Procedure)之資料模型",
        "mapping" : [
          {
            "identity" : "TWProcedure",
            "map" : "TWCoreProcedure"
          }
        ]
      },
      {
        "id" : "TWProcedure.status",
        "path" : "TWProcedure.status",
        "short" : "處置或手術的狀態。",
        "definition" : "處置或手術的狀態。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWProcedure",
            "map" : "TWCoreProcedure.status"
          }
        ]
      },
      {
        "id" : "TWProcedure.code",
        "path" : "TWProcedure.code",
        "short" : "處置或手術的識別碼。",
        "definition" : "處置或手術的識別碼。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWProcedure",
            "map" : "TWCoreProcedure.code"
          }
        ]
      },
      {
        "id" : "TWProcedure.subject",
        "path" : "TWProcedure.subject",
        "short" : "處置或手術服務的對象。",
        "definition" : "處置或手術服務的對象。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWProcedure",
            "map" : "TWCoreProcedure.subject.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWProcedure.performedDateTime",
        "path" : "TWProcedure.performedDateTime",
        "short" : "處置或手術執行時間。",
        "definition" : "處置或手術執行時間。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWProcedure",
            "map" : "TWCoreProcedure.performedDateTime"
          }
        ]
      },
      {
        "id" : "TWProcedure.asserter",
        "path" : "TWProcedure.asserter",
        "short" : "聲稱有此處置或手術的人員。",
        "definition" : "聲稱有此處置或手術的人員。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWProcedure.asserter.patient",
        "path" : "TWProcedure.asserter.patient",
        "short" : "聲稱有此處置或手術的病人。",
        "definition" : "聲稱有此處置或手術的病人。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWProcedure",
            "map" : "TWCoreProcedure.asserter.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWProcedure.asserter.relatedPerson",
        "path" : "TWProcedure.asserter.relatedPerson",
        "short" : "聲稱有此處置或手術的相關人士。",
        "definition" : "聲稱有此處置或手術的相關人士。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "RelatedPerson"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWProcedure",
            "map" : "TWCoreProcedure.asserter.Reference(RelatedPerson)"
          }
        ]
      },
      {
        "id" : "TWProcedure.asserter.practitioner",
        "path" : "TWProcedure.asserter.practitioner",
        "short" : "聲稱有此處置或手術的某健康照護服務提供者。",
        "definition" : "聲稱有此處置或手術的某健康照護服務提供者。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Practitioner"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWProcedure",
            "map" : "TWCoreProcedure.asserter.Reference(TW Core Practitioner)"
          }
        ]
      },
      {
        "id" : "TWProcedure.asserter.practitionerRole",
        "path" : "TWProcedure.asserter.practitionerRole",
        "short" : "聲稱有此處置或手術的某健康照護服務角色。",
        "definition" : "聲稱有此處置或手術的某健康照護服務角色。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "PractitionerRole"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWProcedure",
            "map" : "TWCoreProcedure.asserter.Reference(TW Core PractitionerRole)"
          }
        ]
      },
      {
        "id" : "TWProcedure.performer",
        "path" : "TWProcedure.performer",
        "short" : "執行處置或手術的人員。",
        "definition" : "執行處置或手術的人員。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWProcedure.performer.practitioner",
        "path" : "TWProcedure.performer.practitioner",
        "short" : "執行處置或手術的某健康照護服務提供者。",
        "definition" : "執行處置或手術的某健康照護服務提供者。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Practitioner"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWProcedure",
            "map" : "TWCoreProcedure.performer.actor.Reference(TW Core Practitioner)"
          }
        ]
      },
      {
        "id" : "TWProcedure.performer.practitionerRole",
        "path" : "TWProcedure.performer.practitionerRole",
        "short" : "執行處置或手術的某健康照護服務角色。",
        "definition" : "執行處置或手術的某健康照護服務角色。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "PractitionerRole"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWProcedure",
            "map" : "TWCoreProcedure.performer.actor.Reference(TW Core PractitionerRole)"
          }
        ]
      },
      {
        "id" : "TWProcedure.performer.organization",
        "path" : "TWProcedure.performer.organization",
        "short" : "執行處置或手術的某機構。",
        "definition" : "執行處置或手術的某機構。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Organization"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWProcedure",
            "map" : "TWCoreProcedure.performer.actor.Reference(TW Core Organization Hospital Department)"
          }
        ]
      },
      {
        "id" : "TWProcedure.performer.patient",
        "path" : "TWProcedure.performer.patient",
        "short" : "執行處置或手術的某病人。",
        "definition" : "執行處置或手術的某病人。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWProcedure",
            "map" : "TWCoreProcedure.performer.actor.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWProcedure.performer.relatedPerson",
        "path" : "TWProcedure.performer.relatedPerson",
        "short" : "執行處置或手術的某相關人士。",
        "definition" : "執行處置或手術的某相關人士。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "RelatedPerson"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWProcedure",
            "map" : "TWCoreProcedure.performer.actor.Reference(RelatedPerson)"
          }
        ]
      },
      {
        "id" : "TWProcedure.performer.device",
        "path" : "TWProcedure.performer.device",
        "short" : "執行處置或手術的某設備。",
        "definition" : "執行處置或手術的某設備。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Device"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWProcedure",
            "map" : "TWCoreProcedure.performer.actor.Reference(Device)"
          }
        ]
      },
      {
        "id" : "TWProcedure.bodySite",
        "path" : "TWProcedure.bodySite",
        "short" : "目標身體部位。",
        "definition" : "目標身體部位。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWProcedure",
            "map" : "TWCoreProcedure.bodySite"
          }
        ]
      }
    ]
  }
}

```
