# 臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWPractitionerRole | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWPractitionerRoleModel |

 
臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWPractitionerRole)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWPractitionerRole.csv), [Excel](StructureDefinition-TWPractitionerRole.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWPractitionerRole",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWPractitionerRole",
  "version" : "1.0.0",
  "name" : "TWPractitionerRoleModel",
  "title" : "臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWPractitionerRole",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWPractitionerRole",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWPractitionerRole",
        "path" : "TWPractitionerRole",
        "short" : "臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) 之資料模型",
        "definition" : "臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWPractitionerRole",
            "map" : "TWCorePractitionerRole"
          }
        ]
      },
      {
        "id" : "TWPractitionerRole.practitioner",
        "path" : "TWPractitionerRole.practitioner",
        "short" : "能夠為機構提供所定義服務的健康照護服務提供者。",
        "definition" : "能夠為機構提供所定義服務的健康照護服務提供者。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Practitioner"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPractitionerRole",
            "map" : "TWCorePractitionerRole.practitioner.Reference(TW Core Practitioner)"
          }
        ]
      },
      {
        "id" : "TWPractitionerRole.organization",
        "path" : "TWPractitionerRole.organization",
        "short" : "提供此健康照護服務提供者角色的機構。",
        "definition" : "提供此健康照護服務提供者角色的機構。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPractitionerRole",
            "map" : "TWCorePractitionerRole.organization.Reference(TW Core Organization Hospital Department)"
          }
        ]
      },
      {
        "id" : "TWPractitionerRole.code",
        "path" : "TWPractitionerRole.code",
        "short" : "此健康照護服務提供者可能執行的角色。",
        "definition" : "此健康照護服務提供者可能執行的角色。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPractitionerRole",
            "map" : "TWCorePractitionerRole.code"
          }
        ]
      },
      {
        "id" : "TWPractitionerRole.specialty",
        "path" : "TWPractitionerRole.specialty",
        "short" : "與機構相關的特定專業。",
        "definition" : "與機構相關的特定專業。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPractitionerRole",
            "map" : "TWCorePractitionerRole.specialty"
          }
        ]
      },
      {
        "id" : "TWPractitionerRole.location",
        "path" : "TWPractitionerRole.location",
        "short" : "此健康照護服務提供者提供照護的地點。",
        "definition" : "此健康照護服務提供者提供照護的地點。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Location"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPractitionerRole",
            "map" : "TWCorePractitionerRole.location.Reference(TW Core Location)"
          }
        ]
      },
      {
        "id" : "TWPractitionerRole.telecom",
        "path" : "TWPractitionerRole.telecom",
        "short" : "此健康照護服務提供者角色/地點/服務的聯絡細節。",
        "definition" : "此健康照護服務提供者角色/地點/服務的聯絡細節。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPractitionerRole",
            "map" : "TWCorePractitionerRole.telecom"
          }
        ]
      }
    ]
  }
}

```
