# 臺灣核心-病人(TW Core Patient)之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-病人(TW Core Patient)之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWPatient | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWPatientModel |

 
臺灣核心-病人(TW Core Patient)之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWPatient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWPatient.csv), [Excel](StructureDefinition-TWPatient.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWPatient",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWPatient",
  "version" : "1.0.0",
  "name" : "TWPatientModel",
  "title" : "臺灣核心-病人(TW Core Patient)之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-病人(TW Core Patient)之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWCore",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWPatient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWPatient",
        "path" : "TWPatient",
        "short" : "臺灣核心-病人(TW Core Patient)之資料模型",
        "definition" : "臺灣核心-病人(TW Core Patient)之資料模型",
        "mapping" : [
          {
            "identity" : "TWCore",
            "map" : "TWCorePatient"
          }
        ]
      },
      {
        "id" : "TWPatient.identifier",
        "path" : "TWPatient.identifier",
        "short" : "身份識別碼(病歷號、身分證字號、護照號碼、居留證號碼等)",
        "definition" : "身份識別碼(病歷號、身分證字號、護照號碼、居留證號碼等)。",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCore",
            "map" : "identifier"
          }
        ]
      },
      {
        "id" : "TWPatient.active",
        "path" : "TWPatient.active",
        "short" : "此基本資料是否使用中。",
        "definition" : "此基本資料是否使用中。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCore",
            "map" : "active"
          }
        ]
      },
      {
        "id" : "TWPatient.name",
        "path" : "TWPatient.name",
        "short" : "姓名，包括病人身分證或護照上的姓名、新生兒報戶口（戶籍登記）前的暫時性姓名、或研究用之匿名化病人姓名等。",
        "definition" : "姓名，包括病人身分證或護照上的姓名、新生兒報戶口（戶籍登記）前的暫時性姓名、或研究用之匿名化病人姓名等。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCore",
            "map" : "name"
          }
        ]
      },
      {
        "id" : "TWPatient.telecom",
        "path" : "TWPatient.telecom",
        "short" : "聯絡方式。",
        "definition" : "聯絡方式。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCore",
            "map" : "telecom"
          }
        ]
      },
      {
        "id" : "TWPatient.gender",
        "path" : "TWPatient.gender",
        "short" : "性別。",
        "definition" : "性別。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCore",
            "map" : "gender"
          }
        ]
      },
      {
        "id" : "TWPatient.birthDate",
        "path" : "TWPatient.birthDate",
        "short" : "出生日期。",
        "definition" : "出生日期。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCore",
            "map" : "birthDate"
          }
        ]
      },
      {
        "id" : "TWPatient.address",
        "path" : "TWPatient.address",
        "short" : "地址(戶籍/現居/工作等)。",
        "definition" : "地址(戶籍/現居/工作等)。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCore",
            "map" : "address"
          }
        ]
      },
      {
        "id" : "TWPatient.maritalStatus",
        "path" : "TWPatient.maritalStatus",
        "short" : "婚姻狀態。",
        "definition" : "婚姻狀態。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCore",
            "map" : "maritalStatus"
          }
        ]
      },
      {
        "id" : "TWPatient.photo",
        "path" : "TWPatient.photo",
        "short" : "病人的影像（照片）。",
        "definition" : "病人的影像（照片）。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Attachment"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCore",
            "map" : "photo"
          }
        ]
      },
      {
        "id" : "TWPatient.contact",
        "path" : "TWPatient.contact",
        "short" : "緊急聯絡人。",
        "definition" : "緊急聯絡人。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCore",
            "map" : "contact"
          }
        ]
      },
      {
        "id" : "TWPatient.communicationLanguage",
        "path" : "TWPatient.communicationLanguage",
        "short" : "溝通語言。",
        "definition" : "溝通語言。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCore",
            "map" : "communication.language"
          }
        ]
      },
      {
        "id" : "TWPatient.organization",
        "path" : "TWPatient.organization",
        "short" : "此紀錄的保管機構。",
        "definition" : "此紀錄的保管機構。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCore",
            "map" : "managingOrganization.Reference(TW Core Organization)"
          }
        ]
      }
    ]
  }
}

```
