# 臺灣核心-機構(TW Core Organization)之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-機構(TW Core Organization)之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWOrganization | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWOrganizationModel |

 
臺灣核心-機構(TW Core Organization)之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWOrganization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWOrganization.csv), [Excel](StructureDefinition-TWOrganization.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWOrganization",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWOrganization",
  "version" : "1.0.0",
  "name" : "TWOrganizationModel",
  "title" : "臺灣核心-機構(TW Core Organization)之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-機構(TW Core Organization)之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWOrganization",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWOrganization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWOrganization",
        "path" : "TWOrganization",
        "short" : "臺灣核心-機構(TW Core Organization)之資料模型",
        "definition" : "臺灣核心-機構(TW Core Organization)之資料模型",
        "mapping" : [
          {
            "identity" : "TWOrganization",
            "map" : "TWCoreOrganization"
          }
        ]
      },
      {
        "id" : "TWOrganization.identifier",
        "path" : "TWOrganization.identifier",
        "short" : "機構唯一識別碼(例如：醫事機構代碼、政府機關代號、統一編碼等)。",
        "definition" : "機構唯一識別碼(例如：醫事機構代碼、政府機關代號、統一編碼等)。",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWOrganization",
            "map" : "TWCoreOrganization.identifier"
          }
        ]
      },
      {
        "id" : "TWOrganization.active",
        "path" : "TWOrganization.active",
        "short" : "此機構基本資料是否使用中。",
        "definition" : "此機構基本資料是否使用中。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWOrganization",
            "map" : "TWCoreOrganization.active"
          }
        ]
      },
      {
        "id" : "TWOrganization.organizationType",
        "path" : "TWOrganization.organizationType",
        "short" : "機構種類。",
        "definition" : "機構種類。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWOrganization",
            "map" : "TWCoreOrganization.type"
          }
        ]
      },
      {
        "id" : "TWOrganization.name",
        "path" : "TWOrganization.name",
        "short" : "機構名稱。",
        "definition" : "機構名稱。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWOrganization",
            "map" : "TWCoreOrganization.name"
          }
        ]
      },
      {
        "id" : "TWOrganization.telecom",
        "path" : "TWOrganization.telecom",
        "short" : "聯絡方式。",
        "definition" : "聯絡方式。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWOrganization",
            "map" : "TWCoreOrganization.telecom"
          }
        ]
      }
    ]
  }
}

```
