# 臺灣核心-檢驗檢查(TW Core Observation) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-檢驗檢查(TW Core Observation) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWObservation | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWObservationModel |

 
臺灣核心-檢驗檢查(TW Core Observation) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWObservation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWObservation.csv), [Excel](StructureDefinition-TWObservation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWObservation",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWObservation",
  "version" : "1.0.0",
  "name" : "TWObservationModel",
  "title" : "臺灣核心-檢驗檢查(TW Core Observation) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-檢驗檢查(TW Core Observation) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWObservation",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWObservation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWObservation",
        "path" : "TWObservation",
        "short" : "臺灣核心-檢驗檢查(TW Core Observation) 之資料模型",
        "definition" : "臺灣核心-檢驗檢查(TW Core Observation) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWObservation",
            "map" : "TWCoreObservationLaboratoryResult 或 TWCoreObservationBloodPressure 或 TWCoreObservationBMI"
          }
        ]
      },
      {
        "id" : "TWObservation.resultStatus",
        "path" : "TWObservation.resultStatus",
        "short" : "檢驗檢查結果之狀態。",
        "definition" : "檢驗檢查結果之狀態。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWObservation",
            "map" : "TWCoreObservationLaboratoryResult.status 或 TWCoreObservationBloodPressure.status 或 TWCoreObservationBMI.status"
          }
        ]
      },
      {
        "id" : "TWObservation.category",
        "path" : "TWObservation.category",
        "short" : "檢驗檢查的類別。",
        "definition" : "檢驗檢查的類別。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWObservation",
            "map" : "TWCoreObservationLaboratoryResult.category 或 TWCoreObservationBloodPressure.category 或 TWCoreObservationBMI.category"
          }
        ]
      },
      {
        "id" : "TWObservation.observationCode",
        "path" : "TWObservation.observationCode",
        "short" : "檢驗檢查代碼，此代碼通常是用來識別所進行的檢驗檢查是哪一項，例如身高、體重、血壓等。",
        "definition" : "檢驗檢查代碼，此代碼通常是用來識別所進行的檢驗檢查是哪一項，例如身高、體重、血壓等。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWObservation",
            "map" : "TWCoreObservationLaboratoryResult.code 或 TWCoreObservationBloodPressure.code 或 TWCoreObservationBMI.code"
          }
        ]
      },
      {
        "id" : "TWObservation.subject",
        "path" : "TWObservation.subject",
        "short" : "檢驗檢查的對象。",
        "definition" : "檢驗檢查的對象。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWObservation",
            "map" : "TWCoreObservationLaboratoryResult.subject.Reference(TW Core Patient) 或 TWCoreObservationBloodPressure.subject.Reference(TW Core Patient) 或 TWCoreObservationBMI.subject.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWObservation.dateTime",
        "path" : "TWObservation.dateTime",
        "short" : "檢驗檢查的日期(時間)。",
        "definition" : "檢驗檢查的日期(時間)。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWObservation",
            "map" : "TWCoreObservationLaboratoryResult.effectiveDateTime 或 TWCoreObservationBloodPressure.effectiveDateTime 或 TWCoreObservationBMI.effectiveDateTime"
          }
        ]
      },
      {
        "id" : "TWObservation.performer",
        "path" : "TWObservation.performer",
        "short" : "負責檢驗檢查的人員。",
        "definition" : "負責檢驗檢查的人員。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWObservation.performer.practitioner",
        "path" : "TWObservation.performer.practitioner",
        "short" : "負責檢驗檢查的某健康照護服務提供者。",
        "definition" : "負責檢驗檢查的某健康照護服務提供者。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Practitioner"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWObservation",
            "map" : "TWCoreObservationLaboratoryResult.performer.Reference(TW Core Practitioner)"
          }
        ]
      },
      {
        "id" : "TWObservation.performer.organization",
        "path" : "TWObservation.performer.organization",
        "short" : "負責檢驗檢查的某機構。",
        "definition" : "負責檢驗檢查的某機構。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Organization"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWObservation",
            "map" : "TWCoreObservationLaboratoryResult.performer.Reference(TW Core Organization)"
          }
        ]
      },
      {
        "id" : "TWObservation.performer.patient",
        "path" : "TWObservation.performer.patient",
        "short" : "負責檢驗檢查的某病人。",
        "definition" : "負責檢驗檢查的某病人。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWObservation",
            "map" : "TWCoreObservationLaboratoryResult.performer.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWObservation.performer.practitionerRole",
        "path" : "TWObservation.performer.practitionerRole",
        "short" : "負責檢驗檢查的某健康照護服務角色。",
        "definition" : "負責檢驗檢查的某健康照護服務角色。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "PractitionerRole"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWObservation",
            "map" : "TWCoreObservationLaboratoryResult.performer.Reference(TW Core PractitionerRole)"
          }
        ]
      },
      {
        "id" : "TWObservation.performer.careTeam",
        "path" : "TWObservation.performer.careTeam",
        "short" : "負責檢驗檢查的某照護團隊。",
        "definition" : "負責檢驗檢查的某照護團隊。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CareTeam"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWObservation",
            "map" : "TWCoreObservationLaboratoryResult.performer.Reference(CareTeam)"
          }
        ]
      },
      {
        "id" : "TWObservation.results",
        "path" : "TWObservation.results",
        "short" : "檢驗檢查結果。",
        "definition" : "檢驗檢查結果。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWObservation",
            "map" : "TWCoreObservationLaboratoryResult.value[x] 或 TWCoreObservationBMI.value[x]"
          }
        ]
      },
      {
        "id" : "TWObservation.subResults",
        "path" : "TWObservation.subResults",
        "short" : "子項檢驗檢查之結果。",
        "definition" : "子項檢驗檢查之結果。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWObservation",
            "map" : "TWCoreObservationBloodPressure.valueQuantity"
          }
        ]
      }
    ]
  }
}

```
