# 臺灣核心-文件參照(TW Core DocumentReference) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-文件參照(TW Core DocumentReference) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWDocumentReference | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWDocumentReferenceModel |

 
臺灣核心-文件參照(TW Core DocumentReference) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWDocumentReference)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWDocumentReference.csv), [Excel](StructureDefinition-TWDocumentReference.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWDocumentReference",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWDocumentReference",
  "version" : "1.0.0",
  "name" : "TWDocumentReferenceModel",
  "title" : "臺灣核心-文件參照(TW Core DocumentReference) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-文件參照(TW Core DocumentReference) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWDocumentReference",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWDocumentReference",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWDocumentReference",
        "path" : "TWDocumentReference",
        "short" : "臺灣核心-文件參照(TW Core DocumentReference) 之資料模型",
        "definition" : "臺灣核心-文件參照(TW Core DocumentReference) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWDocumentReference",
            "map" : "TWCoreDocumentReference"
          }
        ]
      },
      {
        "id" : "TWDocumentReference.masterIdentifier",
        "path" : "TWDocumentReference.masterIdentifier",
        "short" : "主要版本的文件參照識別碼。",
        "definition" : "主要版本的文件參照識別碼。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDocumentReference",
            "map" : "TWCoreDocumentReference.masterIdentifier"
          }
        ]
      },
      {
        "id" : "TWDocumentReference.status",
        "path" : "TWDocumentReference.status",
        "short" : "文件引用的狀態。",
        "definition" : "文件引用的狀態。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDocumentReference",
            "map" : "TWCoreDocumentReference.status"
          }
        ]
      },
      {
        "id" : "TWDocumentReference.subject",
        "path" : "TWDocumentReference.subject",
        "short" : "文件參照的對象。",
        "definition" : "文件參照的對象。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWDocumentReference.subject.patient",
        "path" : "TWDocumentReference.subject.patient",
        "short" : "文件參照的某病人。",
        "definition" : "文件參照的某病人。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDocumentReference",
            "map" : "TWCoreDocumentReference.subject.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWDocumentReference.subject.practitioner",
        "path" : "TWDocumentReference.subject.practitioner",
        "short" : "文件參照的某健康照護服務提供者。",
        "definition" : "文件參照的某健康照護服務提供者。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Practitioner"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDocumentReference",
            "map" : "TWCoreDocumentReference.subject.Reference(TW Core practitioner)"
          }
        ]
      },
      {
        "id" : "TWDocumentReference.subject.group",
        "path" : "TWDocumentReference.subject.group",
        "short" : "文件參照的某團體/群體。",
        "definition" : "文件參照的某團體/群體。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Group"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDocumentReference",
            "map" : "TWCoreDocumentReference.subject.Reference(Group)"
          }
        ]
      },
      {
        "id" : "TWDocumentReference.subject.device",
        "path" : "TWDocumentReference.subject.device",
        "short" : "文件參照的某設備。",
        "definition" : "文件參照的某設備。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Device"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDocumentReference",
            "map" : "TWCoreDocumentReference.subject.Reference(Device)"
          }
        ]
      }
    ]
  }
}

```
