# 臺灣核心-臨床文件架構(TW Core Composition) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-臨床文件架構(TW Core Composition) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWComposition | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCompositionModel |

 
臺灣核心-臨床文件架構(TW Core Composition) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWComposition)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWComposition.csv), [Excel](StructureDefinition-TWComposition.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWComposition",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWComposition",
  "version" : "1.0.0",
  "name" : "TWCompositionModel",
  "title" : "臺灣核心-臨床文件架構(TW Core Composition) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-臨床文件架構(TW Core Composition) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWComposition",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWComposition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWComposition",
        "path" : "TWComposition",
        "short" : "臺灣核心-臨床文件架構(TW Core Composition) 之資料模型",
        "definition" : "臺灣核心-臨床文件架構(TW Core Composition) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition"
          }
        ]
      },
      {
        "id" : "TWComposition.identifier",
        "path" : "TWComposition.identifier",
        "short" : "不分版本的臨床文件架構(Composition)識別碼。",
        "definition" : "不分版本的臨床文件架構(臨床文件架構)識別碼。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.identifier"
          }
        ]
      },
      {
        "id" : "TWComposition.status",
        "path" : "TWComposition.status",
        "short" : "臨床文件架構的工作流程/臨床狀態。",
        "definition" : "臨床文件架構的工作流程/臨床狀態。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.status"
          }
        ]
      },
      {
        "id" : "TWComposition.type",
        "path" : "TWComposition.type",
        "short" : "臨床文件架構的種類(如果可能請使用LOINC)。",
        "definition" : "臨床文件架構的種類(如果可能請使用LOINC)。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.type"
          }
        ]
      },
      {
        "id" : "TWComposition.subject",
        "path" : "TWComposition.subject",
        "short" : "臨床文件架構是關於誰和/或什麼。",
        "definition" : "臨床文件架構是關於誰和/或什麼。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWComposition.subject.patient",
        "path" : "TWComposition.subject.patient",
        "short" : "關於某病人。",
        "definition" : "關於某病人。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.subject.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWComposition.subject.group",
        "path" : "TWComposition.subject.group",
        "short" : "關於某團體/群體。",
        "definition" : "關於某團體/群體。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Group"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.subject.Reference(Group)"
          }
        ]
      },
      {
        "id" : "TWComposition.subject.device",
        "path" : "TWComposition.subject.device",
        "short" : "關於某設備。",
        "definition" : "關於某設備。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Device"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.subject.Reference(Device)"
          }
        ]
      },
      {
        "id" : "TWComposition.subject.substance",
        "path" : "TWComposition.subject.substance",
        "short" : "關於某物質。",
        "definition" : "關於某物質。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Substance"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.subject.Reference(Substance)"
          }
        ]
      },
      {
        "id" : "TWComposition.subject.location",
        "path" : "TWComposition.subject.location",
        "short" : "關於某地點。",
        "definition" : "關於某地點。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Location"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.subject.Reference(TW Core Location)"
          }
        ]
      },
      {
        "id" : "TWComposition.date",
        "path" : "TWComposition.date",
        "short" : "臨床文件架構的編輯時間。",
        "definition" : "臨床文件架構的編輯時間。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.date"
          }
        ]
      },
      {
        "id" : "TWComposition.author",
        "path" : "TWComposition.author",
        "short" : "誰和/或什麼創建了這個臨床文件架構。",
        "definition" : "誰和/或什麼創建了這個臨床文件架構。",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWComposition.author.practitioner",
        "path" : "TWComposition.author.practitioner",
        "short" : "某健康照護服務提供者創建這個臨床文件架構。",
        "definition" : "某健康照護服務提供者創建這個臨床文件架構。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Practitioner"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.author.Reference(TW Core Practitioner)"
          }
        ]
      },
      {
        "id" : "TWComposition.author.practitionerRole",
        "path" : "TWComposition.author.practitionerRole",
        "short" : "某健康照護服務角色創建這個臨床文件架構。",
        "definition" : "健康照護服務角色創建這個臨床文件架構。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "PractitionerRole"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.author.Reference(TW Core PractitionerRole)"
          }
        ]
      },
      {
        "id" : "TWComposition.author.organization",
        "path" : "TWComposition.author.organization",
        "short" : "某機構創建這個臨床文件架構。",
        "definition" : "某機構創建這個臨床文件架構。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Organization"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.author.Reference(TW Core Organization Hospital Department)"
          }
        ]
      },
      {
        "id" : "TWComposition.author.patient",
        "path" : "TWComposition.author.patient",
        "short" : "某病人創建這個臨床文件架構。",
        "definition" : "某病人創建這個臨床文件架構。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.author.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWComposition.author.device",
        "path" : "TWComposition.author.device",
        "short" : "某設備創建這個臨床文件架構。",
        "definition" : "某設備創建這個臨床文件架構。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Device"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.author.Reference(Device)"
          }
        ]
      },
      {
        "id" : "TWComposition.author.relatedPerson",
        "path" : "TWComposition.author.relatedPerson",
        "short" : "某相關人士創建這個臨床文件架構。",
        "definition" : "某相關人士創建這個臨床文件架構。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "RelatedPerson"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.author.Reference(RelatedPerson)"
          }
        ]
      },
      {
        "id" : "TWComposition.title",
        "path" : "TWComposition.title",
        "short" : "人類可讀的名稱/標題。",
        "definition" : "人類可讀的名稱/標題。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.title"
          }
        ]
      },
      {
        "id" : "TWComposition.attester",
        "path" : "TWComposition.attester",
        "short" : "證明臨床文件架構的準確性。",
        "definition" : "證明臨床文件架構的準確性。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.attester"
          }
        ]
      },
      {
        "id" : "TWComposition.custodian",
        "path" : "TWComposition.custodian",
        "short" : "維護臨床文件架構的機構。",
        "definition" : "維護臨床文件架構的機構。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.custodian"
          }
        ]
      },
      {
        "id" : "TWComposition.section",
        "path" : "TWComposition.section",
        "short" : "臨床文件架構被分成一個或數個小節。",
        "definition" : "臨床文件架構被分成一個或數個小節。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWComposition",
            "map" : "TWCoreComposition.section"
          }
        ]
      }
    ]
  }
}

```
