# 臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWAllergyIntolerance | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWAllergyIntoleranceModel |

 
臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWAllergyIntolerance)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWAllergyIntolerance.csv), [Excel](StructureDefinition-TWAllergyIntolerance.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWAllergyIntolerance",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWAllergyIntolerance",
  "version" : "1.0.0",
  "name" : "TWAllergyIntoleranceModel",
  "title" : "臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWAllergyIntolerance",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWAllergyIntolerance",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWAllergyIntolerance",
        "path" : "TWAllergyIntolerance",
        "short" : "臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) 之資料模型",
        "definition" : "臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWAllergyIntolerance",
            "map" : "TWCoreAllergyIntolerance"
          }
        ]
      },
      {
        "id" : "TWAllergyIntolerance.clinicalStatus",
        "path" : "TWAllergyIntolerance.clinicalStatus",
        "short" : "過敏或不耐受的臨床狀態。",
        "definition" : "過敏或不耐受的臨床狀態。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWAllergyIntolerance",
            "map" : "TWCoreAllergyIntolerance.clinicalStatus"
          }
        ]
      },
      {
        "id" : "TWAllergyIntolerance.verificationStatus",
        "path" : "TWAllergyIntolerance.verificationStatus",
        "short" : "關於對特定物質反應的傾向或潜在風險的確定性聲明。",
        "definition" : "關於對特定物質反應的傾向或潜在風險的確定性聲明。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWAllergyIntolerance",
            "map" : "TWCoreAllergyIntolerance.verificationStatus"
          }
        ]
      },
      {
        "id" : "TWAllergyIntolerance.code",
        "path" : "TWAllergyIntolerance.code",
        "short" : "指明此過敏或不耐受的代碼。",
        "definition" : "指明此過敏或不耐受的代碼。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWAllergyIntolerance",
            "map" : "TWCoreAllergyIntolerance.code"
          }
        ]
      },
      {
        "id" : "TWAllergyIntolerance.patient",
        "path" : "TWAllergyIntolerance.patient",
        "short" : "誰有此過敏或不耐受？",
        "definition" : "誰有此過敏或不耐受？",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWAllergyIntolerance",
            "map" : "TWCoreAllergyIntolerance.subject.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWAllergyIntolerance.reaction",
        "path" : "TWAllergyIntolerance.reaction",
        "short" : "暴露於此過敏或不耐受物質的不良反應。",
        "definition" : "暴露於此過敏或不耐受物質的不良反應。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWAllergyIntolerance",
            "map" : "TWCoreAllergyIntolerance.reaction"
          }
        ]
      }
    ]
  }
}

```
