# TW Core PractitionerRole - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core PractitionerRole 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCorePractitionerRole |

 
此臺灣核心-健康照護服務提供者角色（TW Core PractitionerRole） Profile說明本IG如何進一步定義FHIR的PractitionerRole Resource以呈現健康照護服務提供者角色的詳細資料。 

## Resource PractitionerRole - 內容

這是指健康照護服務提供者在某個機構中，一段時間內可以擔任的不同角色、在不同地點提供的服務類型、專業領域等。

### 範圍與使用

健康照護服務提供者角色（PractitionerRole）主要用來記錄健康照護服務提供者（Practitioner）能夠在機構內提供的服務種類和服務地點。

如果需要，可以在PractitionerRole的其他實例中重複記錄角色、專長領域、地點的聯絡資訊和HealthcareService（健康照護服務）的詳情。有的系統會為一個地點記錄一系列服務，有的則是記錄一項服務和它可提供的所有地點。這兩種記錄方式都是可以的。 如果所有健康照護服務或地點的可用性、聯絡方式或其他細節不相同，那麼就應該為每種不同的實例創建一個單獨的PractitionerRole resource。

### 界限與關聯

從Practitioner resource 中獲得的資格認證，雖然不直接代表他們的工作角色，但在機構分配Practitioner到特定角色時可能會考慮到這些資格認證。這些資格認證可能包含一些重要資訊（如有效期限），在某些情況下需要追蹤，以確保Practitioner持續符合特定角色的資格。

照護團隊 （[CareTeam](https://hl7.org/fhir/R4/careteam.html)） resource 也經常用來詳細說明分配給Practitioner的角色，但通常這些角色涉及更細致的照護範疇，並且往往是在特定的 [Patient](StructureDefinition-Patient-twcore.md)背景或功能角色（例如：危機規劃團隊）內。相比之下，PractitionerRole則更廣泛地用於涵蓋 Practitioner 被分配工作的所有地點，以及與那個角色相關的具體細節—如特定的聯絡號碼或電子服務端點 （`endpoint`）。

### 背景

Practitioner 有時候會在同一家或不同家機構中擔任多種不同的工作角色。根據不同地區的法律規定和習慣，有時我們需要為每個角色分別建立一個專門的Pratitioner檔案，或者我們可以只建立一個檔案來記錄這個人的多重角色。這些角色有可能只在一段時間內有效，過了這段時間之後，這個人可能就不再有權擔任這個角色。要注意的是：這裡提到的機構不一定直接雇用了這位Practitioner。

這個 resource 被很多其他的 FHIR resources 參照，像是[簽章（Signature）](https://hl7.org/fhir/R4/datatypes.html#Signature)、[帳戶（Account）](https://hl7.org/fhir/R4/account.html#Account)、[醫療不良事件（AdverseEvent）](https://hl7.org/fhir/R4/adverseevent.html#AdverseEvent)、[過敏或不耐症（AllergyIntolerance）](StructureDefinition-AllergyIntolerance-twcore.md)、[預約（Appointment）](https://hl7.org/fhir/R4/appointment.html#Appointment)等，它們覆蓋了從病人照護到行政管理等多個健康照護領域的活動。

**Usages:**

* Refer to this Profile: [TW Core AllergyIntolerance](StructureDefinition-AllergyIntolerance-twcore.md), [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md), [TW Core CareTeam](StructureDefinition-CareTeam-twcore.md), [TW Core Composition](StructureDefinition-Composition-twcore.md)...Show 38 more,[TW Core Condition](StructureDefinition-Condition-twcore.md),[TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md),[TW Core DocumentReference](StructureDefinition-DocumentReference-twcore.md),[TW Core Encounter](StructureDefinition-Encounter-twcore.md),[TW Core Goal](StructureDefinition-Goal-twcore.md),[TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md),[TW Core Immunization](StructureDefinition-Immunization-twcore.md),[TW Core Media](StructureDefinition-Media-twcore.md),[TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md),[TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md),[TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md),[TW Core MessageHeader](StructureDefinition-MessageHeader-twcore.md),[TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md),[TW Core Observation BMI](StructureDefinition-Observation-bmi-twcore.md),[TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md),[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Care Experience Preference](StructureDefinition-Observation-careExperiencePreference-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Occupation](StructureDefinition-Observation-occupation-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Pregnancy Status](StructureDefinition-Observation-pregnancy-status-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Screening Assessment](StructureDefinition-Observation-screening-assessment-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md),[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md),[TW Core Patient](StructureDefinition-Patient-twcore.md),[TW Core Procedure](StructureDefinition-Procedure-twcore.md),[TW Core Provenance](StructureDefinition-Provenance-twcore.md),[TW Core QuestionnaireResponse](StructureDefinition-QuestionnaireResponse-twcore.md),[TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)and[TW Core Specimen](StructureDefinition-Specimen-twcore.md)
* Examples for this Profile: [PractitionerRole/praro-dr-example](PractitionerRole-praro-dr-example.md), [PractitionerRole/praro-nurse-example](PractitionerRole-praro-nurse-example.md), [PractitionerRole/praro-phc-example](PractitionerRole-praro-phc-example.md) and [PractitionerRole/praro-radio-example](PractitionerRole-praro-radio-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/PractitionerRole-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PractitionerRole-twcore.csv), [Excel](StructureDefinition-PractitionerRole-twcore.xlsx), [Schematron](StructureDefinition-PractitionerRole-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-PractitionerRole-id.md)**查詢所有PractitionerRole：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/PractitionerRole?_id=[id]`
`GET [base]/PractitionerRole/[id]`例子：
(1) GET [base]/PractitionerRole?_id=praro-dr-example
(2) GET [base]/PractitionerRole/praro-dr-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`identifier`](SearchParameter-PractitionerRole-identifier.md)**查詢所有PractitionerRole：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/PractitionerRole?identifier={system|}[code]`例子：
(1) GET [base]/PractitionerRole?identifier=https://www.tph.mohw.gov.tw|KP00017
1. **建議應該（SHOULD）**支援透過查詢參數**[`specialty`](SearchParameter-PractitionerRole-specialty.md)**查詢所有PractitionerRole：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/PractitionerRole?specialty={system|}[code]`例子： (1) GET [base]/PractitionerRole?specialty=418960008



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PractitionerRole-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
  "version" : "1.0.0",
  "name" : "TWCorePractitionerRole",
  "title" : "TW Core PractitionerRole",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-健康照護服務提供者角色（TW Core PractitionerRole） Profile說明本IG如何進一步定義FHIR的PractitionerRole Resource以呈現健康照護服務提供者角色的詳細資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/PractitionerRole",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole",
        "short" : "健康照護服務提供者所關聯的角色/機構",
        "definition" : "健康照護服務提供者可能在一個機構內，一段時間內可能承擔的一系列職務角色（Roles）/工作地點（Locations）/專業領域（specialties）/所提供的服務（services）。"
      },
      {
        "id" : "PractitionerRole.id",
        "path" : "PractitionerRole.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的PractitionerRole紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "PractitionerRole.meta",
        "path" : "PractitionerRole.meta",
        "short" : "此PractitionerRole Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "PractitionerRole.implicitRules",
        "path" : "PractitionerRole.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "PractitionerRole.language",
        "path" : "PractitionerRole.language",
        "short" : "用以表述PractitionerRole Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "PractitionerRole.text",
        "path" : "PractitionerRole.text",
        "short" : "PractitionerRole Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "PractitionerRole.identifier",
        "path" : "PractitionerRole.identifier",
        "short" : "與角色（role）/地點（location）相關的特定業務識別碼",
        "definition" : "與角色(role)/地點（location）相關的特定業務識別碼",
        "requirements" : "通常會為代理人指派特定的身份識別",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.active",
        "path" : "PractitionerRole.active",
        "short" : "此健康照護服務提供者角色紀錄是否有效",
        "definition" : "此健康照護服務提供者角色紀錄是否有效",
        "comment" : "如果此值為 false，則可以參考period資料項目來了解角色的有效時間。如果沒有指定eriod，則無法推斷角色的有效時間。",
        "requirements" : "需要能夠將健康照護服務提供者角色紀錄標記為無效，因為該記錄是錯誤創建的，或已不再有效。",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.period",
        "path" : "PractitionerRole.period",
        "short" : "健康照護服務提供者在這些角色裡被授權執行工作的時間範圍",
        "definition" : "健康照護服務提供者被授權在這些角色中為機構執行工作的時間範圍",
        "requirements" : "即使授權被撤銷，仍需記錄該授權曾經存在的事實。"
      },
      {
        "id" : "PractitionerRole.practitioner",
        "path" : "PractitionerRole.practitioner",
        "short" : "能夠為機構提供所定義服務的健康照護服務提供者",
        "definition" : "能夠為機構提供所定義服務的健康照護服務提供者",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.organization",
        "path" : "PractitionerRole.organization",
        "short" : "提供這此健康照護服務提供者角色的機構",
        "definition" : "此健康照護服務提供者履行相關角色職責的機構",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.code",
        "path" : "PractitionerRole.code",
        "short" : "此健康照護服務提供者可能執行的角色",
        "definition" : "此健康照護服務提供者被授權為機構執行的角色",
        "comment" : "一個人可能有不止一個角色",
        "requirements" : "需要了解健康照護服務提供者的權限 - 他們可以做什麽？",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/health-professional-sct-tw"
        }
      },
      {
        "id" : "PractitionerRole.specialty",
        "path" : "PractitionerRole.specialty",
        "short" : "健康照護服務提供者的特定專業",
        "definition" : "健康照護服務提供者的特定專業",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "PractitionerSpecialty"
            }
          ],
          "strength" : "preferred",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "PractitionerRole.specialty.coding",
        "path" : "PractitionerRole.specialty.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "system"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "PractitionerRole.specialty.coding:TWMedicalDepartmentSCT",
        "path" : "PractitionerRole.specialty.coding",
        "sliceName" : "TWMedicalDepartmentSCT",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medical-department-sct-tw"
        }
      },
      {
        "id" : "PractitionerRole.specialty.coding:TWMedicalDepartmentSCT.system",
        "path" : "PractitionerRole.specialty.coding.system",
        "min" : 1,
        "patternUri" : "http://snomed.info/sct"
      },
      {
        "id" : "PractitionerRole.specialty.coding:TWMedicalConsultationDepartment",
        "path" : "PractitionerRole.specialty.coding",
        "sliceName" : "TWMedicalConsultationDepartment",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medical-consultation-department-tw"
        }
      },
      {
        "id" : "PractitionerRole.specialty.coding:TWMedicalConsultationDepartment.system",
        "path" : "PractitionerRole.specialty.coding.system",
        "min" : 1,
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-tw"
      },
      {
        "id" : "PractitionerRole.specialty.coding:TWMedicalTreatmentDepartment",
        "path" : "PractitionerRole.specialty.coding",
        "sliceName" : "TWMedicalTreatmentDepartment",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medical-treatment-department-tw"
        }
      },
      {
        "id" : "PractitionerRole.specialty.coding:TWMedicalTreatmentDepartment.system",
        "path" : "PractitionerRole.specialty.coding.system",
        "min" : 1,
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-treatment-department-tw"
      },
      {
        "id" : "PractitionerRole.location",
        "path" : "PractitionerRole.location",
        "short" : "此健康照護服務提供者提供照護的地點",
        "definition" : "此健康照護服務提供者提供照護的地點",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.healthcareService",
        "path" : "PractitionerRole.healthcareService",
        "short" : "此工作者為此角色的機構（Organizatoin）/地點（Location）提供的健康照護服務清單",
        "definition" : "此工作者為此角色的機構（Organizatoin）/地點（Location）提供的健康照護服務清單"
      },
      {
        "id" : "PractitionerRole.telecom",
        "path" : "PractitionerRole.telecom",
        "short" : "與角色（role）/地點（location）/服務（service）相關的聯絡細節",
        "definition" : "與角色（role）/地點（location）/服務（service）相關的聯絡細節",
        "requirements" : "健康照護服務提供者通常在工作的每個地點（或服務）都有專用的聯絡方式，需要能夠為每個地點（或服務）定義不同的聯絡資訊",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.telecom.system",
        "path" : "PractitionerRole.telecom.system",
        "definition" : "聯絡方式的通訊形式－需要什麼通訊系統進行聯絡",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ContactPointSystem"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/contact-point-system|4.0.1"
        }
      },
      {
        "id" : "PractitionerRole.telecom.value",
        "path" : "PractitionerRole.telecom.value",
        "short" : "實際的聯絡方式之細節",
        "definition" : "實際的聯絡方式之細節，針對指定的通訊系統提供有意義的形式（電話號碼或是電子郵件位址）",
        "comment" : "額外的文字資料，例如電話分機號碼、或關於聯絡人的說明，有時也包括於此值。",
        "requirements" : "需支援非嚴格格式控制之舊有號碼",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.telecom.use",
        "path" : "PractitionerRole.telecom.use",
        "short" : "home | work | temp | old | mobile－此聯絡方式的用途",
        "definition" : "確定聯絡方式的用途",
        "comment" : "應用程式可以假定一個聯絡方法是目前使用中，除非它明確說它是暫時的或舊的。",
        "requirements" : "需要追蹤此人使用這種聯絡的方式，使用者可以選擇適合他們用途的聯絡方式。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ContactPointUse"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/contact-point-use|4.0.1"
        }
      },
      {
        "id" : "PractitionerRole.telecom.rank",
        "path" : "PractitionerRole.telecom.rank",
        "short" : "具體說明偏好的使用順序（1=最高優先順序）",
        "definition" : "具體說明使用一組聯繫方式的優先順序，較小排名序位的聯絡方式比較大排名序位的聯絡方式之序位還要前面。",
        "comment" : "請注意，排名序位沒有一定要遵循聯絡方式在實例中呈現的順序。"
      },
      {
        "id" : "PractitionerRole.telecom.period",
        "path" : "PractitionerRole.telecom.period",
        "short" : "此聯絡方式的使用效期",
        "definition" : "此聯絡方式的使用效期",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.availableTime",
        "path" : "PractitionerRole.availableTime",
        "short" : "服務地點可用的時間",
        "definition" : "健康照護服務提供者在該地點和/或健康照護服務以履行該角色職責的時間集合",
        "comment" : "更詳細的可用性訊息可在相關的時間表/時隙resource中提供。"
      },
      {
        "id" : "PractitionerRole.availableTime.daysOfWeek",
        "path" : "PractitionerRole.availableTime.daysOfWeek",
        "definition" : "此服務地點，在規定的開始和結束時間內，一週中哪些天是開放的。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DaysOfWeek"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/days-of-week|4.0.1"
        }
      },
      {
        "id" : "PractitionerRole.availableTime.allDay",
        "path" : "PractitionerRole.availableTime.allDay",
        "short" : "隨時可用？ 例如：24 小時服務。",
        "definition" : "此服務地點是否始終開放？（因此時間並不重要），例如 24 小時服務。"
      },
      {
        "id" : "PractitionerRole.availableTime.availableStartTime",
        "path" : "PractitionerRole.availableTime.availableStartTime",
        "short" : "每天的開放時間（如果 allDay = true，則忽略。）",
        "definition" : "每天的開放時間（如果 allDay = true，則忽略。）",
        "comment" : "預計時區為提供該醫療保健服務的地點的時區。"
      },
      {
        "id" : "PractitionerRole.availableTime.availableEndTime",
        "path" : "PractitionerRole.availableTime.availableEndTime",
        "short" : "每天的關閉時間（如果 allDay = true，則忽略。）",
        "definition" : "每天的關閉時間（如果 allDay = true，則忽略。）",
        "comment" : "預計時區為提供該醫療保健服務的地點的時區。"
      },
      {
        "id" : "PractitionerRole.notAvailable",
        "path" : "PractitionerRole.notAvailable",
        "short" : "由於提供的原因，在此期間無法使用。",
        "definition" : "由於所提供的原因，此健康照護服務提供者在此期間無法上班或無法履行此角色職責。"
      },
      {
        "id" : "PractitionerRole.notAvailable.description",
        "path" : "PractitionerRole.notAvailable.description",
        "short" : "向使用者說明為什麼此期間無法使用的原因",
        "definition" : "向使用者說明為什麽沒有這個時間的原因"
      },
      {
        "id" : "PractitionerRole.notAvailable.during",
        "path" : "PractitionerRole.notAvailable.during",
        "short" : "從這個日期起，服務將不再提供。",
        "definition" : "此服務從此日期起暫時無法提供（季節性或國定假日）"
      },
      {
        "id" : "PractitionerRole.availabilityExceptions",
        "path" : "PractitionerRole.availabilityExceptions",
        "short" : "描述在特定情況下服務不可用的特例",
        "definition" : "對於服務地點可用性的所有例外情況進行描述，例如國定假日的可用性。簡要描述了所有可能影響可用性的例外情況，包括可用時間和不可用時間的細節。"
      },
      {
        "id" : "PractitionerRole.endpoint",
        "path" : "PractitionerRole.endpoint",
        "short" : "提供用於此健康照護服務提供者角色運營服務的技術端點",
        "definition" : "提供用於此健康照護服務提供者角色運營服務的技術端點",
        "requirements" : "機構在不同健康照護服務提供者角色有提供各種服務的不同系統，需要明確怎樣以及為了什麼目的來連接這些系統的技術詳情。"
      }
    ]
  }
}

```
