# TW Core Practitioner - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Practitioner 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCorePractitioner |

 
tifier:residentNumber欄位的identifier.system改為 = http://www.immigration.gov.tw。 
此臺灣核心-健康照護服務提供者（TW Core Practitioner） Profile說明本IG如何進一步定義FHIR的Practitioner Resource以呈現健康照護服務提供者基本資料。 

## Resource Practitioner - 內容

直接或間接地參與健康照護服務提供的人員

### 範圍與使用

Practitioner 涵蓋了所有參與健康照護過程和與健康照護相關的服務的人員，作為他們正式職責的一部分，而這個 Resource 被用來對這些人員進行的活動和責任進行歸屬。Practitioners 包括（但不限於）：

* 醫生、牙醫、藥劑師
* 醫師助理、護士、書記
* 助產士、營養師、治療師、驗光師、護理人員
* 醫檢師、實驗室科學家、義肢技術人員、放射技師
* 社工、專業家庭照護提供者、官方志工
* 病人掛號行政櫃台人員
* 負責合併或分離病人紀錄的 IT 人員
* 服務動物（例如：被分配到病房的狗，能夠在病人中檢測出癌症）

### 界限與關聯

這個 Resource **必須不用（SHALL NOT）** 於那些沒有正式責任的參與者，比如照顧朋友、親戚或鄰居的個人。這些人可以登記為病人的聯絡人。如果正在執行某些動作或被另一個 resource 參照，請使用 [RelatedPerson](https://hl7.org/fhir/R4/relatedperson.html) resource。

Practitioner 和 RelatedPerson 之間的主要區別基於：

* 如果這個人員或動物是代表照護提供機構對多位病人進行操作的（Practitioner），或者
* 如果這個人員或動物並未與該機構關聯，而是特別為 RelatedPerson 的病人分配任務（RelatedPerson）。

一個標準的擴充資料項目動物的物種 （[`animalSpecies`](https://hl7.org/fhir/R4/extension-practitioner-animalspecies.html) ）可以用來指出服務動物的物種。

[PractitionerRole](https://hl7.org/fhir/R4/practitionerrole.html) resource 提供了健康照護服務提供者被批准執行的角色的細節，這些角色對於哪些機構（在哪些位置，以及可選的是什麼服務）。

practitioner也經常根據角色獨立地被分組進入照護團隊（[CareTeams](https://hl7.org/fhir/R4/careteam.html)），在這裡，CareTeam 定義了他們在團隊內履行的具體角色，並且可能會或可能不會為 practitioner 創建實際的PractitionerRole resources （並且在care team的情境下，還涉及practitioner代表的機構）。

### 背景

Practitioner 在同一個或甚至不同的機構中擔任不同的角色。根據不同的行政區域和習慣，可能需要針對每個這樣的角色維持一個專門的 Practitioner Resource，或者有一個單獨的 Practitioner 同時具備多個角色。這個角色可能只限於一定的時間範圍，在這段時間之後，對這個角色的授權就會結束。值得注意的是，代表的機構不必然是 Practitioner 的（直接）雇主。

Practitioner resource 被以下 resources 所參照：註釋（[Annotation](https://hl7.org/fhir/R4/datatypes.html#Annotation)）、簽章（[Signature](https://hl7.org/fhir/R4/datatypes.html#Signature)）、帳戶（[Account](https://hl7.org/fhir/R4/account.html#Account)）、醫療不良事件（[AdverseEvent](https://hl7.org/fhir/R4/adverseevent.html#AdverseEvent)）、過敏或不耐症（[AllergyIntolerance](StructureDefinition-AllergyIntolerance-twcore.md)）、預約（[Appointment](https://hl7.org/fhir/R4/appointment.html#Appointment)）、預約回應（[AppointmentResponse](https://hl7.org/fhir/R4/appointmentresponse.html#AppointmentResponse)）、稽核事件（[AuditEvent](https://hl7.org/fhir/R4/auditevent.html#AuditEvent)）、基本（[Basic](https://hl7.org/fhir/R4/basic.html#Basic)）、生物衍生產品（[BiologicallyDerivedProduct](https://hl7.org/fhir/R4/biologicallyderivedproduct.html#BiologicallyDerivedProduct)）、照護計畫（[CarePlan](https://hl7.org/fhir/R4/careplan.html#CarePlan)）、照護團隊（[CareTeam](https://hl7.org/fhir/R4/careteam.html#CareTeam)）、目錄內的條目（[CatalogEntry](https://hl7.org/fhir/R4/catalogentry.html#CatalogEntry)）、費用項目（[ChargeItem](https://hl7.org/fhir/R4/chargeitem.html#ChargeItem)）、理賠申請（[Claim](https://hl7.org/fhir/R4/claim.html#Claim)）、理賠申請回應（[ClaimResponse](https://hl7.org/fhir/R4/claimresponse.html#ClaimResponse)）、臨床臆斷（[ClinicalImpression](https://hl7.org/fhir/R4/clinicalimpression.html#ClinicalImpression)）、通訊（[Communication](https://hl7.org/fhir/R4/communication.html#Communication)）、通訊請求（[CommunicationRequest](https://hl7.org/fhir/R4/communicationrequest.html#CommunicationRequest)）、臨床文件架構（[Composition](StructureDefinition-Composition-twcore.md)）、病情、問題或診斷（[Condition](StructureDefinition-Condition-twcore.md)）、同意書（[Consent](https://hl7.org/fhir/R4/consent.html#Consent)）、合約（[Contract](https://hl7.org/fhir/R4/contract.html#Contract)）、給付資格請求（[CoverageEligibilityRequest](https://hl7.org/fhir/R4/coverageeligibilityrequest.html#CoverageEligibilityRequest)）、給付資格回應（[CoverageEligibilityResponse](https://hl7.org/fhir/R4/coverageeligibilityresponse.html#CoverageEligibilityResponse)）、檢測到的問題（[DetectedIssue](https://hl7.org/fhir/R4/detectedissue.html#DetectedIssue)）、設備請求（[DeviceRequest](https://hl7.org/fhir/R4/devicerequest.html#DeviceRequest)）、設備使用聲明（[DeviceUseStatement](https://hl7.org/fhir/R4/deviceusestatement.html#DeviceUseStatement)）、診斷報告（[DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md)）、文件清單（[DocumentManifest](https://hl7.org/fhir/R4/documentmanifest.html#DocumentManifest)）、文件參照（[DocumentReference](StructureDefinition-DocumentReference-twcore.md)）、就醫事件（[Encounter](StructureDefinition-Encounter-twcore.md)）、加入或退出保險計畫請求（[EnrollmentRequest](https://hl7.org/fhir/R4/enrollmentrequest.html#EnrollmentRequest)）、加入或退出保險計畫回應（[EnrollmentResponse](https://hl7.org/fhir/R4/enrollmentresponse.html#EnrollmentResponse)）、照護事件（[EpisodeOfCare](https://hl7.org/fhir/R4/episodeofcare.html#EpisodeOfCare)）、利益說明（[ExplanationOfBenefit](https://hl7.org/fhir/R4/explanationofbenefit.html#ExplanationOfBenefit)）、標記（[Flag](https://hl7.org/fhir/R4/flag.html#Flag)）、目的（[Goal](https://hl7.org/fhir/R4/goal.html#Goal)）、群體（[Group](https://hl7.org/fhir/R4/group.html#Group)）、影像檢查（[ImagingStudy](StructureDefinition-ImagingStudy-twcore.md)）、疫苗接種（[Immunization](https://hl7.org/fhir/R4/immunization.html#Immunization)）、發票或費用清單（[Invoice](https://hl7.org/fhir/R4/invoice.html#Invoice)）、連結（[Linkage](https://hl7.org/fhir/R4/linkage.html#Linkage)）、清單（[List](https://hl7.org/fhir/R4/list.html#List)）、測量報告（[MeasureReport](https://hl7.org/fhir/R4/measurereport.html#MeasureReport)）、多媒體（[Media](StructureDefinition-Media-twcore.md)）、給藥（[MedicationAdministration](https://hl7.org/fhir/R4/medicationadministration.html#MedicationAdministration)）、配藥或調劑藥品（[MedicationDispense](https://hl7.org/fhir/R4/medicationdispense.html#MedicationDispense)）、藥品請求（[MedicationRequest](https://hl7.org/fhir/R4/medicationrequest.html#MedicationRequest)）、用藥聲明（[MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)）、訊息表頭（[MessageHeader](StructureDefinition-MessageHeader-twcore.md)）、營養醫令（[NutritionOrder](https://hl7.org/fhir/R4/nutritionorder.html#NutritionOrder)）、檢驗檢查（[Observation](StructureDefinition-Observation-laboratoryResult-twcore.md)）、病人（[Patient](StructureDefinition-Patient-twcore.md)）、付款通知（[PaymentNotice](https://hl7.org/fhir/R4/paymentnotice.html#PaymentNotice)）、付款對帳（[PaymentReconciliation](https://hl7.org/fhir/R4/paymentreconciliation.html#PaymentReconciliation)）、人（[Person](https://hl7.org/fhir/R4/person.html#Person)）、 健康照護服務提供者角色 （[PractitionerRole](StructureDefinition-PractitionerRole-twcore.md)）、 處置（[Procedure](StructureDefinition-Procedure-twcore.md)）、出處（[Provenance](https://hl7.org/fhir/R4/provenance.html#Provenance)）、問卷題目回覆（[QuestionnaireResponse](https://hl7.org/fhir/R4/questionnaireresponse.html#QuestionnaireResponse)）、一組請求（[RequestGroup](https://hl7.org/fhir/R4/requestgroup.html#RequestGroup)）、研究（[ResearchStudy](https://hl7.org/fhir/R4/researchstudy.html#ResearchStudy)）、風險評估（[RiskAssessment](https://hl7.org/fhir/R4/riskassessment.html#RiskAssessment)）、時間表（[Schedule](https://hl7.org/fhir/R4/schedule.html#Schedule)）、服務請求（[ServiceRequest](https://hl7.org/fhir/R4/servicerequest.html#ServiceRequest)）、檢體（[Specimen](StructureDefinition-Specimen-twcore.md)）、供應品遞交（[SupplyDelivery](https://hl7.org/fhir/R4/supplydelivery.html#SupplyDelivery)）、供應品請求（[SupplyRequest](https://hl7.org/fhir/R4/supplyrequest.html#SupplyRequest)）、任務（[Task](https://hl7.org/fhir/R4/task.html#Task)）、驗證結果（[VerificationResult](https://hl7.org/fhir/R4/verificationresult.html#VerificationResult)）及視力處方（[VisionPrescription](https://hl7.org/fhir/R4/visionprescription.html#VisionPrescription)）

**Usages:**

* Refer to this Profile: [TW Core AllergyIntolerance](StructureDefinition-AllergyIntolerance-twcore.md), [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md), [TW Core CareTeam](StructureDefinition-CareTeam-twcore.md), [TW Core Composition](StructureDefinition-Composition-twcore.md)...Show 39 more,[TW Core Condition](StructureDefinition-Condition-twcore.md),[TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md),[TW Core DocumentReference](StructureDefinition-DocumentReference-twcore.md),[TW Core Encounter](StructureDefinition-Encounter-twcore.md),[TW Core Goal](StructureDefinition-Goal-twcore.md),[TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md),[TW Core Immunization](StructureDefinition-Immunization-twcore.md),[TW Core Media](StructureDefinition-Media-twcore.md),[TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md),[TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md),[TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md),[TW Core MessageHeader](StructureDefinition-MessageHeader-twcore.md),[TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md),[TW Core Observation BMI](StructureDefinition-Observation-bmi-twcore.md),[TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md),[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Care Experience Preference](StructureDefinition-Observation-careExperiencePreference-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Occupation](StructureDefinition-Observation-occupation-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Pregnancy Status](StructureDefinition-Observation-pregnancy-status-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Screening Assessment](StructureDefinition-Observation-screening-assessment-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md),[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md),[TW Core Patient](StructureDefinition-Patient-twcore.md),[TW Core PractitionerRole](StructureDefinition-PractitionerRole-twcore.md),[TW Core Procedure](StructureDefinition-Procedure-twcore.md),[TW Core Provenance](StructureDefinition-Provenance-twcore.md),[TW Core QuestionnaireResponse](StructureDefinition-QuestionnaireResponse-twcore.md),[TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)and[TW Core Specimen](StructureDefinition-Specimen-twcore.md)
* Examples for this Profile: [Practitioner/pra-dr-example](Practitioner-pra-dr-example.md), [Practitioner/pra-nurse-example](Practitioner-pra-nurse-example.md), [Practitioner/pra-phc-example](Practitioner-pra-phc-example.md) and [Practitioner/pra-radio-example](Practitioner-pra-radio-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Practitioner-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Practitioner-twcore.csv), [Excel](StructureDefinition-Practitioner-twcore.xlsx), [Schematron](StructureDefinition-Practitioner-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Practitioner-id.md)**查詢所有Practitioner：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Practitioner?_id=[id]`
`GET [base]/Practitioner/[id]`例子：
(1) GET [base]/Practitioner?_id=pra-dr-example
(2) GET [base]/Practitioner/pra-dr-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`identifier`](SearchParameter-Practitioner-identifier.md)**查詢所有Practitioner：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Practitioner?identifier={system|}[code]`例子：
(1) GET [base]/Practitioner?identifier=https://www.tph.mohw.gov.tw|KP00017
1. **建議應該（SHOULD）**支援透過查詢參數**[`name`](SearchParameter-Practitioner-name.md)**查詢所有Practitioner，該查詢可能與 HumanName 中的任何字串匹配，包括完整的中文姓名(text)、英文姓(family)、英文名(given)、姓名前面的頭銜(prefix)、姓名後面的稱謂(suffix)：
([如何透過string查詢](http://hl7.org/fhir/R4/search.html#string))
`GET [base]/Practitioner?name=[name]`例子： (1) GET [base]/Practitioner?name=王依昇



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Practitioner-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
  "version" : "1.0.0",
  "name" : "TWCorePractitioner",
  "title" : "TW Core Practitioner",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "tifier:residentNumber欄位的identifier.system改為 = http://www.immigration.gov.tw。  \n\n此臺灣核心-健康照護服務提供者（TW Core Practitioner） Profile說明本IG如何進一步定義FHIR的Practitioner Resource以呈現健康照護服務提供者基本資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Practitioner",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner",
        "short" : "對於所提供之健康照護或相關服務負有正式責任的人員",
        "definition" : "直接或間接提供健康照護的人員"
      },
      {
        "id" : "Practitioner.id",
        "path" : "Practitioner.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的Practitioner紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "Practitioner.meta",
        "path" : "Practitioner.meta",
        "short" : "此Practitioner Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "Practitioner.implicitRules",
        "path" : "Practitioner.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "Practitioner.language",
        "path" : "Practitioner.language",
        "short" : "用以表述Practitioner Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "Practitioner.text",
        "path" : "Practitioner.text",
        "short" : "Practitioner Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "Practitioner.identifier",
        "path" : "Practitioner.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type.coding.code"
            },
            {
              "type" : "value",
              "path" : "type.coding.system"
            }
          ],
          "rules" : "open"
        },
        "short" : "此照護服務提供人員的識別碼",
        "definition" : "此人員於此角色的識別碼",
        "requirements" : "通常此人員會被指定特定識別碼",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier.use",
        "path" : "Practitioner.identifier.use",
        "short" : "usual ｜ official ｜ temp ｜ secondary ｜ old （如果知道）",
        "definition" : "這個唯一識別碼（identifier）的用途",
        "comment" : "應用程式可以假定一個識別碼是永久的，除非它明確說它是暫時的。",
        "requirements" : "允許從一組識別碼中為特定的使用情境選擇適當的識別碼",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "IdentifierUse"
            }
          ],
          "strength" : "required",
          "description" : "識別碼的型別，用於決定特定目的所適用的識別碼；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use|4.0.1"
        }
      },
      {
        "id" : "Practitioner.identifier.type",
        "path" : "Practitioner.identifier.type",
        "short" : "照護服務提供人員的識別碼（identifier）的型別說明",
        "definition" : "識別碼的代碼型別，用於決定特定目適用的識別碼。",
        "comment" : "這個資料項目只涉及識別碼的一般類別。它 **必須沒有（SHALL NOT）** 被用於與Identifier.system 1..1對應的代碼。一些識別碼可能由於常見的用法而屬於多個類別。在系統是已知的情況下，型別是不必要的，因為型別總是系統定義的一部分。然而，系統經常需要處理系統不為人知的識別碼。型別和系統之間不是1:1的關係，因為許多不同的系統有相同的型別。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "IdentifierType"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-type"
        }
      },
      {
        "id" : "Practitioner.identifier.system",
        "path" : "Practitioner.identifier.system",
        "short" : "照護服務提供人員識別碼（identifier）的命名空間（namespace）",
        "definition" : "建立值的命名空間－即一個描述一組值的唯一URL",
        "comment" : "Identifier.system總是區分大小寫",
        "requirements" : "有許多識別碼的集合。為了進行兩個識別碼的對應，我們需要知道我們處理的是哪一組。系統指明了一個特定的唯一識別碼集。",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier.value",
        "path" : "Practitioner.identifier.value",
        "short" : "唯一值。\n例如：照護服務提供人員之員工編號為KP00017",
        "definition" : "識別碼中通常與使用者有關的部分，在系統情境內是唯一的。",
        "comment" : "如果此值是一個完整的URI，那麼此系統 **必須（SHALL）** 是urn:ietf:rfc:3986。此值的主要目的是為了可運算的對應。因此，為了比較的目的，它可能會被正規化（例如：去除不重要的空白、破折號等）。一個為人顯示的格式化的值可以使用[Rendered Value](http://hl7.org/fhir/R4/extension-rendered-value.html)擴充來傳達。除非對Identifier.system的了解使處理者確信不區分大小寫的處理是安全的，否則Identifier.value應被視為區分大小寫。",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier.period",
        "path" : "Practitioner.identifier.period",
        "short" : "此身份識別碼（identifier）的使用效期",
        "definition" : "識別碼有效／曾經有效使用的時段或期間"
      },
      {
        "id" : "Practitioner.identifier.assigner",
        "path" : "Practitioner.identifier.assigner",
        "short" : "簽發identifier的機構（可以只是文字表述）",
        "definition" : "簽發／管理識別碼的機構",
        "comment" : "Identifier.assigner可以省略.reference資料項目，只包含一個.display資料項目，反映指定機構的名稱或其他文字表述資訊。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Practitioner.identifier:idCardNumber",
        "path" : "Practitioner.identifier",
        "sliceName" : "idCardNumber",
        "short" : "適用身分證字號",
        "definition" : "適用於身分證字號",
        "requirements" : "通常此人員總是被指定一個特定的數值型的唯一識別碼（identifier）",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "id-card-number",
            "severity" : "error",
            "human" : "身分證號共十碼，首碼以英文字母代表直轄市、縣（市）別，第二碼至第十碼為數字碼。",
            "expression" : "value.matches('^[A-Za-z][0-9]{9}$')",
            "source" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:idCardNumber.use",
        "path" : "Practitioner.identifier.use",
        "short" : "usual ｜ official ｜ temp ｜ secondary ｜ old （如果知道）",
        "definition" : "這個唯一識別碼（identifier）的用途",
        "comment" : "應用程式可以假定一個識別碼是永久的，除非它明確說它是暫時的。",
        "requirements" : "允許從一組識別碼中為特定的使用情境選擇適當的識別碼",
        "patternCode" : "official",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "IdentifierUse"
            }
          ],
          "strength" : "required",
          "description" : "如果知道，請說明此識別碼的目的；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use|4.0.1"
        }
      },
      {
        "id" : "Practitioner.identifier:idCardNumber.type",
        "path" : "Practitioner.identifier.type",
        "short" : "身份識別碼（identifier）的型別說明",
        "definition" : "識別碼的代碼型別，用於決定特定目適用的識別碼。",
        "comment" : "這個資料項目只涉及識別碼的一般類別。它 **必須沒有（SHALL NOT）** 被用於與Identifier.system 1..1對應的代碼。一些識別碼可能由於常見的用法而屬於多個類別。在系統是已知的情況下，型別是不必要的，因為型別總是系統定義的一部分。然而，系統經常需要處理系統不為人知的識別碼。型別和系統之間不是1:1的關係，因為許多不同的系統有相同的型別。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "識別碼的型別，用於決定特定目的所適用的識別碼；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/identifier-type-tw"
        }
      },
      {
        "id" : "Practitioner.identifier:idCardNumber.type.coding",
        "path" : "Practitioner.identifier.type.coding",
        "short" : "由專門術語系統（terminology system）定義的代碼",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier:idCardNumber.type.coding.system",
        "path" : "Practitioner.identifier.type.coding.system",
        "short" : "專門術語系統（terminology system）的識別",
        "definition" : "定義代碼中符號意義的代碼系統識別",
        "comment" : "URI可以是一個OID（urn:oid:...）或一個UUID（urn:uuid:...）；OID和UUID **必須（SHALL）** 參照HL7 OID註冊中心；否則，URI應該來自HL7的FHIR定義的特殊URI列表，或者它應該參照一些明確建立的系统定義。",
        "requirements" : "需要明確說明符號定義的來源",
        "min" : 1,
        "patternUri" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:idCardNumber.type.coding.version",
        "path" : "Practitioner.identifier.type.coding.version",
        "short" : "系統的版本—如果相關的話",
        "definition" : "選擇此代碼時使用的代碼系統版本；請注意，一個維護良好的代碼系統不需要版本報告，因為代碼的意義在不同系統版本中是一致的；然而，不能始終保證這點，當不能保證意義一致時， **必須（SHALL）** 將版本資訊也一併作交換。",
        "comment" : "如果專門術語沒有明確定義應該使用什麼字串來識別代碼系統的版本，建議使用版本正式發布的日期（用FHIR日期格式表示）作為版本日期。"
      },
      {
        "id" : "Practitioner.identifier:idCardNumber.type.coding.code",
        "path" : "Practitioner.identifier.type.coding.code",
        "short" : "系統定義的語法之符號",
        "definition" : "系統定義的語法之符號；符號可能是一個預先定義的代碼，也可能是代碼系統定義的語法中的表達式（如後組合配對／後組合式）。",
        "requirements" : "需要參照系統中的一個特定代碼",
        "min" : 1,
        "patternCode" : "NNxxx",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:idCardNumber.type.coding.code.extension",
        "path" : "Practitioner.identifier.type.coding.code.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Practitioner.identifier:idCardNumber.type.coding.code.extension:identifier-suffix",
        "path" : "Practitioner.identifier.type.coding.code.extension",
        "sliceName" : "identifier-suffix",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/identifier-suffix"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:idCardNumber.type.coding.display",
        "path" : "Practitioner.identifier.type.coding.display",
        "short" : "由系統定義的表示法",
        "definition" : "遵循系統的規則以呈現代碼含義的表示法",
        "requirements" : "需要能為不了解此系統的讀者呈現可讀的代碼含義",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:idCardNumber.type.coding.userSelected",
        "path" : "Practitioner.identifier.type.coding.userSelected",
        "short" : "此編碼是否由使用者直接選擇？",
        "definition" : "表明此編碼是由使用者直接選擇，例如：從可用項目（代碼或顯示名稱）的清單中選擇。",
        "comment" : "在一系列備選方案中，直接選擇的代碼是新翻譯最合適的起點；關於「直接選擇」的確切意義，存在模糊不清之處，可能需要貿易夥伴的同意，以更完整澄清此資料項目的使用及其後果。",
        "requirements" : "已被確定為一個臨床安全準則—此確切的系統／代碼對(code pair)是被明確選擇的，而不是由系統根據一些規則或是程式語言處理判斷。"
      },
      {
        "id" : "Practitioner.identifier:idCardNumber.type.text",
        "path" : "Practitioner.identifier.type.text",
        "short" : "概念的文字表示法",
        "definition" : "輸入資料的使用者所見／所選／所說的人類可讀文字表述，和（或）其代表使用者的預期含義。",
        "comment" : "很多時候，此文字表述與其中一個代碼的顯示名稱相同。",
        "requirements" : "專門術語中的代碼並不總是能捕捉人類使用的細微差別的正確意義，或者根本就沒有合適的代碼；這些情況下，文字表述被用來捕捉來源的全部意義。",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:idCardNumber.system",
        "path" : "Practitioner.identifier.system",
        "short" : "身份識別碼（identifier）的命名空間（namespace）\n例如：身分證字號='http://www.moi.gov.tw'",
        "definition" : "建立值的命名空間－即一個描述一組值的唯一URL",
        "comment" : "Identifier.system總是區分大小寫",
        "requirements" : "有許多識別碼的集合。為了進行兩個識別碼的對應，我們需要知道我們處理的是哪一組。系統指明了一個特定的唯一識別碼集。",
        "min" : 1,
        "patternUri" : "http://www.moi.gov.tw",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:idCardNumber.value",
        "path" : "Practitioner.identifier.value",
        "short" : "唯一值。\n例如：身分證字號為A123456789",
        "definition" : "識別碼中通常與使用者有關的部分，在系統情境內是唯一的。",
        "comment" : "如果此值是一個完整的URI，那麼此系統 **必須（SHALL）** 是urn:ietf:rfc:3986。此值的主要目的是為了可運算的對應。因此，為了比較的目的，它可能會被正規化（例如：去除不重要的空白、破折號等）。一個為人顯示的格式化的值可以使用[Rendered Value](http://hl7.org/fhir/R4/extension-rendered-value.html)擴充來傳達。除非對Identifier.system的了解使處理者確信不區分大小寫的處理是安全的，否則Identifier.value應被視為區分大小寫。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:idCardNumber.period",
        "path" : "Practitioner.identifier.period",
        "short" : "此身份識別碼（identifier）的使用效期",
        "definition" : "識別碼有效／曾經有效使用的時段或期間"
      },
      {
        "id" : "Practitioner.identifier:idCardNumber.assigner",
        "path" : "Practitioner.identifier.assigner",
        "short" : "簽發identifier的機構（可以只是文字表述）",
        "definition" : "簽發／管理識別碼的機構",
        "comment" : "Identifier.assigner可以省略.reference資料項目，只包含一個.display資料項目，反映指定機構的名稱或其他文字表述資訊。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Practitioner.identifier:passportNumber",
        "path" : "Practitioner.identifier",
        "sliceName" : "passportNumber",
        "short" : "適用護照號碼",
        "definition" : "適用於護照號碼",
        "requirements" : "通常此人員總是被指定一個特定的數值型的唯一識別碼（identifier）",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:passportNumber.use",
        "path" : "Practitioner.identifier.use",
        "short" : "usual ｜ official ｜ temp ｜ secondary ｜ old （如果知道）",
        "definition" : "這個唯一識別碼（identifier）的用途",
        "comment" : "應用程式可以假定一個識別碼是永久的，除非它明確說它是暫時的。",
        "requirements" : "允許從一組識別碼中為特定的使用情境選擇適當的識別碼",
        "patternCode" : "official",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "IdentifierUse"
            }
          ],
          "strength" : "required",
          "description" : "如果知道，請說明此識別碼的目的；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use|4.0.1"
        }
      },
      {
        "id" : "Practitioner.identifier:passportNumber.type",
        "path" : "Practitioner.identifier.type",
        "short" : "身份識別碼（identifier）的型別說明",
        "definition" : "識別碼的代碼型別，用於決定特定目適用的識別碼。",
        "comment" : "這個資料項目只涉及識別碼的一般類別。它 **必須沒有（SHALL NOT）** 被用於與Identifier.system 1..1對應的代碼。一些識別碼可能由於常見的用法而屬於多個類別。在系統是已知的情況下，型別是不必要的，因為型別總是系統定義的一部分。然而，系統經常需要處理系統不為人知的識別碼。型別和系統之間不是1:1的關係，因為許多不同的系統有相同的型別。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "識別碼的型別，用於決定特定目的所適用的識別碼；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/identifier-type-tw"
        }
      },
      {
        "id" : "Practitioner.identifier:passportNumber.type.coding",
        "path" : "Practitioner.identifier.type.coding",
        "short" : "由專門術語系統（terminology system）定義的代碼",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:passportNumber.type.coding.system",
        "path" : "Practitioner.identifier.type.coding.system",
        "short" : "專門術語系統（terminology system）的識別",
        "definition" : "定義代碼中符號意義的代碼系統識別",
        "comment" : "URI可以是一個OID（urn:oid:...）或一個UUID（urn:uuid:...）；OID和UUID **必須（SHALL）** 參照HL7 OID註冊中心；否則，URI應該來自HL7的FHIR定義的特殊URI列表，或者它應該參照一些明確建立的系统定義。",
        "requirements" : "需要明確說明符號定義的來源",
        "min" : 1,
        "patternUri" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:passportNumber.type.coding.version",
        "path" : "Practitioner.identifier.type.coding.version",
        "short" : "系統的版本—如果相關的話",
        "definition" : "選擇此代碼時使用的代碼系統版本；請注意，一個維護良好的代碼系統不需要版本報告，因為代碼的意義在不同系統版本中是一致的；然而，不能始終保證這點，當不能保證意義一致時， **必須（SHALL）** 將版本資訊也一併作交換。",
        "comment" : "如果專門術語沒有明確定義應該使用什麼字串來識別代碼系統的版本，建議使用版本正式發布的日期（用FHIR日期格式表示）作為版本日期。"
      },
      {
        "id" : "Practitioner.identifier:passportNumber.type.coding.code",
        "path" : "Practitioner.identifier.type.coding.code",
        "short" : "系統定義的語法之符號",
        "definition" : "系統定義的語法之符號；符號可能是一個預先定義的代碼，也可能是代碼系統定義的語法中的表達式（如後組合配對／後組合式）。",
        "requirements" : "需要參照系統中的一個特定代碼",
        "min" : 1,
        "patternCode" : "PPN",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:passportNumber.type.coding.display",
        "path" : "Practitioner.identifier.type.coding.display",
        "short" : "由系統定義的表示法",
        "definition" : "遵循系統的規則以呈現代碼含義的表示法",
        "requirements" : "需要能為不了解此系統的讀者呈現可讀的代碼含義",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:passportNumber.type.coding.userSelected",
        "path" : "Practitioner.identifier.type.coding.userSelected",
        "short" : "此編碼是否由使用者直接選擇？",
        "definition" : "表明此編碼是由使用者直接選擇，例如：從可用項目（代碼或顯示名稱）的清單中選擇。",
        "comment" : "在一系列備選方案中，直接選擇的代碼是新翻譯最合適的起點；關於「直接選擇」的確切意義，存在模糊不清之處，可能需要貿易夥伴的同意，以更完整澄清此資料項目的使用及其後果。",
        "requirements" : "已被確定為一個臨床安全準則—此確切的系統／代碼對(code pair)是被明確選擇的，而不是由系統根據一些規則或是程式語言處理判斷。"
      },
      {
        "id" : "Practitioner.identifier:passportNumber.type.text",
        "path" : "Practitioner.identifier.type.text",
        "short" : "概念的文字表示法",
        "definition" : "輸入資料的使用者所見／所選／所說的人類可讀文字表述，和（或）其代表使用者的預期含義。",
        "comment" : "很多時候，此文字表述與其中一個代碼的顯示名稱相同。",
        "requirements" : "專門術語中的代碼並不總是能捕捉人類使用的細微差別的正確意義，或者根本就沒有合適的代碼；這些情況下，文字表述被用來捕捉來源的全部意義。",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:passportNumber.system",
        "path" : "Practitioner.identifier.system",
        "short" : "身份識別碼（identifier）的命名空間（namespace）\n例如：護照號碼='http://www.boca.gov.tw。",
        "definition" : "建立值的命名空間－即一個描述一組值的唯一URL",
        "comment" : "Identifier.system總是區分大小寫",
        "requirements" : "有許多識別碼的集合。為了進行兩個識別碼的對應，我們需要知道我們處理的是哪一組。系統指明了一個特定的唯一識別碼集。",
        "min" : 1,
        "patternUri" : "http://hl7.org/fhir/sid/passport-TWN",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:passportNumber.value",
        "path" : "Practitioner.identifier.value",
        "short" : "唯一值。 例如：護照號碼為888800371",
        "definition" : "識別碼中通常與使用者有關的部分，在系統情境內是唯一的。",
        "comment" : "如果此值是一個完整的URI，那麼此系統 **必須（SHALL）** 是urn:ietf:rfc:3986。此值的主要目的是為了可運算的對應。因此，為了比較的目的，它可能會被正規化（例如：去除不重要的空白、破折號等）。一個為人顯示的格式化的值可以使用[Rendered Value](http://hl7.org/fhir/R4/extension-rendered-value.html)擴充來傳達。除非對Identifier.system的了解使處理者確信不區分大小寫的處理是安全的，否則Identifier.value應被視為區分大小寫。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:passportNumber.period",
        "path" : "Practitioner.identifier.period",
        "short" : "此身份識別碼（identifier）的使用效期",
        "definition" : "識別碼有效／曾經有效使用的時段或期間"
      },
      {
        "id" : "Practitioner.identifier:passportNumber.assigner",
        "path" : "Practitioner.identifier.assigner",
        "short" : "簽發identifier的機構（可以只是文字表述）",
        "definition" : "簽發／管理識別碼的機構",
        "comment" : "Identifier.assigner可以省略.reference資料項目，只包含一個.display資料項目，反映指定機構的名稱或其他文字表述資訊。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Practitioner.identifier:residentNumber",
        "path" : "Practitioner.identifier",
        "sliceName" : "residentNumber",
        "short" : "適用居留證號碼",
        "definition" : "適用於居留證號碼",
        "requirements" : "通常此人員總是被指定一個特定的數值型的唯一識別碼（identifier）",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:residentNumber.use",
        "path" : "Practitioner.identifier.use",
        "short" : "usual ｜ official ｜ temp ｜ secondary ｜ old （如果知道）",
        "definition" : "這個唯一識別碼（identifier）的用途",
        "comment" : "應用程式可以假定一個識別碼是永久的，除非它明確說它是暫時的。",
        "requirements" : "允許從一組識別碼中為特定的使用情境選擇適當的識別碼",
        "patternCode" : "official",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "IdentifierUse"
            }
          ],
          "strength" : "required",
          "description" : "如果知道，請說明此識別碼的目的；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use|4.0.1"
        }
      },
      {
        "id" : "Practitioner.identifier:residentNumber.type",
        "path" : "Practitioner.identifier.type",
        "short" : "身份識別碼（identifier）的型別說明",
        "definition" : "識別碼的代碼型別，用於決定特定目適用的識別碼。",
        "comment" : "這個資料項目只涉及識別碼的一般類別。它 **必須沒有（SHALL NOT）** 被用於與Identifier.system 1..1對應的代碼。一些識別碼可能由於常見的用法而屬於多個類別。在系統是已知的情況下，型別是不必要的，因為型別總是系統定義的一部分。然而，系統經常需要處理系統不為人知的識別碼。型別和系統之間不是1:1的關係，因為許多不同的系統有相同的型別。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "識別碼的型別，用於決定特定目的所適用的識別碼；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/identifier-type-tw"
        }
      },
      {
        "id" : "Practitioner.identifier:residentNumber.type.coding",
        "path" : "Practitioner.identifier.type.coding",
        "short" : "由專門術語系統（terminology system）定義的代碼",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier:residentNumber.type.coding.system",
        "path" : "Practitioner.identifier.type.coding.system",
        "short" : "專門術語系統（terminology system）的識別",
        "definition" : "定義代碼中符號意義的代碼系統識別",
        "comment" : "URI可以是一個OID（urn:oid:...）或一個UUID（urn:uuid:...）；OID和UUID **必須（SHALL）** 參照HL7 OID註冊中心；否則，URI應該來自HL7的FHIR定義的特殊URI列表，或者它應該參照一些明確建立的系统定義。",
        "requirements" : "需要明確說明符號定義的來源",
        "min" : 1,
        "patternUri" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:residentNumber.type.coding.version",
        "path" : "Practitioner.identifier.type.coding.version",
        "short" : "系統的版本—如果相關的話",
        "definition" : "選擇此代碼時使用的代碼系統版本；請注意，一個維護良好的代碼系統不需要版本報告，因為代碼的意義在不同系統版本中是一致的；然而，不能始終保證這點，當不能保證意義一致時， **必須（SHALL）** 將版本資訊也一併作交換。",
        "comment" : "如果專門術語沒有明確定義應該使用什麼字串來識別代碼系統的版本，建議使用版本正式發布的日期（用FHIR日期格式表示）作為版本日期。"
      },
      {
        "id" : "Practitioner.identifier:residentNumber.type.coding.code",
        "path" : "Practitioner.identifier.type.coding.code",
        "short" : "系統定義的語法之符號",
        "definition" : "系統定義的語法之符號；符號可能是一個預先定義的代碼，也可能是代碼系統定義的語法中的表達式（如後組合配對／後組合式）。",
        "requirements" : "需要參照系統中的一個特定代碼",
        "min" : 1,
        "patternCode" : "PRC",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:residentNumber.type.coding.display",
        "path" : "Practitioner.identifier.type.coding.display",
        "short" : "由系統定義的表示法",
        "definition" : "遵循系統的規則以呈現代碼含義的表示法",
        "requirements" : "需要能為不了解此系統的讀者呈現可讀的代碼含義",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:residentNumber.type.coding.userSelected",
        "path" : "Practitioner.identifier.type.coding.userSelected",
        "short" : "此編碼是否由使用者直接選擇？",
        "definition" : "表明此編碼是由使用者直接選擇，例如：從可用項目（代碼或顯示名稱）的清單中選擇。",
        "comment" : "在一系列備選方案中，直接選擇的代碼是新翻譯最合適的起點；關於「直接選擇」的確切意義，存在模糊不清之處，可能需要貿易夥伴的同意，以更完整澄清此資料項目的使用及其後果。",
        "requirements" : "已被確定為一個臨床安全準則—此確切的系統／代碼對(code pair)是被明確選擇的，而不是由系統根據一些規則或是程式語言處理判斷。"
      },
      {
        "id" : "Practitioner.identifier:residentNumber.type.text",
        "path" : "Practitioner.identifier.type.text",
        "short" : "概念的文字表示法",
        "definition" : "輸入資料的使用者所見／所選／所說的人類可讀文字表述，和（或）其代表使用者的預期含義。",
        "comment" : "很多時候，此文字表述與其中一個代碼的顯示名稱相同。",
        "requirements" : "專門術語中的代碼並不總是能捕捉人類使用的細微差別的正確意義，或者根本就沒有合適的代碼；這些情況下，文字表述被用來捕捉來源的全部意義。",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:residentNumber.system",
        "path" : "Practitioner.identifier.system",
        "short" : "身份識別碼（identifier）的命名空間（namespace）\n例如：居留證號='http://www.immigration.gov.tw'。",
        "definition" : "建立值的命名空間－即一個描述一組值的唯一URL",
        "comment" : "Identifier.system總是區分大小寫",
        "requirements" : "有許多識別碼的集合。為了進行兩個識別碼的對應，我們需要知道我們處理的是哪一組。系統指明了一個特定的唯一識別碼集。",
        "min" : 1,
        "patternUri" : "http://www.immigration.gov.tw",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:residentNumber.value",
        "path" : "Practitioner.identifier.value",
        "short" : "唯一值。 例如：居留證號碼為A912345678",
        "definition" : "識別碼中通常與使用者有關的部分，在系統情境內是唯一的。",
        "comment" : "如果此值是一個完整的URI，那麼此系統 **必須（SHALL）** 是urn:ietf:rfc:3986。此值的主要目的是為了可運算的對應。因此，為了比較的目的，它可能會被正規化（例如：去除不重要的空白、破折號等）。一個為人顯示的格式化的值可以使用[Rendered Value](http://hl7.org/fhir/R4/extension-rendered-value.html)擴充來傳達。除非對Identifier.system的了解使處理者確信不區分大小寫的處理是安全的，否則Identifier.value應被視為區分大小寫。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:residentNumber.period",
        "path" : "Practitioner.identifier.period",
        "short" : "此身份識別碼（identifier）的使用效期",
        "definition" : "識別碼有效／曾經有效使用的時段或期間"
      },
      {
        "id" : "Practitioner.identifier:residentNumber.assigner",
        "path" : "Practitioner.identifier.assigner",
        "short" : "簽發identifier的機構（可以只是文字表述）",
        "definition" : "簽發／管理識別碼的機構",
        "comment" : "Identifier.assigner可以省略.reference資料項目，只包含一個.display資料項目，反映指定機構的名稱或其他文字表述資訊。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Practitioner.identifier:medicalLicenseNumber",
        "path" : "Practitioner.identifier",
        "sliceName" : "medicalLicenseNumber",
        "short" : "適用員工編號",
        "definition" : "適用於員工編號",
        "requirements" : "通常此人員總是被指定一個特定的數值型的唯一識別碼（identifier）",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:medicalLicenseNumber.use",
        "path" : "Practitioner.identifier.use",
        "short" : "usual ｜ official ｜ temp ｜ secondary ｜ old （如果知道）",
        "definition" : "這個唯一識別碼（identifier）的用途",
        "comment" : "應用程式可以假定一個識別碼是永久的，除非它明確說它是暫時的。",
        "requirements" : "允許從一組識別碼中為特定的使用情境選擇適當的識別碼",
        "patternCode" : "official",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "IdentifierUse"
            }
          ],
          "strength" : "required",
          "description" : "如果知道，請說明此識別碼的目的；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use|4.0.1"
        }
      },
      {
        "id" : "Practitioner.identifier:medicalLicenseNumber.type",
        "path" : "Practitioner.identifier.type",
        "short" : "身份識別碼（identifier）的型別說明",
        "definition" : "識別碼的代碼型別，用於決定特定目適用的識別碼。",
        "comment" : "這個資料項目只涉及識別碼的一般類別。它 **必須沒有（SHALL NOT）** 被用於與Identifier.system 1..1對應的代碼。一些識別碼可能由於常見的用法而屬於多個類別。在系統是已知的情況下，型別是不必要的，因為型別總是系統定義的一部分。然而，系統經常需要處理系統不為人知的識別碼。型別和系統之間不是1:1的關係，因為許多不同的系統有相同的型別。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "識別碼的型別，用於決定特定目的所適用的識別碼；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/identifier-type-tw"
        }
      },
      {
        "id" : "Practitioner.identifier:medicalLicenseNumber.type.coding",
        "path" : "Practitioner.identifier.type.coding",
        "short" : "由專門術語系統（terminology system）定義的代碼",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier:medicalLicenseNumber.type.coding.system",
        "path" : "Practitioner.identifier.type.coding.system",
        "short" : "專門術語系統（terminology system）的識別",
        "definition" : "定義代碼中符號意義的代碼系統識別",
        "comment" : "URI可以是一個OID（urn:oid:...）或一個UUID（urn:uuid:...）；OID和UUID **必須（SHALL）** 參照HL7 OID註冊中心；否則，URI應該來自HL7的FHIR定義的特殊URI列表，或者它應該參照一些明確建立的系统定義。",
        "requirements" : "需要明確說明符號定義的來源",
        "min" : 1,
        "patternUri" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:medicalLicenseNumber.type.coding.version",
        "path" : "Practitioner.identifier.type.coding.version",
        "short" : "系統的版本—如果相關的話",
        "definition" : "選擇此代碼時使用的代碼系統版本；請注意，一個維護良好的代碼系統不需要版本報告，因為代碼的意義在不同系統版本中是一致的；然而，不能始終保證這點，當不能保證意義一致時， **必須（SHALL）** 將版本資訊也一併作交換。",
        "comment" : "如果專門術語沒有明確定義應該使用什麼字串來識別代碼系統的版本，建議使用版本正式發布的日期（用FHIR日期格式表示）作為版本日期。"
      },
      {
        "id" : "Practitioner.identifier:medicalLicenseNumber.type.coding.code",
        "path" : "Practitioner.identifier.type.coding.code",
        "short" : "系統定義的語法之符號",
        "definition" : "系統定義的語法之符號；符號可能是一個預先定義的代碼，也可能是代碼系統定義的語法中的表達式（如後組合配對／後組合式）。",
        "requirements" : "需要參照系統中的一個特定代碼",
        "min" : 1,
        "patternCode" : "MD",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:medicalLicenseNumber.type.coding.display",
        "path" : "Practitioner.identifier.type.coding.display",
        "short" : "由系統定義的表示法",
        "definition" : "遵循系統的規則以呈現代碼含義的表示法",
        "requirements" : "需要能為不了解此系統的讀者呈現可讀的代碼含義",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:medicalLicenseNumber.type.coding.userSelected",
        "path" : "Practitioner.identifier.type.coding.userSelected",
        "short" : "此編碼是否由使用者直接選擇？",
        "definition" : "表明此編碼是由使用者直接選擇，例如：從可用項目（代碼或顯示名稱）的清單中選擇。",
        "comment" : "在一系列備選方案中，直接選擇的代碼是新翻譯最合適的起點；關於「直接選擇」的確切意義，存在模糊不清之處，可能需要貿易夥伴的同意，以更完整澄清此資料項目的使用及其後果。",
        "requirements" : "已被確定為一個臨床安全準則—此確切的系統／代碼對(code pair)是被明確選擇的，而不是由系統根據一些規則或是程式語言處理判斷。"
      },
      {
        "id" : "Practitioner.identifier:medicalLicenseNumber.type.text",
        "path" : "Practitioner.identifier.type.text",
        "short" : "概念的文字表示法",
        "definition" : "輸入資料的使用者所見／所選／所說的人類可讀文字表述，和（或）其代表使用者的預期含義。",
        "comment" : "很多時候，此文字表述與其中一個代碼的顯示名稱相同。",
        "requirements" : "專門術語中的代碼並不總是能捕捉人類使用的細微差別的正確意義，或者根本就沒有合適的代碼；這些情況下，文字表述被用來捕捉來源的全部意義。",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:medicalLicenseNumber.system",
        "path" : "Practitioner.identifier.system",
        "short" : "身份識別碼（identifier）的命名空間（namespace），可至 [twTerminology](https://fhir.mohw.gov.tw/ts/namingsystem.jsp?status=active&amp;type=0) 申請或查詢命名系統。",
        "definition" : "建立值的命名空間－即一個描述一組值的唯一URL",
        "comment" : "Identifier.system總是區分大小寫",
        "requirements" : "有許多識別碼的集合。為了進行兩個識別碼的對應，我們需要知道我們處理的是哪一組。系統指明了一個特定的唯一識別碼集。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:medicalLicenseNumber.value",
        "path" : "Practitioner.identifier.value",
        "short" : "唯一值。 例如：員工編號為KP00017",
        "definition" : "識別碼中通常與使用者有關的部分，在系統情境內是唯一的。",
        "comment" : "如果此值是一個完整的URI，那麼此系統 **必須（SHALL）** 是urn:ietf:rfc:3986。此值的主要目的是為了可運算的對應。因此，為了比較的目的，它可能會被正規化（例如：去除不重要的空白、破折號等）。一個為人顯示的格式化的值可以使用[Rendered Value](http://hl7.org/fhir/R4/extension-rendered-value.html)擴充來傳達。除非對Identifier.system的了解使處理者確信不區分大小寫的處理是安全的，否則Identifier.value應被視為區分大小寫。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:medicalLicenseNumber.period",
        "path" : "Practitioner.identifier.period",
        "short" : "此身份識別碼（identifier）的使用效期",
        "definition" : "識別碼有效／曾經有效使用的時段或期間"
      },
      {
        "id" : "Practitioner.identifier:medicalLicenseNumber.assigner",
        "path" : "Practitioner.identifier.assigner",
        "short" : "簽發identifier的機構（可以只是文字表述）",
        "definition" : "簽發／管理識別碼的機構",
        "comment" : "Identifier.assigner可以省略.reference資料項目，只包含一個.display資料項目，反映指定機構的名稱或其他文字表述資訊。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Practitioner.active",
        "path" : "Practitioner.active",
        "short" : "此照護服務提供人員的紀錄是否在使用中",
        "definition" : "此照護服務提供人員的紀錄是否在使用中",
        "comment" : "如果機構未使用此照護服務提供人員紀錄，那麼應該在PractitonerRole上標註結束日期（即使他們是使用中的），因為他們可能以另一種角色存在。",
        "requirements" : "由於照護服務提供人員的紀錄被錯誤建立，需能將其紀錄標註為非使用中。",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name",
        "path" : "Practitioner.name",
        "short" : "照護服務提供人員的姓名",
        "definition" : "照護服務提供人員的姓名",
        "comment" : "使用屬性的選擇應確保有一個指定的常用名稱，其他名稱應根據需要使用暱稱（別名）、舊名或其他值。\n \n一般來說，根據以下條件決定要在ResourceReference.display中使用的值：\n \n1. 有一個以上的名字\n2. Use=usual\n3. Period（使用期間）是目前日期至使用截止日期\n4. Use=official\n5. 其他順序則由內部業務規則決定",
        "requirements" : "Practitioner所使用的名稱。如果有多個名字，則應使用此健康照護服務提供者常用的名字來顯示。",
        "constraint" : [
          {
            "key" : "tw-core-1",
            "severity" : "error",
            "human" : "Patient.name.text or Patient.name.family or both SHALL be present",
            "expression" : "text.exists() or family.exists()",
            "xpath" : "f:text or f:given",
            "source" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name.use",
        "path" : "Practitioner.name.use",
        "definition" : "此姓名的用途",
        "comment" : "應用程式可以假定一個姓名是永久的，除非它明確說它是暫時或舊的。",
        "requirements" : "允許從一組姓名中為特定的使用情境選擇適當的姓名",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "NameUse"
            }
          ],
          "strength" : "required",
          "description" : "人名的使用情況；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/name-use|4.0.1"
        }
      },
      {
        "id" : "Practitioner.name.text",
        "path" : "Practitioner.name.text",
        "short" : "完整的中文姓名",
        "definition" : "完整姓名的文字表述。由於世界各地的文化差異，取得資料的系統可能不知道如何正確地呈現姓名；此外，不是所有的名字部分都呈現予姓或名。因此，我們強烈建議創建者透過這個資料項目提供姓名的顯示文字。",
        "comment" : "可以同時提供文字表述（text）和部分（part）。更新姓名的應用程式 **必須（SHALL）** 確保當test和lpart都存在時，text中不包含part中沒有的內容。",
        "requirements" : "一個可呈現的、未編碼的形式。",
        "example" : [
          {
            "label" : "General",
            "valueString" : "王依昇"
          }
        ],
        "condition" : ["tw-core-1"],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name.family",
        "path" : "Practitioner.name.family",
        "short" : "英文姓",
        "definition" : "姓名中與族譜相關的部分。在一些文化中（如厄立特里亞），兒子的姓氏是其父親的名字。",
        "comment" : "姓氏可以使用擴充名（de、nl、es相關文化）分解成具體的部分（part）",
        "example" : [
          {
            "label" : "General",
            "valueString" : "Wang"
          }
        ],
        "condition" : ["tw-core-1"],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name.given",
        "path" : "Practitioner.name.given",
        "short" : "英文名",
        "definition" : "姓名中的「名」",
        "comment" : "如果只記錄首字母，可以用它們來代替完整姓名。首字母可以分為多個名，但由於實際情況的限制，通常不會這樣做。這個資料項目不被稱為 「first name」，因為「given name」並不總是排在前面。",
        "example" : [
          {
            "label" : "General",
            "valueString" : "Yi Sheng"
          }
        ],
        "condition" : ["tw-core-1"],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name.prefix",
        "path" : "Practitioner.name.prefix",
        "short" : "姓名前面的頭銜\n由於學術，法律，職業或貴族身份等原因而獲得頭銜，出現在姓名開頭。",
        "definition" : "由於學術、法規、就業或貴族身份等原因而獲得的名，並出現在姓名的開頭。"
      },
      {
        "id" : "Practitioner.name.suffix",
        "path" : "Practitioner.name.suffix",
        "short" : "姓名後面的稱謂\n由於學術，法律，職業或貴族身份等原因而獲得頭銜，出現在姓名之後。",
        "definition" : "由於學術、法規、就業或貴族身份等原因而獲得的名，並出現在姓名的開頭。"
      },
      {
        "id" : "Practitioner.name.period",
        "path" : "Practitioner.name.period",
        "short" : "此姓名的使用效期",
        "definition" : "表明這個姓名對此病人有效的時間區間或期間",
        "requirements" : "允許多個姓名按其歷史情境（效期）儲存"
      },
      {
        "id" : "Practitioner.telecom",
        "path" : "Practitioner.telecom",
        "short" : "照護服務提供人員的詳細聯絡方式（適用於所有角色）。",
        "definition" : "照護服務提供人員的詳細聯絡方式，例如：電話號碼或電子郵件信箱。",
        "comment" : "個人可能有多種聯繫方式，有不同的用途或適用期。可能需要有與該人緊急聯繫的選項，並幫助識別。這些通常會有家用電話號碼，或沒有特定角色的手機號碼。",
        "requirements" : "不論照護服務提供人員的角色是什麼，需要知道如何與照護服務提供人員取得聯繫。",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.telecom.system",
        "path" : "Practitioner.telecom.system",
        "definition" : "聯絡方式的通訊形式－需要什麼通訊系統進行聯絡",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ContactPointSystem"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/contact-point-system|4.0.1"
        }
      },
      {
        "id" : "Practitioner.telecom.value",
        "path" : "Practitioner.telecom.value",
        "short" : "實際的聯絡方式之細節",
        "definition" : "實際的聯絡方式之細節，針對指定的通訊系統提供有意義的形式（電話號碼或是電子郵件位址）。",
        "comment" : "額外的文字資料，例如電話分機號碼、或關於聯絡人的說明，有時也包括於此值。",
        "requirements" : "需支援非嚴格格式控制之舊有號碼",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.telecom.use",
        "path" : "Practitioner.telecom.use",
        "short" : "home | work | temp | old | mobile－此聯絡方式的用途",
        "definition" : "確定聯絡方式的用途",
        "comment" : "應用程式可以假定一個聯絡方法是目前使用中，除非它明確說它是暫時的或舊的。",
        "requirements" : "需要追蹤此人使用這種聯絡的方式，使用者可以選擇適合他們用途的聯絡方式。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ContactPointUse"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/contact-point-use|4.0.1"
        }
      },
      {
        "id" : "Practitioner.telecom.rank",
        "path" : "Practitioner.telecom.rank",
        "short" : "具體說明偏好的使用順序（1=最高優先順序）",
        "definition" : "具體說明使用一組聯絡方式的優先順序，較小排名序位的聯絡方式比較大排名序位的聯絡方式之序位還要前面。",
        "comment" : "請注意，排名序位沒有一定要遵循聯絡方式在實例中呈現的順序。"
      },
      {
        "id" : "Practitioner.telecom.period",
        "path" : "Practitioner.telecom.period",
        "short" : "此聯絡方式的使用效期",
        "definition" : "此聯絡方式的使用效期",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.address",
        "path" : "Practitioner.address",
        "short" : "不限特定角色的照護服務提供人員的地址（通常是住家地址）",
        "definition" : "不限特定角色的健康照護服務提供者的地址（通常是住家地址），工作地址通常不在此屬性中輸入，因為它們通常取決於此人員的角色。",
        "comment" : "PractitionerRole上沒有address但有location屬性（它有一個地址）用於這個目的。",
        "requirements" : "Administrative Gender為行政管理的及保存紀錄目的之健康照護服務提供者性別",
        "type" : [
          {
            "code" : "Address",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Address-tw"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.gender",
        "path" : "Practitioner.gender",
        "short" : "male ｜ female ｜ other ｜ unknown",
        "definition" : "Administrative Gender為行政管理的及保存紀錄目的之健康照護服務提供者性別",
        "requirements" : "用以正確稱呼健康照護服務提供者",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "AdministrativeGender"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "required",
          "description" : "性別；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/administrative-gender|4.0.1"
        }
      },
      {
        "id" : "Practitioner.birthDate",
        "path" : "Practitioner.birthDate",
        "short" : "照護服務提供人員的出生日期",
        "definition" : "照護服務提供人員的出生日期",
        "requirements" : "為了識別身份而需要",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.photo",
        "path" : "Practitioner.photo",
        "short" : "人員的影像（照片）",
        "definition" : "人員的影像（照片）",
        "requirements" : "許多EHR系統有能力取得健康照護服務提供者的影像（照片），這也符合較新的社群媒體的使用。",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.qualification",
        "path" : "Practitioner.qualification",
        "short" : "與照護服務相關的證書、執照或培訓",
        "definition" : "授權或其他與照護服務提供人員提供照護有關的官方證書、執照和培訓。例如：由衛生福利部頒發的醫師證書。"
      },
      {
        "id" : "Practitioner.qualification.identifier",
        "path" : "Practitioner.qualification.identifier",
        "short" : "照護服務提供人員的資格證書識別碼",
        "definition" : "此人在此角色的資格證書之識別碼",
        "requirements" : "通常此資格證書會被指定特定識別碼"
      },
      {
        "id" : "Practitioner.qualification.code",
        "path" : "Practitioner.qualification.code",
        "short" : "資格證書的編碼表示法",
        "definition" : "資格證書的編碼表示法",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "照護服務提供人員提供服務所具有的具體資格證書；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/health-professional-sct-tw"
        }
      },
      {
        "id" : "Practitioner.qualification.period",
        "path" : "Practitioner.qualification.period",
        "short" : "資格證書的有效期限",
        "definition" : "資格證書的有效期限",
        "requirements" : "資格證書通常是有期限的，並且可以被撤銷。"
      },
      {
        "id" : "Practitioner.qualification.issuer",
        "path" : "Practitioner.qualification.issuer",
        "short" : "監管和頒發資格證書的機構",
        "definition" : "監管和頒發資格證書的機構",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Practitioner.communication",
        "path" : "Practitioner.communication",
        "short" : "健康照護服務提供者與病人溝通時可使用的語言",
        "definition" : "健康照護服務提供者與病人溝通時可使用的語言",
        "comment" : "帶有這種精確字母大小寫的aa-BB結構是最廣泛使用的地方性符號之一。但並不是所有的系統都對其進行編碼，而是將其作為純文字表述。因此，data type為CodeableConcept而不是code。",
        "requirements" : "知道照護服務提供人員講哪種語言有助於促進與病人的溝通",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      }
    ]
  }
}

```
