# TW Core Patient - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Patient 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCorePatient |

 
此臺灣核心-病人（TW Core Patient） Profile說明本IG如何進一步定義FHIR的Patient Resource以呈現基本資料。 

## Resource Patient - 內容

關於接受照顧或其他健康相關服務的個人或動物的人口統計學和其他行政資訊。

### 範圍與使用

此 resource 覆蓋了參與廣泛健康相關活動的病人和動物的資料，包括：

* 治療活動
* 精神病照護
* 社會服務
* 孕期照護
* 護理和輔助生活
* 飲食服務
* 個人健康和運動資料追蹤

這個 Rresource 涵蓋了關於病人的「誰」訊息：其屬性專注於支援行政、財務和物流程序所必需的人口統計學資料。一般而言，每個提供病人照護的機構都會創建和維護病人紀錄。因此，在多個機構接受照護的病人或動物可能會在多個 Patient resources 中擁有其資料。

並非所有概念都包含在基本 resource 中（如種族race、民族ethnicity、器官捐贈者狀態等），但可能在為特定行政管轄區定義的[profiles](https://hl7.org/fhir/R4/patient-profiles.html)或[standard extensions](https://hl7.org/fhir/R4/patient-extensions.html)中找到。這些欄位在不同的行政管轄區之間差異很大，並且經常對類似概念有不同的名稱和值集，這樣的不一致性使得這些欄位難以直接對應或交換，因為它們之間的相似度不足以進行這樣的操作。

這個 resource 被以下 resources 所參照： 註釋（[Annotation](https://hl7.org/fhir/R4/datatypes.html#Annotation)）、簽章（[Signature](https://hl7.org/fhir/R4/datatypes.html#Signature)）、 帳號（[Account](https://hl7.org/fhir/R4/account.html#Account)）、醫療不良事件（[AdverseEvent](https://hl7.org/fhir/R4/adverseevent.html#AdverseEvent)）、過敏或不耐症（[AllergyIntolerance](StructureDefinition-AllergyIntolerance-twcore.md)）、預約（[Appointment](https://hl7.org/fhir/R4/appointment.html#Appointment)）、預約回應（[AppointmentResponse](https://hl7.org/fhir/R4/appointmentresponse.html#AppointmentResponse)）、稽核事件（[AuditEvent](https://hl7.org/fhir/R4/auditevent.html#AuditEvent)）、基本（[Basic](https://hl7.org/fhir/R4/basic.html#Basic)）、生物衍生產品（[BiologicallyDerivedProduct](https://hl7.org/fhir/R4/biologicallyderivedproduct.html#BiologicallyDerivedProduct)）、身體結構（[BodyStructure](https://hl7.org/fhir/R4/bodystructure.html#BodyStructure)）、照護計畫（[CarePlan](https://hl7.org/fhir/R4/careplan.html#CarePlan)）、照護團隊（[CareTeam](https://hl7.org/fhir/R4/careteam.html#CareTeam)）、費用項目（[ChargeItem](https://hl7.org/fhir/R4/chargeitem.html#ChargeItem)）、理賠申請（[Claim](https://hl7.org/fhir/R4/claim.html#Claim)）、理賠申請回應（[ClaimResponse](https://hl7.org/fhir/R4/claimresponse.html#ClaimResponse)）、臨床臆斷（[ClinicalImpression](https://hl7.org/fhir/R4/clinicalimpression.html#ClinicalImpression)）、通訊（[Communication](https://hl7.org/fhir/R4/communication.html#Communication)）、通訊請求（[CommunicationRequest](https://hl7.org/fhir/R4/communicationrequest.html#CommunicationRequest)）、臨床文件架構（[Composition](StructureDefinition-Composition-twcore.md)）、病情、問題或診斷（[Condition](StructureDefinition-Condition-twcore.md)）、同意書（[Consent](https://hl7.org/fhir/R4/consent.html#Consent)）、合約（[Contract](https://hl7.org/fhir/R4/contract.html#Contract)）、給付範圍（[Coverage](https://hl7.org/fhir/R4/coverage.html#Coverage)）、給付資格請求（[CoverageEligibilityRequest](https://hl7.org/fhir/R4/coverageeligibilityrequest.html#CoverageEligibilityRequest)）、給付資格回應（[CoverageEligibilityResponse](https://hl7.org/fhir/R4/coverageeligibilityresponse.html#CoverageEligibilityResponse)）、檢測到的問題（[DetectedIssue](https://hl7.org/fhir/R4/detectedissue.html#DetectedIssue)）、設備（[Device](https://hl7.org/fhir/R4/device.html#Device)）、設備請求（[DeviceRequest](https://hl7.org/fhir/R4/devicerequest.html#DeviceRequest)）、設備使用聲明（[DeviceUseStatement](https://hl7.org/fhir/R4/deviceusestatement.html#DeviceUseStatement)）、診斷報告（[DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md)）、文件清單（[DocumentManifest](https://hl7.org/fhir/R4/documentmanifest.html#DocumentManifest)）、文件參照（[DocumentReference](StructureDefinition-DocumentReference-twcore.md)）、就醫事件（[Encounter](StructureDefinition-Encounter-twcore.md)）、加入或退出保險計畫請求（[EnrollmentRequest](https://hl7.org/fhir/R4/enrollmentrequest.html#EnrollmentRequest)）、照護事件（[EpisodeOfCare](https://hl7.org/fhir/R4/episodeofcare.html#EpisodeOfCare)）、利益說明（[ExplanationOfBenefit](https://hl7.org/fhir/R4/explanationofbenefit.html#ExplanationOfBenefit)）、家族成員病史（[FamilyMemberHistory](https://hl7.org/fhir/R4/familymemberhistory.html#FamilyMemberHistory)）、標記（[Flag](https://hl7.org/fhir/R4/flag.html#Flag)）、目標（[Goal](https://hl7.org/fhir/R4/goal.html#Goal)）、群體（[Group](https://hl7.org/fhir/R4/group.html#Group)）、指導回應（[GuidanceResponse](https://hl7.org/fhir/R4/guidanceresponse.html#GuidanceResponse)）、影像檢查（[ImagingStudy](StructureDefinition-ImagingStudy-twcore.md)）、疫苗接種（[Immunization](https://hl7.org/fhir/R4/immunization.html#Immunization)）、疫苗接種評估（[ImmunizationEvaluation](https://hl7.org/fhir/R4/immunizationevaluation.html#ImmunizationEvaluation)）、疫苗接種建議（[ImmunizationRecommendation](https://hl7.org/fhir/R4/immunizationrecommendation.html#ImmunizationRecommendation)）、發票或費用清單（[Invoice](https://hl7.org/fhir/R4/invoice.html#Invoice)）、清單（[List](https://hl7.org/fhir/R4/list.html#List)）、測量報告（[MeasureReport](https://hl7.org/fhir/R4/measurereport.html#MeasureReport)）、多媒體（[Media](StructureDefinition-Media-twcore.md)）、給藥（[MedicationAdministration](https://hl7.org/fhir/R4/medicationadministration.html#MedicationAdministration)）、配藥或藥品調劑（[MedicationDispense](StructureDefinition-MedicationDispense-twcore.md)）、藥品請求（[MedicationRequest](StructureDefinition-MedicationRequest-twcore.md)）、用藥聲明（[MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)）、分子序列（[MolecularSequence](https://hl7.org/fhir/R4/molecularsequence.html#MolecularSequence)）、營養醫令（[NutritionOrder](https://hl7.org/fhir/R4/nutritionorder.html#NutritionOrder)）、檢驗檢查（[Observation](StructureDefinition-Observation-laboratoryResult-twcore.md)）、病人（Patient）、人（[Person](https://hl7.org/fhir/R4/person.html#Person)）、處置（[Procedure](StructureDefinition-Procedure-twcore.md)）、出處（[Provenance](https://hl7.org/fhir/R4/provenance.html#Provenance)）、問卷題目回覆（[QuestionnaireResponse](https://hl7.org/fhir/R4/questionnaireresponse.html#QuestionnaireResponse)）、相關人士（[RelatedPerson](https://hl7.org/fhir/R4/relatedperson.html#RelatedPerson)）、一組請求（[RequestGroup](https://hl7.org/fhir/R4/requestgroup.html#RequestGroup)）、研究對象（[ResearchSubject](https://hl7.org/fhir/R4/researchsubject.html#ResearchSubject)）、風險評估（[RiskAssessment](https://hl7.org/fhir/R4/riskassessment.html#RiskAssessment)）、 時間表（[Schedule](https://hl7.org/fhir/R4/schedule.html#Schedule)）、服務請求（[ServiceRequest](https://hl7.org/fhir/R4/servicerequest.html#ServiceRequest)）、檢體（[Specimen](StructureDefinition-Specimen-twcore.md)）、供應品遞交（[SupplyDelivery](https://hl7.org/fhir/R4/supplydelivery.html#SupplyDelivery)）、供應品請求（[SupplyRequest](https://hl7.org/fhir/R4/supplyrequest.html#SupplyRequest)）、任務（[Task](https://hl7.org/fhir/R4/task.html#Task)）及視力處方（[VisionPrescription](https://hl7.org/fhir/R4/visionprescription.html#VisionPrescription)）。

**Usages:**

* Refer to this Profile: [TW Core AllergyIntolerance](StructureDefinition-AllergyIntolerance-twcore.md), [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md), [TW Core CareTeam](StructureDefinition-CareTeam-twcore.md), [TW Core Composition](StructureDefinition-Composition-twcore.md)...Show 42 more,[TW Core Condition](StructureDefinition-Condition-twcore.md),[TW Core Coverage](StructureDefinition-Coverage-twcore.md),[TW Core Implantable Device](StructureDefinition-Device-twcore.md),[TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md),[TW Core DocumentReference](StructureDefinition-DocumentReference-twcore.md),[TW Core Encounter](StructureDefinition-Encounter-twcore.md),[TW Core Goal](StructureDefinition-Goal-twcore.md),[TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md),[TW Core Immunization](StructureDefinition-Immunization-twcore.md),[TW Core Media](StructureDefinition-Media-twcore.md),[TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md),[TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md),[TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md),[TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md),[TW Core Observation Blood Pressure](StructureDefinition-Observation-bloodPressure-twcore.md),[TW Core Observation BMI](StructureDefinition-Observation-bmi-twcore.md),[TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md),[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Care Experience Preference](StructureDefinition-Observation-careExperiencePreference-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Laboratory Result](StructureDefinition-Observation-laboratoryResult-twcore.md),[TW Core Observation Occupation](StructureDefinition-Observation-occupation-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Pregnancy Status](StructureDefinition-Observation-pregnancy-status-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Screening Assessment](StructureDefinition-Observation-screening-assessment-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md),[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md),[TW Core Patient](StructureDefinition-Patient-twcore.md),[TW Core Procedure](StructureDefinition-Procedure-twcore.md),[TW Core Provenance](StructureDefinition-Provenance-twcore.md),[TW Core QuestionnaireResponse](StructureDefinition-QuestionnaireResponse-twcore.md),[TW Core RelatedPerson](StructureDefinition-RelatedPerson-twcore.md),[TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)and[TW Core Specimen](StructureDefinition-Specimen-twcore.md)
* Examples for this Profile: [Patient/pat-child-example](Patient-pat-child-example.md), [Patient/pat-example](Patient-pat-example.md) and [Patient/pat-residentNumber-example](Patient-pat-residentNumber-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Patient-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Patient-twcore.csv), [Excel](StructureDefinition-Patient-twcore.xlsx), [Schematron](StructureDefinition-Patient-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Patient-id.md)**查詢所有Patient：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Patient?_id=[id]`
`GET [base]/Patient/[id]`例子：
(1) GET [base]/Patient?_id=pat-example
(2) GET [base]/Patient/pat-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`birthdate`](SearchParameter-Patient-birthdate.md)**查詢所有Patient：
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Patient?birthdate={gt|lt|ge|le}[date]`例子：
(1) GET [base]/Patient?birthdate=1990-01-01
1. **建議應該（SHOULD）**支援透過查詢參數**[`gender`](SearchParameter-Patient-gender.md)**查詢所有Patient：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Patient?gender=[code]`例子：
(1) GET [base]/Patient?gender=female
1. **建議應該（SHOULD）**支援透過查詢參數**[`identifier`](SearchParameter-Patient-identifier.md)**查詢所有Patient：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Patient?identifier={system|}[code]`例子：
(1) GET [base]/Patient?identifier=http://www.moi.gov.tw|A123456789
1. **建議應該（SHOULD）**支援透過查詢參數**[`name`](SearchParameter-Patient-name.md)**查詢所有Patient，該查詢可能與 HumanName 中的任何字串匹配，包括完整的中文姓名(text)、英文姓(family)、英文名(given)、姓名前面的頭銜(prefix)、姓名後面的稱謂(suffix)：
([如何透過string查詢](http://hl7.org/fhir/R4/search.html#string))
`GET [base]/Patient?name=[name]`例子：
(1) GET [base]/Patient?name=陳加玲

#### Constraints 限制

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| **pat-1** | [Rule](https://hl7.org/fhir/R4/conformance-rules.html#rule) | Patient.contact | 必須（SHALL）至少包含聯絡的細節或參照至一個機構 | name.exists() or telecom.exists() or address.exists() or organization.exists() |

注意事項：

* `multipleBirth`資料項目可以是布林值來指示病人是否為多胞胎，或者是整數來顯示病人在多胞胎中的出生順序。
* 病人紀錄只有兩種狀態：使用中（`active`=`true`）和停用（`active` =`false`）。正常使用的紀錄標記為`active` =`true`。如果紀錄因重複、錯誤或不再需要而被創建，則可設為停用（`active` =`false`），這樣的紀錄無需與其他紀錄建立關聯即可獨立標記為停用。
* `link` 資料項目用來證明兩個或更多的Patient resources是關於同一位實際病人的。更多細節將在後文討論。
* 每位病人的溝通方式中只能選擇一種作為偏好語言（`communication.preferred`=`true`）。
* 病人的聯繫資訊中可以包含一個`contact.organization`資料項目，主要用於監護人或業務相關聯繫。這個屬性提供的是專門聯繫相關機構的資訊，與常規針對個人的聯繫方式不同。

### 病人識別碼 (identifier) 與Patient resource的識別碼 (id)

病人記錄的[Resource Id](https://hl7.org/fhir/R4/resource.html#id)永遠不變。因此，病歷號(MRN)或單位記錄(UR)這類變動的識別碼不應用作Resource Id，因它們可能隨機構而異。MRN或UR應記錄在`Patient.identifier`清單中，方便管理。這對於隨時間合併病人資料系統的機構特別有用，有助於識別重複紀錄和易於追蹤、更新病人資訊。

當需要自動化生成病人紀錄的MRN時，可以在Patient Resource 中預留一個未賦值的MRN type的identifier。隨後，系統根據內部規則自動分配一個或多個新的identifier。

**案例**：李小姐在A醫院有一個MRN是「A123」。後來，由於個人因素，她希望轉院至B醫院並將她在A醫院的病歷也轉到B醫院。在B醫院，李小姐的新病歷需要創建，需要一個新的MRN時，她在A醫院的MRN 「A123」不會直接用作她在B醫院的identifier，B醫院系統根據內部規則自動產生一個新的MRN，比如「B456」，填入至空白identifier。

此外，為保持在A醫院的病歷連接，B醫院在李小姐的病人資料中可能也會保存標明來自A醫院的MRN之identifier，以保持病歷的完整性和連續性。

### 連結病人

`link` 資料項目用於聲明Patient resources 的資訊指的是同一位病人，它用於支援以下情境，即存在多筆病人紀錄的情況：

#### 重複的病人紀錄

管理病人註冊是一個常見的挑戰，約有2%的註冊過程中會出現錯誤，大多數情況下是因為重複的紀錄。有時候，這些重複的紀錄會在累積過多資料之前被快速發現並撤銷。但在其他情況下，可能已經積累了大量資料。為了處理這一問題，我們可以使用`link.type`為 `replaced-by` 的`link`，這樣的連結會將包含它的紀錄標記為重複的，並指向一個應該被用作替代的紀錄。需要注意的是，指向的紀錄本身也可能是因錯誤而被創建的，並可能進一步指向另一個Patient resource。在這種情況下，替換了另一紀錄的紀錄將使用`link.type`為 `replaces` 的`link`指回被替換的舊紀錄，從而建立一個清晰的連結鏈。

**案例**：林先生在醫院系統中有兩個紀錄，一個紀錄的MRN是X666，另一個是X000。後來發現，這兩個紀錄實際上是同一位病人的重複紀錄。為了解決這個問題，醫院選擇保留MRN為X666的紀錄，並將MRN為X000的紀錄標記為`replaced-by`，指向MRN為X666的紀錄。這樣，MRN為123的紀錄就成了主要使用的紀錄，而MRN為X000的紀錄則被清楚地標記為重複且不再使用。

#### Patient 索引中心的病人紀錄

當病人紀錄被納入作為病人索引的系統時，該系統不僅保留了病人資訊摘要，還列出了一個或多個擁有該病人更完整或官方紀錄的伺服器清單。在這種情況下，我們使用`link.type`為 `refer` 的`link`來標明這種關聯。重要的是，連接的紀錄可能包含矛盾的資訊，而被參考的紀錄並不指回參考它的紀錄，保持了資訊的獨立性。

案例：李小姐在台北市和宜蘭縣的兩家醫院都有病人紀錄，假設衛生福利部(國家級)有一套健康資訊系統作為病人索引使用，收集了指向這兩家醫院紀錄的連結，當李小姐到桃園市的醫院就診時，桃園市醫院的醫生可以通過這個索引找到她在台北市和宜蘭縣的完整醫療資訊。這個過程是透過設置`link.type`為 `refer` 的link實現的，使得李小姐的健康資訊可以跨醫院共享，但各自紀錄的來源保持獨立。

#### 分散式病人紀錄

在分散式架構中，多個系統分別儲存著同一病人的獨立病人紀錄。這些紀錄並不被看作是重複的，而是呈現了病人資料的分散式且可能重疊的視角。每份這樣的紀錄可能關於不同的事件或健康問題或者由不同的機構維護，而且並不需要一份紀錄比另一份更完整或具權威性。在這種情況下，可以使用`link.type`為`refer` 指向其他病人紀錄，而且並不要求這樣的連結是雙向的。

#### Patient.link.type 完整代碼定義

| | | |
| :--- | :--- | :--- |
| replaced-by | 由…所取代 | 內含此link的Patient resource不得再使用，此連結若指向另一個Patient resource，則必須使用該Patient resource來取代內含此連結Patient resource。 |
| replaces | 取代 | 包含此連結的Patient resource是當前使用中的病人紀錄。此連結指向已併入該 resource 的不使用 Patient resource，應查閱該 resource 以獲取更多參考資訊。 |
| refer | 參照 | 包含此連結的 Patient resource 正在使用且有效，但不被視為Patient resource的主要來源。此連結指向另一個Patient resource，查詢其他病人資訊時應查閱該Patient resource。 |
| seealso | 參見 | 包含此連結的Patient resource正在使用且有效，但指向另一個已知包含相同人資料的Patient resource。此 resource 中的資料可能與另一Patient resource中的資訊重疊或矛盾。此連結並不表示相關 Rresource 的相對重要性，兩者應被視為同等有效。 |

### Patient vs. Person vs. Patient.link vs. Linkage

Person resource 看起來與 Patient resource 非常相似，而且它的使用方式與使用 `Patient.link` 功能非常類似。Person resource 的目的是能夠將相信是同一個人的 resources 實例連結在一起，這包括其他 resource 類型，如 RelatedPerson、Practitioner、Patient、甚至其他 Person resources；**但是`Patient.link`僅用於 Patient resources。**

Person resource 的主要用途是能夠支援不必然具有健康照護情境的個人註冊，並能夠識別和量化這是同一人的信心等級，這可能包括一個允許個人存取和管理與自身資訊的網站，比如可管理個人健康記錄、預約和其他個人服務的網站，其中人員資訊的維護者是實際的本人。系統可以使用 Person 紀錄來交叉檢查紀錄的一部分資訊或另一套系統的值的變更；例如：當搬家時，消費者在他的 Person resource 更新他的聯絡電話和地址，然後病人管理系統能夠看到這些資料已更改，並提示機構跟進與 Person resource 連結的Patient resources，以確認病人是否希望更新個人資訊，或者是否病人不再需要原有的照護或健康相關醫療服務，因為他們已從該地區搬走。

[Linkage](https://hl7.org/fhir/R4/linkage.html) resource 和 `Patient.link` 資料項目在概念上執行 FHIR 中類似的功能，兩者都提供了指向同一個人的多個 resources 實例之間連結的主張。當 Patient resource 被連結/合併時，則需要有一個內部指示，可透過使用 `Patient.link` 資料項目表明參照其他紀錄時應該考慮另一個 Patient resource。另一種作法是使用Linkage resource 來合併或連結記錄。 但在應用或查詢病人完整紀錄時，要特別留意這兩種設計的差異。前者只要查找Patient即可找到相關Patient resources的連結，但後者可能需要額外的查詢步驟來找出所有相關的Patient resources，以確保沒有遺漏任何病人關聯資訊(例如以下Linage resource案例中的查詢語法二)。

**但Linkage resource中若有應記錄卻因未發現或作業疏失而未記錄的連結，這可能意味著相關臨床紀錄未被發現及未被呈現，這可能會影響病人安全，這也是相對於 Patient.link，Linkage resource 較不適合存放病人關聯資訊的理由。另一個相對建議使用Patient.link來為病人資訊建立關聯的理由是Patient resource已是一規範(Normative，未來不會再異動)，而Linkage resource的成熟度在FHIR第4版及第5版都為0，表示此resource的設計於未來仍可能有異動。**

**Patient.link 案例**：(假設所有機構病歷都在同一台FHIR Server) 林先生在A醫院有一個病人紀錄（Patient ID: 001），在B醫院也有一個病人紀錄（Patient ID: 002）。使用 Patient.link，我們可以在A醫院的紀錄中添加一個連接指向B醫院的紀錄，反之亦然，從而表明這兩個紀錄實際上是同一個人的不同紀錄。

```
{
  "resourceType": "Patient",
  "id": "001",
  "link": [
    {
      "other": {
        "reference": "Patient/002"
      },
      "type": "refer"
    }
  ]
}

```

**若要取得病人 001 資料，查詢語法如下，將會回傳上面的這份Patient resource。實作者可從中得知與其相關的病人 002 之連結。**

```
GET /Patient/001

```

**Linkage resource 案例**：如果林先生的病人紀錄（在A醫院和B醫院）需要與他的治療計劃紀錄或診斷報告紀錄關聯起來，可以使用 Linkage resource 來建立這些關聯。

```
{
  "resourceType": "Linkage",
  "item": [
    {
      "type": "source",
      "resource": {
        "reference": "Patient/001"
      }
    },
    {
      "type": "alternate",
      "resource": {
        "reference": "Patient/002"
      }
    },
    {
      "type": "alternate",
      "resource": {
        "reference": "CarePlan/123"
      }
    }
  ]
}

```

**若要取得病人 001 及其相關資料之連結，查詢語法一如下，將會回傳上面的這份Linkage resource。實作者可從中得知與其相關的病人資訊 002 之連結 及照護計畫 123 之連結。**

```
GET /Linkage?item=Patient/001

```

```
{
  "resourceType": "Bundle",
  "type": "searchset",
  "entry": [
    {
      "resource": {
        "resourceType": "Linkage",
        "id": "linkage1",
        "item": [
          {
            "type": "source",
            "resource": {
              "reference": "Patient/001"
            }
          },
          {
            "type": "alternate",
            "resource": {
              "reference": "Patient/002"
            }
          }
        ]
      }
    }
  ]
}

```

**查詢語法二：僅限在FHIR Server有提供_revinclude查詢參數功能時才有辦法進行以下查詢。這個查詢將返回病人 001 的資料，以及所有透過 Linkage resources 與之相關聯的其他resources 的連結。有別於查詢語法一，查詢語法二便於在單一操作中獲取到病人紀錄及其所有相關 resources 的連結。**

```
GET /Patient/001?_revinclude=Linkage:item

```

```
{
  "resourceType": "Bundle",
  "type": "searchset",
  "entry": [
    {
      "resource": {
        "resourceType": "Patient",
        "id": "001",        
        "name": [
          {
            "text": "林某某"            
          }
        ],
        "gender": "female"
      }
    },
    {
      "resource": {
        "resourceType": "Linkage",
        "id": "linkage1",
        "item": [
          {
            "type": "source",
            "resource": {
              "reference": "Patient/001"
            }
          },
          {
            "type": "alternate",
            "resource": {
              "reference": "Patient/002"
            }
          }
        ]
      }
    }
  ]
}

```

### Patient.contact vs. RelatedPerson

在 Patient resource 中，contact 資料項目被專門設計來儲存聯絡人的細節。因此，這些資訊總是伴隨著 Patient resource 一同被傳遞，而且這些聯絡人資訊並不能直接被其他 resources 作為參照的目標。這就意味著，如果在其他 resources 中（像是 CarePlan.participant、Encounter.participant、DocumentReference.author、Appointment.participant）需要參照到病人的相關人士，那麼我們就必須要使用 RelatedPerson resource 來實現這一點。

此外，這些紀錄並不是用來記錄病人的主要照護提供者的資訊。相對地，這種類型的資訊應該被儲存在 Patient.generalPractitioner 資料項目中。這樣的安排確保了資訊的清晰劃分，使得病人的聯絡人資訊和照護提供者資訊各自存放在最合適的位置，從而方便了資訊的查詢和使用。

### Patient Gender 和 Sex

很多系統和機構只用一個單一的值來嘗試代表病人的性別和性別認同的所有面向。然而，在記錄和交換有關性別和性別認同的資訊時，存在許多需要考慮的點。接下來列出的是在健康照護場景中相關的各種社會和生物屬性，以及如何傳達每一種資訊。

* **行政性別（Administrative Gender）** - 為了與那些只使用一個通用屬性的系統進行互操作，`[Patient.gender](https://hl7.org/fhir/R4/patient-definitions.html#Patient.gender)` 資料項目表示了一種行政性別。這是指病人在行政和記錄保存上被認定的性別。這個資料項目常常被用於病人匹配算法中。


  除了這個行政性別外，還可以表示其他種類的性別或性別屬性：
* **臨床性別（Clinical Sex）** - 關於病人某個生物特質的可測試檢驗檢查。臨床性別有幾種不同的類型，包括染色體/遺傳/染色體、性腺、管的(ductal)、表型等。臨床性別檢驗檢查應該使用 [Observation](https://hl7.org/fhir/R4/observation.html)，並且用LOINC和/或SNOMED的適當臨床代碼來具體說明。
* **臨床性別認同（Clinical Gender）** - 通常作為社交史紀錄的一部分收集的關於病人的檢驗檢查，並且用 [Observation](https://hl7.org/fhir/R4/observation.html)（[範例](https://hl7.org/fhir/R4/observation-example-clinical-gender.html)）和例如LOINC代碼 76691-5 來表示。臨床性別認同檢驗檢查可以提供歷史和隱私保護，這是 `genderIdentity` 擴充資料項目(extension)做不到的。
* **性別認同（Gender Identity）** - 病人表達他們自認為的性別。這可能影響病人希望如何被照顧者和其他人稱呼。可以使用標準的 `[genderIdentity](https://hl7.org/fhir/R4/extension-patient-genderidentity.html)` 擴充資料項目來傳遞這個屬性。當性別認同是公開知道的時候，使用這個擴充資料項目是恰當的。
* **出生時指定的性別（Sex assigned at Birth）** - 出生登記上紀錄的性別。有些國家允許登記時選擇如「未決定( not yet determined )」、「未知( unknown )」或「無法區分( undifferentiated )」等選項，而有些則不允許。有些國家還允許更改出生登記上的資訊。美國為這個特性定義了一個特定的擴充資料項目。或者，如果你想用檢驗檢查來表示這個概念，你可以使用LOINC代碼 [76689-9](http://loinc.org/76689-9)。
* **法律性別（Legal Sex）** - 地區和國家通常使用單一的法律性別值來分類公民。病人的法律性別可能因地區和國家的不同而有所不同。一個病人在不同的司法管轄區可能同時有多個法律性別值。如果`Patient.gender`行政屬性不足以傳達法律性別，則應使用特定領域的擴充資料項目。

對於獸醫使用，動物擴充資料項目還包括了指示絕育資訊的 `genderStatus`。

### 母新與新生兒的關係

表示母親與新生兒之間關係有幾種方式，這取決於記錄的時間和記錄的目的：

* 如果目的是表達家庭關係和因此而產生的法律責任，比如用於行政目的，那麼應該使用 Patient/RelatedPerson 結構。這個結構隨著時間的推移是保持一致的，意味著無論何時查看，表示的關係和責任都是相同的。
* 為了連接母親和她的寶寶在產科就醫的情況，這涉及行政和計費目的，可以使用 `[Encounter.partof](https://hl7.org/fhir/R4/encounter-definitions.html#Encounter.partOf)` 資料項目。
* 如果需要收集關於病人家庭成員的資訊，而且這些資訊可能與病人的醫療狀況相關時，則應使用 [FamilyMemberHistory](https://hl7.org/fhir/R4/familymemberhistory.html) resource。

在產科就醫期間，母親的 Patient 和 Encounter resources 會存在。寶寶出生後，將創建新的 Patient、Encounter 和 RelatedPerson（針對母親）紀錄，應該使用寶寶的Encounter.partOf 資料項目參照母親的Encounter。Patient/RelatedPerson 結構也應該為持續使用而創建，如此範例所示：

```
<Patient>
	<id value="child"/>
	<!-- The details of the child -->
</Patient>
<RelatedPerson>
	<id value="rp-mom"/>
	<patient>
		<reference value="Patient/child"/>
	</patient>
</RelatedPerson>
<Patient>
	<id value="pat-mom"/>
	<!-- The details of the mom -->
	<link>
		<other value="rp-mom"/>
		<type value="see-also"/>
	</link>
</Patient>
<Encounter>
	<id value="mom-enc"/>
	<status value="in-progress"/>
	<class value="inpatient"/>
	<patient>
		<reference value="Patient/mom"/>
	</patient>
</Encounter>
<Encounter>
	<id value="child-enc"/>
	<status value="in-progress"/>
	<class value="inpatient"/>
	<patient>
		<reference value="Patient/child"/>
	</patient>
	<partOf>
		<reference value="Encounter/mom-enc"/>
	</partOf>
</Encounter>

```

### 合併紀錄

這份規範並沒有指定合併功能：如果發現多個病人紀錄是重複的，它們可以如上所述被連結在一起。這些連結僅僅表達了紀錄之間的關係，並且在替換連結的情況下，指出了一個「主要(master)」紀錄。這份規範並不強制要求 FHIR 伺服器在發現這樣的連結時，將資訊從一個紀錄遷移到另一個紀錄。請注意：

* 健康資訊管理者可能會稱這個過程為「合併(merging)」，但在紀錄層面上，它通常被實作為「連結(linking)」。
* 即便這不是一項強制要求，伺服器也被允許實作合併/紀錄遷移(record migration)功能。

### 使用MPI匹配病人

主要病人索引（Master Patient Index，MPI）是一種服務，它在有多個病人資料庫存在的情境下，用來管理病人的識別工作。健康照護的應用程式和中介軟體使用MPI在這些資料庫之間尋找匹配的病人記錄，並處理新發現的病人資料。MPI是特別設計的應用程式，通常會根據醫療機構所服務的病人類型進行大量客製化。MPI的運作範圍可以是區域性的，也可以是國家級的。

當需要MPI來尋找一個病人的匹配時，用戶端會執行一個叫做病人的 [$match](https://hl7.org/fhir/R4/patient-operation-match.html) 操作。這個操作處理一個包含病人完整或部分資料的Parameters resource，以及一些控制參數，提供給MPI 的 Patient resource 不需要完全符合驗證標準（如必填欄位或規則），因為這份資料不會被儲存，但它必須是一個能被解析的實例。接著，MPI會使用這份resource的資料項目作為輸入，並透過其內部演算法來處理這些資訊，以判定最適合的病人匹配。MPI可能不會利用所有提供的資料項目，並可能會忽略一些資訊。

如果需要定義 MPI 演算法所需的特定參數，可以設定一個特定的Profile，包括必須提供的欄位和規則。

```
POST [base]/Patient/$match
     [包括指定 content-type 為 XML 或 JSON 的一些表頭（headers）]
     [帶有內含 Patitne resoruce 的參數主體]

```

當你使用 MPI 的 $match 功能來尋找病人時，它會回傳一系列的病人紀錄。這些紀錄會按照匹配的可能性高低來排序，從最可能的匹配到最不可能的匹配。如果沒有找到任何匹配的病人，MPI **必須（SHALL）** 回傳一個沒有任何記錄的空結果集，這時不會報錯，但它可能會附加一個提供額外建議的 [操作結果(operation outcome)](https://hl7.org/fhir/R4/operationoutcome.html)。每筆病人記錄都會被打上一個從 0 到 1 的分數，這裡的 1 代表最確定的匹配。此外，還會有一個名為 [「match-grade」](https://hl7.org/fhir/R4/extension-match-grade.html) 的 [擴充的資料項目(extension)](https://hl7.org/fhir/R4/extensibility.html)，用來表示 MPI 對這次匹配的品質。

```
 <entry> 
   <resource>
     <Patient>
       <!-- 病人細節-->
     </Patient>
    </resource>
    <search>
      <extension url="http://hl7.org/fhir/StructureDefinition/match-grade">
        <valueCode value="probable"/>
      </extension>
      <score value="0.80"/>
    </search>
  </entry> 

```

這個 match-grade 擴充資料項目可填入[以下幾種代碼](https://hl7.org/fhir/R4/valueset-match-grade.html)其中一種：

| | |
| :--- | :--- |
| certain | 這筆紀錄滿足了自動判定為完全匹配所需的匹配條件。 |
| probable | 這筆紀錄非常接近於匹配，但並不能確定完全匹配。因此，在確認為匹配之前，可能需要更進一步的檢查（比如，需要人來進行評估）。 |
| possible | 這筆紀錄可能是一個匹配的紀錄。在將其用作匹配之前，**應該(SHOULD)**進行額外的審查（例如：由人工進行）。 |
| certainly-not | 這筆紀錄確定不是我們要找的匹配對象。一般來說，不符合條件的紀錄我們是不會看到的，但有些特殊情況下，那些之前可能被認為是匹配，或者很有可能被當作匹配考慮的紀錄，匹配系統會特別標記為不匹配。 |

使用主要病人索引（MPI）查詢而不是一般查詢目的，主要是因為MPI查詢專門設計來精確找到一位特定的病人，目的是為了在記錄資訊時減少因選錯病人而產生的錯誤。如果查詢條件不夠充分，比如只提供了部分姓氏，MPI通常不會返回任何結果。這和一般查詢不同，一般查詢可用於查找一系列病人，例如查找住在同一地區或處於同一年齡段的病人群，這對於進行人口分析很有幫助。

MPI $match 操作的[官方定義](https://hl7.org/fhir/R4/operation-patient-match.html)已經發布。

### Veterinary Care

獸醫照護完全適用於 FHIR 標準，Patient resource 同樣可以用來記錄病人為動作的資訊。為此，FHIR 提供了一個專門的 [patient-animal 擴充的資料項目](https://hl7.org/fhir/R4/extension-patient-animal.html)，這個擴充資料項目允許記錄動物的種類、品種和性別狀況等細節。但是，這個擴充資料項目並不打算包含獸醫照護中所有重要的屬性，對於更專業的領域，比如實驗室檢驗、動物園照護或畜牧業照護，我們預計會用到更多相關領域的擴充資料項目。

至於獸醫的客戶，也就是動物的「主人(owner)」，則透過 RelatedPerson resource 來表示。



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Patient-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
  "version" : "1.0.0",
  "name" : "TWCorePatient",
  "title" : "TW Core Patient",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "\n此臺灣核心-病人（TW Core Patient） Profile說明本IG如何進一步定義FHIR的Patient Resource以呈現基本資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "short" : "接受健康照護服務的個人或動物之資訊",
        "definition" : "關於接受照護或其他健康相關服務的個人或動物的人口統計學和其他行政資訊。"
      },
      {
        "id" : "Patient.id",
        "path" : "Patient.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的Patient紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "Patient.meta",
        "path" : "Patient.meta",
        "short" : "此Patient Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "Patient.implicitRules",
        "path" : "Patient.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "Patient.language",
        "path" : "Patient.language",
        "short" : "用以表述Patient Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "Patient.text",
        "path" : "Patient.text",
        "short" : "Patient Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "Patient.extension",
        "path" : "Patient.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.extension:age",
        "path" : "Patient.extension",
        "sliceName" : "age",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/person-age"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.extension:nationality",
        "path" : "Patient.extension",
        "sliceName" : "nationality",
        "short" : "病人所屬國籍",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/patient-nationality"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type.coding.code"
            },
            {
              "type" : "value",
              "path" : "type.coding.system"
            }
          ],
          "rules" : "open"
        },
        "short" : "病人的身份識別碼（identifier），通常為業務目的所使用的識別碼，例如病歷號。",
        "definition" : "病人的唯一識別碼（identifier）",
        "requirements" : "病人幾乎總是被指定一個特定的數值型的唯一識別碼（identifier）",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier.type",
        "path" : "Patient.identifier.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ]
      },
      {
        "id" : "Patient.identifier.system",
        "path" : "Patient.identifier.system",
        "min" : 1
      },
      {
        "id" : "Patient.identifier.value",
        "path" : "Patient.identifier.value",
        "min" : 1
      },
      {
        "id" : "Patient.identifier.assigner",
        "path" : "Patient.identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Patient.identifier:idCardNumber",
        "path" : "Patient.identifier",
        "sliceName" : "idCardNumber",
        "short" : "適用身分證字號",
        "definition" : "適用於身分證字號",
        "requirements" : "病人幾乎總是被指定一個特定的數值型的唯一識別碼（identifier）",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "id-card-number",
            "severity" : "error",
            "human" : "身分證號共十碼，首碼以英文字母代表直轄市、縣（市）別，第二碼至第十碼為數字碼。",
            "expression" : "value.matches('^[A-Za-z][0-9]{9}$')",
            "source" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:idCardNumber.use",
        "path" : "Patient.identifier.use",
        "short" : "usual ｜ official ｜ temp ｜ secondary ｜ old （如果知道）",
        "definition" : "這個唯一識別碼（identifier）的用途",
        "comment" : "應用程式可以假定一個識別碼是永久的，除非它明確說它是暫時的。",
        "requirements" : "允許從一組識別碼中為特定的使用情境選擇適當的識別碼",
        "patternCode" : "official",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "IdentifierUse"
            }
          ],
          "strength" : "required",
          "description" : "如果知道，請說明此識別碼的目的；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use|4.0.1"
        }
      },
      {
        "id" : "Patient.identifier:idCardNumber.type",
        "path" : "Patient.identifier.type",
        "short" : "身份識別碼（identifier）的型別說明",
        "definition" : "識別碼的代碼型別，用於決定特定目適用的識別碼。",
        "comment" : "這個資料項目只涉及識別碼的一般類別。它 **必須沒有（SHALL NOT）** 被用於與Identifier.system 1..1對應的代碼。一些識別碼可能由於常見的用法而屬於多個類別。在系統是已知的情況下，型別是不必要的，因為型別總是系統定義的一部分。然而，系統經常需要處理系統不為人知的識別碼。型別和系統之間不是1:1的關係，因為許多不同的系統有相同的型別。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "識別碼的型別，用於決定特定目的所適用的識別碼；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/identifier-type-tw"
        }
      },
      {
        "id" : "Patient.identifier:idCardNumber.type.coding",
        "path" : "Patient.identifier.type.coding",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "min" : 1
      },
      {
        "id" : "Patient.identifier:idCardNumber.type.coding.system",
        "path" : "Patient.identifier.type.coding.system",
        "min" : 1,
        "patternUri" : "http://terminology.hl7.org/CodeSystem/v2-0203"
      },
      {
        "id" : "Patient.identifier:idCardNumber.type.coding.code",
        "path" : "Patient.identifier.type.coding.code",
        "min" : 1,
        "patternCode" : "NNxxx"
      },
      {
        "id" : "Patient.identifier:idCardNumber.type.coding.code.extension",
        "path" : "Patient.identifier.type.coding.code.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.identifier:idCardNumber.type.coding.code.extension:identifier-suffix",
        "path" : "Patient.identifier.type.coding.code.extension",
        "sliceName" : "identifier-suffix",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/identifier-suffix"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:idCardNumber.system",
        "path" : "Patient.identifier.system",
        "short" : "身份識別碼（identifier）的命名空間（namespace）\n例如：身分證字號='http://www.moi.gov.tw'",
        "definition" : "建立值的命名空間－即一個描述一組值的唯一URL",
        "comment" : "Identifier.system總是區分大小寫",
        "requirements" : "有許多識別碼的集合。為了進行兩個識別碼的對應，我們需要知道我們處理的是哪一組。系統指明了一個特定的唯一識別碼集。",
        "patternUri" : "http://www.moi.gov.tw",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:idCardNumber.value",
        "path" : "Patient.identifier.value",
        "short" : "唯一值。\n例如：身分證字號為A123456789",
        "definition" : "識別碼中通常與使用者有關的部分，在系統情境內是唯一的。",
        "comment" : "如果此值是一個完整的URI，那麼此系統 **必須（SHALL）** 是urn:ietf:rfc:3986。此值的主要目的是為了可運算的對應。因此，為了比較的目的，它可能會被正規化（例如：去除不重要的空白、破折號等）。一個為人顯示的格式化的值可以使用[Rendered Value](http://hl7.org/fhir/R4/extension-rendered-value.html)擴充來傳達。除非對Identifier.system的了解使處理者確信不區分大小寫的處理是安全的，否則Identifier.value應被視為區分大小寫。",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:idCardNumber.period",
        "path" : "Patient.identifier.period",
        "short" : "此身份識別碼（identifier）的使用效期",
        "definition" : "識別碼有效／曾經有效使用的時段或期間"
      },
      {
        "id" : "Patient.identifier:idCardNumber.assigner",
        "path" : "Patient.identifier.assigner",
        "short" : "簽發identifier的機構（可以只是文字表述）",
        "definition" : "簽發／管理識別碼的機構",
        "comment" : "Identifier.assigner可以省略.reference資料項目，只包含一個.display資料項目，反映指定機構的名稱或其他文字表述資訊。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Patient.identifier:passportNumber",
        "path" : "Patient.identifier",
        "sliceName" : "passportNumber",
        "short" : "適用護照號碼",
        "definition" : "適用於護照號碼",
        "requirements" : "病人幾乎總是被指定一個特定的數值型的唯一識別碼（identifier）",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:passportNumber.use",
        "path" : "Patient.identifier.use",
        "short" : "usual ｜ official ｜ temp ｜ secondary ｜ old （如果知道）",
        "definition" : "這個唯一識別碼（identifier）的用途",
        "comment" : "應用程式可以假定一個識別碼是永久的，除非它明確說它是暫時的。",
        "requirements" : "允許從一組識別碼中為特定的使用情境選擇適當的識別碼",
        "patternCode" : "official",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "IdentifierUse"
            }
          ],
          "strength" : "required",
          "description" : "如果知道，請說明此識別碼的目的；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use|4.0.1"
        }
      },
      {
        "id" : "Patient.identifier:passportNumber.type",
        "path" : "Patient.identifier.type",
        "short" : "身份識別碼（identifier）的型別說明",
        "definition" : "識別碼的代碼型別，用於決定特定目適用的識別碼。",
        "comment" : "這個資料項目只涉及識別碼的一般類別。它 **必須沒有（SHALL NOT）** 被用於與Identifier.system 1..1對應的代碼。一些識別碼可能由於常見的用法而屬於多個類別。在系統是已知的情況下，型別是不必要的，因為型別總是系統定義的一部分。然而，系統經常需要處理系統不為人知的識別碼。型別和系統之間不是1:1的關係，因為許多不同的系統有相同的型別。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "識別碼的型別，用於決定特定目的所適用的識別碼；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/identifier-type-tw"
        }
      },
      {
        "id" : "Patient.identifier:passportNumber.type.coding",
        "path" : "Patient.identifier.type.coding",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "min" : 1
      },
      {
        "id" : "Patient.identifier:passportNumber.type.coding.system",
        "path" : "Patient.identifier.type.coding.system",
        "min" : 1,
        "patternUri" : "http://terminology.hl7.org/CodeSystem/v2-0203"
      },
      {
        "id" : "Patient.identifier:passportNumber.type.coding.code",
        "path" : "Patient.identifier.type.coding.code",
        "min" : 1,
        "patternCode" : "PPN"
      },
      {
        "id" : "Patient.identifier:passportNumber.system",
        "path" : "Patient.identifier.system",
        "short" : "身份識別碼（identifier）的命名空間（namespace）\n例如：護照號碼='http://www.boca.gov.tw。",
        "definition" : "建立值的命名空間－即一個描述一組值的唯一URL",
        "comment" : "Identifier.system總是區分大小寫",
        "requirements" : "有許多識別碼的集合。為了進行兩個識別碼的對應，我們需要知道我們處理的是哪一組。系統指明了一個特定的唯一識別碼集。",
        "patternUri" : "http://hl7.org/fhir/sid/passport-TWN",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:passportNumber.value",
        "path" : "Patient.identifier.value",
        "short" : "唯一值。 例如：護照號碼為888800371",
        "definition" : "識別碼中通常與使用者有關的部分，在系統情境內是唯一的。",
        "comment" : "如果此值是一個完整的URI，那麼此系統 **必須（SHALL）** 是urn:ietf:rfc:3986。此值的主要目的是為了可運算的對應。因此，為了比較的目的，它可能會被正規化（例如：去除不重要的空白、破折號等）。一個為人顯示的格式化的值可以使用[Rendered Value](http://hl7.org/fhir/R4/extension-rendered-value.html)擴充來傳達。除非對Identifier.system的了解使處理者確信不區分大小寫的處理是安全的，否則Identifier.value應被視為區分大小寫。",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:passportNumber.period",
        "path" : "Patient.identifier.period",
        "short" : "此身份識別碼（identifier）的使用效期",
        "definition" : "識別碼有效／曾經有效使用的時段或期間"
      },
      {
        "id" : "Patient.identifier:passportNumber.assigner",
        "path" : "Patient.identifier.assigner",
        "short" : "簽發identifier的機構（可以只是文字表述）",
        "definition" : "簽發／管理識別碼的機構",
        "comment" : "Identifier.assigner可以省略.reference資料項目，只包含一個.display資料項目，反映指定機構的名稱或其他文字表述資訊。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Patient.identifier:residentNumber",
        "path" : "Patient.identifier",
        "sliceName" : "residentNumber",
        "short" : "適用居留證號碼",
        "definition" : "適用於居留證號碼",
        "requirements" : "病人幾乎總是被指定一個特定的數值型的唯一識別碼（identifier）",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:residentNumber.use",
        "path" : "Patient.identifier.use",
        "short" : "usual ｜ official ｜ temp ｜ secondary ｜ old （如果知道）",
        "definition" : "這個唯一識別碼（identifier）的用途",
        "comment" : "應用程式可以假定一個識別碼是永久的，除非它明確說它是暫時的。",
        "requirements" : "允許從一組識別碼中為特定的使用情境選擇適當的識別碼",
        "patternCode" : "official",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "IdentifierUse"
            }
          ],
          "strength" : "required",
          "description" : "如果知道，請說明此識別碼的目的；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use|4.0.1"
        }
      },
      {
        "id" : "Patient.identifier:residentNumber.type",
        "path" : "Patient.identifier.type",
        "short" : "身份識別碼（identifier）的型別說明",
        "definition" : "識別碼的代碼型別，用於決定特定目適用的識別碼。",
        "comment" : "這個資料項目只涉及識別碼的一般類別。它 **必須沒有（SHALL NOT）** 被用於與Identifier.system 1..1對應的代碼。一些識別碼可能由於常見的用法而屬於多個類別。在系統是已知的情況下，型別是不必要的，因為型別總是系統定義的一部分。然而，系統經常需要處理系統不為人知的識別碼。型別和系統之間不是1:1的關係，因為許多不同的系統有相同的型別。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "識別碼的型別，用於決定特定目的所適用的識別碼；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/identifier-type-tw"
        }
      },
      {
        "id" : "Patient.identifier:residentNumber.type.coding",
        "path" : "Patient.identifier.type.coding",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "min" : 1
      },
      {
        "id" : "Patient.identifier:residentNumber.type.coding.system",
        "path" : "Patient.identifier.type.coding.system",
        "min" : 1,
        "patternUri" : "http://terminology.hl7.org/CodeSystem/v2-0203"
      },
      {
        "id" : "Patient.identifier:residentNumber.type.coding.code",
        "path" : "Patient.identifier.type.coding.code",
        "min" : 1,
        "patternCode" : "PRC"
      },
      {
        "id" : "Patient.identifier:residentNumber.system",
        "path" : "Patient.identifier.system",
        "short" : "身份識別碼（identifier）的命名空間（namespace）\n例如：居留證號='http://www.immigration.gov.tw'。",
        "definition" : "建立值的命名空間－即一個描述一組值的唯一URL",
        "comment" : "Identifier.system總是區分大小寫",
        "requirements" : "有許多識別碼的集合。為了進行兩個識別碼的對應，我們需要知道我們處理的是哪一組。系統指明了一個特定的唯一識別碼集。",
        "patternUri" : "http://www.immigration.gov.tw",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:residentNumber.value",
        "path" : "Patient.identifier.value",
        "short" : "唯一值。 例如：居留證號碼為A912345678",
        "definition" : "識別碼中通常與使用者有關的部分，在系統情境內是唯一的。",
        "comment" : "如果此值是一個完整的URI，那麼此系統 **必須（SHALL）** 是urn:ietf:rfc:3986。此值的主要目的是為了可運算的對應。因此，為了比較的目的，它可能會被正規化（例如：去除不重要的空白、破折號等）。一個為人顯示的格式化的值可以使用[Rendered Value](http://hl7.org/fhir/R4/extension-rendered-value.html)擴充來傳達。除非對Identifier.system的了解使處理者確信不區分大小寫的處理是安全的，否則Identifier.value應被視為區分大小寫。",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:residentNumber.period",
        "path" : "Patient.identifier.period",
        "short" : "此身份識別碼（identifier）的使用效期",
        "definition" : "識別碼有效／曾經有效使用的時段或期間"
      },
      {
        "id" : "Patient.identifier:residentNumber.assigner",
        "path" : "Patient.identifier.assigner",
        "short" : "簽發identifier的機構（可以只是文字表述）",
        "definition" : "簽發／管理識別碼的機構",
        "comment" : "Identifier.assigner可以省略.reference資料項目，只包含一個.display資料項目，反映指定機構的名稱或其他文字表述資訊。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Patient.identifier:medicalRecord",
        "path" : "Patient.identifier",
        "sliceName" : "medicalRecord",
        "short" : "適用病歷號",
        "definition" : "適用於病歷號",
        "requirements" : "病人幾乎總是被指定一個特定的數值型的唯一識別碼（identifier）",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:medicalRecord.use",
        "path" : "Patient.identifier.use",
        "short" : "usual ｜ official ｜ temp ｜ secondary ｜ old （如果知道）",
        "definition" : "這個唯一識別碼（identifier）的用途",
        "comment" : "應用程式可以假定一個識別碼是永久的，除非它明確說它是暫時的。",
        "requirements" : "允許從一組識別碼中為特定的使用情境選擇適當的識別碼",
        "patternCode" : "official",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "IdentifierUse"
            }
          ],
          "strength" : "required",
          "description" : "如果知道，請說明此識別碼的目的；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use|4.0.1"
        }
      },
      {
        "id" : "Patient.identifier:medicalRecord.type",
        "path" : "Patient.identifier.type",
        "short" : "身份識別碼（identifier）的型別說明",
        "definition" : "識別碼的代碼型別，用於決定特定目適用的識別碼。",
        "comment" : "這個資料項目只涉及識別碼的一般類別。它 **必須沒有（SHALL NOT）** 被用於與Identifier.system 1..1對應的代碼。一些識別碼可能由於常見的用法而屬於多個類別。在系統是已知的情況下，型別是不必要的，因為型別總是系統定義的一部分。然而，系統經常需要處理系統不為人知的識別碼。型別和系統之間不是1:1的關係，因為許多不同的系統有相同的型別。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "識別碼的型別，用於決定特定目的所適用的識別碼；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/identifier-type-tw"
        }
      },
      {
        "id" : "Patient.identifier:medicalRecord.type.coding",
        "path" : "Patient.identifier.type.coding",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "min" : 1
      },
      {
        "id" : "Patient.identifier:medicalRecord.type.coding.system",
        "path" : "Patient.identifier.type.coding.system",
        "min" : 1,
        "patternUri" : "http://terminology.hl7.org/CodeSystem/v2-0203"
      },
      {
        "id" : "Patient.identifier:medicalRecord.type.coding.code",
        "path" : "Patient.identifier.type.coding.code",
        "min" : 1,
        "patternCode" : "MR"
      },
      {
        "id" : "Patient.identifier:medicalRecord.system",
        "path" : "Patient.identifier.system",
        "short" : "身份識別碼（identifier）的命名空間（namespace），可至[twTerminology](https://fhir.mohw.gov.tw/ts/namingsystem.jsp?status=active&amp;type=0)申請或查詢命名系統。",
        "definition" : "建立值的命名空間－即一個描述一組值的唯一URL",
        "comment" : "Identifier.system總是區分大小寫",
        "requirements" : "有許多識別碼的集合。為了進行兩個識別碼的對應，我們需要知道我們處理的是哪一組。系統指明了一個特定的唯一識別碼集。",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:medicalRecord.value",
        "path" : "Patient.identifier.value",
        "short" : "唯一值。\n例如：病歷號為8862168",
        "definition" : "識別碼中通常與使用者有關的部分，在系統情境內是唯一的。",
        "comment" : "如果此值是一個完整的URI，那麼此系統 **必須（SHALL）** 是urn:ietf:rfc:3986。此值的主要目的是為了可運算的對應。因此，為了比較的目的，它可能會被正規化（例如：去除不重要的空白、破折號等）。一個為人顯示的格式化的值可以使用[Rendered Value](http://hl7.org/fhir/R4/extension-rendered-value.html)擴充來傳達。除非對Identifier.system的了解使處理者確信不區分大小寫的處理是安全的，否則Identifier.value應被視為區分大小寫。",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:medicalRecord.period",
        "path" : "Patient.identifier.period",
        "short" : "此身份識別碼（identifier）的使用效期",
        "definition" : "識別碼有效／曾經有效使用的時段或期間"
      },
      {
        "id" : "Patient.identifier:medicalRecord.assigner",
        "path" : "Patient.identifier.assigner",
        "short" : "簽發identifier的機構（可以只是文字表述）",
        "definition" : "簽發／管理識別碼的機構",
        "comment" : "Identifier.assigner可以省略.reference資料項目，只包含一個.display資料項目，反映指定機構的名稱或其他文字表述資訊。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Patient.active",
        "path" : "Patient.active",
        "short" : "病人的紀錄是否「使用中（true）」",
        "definition" : "這位病人的紀錄是否在使用中（active）。許多系統使用這個屬性來標記為非現有（non-current）病人，例如那些根據機構的業務規則在一段時間內沒有被看到的病人。\n\n它經常被用來過濾病人清單以排除inactive的病人\n\n已過世的病人也可能因為同樣的原因被標記為inactive，但在過世後的一段時間內可能是active。",
        "comment" : "如果一筆病人紀錄沒有在使用，但與另一筆使用中的病人紀錄相連結，那麼未來的病人／紀錄更新應該發生在另一筆病人紀錄。",
        "requirements" : "若紀錄因為錯誤而創建，需要能夠將這位病人紀錄標記為不使用",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "use"
            }
          ],
          "rules" : "open"
        },
        "short" : "病人的姓名",
        "definition" : "個人名字",
        "comment" : "一位病人可能有多個姓名，有不同的用途或適用期。對於動物來說，這個姓名是一個「HumanName」，它是人類指定和使用的，具有相同的模式。",
        "requirements" : "需要能夠追踪病人的多個姓名。例如：正式姓名及配偶姓名。 **必須（SHALL）** 總是提供姓名的完整拼法。"
      },
      {
        "id" : "Patient.name:official",
        "path" : "Patient.name",
        "sliceName" : "official",
        "short" : "病人的護照姓名",
        "definition" : "個人名字",
        "comment" : "一位病人可能有多個姓名，有不同的用途或適用期。對於動物來說，這個姓名是一個「HumanName」，它是人類指定和使用的，具有相同的模式。",
        "requirements" : "需要能夠追踪病人的多個姓名。例如：正式姓名及配偶姓名。 **必須（SHALL）** 總是提供姓名的完整拼法。",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "tw-core-1",
            "severity" : "error",
            "human" : "Patient.name.text or Patient.name.family or both SHALL be present",
            "expression" : "text.exists() or family.exists()",
            "xpath" : "f:text or f:given",
            "source" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:official.use",
        "path" : "Patient.name.use",
        "definition" : "此姓名的用途",
        "comment" : "應用程式可以假定一個姓名是永久的，除非它明確說它是暫時或舊的。",
        "requirements" : "允許從一組姓名中為特定的使用情境選擇適當的姓名",
        "min" : 1,
        "patternCode" : "official",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "NameUse"
            }
          ],
          "strength" : "required",
          "description" : "人名的使用情況；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/name-use|4.0.1"
        }
      },
      {
        "id" : "Patient.name:official.text",
        "path" : "Patient.name.text",
        "short" : "完整的護照姓名",
        "definition" : "完整姓名的文字表述。由於世界各地的文化差異，取得資料的系統可能不知道如何正確地呈現姓名；此外，不是所有的名字部分都呈現予姓或名。因此，我們強烈建議創建者透過這個資料項目提供姓名的顯示文字。",
        "comment" : "可以同時提供文字表述（text）和部分（part）。更新姓名的應用程式 **必須（SHALL）** 確保當test和lpart都存在時，text中不包含part中沒有的內容。",
        "requirements" : "一個可呈現的、未編碼的形式。",
        "example" : [
          {
            "label" : "General",
            "valueString" : "Chia-Lin Chan"
          }
        ],
        "condition" : ["tw-core-1"],
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:official.family",
        "path" : "Patient.name.family",
        "short" : "護照中的姓",
        "definition" : "姓名中與族譜相關的部分。在一些文化中（如厄立特里亞），兒子的姓氏是其父親的名字。",
        "comment" : "姓氏可以使用擴充名（de、nl、es相關文化）分解成具體的部分（part）",
        "example" : [
          {
            "label" : "General",
            "valueString" : "Chen"
          }
        ],
        "condition" : ["tw-core-1"],
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:official.given",
        "path" : "Patient.name.given",
        "short" : "護照中的名",
        "definition" : "姓名中的「名」",
        "comment" : "如果只記錄首字母，可以用它們來代替完整姓名。首字母可以分為多個名，但由於實際情況的限制，通常不會這樣做。這個資料項目不被稱為 「first name」，因為「given name」並不總是排在前面。",
        "example" : [
          {
            "label" : "General",
            "valueString" : "Chia-Lin"
          }
        ],
        "condition" : ["tw-core-1"],
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:official.prefix",
        "path" : "Patient.name.prefix",
        "short" : "姓名前面的頭銜\n由於學術，法律，職業或貴族身份等原因而獲得頭銜，出現在姓名開頭。",
        "definition" : "由於學術、法規、就業或貴族身份等原因而獲得的名，並出現在姓名的開頭。"
      },
      {
        "id" : "Patient.name:official.suffix",
        "path" : "Patient.name.suffix",
        "short" : "姓名後面的稱謂\n由於學術，法律，職業或貴族身份等原因而獲得頭銜，出現在姓名之後。",
        "definition" : "由於學術、法規、就業或貴族身份等原因而獲得的名，並出現在姓名的開頭。"
      },
      {
        "id" : "Patient.name:official.period",
        "path" : "Patient.name.period",
        "short" : "此姓名的使用效期",
        "definition" : "表明這個姓名對此病人有效的時間區間或期間",
        "requirements" : "允許多個姓名按其歷史情境（效期）儲存"
      },
      {
        "id" : "Patient.name:usual",
        "path" : "Patient.name",
        "sliceName" : "usual",
        "short" : "病人所屬國籍的真實姓名",
        "definition" : "個人名字",
        "comment" : "一位病人可能有多個姓名，有不同的用途或適用期。對於動物來說，這個姓名是一個「HumanName」，它是人類指定和使用的，具有相同的模式。",
        "requirements" : "需要能夠追踪病人的多個姓名。例如：正式姓名及配偶姓名。 **必須（SHALL）** 總是提供姓名的完整拼法。",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "tw-core-1",
            "severity" : "error",
            "human" : "Patient.name.text or Patient.name.family or both SHALL be present",
            "expression" : "text.exists() or family.exists()",
            "xpath" : "f:text or f:given",
            "source" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:usual.use",
        "path" : "Patient.name.use",
        "definition" : "此姓名的用途",
        "comment" : "應用程式可以假定一個姓名是永久的，除非它明確說它是暫時或舊的。",
        "requirements" : "允許從一組姓名中為特定的使用情境選擇適當的姓名",
        "min" : 1,
        "patternCode" : "usual",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "NameUse"
            }
          ],
          "strength" : "required",
          "description" : "人名的使用情況；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/name-use|4.0.1"
        }
      },
      {
        "id" : "Patient.name:usual.text",
        "path" : "Patient.name.text",
        "short" : "完整的中文姓名",
        "definition" : "完整姓名的文字表述。由於世界各地的文化差異，取得資料的系統可能不知道如何正確地呈現姓名；此外，不是所有的名字部分都呈現予姓或名。因此，我們強烈建議創建者透過這個資料項目提供姓名的顯示文字。",
        "comment" : "可以同時提供文字表述（text）和部分（part）。更新姓名的應用程式 **必須（SHALL）** 確保當test和lpart都存在時，text中不包含part中沒有的內容。",
        "requirements" : "一個可呈現的、未編碼的形式。",
        "example" : [
          {
            "label" : "General",
            "valueString" : "陳加玲"
          }
        ],
        "condition" : ["tw-core-1"],
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:usual.family",
        "path" : "Patient.name.family",
        "short" : "若所屬國籍可區分family及given，填入所屬國籍之姓（family）",
        "definition" : "姓名中與族譜相關的部分。在一些文化中（如厄立特里亞），兒子的姓氏是其父親的名字。",
        "comment" : "姓氏可以使用擴充名（de、nl、es相關文化）分解成具體的部分（part）",
        "example" : [
          {
            "label" : "General",
            "valueString" : "陳"
          }
        ],
        "condition" : ["tw-core-1"],
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:usual.given",
        "path" : "Patient.name.given",
        "short" : "若所屬國籍可區分family及given，填入所屬國籍之名（given）",
        "definition" : "姓名中的「名」",
        "comment" : "如果只記錄首字母，可以用它們來代替完整姓名。首字母可以分為多個名，但由於實際情況的限制，通常不會這樣做。這個資料項目不被稱為 「first name」，因為「given name」並不總是排在前面。",
        "example" : [
          {
            "label" : "General",
            "valueString" : "加玲"
          }
        ],
        "condition" : ["tw-core-1"],
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:usual.prefix",
        "path" : "Patient.name.prefix",
        "short" : "姓名前面的頭銜\n由於學術，法律，職業或貴族身份等原因而獲得頭銜，出現在姓名開頭。",
        "definition" : "由於學術、法規、就業或貴族身份等原因而獲得的名，並出現在姓名的開頭。"
      },
      {
        "id" : "Patient.name:usual.suffix",
        "path" : "Patient.name.suffix",
        "short" : "姓名後面的稱謂\n由於學術，法律，職業或貴族身份等原因而獲得頭銜，出現在姓名之後。",
        "definition" : "由於學術、法規、就業或貴族身份等原因而獲得的名，並出現在姓名的開頭。"
      },
      {
        "id" : "Patient.name:usual.period",
        "path" : "Patient.name.period",
        "short" : "此姓名的使用效期",
        "definition" : "表明這個姓名對此病人有效的時間區間或期間",
        "requirements" : "允許多個姓名按其歷史情境（效期）儲存"
      },
      {
        "id" : "Patient.name:temp",
        "path" : "Patient.name",
        "sliceName" : "temp",
        "short" : "新生兒姓名，緊急救護未知病人姓名時亦可用。",
        "definition" : "個人名字",
        "comment" : "一位病人可能有多個姓名，有不同的用途或適用期。對於動物來說，這個姓名是一個「HumanName」，它是人類指定和使用的，具有相同的模式。",
        "requirements" : "需要能夠追踪病人的多個姓名。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:temp.use",
        "path" : "Patient.name.use",
        "definition" : "此姓名的用途",
        "comment" : "應用程式可以假定一個姓名是永久的，除非它明確說它是暫時或舊的。",
        "requirements" : "允許從一組姓名中為特定的使用情境選擇適當的姓名",
        "min" : 1,
        "patternCode" : "temp",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "NameUse"
            }
          ],
          "strength" : "required",
          "description" : "人名的使用情況；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/name-use|4.0.1"
        }
      },
      {
        "id" : "Patient.name:temp.text",
        "path" : "Patient.name.text",
        "short" : "完整的中文姓名",
        "definition" : "完整姓名的文字表述。由於世界各地的文化差異，取得資料的系統可能不知道如何正確地呈現姓名；此外，不是所有的名字部分都呈現予姓或名。因此，我們強烈建議創建者透過這個資料項目提供姓名的顯示文字。",
        "comment" : "可以同時提供文字表述（text）和部分（part）。更新姓名的應用程式 **必須（SHALL）** 確保當test和lpart都存在時，text中不包含part中沒有的內容。",
        "requirements" : "一個可呈現的、未編碼的形式。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:temp.family",
        "path" : "Patient.name.family",
        "max" : "0"
      },
      {
        "id" : "Patient.name:temp.given",
        "path" : "Patient.name.given",
        "max" : "0"
      },
      {
        "id" : "Patient.name:temp.prefix",
        "path" : "Patient.name.prefix",
        "max" : "0"
      },
      {
        "id" : "Patient.name:temp.suffix",
        "path" : "Patient.name.suffix",
        "max" : "0"
      },
      {
        "id" : "Patient.name:temp.period",
        "path" : "Patient.name.period",
        "short" : "此姓名的使用效期",
        "definition" : "表明這個姓名對此病人有效的時間區間或期間",
        "requirements" : "允許多個姓名按其歷史情境（效期）儲存"
      },
      {
        "id" : "Patient.name:anonymous",
        "path" : "Patient.name",
        "sliceName" : "anonymous",
        "short" : "匿名供研究使用",
        "definition" : "個人名字",
        "comment" : "一位病人可能有多個姓名，有不同的用途或適用期。對於動物來說，這個姓名是一個「HumanName」，它是人類指定和使用的，具有相同的模式。",
        "requirements" : "需要能夠追踪病人的多個姓名。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:anonymous.use",
        "path" : "Patient.name.use",
        "definition" : "此姓名的用途",
        "comment" : "應用程式可以假定一個姓名是永久的，除非它明確說它是暫時或舊的。",
        "requirements" : "允許從一組姓名中為特定的使用情境選擇適當的姓名",
        "min" : 1,
        "patternCode" : "anonymous",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "NameUse"
            }
          ],
          "strength" : "required",
          "description" : "人名的使用情況；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/name-use|4.0.1"
        }
      },
      {
        "id" : "Patient.name:anonymous.text",
        "path" : "Patient.name.text",
        "short" : "完整的中文姓名",
        "definition" : "完整姓名的文字表述。由於世界各地的文化差異，取得資料的系統可能不知道如何正確地呈現姓名；此外，不是所有的名字部分都呈現予姓或名。因此，我們強烈建議創建者透過這個資料項目提供姓名的顯示文字。",
        "comment" : "可以同時提供文字表述（text）和部分（part）。更新姓名的應用程式 **必須（SHALL）** 確保當test和lpart都存在時，text中不包含part中沒有的內容。",
        "requirements" : "一個可呈現的、未編碼的形式。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:anonymous.family",
        "path" : "Patient.name.family",
        "max" : "0"
      },
      {
        "id" : "Patient.name:anonymous.given",
        "path" : "Patient.name.given",
        "max" : "0"
      },
      {
        "id" : "Patient.name:anonymous.prefix",
        "path" : "Patient.name.prefix",
        "max" : "0"
      },
      {
        "id" : "Patient.name:anonymous.suffix",
        "path" : "Patient.name.suffix",
        "max" : "0"
      },
      {
        "id" : "Patient.name:anonymous.period",
        "path" : "Patient.name.period",
        "short" : "此姓名的使用效期",
        "definition" : "表明這個姓名對此病人有效的時間區間或期間",
        "requirements" : "允許多個姓名按其歷史情境（效期）儲存"
      },
      {
        "id" : "Patient.telecom",
        "path" : "Patient.telecom",
        "short" : "病人的聯絡資訊（例如：電話、電子郵件等）",
        "definition" : "可與此人聯絡的詳細聯絡方式（如電話或電子郵件地址等）",
        "comment" : "一位病人可能有多種聯絡方式，有不同的用途或適用期。可能需要有緊急聯絡此人的選項，也需要幫忙識別身份。地址可能不會直接聯絡到此人，但可能到透過他人代為聯絡（意即家中的電話）。",
        "requirements" : "人們有（主要）方式與他們聯絡，如電話、電子郵件。",
        "mustSupport" : true
      },
      {
        "id" : "Patient.telecom.system",
        "path" : "Patient.telecom.system",
        "definition" : "聯絡方式的通訊形式－需要什麼通訊系統進行聯絡",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ContactPointSystem"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/contact-point-system|4.0.1"
        }
      },
      {
        "id" : "Patient.telecom.value",
        "path" : "Patient.telecom.value",
        "short" : "實際的聯絡方式之細節",
        "definition" : "實際的聯絡方式之細節，針對指定的通訊系統提供有意義的形式（電話號碼或是電子郵件位址）",
        "comment" : "額外的文字資料，例如電話分機號碼、或關於聯絡人的說明，有時也包括於此值。",
        "requirements" : "需支援非嚴格格式控制之舊有號碼",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.telecom.use",
        "path" : "Patient.telecom.use",
        "short" : "home | work | temp | old | mobile－此聯絡方式的用途",
        "definition" : "確定聯絡方式的用途",
        "comment" : "應用程式可以假定一個聯絡方法是目前使用中，除非它明確說它是暫時的或舊的。",
        "requirements" : "需要追蹤此人使用這種聯絡的方式，使用者可以選擇適合他們用途的聯絡方式。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ContactPointUse"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/contact-point-use|4.0.1"
        }
      },
      {
        "id" : "Patient.telecom.rank",
        "path" : "Patient.telecom.rank",
        "short" : "具體說明偏好的使用順序（1=最高優先順序）",
        "definition" : "具體說明使用一組聯繫方式的優先順序，較小排名序位的聯絡方式比較大排名序位的聯絡方式之序位還要前面。",
        "comment" : "請注意，排名序位沒有一定要遵循聯絡方式在實例中呈現的順序。"
      },
      {
        "id" : "Patient.telecom.period",
        "path" : "Patient.telecom.period",
        "short" : "此聯絡方式的使用效期",
        "definition" : "此聯絡方式的使用效期",
        "mustSupport" : true
      },
      {
        "id" : "Patient.gender",
        "path" : "Patient.gender",
        "short" : "male ｜ female ｜ other ｜ unknown",
        "definition" : "Administrative Gender 為行政管理及保存紀錄目的之病人性別",
        "comment" : "行政管理用之性別可能不符合由遺傳學或個人偏好的識別所決定的生物性別。請注意，對於人類，特別是動物，除了男性和女性，還有其他合法歸類的可能性，儘管絕大多數系統和情境只支持男性和女性。提供決策支援或執行業務規則的系統最好以檢驗檢查（Observation）呈現特定性別或感興趣的性別（解剖學、染色體、社會等）。然而，由於這些檢驗檢驗不常被記錄，預設為行政管理用之性別是常見的做法。在這種預設的情況下，規則的執行應該允許行政管理用和生物、染色體和其他性別方面的差異。例如：關於男性子宮切除的警訊應該作為警告或可推翻的錯誤來處理，而不是 「硬（hard） 」錯誤。關於溝通病人性別的更多資訊，請參閱Patient Gender及Sex的部分。",
        "requirements" : "性別用於結合（至少）姓名和出生日期以識別個人身份",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "AdministrativeGender"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "required",
          "description" : "病人性別；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/administrative-gender|4.0.1"
        }
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "short" : "病人出生日期",
        "definition" : "個人的出生日期",
        "comment" : "如果真實的出生日期未知，至少應該提供一個估計的出生年份作為猜測。有一個標準的擴充 「patient-birthTime」，應該於需要出生時間（Time）資訊時使用（例如：在產科／新生兒照護系統中）。",
        "requirements" : "個人的年齡驅動著許多臨床過程／進程",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.deceased[x]",
        "path" : "Patient.deceased[x]",
        "short" : "病人是否過世",
        "definition" : "表示此人是否過世",
        "comment" : "如果實例中沒有值，就意味著沒有關於此人是否過世的聲明。大多數系統會把沒有數值解釋為這個人還活著的標誌。",
        "requirements" : "病人已經過世的事實影響了臨床過程／進度。另外，在人際溝通和關係管理中，有必要知道這個人是否活著。"
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address",
        "short" : "病人聯絡地址\npat-cnt-2or3-char：如果有國家名，則必須（SHALL）從[ISO Country Alpha-2](http://hl7.org/fhir/valueset/iso3166-1-2)找出相對代碼作呈現。 如果未在ISO Country Alpha-2 中找到此一國家的代碼，則可能可以（MAY）從[ISO Country Alpha-3](http://hl7.org/fhir/valueset/iso3166-1-3)找出相對代碼作呈現。",
        "definition" : "此人的地址",
        "comment" : "病人可能有多個地址，有不同的用途或適用期。",
        "requirements" : "可能需要記錄病人的地址，以便聯繫、結算或報告的要求，也有助於識別身份。",
        "type" : [
          {
            "code" : "Address",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Address-tw"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.maritalStatus",
        "path" : "Patient.maritalStatus",
        "short" : "病人的婚姻狀態",
        "definition" : "這個欄位包含病人的目前婚姻（民事）狀態",
        "requirements" : "如果不是所有的系統都能取得此資訊",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MaritalStatus"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "extensible",
          "description" : "病人的婚姻狀態；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/marital-status"
        }
      },
      {
        "id" : "Patient.multipleBirth[x]",
        "path" : "Patient.multipleBirth[x]",
        "short" : "病人是否為多胞胎；或多胞胎出生順序。",
        "definition" : "表示病人是否是為多胞胎（佈林值）或表示實際的出生順序（整數值）",
        "comment" : "在提供valueInteger的情況下，這個數字是序列中的出生序。例如：三胞胎中的中間胎兒是valueInteger=2，第三胎兒是valueInteger=3，如果是為三胞胎提供布林值，那麼所有3位病人的紀錄都是valueBoolean=true（沒有指明出生序）。",
        "requirements" : "用於消除多胎孩童的歧義，特別是在照護人員沒有見到病人的情況下，例如：在實驗室。"
      },
      {
        "id" : "Patient.photo",
        "path" : "Patient.photo",
        "short" : "病人的影像（照片）",
        "definition" : "病人的影像（照片）",
        "comment" : "指引：\n使用個人影像，而不是臨床影像。\n限制尺寸為縮圖。\n保持低位元組小檔案以便更新resource。",
        "requirements" : "許多EHR系統有能力取得病人的影像，這也符合較新的社群媒體的使用。",
        "mustSupport" : true
      },
      {
        "id" : "Patient.contact",
        "path" : "Patient.contact",
        "short" : "病人的聯絡人，例如：監護人、伴侶、朋友等。",
        "definition" : "病人的聯絡人（如監護人、伴侶、朋友）。",
        "comment" : "聯絡涵蓋所有種類的聯絡人：家人、業務聯絡、監護人、照顧者。不適用於登記血統和家庭關係，因這超出聯絡的目的。",
        "requirements" : "需能聯絡到的病人的人。",
        "mustSupport" : true
      },
      {
        "id" : "Patient.contact.relationship",
        "path" : "Patient.contact.relationship",
        "short" : "概念（Concept）－參照一個專門術語或只是文字表述",
        "definition" : "可以透過正式參照一個專門術語或知識本體來定義一個概念，或者也可以文字表述此概念。",
        "requirements" : "根據情況決定哪位聯絡人最有關聯以作聯繫",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/relatedperson-relationshiptype"
        }
      },
      {
        "id" : "Patient.contact.name",
        "path" : "Patient.contact.name",
        "short" : "聯絡人姓名",
        "definition" : "與聯絡人有關的姓名",
        "requirements" : "聯絡人需要以姓名來識別，但通常不需要此聯絡人的其他姓名的細節。",
        "mustSupport" : true
      },
      {
        "id" : "Patient.contact.name.use",
        "path" : "Patient.contact.name.use",
        "definition" : "此姓名的用途",
        "comment" : "應用程式可以假定一個姓名是永久的，除非它明確說它是暫時或舊的。",
        "requirements" : "允許從一組姓名中為特定的使用情境選擇適當的姓名",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "NameUse"
            }
          ],
          "strength" : "required",
          "description" : "人名的使用情況；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/name-use|4.0.1"
        }
      },
      {
        "id" : "Patient.contact.name.text",
        "path" : "Patient.contact.name.text",
        "short" : "完整的中文姓名",
        "definition" : "完整姓名的文字表述。由於世界各地的文化差異，取得資料的系統可能不知道如何正確地呈現姓名；此外，不是所有的名字部分都呈現予姓或名。因此，我們強烈建議創建者透過這個資料項目提供姓名的顯示文字。",
        "comment" : "可以同時提供文字表述（text）和部分（part）。更新姓名的應用程式  **必須（SHALL）**  確保當test和lpart都存在時，text中不包含part中沒有的內容。",
        "requirements" : "一個可呈現的、未編碼的形式。",
        "mustSupport" : true
      },
      {
        "id" : "Patient.contact.name.family",
        "path" : "Patient.contact.name.family",
        "short" : "英文姓",
        "definition" : "姓名中與族譜相關的部分。在一些文化中（如厄立特里亞），兒子的姓氏是其父親的名字。",
        "comment" : "姓氏可以使用擴充名（de、nl、es相關文化）分解成具體的部分（part）",
        "mustSupport" : true
      },
      {
        "id" : "Patient.contact.name.given",
        "path" : "Patient.contact.name.given",
        "short" : "英文名",
        "definition" : "姓名中的「名」",
        "comment" : "如果只記錄首字母，可以用它們來代替完整姓名。首字母可以分為多個名，但由於實際情況的限制，通常不會這樣做。這個資料項目不被稱為 「first name」，因為「given name」並不總是排在前面。",
        "mustSupport" : true
      },
      {
        "id" : "Patient.contact.name.prefix",
        "path" : "Patient.contact.name.prefix",
        "short" : "姓名前面的頭銜\n由於學術，法律，職業或貴族身份等原因而獲得頭銜，出現在姓名開頭。",
        "definition" : "由於學術、法規、就業或貴族身份等原因而獲得的名，並出現在姓名的開頭。"
      },
      {
        "id" : "Patient.contact.name.suffix",
        "path" : "Patient.contact.name.suffix",
        "short" : "姓名後面的稱謂\n由於學術，法律，職業或貴族身份等原因而獲得頭銜，出現在姓名之後。",
        "definition" : "由於學術、法規、就業或貴族身份等原因而獲得的名，並出現在姓名的開頭。"
      },
      {
        "id" : "Patient.contact.name.period",
        "path" : "Patient.contact.name.period",
        "short" : "此姓名的使用效期",
        "definition" : "表明這個姓名對此病人有效的時間區間或期間",
        "requirements" : "允許多個姓名按其歷史情境（效期）儲存"
      },
      {
        "id" : "Patient.contact.telecom",
        "path" : "Patient.contact.telecom",
        "short" : "聯絡人的詳細聯絡資訊",
        "definition" : "此人的詳細聯絡方式，例如：電話號碼或電子郵件地址。",
        "comment" : "聯絡人可能有多種聯絡方式，有不同的用途或適用期。可能需要有緊急聯絡此人的選項，及需要幫忙身份識別。",
        "requirements" : "人們可透過（主要）方式與他們聯絡，例如電話、電子郵件。",
        "mustSupport" : true
      },
      {
        "id" : "Patient.contact.telecom.system",
        "path" : "Patient.contact.telecom.system",
        "definition" : "聯絡方式的通訊形式－需要什麼通訊系統進行聯絡",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ContactPointSystem"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/contact-point-system|4.0.1"
        }
      },
      {
        "id" : "Patient.contact.telecom.value",
        "path" : "Patient.contact.telecom.value",
        "short" : "實際的聯絡方式之細節",
        "definition" : "實際的聯絡方式之細節，針對指定的通訊系統提供有意義的形式（電話號碼或是電子郵件位址）。",
        "comment" : "額外的文字資料，例如電話分機號碼、或關於聯絡人的說明，有時也包括於此值。",
        "requirements" : "需支援非嚴格格式控制之舊有號碼",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.contact.telecom.use",
        "path" : "Patient.contact.telecom.use",
        "short" : "home | work | temp | old | mobile－此聯絡方式的用途",
        "definition" : "確定聯絡方式的用途",
        "comment" : "應用程式可以假定一個聯絡方法是目前使用中，除非它明確說它是暫時的或舊的。",
        "requirements" : "需要追蹤此人使用這種聯絡的方式，使用者可以選擇適合他們用途的聯絡方式。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ContactPointUse"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/contact-point-use|4.0.1"
        }
      },
      {
        "id" : "Patient.contact.telecom.rank",
        "path" : "Patient.contact.telecom.rank",
        "short" : "具體說明偏好的使用順序（1=最高優先順序）",
        "definition" : "具體說明使用一組聯繫方式的優先順序，較小排名序位的聯絡方式比較大排名序位的聯絡方式之序位還要前面。",
        "comment" : "請注意，排名序位沒有一定要遵循聯絡方式在實例中呈現的順序。"
      },
      {
        "id" : "Patient.contact.telecom.period",
        "path" : "Patient.contact.telecom.period",
        "short" : "此聯絡方式的使用效期",
        "definition" : "此聯絡方式的使用效期"
      },
      {
        "id" : "Patient.contact.address",
        "path" : "Patient.contact.address",
        "short" : "聯絡人的地址",
        "definition" : "聯絡人的地址",
        "requirements" : "需要紀錄用以聯絡聯絡人的郵件地址或到訪地址",
        "type" : [
          {
            "code" : "Address",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Address-tw"
            ]
          }
        ]
      },
      {
        "id" : "Patient.contact.gender",
        "path" : "Patient.contact.gender",
        "short" : "male ｜ female ｜ other ｜ unknown",
        "definition" : "Administrative Gender為行政管理的及保存紀錄目的之聯絡人性別",
        "requirements" : "用以正確稱呼聯絡人",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "AdministrativeGender"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "required",
          "description" : "聯絡人的性別；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/administrative-gender|4.0.1"
        }
      },
      {
        "id" : "Patient.contact.organization",
        "path" : "Patient.contact.organization",
        "short" : "可聯絡到聯絡人的機構",
        "definition" : "聯絡人為機構或聯絡人為其工作的機構",
        "requirements" : "監護人或與業務相關聯絡與此機構有關",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Patient.contact.period",
        "path" : "Patient.contact.period",
        "short" : "聯絡人或其可聯絡機構之可聯絡期（時間區間）",
        "definition" : "與此病人有關的聯絡人或機構的有效聯絡期",
        "mustSupport" : true
      },
      {
        "id" : "Patient.communication",
        "path" : "Patient.communication",
        "short" : "向病人說明健康狀態時所使用的語言",
        "definition" : "可用於與病人溝通其健康狀況的語言。",
        "comment" : "如果沒有指定語言，這意味著預設使用當地語言。如果你需要多種模式的熟練程度，那麼你需要多個Patient.Communication關聯。對於動物來說，語言不是相關的欄位，應該不存在於實例中。如果病人不講預設的當地語言，那麼可以使用 「（Interpreter Required Standard）需要口譯員」來明確聲明需要口譯員。",
        "requirements" : "如果病人不會說當地語言，可能需要翻譯，因此，對於病人和其他相關人士來說，所講的語言和熟練程度都是需要記錄的重要內容。",
        "mustSupport" : true
      },
      {
        "id" : "Patient.communication.language",
        "path" : "Patient.communication.language",
        "short" : "向病人說明健康狀況時所使用的語言",
        "definition" : "小寫的ISO-639-1字母兩個代碼表示的語言，後面可以有連字符號，大寫的ISO-3166-1字母兩個代碼表示使用此語言的地區；例如「en 」代表英語，或者 「en-US 」代表美國英語，而 「en-EN 」代表英國英語。",
        "comment" : "帶有這種精確字母大小寫的aa-BB結構是最廣泛使用的地方性符號之一。但並不是所有的系統都對其進行編碼，而是將其作為純文字表述。因此，data type為CodeableConcept而不是code。",
        "requirements" : "在多語言國家的大多數系統都會想要溝通語言。並非所有的系統實際上都需要區域方言。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "Patient.communication.preferred",
        "path" : "Patient.communication.preferred",
        "short" : "病人是否偏好使用此語言",
        "definition" : "表示病人是否偏好此語言（相對於其他它已掌握到一定水平的語言）",
        "comment" : "此語言專門用以溝通健康照護資訊",
        "requirements" : "掌握多種語言達到一定水平的人可能更偏好一種或多種語言，也就是說，在用某一種語言溝通時感到更有信心，使其他語言成為一種備用語言。"
      },
      {
        "id" : "Patient.generalPractitioner",
        "path" : "Patient.generalPractitioner",
        "short" : "照護此病人的機構、照護服務提供者、或健康照護服務提供者的角色",
        "definition" : "病人指定的照護服務提供者",
        "comment" : "這可能是基層健康照護提供者（在一般科醫生的情境下），也可能是在社區／失能環境中由病人提名的照護管理者，甚至是提供人力來履行照護提供者角色的機構。它不能用來記錄Care Teams，這些團隊應該在CareTeams resource中，可以連接到CarePlan或EpisodeOfCare。由於各種原因，病人可能會被記錄有多個一般科醫生，例如：一位學生在學校學期期間將他的家庭醫生與大學的醫生一起列出，或者一位至偏遠地區「飛進／飛出 」的工作者會有當地的醫師及其家庭醫生，以保持對醫療問題的瞭解。  \n如果需要，各行政管轄區可決定將其規範為只有1位，或每種型別1位。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Patient.managingOrganization",
        "path" : "Patient.managingOrganization",
        "short" : "此紀錄的保管機構",
        "definition" : "病人紀錄的保管機構",
        "comment" : "僅有一個管理特定病人紀錄的機構。其他機構將擁有自己的「病人」紀錄，並可透過使用「Link」屬性將紀錄結合在一起（或可以包含關聯可信的「Person」resource）。",
        "requirements" : "需要知道誰識別、管理和更新這位病人的紀錄",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.link",
        "path" : "Patient.link",
        "short" : "連結至此病人的其他Patient Resource",
        "definition" : "連結到另一個涉及同一實際病人的Patient resource。",
        "comment" : "不存在連結的病人紀錄有相互連結的假設",
        "requirements" : "有多種使用案例：  \n由於難以一致地指明與人相關的文件而錯誤地重複製作病人紀錄，並在多個伺服器上發佈病人的資訊。"
      },
      {
        "id" : "Patient.link.other",
        "path" : "Patient.link.other",
        "short" : "連結至其他Patient或RelatedPerson Resource",
        "definition" : "此連超所參照的另一個Patient resource",
        "comment" : "在這裡參照一個RelatedPerson，就不需要另外使用Person來將Patient及RelatedPerson作為同一個人關聯起來。",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : false
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Patient.link.type",
        "path" : "Patient.link.type",
        "short" : "replaced-by ｜ replaces ｜ refer ｜ seealso",
        "definition" : "這個Patient resource與另一個Patient resource之間的連結型別",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "LinkType"
            }
          ],
          "strength" : "required",
          "description" : "連結的型別；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/link-type|4.0.1"
        }
      }
    ]
  }
}

```
