# TW Core Organization - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Organization 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreOrganization |

 
此臺灣核心-機構（TW Core Organization）Profile說明本IG如何進一步定義FHIR的Organization Resource以呈現機構基本資料。 

## Resource Organization - 內容

這是指一群人或機構，他們不論是正式或非正式地被認可，都是為了達成某種共同行動的目的而聚集在一起。這樣的群體包括了各種形式，如公司、學校、企業、部門、社群（區）團體、健康照護服務團隊以及醫療費用支付者（payer）如健保署（全民健保）、僱主（提供員工健康保險福利）或收取保費提供健康保險的機構或公司（insurer）等。

### 範圍與使用

這個 resource 既可以用來在一個共享註冊處登記各種機構的聯絡方式和其他資訊，也可以單純作為支援其他需要參照機構資訊的resource，比如作為一份[文件（docuement）](https://hl7.org/fhir/R4/documents.html)、一則[訊息（message）](https://hl7.org/fhir/R4/messaging.html)或者作為一個[內嵌（contained）](https://hl7.org/fhir/R4/references.html#contained) resource 。如果採用註冊處的方式，那麼完全有可能存在多個註冊處，其中每一個都專門處理不同類型或不同層級的機構資訊。

### 界限與關聯

Organization resource 用於描述一群人為了共同的目標而聚集的情形。與之相對，[Group](https://hl7.org/fhir/R4/group.html) 則用來標識一群出於分析目的或需要被採取行動對的人（或動物、設備等），但這群體本身不預期會採取任何行動。

Organization resource 通常會形成一個層級結構，透過使用 part-of 屬性來顯示子Organization與其父Organization之間的聯繫。這種機構的層級結構幫助闡明概念上的結構，而 Location resource 則提供了這種層級結構的實體上表示。

Organization 與 Location 之間的關聯是從 Location 層級結構中的每一點到 Organization 層級結構中適當層級的連接。這些連結不一定都指向最頂層的 Organization。

在構建 Organization 和 Location 的層級結構時，雖然這兩者間可能不容易區分，但為了幫助進行判斷，Location 總被用來記錄服務發生的地點，從而與 Encounter 和 Observation 有所聯繫。這意味著，resource 上的 Organization 屬性可能不反應服務發生的真實位置。

Organization resource 被以下 resources 所參照： 註釋（[Annotation](https://hl7.org/fhir/R4/datatypes.html#Annotation)）、識別碼（[Identifier](https://hl7.org/fhir/R4/datatypes.html#Identifier)）、簽章（[Signature](https://hl7.org/fhir/R4/datatypes.html#Signature)）、使用情境（[UsageContext](https://hl7.org/fhir/R4/metadatatypes.html#UsageContext)）、帳戶（[Account](https://hl7.org/fhir/R4/account.html#Account)）、稽核事件（[AuditEvent](https://hl7.org/fhir/R4/auditevent.html#AuditEvent)）基本（[Basic](https://hl7.org/fhir/R4/basic.html#Basic)）、生物衍生產品（[BiologicallyDerivedProduct](https://hl7.org/fhir/R4/biologicallyderivedproduct.html#BiologicallyDerivedProduct)）、能力聲明（[CapabilityStatement](https://hl7.org/fhir/R4/capabilitystatement.html#CapabilityStatement)）、照護計畫（[CarePlan](https://hl7.org/fhir/R4/careplan.html#CarePlan)）、照護團隊（[CareTeam](https://hl7.org/fhir/R4/careteam.html#CareTeam)）、目錄內的條目（[CatalogEntry](https://hl7.org/fhir/R4/catalogentry.html#CatalogEntry)）、費用項目（[ChargeItem](https://hl7.org/fhir/R4/chargeitem.html#ChargeItem)）、理賠申請（[Claim](https://hl7.org/fhir/R4/claim.html#Claim)）、理賠申請回應（[ClaimResponse](https://hl7.org/fhir/R4/claimresponse.html#ClaimResponse)）、通訊（[Communication](https://hl7.org/fhir/R4/communication.html#Communication)）、通訊請求（[CommunicationRequest](https://hl7.org/fhir/R4/communicationrequest.html#CommunicationRequest)）、臨床文件架構（[Composition](StructureDefinition-Composition-twcore.md)）、同意書（[Consent](https://hl7.org/fhir/R4/consent.html#Consent)）、同意書（[Consent](https://hl7.org/fhir/R4/consent.html#Consent)）、合約（[Contract](https://hl7.org/fhir/R4/contract.html#Contract)）、給付範圍（[Coverage](https://hl7.org/fhir/R4/coverage.html#Coverage)）、給付資格請求（[CoverageEligibilityRequest](https://hl7.org/fhir/R4/coverageeligibilityrequest.html#CoverageEligibilityRequest)）、給付資格回應（[CoverageEligibilityResponse](https://hl7.org/fhir/R4/coverageeligibilityresponse.html#CoverageEligibilityResponse)）、設備（[Device](https://hl7.org/fhir/R4/device.html#Device)）、設備定義（[DeviceDefinition](https://hl7.org/fhir/R4/devicedefinition.html#DeviceDefinition)）、設備請求（[DeviceRequest](https://hl7.org/fhir/R4/devicerequest.html#DeviceRequest)）、診斷報告（[DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md)）、文件清單（[DocumentManifest](https://hl7.org/fhir/R4/documentmanifest.html#DocumentManifest)）、文件參照（[DocumentReference](StructureDefinition-DocumentReference-twcore.md)）、就醫（[Encounter](StructureDefinition-Encounter-twcore.md)）、端點（[Endpoint](https://hl7.org/fhir/R4/endpoint.html#Endpoint)）、加入或退出保險計畫請求（[EnrollmentRequest](https://hl7.org/fhir/R4/enrollmentrequest.html#EnrollmentRequest)）、 加入或退出保險計畫回應（[EnrollmentResponse](https://hl7.org/fhir/R4/enrollmentresponse.html#EnrollmentResponse)）、照護事件（[EpisodeOfCare](https://hl7.org/fhir/R4/episodeofcare.html#EpisodeOfCare)）、利益說明（[ExplanationOfBenefit](https://hl7.org/fhir/R4/explanationofbenefit.html#ExplanationOfBenefit)）、標記（[Flag](https://hl7.org/fhir/R4/flag.html#Flag)）、目標（[Goal](https://hl7.org/fhir/R4/goal.html#Goal)）、群體（[Group](https://hl7.org/fhir/R4/group.html#Group)）、健康照護服務（[HealthcareService](https://hl7.org/fhir/R4/healthcareservice.html#HealthcareService)）、影像檢查（[ImagingStudy](StructureDefinition-ImagingStudy-twcore.md)）、疫苗接種（[Immunization](https://hl7.org/fhir/R4/immunization.html#Immunization)）、疫苗接種評估（[ImmunizationEvaluation](https://hl7.org/fhir/R4/immunizationevaluation.html#ImmunizationEvaluation)）、疫苗接種建議（[ImmunizationRecommendation](https://hl7.org/fhir/R4/immunizationrecommendation.html#ImmunizationRecommendation)）、保險計畫（[InsurancePlan](https://hl7.org/fhir/R4/insuranceplan.html#InsurancePlan)）、發票或費用清單（[Invoice](https://hl7.org/fhir/R4/invoice.html#Invoice)）、連結（[Linkage](https://hl7.org/fhir/R4/linkage.html#Linkage)）、地點（[Location](StructureDefinition-Location-twcore.md)）、測量報告（[MeasureReport](https://hl7.org/fhir/R4/measurereport.html#MeasureReport)）、多媒體（[Media](StructureDefinition-Media-twcore.md)）、藥品（[Medication](StructureDefinition-Medication-twcore.md)）、配藥或藥品調劑（[MedicationDispense](StructureDefinition-MedicationDispense-twcore.md)）、藥品知識（[MedicationKnowledge](https://hl7.org/fhir/R4/medicationknowledge.html#MedicationKnowledge)）藥品請求（[MedicationRequest](StructureDefinition-MedicationRequest-twcore.md)）、用藥聲明（[MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)）、醫藥產品（[MedicinalProduct](https://hl7.org/fhir/R4/medicinalproduct.html#MedicinalProduct)）、醫藥產品授權（[MedicinalProductAuthorization](https://hl7.org/fhir/R4/medicinalproductauthorization.html#MedicinalProductAuthorization)）、醫藥產品成份（[MedicinalProductIngredient](https://hl7.org/fhir/R4/medicinalproductingredient.html#MedicinalProductIngredient)）、醫藥產品製造（[MedicinalProductManufactured](https://hl7.org/fhir/R4/medicinalproductmanufactured.html#MedicinalProductManufactured)）、醫藥產品包裝（[MedicinalProductPackaged](https://hl7.org/fhir/R4/medicinalproductpackaged.html#MedicinalProductPackaged)）、訊息表頭（[MessageHeader](StructureDefinition-MessageHeader-twcore.md)）、分子序列（[MolecularSequence](https://hl7.org/fhir/R4/molecularsequence.html#MolecularSequence)）、檢驗檢查（[Observation](StructureDefinition-Observation-laboratoryResult-twcore.md)）、機構（Organization）、機構隸屬關係（[OrganizationAffiliation](https://hl7.org/fhir/R4/organizationaffiliation.html#OrganizationAffiliation)）、病人（[Patient](StructureDefinition-Patient-twcore.md)）、付款通知（[PaymentNotice](https://hl7.org/fhir/R4/paymentnotice.html#PaymentNotice)）、付款對帳（[PaymentReconciliation](https://hl7.org/fhir/R4/paymentreconciliation.html#PaymentReconciliation)）、人（[Person](https://hl7.org/fhir/R4/person.html#Person)）、健康照護服務提供者（[Practitioner](StructureDefinition-Practitioner-twcore.md)）、健康照護服務提供者角色（[PractitionerRole](StructureDefinition-PractitionerRole-twcore.md)）、處置（[Procedure](StructureDefinition-Procedure-twcore.md)）、出處（[Provenance](https://hl7.org/fhir/R4/provenance.html#Provenance)）、問卷題目回覆（[QuestionnaireResponse](https://hl7.org/fhir/R4/questionnaireresponse.html#QuestionnaireResponse)）、研究（[ResearchStudy](https://hl7.org/fhir/R4/researchstudy.html#ResearchStudy)）、服務請求（[ServiceRequest](https://hl7.org/fhir/R4/servicerequest.html#ServiceRequest)）、供應品供應品遞交（[SupplyDelivery](https://hl7.org/fhir/R4/supplydelivery.html#SupplyDelivery)）、供應品請求（[SupplyRequest](https://hl7.org/fhir/R4/supplyrequest.html#SupplyRequest)）、任務（[Task](https://hl7.org/fhir/R4/task.html#Task)）及驗證結果（[VerificationResult](https://hl7.org/fhir/R4/verificationresult.html#VerificationResult)）。

**Usages:**

* Derived from this Profile: [TW Core Organization Company](StructureDefinition-Organization-co-twcore.md), [TW Core Organization Government](StructureDefinition-Organization-govt-twcore.md) and [TW Core Organization Hospital Department](StructureDefinition-Organization-hosp-twcore.md)
* Refer to this Profile: [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md), [TW Core CareTeam](StructureDefinition-CareTeam-twcore.md), [TW Core Composition](StructureDefinition-Composition-twcore.md), [TW Core Coverage](StructureDefinition-Coverage-twcore.md)...Show 42 more,[TW Core Implantable Device](StructureDefinition-Device-twcore.md),[TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md),[TW Core DocumentReference](StructureDefinition-DocumentReference-twcore.md),[TW Core Encounter](StructureDefinition-Encounter-twcore.md),[TW Core Goal](StructureDefinition-Goal-twcore.md),[TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md),[TW Core Immunization](StructureDefinition-Immunization-twcore.md),[TW Core Location](StructureDefinition-Location-twcore.md),[TW Core Media](StructureDefinition-Media-twcore.md),[TW Core Medication](StructureDefinition-Medication-twcore.md),[TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md),[TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md),[TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md),[TW Core MessageHeader](StructureDefinition-MessageHeader-twcore.md),[TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md),[TW Core Observation BMI](StructureDefinition-Observation-bmi-twcore.md),[TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md),[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Care Experience Preference](StructureDefinition-Observation-careExperiencePreference-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Occupation](StructureDefinition-Observation-occupation-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Pregnancy Status](StructureDefinition-Observation-pregnancy-status-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Screening Assessment](StructureDefinition-Observation-screening-assessment-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md),[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md),[TW Core Organization](StructureDefinition-Organization-twcore.md),[TW Core Patient](StructureDefinition-Patient-twcore.md),[TW Core Practitioner](StructureDefinition-Practitioner-twcore.md),[TW Core PractitionerRole](StructureDefinition-PractitionerRole-twcore.md),[TW Core Procedure](StructureDefinition-Procedure-twcore.md),[TW Core Provenance](StructureDefinition-Provenance-twcore.md),[TW Core QuestionnaireResponse](StructureDefinition-QuestionnaireResponse-twcore.md)and[TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)
* Examples for this Profile: [衛生福利部桃園醫院](Organization-org-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Organization-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Organization-twcore.csv), [Excel](StructureDefinition-Organization-twcore.xlsx), [Schematron](StructureDefinition-Organization-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Organization-id.md)**查詢所有Organization：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Organization?_id=[id]`
`GET [base]/Organization/[id]`例子：
(1) GET [base]/Organization?_id=org-example
(2) GET [base]/Organization/org-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`identifier`](SearchParameter-Organization-identifier.md)**查詢所有Organization：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Organization?identifier={system|}[code]`例子：
(1) GET [base]/Organization?identifier=http://ns.electronichealth.net.au/id/hi/hpio/1.0|8003621566684455
1. **建議應該（SHOULD）**支援透過查詢參數**[`name`](SearchParameter-Organization-name.md)**查詢所有Organization：
([如何透過string查詢](http://hl7.org/fhir/R4/search.html#string))
`GET [base]/Organization?name=[name]`例子：
(1) GET [base]/Organization?name=Downunder Hospital
1. **建議應該（SHOULD）**支援透過查詢參數**[`type`](SearchParameter-Organization-type.md)**查詢所有Organization：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Organization?type={system|}[code]`例子：
(1) GET [base]/Organization?type=http://terminology.hl7.org/CodeSystem/organization-type|prov



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Organization-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreOrganization",
  "title" : "TW Core Organization",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "\n\n此臺灣核心-機構（TW Core Organization）Profile說明本IG如何進一步定義FHIR的Organization Resource以呈現機構基本資料。\n",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization",
        "short" : "具有共同目的的一群人或機構",
        "definition" : "為實現某種形式的集體行動而形成的正式或非正式認可的一群人或機構的團體。包括公司、機構、企業、部門、社群團體、健康照護實務團體、付款人／保險公司等。"
      },
      {
        "id" : "Organization.id",
        "path" : "Organization.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的Organization紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "Organization.meta",
        "path" : "Organization.meta",
        "short" : "此Organization Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "Organization.implicitRules",
        "path" : "Organization.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "Organization.language",
        "path" : "Organization.language",
        "short" : "用以表述Organization Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "Organization.text",
        "path" : "Organization.text",
        "short" : "Organization Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "short" : "跨多個系統中識別此機構",
        "definition" : "用於指明跨多個不同系統的機構識別碼",
        "requirements" : "Organizations通常有多種識別碼。有些機構保有數個，而大多數機構收集識別碼用於跟其他機構交流有關此機構的資訊。",
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier.id",
        "path" : "Organization.identifier.id",
        "short" : "唯一可識別ID，以供資料項目間相互參照。",
        "definition" : "resource中資料項目的唯一ID（用於內部參照）。這可以是任何不含空格的字串。"
      },
      {
        "id" : "Organization.identifier.extension",
        "path" : "Organization.identifier.extension",
        "short" : "擴充的資料項目",
        "definition" : "擴充的資料項目"
      },
      {
        "id" : "Organization.identifier.use",
        "path" : "Organization.identifier.use",
        "short" : "usual ｜ official ｜ temp ｜ secondary ｜ old （如果知道）",
        "definition" : "這個唯一識別碼（identifier）的用途",
        "comment" : "應用程式可以假定一個識別碼是永久的，除非它明確說它是暫時的。",
        "requirements" : "允許從一組識別碼中為特定的使用情境選擇適當的識別碼",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "IdentifierUse"
            }
          ],
          "strength" : "required",
          "description" : "如果已知，請說明此識別碼的目的；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use|4.0.1"
        }
      },
      {
        "id" : "Organization.identifier.type",
        "path" : "Organization.identifier.type",
        "short" : "機構識別碼（identifier）的型別說明",
        "definition" : "識別碼的代碼型別，用於決定特定目適用的識別碼。",
        "comment" : "這個資料項目只涉及識別碼的一般類別。它 **必須沒有（SHALL NOT）** 被用於與Identifier.system 1..1對應的代碼。一些識別碼可能由於常見的用法而屬於多個類別。在系統是已知的情況下，型別是不必要的，因為型別總是系統定義的一部分。然而，系統經常需要處理系統不為人知的識別碼。型別和系統之間不是1:1的關係，因為許多不同的系統有相同的型別。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "識別碼的型別，用於決定特定目的所適用的識別碼；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/identifier-type-tw"
        }
      },
      {
        "id" : "Organization.identifier.system",
        "path" : "Organization.identifier.system",
        "short" : "機構識別碼（identifier）的命名空間（namespace），可至[twTerminology](https://fhir.mohw.gov.tw/ts/namingsystem.jsp?status=active&amp;type=0)申請或查詢命名系統。",
        "definition" : "建立值的命名空間－即一個描述一組值的唯一URL",
        "comment" : "Identifier.system總是區分大小寫",
        "requirements" : "有許多識別碼的集合。為了進行兩個識別碼的對應，我們需要知道我們處理的是哪一組。系統指明了一個特定的唯一識別碼集。",
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier.value",
        "path" : "Organization.identifier.value",
        "short" : "唯一值",
        "definition" : "識別碼中通常與使用者有關的部分，在系統情境內是唯一的。",
        "comment" : "如果此值是一個完整的URI，那麼此系統 **必須（SHALL）** 是urn:ietf:rfc:3986。此值的主要目的是為了可運算的對應。因此，為了比較的目的，它可能會被正規化（例如：去除不重要的空白、破折號等）。一個為人顯示的格式化的值可以使用[Rendered Value](http://hl7.org/fhir/R4/extension-rendered-value.html)擴充來傳達。除非對Identifier.system的了解使處理者確信不區分大小寫的處理是安全的，否則Identifier.value應被視為區分大小寫。",
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier.period",
        "path" : "Organization.identifier.period",
        "short" : "此機構識別碼（identifier）的使用效期",
        "definition" : "識別碼有效／曾經有效使用的時段或期間"
      },
      {
        "id" : "Organization.identifier.assigner",
        "path" : "Organization.identifier.assigner",
        "short" : "簽發identifier的機構（可以只是文字表述）",
        "definition" : "簽發／管理識別碼的機構",
        "comment" : "Identifier.assigner可以省略.reference資料項目，只包含一個.display資料項目，反映指定機構的名稱或其他文字表述資訊。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Organization.active",
        "path" : "Organization.active",
        "short" : "此機構的紀錄是否仍在使用中",
        "definition" : "此機構的紀錄是否仍在使用中",
        "comment" : "這個Active標記不是用來標記機構暫時關閉或正在建設中。反而應該是Organization的地點（Location）應該具有暫停狀態。如果需要進一步詳細說明暫停的原因，那麼應該針對這個資料項目的提供一個擴充的資料項目。\n\n這個資料項目被標記為修飾語／修飾用，因為它可用來標記resource是錯誤建立的。",
        "requirements" : "需要一個標記表明此記錄不再被使用，一般來說應會在使用者界面中隱藏此資料項目。",
        "mustSupport" : true
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "short" : "機構的型別",
        "definition" : "機構的型別",
        "comment" : "機構可以是公司、病房、科室、臨床團隊、政府部門等。請注意，代碼通常是機構型別的分類；在許多應用程式中，若代碼是用來指明一個特定機構（例如：病房），而不是另一個相同型別的機構，那麼這些算是識別碼代碼，而不是型別代碼。\n\n當考慮多個型別是否合適時，你應該評估子機構是否是一個更合適的概念使用，因為不同的型別可能在不同子區域的機構。這最有可能用於型別值不相關（orthogonal values）的地方，像是一個宗教的、學術的和醫學中心。\n\n我們期望一些行政管轄區設計此資料項目為可選填且基數設定為1。",
        "requirements" : "需要能夠追踪這是哪種機構－不同機構型別有不同的用途。",
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "OrganizationType"
            }
          ],
          "strength" : "example",
          "description" : "用於分類機構；可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/organization-type"
        }
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "short" : "機構的名稱",
        "definition" : "與此機構相關名稱",
        "comment" : "如果一個機構改變名稱，可以考慮把舊的名稱放在別名（alias）資料項目中，這樣仍然可以透過查詢找到它。",
        "requirements" : "需要使用名稱作為機構的標籤",
        "mustSupport" : true
      },
      {
        "id" : "Organization.alias",
        "path" : "Organization.alias",
        "short" : "此機構目前或過去已知的其他（多個）名稱",
        "definition" : "此機構目前或過去已知的其他（多個）名稱",
        "comment" : "沒有與別名／歷史名稱相關的日期，因為這不是為了追踪使用名稱的時間，而是為了協助查詢，以便舊名稱仍然可以指明此機構。",
        "requirements" : "隨著時間的推移，地點和機構經歷了許多變化，可能會有不同的名稱。\n\n對於查詢而言，了解此機構以前的名稱是非常有用的。"
      },
      {
        "id" : "Organization.telecom",
        "path" : "Organization.telecom",
        "short" : "此機構的詳細聯絡方式。\norg-3：一個機構的通訊永遠不可能是「家用」，意即不可能使用「home」。",
        "definition" : "此機構的詳細聯絡方式",
        "comment" : "不能使用代碼 「home」。請注意，這些聯絡人不是指受僱於此機構或代表此機構的人的詳細聯絡方式，而是此機構本身的官方聯絡人。",
        "requirements" : "此機構的聯絡人",
        "mustSupport" : true
      },
      {
        "id" : "Organization.telecom.id",
        "path" : "Organization.telecom.id",
        "short" : "唯一可識別ID，以供資料項目間相互參照。",
        "definition" : "resource中資料項目的唯一ID（用於內部參照）。這可以是任何不含空格的字串。"
      },
      {
        "id" : "Organization.telecom.extension",
        "path" : "Organization.telecom.extension",
        "short" : "擴充的資料項目",
        "definition" : "可用於表示不屬於此資料項目基本定義的附加資訊。為了擴充的使用安全和可管理，對擴充的定義和使用有一套嚴格的管理。儘管任何實作者都可以定義一個擴充，但作為擴充定義的一部分，有一套要求 **必須（SHALL）** 滿足。"
      },
      {
        "id" : "Organization.telecom.system",
        "path" : "Organization.telecom.system",
        "definition" : "聯絡方式的通訊形式－需要什麼通訊系統進行聯絡",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ContactPointSystem"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/contact-point-system|4.0.1"
        }
      },
      {
        "id" : "Organization.telecom.value",
        "path" : "Organization.telecom.value",
        "short" : "實際的聯絡方式之細節",
        "definition" : "實際的聯絡方式之細節，針對指定的通訊系統提供有意義的形式（電話號碼或是電子郵件位址）。",
        "comment" : "額外的文字資料，例如電話分機號碼、或關於聯絡人的說明，有時也包括於此值。",
        "requirements" : "需支援非嚴格格式控制之舊有號碼",
        "mustSupport" : true
      },
      {
        "id" : "Organization.telecom.use",
        "path" : "Organization.telecom.use",
        "short" : "home | work | temp | old | mobile－此聯絡方式的用途",
        "definition" : "確定聯絡方式的用途",
        "comment" : "應用程式可以假定一個聯絡方法是目前使用中，除非它明確說它是暫時的或舊的。",
        "requirements" : "需要追蹤此人使用這種聯絡的方式，使用者可以選擇適合他們用途的聯絡方式。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ContactPointUse"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/contact-point-use|4.0.1"
        }
      },
      {
        "id" : "Organization.telecom.rank",
        "path" : "Organization.telecom.rank",
        "short" : "具體說明偏好的使用順序（1=最高優先順序）",
        "definition" : "具體說明使用一組聯繫方式的優先順序，較小排名序位的聯絡方式比較大排名序位的聯絡方式之序位還要前面。",
        "comment" : "請注意，排名序位沒有一定要遵循聯絡方式在實例中呈現的順序。"
      },
      {
        "id" : "Organization.telecom.period",
        "path" : "Organization.telecom.period",
        "short" : "此聯絡方式的使用效期",
        "definition" : "此聯絡方式的使用效期"
      },
      {
        "id" : "Organization.address",
        "path" : "Organization.address",
        "short" : "此機構的地址。\norg-2：一個機構的地址永遠不可能是「家用」，意即不可能使用「home」。",
        "definition" : "此機構的地址",
        "comment" : "機構可能有多個地址，有不同的用途或適用期。不使用代碼「home」。",
        "requirements" : "為了聯絡、計費或通報要求而可能需要追踪機構的地址",
        "type" : [
          {
            "code" : "Address",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Address-tw"
            ]
          }
        ]
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "short" : "此機構屬於哪個更高層次機構的一部分",
        "definition" : "此機構屬於哪個更高層次機構的一部分",
        "requirements" : "需要能夠追踪一個機構內的機構層次結構",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Organization.contact",
        "path" : "Organization.contact",
        "short" : "某一用途的機構聯絡方式",
        "definition" : "某一用途的機構聯絡方式",
        "comment" : "如果為同一個用途提供多個聯絡方式，則可有一個擴充的資料項目用以決定哪一個優先聯絡。",
        "requirements" : "需要在更大的機構內追踪用的指定聯絡方式"
      },
      {
        "id" : "Organization.contact.id",
        "path" : "Organization.contact.id",
        "short" : "唯一可識別ID，以供資料項目間相互參照。",
        "definition" : "resource中資料項目的唯一ID（用於內部參照）。這可以是任何不含空格的字串。"
      },
      {
        "id" : "Organization.contact.extension",
        "path" : "Organization.contact.extension",
        "short" : "擴充的資料項目",
        "definition" : "可用於表示不屬於此資料項目基本定義的附加資訊。為了擴充的使用安全和可管理，對擴充的定義和使用有一套嚴格的管理。儘管任何實作者都可以定義一個擴充，但作為擴充定義的一部分，有一套要求 **必須（SHALL）** 滿足。",
        "comment" : "無論使用或定義擴充的機構或管轄區，任何應用程式、專案或標準使用擴充都不背負任何污名（stigma）。使用擴充是允許FHIR規範為每個人保留一個核心的簡易性。"
      },
      {
        "id" : "Organization.contact.modifierExtension",
        "path" : "Organization.contact.modifierExtension",
        "short" : "此擴充的資料項目可能會完全修正或改變其他資料項目的意涵，需特別留意。",
        "definition" : "可以用來表示不屬於資料項目的基本定義的附加資訊，並且修改對它所內嵌（contained）的資料項目的理解和／或對包含資料項目之後續使用的理解。通常，修飾用的資料項目提供否定或限定。為了使擴充的使用安全和可管理，對擴充的定義和使用有一套嚴格的管理。儘管任何實作者都可以定義一個擴充，但作為擴充定義的一部分，有一組要求 **必須（SHALL）** 滿足。處理resource的應用程式被要求檢查修飾用的擴充資料項目。\n\n修飾用的擴充資料項目 **必須沒有（SHALL NOT）** 改變resource或DomainResource上任何資料項目的含義（包括不能改變modifierExtension本身的含義）。",
        "comment" : "無論使用或定義擴充的機構或管轄區，任何應用程式、專案或標準使用擴充都不背負任何污名（stigma）。使用擴充是允許FHIR規範為每個人保留一個核心的簡易性。",
        "requirements" : "修飾用的資料項目擴充將不能安全地忽略的擴充與絕大多數可以安全地忽略的擴充明確區分開來。透過消除禁止實作者擴充存在的需求來促進可互操作性。更多訊息，請參見修飾用的資料項目擴充之定義。"
      },
      {
        "id" : "Organization.contact.purpose",
        "path" : "Organization.contact.purpose",
        "short" : "聯絡的型別",
        "definition" : "表明可聯絡到此聯絡人的聯絡方式之用途",
        "requirements" : "需要對多個聯絡人進行區分",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ContactPartyType"
            }
          ],
          "strength" : "extensible",
          "description" : "你所聯絡之聯絡人的聯絡方式用途；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/contactentity-type"
        }
      },
      {
        "id" : "Organization.contact.name",
        "path" : "Organization.contact.name",
        "short" : "聯絡人名字",
        "definition" : "聯絡人名字",
        "requirements" : "需能透過名字來追綜此聯絡人"
      },
      {
        "id" : "Organization.contact.telecom",
        "path" : "Organization.contact.telecom",
        "short" : "聯絡人的詳細聯絡方式（例如：電話、電子郵件等）。",
        "definition" : "可與此人聯絡的詳細聯絡方式（如電話或電子郵件地址等）",
        "requirements" : "人們有（主要）方式與他們聯絡，如電話、電子郵件。"
      },
      {
        "id" : "Organization.contact.address",
        "path" : "Organization.contact.address",
        "short" : "聯絡人的到訪或郵政地址",
        "definition" : "可到訪及郵寄聯絡人的地址",
        "requirements" : "為了聯絡、計費或通報要求而可能需要追踪機構的地址",
        "type" : [
          {
            "code" : "Address",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Address-tw"
            ]
          }
        ]
      },
      {
        "id" : "Organization.endpoint",
        "path" : "Organization.endpoint",
        "short" : "存取此Organization的技術服務的終端（endpoints）",
        "definition" : "存取此Organization的技術服務的終端（endpoints）",
        "requirements" : "機構有多個提供各種服務的系統，需要能夠定義技術連接的細節，如何連接到這些系統，以及為了什麼目的。"
      }
    ]
  }
}

```
