# TW Core Observation Vital Signs - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Observation Vital Signs 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-vitalSigns-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreObservationVitalSigns |

 
此臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile說明本IG如何進一步定義FHIR的Vital Signs Profile以呈現生命體徵資料。 

## Resource Observation Vital Signs - 內容

生命徵象將會是最先需要一套統一且全球通用的術語體系的領域之一，目的是為了能夠隨時隨地存取和重用這些資料。這個需求在病人使用可穿戴設備時尤其突顯，因為他們希望或需要分享這些設備上的資訊。為了滿足這個需求，我們必須採用一套一致的術語和通用的語法，以實現資料意義能夠被不同系統理解和使用。FHIR 的生命徵象Profile為記錄、查詢和獲取與病人相關的生命徵象設定了基本標準，不僅包括主要的生命徵象，還有身高、體重和BMI等額外測量資料。在下面的快速開始部分定義了對 resource 進行基本強制性查詢的支援。當一個FHIR實作支援下面列出的任何生命徵象時，該實作 **必須（SHALL）** 遵循此 Profile 對生命徵象檢驗檢查的規定。

這些要求最初是在FHIR DSTU2版本中，作為美國ONC支援的資料存取框架（DAF）專案的一部分而開發、審議和發布的，並且隨後被更新，以定義存取由美國Argonaut專案試點實作所確定的病人資料所需要的最基本的遵循要求。

### 範圍及使用

**範例使用情境：**

以下是使用這個 Profile 的一些範例情境：

* 查詢特定病人的生命徵象

#### 必填資料項目及專門術語

以下資料項目是必須要有的，換句話說，這些資料 **必須（SHALL）** 被填入。我們用簡單明了的方式來解釋這些資料項目，同時也提供了適用於特定 Profile 的指引和有效的範例。需注意的是，許多範例的內容超出了最低的規格要求，連結到所提供的 Profile 定義，你將可看到關於 Profile 更正式的內容、描述、對應以及 JSON 和 XML 的 StructureDefinitions 。

**每一項檢驗檢查(Observation)必須包含：**

1. 狀態(status)
1. 「生命徵象」的類別代碼(category code)
1. 指出正在測量的內容的一個「特定值(magic value)」
* 選擇 LOINC 作為「特定值」，因為這與大多數國家一致，但它可以簡單地被視為一套固定的共通代碼來傳達基本的生命徵象。需要使用不同代碼系統的實作者仍可以相應地進行對應。

1. 病人
1. 測量的時間
1. 一個數值結果值和來自下表單位代碼 (Unit Code) 欄的標準 UCUM 單位。
* 注意：如果沒有數值結果，則必須提供原因。

### Profile 的正式內容

[生命徵象 Profile](http://hl7.org/fhir/R4/vitalsigns.html)提供了生命徵象的官方定義連結。

* 下表列出了一組基本的生命徵象概念，包括必需使用的代碼「特定值」，以及用來表示生命徵象檢驗檢查結果的UCUM單位代碼。當系統支援下表中任一生命徵象時，必須使用這些代碼來表示。如果有血壓的檢驗檢查結果，那麼必須包括收縮壓和舒張壓的數值，但如果缺少這些數值，則需要提供缺數據的原因。
* 下表的第一列提供了指向每個生命徵象個別 Profile 的正式定義的連結。
* 如果記錄更具體的代碼或需要使用另一個代碼系統，實作者必須同時支援下列的LOINC值和轉換後的代碼，例如：特定方法的LOINC代碼、SNOMED CT概念或是特定系統的本地代碼。
* 此外，實作者可以選擇除了這裡定義的標準代碼之外，還提供其他代碼。範例顯示了如何使用其他代碼作為轉換。
* 其他 Profile 可能會規定哪些生命徵象必須記錄，或作為「一組/組套檢驗(panel)」的一部分出現，或者可能擴充這個列表以包括更多的生命徵象。針對使用LOINC的實作者，下面的注意事項提供了選填的代碼。

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [一組生命徵象檢驗檢查（Vital Signs Panel）](http://hl7.org/fhir/R4/vitalspanel.html) | 85353-1 | 生命徵象、體重、身高、頭圍、氧飽和度和一組BMI檢驗 - 它代表了在此表中列出的一組生命徵象。需要注意的是，一組檢驗中的所有檢驗項目都是選填的，這種情況下的`Observation.valueQuantity`並未呈現在Observation，這意味者查詢一組檢驗可能會漏掉不屬於這一組檢驗的個別結果；而是會有一些相關連結（hasMember）參照生命徵象檢驗檢查（例如：呼吸率、心率、血壓等）。這個代碼取代了已被淘汰的代碼 8716-3 - 生命徵象，該代碼在 Argonaut 資訊查詢實作指引（Argonaut Data Query Implementation Guide）中被使用。 | - | [一組生命徵象檢驗檢查範例](http://hl7.org/fhir/R4/observation-example-vitals-panel.html) |
| [呼吸率（Respiratory Rate）](http://hl7.org/fhir/R4/resprate.html) | 9279-1 | 呼吸率 - /每分鐘 | - | [呼吸率範例](http://hl7.org/fhir/R4/observation-example-respiratory-rate.html) |
| [心率（Heart rate）](http://hl7.org/fhir/R4/heartrate.html) | 8867-4 | 心率 - 為了更完整地記錄這項生命徵象，**可能可以(MAY)** 選擇性地加入 8887-2 - 心率設備類型（device type）作為一個附加的檢驗檢查數據。 | /分鐘 | [心率範例（Heart Rate Example）](http://hl7.org/fhir/R4/observation-example-heart-rate.html) |
| [血氧飽和度（Oxygen saturation）](http://hl7.org/fhir/R4/oxygensat.html) | 2708-6 | 動脈血氧飽和度 - 此代碼用來取代了原有的代碼 59408-5，即透過脈搏血氧儀測量的動脈血中氧飽和度，59408-5 **可能可以（MAY）** 作為一個額外的檢驗檢查代碼被納入。 | % | [血氧飽和度範例](http://hl7.org/fhir/R4/observation-example-satO2.html) |
| [體溫（Body temperature）](http://hl7.org/fhir/R4/bodytemp.html) | 8310-5 | 體溫 - 為了進一步補充這項生命徵象的檢驗檢查資料，**可能可以（MAY）** 使用代碼 8327-9 來指明體溫的測量部位（如口腔、額頭、直腸等），並且代碼 8326-1 可以用來描述測量體溫的類型，這些都可以作為附加的檢驗檢查資料。 | 攝氏、[華氏] | [體溫範例](http://hl7.org/fhir/R4/observation-example-body-temperature.html) |
| [身高（Body height）](http://hl7.org/fhir/R4/bodyheight.html) | 8302-2 | 身高 - 為了進一步補充這項生命徵象的檢驗檢查，代碼 8306-3，即躺著時的身體高度（亦即身體長度，這一測量通常用於嬰兒），**可能可以（MAY）** 被作為一個附加的檢驗檢查代碼加入。 | cm, [in_i] | [身高範例](http://hl7.org/fhir/R4/observation-example-body-height.html) |
| [頭圍（Head circumference）](http://hl7.org/fhir/R4/headcircum.html) | 9843-4 | 頭圍-枕額週長（Head Occipital-frontal circumference） | cm, [in_i] | [頭圍範例](http://hl7.org/fhir/R4/observation-example-head-circumference.html) |
| [體重（Body weight）](http://hl7.org/fhir/R4/bodyweight.html) | 29463-7 | 體重 - 為了更全面地記錄這項生命徵象的檢驗檢查，代碼8352-7指的是測量時穿著的衣物，以及代碼 8361-8，指的是體重測量時身體相對於重力的位置（例如：站立、坐著、躺著等），**可能都可以（MAY）** 作為額外的檢驗檢查代碼加入。 | g, kg,[lb_av] | [Body Weight Example](http://hl7.org/fhir/R4/observation-example.html) |
| [身體質量指數（Body mass index）](StructureDefinition-Observation-bmi-twcore.md) | 39156-5 | 身體質量指數（Body mass index ，BMI）[比率（Ratio）] | kg/m2 | [BMI 範例](Observation-obs-bmi-example.md) |
| [收縮壓及舒張壓（Blood pressure systolic and diastolic）](StructureDefinition-Observation-bloodPressure-twcore.md) | 85354-9 | 一組血壓檢查包含所有可選的子項目 - 這是一個由多個部分組成的檢查。在`Observation.valueQuantity`中它不包含具體的值，但至少包括一個component，即收縮壓和/或舒張壓。為了進一步補充這項生命徵象檢驗檢查，可以使用以下額外的檢驗檢查項目：8478-0 - 表示平均血壓、8357-6 - 表示血壓測量方法、41904-4 - 表示血壓測量部位、8358-4 - 表示血壓計袖帶的大小、以及41901-0 - 表示使用的血壓計的類型，**可能都可以(MAY)** 作為額外的檢驗檢查代碼加入。 | - | [一組血壓檢查範例](Observation-obs-bloodPressure-example.md),[一組血壓檢查範例但缺少舒張壓的值](http://hl7.org/fhir/R4/observation-example-bloodpressure-dar.html) |
| [收縮壓（Systolic blood pressure）](StructureDefinition-Observation-bloodPressure-twcore.md) | 8480-6 | 用於收縮壓檢查的`Observation.component.code` | mm[Hg] | [一組血壓檢查範例](Observation-obs-bloodPressure-example.md) |
| [舒張壓（Diastolic blood pressure）](StructureDefinition-Observation-bloodPressure-twcore.md) | 8462-4 | 用於舒張檢查的`Observation.component.code` | mm[Hg] | [一組血壓檢查範例](Observation-obs-bloodPressure-example.md) |

**Usages:**

* Derived from this Profile: [TW Core Pediatric BMI for Age Observation](StructureDefinition-Observation-pediatric-bmi-age-twcore.md), [TW Core Observation Pediatric Head Occipital Frontal Circumference Percentile](StructureDefinition-Observation-pediatric-head-circumference-twcore.md), [TW Core Pediatric Weight for Height Observation](StructureDefinition-Observation-pediatric-weight-height-twcore.md) and [TW Core Observation Pulse Oximetry](StructureDefinition-Observation-pulse-oximetry-twcore.md)
* Refer to this Profile: [TW Core Condition](StructureDefinition-Condition-twcore.md), [TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md), [TW Core Observation Blood Pressure](StructureDefinition-Observation-bloodPressure-twcore.md), [TW Core Observation BMI](StructureDefinition-Observation-bmi-twcore.md)...Show 7 more,[TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md),[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md)and[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md)
* Examples for this Profile: [Observation/obs-vital](Observation-obs-vital.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Observation-vitalSigns-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Observation-vitalSigns-twcore.csv), [Excel](StructureDefinition-Observation-vitalSigns-twcore.xlsx), [Schematron](StructureDefinition-Observation-vitalSigns-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Observation-id.md)**查詢所有Observation：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?_id=[id]`
`GET [base]/Observation/[id]`例子：
(1) GET [base]/Observation?_id=obs-vital
(2) GET [base]/Observation/obs-vital
1. **建議應該（SHOULD）**支援透過查詢參數**[`category`](SearchParameter-Observation-category.md)**查詢所有Observation：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?category={system|}[code]`例子：
(1) GET [base]/Observation?category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs
1. **建議應該（SHOULD）**支援透過查詢參數**[`code`](SearchParameter-Observation-clinical-code.md)**查詢所有Observation：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?code={system|}[code]`例子：
(1) GET [base]/Observation?code=http://loinc.org|39156-5
1. **建議應該（SHOULD）**支援透過查詢參數**[`performer`](SearchParameter-Observation-performer.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Observation?performer={Type/}[id]`例子：
(1) GET [base]/Observation?performer=Practitioner/pra-dr-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`status`](SearchParameter-Observation-status.md)**查詢所有Observation：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?status=[code]`例子：
(1) GET [base]/Observation?status=registered
1. **建議應該（SHOULD）**支援透過查詢參數**[`subject`](SearchParameter-Observation-subject.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Observation?subject={Type/}[id]`例子：
(1) GET [base]/Observation?subject=Patient/pat-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`date`](SearchParameter-Observation-date.md)**查詢所有Observation：
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?date={gt|lt|ge|le}[date]`例子：
(1) GET [base]/Observation?date=gt2022-07-31

### Quick Start

以下是必要的查詢及讀取操作之說明。

**用戶端(Clients)**

用戶端已連接到伺服器，並透過使用下列指令按檢驗檢查類別查詢取得某位病人的所有生命徵象：

```
GET [base]/Observation?patient=[id]&category=vital-signs

```

用戶端已連接到伺服器，並透過使用下列指令按類別代碼和日期範圍查詢取得某位病人的所有生命徵象：

```
GET [base]/Observation?patient=[id]&category=vital-signs&date=[date]{&date=[date]}

```

用戶端已連接到伺服器，並透過使用下列指令按一個或多個上述列出的代碼查詢來取得某位病人的任何生命徵象：

```
GET [base]/Observation?patient=[id]&code[vital sign LOINC{,LOINC2,LOINC3,...}]

```

用戶端 **應該(SHOULD)** 能夠連接到伺服器，並透過使用下列指令按一個或多個上述列出的代碼和日期範圍查詢取得某位病人的任何生命徵象：

```
GET [base]/Observation?patient=[id]&code=[LOINC{,LOINC2...}]vital-signs&date=[date]{&date=[date]}

```

**伺服器端(Server)**

伺服器能夠使用下列指令返回它支援的某位病人的所有生命徵象：

```
GET [base]/Observation?patient=[id]&category=vital-signs

```

伺服器能夠使用下列指令按日期範圍查詢返回某位病人的所有生命徵象：

```
GET [base]/Observation?patient=[id]&category=vital-signs&date=[date]{&date=[date]}

```

伺服器能夠使用下列指令按一個或多個上述列出的代碼查詢返回某位病人的任何生命徵象：

```
GET [base]/Observation?patient=[id]&code[vital sign LOINC{,LOINC2,LOINC3,...}]

```

伺服器 **應該(SHOULD)** 能夠使用下列指令按一個或多個上述列出的代碼和日期範圍查詢返回某位病人的任何生命徵象：

```
GET [base]/Observation?patient=[id]&code=[LOINC{,LOINC2...}]vital-signs&date=[date]{&date=[date]}

```

伺服器確保每一次API請求都包括一個有效的授權令牌，通過以下方式提供：Authorization: Bearer {server-specific-token-here}。

伺服器透過返回HTTP 401 Unauthorized 回應代碼來拒絕任何未經授權的請求。

##### GET [base]/Observation?patient=[id]&category=vital-signs

**範例：** 查詢某位病人的所有生命徵象測量數據

[GET [base]/Observation?patient=1186747&category=vital-signs](http://hl7.org/fhir/R4/observation-vitalsigns.html#.html)

**支援：** 必須支援透過 category 代碼作查詢。

**實作注意事項：** 這種查詢是基於生命徵象的 category 代碼進行的，透過這個查詢方法，你可以取得一個包含所有category為「vital-signs」 的 Observation resource的集合，這些resources是針對指定病人的。要了解如何根據參照進行查詢，你可以參考[如何按參照查詢](http://hl7.org/fhir/R4/search.html#reference)，以及要了解如何根據令牌進行查詢，可以參考[如何按令牌查詢](http://hl7.org/fhir/R4/search.html#token)。表中列出的是最基本的生命徵象集合，但是也允許包括更多的生命徵象。

*回應類型：

* (Status 200)：成功的操作(successful operation)
* (Status 400): 無效的參數(invalid parameter)
* (Status 401/4xx): 末授權的請求(unauthorized request)
* (Status 403): 不適當的範圍(insufficient scope)

##### GET [base]/Observation?patient=[id]&code=[vital sign LOINC{,LOINC2,LOINC3,…}]

**範例：** 查詢某位病人的所有心率檢查：

[GET [base]/Observation?patient=1186747&code=8867-4](http://hl7.org/fhir/R4/observation-vitalsigns.html#.html)

**範別：** 查詢某位病人的所有心率、呼吸率及血壓檢查數據:

[GET [base]/Observation?patient=1186747&code=8867-4,9279-1,85354-9](http://hl7.org/fhir/R4/observation-vitalsigns.html#.html)

**支援：** 必須支援上述表格之生命徵象LOINC代碼查詢

實作注意事項:

(1) 透過基於生命徵象的LOINC代碼進行查詢，你可以取得一系列專門針對指定病人的、並且列在上述表中的特定生命徵象的 Observation resource 的集合。要了解如何透過參照進行查詢，你可以參考[如何按參照查詢](http://hl7.org/fhir/R4/search.html#reference)，以及要了解如何根據令牌進行查詢，可以參考[如何按令牌查詢](http://hl7.org/fhir/R4/search.html#token)。

(2) 「code」 參數專門用於查詢 `Observation.code`。舉例來說，當查詢血壓資料時，只有當查詢基於85354-9（代表收縮壓和舒張壓）時，相關resources才會被返回。如果使用`Observation.compodnet.code`如8480-6（代表收縮壓）或8462-4（代表舒張壓），則不會返回任何resources。如果你希望在一次查詢中同時查詢 `Observation.code` 和 `Observation.component.code`，應該使用 「combo-code」作為查詢參數。

*回應類型：

* (Status 200)：成功的操作(successful operation)
* (Status 400): 無效的參數(invalid parameter)
* (Status 401/4xx): 末授權的請求(unauthorized request)
* (Status 403): 不適當的範圍(insufficient scope)

##### GET [base]/Observation?patient=[id]&category=vital-signs&date=[date]{&date=[date]}

**範例：** 查找2015-01-14之後的所有血壓紀錄

[GET [base]/Observation?patient=555580&code=85354-9&date=ge2015-01-14](http://hl7.org/fhir/R4/observation-vitalsigns.html#.hml)

**支援：** 必須支援透過category 代碼及日期查詢

實作注意事項：基於生命徵象category代碼和日期進行查詢。這將取得一組所有擁有「vital-signs」cateogry、針對特定病人、並且在特定時間段內的 Observation resources的集合。要了解如何透過參照進行查詢，你可以參考[如何按參照查詢](http://hl7.org/fhir/R4/search.html#reference)，以及要了解如何根據令牌進行查詢，可以參考[如何按令牌查詢](http://hl7.org/fhir/R4/search.html#token)。

*回應類型：

* (Status 200)：成功的操作(successful operation)
* (Status 400): 無效的參數(invalid parameter)
* (Status 401/4xx): 末授權的請求(unauthorized request)
* (Status 403): 不適當的範圍(insufficient scope)



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Observation-vitalSigns-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-vitalSigns-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreObservationVitalSigns",
  "title" : "TW Core Observation Vital Signs",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile說明本IG如何進一步定義FHIR的Vital Signs Profile以呈現生命體徵資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/vitalsigns",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "檢驗檢查，測量及簡單的判定。",
        "definition" : "對病人、設備或其他對象進行的測量和簡單判定。"
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的Observation紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "Observation.meta",
        "path" : "Observation.meta",
        "short" : "此Observation Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "Observation.implicitRules",
        "path" : "Observation.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "Observation.language",
        "path" : "Observation.language",
        "short" : "用以表述Observation Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "Observation Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "Observation.identifier",
        "path" : "Observation.identifier",
        "short" : "檢驗檢查的識別碼，通常為業務目的所使用的識別碼，例如：檢驗序號或單號。",
        "definition" : "此檢驗檢查的唯一識別碼",
        "requirements" : "允許對檢驗檢查結果進行區分和參照"
      },
      {
        "id" : "Observation.basedOn",
        "path" : "Observation.basedOn",
        "short" : "依據的照護計畫／提議／醫令",
        "definition" : "依據的計劃、提議或醫令或其部分要求進行檢驗檢查。例如：一個MedicationRequest可能要求給病人藥之前要先進行實驗室檢查。",
        "requirements" : "允許授權追踪檢驗檢查事件並追踪提議／建議是否有落實",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore",
              "http://hl7.org/fhir/StructureDefinition/DeviceRequest",
              "http://hl7.org/fhir/StructureDefinition/ImmunizationRecommendation",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore",
              "http://hl7.org/fhir/StructureDefinition/NutritionOrder",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ServiceRequest-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.partOf",
        "path" : "Observation.partOf",
        "short" : "此檢驗檢查是哪個參照事件的一部分",
        "definition" : "此特定的檢驗檢查（Observation）是一個更大事件中的一個組成或步驟。例如：一項處置裡的一項檢驗檢查。",
        "comment" : "使用encounter將一個檢驗檢查（Observation）與一個就醫（Encounter）連結起來。關於參照另一個Observation的作法，請參閱下面的Notes小節。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/MedicationAdministration",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationDispense-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationStatement-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Immunization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "short" : "registered ｜ preliminary ｜ final ｜ amended +",
        "definition" : "結果值的狀態",
        "comment" : "這個資料項目被標記為修飾語／修飾用，因為附加到其他文件上的文件，其本身是不完整的文件。",
        "requirements" : "需要追踪單個結果狀態，有些結果在整個報告確定之前就已經確定了。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Status"
            }
          ],
          "strength" : "required",
          "description" : "檢驗檢查的狀態代碼；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-status|4.0.1"
        }
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "short" : "概念（concept）－參照一個專門術語或只是純文字。",
        "definition" : "可以正式參照一個專門術語或本體論來定義一個概念，或者也可以文字表述此概念。",
        "comment" : "並非所有的專門術語使用都符合這個一般模式。在某些情況下，資料模型不應該使用CodeableConcept而應直接使用Coding，並提供他們自己的結構來管理text、codings、translation、資料項目之間的關係、以及先組合配對／前組合式（pre-coordination）和後組合配對／後組合式（post-coordination）。",
        "requirements" : "用於篩選取得及顯示之檢驗檢查",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ObservationCategory"
            }
          ],
          "strength" : "preferred",
          "description" : "高層次的檢驗檢查分類；鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-category"
        }
      },
      {
        "id" : "Observation.category:VSCat",
        "path" : "Observation.category",
        "sliceName" : "VSCat",
        "short" : "檢驗檢查分類",
        "definition" : "可以正式參照一個專門術語或本體論來定義一個概念，或者也可以文字表述此概念。",
        "comment" : "並非所有的專門術語使用都符合這個一般模式。在某些情況下，資料模型不應該使用CodeableConcept而應直接使用Coding，並提供他們自己的結構來管理text、codings、translation、資料項目之間的關係、以及先組合配對／前組合式（pre-coordination）和後組合配對／後組合式（post-coordination）。",
        "requirements" : "用於篩選取得及顯示之檢驗檢查",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ObservationCategory"
            }
          ],
          "strength" : "preferred",
          "description" : "高層次的檢驗檢查分類；鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-category"
        }
      },
      {
        "id" : "Observation.category:VSCat.coding",
        "path" : "Observation.category.coding",
        "short" : "由專門術語系統（terminology system）定義的代碼",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼"
      },
      {
        "id" : "Observation.category:VSCat.coding.system",
        "path" : "Observation.category.coding.system",
        "short" : "專門術語系統（terminology system）的識別",
        "definition" : "定義代碼中符號意義的代碼系統識別。",
        "comment" : "URI可以是一個OID（urn:oid:...）或一個UUID（urn:uuid:...）；OID和UUID **必須（SHALL）** 參照HL7 OID註冊中心；否則，URI應該來自HL7的FHIR定義的特殊URI列表，或者它應該參照一些明確建立的系统定義。",
        "requirements" : "需要明確說明符號定義的來源"
      },
      {
        "id" : "Observation.category:VSCat.coding.version",
        "path" : "Observation.category.coding.version",
        "short" : "系統的版本—如果相關的話",
        "definition" : "選擇此代碼時使用的代碼系統版本；請注意，一個維護良好的代碼系統不需要版本報告，因為代碼的意義在不同系統版本中是一致的；然而，不能始終保證這點，當不能保證意義一致時， **必須（SHALL）** 將版本資訊也一併作交換。",
        "comment" : "如果專門術語沒有明確定義應該使用什麼字串來識別代碼系統的版本，建議使用版本正式發布的日期（用FHIR日期格式表示）作為版本日期。"
      },
      {
        "id" : "Observation.category:VSCat.coding.code",
        "path" : "Observation.category.coding.code",
        "short" : "系統定義的語法之符號",
        "definition" : "系統定義的語法之符號；符號可能是一個預先定義的代碼，也可能是代碼系統定義的語法中的表達式（如後組合配對／後組合式）。",
        "requirements" : "需要參照系統中的一個特定代碼"
      },
      {
        "id" : "Observation.category:VSCat.coding.display",
        "path" : "Observation.category.coding.display",
        "short" : "由系統定義的表示法",
        "definition" : "遵循系統的規則以呈現代碼含義的表示法",
        "requirements" : "需要能為不了解此系統的讀者呈現可讀的代碼含義"
      },
      {
        "id" : "Observation.category:VSCat.coding.userSelected",
        "path" : "Observation.category.coding.userSelected",
        "short" : "此編碼是否由使用者直接選擇？",
        "definition" : "表明此編碼是由使用者直接選擇，例如：從可用項目（代碼或顯示名稱）的清單中選擇。",
        "comment" : "在一系列備選方案中，直接選擇的代碼是新翻譯最合適的起點；關於「直接選擇」的確切意義，存在模糊不清之處，可能需要貿易夥伴的同意，以更完整澄清此資料項目的使用及其後果。",
        "requirements" : "已被確定為一個臨床安全準則—此確切的系統／代碼對(code pair)是被明確選擇的，而不是由系統根據一些規則或是程式語言處理判斷。"
      },
      {
        "id" : "Observation.category:VSCat.text",
        "path" : "Observation.category.text",
        "short" : "概念的文字表示法",
        "definition" : "輸入資料的使用者所見／所選／所說的人類可讀文字表述，和（或）其代表使用者的預期含義。",
        "comment" : "很多時候，此文字表述與其中一個代碼的顯示名稱相同。",
        "requirements" : "專門術語中的代碼並不總是能捕捉人類使用的細微差別的正確意義，或者根本就沒有合適的代碼；這些情況下，文字表述被用來捕捉來源的全部意義。"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "概念（concept）－參照一個專門術語或只是純文字。",
        "definition" : "可以透過正式參照一個專門術語或本體論來定義一個概念，或者也可以文字表述此概念。",
        "comment" : "並非所有的專門術語使用都符合這個一般模式。在某些情況下，資料模型不應該使用CodeableConcept而應直接使用Coding，並提供他們自己的結構來管理text、codings、translation、資料項目之間的關係、以及先組合配對／前組合式（pre-coordination）和後組合配對／後組合式（post-coordination）。",
        "requirements" : "知道正在進行的是哪種檢驗檢查是理解檢驗檢查的關鍵",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/vital-signs-tw"
        }
      },
      {
        "id" : "Observation.code.text",
        "path" : "Observation.code.text",
        "short" : "概念的文字表示法",
        "definition" : "輸入資料的使用者所見／所選／所說的人類可讀文字表述，和（或）其代表使用者的預期含義。",
        "comment" : "很多時候，此文字表述與其中一個代碼的顯示名稱相同。",
        "requirements" : "專門術語中的代碼並不總是能捕捉人類使用的細微差別的正確意義，或者根本就沒有合適的代碼；這些情況下，文字表述被用來捕捉來源的全部意義。",
        "mustSupport" : true
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "short" : "檢驗檢查有關的對象及（或）事物",
        "definition" : "此檢驗檢查是關於一位病人、一群病人、地點、或設備。如果檢驗檢查的實際焦點與對象（或其樣本、其部分或其區域）不同，則焦點資料項目或代碼本身會具體說明檢驗檢查的實際焦點。",
        "comment" : "人們期望這個資料項目的cardinality為1...1。唯一可能缺少對象的情況是當檢驗檢查是由一個不認識病人的設備進行的。在這種情況下，應透過一些情境／通道對應（context／channel matching）技術將檢驗檢查與病人對應，此時，應更新檢驗檢查資訊。",
        "requirements" : "如果你不知道他們是誰或關於什麼，檢驗檢查不會有值。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.focus",
        "path" : "Observation.focus",
        "short" : "當檢驗檢查並非有關於與病人本身，檢驗檢查是關於什麼。",
        "definition" : "檢驗檢查的實際焦點，當它不是記錄病人時，代表是與病人有關的事物或人，如配偶、父母、胎兒或捐贈者。例如：母親的記錄中有關胎兒檢驗檢查。檢驗檢查的焦點也可以是現有的狀況、疾病或問題（condition）、介入（intervention）、此對象的飲食、對此對象的另一項檢驗檢查，或身體結構像是腫瘤或植入裝置。有一個案例是使用Observation Resource來取得母親是否已接受更換她的小孩的氣管插管訓練之資訊，在這個例子中，孩子是此記錄的病人，而母親是focus。 ",
        "comment" : "通常檢驗檢查的對象是一位病人或一群病人、地點或設備，檢驗檢查對象與直接測量內容之間的區別在observation.code已具體說明（例如： 「血糖」），不需要使用這個資料項目（focus）單獨表示。如果需要參照檢體，則使用specimen，如果需要一個代碼而不是一個resource，則使用bodysite來表示bodysites或標準擴充focusCode。"
      },
      {
        "id" : "Observation.encounter",
        "path" : "Observation.encounter",
        "short" : "檢驗檢查是哪一次就醫時執行的",
        "definition" : "執行檢驗檢查的健康照護事件（例如：病人及健康照護提供人員的互動）",
        "comment" : "這通常指檢驗檢查發生於哪次就醫，但有些檢驗檢查可能是在就醫前或就醫後發生，但仍與就醫的情境有關（如入院前的實驗室檢驗檢查）。",
        "requirements" : "對於某些檢驗檢查來說，知道某個檢驗檢查和某個特定的就醫事件之間的連結可能很重要。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "short" : "檢驗檢查執行日期或時間區間",
        "definition" : "宣告檢驗檢查值的產出時間或時間區段是真的。對於生物學研究對象—例如病人—這通常被稱為「生理相關時間」。這通常是處置的時間或採樣的時間，但很多時候不知道日期或時間的來源，只知道日期或時間本身。",
        "comment" : "除非這是一份檢驗檢查的歷史報告，否則至少應該有一個日期。為了記錄不精確或「模煳」的時間（例如：測量「早餐後 」血糖），使用Timing datatype以允許測量能與常規生活事件連結。",
        "requirements" : "知道一項檢驗檢查何時被認為是真的，對其相關性和確定趨勢都很重要。",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "Observation.issued",
        "path" : "Observation.issued",
        "short" : "此版本檢驗檢查完成的日期或時間",
        "definition" : "此版本的檢驗檢查資訊可供健康照護提供人員取得的日期和時間，通常是在結果被審查與核實之後。",
        "comment" : "對於不需要審查和核實的檢驗檢查值，發佈日期時間可能與resource本身的最後更新日期時間相同。對於需要對某些更新進行審查和核實的檢驗檢查，若為非臨床上的重要更新則不需要對新版本進行再次審查和驗證，所以發佈日期時間可能與resource本身的最後更新日期時間不一樣。"
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "short" : "誰負責這項檢驗檢查",
        "definition" : "誰負責宣告檢驗檢查結果值為「真的」",
        "requirements" : "可以對此檢驗檢查有一定程度的信任，並指出後續問題的方向。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "short" : "檢驗檢查的實際結果",
        "definition" : "如果此資訊有一個簡單的值，則將其作為此項檢驗檢查的結果。",
        "comment" : "一項檢驗檢查可能有：1）單一值、2）一個值及一組相關或組成之檢驗檢查的多個值、或者3）只有一組相關或組成之檢驗檢查的多個值。如果有一個值，這個資料項目的datatype應該由Observation.code決定。如果這個資料項目是編碼或者如果與Observation.code相關的type定義一個編碼值，那麼將使用只有文字表述的CodeableConcept來代替字串。若需要更多的說明，請參閱下面Notes小節。",
        "requirements" : "通常一項檢驗檢查就會有一個值，雖然若它有錯誤或者它代表一組檢驗檢查可能不會有值。",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Quantity"
          },
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "string"
          },
          {
            "code" : "boolean"
          },
          {
            "code" : "integer"
          },
          {
            "code" : "Range"
          },
          {
            "code" : "Ratio"
          },
          {
            "code" : "SampledData"
          },
          {
            "code" : "time"
          },
          {
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "用於記錄生命體徵的常用UCUM單元；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/ucum-vitals-common"
        }
      },
      {
        "id" : "Observation.dataAbsentReason",
        "path" : "Observation.dataAbsentReason",
        "short" : "缺少檢驗檢查結果的原因",
        "definition" : "提供資料項目Observation.value[x]中的預期值缺少的原因",
        "comment" : "空值（Null）或例外值可以在FHIR Observations中以兩種方式表示，一種方法是簡單地將它們含括在值集中，並在值中表示例外。例如：血清檢測的測量值可以是「檢測到」、「未檢測到」、「不確定」或「檢測未完成」。\n\n另一種方法是使用資料項目value呈現實際檢驗檢查值，並使用資料項目dataAbsentReason來明確記錄例外值。例如：當測量沒有完成，可使用dataAbsentReason代碼「error」。請注意，只有在有值的情況下，才可以報告檢驗檢查。例如：只有在>0的情況下才可能報告細胞計數的差值。由於有這些選項，所以需要有使用案例協議（use-case agreements）來解釋一般檢驗檢查的例外值。",
        "requirements" : "對於許多結果，必須處理測量中的異常值。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ObservationValueAbsentReason"
            }
          ],
          "strength" : "extensible",
          "description" : "代碼具體說明檢驗檢查結果缺少的原因；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/data-absent-reason"
        }
      },
      {
        "id" : "Observation.interpretation",
        "path" : "Observation.interpretation",
        "short" : "高、低、正常等",
        "definition" : "對一項檢驗檢查值的分類評估，例如：高、低、正常。",
        "comment" : "歷史上用於實驗室結果【被稱為 「異常標記（abnormal flag）」】，它的使用延伸到其他與編碼解釋有關的使用情況中。通常報告為一個或多個簡單的緊密碼（compact code，一種可以解譯且具有最小平均字長的唯一資料代碼），這個資料項目經常被放置在報告和流程表的結果值的旁邊，以表示結果的意義或正常狀態。",
        "requirements" : "對於某些結果，特別是數值結果，需有一個解釋以便完全理解結果之意義。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ObservationInterpretation"
            }
          ],
          "strength" : "extensible",
          "description" : "代碼指明檢驗檢查結果的解釋；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-interpretation"
        }
      },
      {
        "id" : "Observation.note",
        "path" : "Observation.note",
        "short" : "關於此檢驗檢查之解說",
        "definition" : "關於檢驗檢查或結果的解說",
        "comment" : "可包括關於檢驗檢查的一般陳述，或關於重要的、非預期的或不可靠的結果值的陳述，或與資料項目interpretation有關的來源資訊。",
        "requirements" : "需能提供純文字表述的附加資訊"
      },
      {
        "id" : "Observation.bodySite",
        "path" : "Observation.bodySite",
        "short" : "接受檢驗檢查的身體部位。此為SNOMED CT代碼，若機構已有購買相關授權，亦可使用。",
        "definition" : "表示在檢驗檢查對象身上進行檢驗檢查的部位（即目標部位）",
        "comment" : "只有在Observation.code中的代碼未隱含時才會使用。在許多系統中，這可能被表示為一個相關的檢驗檢查，而不是一個行內的組成之檢驗檢查（inline component）。\n\n如果使用案例（use-case）要求將BodySite作為一個單獨的resource來處理（例如：單獨指明和追踪），那麼就使用標準的資料項目擴充方式來擴充bodySite。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "代碼說明解剖學位置，可能包含側邊；可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      },
      {
        "id" : "Observation.method",
        "path" : "Observation.method",
        "short" : "此檢驗檢查使用何種方法完成",
        "definition" : "指明用於執行檢驗檢查的機制",
        "comment" : "只有在Observation.code中的代碼未隱含此資料項目概念時才會使用。",
        "requirements" : "在某些情況下，方法會影響結果，因此用於確認結果是否可以比較或確認結果的顯著性（significance）。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "檢驗檢查的方法；可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-methods"
        }
      },
      {
        "id" : "Observation.specimen",
        "path" : "Observation.specimen",
        "short" : "此檢驗檢查的檢體",
        "definition" : "進行這項檢驗檢查時使用的檢體",
        "comment" : "只有在Observation.code中的代碼未隱含此資料項目概念時才會使用。\n檢驗檢查不是針對檢體本身進行，而是針對對象，但在很多情況下是透過檢體的方式進行檢驗檢查。請注意，雖然經常涉及到檢體，但並不總是明確地對其進行追踪和報告。還要注意的是Observation resources可在明確追踪檢體的情境下使用（例如：Diagnostic Report）。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.device",
        "path" : "Observation.device",
        "short" : "（測量）設備",
        "definition" : "用於產生檢驗檢查資料的設備",
        "comment" : "請注意，這不是用來表示結果傳輸的設備，例如：閘道器（gateway）等可在相關情況下使用 Provenance resource進行記錄。"
      },
      {
        "id" : "Observation.referenceRange",
        "path" : "Observation.referenceRange",
        "short" : "解釋結果值的指引。\nobs-3：必須至少有低、高或文字表述。",
        "definition" : "指導如何透過與正常或建議範圍值的比較來解釋此值。多個參考範圍值以「OR」解釋。換句話說，為了代表兩個不同的目標人群，將使用兩個referenceRange資料項目。",
        "comment" : "大多數檢驗檢查只有一個通用的參考範圍值。系統 **可能可以（MAY）** 選擇限制只提供病人的相關參考範圍值（例如：具體的病人年齡、性別、體重和其他因素），但這可能是不可能的或也不合適。只要提供了一個以上的參考範圍值，就 **建議應該（SHOULD）** 提供不同年齡的參考範圍值差異。",
        "requirements" : "知道什麼值被認為是「正常的」，可以幫助評估某一特定結果的意義。需要能夠為不同的情境提供多個參考範圍值。"
      },
      {
        "id" : "Observation.referenceRange.low",
        "path" : "Observation.referenceRange.low",
        "short" : "參考範圍值的下限值，如果相關。",
        "definition" : "參考範圍值的下限值。參考範圍值endpoint的下限值包含在此值中（例如：參考範圍值是>=5 - <=9）。如果省略下限值，則被認為是沒有意義的（例如：參考範圍值是<=2.3）。"
      },
      {
        "id" : "Observation.referenceRange.high",
        "path" : "Observation.referenceRange.high",
        "short" : "參考範圍值的上限值，如果相關。",
        "definition" : "參考範圍值的下限值。參考範圍值endpoint的下限值包含在此值中（例如：參考範圍值是>=5 - <=9）。如果省略下限值，則被認為是沒有意義的（例如：參考範圍值是<=2.3）。"
      },
      {
        "id" : "Observation.referenceRange.type",
        "path" : "Observation.referenceRange.type",
        "short" : "參考範圍值的限定詞",
        "definition" : "代碼表明適用的目標人群，例如：正常值或治療範圍值。",
        "comment" : "如果有一個以上的範圍值，此資料項目 **建議應該（SHOULD）** 填寫。如果這個資料項目不存在，則假定是正常範圍值。",
        "requirements" : "需要能夠說出這是什麼樣的參考範圍值：正常的、建議的、治療的等，以便正確解釋。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ObservationRangeMeaning"
            }
          ],
          "strength" : "preferred",
          "description" : "用以表述參考範圍值之含意的代碼；鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/referencerange-meaning"
        }
      },
      {
        "id" : "Observation.referenceRange.appliesTo",
        "path" : "Observation.referenceRange.appliesTo",
        "short" : "參考範圍值是用適用的對象或人口群",
        "definition" : "代碼表明此參考範圍值所適用的目標人群，例如：一個參考範圍值可能是一般人群或特定的性別或種族。多個適用對象需以「AND」解釋目標人群。例如：為了表示一個非裔美國人女性的目標人群，將同時使用女性的代碼和非裔美國人的代碼。",
        "comment" : "如果有一個以上的範圍值，此資料項目 **建議應該（SHOULD）** 填寫。如果這個資料項目不存在，則假定是正常範圍值。",
        "requirements" : "需要能夠指明目標人群以進行適當的解釋。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ObservationRangeType"
            }
          ],
          "strength" : "example",
          "description" : "用以指明參考範圍值適用的對象或人口群之代碼；可參考所綁定代碼表，但此代碼表只是針對這個欄位的一個可能值的示例，不預期也不鼓勵使用者一定要使用此代碼表的代碼代碼表中的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/referencerange-appliesto"
        }
      },
      {
        "id" : "Observation.referenceRange.age",
        "path" : "Observation.referenceRange.age",
        "short" : "適用的年齡範圍值，如果相關。",
        "definition" : "此參考範圍值適用的年齡，如果意思是說足月時的週數，這就是指新生兒年齡。",
        "requirements" : "有些分析隨著年齡的增長變化很大"
      },
      {
        "id" : "Observation.referenceRange.text",
        "path" : "Observation.referenceRange.text",
        "short" : "檢驗檢查中以文字表述的參考範圍值",
        "definition" : "檢驗檢查中以文字表述的參考範圍值，可在不適合以定量範圍值呈現某項檢驗檢查時使用。例如：「陰性 」的參照值或 「正常」的清單／列表。"
      },
      {
        "id" : "Observation.hasMember",
        "path" : "Observation.hasMember",
        "short" : "屬於此組檢驗檢查的相關Resource",
        "definition" : "這項檢驗檢查是一組檢驗檢查，例如：一個套組（battery）、一個檢驗套組（panel）或一組生命徵象測量，其組成的檢驗檢查為此資料項目的目標resource。",
        "comment" : "使用這個資料項目時，一項檢驗檢查通常會有一個值或者一組相關的resources，儘管在某些情況下兩者都可能存在。有關討論如何將Observations組合在一起的方法，請參閱下面的Notes小節。請注意，系統可能針對問卷調查的結果（ QuestionnaireResponse）計算成一個最終的分數，並將這個分數表示為一個Observation。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-vitalSigns-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/QuestionnaireResponse-twcore",
              "http://hl7.org/fhir/StructureDefinition/MolecularSequence"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom",
        "path" : "Observation.derivedFrom",
        "short" : "檢驗檢查源自哪些相關測量",
        "definition" : "目標resource為一種測量，此檢驗檢查就是從那個測量中得出。例如：陰離子間隙（an anion gap）或胎兒的測量值是從超音波影像計算而得。",
        "comment" : "在這個資料項目中列出可以代表臨床檢檢查和其他測量的所有參照選項，可能是衍生值的來源。最常見參照另一個Observation，關於Observations如何組合在一起的討論，請參閱下面的Notes小節。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Media-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/QuestionnaireResponse-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-vitalSigns-twcore",
              "http://hl7.org/fhir/StructureDefinition/MolecularSequence"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "short" : "組成之（部分）檢驗檢查的檢驗結果",
        "definition" : "有有些檢驗檢查有多個組成之檢驗檢查，這些組成之檢驗檢查被表達為具有相同屬性的獨立的代碼值對（code value pair）。例子包括血壓測量的收縮壓和舒張壓即為組成之檢驗檢查（component observations），以及遺傳學檢驗檢查的多個組成之檢驗檢查。",
        "comment" : "有關如何組合Observations的方法討論，請參閱下面的Notes小節。",
        "requirements" : "組成之檢驗檢查在Obsrvation resource中與主要檢驗檢查共享相同的屬性，並且總是被視為單個檢驗檢查的一部分（它們是不可分離的）。然而，主要檢驗檢查的參考範圍值並不被組成之檢驗檢查所繼承，在適當的時候需給予每項組成之檢驗檢查參考範圍值。"
      },
      {
        "id" : "Observation.component.code",
        "path" : "Observation.component.code",
        "short" : "組成之檢驗檢查的型別（代碼／型別）",
        "definition" : "描述所觀察到的情況，有時這被稱為檢驗檢查「代碼」。",
        "comment" : "所有的code-value和component.code-component.value都需要考慮到，以正確理解檢驗檢查的意義。",
        "requirements" : "知道正在進行的是哪種檢驗檢查是理解檢驗檢查的關鍵",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "代碼指明檢驗檢查的名稱；可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/vital-signs-tw"
        }
      },
      {
        "id" : "Observation.component.value[x]",
        "path" : "Observation.component.value[x]",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Quantity"
          },
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "string"
          },
          {
            "code" : "boolean"
          },
          {
            "code" : "integer"
          },
          {
            "code" : "Range"
          },
          {
            "code" : "Ratio"
          },
          {
            "code" : "SampledData"
          },
          {
            "code" : "time"
          },
          {
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "Observation.component.dataAbsentReason",
        "path" : "Observation.component.dataAbsentReason",
        "short" : "為什麼缺少組成之檢驗檢查結果",
        "definition" : "提供資料項目Observation.component.value[x]中的預期值缺少的原因",
        "comment" : "空值（Null）或例外值可以在FHIR Observations中以兩種方式表示，一種方法是簡單地將它們含括在值集中，並在值中表示例外。例如：血清檢測的測量值可以是「檢測到」、「未檢測到」、「不確定」或「檢測未完成」。\n\n另一種方法是使用資料項目value呈現實際檢驗檢查值，並使用資料項目dataAbsentReason來明確記錄例外值。例如：當測量沒有完成，可使用dataAbsentReason代碼「error」。請注意，只有在有值的情況下，才可以報告檢驗檢查。例如：只有在>0的情況下才可能報告細胞計數的差值。由於有這些選項，所以需要有使用案例協議（use-case agreements）來解釋一般檢驗檢查的例外值。",
        "requirements" : "對於許多結果，必須處理測量中的異常值。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ObservationValueAbsentReason"
            }
          ],
          "strength" : "extensible",
          "description" : "代碼指明為什麼結果（Observation.value[x]）缺少；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/data-absent-reason"
        }
      },
      {
        "id" : "Observation.component.interpretation",
        "path" : "Observation.component.interpretation",
        "short" : "高、低、正常等。",
        "definition" : "對一項檢驗檢查值的分類評估，例如：高、低、正常。",
        "comment" : "歷史上用於實驗室結果【被稱為 「異常標記（abnormal flag）」】，它的使用延伸到其他與編碼解釋有關的使用情況中。通常報告為一個或多個簡單的緊密碼（compact code，一種可以解譯且具有最小平均字長的唯一資料代碼），這個資料項目經常被放置在報告和流程表的結果值的旁邊，以表示結果的意義或正常狀態。",
        "requirements" : "對於某些結果，特別是數值結果，需有一個解釋以便完全理解結果之意義。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ObservationInterpretation"
            }
          ],
          "strength" : "extensible",
          "description" : "用以指明檢驗檢查的解釋之代碼。應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-interpretation"
        }
      },
      {
        "id" : "Observation.component.referenceRange",
        "path" : "Observation.component.referenceRange",
        "short" : "解釋此組成之檢驗驗查的結果值之指引",
        "definition" : "關於如何透過與正常值或建議範圍值的比較來解釋此值",
        "comment" : "大多數檢驗檢查只有一個通用的參考範圍值。系統 **可能可以（MAY）** 選擇限制只提供病人的相關參考範圍值（例如：具體的病人年齡、性別、體重和其他因素），但這可能是不可能的或也不合適。只要提供了一個以上的參考範圍值，就 **建議應該（SHOULD）** 提供不同年齡的參考範圍值差異。",
        "requirements" : "知道什麼值被認為是「正常的」，可以幫助評估某一特定結果的意義。需要能夠為不同的情境提供多個參考範圍值。"
      }
    ]
  }
}

```
