# TW Core Observation Pulse Oximetry - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Observation Pulse Oximetry 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pulse-oximetry-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreObservationPulseOximetry |

 
此臺灣核心-脈搏血氧飽和度（TW Core Observation Pulse Oximetry）Profile 說明本 IG 如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile 以呈現脈搏血氧飽和度資料。 

**Usages:**

* Examples for this Profile: [Observation/obs-pulse-oximetry-example](Observation-obs-pulse-oximetry-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Observation-pulse-oximetry-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Observation-pulse-oximetry-twcore.csv), [Excel](StructureDefinition-Observation-pulse-oximetry-twcore.xlsx), [Schematron](StructureDefinition-Observation-pulse-oximetry-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**及**[`category`](SearchParameter-Observation-category.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs
1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**及**[`code`](SearchParameter-Observation-clinical-code.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&code=http://loinc.org|59408-5,http://loinc.org|2708-6
1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`date`](SearchParameter-Observation-date.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&date=ge2020-01-01T00:00:00Z

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`status`](SearchParameter-Observation-status.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory&status={system|}[code]{,{system|}[code],...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&status=final
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`_lastUpdated`](SearchParameter-Observation-lastupdated.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&category={system|}[code]&_lastUpdated={gt|lt|ge|le}[date]{&_lastUpdated={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&_lastUpdated=ge2024-01-01T00:00:00Z
1. 支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`code`](SearchParameter-Observation-clinical-code.md)**及**[`date`](SearchParameter-Observation-date.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&code=http://loinc.org|59408-5,http://loinc.org|2708-6&date=ge2020-01-01T00:00:00Z



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Observation-pulse-oximetry-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pulse-oximetry-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreObservationPulseOximetry",
  "title" : "TW Core Observation Pulse Oximetry",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-脈搏血氧飽和度（TW Core Observation Pulse Oximetry）Profile 說明本 IG 如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile 以呈現脈搏血氧飽和度資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-vitalSigns-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "核心脈搏血氧飽和度樣板",
        "definition" : "此 FHIR 生命體徵樣板為觀察資源記錄、搜尋和取得與病患相關的生命徵象設定了最低期望值。"
      },
      {
        "id" : "Observation.modifierExtension",
        "path" : "Observation.modifierExtension",
        "short" : "不可忽略的擴充"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "脈搏血氧飽和度"
      },
      {
        "id" : "Observation.code.coding",
        "path" : "Observation.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "由術語系統定義的代碼",
        "min" : 2,
        "type" : [
          {
            "code" : "Coding",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Coding-tw"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding:PulseOx",
        "path" : "Observation.code.coding",
        "sliceName" : "PulseOx",
        "short" : "以脈搏血氧儀測得的動脈血氧飽和度",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://loinc.org",
          "code" : "59408-5"
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding:PulseOx.system",
        "path" : "Observation.code.coding.system",
        "short" : "術語系統的識別"
      },
      {
        "id" : "Observation.code.coding:PulseOx.code",
        "path" : "Observation.code.coding.code",
        "short" : "系統定義的語法符號"
      },
      {
        "id" : "Observation.code.coding:OxygenSatCode",
        "path" : "Observation.code.coding",
        "sliceName" : "OxygenSatCode",
        "short" : "動脈血氧飽和度",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://loinc.org",
          "code" : "2708-6"
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding:OxygenSatCode.system",
        "path" : "Observation.code.coding.system",
        "short" : "術語系統的識別"
      },
      {
        "id" : "Observation.code.coding:OxygenSatCode.code",
        "path" : "Observation.code.coding.code",
        "short" : "系統定義的語法符號"
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.value[x]:valueQuantity",
        "path" : "Observation.value[x]",
        "sliceName" : "valueQuantity",
        "short" : "血氧飽和度數值",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Quantity"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x]:valueQuantity.value",
        "path" : "Observation.value[x].value",
        "short" : "數值（含隱含精確度）",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x]:valueQuantity.unit",
        "path" : "Observation.value[x].unit",
        "short" : "單位顯示",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x]:valueQuantity.system",
        "path" : "Observation.value[x].system",
        "short" : "單位系統",
        "min" : 1,
        "fixedUri" : "http://unitsofmeasure.org",
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x]:valueQuantity.code",
        "path" : "Observation.value[x].code",
        "short" : "單位代碼",
        "min" : 1,
        "fixedCode" : "%",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "code"
            }
          ],
          "rules" : "open"
        },
        "short" : "用於報告流量率或氧氣濃度的組件。",
        "definition" : "用於報告流量率或氧氣濃度的組件。"
      },
      {
        "id" : "Observation.component.modifierExtension",
        "path" : "Observation.component.modifierExtension",
        "short" : "即使無法識別也不可忽略的擴充"
      },
      {
        "id" : "Observation.component.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "以 UCUM 記錄的生命體徵值"
      },
      {
        "id" : "Observation.component:FlowRate",
        "path" : "Observation.component",
        "sliceName" : "FlowRate",
        "short" : "吸入氧氣流量率",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:FlowRate.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "3151-8"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:FlowRate.code.coding",
        "path" : "Observation.component.code.coding",
        "short" : "由術語系統定義的代碼"
      },
      {
        "id" : "Observation.component:FlowRate.code.coding.system",
        "path" : "Observation.component.code.coding.system",
        "short" : "術語系統的識別"
      },
      {
        "id" : "Observation.component:FlowRate.code.coding.code",
        "path" : "Observation.component.code.coding.code",
        "short" : "系統定義的語法符號"
      },
      {
        "id" : "Observation.component:FlowRate.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:FlowRate.value[x]:valueQuantity",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueQuantity",
        "short" : "生命體徵組件數值",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Quantity"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:FlowRate.value[x]:valueQuantity.value",
        "path" : "Observation.component.value[x].value",
        "short" : "數值（含隱含精確度）",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:FlowRate.value[x]:valueQuantity.unit",
        "path" : "Observation.component.value[x].unit",
        "short" : "單位顯示",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:FlowRate.value[x]:valueQuantity.system",
        "path" : "Observation.component.value[x].system",
        "short" : "定義單位代碼的系統",
        "min" : 1,
        "fixedUri" : "http://unitsofmeasure.org",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:FlowRate.value[x]:valueQuantity.code",
        "path" : "Observation.component.value[x].code",
        "short" : "單位代碼",
        "min" : 1,
        "fixedCode" : "L/min",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Concentration",
        "path" : "Observation.component",
        "sliceName" : "Concentration",
        "short" : "吸入氧氣濃度",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Concentration.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "3150-0"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:Concentration.code.coding",
        "path" : "Observation.component.code.coding",
        "short" : "由術語系統定義的代碼"
      },
      {
        "id" : "Observation.component:Concentration.code.coding.system",
        "path" : "Observation.component.code.coding.system",
        "short" : "術語系統的識別"
      },
      {
        "id" : "Observation.component:Concentration.code.coding.code",
        "path" : "Observation.component.code.coding.code",
        "short" : "系統定義的語法符號"
      },
      {
        "id" : "Observation.component:Concentration.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:Concentration.value[x]:valueQuantity",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueQuantity",
        "short" : "生命體徵組件數值",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Quantity"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Concentration.value[x]:valueQuantity.value",
        "path" : "Observation.component.value[x].value",
        "short" : "數值（含隱含精確度）",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Concentration.value[x]:valueQuantity.unit",
        "path" : "Observation.component.value[x].unit",
        "short" : "單位顯示",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Concentration.value[x]:valueQuantity.system",
        "path" : "Observation.component.value[x].system",
        "short" : "定義單位代碼的系統",
        "min" : 1,
        "fixedUri" : "http://unitsofmeasure.org",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Concentration.value[x]:valueQuantity.code",
        "path" : "Observation.component.value[x].code",
        "short" : "單位代碼",
        "min" : 1,
        "fixedCode" : "%",
        "mustSupport" : true
      }
    ]
  }
}

```
