# TW Core Observation Care Experience Preference - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Observation Care Experience Preference 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-careExperiencePreference-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreObservationCareExperiencePreference |

 
此臺灣核心-病人照護偏好註記（TW Core Observation Care Experience Preference）Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現照護經驗偏好資料。
(可填寫文字或代碼等說明) 

**Usages:**

* Examples for this Profile: [Observation/obs-careExp-example](Observation-obs-careExp-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Observation-careExperiencePreference-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Observation-careExperiencePreference-twcore.csv), [Excel](StructureDefinition-Observation-careExperiencePreference-twcore.xlsx), [Schematron](StructureDefinition-Observation-careExperiencePreference-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**及**[`category`](SearchParameter-Observation-category.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&category=care-experience-preference`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=care-experience-preference
1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**及**[`code`](SearchParameter-Observation-clinical-code.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&code=http://loinc.org|95541-9
1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`date`](SearchParameter-Observation-date.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&category=care-experience-preference&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=care-experience-preference&date=ge2020-01-01T00:00:00Z

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`status`](SearchParameter-Observation-status.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&category=care-experience-preference&status={system|}[code]{,{system|}[code],...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=care-experience-preference&status=final
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`_lastUpdated`](SearchParameter-Observation-lastupdated.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&category={system|}[code]&_lastUpdated={gt|lt|ge|le}[date]{&_lastUpdated={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=care-experience-preference&_lastUpdated=ge2024-01-01T00:00:00Z
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`code`](SearchParameter-Observation-clinical-code.md)**及**[`date`](SearchParameter-Observation-date.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&code=http://loinc.org|95541-9&date=ge2020-01-01T00:00:00Z



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Observation-careExperiencePreference-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-careExperiencePreference-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreObservationCareExperiencePreference",
  "title" : "TW Core Observation Care Experience Preference",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-病人照護偏好註記（TW Core Observation Care Experience Preference）Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現照護經驗偏好資料。  \n(可填寫文字或代碼等說明)",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "測量與簡單陳述",
        "definition" : "關於病人、裝置或其他主體的測量與簡單陳述。",
        "comment" : "用於簡單觀察，例如裝置測量、實驗室原子結果、生命徵象、身高、體重、吸菸狀態、備註等。其他資源則用於提供觀察的上下文，例如實驗室報告等。"
      },
      {
        "id" : "Observation.implicitRules",
        "path" : "Observation.implicitRules",
        "short" : "建立本內容所依據的一組規則",
        "definition" : "指向建構本 resource 時所遵循規則的參照，處理內容時必須理解這些規則。通常是參照定義特殊規則的實作指南（Implementation Guide），以及其他 profiles 等。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解，這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，尚未準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應避免使用此欄位。"
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "definition" : "此欄位表示照護偏好觀察結果的狀態。",
        "comment" : "此元素被標記為修飾性（modifier），因為 status 可能包含標示資源目前無效的代碼。",
        "mustSupport" : true
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "coding.code"
            },
            {
              "type" : "value",
              "path" : "coding.system"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "觀察類型的分類",
        "definition" : "用於分類所進行觀察的一般類型的代碼。",
        "comment" : "除了必要的 category 值集外，此元素也允許根據擁有者自訂的分類方案進行多元分類，且可同時使用多個分類。分類的細緻程度由值集中的 category 概念所決定。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.category:twcore",
        "path" : "Observation.category",
        "sliceName" : "twcore",
        "short" : "照護偏好類型的分類",
        "definition" : "用於分類照護偏好觀察的類型代碼。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.category:twcore.coding",
        "path" : "Observation.category.coding",
        "short" : "由術語系統所定義的代碼",
        "definition" : "參照由術語系統定義的代碼。",
        "min" : 1
      },
      {
        "id" : "Observation.category:twcore.coding.system",
        "path" : "Observation.category.coding.system",
        "short" : "術語系統的識別碼",
        "definition" : "定義代碼符號意義的代碼系統之識別。",
        "min" : 1,
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/category-code-tw"
      },
      {
        "id" : "Observation.category:twcore.coding.code",
        "path" : "Observation.category.coding.code",
        "short" : "照護偏好的代碼符號",
        "definition" : "由系統定義的語法符號，代表照護偏好的類型。",
        "min" : 1,
        "patternCode" : "care-experience-preference"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "照護偏好代碼",
        "definition" : "描述所觀察到的照護偏好內容。此處使用 LOINC 代碼表示病人的照護偏好。",
        "comment" : "所有的 code-value 配對需要被考慮，才能正確理解照護偏好觀察的意義。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "95541-9"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding",
        "path" : "Observation.code.coding",
        "short" : "由術語系統所定義的代碼",
        "definition" : "參照由術語系統定義的代碼。"
      },
      {
        "id" : "Observation.code.coding.system",
        "path" : "Observation.code.coding.system",
        "short" : "術語系統的識別碼",
        "definition" : "定義代碼符號意義的代碼系統之識別。"
      },
      {
        "id" : "Observation.code.coding.code",
        "path" : "Observation.code.coding.code",
        "short" : "照護偏好的代碼符號",
        "definition" : "由系統定義的語法符號，代表照護偏好的類型。"
      },
      {
        "id" : "Observation.code.text",
        "path" : "Observation.code.text",
        "mustSupport" : true
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "short" : "此照護偏好觀察所關於的病人",
        "definition" : "此照護偏好觀察所關於且將觀察記錄存入其病歷的病人。",
        "comment" : "照護偏好觀察通常關聯到特定病人，用於記錄其治療和照護方式的偏好。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.encounter",
        "path" : "Observation.encounter",
        "short" : "進行此照護偏好觀察時的醫療事件",
        "definition" : "此照護偏好觀察所發生的醫療事件（例如病人與醫療提供者的會談）。",
        "comment" : "這通常是記錄照護偏好時的就診（encounter），可能是諮詢、收案或評估的場合。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "short" : "照護偏好觀察在臨床上的相關時間/時間區間",
        "definition" : "照護偏好被紀錄或被視為有效的時間或時間區間。",
        "comment" : "照護偏好的記錄時間非常重要，因為病人的偏好可能隨時間而變化。",
        "min" : 1,
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          },
          {
            "code" : "Timing"
          },
          {
            "code" : "instant"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "short" : "記錄照護偏好的負責人",
        "definition" : "負責記錄或確認照護偏好觀察為「真實」的人員。",
        "comment" : "通常是醫護人員、社工或病人本人記錄照護偏好。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "short" : "照護偏好的實際內容",
        "definition" : "照護偏好觀察的實際內容，可能是文字描述或代碼化的偏好記錄。",
        "comment" : "照護偏好可以多種形式表達，包括自由文字陳述或使用預定義的偏好選項代碼。",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "string"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "CodeableConcept"
          },
          {
            "code" : "integer"
          },
          {
            "code" : "Range"
          },
          {
            "code" : "Ratio"
          },
          {
            "code" : "SampledData"
          },
          {
            "code" : "time"
          },
          {
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.specimen",
        "path" : "Observation.specimen",
        "short" : "用於此觀察的標本",
        "definition" : "進行此觀察時所使用的標本。",
        "comment" : "照護偏好觀察通常不涉及標本，但此欄位保留以維持與 Observation 資源的一致性。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component.code",
        "path" : "Observation.component.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ]
      }
    ]
  }
}

```
