# TW Core Observation Body Temperature - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Observation Body Temperature 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-body-temperature-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreObservationBodyTemperature |

 
此臺灣核心-體溫 (TW Core Observation Body Temperature) Profile 說明本 IG 如何進一步定義臺灣核心-生命體徵 (TW Core Observation Vital Signs) Profile 以呈現體溫資料。 

**Usages:**

* Examples for this Profile: [Observation/obs-temperature-example](Observation-obs-temperature-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Observation-body-temperature-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Observation-body-temperature-twcore.csv), [Excel](StructureDefinition-Observation-body-temperature-twcore.xlsx), [Schematron](StructureDefinition-Observation-body-temperature-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**及**[`category`](SearchParameter-Observation-category.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs
1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**及**[`code`](SearchParameter-Observation-clinical-code.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&code=http://loinc.org|8310-5
1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`date`](SearchParameter-Observation-date.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&date=ge2020-01-01T00:00:00Z

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`status`](SearchParameter-Observation-status.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory&status={system|}[code]{,{system|}[code],...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&status=final
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`_lastUpdated`](SearchParameter-Observation-lastupdated.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&category={system|}[code]&_lastUpdated={gt|lt|ge|le}[date]{&_lastUpdated={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&_lastUpdated=ge2024-01-01T00:00:00Z
1. 支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`code`](SearchParameter-Observation-clinical-code.md)**及**[`date`](SearchParameter-Observation-date.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&code=http://loinc.org|8310-5&date=ge2020-01-01T00:00:00Z



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Observation-body-temperature-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-body-temperature-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreObservationBodyTemperature",
  "title" : "TW Core Observation Body Temperature",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-體溫 (TW Core Observation Body Temperature) Profile 說明本 IG 如何進一步定義臺灣核心-生命體徵 (TW Core Observation Vital Signs) Profile 以呈現體溫資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/bodytemp",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "體溫測量結果",
        "definition" : "測量身體產生的熱量。"
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "short" : "不重複的 ID 用以識別儲存在特定 FHIR Server 中的 Observation 紀錄，通常又稱為邏輯性 ID。",
        "definition" : "resource 的邏輯 ID，在 resource 的 URL 中使用。一旦指定，這個值永遠不會改變。"
      },
      {
        "id" : "Observation.implicitRules",
        "path" : "Observation.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建 resource 時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對 IG 所定義之特殊規則及其他 profiles 的參照。"
      },
      {
        "id" : "Observation.modifierExtension",
        "path" : "Observation.modifierExtension",
        "short" : "能修改所包含資料項目解釋的擴充資料項目",
        "definition" : "可用於表示不屬於此資源基本定義的額外資訊，且會修改對資源的解釋。此類擴充資料項目的使用需特別謹慎。"
      },
      {
        "id" : "Observation.basedOn",
        "path" : "Observation.basedOn",
        "short" : "履行或延伸的資源",
        "definition" : "此觀察結果所履行的計畫、目標或要求。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore",
              "http://hl7.org/fhir/StructureDefinition/DeviceRequest",
              "http://hl7.org/fhir/StructureDefinition/ImmunizationRecommendation",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore",
              "http://hl7.org/fhir/StructureDefinition/NutritionOrder",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ServiceRequest-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.partOf",
        "path" : "Observation.partOf",
        "short" : "作為父資源的一部分",
        "definition" : "記錄此觀察結果的事件的參照。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/MedicationAdministration",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationDispense-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationStatement-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Immunization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "definition" : "Observation 的狀態。"
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "short" : "Observation 的分類",
        "definition" : "用於將 Observation 分組的分類。"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "體溫 (Body Temperature)",
        "definition" : "描述被觀察的內容。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ]
      },
      {
        "id" : "Observation.code.coding",
        "path" : "Observation.code.coding",
        "short" : "用於識別觀察結果的編碼",
        "definition" : "用於識別觀察結果的編碼表示。",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "short" : "此 Observation 的對象",
        "definition" : "此 Observation 是關於哪個病患/群體。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.encounter",
        "path" : "Observation.encounter",
        "short" : "與此 Observation 相關的就醫事件",
        "definition" : "產生此 Observation 的就醫事件。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "short" : "測量體溫的時間",
        "definition" : "進行觀察的臨床相關時間點或時間段。"
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "short" : "執行此 Observation 的人員或組織",
        "definition" : "誰負責此觀察結果。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]:valueQuantity",
        "path" : "Observation.value[x]",
        "sliceName" : "valueQuantity",
        "short" : "體溫測量值",
        "definition" : "觀察的實際結果。",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Observation.value[x]:valueQuantity.value",
        "path" : "Observation.value[x].value",
        "short" : "觀察結果的數值",
        "definition" : "觀察結果的數值。"
      },
      {
        "id" : "Observation.value[x]:valueQuantity.unit",
        "path" : "Observation.value[x].unit",
        "short" : "觀察結果的單位",
        "definition" : "觀察結果的單位。"
      },
      {
        "id" : "Observation.value[x]:valueQuantity.system",
        "path" : "Observation.value[x].system",
        "short" : "定義單位的系統",
        "definition" : "定義單位的系統 URI。"
      },
      {
        "id" : "Observation.value[x]:valueQuantity.code",
        "path" : "Observation.value[x].code",
        "short" : "單位的編碼表示",
        "definition" : "單位的編碼表示。"
      },
      {
        "id" : "Observation.specimen",
        "path" : "Observation.specimen",
        "short" : "與此 Observation 相關的檢體",
        "definition" : "分析此觀察結果的檢體。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.hasMember",
        "path" : "Observation.hasMember",
        "short" : "此 Observation 包含的成員 Observation",
        "definition" : "此觀察是群組觀察的一部分，並包含對成員觀察的參照。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-vitalSigns-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/QuestionnaireResponse-twcore",
              "http://hl7.org/fhir/StructureDefinition/MolecularSequence"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom",
        "path" : "Observation.derivedFrom",
        "short" : "此 Observation 衍生自的資源",
        "definition" : "此觀察結果衍生自的資源。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Media-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/QuestionnaireResponse-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-vitalSigns-twcore",
              "http://hl7.org/fhir/StructureDefinition/MolecularSequence"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "short" : "Observation 的組成部分",
        "definition" : "一些觀察結果由相關的觀察結果組成，這些觀察結果作為此觀察結果的組成部分進行測量和報告。"
      },
      {
        "id" : "Observation.component.code",
        "path" : "Observation.component.code",
        "short" : "組成部分的觀察代碼",
        "definition" : "描述此組成部分觀察的內容。"
      },
      {
        "id" : "Observation.component.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "組成部分的實際觀察結果",
        "definition" : "此組成部分的實際觀察結果。"
      },
      {
        "id" : "Observation.component.dataAbsentReason",
        "path" : "Observation.component.dataAbsentReason",
        "short" : "觀察結果缺失的原因",
        "definition" : "提供觀察結果值缺失的原因。"
      }
    ]
  }
}

```
