# TW Core Observation Blood Pressure - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Observation Blood Pressure 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-bloodPressure-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreObservationBloodPressure |

 
此臺灣核心-血壓（TW Core Observation Blood Pressure） Profile說明本IG如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile以呈現血壓資料。 

**Usages:**

* Examples for this Profile: [Observation/obs-bloodPressure-example](Observation-obs-bloodPressure-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Observation-bloodPressure-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Observation-bloodPressure-twcore.csv), [Excel](StructureDefinition-Observation-bloodPressure-twcore.xlsx), [Schematron](StructureDefinition-Observation-bloodPressure-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Observation-id.md)**查詢所有Observation：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?_id=[id]`
`GET [base]/Observation/[id]`例子：
(1) GET [base]/Observation?_id=obs-bloodPressure-example
(2) GET [base]/Observation/obs-bloodPressure-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`category`](SearchParameter-Observation-category.md)**查詢所有Observation：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?category={system|}[code]`例子：
(1) GET [base]/Observation?category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs
1. **建議應該（SHOULD）**支援透過查詢參數**[`code`](SearchParameter-Observation-clinical-code.md)**查詢所有Observation：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?code={system|}[code]`例子：
(1) GET [base]/Observation?code=http://loinc.org|85354-9
1. **建議應該（SHOULD）**支援透過查詢參數**[`performer`](SearchParameter-Observation-performer.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Observation?performer={Type/}[id]`例子：
(1) GET [base]/Observation?performer=Practitioner/pra-dr-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`status`](SearchParameter-Observation-status.md)**查詢所有Observation：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?status=[code]`例子：
(1) GET [base]/Observation?status=registered
1. **建議應該（SHOULD）**支援透過查詢參數**[`subject`](SearchParameter-Observation-subject.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Observation?subject={Type/}[id]`例子：
(1) GET [base]/Observation?subject=Patient/pat-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`date`](SearchParameter-Observation-date.md)**查詢所有Observation：
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?date={gt|lt|ge|le}[date]`例子：
(1) GET [base]/Observation?date=gt2022-07-31



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Observation-bloodPressure-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-bloodPressure-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreObservationBloodPressure",
  "title" : "TW Core Observation Blood Pressure",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-血壓（TW Core Observation Blood Pressure） Profile說明本IG如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile以呈現血壓資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/bp",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.basedOn",
        "path" : "Observation.basedOn",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore",
              "http://hl7.org/fhir/StructureDefinition/DeviceRequest",
              "http://hl7.org/fhir/StructureDefinition/ImmunizationRecommendation",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore",
              "http://hl7.org/fhir/StructureDefinition/NutritionOrder",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ServiceRequest-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.partOf",
        "path" : "Observation.partOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/MedicationAdministration",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationDispense-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationStatement-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Immunization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "血壓",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ]
      },
      {
        "id" : "Observation.code.coding",
        "path" : "Observation.code.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.bodySite",
        "path" : "Observation.bodySite",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      },
      {
        "id" : "Observation.method",
        "path" : "Observation.method",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-methods"
        }
      },
      {
        "id" : "Observation.hasMember",
        "path" : "Observation.hasMember",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/QuestionnaireResponse-twcore",
              "http://hl7.org/fhir/StructureDefinition/MolecularSequence",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-vitalSigns-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom",
        "path" : "Observation.derivedFrom",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Media-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/QuestionnaireResponse-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-vitalSigns-twcore",
              "http://hl7.org/fhir/StructureDefinition/MolecularSequence"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component:SystolicBP",
        "path" : "Observation.component",
        "sliceName" : "SystolicBP"
      },
      {
        "id" : "Observation.component:SystolicBP.code",
        "path" : "Observation.component.code",
        "short" : "收縮壓代碼"
      },
      {
        "id" : "Observation.component:SystolicBP.code.coding",
        "path" : "Observation.component.code.coding",
        "min" : 1
      },
      {
        "id" : "Observation.component:DiastolicBP",
        "path" : "Observation.component",
        "sliceName" : "DiastolicBP"
      },
      {
        "id" : "Observation.component:DiastolicBP.code",
        "path" : "Observation.component.code",
        "short" : "舒張壓代碼"
      },
      {
        "id" : "Observation.component:DiastolicBP.code.coding",
        "path" : "Observation.component.code.coding",
        "min" : 1
      }
    ]
  }
}

```
