# TW Core MessageHeader - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core MessageHeader 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MessageHeader-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreMessageHeader |

 
此臺灣核心-訊息表頭（TW Core MessageHeader） Profile說明本IG如何進一步定義FHIR的MessageHeader Resource以呈現訊息表頭的詳細資料。 

## Resource MessageHeader - 內容

當我們在進行訊息交換，不論是發出請求還是回應某個請求時，都會用到一個特別的表頭，我們稱之為訊息標頭（MessageHeader）。這個表頭裡面會包含這次請求涉及的主要內容參照（比如是關於哪些資料的操作）以及其他一些相關資訊。這些資訊通常會被打包在一個 bundle 中發送出去，而MessageHeader resource 則是這個bundle裡的第一個 resource，就像是包裹的首頁或封面一樣，告訴接收者這個包裹的主要內容和目的。

### 範圍與使用

MessageHeader Resource 是為了支援[利用 FHIR Resources 進行訊息傳遞](https://hl7.org/fhir/R4/messaging.html)而設計的。當進行訊息交換時，主要會使用到 MessageHeader Resource。

MessageHeader Resource 也可以在 RESTful 架構中使用，它有一個標準的 resource 端點（[base-url]/MessageHeader），可以透過這個端點管理一組訊息 resources及建立過去訊息的儲存庫。就像是在電腦裡保存的一個資料夾，裡面存放著所有曾經發送和接收的郵件。**但要注意，僅僅是保存這些訊息紀錄，並不意味著這些事件還在發生，或者可以透過保存的紀錄來觸發任何相關的操作或事件。** 它只是一個方便我們回顧和管理過去訊息的方法。

**Usages:**

* Use this Profile: [TW Core Bundle Message](StructureDefinition-Bundle-message-twcore.md)
* Examples for this Profile: [MessageHeader/mes-request-example](MessageHeader-mes-request-example.md) and [MessageHeader/mes-response-example](MessageHeader-mes-response-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/MessageHeader-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MessageHeader-twcore.csv), [Excel](StructureDefinition-MessageHeader-twcore.xlsx), [Schematron](StructureDefinition-MessageHeader-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-MessageHeader-id.md)**查詢所有MessageHeader：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/MessageHeader?_id=[id]`
`GET [base]/MessageHeader/[id]`例子：
(1) GET [base]/MessageHeader?_id=mes-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`author`](SearchParameter-MessageHeader-author.md)**查詢所有MessageHeader：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/MessageHeader?author={Type/}[id]`例子：
(1) GET [base]/MessageHeader?author= https://twcore.mohw.gov.tw/ig/twcore/Practitioner-pra-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`sender`](SearchParameter-MessageHeader-sender.md)**查詢所有MessageHeader：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/MessageHeader?sender={Type/}[id]`例子：
(1) GET [base]/MessageHeader?sender= https://twcore.mohw.gov.tw/ig/twcore/org-hosp-example

### 實作注意事項

* 當我們發送一個訊息 bundle 時，我們可以選擇是否要把跟訊息有關的資訊（比如由誰輸入的、誰是作者、誰是負責這項工作的人的訊息）一起打包發送，但如果接收者(或其他中介軟體)能夠定位或解析這些參照的resources資訊，我們就可以選擇不把它們包含在訊息裡。把所有訊息都打包發送比較適合那些系統間連接不那麼緊密的情況；而對於那些系統間連接很緊密的情況，可以不用這麼做。傳送訊息的規格及系統存取能力都定義在結構定義（[Structure Definition](https://hl7.org/fhir/R4/structuredefinition.html)），我們可以透過它了解如何進行選擇。
* 訊息中特別關注的部分（例如：是關於哪一件事的訊息，我們稱之為 **focus resources - 焦點 resources**）和它具體包含哪些訊息，是根據每次發送的訊息事件所決定的（可以參考[傳送訊息事件說明](https://hl7.org/fhir/R4/messaging.html#events)），這部分訊息總是會被包含在訊息的bundle中。
* 如果MessageHeader裡面的`source.endpoint`和`destination.endpoint`是實際可存取的網址，那麼它們應該指向訊息可以被送達的地方。如果這些地址是邏輯上的（也就是說你不能直接用網路存取），那麼負責傳遞訊息的中介軟體必須知道怎麼把訊息正確送到目的地。
* 訊息發生的具體時間會記錄在 focus resource 裡，而訊息發送的時間則會記錄在[`Bundle.timestamp`](https://hl7.org/fhir/R4/bundle-definitions.html#Bundle.timestamp)。
* 訊息的作者和接收者並不是指實際操作系統的技術設備，而是使用這些技術設備的人或機構。
* 即使一條訊息沒有明確指出接收者是誰，接收方也沒有義務拒絕這條訊息。例如：一個追蹤系統可能會收到本來發給別的系統的訊息。
* MessageEvent 值集是由那些定義事件的 resources 的作者所填寫的。



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MessageHeader-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MessageHeader-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreMessageHeader",
  "title" : "TW Core MessageHeader",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-訊息表頭（TW Core MessageHeader） Profile說明本IG如何進一步定義FHIR的MessageHeader Resource以呈現訊息表頭的詳細資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MessageHeader",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MessageHeader",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MessageHeader",
        "path" : "MessageHeader",
        "short" : "描述系統間交換的訊息的resources",
        "definition" : "在系統之間交換資訊時，會使用一個稱為「message header（訊息表頭）」的資料項目來標記和組織這次交換的內容。無論是發出請求還是回應某個動作，「訊息表頭」都扮演著關鍵角色。它不僅包含了這次動作涉及的對象（例如：特定的資料或resources），還包含了與這次動作相關的其他資訊。\n\n這些資訊一般會放在一個稱為「Bundle」的resource中傳輸，而「Message Header」resource則是這個Bundle中的第一個resource。這種結構讓接收方可以從「Message Header」resource 開始解析整個bundle，了解這次訊息交換的上下文和目的。簡言之，「Message Header」resource就像是一封信的信頭，告訴接收者这封信的主要内容和目的。"
      },
      {
        "id" : "MessageHeader.id",
        "path" : "MessageHeader.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的DocumentReference紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "MessageHeader.meta",
        "path" : "MessageHeader.meta",
        "short" : "此DocumentReference Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "MessageHeader.implicitRules",
        "path" : "MessageHeader.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "MessageHeader.language",
        "path" : "MessageHeader.language",
        "short" : "用以表述DocumentReference Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "MessageHeader.text",
        "path" : "MessageHeader.text",
        "short" : "DocumentReference Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "MessageHeader.event[x]",
        "path" : "MessageHeader.event[x]",
        "short" : "此訊息代表的事件的代碼或連結到事件定義",
        "definition" : "用於識別此訊息所代表的事件並將其與其定義連接的代碼。作為FHIR規範一部分定義的事件，其系統值（system value）為「http://terminology.hl7.org/CodeSystem/message-events」。或者是指向EventDefinition的URI。",
        "comment" : "事件的時間將在foscus resource中找到。訊息的時間將在[Bundle.timestamp](bundle-definitions.html#Bundle.timestamp)中找到。",
        "requirements" : "驅動與此訊息相關的行為",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MessageEvent"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/message-events"
        }
      },
      {
        "id" : "MessageHeader.destination",
        "path" : "MessageHeader.destination",
        "short" : "訊息目的地應用程式",
        "definition" : "訊息目的地應用程式",
        "comment" : "在發送訊息時，通常 **應該（SHOULD）** 至少有一個接收目的地。但在某些情況下，發送訊息的系統可能不會知道任何特定的接收目的地系統。",
        "requirements" : "訊息中會指定一個或多個接收方（目的地應用程式），用於確定訊息應該發送到哪裡去。這樣做的目的是為了確保訊息能夠正確地被送達到預定的接收者，並且允許接收訊息的系統或人員檢查自己是否是該訊息的目標接收者。簡言之，這是一種確認「這個訊息是不是發給我的」的機制。"
      },
      {
        "id" : "MessageHeader.destination.name",
        "path" : "MessageHeader.destination.name",
        "short" : "系統的名稱",
        "definition" : "目標系統的名稱",
        "requirements" : "可用於回應的路徑和/或支援稽核"
      },
      {
        "id" : "MessageHeader.destination.target",
        "path" : "MessageHeader.destination.target",
        "short" : "在訊息或資料發送的目的地中，指定一個具體的接收點。",
        "definition" : "當發送的訊息首先被送達到一個中介系統而不是直接送到最終目的地時，需要明確識別出最終的接收系統是什麼。",
        "requirements" : "支援多點跳躍繞徑（multi-hop routing）"
      },
      {
        "id" : "MessageHeader.destination.endpoint",
        "path" : "MessageHeader.destination.endpoint",
        "short" : "實際目的地地址或id",
        "definition" : "指明訊息應該被繞徑到哪裡",
        "comment" : "對於不使用標準網絡地址的系統，該id可能是一個無法解析的URI。",
        "requirements" : "指明應將訊息繞徑至何處"
      },
      {
        "id" : "MessageHeader.destination.receiver",
        "path" : "MessageHeader.destination.receiver",
        "short" : "資料應該被發送給在現實生活中真正需要這些資訊的個人或機構",
        "definition" : "當單純發送資料到一個特定的應用程式是不夠用時，這允許我們把訊息直接指定發送給具體的某個人或是某個部門。",
        "requirements" : "可以把訊息發送到更多的地方，不只是發到某個應用程式裡面。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "MessageHeader.sender",
        "path" : "MessageHeader.sender",
        "short" : "訊息的實際發送端",
        "definition" : "識別發送端系統的身份，以便可以建立信任關係並進行後續操作。",
        "comment" : "這個使用案例是針對一個（受信任的）發送端系統負責管理多個機構的情況，因此單憑來源端點/身份驗證無法區分機構。",
        "requirements" : "不僅僅限制在應用程式層級的繞徑操作，可以進行更高層次的繞徑操作。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MessageHeader.enterer",
        "path" : "MessageHeader.enterer",
        "short" : "資料輸入的來源",
        "definition" : "此訊息的資料輸入來源，即導致此訊息出現的人員或裝置。如果有多個可能的輸入者，則應選擇與訊息最相關的那個。如果有其他可能的輸入者，可以在擴充資料項目中提供其他輸入者資訊。",
        "comment" : "通常僅用於請求，但也可用於回應。",
        "requirements" : "需要知道這個訊息的來源是出於審計/追溯需求，可能也與授權有關。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
            ]
          }
        ]
      },
      {
        "id" : "MessageHeader.author",
        "path" : "MessageHeader.author",
        "short" : "決策的來源",
        "definition" : "這是在描述訊息的作者，也就是決定所描述事件應該發生的人或設備。如果有多個可能的候選者，應該選擇最接近消息標頭的那個。在需要時，可以在擴充資料項目中提供其他作者的相關資訊。",
        "comment" : "通常僅用於請求，但也可用於回應。",
        "requirements" : "需要知道這個訊息的來源是出於審計/追溯需求，可能也與授權有關。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
            ]
          }
        ]
      },
      {
        "id" : "MessageHeader.source",
        "path" : "MessageHeader.source",
        "short" : "訊息來源應用程式",
        "definition" : "此訊息來源應用程式",
        "requirements" : "允許回應，支援稽核。"
      },
      {
        "id" : "MessageHeader.source.name",
        "path" : "MessageHeader.source.name",
        "short" : "系統的名稱",
        "definition" : "系統的名稱",
        "requirements" : "可用於支援稽核"
      },
      {
        "id" : "MessageHeader.source.software",
        "path" : "MessageHeader.source.software",
        "short" : "運行系統的軟體名稱",
        "definition" : "可能包含設定或其他對於除錯有用的資訊",
        "requirements" : "支援稽核功能，也可能涉及到介面引擎（Interface Engine）的操作。介面引擎是一種軟體工具或平台，用於在不同的資訊系統、應用程式或資料庫之間傳輸和轉換資料。"
      },
      {
        "id" : "MessageHeader.source.version",
        "path" : "MessageHeader.source.version",
        "short" : "軟體運行的版本",
        "definition" : "可以在訊息經過多方處理的情況下，傳達多個系統的版本資訊。",
        "requirements" : "支援稽核功能，也可能涉及到介面引擎（Interface Engine）的操作。介面引擎是一種軟體工具或平台，用於在不同的資訊系統、應用程式或資料庫之間傳輸和轉換資料。"
      },
      {
        "id" : "MessageHeader.source.contact",
        "path" : "MessageHeader.source.contact",
        "short" : "提供人工聯絡途徑以處理問題",
        "definition" : "提供電子郵件、電話、網站或其他聯絡方式，用以解決訊息溝通上的問題。",
        "requirements" : "允許對技術問題進行升級處理"
      },
      {
        "id" : "MessageHeader.source.endpoint",
        "path" : "MessageHeader.source.endpoint",
        "short" : "實際訊息來源地址或ID",
        "definition" : "要把確認訊息發給哪個地方？",
        "comment" : "這個 id 可能是一個無法在不使用標準基於網路地址的系統中解析的 URI",
        "requirements" : "指明回應訊息應該發送到的地方，這個指定可能會對系統的安全權限產生影響。"
      },
      {
        "id" : "MessageHeader.responsible",
        "path" : "MessageHeader.responsible",
        "short" : "事件的最終責任",
        "definition" : "承擔整個訊息內容的最終責任的個人或機構，這意味著訊息事件發生在負責方的政策下。",
        "comment" : "通常僅用於請求，但也可以在回應中使用。",
        "requirements" : "需要知道這一點是為了滿足稽核/追踪需求，可能也是為了授權。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "MessageHeader.reason",
        "path" : "MessageHeader.reason",
        "short" : "事件的原因",
        "definition" : "這是對事件原因的編碼指示，表示了此訊息關注（focus）事件發生的原因。",
        "requirements" : "需要能夠追蹤為何resource被更改，並在resource的稽核日誌/歷史記錄中報告，但這可能會影響授權。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "EventReason"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/message-reason-encounter"
        }
      },
      {
        "id" : "MessageHeader.response",
        "path" : "MessageHeader.response",
        "short" : "這是對先前訊息的回應",
        "definition" : "如果這是對先前訊息的回應，則包含有關此訊息的回應訊息。"
      },
      {
        "id" : "MessageHeader.response.identifier",
        "path" : "MessageHeader.response.identifier",
        "short" : "原始訊息的Id",
        "definition" : "此訊息所回應的原始訊息的MessageHeader.id ",
        "requirements" : "讓接收者知道正在回應哪個訊息"
      },
      {
        "id" : "MessageHeader.response.code",
        "path" : "MessageHeader.response.code",
        "definition" : "指明訊息回應類型的代碼 - 表示它是否成功，是否應該重新發送。",
        "comment" : "這是對請求訊息的一般性回應。回應的具體資料將在MessageHeader.focus中找到。",
        "requirements" : "允許確認訊息的發送者知道請求是否成功，或是否需要採取行動。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ResponseType"
            }
          ],
          "strength" : "required",
          "description" : "訊息回應類型；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/response-code|4.0.1"
        }
      },
      {
        "id" : "MessageHeader.response.details",
        "path" : "MessageHeader.response.details",
        "short" : "特定的提示/警告/錯誤清單",
        "definition" : "訊息中發現的任何問題細節",
        "comment" : "這些問題 **必須（SHALL）** 被包含在 bundle 中。如果其中有任何錯誤，則回應代碼 **必須（SHALL）** 是錯誤。",
        "requirements" : "允許訊息的發送者確定具體的問題是什麼"
      },
      {
        "id" : "MessageHeader.focus",
        "path" : "MessageHeader.focus",
        "short" : "訊息的實際內容",
        "definition" : "訊息的實際資料 - 這是指向事件的root/focus class的參照。",
        "comment" : "每個訊息事件都涉及實際資料，即在事件定義中識別的單個 resource，可能還包括一些或所有關聯 resources。",
        "requirements" : "每個訊息事件都牽涉到實際的資料，就是在定義異動/交易類型時標識的單一 resource，有時還可能包括一些或全部相關聯的 resources。這些資料是在定義異動/交易類型時所定義的，異動/交易資料始終包含在完整訊息的 Bundle 中。這裡僅指定了root resource，它所參照的其他 resources 應該包含在 Bundle 中但並未在這裡列出。允許多次重複以處理具有多個焦點（focus）目標的合併和其他情況。",
        "mustSupport" : true
      },
      {
        "id" : "MessageHeader.definition",
        "path" : "MessageHeader.definition",
        "short" : "這個訊息的定義連結",
        "definition" : "此訊息的 MessageDefinition 的永久連結",
        "requirements" : "允許發送者定義訊息的預期內容"
      }
    ]
  }
}

```
