# TW Core MedicationRequest - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core MedicationRequest 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreMedicationRequest |

 
此臺灣核心-藥品請求（TW Core MedicationRequest） Profile說明本IG如何進一步定義FHIR的MedicationRequest Resource以呈現藥品請求的詳細資料。 

## Resource MedicationRequest - 內容

一份包含藥品供應和給病人使用藥品指示的醫令或請求稱為「藥品請求 （MedicationRequest）」。之所以選用「藥品請求」而不是「藥品處方 （MedicationPrescription）」或「藥品醫令 （MedicationOrder）」作為名稱，是為了讓這個resource能夠適用於更廣泛的場景，包括住院和門診環境、護理計畫等，同時也為了與現有的工作流程模式相協調。

### 範圍與使用

這個resource是用來記錄針對病人的各種藥品醫令，包括住院和社區中的藥品醫令（不論是由開立處方醫生還是由藥局給藥），它不僅適用於處方藥，還包括非處方藥物如阿司匹林、全腸外營養和飲食/維他命補充品的醫令。此外，這個resource還可以用於藥品相關裝置的醫令，但是，它不用於開立特定飲食的醫令，或是非藥品相關項目（如眼鏡、耗材等）醫令。MedicationRequest還可以用來匯報來自外部系統的醫令/請求，這些只是作為資訊分享，並非正式執行的醫令（例如：不預期進行配藥或給藥）。

從FHIR工作流程的角度看，MedicationRequest是一個用於「請求」的resource，旨在協助處理藥品相關的工作流程需求——詳見[工作流程請求](https://hl7.org/fhir/R4/workflow.html#request)。

如果需要一次開立多種藥品，則需使用MedicationRequest的多個實例來完成，並根據實際工作流程的需求將這些實例相互關聯。如需了解如何組織多個醫令，可以參考[請求模式](https://hl7.org/fhir/R4/request.html#compound)的指導。

### 界限與關聯

MedicationRequest resource是用來為病人請求或開立藥品醫令的。此外，當需要在不同機構或來源之間交流有關藥品請求或醫令的資訊時，也可以使用此resource。如果要請求耗材或醫療裝置，且這些請求涉及到病人使用指示時，則應該選擇使用[SupplyRequest](https://hl7.org/fhir/R4/supplyrequest.html)或[DeviceRequest](https://hl7.org/fhir/R4/devicerequest.html)。而當需要記錄和報告病人對藥品的使用情況時，則應該使用[MedicationStatementt](StructureDefinition-MedicationStatement-twcore.md)。這樣的安排確保了每種醫療需求都能通過最合適的resource來處理，從而提高了資訊交流的效率和準確性。

**藥品領域包括多個相關resources**

| | |
| :--- | :--- |
| [MedicationRequest](StructureDefinition-MedicationRequest-twcore.md)（藥品請求） | 一個關於供應藥品及病人服藥或用藥指示的醫令。 |
| [MedicationDispense](StructureDefinition-MedicationDispense-twcore.md)（配藥或調劑藥品） | 提供一批藥品，旨在隨後由病人使用或服用（通常是回應處方）。 |
| [MedicationAdministration](https://hl7.org/fhir/R4/medicationadministration.html)（給藥） | 當病人實際使用藥品或者以其他方式給予病人藥品時。 |
| [MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)（用藥聲明） | 這是一項紀錄，記錄了病人服用藥品或藥品已經給予病人，其中紀錄是基於病人或另一位臨床醫生的報告。藥品聲明不是「處方開立->配藥->給藥」過程中的一部分，而是一個報告，表明這樣的過程（或至少其一部分）確實發生了，從而認為病人已經接受了特定的藥品。 |

這個resource被多個其他resources參照，包括照護計畫（[CarePlan](https://hl7.org/fhir/R4/careplan.html#CarePlan)）、理賠申請（[Claim](https://hl7.org/fhir/R4/claim.html#Claim)）、診斷報告（[DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md)）、利益說明（[ExplanationOfBenefit](https://hl7.org/fhir/R4/explanationofbenefit.html#ExplanationOfBenefit)）、給藥（[MedicationAdministration](https://hl7.org/fhir/R4/medicationadministration.html#MedicationAdministration)）、配藥或調劑藥品（[MedicationDispense](StructureDefinition-MedicationDispense-twcore.md)）、藥品請求（MedicationRequest）、用藥聲明（[MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)）、檢驗檢查（[Observation](StructureDefinition-Observation-laboratoryResult-twcore.md)） 和服務請求（[ServiceRequest](https://hl7.org/fhir/R4/servicerequest.html#ServiceRequest)）。

**Usages:**

* Refer to this Profile: [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md), [TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md), [TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md), [TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md)...Show 18 more,[TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md),[TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md),[TW Core Observation Blood Pressure](StructureDefinition-Observation-bloodPressure-twcore.md),[TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md),[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md),[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md)and[TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)
* Examples for this Profile: [MedicationRequest/med-req-cod-example](MedicationRequest-med-req-cod-example.md) and [MedicationRequest/med-req-ref-example](MedicationRequest-med-req-ref-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/MedicationRequest-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationRequest-twcore.csv), [Excel](StructureDefinition-MedicationRequest-twcore.xlsx), [Schematron](StructureDefinition-MedicationRequest-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：ounter

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-MedicationRequest-id.md)**查詢所有MedicationRequest：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/MedicationRequest?_id=[id]`
`GET [base]/MedicationRequest/[id]`例子：
(1) GET [base]/MedicationRequest?_id=med-req-ref-example
(2) GET [base]/MedicationRequest/med-req-ref-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`status`](SearchParameter-MedicationRequest-status.md)**查詢所有MedicationRequest：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/MedicationRequest?status=[code]`例子：
(1) GET [base]/MedicationRequest?status=active
1. **建議應該（SHOULD）**支援透過查詢參數**[`intent`](SearchParameter-MedicationRequest-intent.md)**查詢所有MedicationRequest：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/MedicationRequest?intent=[code]`例子：
(1) GET [base]/MedicationRequest?intent=order
1. **建議應該（SHOULD）**支援透過查詢參數**[`subject`](SearchParameter-MedicationRequest-subject.md)**查詢所有MedicationRequest：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/MedicationRequest?subject={Type/}[id]`例子：
(1) GET [base]/MedicationRequest?subject=Patient/pat-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`medication`](SearchParameter-MedicationRequest-medication.md)**查詢所有MedicationRequest：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/MedicationRequest?medication={Type/}[id]`例子：
(1) GET [base]/MedicationRequest?medication=Medication/med-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`encounter`](SearchParameter-MedicationRequest-encounter.md)**查詢所有MedicationRequest：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/MedicationRequest?encounter={Type/}[id]`例子：
(1) GET [base]/MedicationRequest?encounter=Encounter/enc-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`authoredon`](SearchParameter-MedicationRequest-authoredon.md)**查詢所有MedicationRequest：
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/MedicationRequest?authoredon={gt|lt|ge|le}[date]`例子：
(1) GET [base]/MedicationRequest?authoredon=gt2022-08-01

### 劑量指示

在劑量指示過於複雜，難以進行編碼時，可以採用純文字形式來進行說明。這個屬性的內容不會包含藥品的名稱或其描述。即便存在編碼化的指示，純文字形式的劑量指示仍可用於展示給服藥或給藥的人員。預計這些文字指示將始終被填寫完整。如果劑量的時間（`dosage.timing`）也被提供，那麼劑量的純文字說明（`dosage.text`）應該反映與劑量時間相同的資訊。



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationRequest-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreMedicationRequest",
  "title" : "TW Core MedicationRequest",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-藥品請求（TW Core MedicationRequest） Profile說明本IG如何進一步定義FHIR的MedicationRequest Resource以呈現藥品請求的詳細資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest",
        "path" : "MedicationRequest",
        "short" : "為病人或實體集合（例如：特定的一群人）開立的藥品請求",
        "definition" : "關於藥品供應和對病人用藥指導的醫令或請求。此resource被稱為 「MedicationRequest」，而不是 「MedicationPrescription 」或「MedicationOrder」，以便與在住院病人和門診病人的環境中通用，包括照護計畫等，並與工作流程模式相協調。"
      },
      {
        "id" : "MedicationRequest.id",
        "path" : "MedicationRequest.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的MedicationRequest紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "MedicationRequest.meta",
        "path" : "MedicationRequest.meta",
        "short" : "此MedicationRequest Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "MedicationRequest.implicitRules",
        "path" : "MedicationRequest.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "MedicationRequest.language",
        "path" : "MedicationRequest.language",
        "short" : "用以表述MedicationRequest Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "MedicationRequest.text",
        "path" : "MedicationRequest.text",
        "short" : "MedicationRequest Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "MedicationRequest.identifier",
        "path" : "MedicationRequest.identifier",
        "short" : "此藥品請求的外部識別碼",
        "definition" : "與此藥品請求相關的識別碼，這些識別碼是由業務流程定義的，並且/或者在對resource本身的直接URL參照不合適的情況下用來參照它。它們是由執行者或其他系統指定給此resource的業務用識別碼，並隨著resource的更新和從伺服器到伺服器的傳播而保持不變。",
        "comment" : "這是一個業務用識別碼，而不是一個resource識別碼。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.status",
        "path" : "MedicationRequest.status",
        "definition" : "一個指定醫令當前狀態的代碼。一般來說，它是有效或完成的狀態。",
        "comment" : "這個資料項目被標記為修飾用，因為此狀態亦包含標記resource當前為無效的代碼。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationRequestStatus"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationrequest-status|4.0.1"
        }
      },
      {
        "id" : "MedicationRequest.statusReason",
        "path" : "MedicationRequest.statusReason",
        "short" : "當前狀態的原因",
        "definition" : "捕捉MedicationRequest當前狀態的原因",
        "comment" : "這通常只用於 「例外」狀態，例如：「暫停」或 「取消」。MedicationRequest的原因是在reasonCode中描述，而不是在這裡。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationRequestStatusReason"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationrequest-status-reason"
        }
      },
      {
        "id" : "MedicationRequest.intent",
        "path" : "MedicationRequest.intent",
        "definition" : "請求是提案、計畫、還是原始醫令？",
        "comment" : "預期服務請求者的型別將在MedicationRequest的不同階段受到限制。例如：提案可由病人（Patient）、相關人士（relatedPerson）、健康照護服務提供者（Practitioner）或設備（Device）建立。照護計畫可由健康照護服務提供者、病人、相關人士和設備建立。原始醫令只能由健康照護服務提供者建立。\n \n實例醫令（an instance-order）是請求或醫令的實例，可用於填充給藥紀錄。\n \n這個資料項目被標記為修飾用，因為其意圖改變resource實際適用的時間和方式。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationRequestIntent"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationrequest-intent|4.0.1"
        }
      },
      {
        "id" : "MedicationRequest.category",
        "path" : "MedicationRequest.category",
        "short" : "用藥型別",
        "definition" : "表示藥品請求的型別（例如：預計用藥或給藥的地方（即住院病人或門診病人））。",
        "comment" : "此類別可用於包括預期的藥品使用地點或其他型別的請求",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationRequestCategory"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationrequest-category"
        }
      },
      {
        "id" : "MedicationRequest.priority",
        "path" : "MedicationRequest.priority",
        "short" : "routine ｜ urgent ｜ asap ｜ stat",
        "definition" : "表示相對於其他請求而言，此藥品請求應如何快速得到處理。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationRequestPriority"
            }
          ],
          "strength" : "required",
          "description" : "應填入RequestPriority值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/request-priority|4.0.1"
        }
      },
      {
        "id" : "MedicationRequest.doNotPerform",
        "path" : "MedicationRequest.doNotPerform",
        "short" : "如果藥品請求是禁止活動，則為真。",
        "definition" : "如果為真，表示健康照護服務提供者要求不發生藥品請求。",
        "comment" : "如果沒有具體說明不執行，則該藥品請求是一個正向的請求，例如：「執行」。"
      },
      {
        "id" : "MedicationRequest.reported[x]",
        "path" : "MedicationRequest.reported[x]",
        "short" : "被報告的而不是主要的紀錄",
        "definition" : "表明此記錄是否為次級的 「報告 」紀錄，而不是作為原始的主要真實來源紀錄，它也可用以表明報告的來源。",
        "type" : [
          {
            "code" : "boolean"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.medication[x]",
        "path" : "MedicationRequest.medication[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "服用的藥品。",
        "definition" : "指明被請求的藥品，這是一個指向代表藥品的resource的連接，可以是藥品的細節，也可以是一個帶有代碼的屬性，從已知的藥品列表中指明此藥品。",
        "comment" : "如果只具體說明一個代碼，那麼它需要是一個特定產品的代碼。如果需要更多資訊，那麼建議使用Medication resource。例如：如果您需要劑型或批號，或者如果藥品是複方或臨場調製（extemporaneously prepared）的，那麼您必須參考Medication resource。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Medication-twcore"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationCode"
            }
          ],
          "strength" : "example",
          "description" : "此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-codes"
        }
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationReference",
        "path" : "MedicationRequest.medication[x]",
        "sliceName" : "medicationReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Medication-twcore"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept",
        "path" : "MedicationRequest.medication[x]",
        "sliceName" : "medicationCodeableConcept",
        "short" : "服用的藥品。此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
        "definition" : "指明被開立的藥品，這是一個指向代表藥品的resource的連接，可以是藥品的細節，也可以是一個帶有代碼的屬性，從已知的藥品列表中指明此藥品。",
        "comment" : "如果只具體說明一個代碼，那麼它需要是一個特定產品的代碼。如果需要更多資訊，那麼建議使用Medication resource。例如：如果您需要劑型或批號，或者如果藥品是複方或臨場調製（extemporaneously prepared）的，那麼您必須參考Medication resource。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationCode"
            }
          ],
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-codes"
        }
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding",
        "path" : "MedicationRequest.medication[x].coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。"
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding:fda-medication-tw",
        "path" : "MedicationRequest.medication[x].coding",
        "sliceName" : "fda-medication-tw",
        "short" : "此為臺灣食品藥物管理署(TFDA)維護之藥品代碼，涵蓋範圍相對完整，可免費使用，可優先選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-fda-tw"
        }
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding:nhi-medication-tw",
        "path" : "MedicationRequest.medication[x].coding",
        "sliceName" : "nhi-medication-tw",
        "short" : "此為中央健康保險署(NHI)維護之藥品代碼，主要針對申報使用，更新頻率相對頻繁，可免費使用，可依情境選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-nhi-tw"
        }
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding:nhi-medication-ch-herb-tw",
        "path" : "MedicationRequest.medication[x].coding",
        "sliceName" : "nhi-medication-ch-herb-tw",
        "short" : "此為中央健康保險署(NHI)維護之中藥藥品代碼，主要針對申報使用，更新頻率相對頻繁，可免費使用，可依情境選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "min" : 0,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/nhi-medication-ch-herb-tw"
        }
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding:rxnorm-medication-us-core",
        "path" : "MedicationRequest.medication[x].coding",
        "sliceName" : "rxnorm-medication-us-core",
        "short" : "RxNorm為美國Unified Medical Language System®中的藥品代碼，取得UMLS®授權即可免費使用，可依情境選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-rxnorm-tw"
        }
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding:atc-medication-code",
        "path" : "MedicationRequest.medication[x].coding",
        "sliceName" : "atc-medication-code",
        "short" : "ATC代碼的版權為世界衛生組織（WHO）Collaborating Centre for Drug Statistics Methodology，可免費使用，可依情境選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medcation-atc-tw"
        }
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding:snomedct-medication-codes",
        "path" : "MedicationRequest.medication[x].coding",
        "sliceName" : "snomedct-medication-codes",
        "short" : "此為SNOMED CT代碼，若機構已有購買相關授權，亦可使用。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-codes"
        }
      },
      {
        "id" : "MedicationRequest.subject",
        "path" : "MedicationRequest.subject",
        "short" : "為誰或哪個實體集合（例如：特定的一群人）所開立的藥品請求",
        "definition" : "連結至一個或一組即將給予藥品的人",
        "comment" : "藥品請求的對像是必填的。對於不提供實際對象的次級使用案例，仍然必須指定一個匿名對象。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.encounter",
        "path" : "MedicationRequest.encounter",
        "short" : "連結至一個或一組即將給予藥品的人",
        "definition" : "建立此[x]的就醫（Encounter），或與此藥品請求紀錄密切相關的就醫。",
        "comment" : "這通常是事件發生的就醫（Encounter），但有些活動可能是在就醫完成之前或之後發生，但仍與就醫的情境相關。如果需要與照護事件相聯繫，它們將用一個擴充資料項目來處理。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.supportingInformation",
        "path" : "MedicationRequest.supportingInformation",
        "short" : "任何與藥品請求相關的補充資訊",
        "definition" : "任何與藥品請求相關的補充資訊（例如：病人身高及體重）"
      },
      {
        "id" : "MedicationRequest.authoredOn",
        "path" : "MedicationRequest.authoredOn",
        "short" : "藥品請求請求最初何時被撰寫？",
        "definition" : "處方最初書寫或撰寫的日期（或許也有時間）。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.requester",
        "path" : "MedicationRequest.requester",
        "short" : "誰／什麼提出藥品請求請求？",
        "definition" : "發起藥品請求並對其有效負責的個人、組織或設備。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
              "http://hl7.org/fhir/StructureDefinition/Device"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.performer",
        "path" : "MedicationRequest.performer",
        "short" : "預期的給藥執行者",
        "definition" : "具體說明的藥物治療執行者（例如：給藥的執行者）。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.performerType",
        "path" : "MedicationRequest.performerType",
        "short" : "所需的給藥執行者種類",
        "definition" : "表明給藥的執行者的型別",
        "comment" : "如果具體說明中未表明執行者，則表明執行者必須是具體的型別。如果具體說明有執行者，那麼如果指定的執行無法獲得則需說明指定執行者的要求條件。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/performer-role"
        }
      },
      {
        "id" : "MedicationRequest.recorder",
        "path" : "MedicationRequest.recorder",
        "short" : "輸入藥品請求請求的人",
        "definition" : "代表另一個人輸入醫令的人，例如：在口頭或電話指示下的情況。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.reasonCode",
        "path" : "MedicationRequest.reasonCode",
        "short" : "開立醫令或不開立醫令的原因或指示",
        "definition" : "開立或不開立藥品醫令的原因或指示",
        "comment" : "這可能是一個診斷代碼。如果存在完整的病情、問題或診斷（condition）紀錄或需要附加的細節，請使用 reasonReference。",
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-code"
        }
      },
      {
        "id" : "MedicationRequest.reasonReference",
        "path" : "MedicationRequest.reasonReference",
        "short" : "開立處方的原因，例如：病情、問題或診斷（condition）或者檢驗檢查（observation）",
        "definition" : "開立藥品醫令的原因，例如：病情、問題或診斷（condition）或者檢驗檢查（observation）。",
        "comment" : "藥品醫令開立的原因參照，例如：病情、問題或診斷（condition）或者檢驗檢查（observation）。如果只能有一個代碼存在，則使用reasonCode。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-laboratoryResult-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.instantiatesCanonical",
        "path" : "MedicationRequest.instantiatesCanonical",
        "short" : "實例化FHIR計畫書（protocol）或定義",
        "definition" : "指向此藥品請求全部或部分遵守的計畫書（protocol）、指南（guideline）、醫令集（orderset）或其他定義的URL。"
      },
      {
        "id" : "MedicationRequest.instantiatesUri",
        "path" : "MedicationRequest.instantiatesUri",
        "short" : "實例化外部計畫書（protocol）或定義",
        "definition" : "指向此藥品請求全部或部分的外部維護之計畫書（protocol）、指南（guideline）、醫令集（orderset）或其他定義的URL。"
      },
      {
        "id" : "MedicationRequest.basedOn",
        "path" : "MedicationRequest.basedOn",
        "short" : "此MedicationRquest是基於什麼而履行？",
        "definition" : "透過藥品請求，一項計畫或請求已全部或部分被履行",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ServiceRequest-twcore",
              "http://hl7.org/fhir/StructureDefinition/ImmunizationRecommendation"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.groupIdentifier",
        "path" : "MedicationRequest.groupIdentifier",
        "short" : "此為綜合請求的一部分",
        "definition" : "由單一作者或多或少同時授權之所有服務請求的共用識別碼，代表一個藥品請求的群組識別碼",
        "requirements" : "請求之間的連接可以透過「基於」(basedOn) 關係實現（即一個請求是為了完成另一個請求），或者是它們有一個共同的申請單 (requisition)。那些屬於同一申請單的請求，在改變它們的狀態或在最初創建後進行維護的過程中，通常被視為各自獨立的。"
      },
      {
        "id" : "MedicationRequest.courseOfTherapyType",
        "path" : "MedicationRequest.courseOfTherapyType",
        "short" : "給藥的整體模式",
        "definition" : "給病人的給藥整體模型描述",
        "comment" : "這個屬性不應與藥物治療計畫（protocol）混淆",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationRequestCourseOfTherapy"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationrequest-course-of-therapy"
        }
      },
      {
        "id" : "MedicationRequest.insurance",
        "path" : "MedicationRequest.insurance",
        "short" : "相關的保險承保範圍",
        "definition" : "提供此請求服務可能需要的保險計畫、擴大承保範圍、預先授權和／或預先決定。"
      },
      {
        "id" : "MedicationRequest.note",
        "path" : "MedicationRequest.note",
        "short" : "關於處方的資訊",
        "definition" : "關於處方的附加資訊，不能由其他屬性來傳達。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction",
        "path" : "MedicationRequest.dosageInstruction",
        "short" : "應該如何用藥",
        "definition" : "表明病人的用藥方式",
        "comment" : "在一些例子中，藥品請求可包括口服劑量或靜脈注射或肌肉注射劑量的選擇。例如：「昂丹司瓊（Ondansetron）8毫克口服或靜脈注射，每天兩次，治療噁心」或 「康帕辛® （Compazine®）【丙氯拉嗪（prochlorperazine）】5-10毫克口服（PO）或25毫克經直腸給藥（PR） 每天早、晚（飯後）1次（bid） 需要時使用（prn）噁心或嘔吐 」。在這些情況下，這兩個醫令的建立可歸為一組藥品醫令，基於病人在需要用藥時的情況決定使用哪種劑量和給藥途徑。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.sequence",
        "path" : "MedicationRequest.dosageInstruction.sequence",
        "short" : "劑量指示的順序",
        "definition" : "表明使用或解釋劑量指示的順序",
        "requirements" : "如果多個劑量的序號是相同的，那麼就意味著這些指示將被視為同時進行。如果序號不同，那麼這些劑量將是依續使用。"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.text",
        "path" : "MedicationRequest.dosageInstruction.text",
        "short" : "純文字表述的劑量指示，例如：SIG。",
        "definition" : "純文字表述的劑量指示，例如：SIG。",
        "requirements" : "純文字表述劑量指示可用於說明太複雜而無法編碼的案例。此屬性的內容不包括藥品的名稱或描述。當有已編碼的指示，純文字表述說明可能仍然存在，以顯示給服用藥品或給藥的人。文字指示預計將始終被填入。如果dosage.timing屬性也被填入，那麼dosage.text應該反映與timing相同的資訊。關於給藥或準備藥品的附加資訊應作為文字包括在內。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.additionalInstruction",
        "path" : "MedicationRequest.dosageInstruction.additionalInstruction",
        "short" : "對病人的補充指示或警告－例如：「隨餐服用」，「可能引起嗜睡」",
        "definition" : "向病人提供關於如何服藥的補充指示（例如 「隨餐服用」或「在進食前半小時服用」）或給病人的藥品警告（例如「可能導致嗜睡 」或「避免皮膚暴露於陽光直射或人工強光燈（日曬用）下」）。",
        "comment" : "應在dosage.text中填入關於用藥或準備藥品的資訊（例如： 「盡可能快地透過腹膜內口輸液」或 「在用 x 藥後立即服用」）。",
        "requirements" : "附加指示是要編碼的，但在沒有編碼的情況下，此資料項目可以包括文字。例如，「用大量的水吞咽」，這可能編碼也可能不編碼。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "一個編碼的概念，確定額外的指示，如「與水一起服用」或「避免操作重型機器」；可參考所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/additional-instruction-codes"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.patientInstruction",
        "path" : "MedicationRequest.dosageInstruction.patientInstruction",
        "short" : "以病人或消費者為導向的指示",
        "definition" : "用病人或消費者能理解的術語提供指示"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing",
        "path" : "MedicationRequest.dosageInstruction.timing",
        "short" : "應該何時給藥；時間的寫法請參照Timimg datatype。",
        "definition" : "應該何時給藥",
        "comment" : "這個屬性可能並不總是被填入，而Dosage.text預計會被填入。如果兩者都被填入，那麼Dosage.text應反映Dosage.timing的內容。",
        "requirements" : "病人用藥的時間安排。這種data type允許許多不同的表達方式。例如：「每8小時一次」；「一天三次」；「從2011年12月23日開始的10天裡，早餐前半小時」；「2013年10月15日、2013年10月17日和2013年11月1日」。有時，當率值（rate）為總容量／期間，其「期間」意指（例如：500mL／2小時）之持續期間為2小時。但當率值非意指「持續期間」時（例如：250mL／小時），則需要timing.repeat.duration來表達輸液的時間區間。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.event",
        "path" : "MedicationRequest.dosageInstruction.timing.event",
        "short" : "事件發生的時間",
        "definition" : "指明事件發生的特定時間",
        "requirements" : "例如：在一份用藥記錄中，你需要把一個一般的規範變成一個精確的規範。"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat",
        "short" : "事件定期重複發生的時間",
        "definition" : "一組描述事件何時被安排的規則",
        "requirements" : "定期重複的時間安排"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.bounds[x]",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.bounds[x]",
        "short" : "時間或期間長度／長度範圍，或（開始和／或結束）限制",
        "definition" : "時間長度或可能的時間長度範圍，或開始和／或結束時間。"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.count",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.count",
        "short" : "重複的次數",
        "definition" : "在整個持續期間內，期望重複的總次數。如果countMax這個資料項目存在，此count資料項目表示允許次數範圍的下限。",
        "comment" : "如果你同時擁有bounds和count這兩個資料項目，那麼這應該被理解為在bounds期間，發生count的次數。",
        "requirements" : "重複次數可透過設定結束時間或總發生次數作限制"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.countMax",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.countMax",
        "short" : "重複的最大次數",
        "definition" : "如果countMax存在，表示count是一個範圍，如此可在［count］和［countMax］之間的重複次數執行動作。"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.duration",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.duration",
        "short" : "此事件持續多久時間",
        "definition" : "這件事發生的時候會持續多久時間。如果durationMax這個資料項目存在，則此duration資料項目表示持續時間的允許範圍之下限。",
        "comment" : "對於一些事件，持續時間是事件定義的一部分（例如：靜脈輸液，持續時間隱含於特定輸液量及速度）。對於其他事件，它是時間規範的一部分（例如：運動持續時間）。",
        "requirements" : "有些活動不是立即發生，需要維持一段時間。"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.durationMax",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.durationMax",
        "short" : "此事件持續多久時間 （最長時間／最大值）",
        "definition" : "如果durationMax這個資料項目存在，表示duration資料項目是一個範圍的下限 — 所以要在［duration］和［durationMax］之間執行此活動。",
        "comment" : "對於一些事件，持續時間是事件定義的一部分（例如：靜脈輸液，持續時間隱含於特定輸液量及速度）。對於其他事件，它是時間規範的一部分（例如：運動持續時間）。",
        "requirements" : "有些活動不是立即發生，需要維持一段時間。"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.durationUnit",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.durationUnit",
        "short" : "s ｜ min ｜ h ｜ d ｜ wk ｜ mo ｜ a - 單位時間 （unit of time，UCUM）",
        "definition" : "持續時間的單位，以UCUM為單位。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "UnitsOfTime"
            }
          ],
          "strength" : "required",
          "description" : "時間的單位（單位來自UCUM）；應填入UnitsOfTime值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/units-of-time|4.0.1"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.frequency",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.frequency",
        "short" : "此事件於每一期間的發生頻率",
        "definition" : "在特定期間內重複動作的次數。如果frequencyMax存在，此frequency資料項目表示頻率的允許範圍的下限。"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.frequencyMax",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.frequencyMax",
        "short" : "此事件於每一期間的最大發生頻率",
        "definition" : "如果frequencyMax存在，frequency資料項目表示頻率範圍的下限 – 所以要在［frequency］和［frequencyMax］之間重複執行此活動。"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.period",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.period",
        "short" : "此事件於特定時間區間所發生的頻率",
        "definition" : "表示重複發生的時間區間；例如：為了表示「每天3次」，3次是頻率（frequency），1天是週期（period）。如果存在periodMax資料項目，此period資料項目表示時間區間長度的允許範圍的下限。"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.periodMax",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.periodMax",
        "short" : "時間區間的上限（3-4小時）",
        "definition" : "如果periodMax存在，表示時間區間是一個從［period］到［periodMax］的範圍，允許表達像是「每3至5天一次」的概念。"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.periodUnit",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.periodUnit",
        "short" : "s ｜ min ｜ h ｜ d ｜ wk ｜ mo ｜ a - 單位時間 （unit of time，UCUM）",
        "definition" : "持續時間的單位，以UCUM為單位。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "UnitsOfTime"
            }
          ],
          "strength" : "required",
          "description" : "時間的單位（單位來自UCUM）；應填入UnitsOfTime值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/units-of-time|4.0.1"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.dayOfWeek",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.dayOfWeek",
        "short" : "mon ｜ tue ｜ wed ｜ thu ｜ fri ｜ sat ｜ sun",
        "definition" : "如果提供的資訊為一星期中的一天或多天，那麼此活動只發生在這特定的幾天。",
        "comment" : "如果沒有指定天數，則假定該活動每天都會發生，否則就會指定。資料項目frequency和period不能與dayOfWeek同時使用。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DayOfWeek"
            }
          ],
          "strength" : "required",
          "description" : "應填入DaysOfWeek值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/days-of-week|4.0.1"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.timeOfDay",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.timeOfDay",
        "short" : "一天中的活動時間",
        "definition" : "具體說明一天中活動進行的時間",
        "comment" : "當指定了一天中的時間時，就會推斷出該活動每天都會在指定的時間發生（由dayofWeek篩選）。資料項目when、frequency和period不能和timeOfDay一起使用。"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.when",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.when",
        "short" : "事件發生的時間區間之代碼",
        "definition" : "一天中的一個大致時段，可能與日常生活中的某一事件有關，表明該活動應在何時發生。",
        "comment" : "當一個以上的事件被列出，則此事件被綁定至合併的數個特定事件。",
        "requirements" : "時間經常由特定事件的發生所決定，例如：起床、吃飯和睡覺。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "EventTiming"
            }
          ],
          "strength" : "required",
          "description" : "與時程表有關的真實世界事件；應填入EventTiming值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/event-timing|4.0.1"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.offset",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.offset",
        "short" : "事件的分鐘數（之前或之後）",
        "definition" : "距離特定事件發生的分鐘數。如果事件代碼沒有表明該分鐘是在事件之前還是之後，則假定該offset是指特定事件發生後的分鐘數。"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.code",
        "path" : "MedicationRequest.dosageInstruction.timing.code",
        "short" : "BID ｜ TID ｜ QID ｜ AM ｜ PM ｜ QD ｜ QOD ｜ + 此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
        "definition" : "活動發生時機之代碼（或只是code.text中的文字）。像是BID的一些代碼到處都有，但許多機構定義它們自己的額外代碼。如果提供了一個代碼，此代碼被理解為是結構化時間資料中規定的任何內容的完整陳述，代碼或資料都可用於解釋時機（Timing），但.repeat.bounds適用於代碼（且不包含在代碼中）的例外。",
        "comment" : "BID等被定義為「在機構特定的時間」。例如：一個機構可以選擇BID是 「總是在早上7點和下午6點」。如果這種選項是不合適的，就不應該使用代碼BID。反之，應使用一個獨特的機構特定代碼來代替HL7定義的BID代碼和／或使用一個結構化表示法（在這種情況下，具體說明兩個事件時間）。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "已知／確定的時間模式之代碼；鼓勵使用TimingAbbreviation值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-frequency-hl7-tw"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.code.coding",
        "path" : "MedicationRequest.dosageInstruction.timing.code.coding",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.code.text",
        "path" : "MedicationRequest.dosageInstruction.timing.code.text",
        "short" : "概念的文字標記法",
        "definition" : "輸入資料的使用者所見／所選／所說的人類可讀文字表述，和（或）其代表使用者的預期含義。",
        "comment" : "很多時候，此文字表述與其中一個代碼的顯示名稱相同。",
        "requirements" : "專門術語中的代碼並不總是能捕捉人類使用的細微差別的正確意義，或者根本就沒有合適的代碼；這些情況下，文字表述被用來捕捉來源的全部意義。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.asNeeded[x]",
        "path" : "MedicationRequest.dosageInstruction.asNeeded[x]",
        "short" : "「根據（對x的）需要」服用\nBinding：一個編碼概念，指明在服用或用藥之前應滿足或評估的先決條件。例如：「疼痛」、「性行為前30分鐘」、「發作時」等；可參考SNOMEDCTMedicationAsNeededReasonCodes值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
        "definition" : "表明此藥品是否只在需要時在特定的用法（Boolean選項）服用，或者表明服用此藥品（CodeableConcept）的前提條件。",
        "comment" : "可以透過設定Boolean = True來表達不用填寫理由的「根據需要」。在這種情況下，CodeableConcept不會被填入任何值。或者你可以透過包括CodeableConcept來表達 「根據需要」的理由。在這種情況下，Boolean值被假定為True。如果您將Boolean值設置為「False」，那麼該劑量是根據時間表給予的，而不是 「prn」或 「根據需要」。",
        "type" : [
          {
            "code" : "boolean"
          },
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "一個編碼概念，指明在服用或用藥之前應滿足或評估的先決條件。例如：「疼痛」、「性行為前30分鐘」、「發作時」等；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-as-needed-reason"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.site",
        "path" : "MedicationRequest.dosageInstruction.site",
        "short" : "用藥之身體部位",
        "definition" : "用藥的身體部位",
        "comment" : "如果使用案例需要BodySite resource的屬性（例如：分別識別和追蹤），那麼就使用標準extension bodySite。可以是一個摘要代碼，也可以是對一個非常精確的位置定義的參照，或者兩者都是。",
        "requirements" : "對藥品首次進入之人體解剖部位的編碼說明",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "一個編碼概念，描述藥品進入或在身體上的位置；可參考所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/approach-site-codes"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.route",
        "path" : "MedicationRequest.dosageInstruction.route",
        "short" : "藥品應如何進入體內",
        "definition" : "藥品應如何進入體內",
        "requirements" : "具體說明治療劑進入或到達病人體內的途徑或生理途徑之代碼",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "RouteOfAdministration"
            }
          ],
          "strength" : "example",
          "description" : "一個編碼概念，描述治療劑進入或在受試者體內的用藥途徑或生理途徑；此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/route-codes"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.route.coding",
        "path" : "MedicationRequest.dosageInstruction.route.coding",
        "short" : "由專門術語系統（terminology system）定義的代碼。此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-path-sct-tw"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.route.text",
        "path" : "MedicationRequest.dosageInstruction.route.text",
        "short" : "概念的文字標記法",
        "definition" : "輸入資料的使用者所見／所選／所說的人類可讀文字表述，和（或）其代表使用者的預期含義。",
        "comment" : "很多時候，此文字表述與其中一個代碼的顯示名稱相同。",
        "requirements" : "專門術語中的代碼並不總是能捕捉人類使用的細微差別的正確意義，或者根本就沒有合適的代碼；這些情況下，文字表述被用來捕捉來源的全部意義。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.method",
        "path" : "MedicationRequest.dosageInstruction.method",
        "short" : "用藥的技術",
        "definition" : "用藥的技術",
        "comment" : "使用的專門術語通常先組合配對（pre-coordinate）用藥途徑和／或劑型。",
        "requirements" : "表示藥品進入或進入身體的方法的一個編碼值。最常用的方法為注射。例如：慢推、深靜脈。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "一個編碼概念，描述用藥的技術；可參考所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/administration-method-codes"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate",
        "short" : "用藥量",
        "definition" : "用藥量"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.type",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.type",
        "short" : "特定劑量或比率種類",
        "definition" : "特定劑量或比率種類，例如：依處方或計算而來。",
        "requirements" : "如果此type資料項目沒有被填入，則假定為「依處方（ordered）」。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DoseAndRateType"
            }
          ],
          "strength" : "example",
          "description" : "可參考DoseAndRateType值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/dose-rate-type"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "short" : "每一劑量的藥量",
        "definition" : "每一劑量的藥量",
        "comment" : "請注意這是指特定藥品量，而不是指每種有效成分量。每種成分量都可以在Medication resource中進行溝通。例如：如果想表達一錠375毫克的藥錠，劑量是一錠，你可以使用Medication resource來記錄此藥錠是由375毫克的藥物XYZ組成。或者，如果劑量是375毫克，那麼你可能只需要使用Medication resource來表明這是藥錠。如果是靜脈注射，例如：多巴胺，你想表明400毫克多巴胺被混合在500毫升的靜脈注射液中，那麼這些都將在Medication resource中呈現。如果用藥不打算是即時的（速率是存在的，或者時間是有期限的），這可具體說明以傳達在時間表所指示的時段之總用藥量，例如：500毫升的劑量應該在4小時內完成。",
        "requirements" : "在一次用藥事件中給予的治療用或其他的物質量"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.rate[x]",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.rate[x]",
        "short" : "每時間單位內的用藥量",
        "definition" : "每時間單位內的用藥量",
        "comment" : "可同時提供rate和doseQuantity，以提供關於如何用藥和供應藥品的全部細節。如果速率打算隨著時間的推移而改變，根據當地的規則／法規，每次改變都應作為帶有更新速率的新版MedicationRequest來捕捉，或者用帶有新速率的新的MedicationRequest來捕捉。可以使用rateRatio和rateQuantity來指定一段時間內的比率（例如：100毫升／小時）。rateQuantity的方式要求系統有能力解析包含毫升／小時的UCUM語法，而不是將時間指定為分母的特定比率。如果指定了一個2小時500毫升的率值，使用rateRatio可能比使用rateQuantity指定250毫克／小時在語義上更正確。",
        "requirements" : "指明藥品引入病人體內的速度。通常是指輸液的速度，例如：每1小時100毫升或100毫升／小時。也可表示為每單位時間的速度，例如：每2小時500毫升，其他例子如200微克／分鐘或200微克／1分鐘；1升／8小時。有時，當表示為總容量／持續時間時，速率可以隱喻持續時間（例如：500毫升／2小時隱喻持續時間為2小時）。然而，當速率未隱喻持續時間時（例如：250毫升／小時），則需要timing.repeat.duration來表達輸液的時間區間。"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.maxDosePerPeriod",
        "path" : "MedicationRequest.dosageInstruction.maxDosePerPeriod",
        "short" : "每時間單位內用藥的上限",
        "definition" : "每時間單位內用藥的上限",
        "comment" : "這是為了在有上限的情況下作為劑量的輔助說明。例如：「每4小時2錠，一天最多8錠」。",
        "requirements" : "在一段時間區間用於某一對象的治療用物質之最大總量。例如：24小時內1,000毫克。"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.maxDosePerAdministration",
        "path" : "MedicationRequest.dosageInstruction.maxDosePerAdministration",
        "short" : "每次用藥的上限",
        "definition" : "每次用藥的上限",
        "comment" : "這是為了在有上限的情況下作為劑量的輔助說明。例如：與體表面積有關的劑量有一個上限，如在5至10分鐘內靜脈注射1.5毫克／平方米（最多2毫克），其doseQuantity為1.5毫克／平方米，maxDosePerAdministration為2毫克。",
        "requirements" : "每次用於某一對象治療用物質的最大總量"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.maxDosePerLifetime",
        "path" : "MedicationRequest.dosageInstruction.maxDosePerLifetime",
        "short" : "病人一生中用藥的上限",
        "definition" : "病人一生中用藥的上限",
        "requirements" : "用於某一對象的治療用物質於其一生的最大總數量"
      },
      {
        "id" : "MedicationRequest.dispenseRequest",
        "path" : "MedicationRequest.dispenseRequest",
        "short" : "藥品供應授權",
        "definition" : "這表示在藥品請求（亦稱作藥品處方或藥品醫令）中，關於調劑或提供藥品部分的特定詳情。注意：這些資訊不總是與醫令一同發送的。在某些機構（如醫院），可能會有機構或系統上的支援，允許藥局完成調劑的詳細資訊。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.initialFill",
        "path" : "MedicationRequest.dispenseRequest.initialFill",
        "short" : "首次依照處方配藥的細節",
        "definition" : "表明第一次配藥的數量或時間",
        "comment" : "如果填入此資料項目，必須包括數量或期間。"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.initialFill.quantity",
        "path" : "MedicationRequest.dispenseRequest.initialFill.quantity",
        "short" : "首次配藥的數量",
        "definition" : "首次配藥量"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.initialFill.duration",
        "path" : "MedicationRequest.dispenseRequest.initialFill.duration",
        "short" : "首次配藥的持續時間",
        "definition" : "預計首次配藥的時間持續長度"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.dispenseInterval",
        "path" : "MedicationRequest.dispenseRequest.dispenseInterval",
        "short" : "前後兩次配藥的最短時間間隔",
        "definition" : "前後兩次配藥必須間隔的最短時間"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.validityPeriod",
        "path" : "MedicationRequest.dispenseRequest.validityPeriod",
        "short" : "處方可用以配藥的有效期限",
        "definition" : "表明處方的有效期（處方的過期日期）",
        "comment" : "它反映了處方開立者對處方的有效性的看法。在此期限之外，不得根據處方進行配藥。配藥視窗的下限標誌處方可以首次配藥的開始日期。如果沒有指定上限，那麼處方是無期限的，或者將默認為基於法規的過期日期。",
        "requirements" : "表明處方何時有效，何時處方無法再被拿來配藥。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.numberOfRepeatsAllowed",
        "path" : "MedicationRequest.dispenseRequest.numberOfRepeatsAllowed",
        "short" : "可重複領藥的次數",
        "definition" : "一個整數，表示除了最初的配藥外，病人可以取得處方藥的次數【又稱連續處方／補藥（refills）或重複】。使用注意事項：這個整數不包括原始醫令的配藥，意即如果一個醫令顯示配藥30錠加上「3次重複」，那麼此醫令總共可以配藥4次，病人總共可以得到120片。開立處方者可明確說，在初次配藥後允許零次補藥。",
        "comment" : "如果顯示的是「授權的開藥次數」，則在這個數字上加1。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity",
        "path" : "MedicationRequest.dispenseRequest.quantity",
        "short" : "每次配藥的藥品（數）量",
        "definition" : "一次裝藥所需的（數）量"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.expectedSupplyDuration",
        "path" : "MedicationRequest.dispenseRequest.expectedSupplyDuration",
        "short" : "每次配藥可持續的天數",
        "definition" : "指明預期使用供應產品的時間區間，或預期配藥可持續的時間長度。",
        "comment" : "在某些情況下，這個屬性可以用來代替數量，透過預期持續的時間長度來確定供應的數量，而不是發放的實際數量，例如：90天的用藥供應（基於一個醫令的劑量）。在可能的情況下，指定數量總是更好的，因為這往往是更精確的。預期供應時間長度將總是一個估計值，可能受到外部因素的影響。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.performer",
        "path" : "MedicationRequest.dispenseRequest.performer",
        "short" : "預定的配藥人員",
        "definition" : "表明開立處方者指定的預定配藥機構（Organization）。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.substitution",
        "path" : "MedicationRequest.substitution",
        "short" : "對替代藥品的任何限制",
        "definition" : "表示替代藥品是否可以或應該成為配藥的一部分。在某些情況下，替代藥品必須發生，在其他情況下，替代藥品必須不發生。此區塊解釋開立處方者的意圖。如果沒有指定，可以進行替換。"
      },
      {
        "id" : "MedicationRequest.substitution.allowed[x]",
        "path" : "MedicationRequest.substitution.allowed[x]",
        "short" : "是否允許替換",
        "definition" : "如果處方開立者允許與處方不同的藥物配藥，則為真。",
        "comment" : "這個資料項目被標記為修飾用，因為無論是否允許替換，它都不能被忽略。",
        "type" : [
          {
            "code" : "boolean"
          },
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationRequestSubstitution"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActSubstanceAdminSubstitutionCode"
        }
      },
      {
        "id" : "MedicationRequest.substitution.reason",
        "path" : "MedicationRequest.substitution.reason",
        "short" : "為什麼要（不）進行替換",
        "definition" : "表示替換的原因，或為什麼必須或不必須進行替換。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationIntendedSubstitutionReason"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-SubstanceAdminSubstitutionReason"
        }
      },
      {
        "id" : "MedicationRequest.priorPrescription",
        "path" : "MedicationRequest.priorPrescription",
        "short" : "正被替換的醫令／處方",
        "definition" : "連結至與代表早期醫令相關的醫令或處方的resource",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.detectedIssue",
        "path" : "MedicationRequest.detectedIssue",
        "short" : "活動的臨床問題",
        "definition" : "表明一個或多個針對病人的較積極的或提議的臨床活動之間的實際或潛在的臨床問題；例如：藥物交互作用、重複治療、劑量警訊等。",
        "comment" : "此資料項目可包括由決策支援系統或臨床醫生發現的問題，及可能包括解決問題所採取步驟的資訊。"
      },
      {
        "id" : "MedicationRequest.eventHistory",
        "path" : "MedicationRequest.eventHistory",
        "short" : "生命週期中感興趣的事件清單",
        "definition" : "連結至Provenance resource的過去版本，或履行請求或事件resource的Provenance紀錄，其指明可能與查看當前版本resource的使用者相關的關鍵狀態之轉換或更新。",
        "comment" : "這可能不包括請求的所有版本的出處–只包括那些被認為「相關」或重要的版本。這 **必須沒有（SHALL NOT）** 包括與此resource的當前版本相關的出處。（如果此出處被認為是一個「相關」的變化，它將需要作為後續更新的一部分。在此之前，可使用_revinclude直接查詢指向此版本的出處。 所有出處（Provenances）都應有這個藥品請求請求的一些歷史版本作為對象。）",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Provenance-twcore"
            ]
          }
        ]
      }
    ]
  }
}

```
