# TW Core Medication - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Medication 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Medication-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreMedication |

 
此臺灣核心-藥品（TW Core Medication） Profile說明本IG如何進一步定義FHIR的Medication Resource以呈現藥品的詳細資料。 

## Resource Medication - 內容

這個 resource 主要被用來識別和定義開處方、配藥、給藥、以及藥品使用聲明之藥品。

### 範圍與使用

在大部分健康照護環境中，描述藥品通常涉及從一個清單中選擇一項藥品，然後將選擇的藥品的參照資訊轉達給與病人相關的 resources 或其他應用程序。經常會提供額外的藥品資訊來進行人工確認，但是藥品的完整組成和功效的詳細資訊是透過參照藥典並使用它們定義的代碼來傳達的。有時候，當需要同時識別藥品和它的包裝，例如在配製一個有特定藥品包裝的藥品時，就需要識別更多細節。也有一些情況（例如：自製配方）需要表明藥品的組成。在這些情況下，需要具體指明藥品的成分和含量，儘管 Medication resource 並不提供完整的細節。

Medication resource 允許藥品透過其藥品劑型和成分（或多個成分）以及包裝方式進行描述。藥品將包括其成分及其強度，而包裝則包括特定容器中包含的量（例如：藥片數量、體積等），比如一瓶含100粒阿莫西林500毫克膠囊（100 capsules of Amoxicillin 500mg per bottle）。

用於描述藥局在配藥時製造的複方（即時配藥或處方藥）時，可以使用 Medication resource。這種情況下會有多種成分，通常是基本化學物質（例如：氫化可的松粉），也可能包括製成品（例如：Glaxal Base）作為其他成分。

當藥品包括包裝時，可以進一步提供有關其組成的詳細資訊。包裝通常包含一個容器（例如：真空包裝盒、罐子等）以及包裝中的產品或其他包裝的清單。

Medication resource 被以下 resources 所參照：活動定義（[ActivityDefinition](https://hl7.org/fhir/R4/activitydefinition.html#ActivityDefinition)）、醫療不良事件（[AdverseEvent](https://hl7.org/fhir/R4/adverseevent.html#AdverseEvent)）、照護計畫（[CarePlan](https://hl7.org/fhir/R4/careplan.html#CarePlan)）、目錄內的條目（[CatalogEntry](https://hl7.org/fhir/R4/catalogentry.html#CatalogEntry)）、費用項目（ [ChargeItem](https://hl7.org/fhir/R4/chargeitem.html#ChargeItem)）、費用項目定義（[ChargeItemDefinition](https://hl7.org/fhir/R4/chargeitemdefinition.html#ChargeItemDefinition)）、標記（[Flag](https://hl7.org/fhir/R4/flag.html#Flag)）、群體（[Group](https://hl7.org/fhir/R4/group.html#Group)）、藥品（Medication）、給藥（[MedicationAdministration](https://hl7.org/fhir/R4/medicationadministration.html#MedicationAdministration)）、配藥或調劑藥品（[MedicationDispense](StructureDefinition-MedicationDispense-twcore.md)）、藥品知識（[MedicationKnowledge](https://hl7.org/fhir/R4/medicationknowledge.html#MedicationKnowledge)）、藥品請求（[MedicationRequest](StructureDefinition-MedicationRequest-twcore.md)）、用藥聲明（[MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)）、醫藥產品禁忌（[MedicinalProductContraindication](https://hl7.org/fhir/R4/medicinalproductcontraindication.html#MedicinalProductContraindication)）、醫藥產品適應症（[MedicinalProductIndication](https://hl7.org/fhir/R4/medicinalproductindication.html#MedicinalProductIndication)）、醫藥產品交互作用（[MedicinalProductInteraction](https://hl7.org/fhir/R4/medicinalproductinteraction.html#MedicinalProductInteraction)）、醫藥產品不良反應（[MedicinalProductUndesirableEffect](https://hl7.org/fhir/R4/medicinalproductundesirableeffect.html#MedicinalProductUndesirableEffect)）、處置（[Procedure](StructureDefinition-Procedure-twcore.md)）、供應品遞送（[SupplyDelivery](https://hl7.org/fhir/R4/supplydelivery.html#SupplyDelivery)）及供應品請求（[SupplyRequest](https://hl7.org/fhir/R4/supplyrequest.html#SupplyRequest)）

**Usages:**

* Refer to this Profile: [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md), [TW Core Medication](StructureDefinition-Medication-twcore.md), [TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md), [TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md)...Show 2 more,[TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)and[TW Core Procedure](StructureDefinition-Procedure-twcore.md)
* Examples for this Profile: [Medication/med-example](Medication-med-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Medication-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Medication-twcore.csv), [Excel](StructureDefinition-Medication-twcore.xlsx), [Schematron](StructureDefinition-Medication-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Medication-id.md)**查詢所有Medication：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Medication?_id=[id]`
`GET [base]/Medication/[id]`例子：
(1) GET [base]/Medication?_id=med-example
(2) GET [base]/Medication/med-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`code`](SearchParameter-Medication-code.md)**查詢所有Medication：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Medication?code={system|}[code]`例子：
(1) GET [base]/Medication?code=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-fda-tw|衛署藥輸字第025485號



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Medication-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Medication-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreMedication",
  "title" : "TW Core Medication",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-藥品（TW Core Medication） Profile說明本IG如何進一步定義FHIR的Medication Resource以呈現藥品的詳細資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Medication",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Medication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Medication",
        "path" : "Medication",
        "short" : "藥品的定義",
        "definition" : "此resource主要用於識別和定義藥品，以便開立處方、配藥和給藥，以及對藥品使用進行說明。"
      },
      {
        "id" : "Medication.id",
        "path" : "Medication.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的Medication紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "Medication.meta",
        "path" : "Medication.meta",
        "short" : "此Medication Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "Medication.implicitRules",
        "path" : "Medication.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "Medication.language",
        "path" : "Medication.language",
        "short" : "用以表述Medication Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "Medication.text",
        "path" : "Medication.text",
        "short" : "Medication Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "Medication.identifier",
        "path" : "Medication.identifier",
        "short" : "此藥品的業務用識別碼",
        "definition" : "此藥品的業務用識別碼",
        "comment" : "序號可被包含於一個識別碼"
      },
      {
        "id" : "Medication.code",
        "path" : "Medication.code",
        "short" : "指明這種藥品的代碼。",
        "definition" : "具體說明此藥品的一個代碼（或一組代碼），如果沒有代碼，則為文字描述。使用說明：這可以是一個標準的藥品代碼，如RxNorm、SNOMED CT、IDMP等的代碼。它也可以是一個國家或地方的處方藥代碼，可以選擇翻譯／交易（transactions）為其他代碼系統。",
        "comment" : "根據使用情境，實際由使用者（開立處方者、配藥者等）選擇的代碼將把coding.userSelected設置為true。正如coding datatype中所描述的。「如果使用者在使用者介面上選擇了特定的代碼值（例如：使用者在清單中選擇了一個項目），那麼coding可以被標記為 「userSelected」。如果存在一個使用者選擇的代碼，它是進行翻譯等的首選，其他代碼只能字面翻譯至替代的代碼系統或者較小精細度的代碼（例如：一個通用代碼用於一個供應商限定的代碼）。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationFormalRepresentation"
            }
          ],
          "strength" : "example",
          "description" : "此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-codes"
        }
      },
      {
        "id" : "Medication.code.coding",
        "path" : "Medication.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "由專門術語系統（terminology system）定義的代碼。此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。"
      },
      {
        "id" : "Medication.code.coding:fda-medication-tw",
        "path" : "Medication.code.coding",
        "sliceName" : "fda-medication-tw",
        "short" : "此為臺灣食品藥物管理署(TFDA)維護之藥品代碼，涵蓋範圍相對完整，可免費使用，可優先選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-fda-tw"
        }
      },
      {
        "id" : "Medication.code.coding:nhi-medication-tw",
        "path" : "Medication.code.coding",
        "sliceName" : "nhi-medication-tw",
        "short" : "此為中央健康保險署(NHI)維護之藥品代碼，主要針對申報使用，更新頻率相對頻繁，可免費使用，可依情境選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-nhi-tw"
        }
      },
      {
        "id" : "Medication.code.coding:nhi-medication-ch-herb-tw",
        "path" : "Medication.code.coding",
        "sliceName" : "nhi-medication-ch-herb-tw",
        "short" : "此為中央健康保險署(NHI)維護之中藥藥品代碼，主要針對申報使用，更新頻率相對頻繁，可免費使用，可依情境選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "min" : 0,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/nhi-medication-ch-herb-tw"
        }
      },
      {
        "id" : "Medication.code.coding:rxnorm-medication-us-core",
        "path" : "Medication.code.coding",
        "sliceName" : "rxnorm-medication-us-core",
        "short" : "RxNorm為美國Unified Medical Language System®中的藥品代碼，取得UMLS®授權即可免費使用，可依情境選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-rxnorm-tw"
        }
      },
      {
        "id" : "Medication.code.coding:atc-medication-code",
        "path" : "Medication.code.coding",
        "sliceName" : "atc-medication-code",
        "short" : "ATC代碼的版權為世界衛生組織（WHO）Collaborating Centre for Drug Statistics Methodology，可免費使用，可依情境選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medcation-atc-tw"
        }
      },
      {
        "id" : "Medication.code.coding:snomedct-medication-codes",
        "path" : "Medication.code.coding",
        "sliceName" : "snomedct-medication-codes",
        "short" : "此為SNOMED CT代碼，若機構已有購買相關授權，亦可使用。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-codes"
        }
      },
      {
        "id" : "Medication.code.text",
        "path" : "Medication.code.text",
        "short" : "概念的文字表示法",
        "definition" : "輸入資料的使用者所見／所選／所說的人類可讀文字表述，和（或）其代表使用者的預期含義。",
        "comment" : "很多時候，此文字表述與其中一個代碼的顯示名稱相同。",
        "requirements" : "專門術語中的代碼並不總是能捕捉人類使用的細微差別的正確意義，或者根本就沒有合適的代碼；這些情況下，文字表述被用來捕捉來源的全部意義。",
        "mustSupport" : true
      },
      {
        "id" : "Medication.status",
        "path" : "Medication.status",
        "short" : "active ｜ inactive ｜ entered-in-error",
        "definition" : "此代碼指明藥品是否使用中",
        "comment" : "此狀態是為了識別當地系統中的藥品是否在藥物資料庫或存貨為有效使用狀態。例如：一個藥局系統可能為一個複方產品 「ABC醫院專用藥膏」建立一個新的藥品檔案紀錄，狀態為有效。在未來的某個時間點，可能決定此藥品紀錄在建立時出現了錯誤，於是狀態被改為 「輸入錯誤 」。這種狀態不是為了說明某種藥品是否屬於某個特定的處方集。藥品紀錄有可能被多個處方集或編錄集所參照，每筆紀錄都會有一個單獨的狀態。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationStatus"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-status|4.0.1"
        }
      },
      {
        "id" : "Medication.manufacturer",
        "path" : "Medication.manufacturer",
        "short" : "此藥品的製造商",
        "definition" : "描述藥品製造商的詳細訊息。這並不意味著代表藥品的經銷商。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Medication.form",
        "path" : "Medication.form",
        "short" : "powder ｜ tablets ｜ capsule +",
        "definition" : "描述藥品的劑型：藥粉、錠劑、膠囊。",
        "comment" : "當藥品被MedicationRequest參照時，這是開立處方的劑型。當MedicationDispense中參用Medication時，這是配藥的劑型。當在MedicationAdministration中引用Medication時，這是給藥的劑型。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationForm"
            }
          ],
          "strength" : "example",
          "description" : "此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-form-codes"
        }
      },
      {
        "id" : "Medication.form.coding",
        "path" : "Medication.form.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "powder ｜ tablets ｜ capsule + 此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
        "min" : 1
      },
      {
        "id" : "Medication.form.coding:v3-orderableDrugForm",
        "path" : "Medication.form.coding",
        "sliceName" : "v3-orderableDrugForm",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/v3-orderableDrugForm"
        }
      },
      {
        "id" : "Medication.form.coding:snomed-sct-form-codes",
        "path" : "Medication.form.coding",
        "sliceName" : "snomed-sct-form-codes",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-form-codes"
        }
      },
      {
        "id" : "Medication.form.text",
        "path" : "Medication.form.text",
        "mustSupport" : true
      },
      {
        "id" : "Medication.amount",
        "path" : "Medication.amount",
        "short" : "每包裝的藥品數量或容量",
        "definition" : "每包裝產品中藥品的具體數量或容量。例如：當指定一個具有相同強度的藥品時（例如：每毫升注射用胰島素100單位），該屬性提供了每包裝數量與容量的附加說明（例如：3mL、10mL等）。"
      },
      {
        "id" : "Medication.ingredient",
        "path" : "Medication.ingredient",
        "short" : "有使用或沒有使用的藥品成份",
        "definition" : "指明產品中的特定成份",
        "comment" : "成份不需要是一個完整的清單。如果沒有具體說明某種成份，這並不表明有使用或沒使用某種成份。如果一個成份被具體說明，並不意味著所有的成份都被具體說明。可以同時具體說明有沒有使用及有使用的成份。"
      },
      {
        "id" : "Medication.ingredient.item[x]",
        "path" : "Medication.ingredient.item[x]",
        "short" : "實際的成份或內容物",
        "definition" : "實際成份—不是一種物質（單一成份）就是一種藥品的另一種藥品。",
        "requirements" : "此成份可能是指一種物質（例如：阿莫西林）或另一種藥品（例如：複方葛蘭素史克）。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Medication-twcore",
              "http://hl7.org/fhir/StructureDefinition/Substance"
            ]
          }
        ]
      },
      {
        "id" : "Medication.ingredient.isActive",
        "path" : "Medication.ingredient.isActive",
        "short" : "有效成份指標",
        "definition" : "說明此成份是否會影響藥物的治療作用",
        "requirements" : "True表示此成份會影響藥物的治療作用（意即：active），False表示此成份不影響藥物的治療作用（意即：inactive）。"
      },
      {
        "id" : "Medication.ingredient.strength",
        "path" : "Medication.ingredient.strength",
        "short" : "所含成份的劑量",
        "definition" : "指明此藥品中有多少（或多少）項目。例如：每錠250毫克，這表示為一個比率，分子為250毫克，分母為1錠。"
      },
      {
        "id" : "Medication.batch",
        "path" : "Medication.batch",
        "short" : "關於包裝藥品的細節",
        "definition" : "只適用於包裝（不是產品）的資訊"
      },
      {
        "id" : "Medication.batch.lotNumber",
        "path" : "Medication.batch.lotNumber",
        "short" : "藥品的批號",
        "definition" : "藥品的批號資訊"
      },
      {
        "id" : "Medication.batch.expirationDate",
        "path" : "Medication.batch.expirationDate",
        "short" : "有效期限",
        "definition" : "此批號藥品之有效期限"
      }
    ]
  }
}

```
