# TW Core Media - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Media 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Media-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreMedia |

 
此臺灣核心-多媒體（TW Core Media） Profile說明本IG如何進一步定義FHIR的Media Resource以呈現多媒體的詳細資料。 

## Resource Media - 內容

Media resource 涵蓋了在健康照護中獲取或使用的影像、影片和音檔。這些內容可能直接嵌入或透過直接參照提供。

### 範圍與使用

**試用階段注意事項:** 國際HL7「醫令和檢驗檢查工作小組」想讓大家知道，需要附加資料類型的檢驗檢查現在應該用 Media resource 來記錄，而不是用Observation。為了讓 Media resource 能更好地和[檢驗檢查（Observation）](StructureDefinition-Observation-laboratoryResult-twcore.md)以及工作流[事件（event）](https://hl7.org/fhir/R4/event.html)模式結合，他們對 Media resource 做了幾個重要的調整：

1. 新增了[`partOf`](https://hl7.org/fhir/R4/media-definitions.html#Media.partOf)和[`issued`](https://hl7.org/fhir/R4/media-definitions.html#issued)資料項目。
1. 把必填的`type`改成了 選填的類別（`category`），並將`subtype`資料項目更名為[儀器（`modality`）](StructureDefinition-Media-twcore-definitions.md#Media.modality)。
1. 為`subject`、`operator`和`basedOn`元素增加了更多參照對象。
1. 加入了幾個標準的[事件之擴充資料項目（`event extensions`）](https://hl7.org/fhir/R4/media-profiles.html#extensions)。

Media resource 包括影像、影片和音檔，是醫療過程中不可或缺的一部分。常見的使用情境包括：

* 記錄診斷或照護過程的影像和影片。
* 診斷報告中的影像。

### 界限與關聯

這個 Media resource 專門記錄那些以音檔、影片或影像作為結果的檢驗檢查[（Observation）](StructureDefinition-Observation-laboratoryResult-twcore.md)。這種格式的資料優先使用此 resource 記錄，是因為它能提供讓我們理解這些資料的重要背景資訊（例如： metadata）。但要注意，有時候在一些舊的系統中，這類的多媒體資料可能會被記錄在 Observation 裡。

Media resource 可以包括用DICOM格式儲存的醫學影像。這些影像也可以透過 ImagingStudy resource 來存取，這個 resource 能直接連結到 WADO-RS 伺服器上的影像。

使用 WADO-RS 框架來呈現這些影像是首選的方法，因為它可能包括了根據 DICOM 標準加上的註釋和顯示參數。

另一方面，當 WADO-RS 服務無法使用時，Media resource 也提供了一個穩定的方式來傳送影像。所以，醫學影像同樣可以在 Media resource 表示，但`Media.content.url`應該指向一個可以存取影像的WADO-RS服務。

這個 resource 被醫療不良事件[（AdverseEvent）](https://hl7.org/fhir/R4/adverseevent.html#AdverseEvent)、臨床臆斷[（ClinicalImpression）](https://hl7.org/fhir/R4/clinicalimpression.html#ClinicalImpression)、設備使用聲明[（DeviceUseStatement）](https://hl7.org/fhir/R4/deviceusestatement.html#DeviceUseStatement)、診斷報告[（DiagnosticReport）](StructureDefinition-DiagnosticReport-twcore.md)、影像檢查[（ImagingStudy）](StructureDefinition-ImagingStudy-twcore.md)、藥品知識[（MedicationKnowledge）](https://hl7.org/fhir/R4/medicationknowledge.html#MedicationKnowledge)和檢驗檢查[（Observation）](StructureDefinition-Observation-laboratoryResult-twcore.md)等多個其他FHIR resources 參照。

#### 實作注意事項

Media resource 包含幾個日期/時間的資料項目：

* `Media.created[x]` - 是指拍攝或錄製的具體日期（或時間），或者是進行拍攝或錄製的時間段。
* `Media.duration` - 表示多媒體內容的持續時間。如果在錄製過程中有暫停，這個持續時間可能會與實際錄製的時間段`Media.createdPeriod`有所不同。
* [`Media.content.creation`](https://hl7.org/fhir/R4/datatypes-definitions.html#Attachment.creation)- 這個時間應該與`Media.created[x]`保持一致，但如果音檔有被部分剪輯或編輯，時間上可能會有差異。

這個resource允許透過`attachment.data` 直接嵌入影像或影片。不過，一般推薦的做法是使用`attachment.url`指向一個 Binary resource。這樣做的原因是伺服器通常能夠把 Binary resources 儲存在專門設計來存放可能很大的文件的儲庫中，這樣更加合適。

**Usages:**

* Refer to this Profile: [TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md), [TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md), [TW Core Observation Blood Pressure](StructureDefinition-Observation-bloodPressure-twcore.md), [TW Core Observation BMI](StructureDefinition-Observation-bmi-twcore.md)...Show 16 more,[TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md),[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Laboratory Result](StructureDefinition-Observation-laboratoryResult-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Pregnancy Status](StructureDefinition-Observation-pregnancy-status-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md)and[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md)
* Examples for this Profile: [Media/media-example](Media-media-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Media-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Media-twcore.csv), [Excel](StructureDefinition-Media-twcore.xlsx), [Schematron](StructureDefinition-Media-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Media-id.md)**查詢所有Media：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Media?_id=[id]`
`GET [base]/Media/[id]`例子：
(1) GET [base]/Media?_id=media-example(2) GET [base]/Media/media-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`status`](SearchParameter-Media-status.md)**查詢所有Media：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Media?status=[code]`例子：
(1) GET [base]/Media?status=completed
1. **建議應該（SHOULD）**支援透過查詢參數**[`subject`](SearchParameter-Media-subject.md)**查詢所有Media：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Media?subject={Type/}[id]`例子：
(1) GET [base]/Media?subject=Patient/pat-example



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Media-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Media-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreMedia",
  "title" : "TW Core Media",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-多媒體（TW Core Media） Profile說明本IG如何進一步定義FHIR的Media Resource以呈現多媒體的詳細資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "dicom",
      "uri" : "http://nema.org/dicom",
      "name" : "DICOM Tag Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Media",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Media",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Media",
        "path" : "Media",
        "short" : "健康照護中獲取或使用的影像、影片或音檔，實際內容可能置於行內或透過直接參照提供。",
        "definition" : "健康照護中獲取或使用的影像、影片或音檔，實際內容可能置於行內或透過直接參照提供。"
      },
      {
        "id" : "Media.id",
        "path" : "Media.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的Media紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "Media.meta",
        "path" : "Media.meta",
        "short" : "此Media Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "Media.implicitRules",
        "path" : "Media.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "Media.language",
        "path" : "Media.language",
        "short" : "用以表述Media Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "Media.text",
        "path" : "Media.text",
        "short" : "Media Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則**建議應該（SHOULD）**有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "Media.identifier",
        "path" : "Media.identifier",
        "short" : "影像的識別碼",
        "definition" : "影像相關的識別碼，可能包括影像本身的識別碼，以及用於其收集上下文（例如：系列識別碼）和其他工作流程識別碼，例如存取號等。",
        "comment" : "識別碼的標籤和使用可以用來確定它是什麼類型的識別碼"
      },
      {
        "id" : "Media.basedOn",
        "path" : "Media.basedOn",
        "short" : "導致產生此多媒體的程序",
        "definition" : "由創建此多媒體文件而完全或部分完成的程序。例如，如果多媒體文件是一張X光影像，那麼這個程序可能是一次X光檢查。",
        "requirements" : "此功能可追蹤事件的授權情況，並追蹤建議或推薦是否已執行。"
      },
      {
        "id" : "Media.partOf",
        "path" : "Media.partOf",
        "short" : "參照事件的一部分",
        "definition" : "這個特定事件是更大事件的一部分，或者是一個步驟。",
        "comment" : "不應該使用此屬性將事件與一次就診關聯 - 請使用 Media.encounter 來完成這個目的。\n\n[對於事件 resource，所允許的參照resources可能會根據需要進行調整。]",
        "requirements" : "舉例來說，藥物管理可以是某個程序的一部分，而這個程序則可能是某個觀察過程的一部分等等。"
      },
      {
        "id" : "Media.status",
        "path" : "Media.status",
        "definition" : "多媒體的目前狀態",
        "comment" : "可以在[[event.html#statemachine | 事件模式]]文件中找到一個標準的狀態轉換圖。\n\n「未知」不代表「其他」狀態 - 必須使用其中一個已定義的狀態，「未知」用於表示不確定當前狀態。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MediaStatus"
            }
          ],
          "strength" : "required",
          "description" : "代表事件生命週期階段的代碼；應填入所綁定值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/event-status|4.0.1"
        }
      },
      {
        "id" : "Media.type",
        "path" : "Media.type",
        "short" : "將多媒體分類為影像、影片或音檔",
        "definition" : "一個代碼，用於分類多媒體是否為影像、影片或音檔或其他多媒體類別。",
        "requirements" : "用於篩選取得和顯示的檢驗檢查結果",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/media-type"
        }
      },
      {
        "id" : "Media.modality",
        "path" : "Media.modality",
        "short" : "取得影像的設備/過程",
        "definition" : "在醫學影像領域中，描述多媒體類型（即影像）的細節時重要的幾個方面。通常，這包括影像是如何被獲取的，比如使用了什麼設備或技術。如果這些影像是從DICOM系統中獲得的，並且被存儲在一種稱為「Media resource」的格式中，那麼這個過程中用到的特定技術或設備類型被稱為「儀器(modality)」。儀器是指影像如何被產生，比如CT掃描、MRI掃描或X光等。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MediaModality"
            }
          ],
          "strength" : "example",
          "description" : "可參考MediaModality代碼表，但此代碼表只是針對這個欄位的一個可能值的示例，不預期也不鼓勵使用者一定要使用此代碼表的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/media-modality"
        }
      },
      {
        "id" : "Media.view",
        "path" : "Media.view",
        "short" : "影像視圖，從不同的角度拍攝醫學影像，例如：側位（Lateral，從旁邊看）或前後部位（Antero-posterior，從前面或後面看）",
        "definition" : "影像視圖的名稱，例如：側位或前後部位（AP）。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/media-view"
        }
      },
      {
        "id" : "Media.subject",
        "path" : "Media.subject",
        "short" : "多媒體紀錄的對象是誰或什麼？",
        "definition" : "多媒體紀錄的對象是誰或什麼？",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Media.encounter",
        "path" : "Media.encounter",
        "short" : "與此Media相關的就醫事件（Encounter）",
        "definition" : "此多媒體是在什麼樣的就醫過程中產生或被使用的。例如：有一次具體的就診活動（比如病人因為某種疼痛去看醫生），在這次就醫中產生了這份X光影像，從而為這份影像提供了相關的就醫背景或情境。",
        "comment" : "這通常會是多媒體產生時所在的就醫情境",
        "requirements" : "將多媒體與 「就醫」背景連結起來",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Media.created[x]",
        "path" : "Media.created[x]",
        "short" : "Media被收集的時間",
        "definition" : "多媒體收集的日期和時間"
      },
      {
        "id" : "Media.issued",
        "path" : "Media.issued",
        "short" : "此版本提供的日期/時間",
        "definition" : "當一份多媒體資料（比如影像、文件等）經過專業人士的審查之後，確定無誤或達到一定標準，便會選擇一個時間點，把這份經過審查的多媒體版本提供給其他醫療專業人員或相關人士使用。這個「日期和時間」就是指這份多媒體資料被正式認可並開放給相關人士使用的具體時刻。",
        "comment" : "它可能與resource本身的最後更新時間相同。但對於那些確實需要對某些更新進行審查和驗證的Observations，如果更新是非臨床顯著的，則不需要對新版本進行再次審查和驗證，因此它也可能與resource本身的最後更新時間不同。"
      },
      {
        "id" : "Media.operator",
        "path" : "Media.operator",
        "short" : "產生影像的人",
        "definition" : "負責收集影像的人",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Media.reasonCode",
        "path" : "Media.reasonCode",
        "short" : "為什麼會進行這個事件？",
        "definition" : "以編碼或文字形式描述了事件發生的原因",
        "comment" : "文字形式的原因可以使用reasonCode.text來取得",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/procedure-reason"
        }
      },
      {
        "id" : "Media.bodySite",
        "path" : "Media.bodySite",
        "short" : "接受檢驗檢查的身體部位",
        "definition" : "表示在受檢者身上進行檢查的部位（即目標部位）",
        "comment" : "只有在Observation.code中發現的代碼中沒有隱含的情況下才使用。在許多系統中，這可能被表示為一個相關的觀察，而不是一個內聯元件。如果用例要求將BodySite作為一個單獨的resource來處理（例如，單獨識別和跟蹤），那麼就使用標準擴展 bodySite。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      },
      {
        "id" : "Media.deviceName",
        "path" : "Media.deviceName",
        "short" : "設備/製造商的名稱",
        "definition" : "用來進行錄製的設備名稱/製造商"
      },
      {
        "id" : "Media.device",
        "path" : "Media.device",
        "short" : "影像、影片、音檔的補捉設備。",
        "definition" : "用來收集多媒體的設備",
        "comment" : "如果需要對設備進行進一步的類型化，應該使用擴展。用於支援收集多媒體的次要設備可以使用擴展或通過Observation.related資料項目表示。"
      },
      {
        "id" : "Media.height",
        "path" : "Media.height",
        "short" : "以像素為單位的影像高度（影像/影像）",
        "definition" : "以像素為單位的影像高度（影像/影像）。"
      },
      {
        "id" : "Media.width",
        "path" : "Media.width",
        "short" : "以像素為單位的影像寬度（影像/影像）",
        "definition" : "以像素為單位的影像寬度（影像/影像）。"
      },
      {
        "id" : "Media.frames",
        "path" : "Media.frames",
        "short" : "> 1 的影格（影像）。",
        "definition" : "這段話講述的是在某些情況下，一份影像或文件可能包含多個獨立的影像影格(frame)，而這些影格是組成整個文件的部分。例如：在醫療影像、動畫GIF圖像或多頁傳真文件中，可能會有多影格影像。如果一份文件或影像實際上包含多於一個的影像影格，那麼它需要標記一個具體的數值來表示這些影格的數量。這樣做的目的是為了讓使用這份文件或影像的軟體知道，它需要使用一種能夠顯示或處理多個影像影格的特殊工具或功能，稱為渲染小部件(rendering widget）。簡單來說，如果一個文件包含多個影像影格，那麼需要透過特定的方式告知相關的軟體，以便正確顯示或處理這些影格。",
        "comment" : "如果沒有提供幀的數量，該值可能是未知的。除非明確說明，否則應用程式不應假定只有一個框架。"
      },
      {
        "id" : "Media.duration",
        "path" : "Media.duration",
        "short" : "以秒為單位的長度（音檔/影片）。",
        "definition" : "錄製的持續時間，以秒為單位 - 對於音檔/影片。",
        "comment" : "如果記錄被暫停，持續時間可能與發生時間不同。"
      },
      {
        "id" : "Media.content",
        "path" : "Media.content",
        "short" : "實際的多媒體 - 參照或資料。",
        "definition" : "多媒體的實際內容 -內置或直接參照多媒體原始檔案。",
        "comment" : "推薦的內容類別型：image/jpeg, image/png, image/tiff, video/mpeg, audio/mp4, application/dicom。Application/dicom可以包含傳輸語法作為一個參數。對於涵蓋一段時期的多媒體（視頻/聲音），content.creationTime是結束時間。創建時間用於跟蹤、組織版本和查詢。"
      },
      {
        "id" : "Media.note",
        "path" : "Media.note",
        "short" : "對此Media的意見",
        "definition" : "執行者、對象或其他參與者對Media的意見",
        "comment" : "不能用於觀察、結論等。而是使用基於多媒體/影像研究resource的觀察。"
      }
    ]
  }
}

```
