# TW Core Location - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Location 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreLocation |

 
此臺灣核心-地點（TW Core Location） Profile說明本IG如何進一步定義FHIR的Location Resource以呈現地點的詳細資料。 

## Resource Location - 內容

這是關於一個提供服務的具體位置的描述，包括那裡如何存放、查找、包含或安置資源和人員的資訊。

### 範圍與使用

地點（Location）既包括臨時的地方（像是一個沒有提前被指定或批准就用來提供醫療服務的地方），也包括那些被正式確定用於特定目的的地方。這些地點既可以是私有的，也可以是公有的，有的可以移動，有的是固定不動的，大小也各不相同，從小型的冷凍箱到整座醫院大樓或停車場都是。

地點的例子有：

* 建築物、病區、走廊、房間或床位
* 流動診所
* 冷凍箱、孵育器
* 車輛或升降機
* 家裡、小屋或車庫
* 道路、停車位、公園
* 救護車（通稱）
* 救護車（具體指某一輛）
* 病人的家（通稱）
* 行政管轄區

這裡提到的地點位置不是指病人身上發生了什麼（比如病人的腿斷了那裡），而是指病人腿斷發生時的地點（比如在遊樂場）。

### 界限與關聯

地點（Location）和機構（Organization）是兩種密切相關的resources，但它們的用途有所不同。地點專注於描述具體的實體空間，這些空間由機構管理或運營。相比之下，機構更多地代表組織結構上的概念層次，例如：管理一間病房。

在某些情況下，地點可以不需要具體的地址就有效，例如：透過地理編碼描述偏遠地區，或由裝置記錄的位置。那些模式為「`kind`」的地點通常也不會有地址，因為它們只是表示一種地點的類型，但如果這些地點有一個具體地址可以找到，那麼也可以記錄地址。

地點還可以用來描述一個管轄區域，這可能是基於實體邊界和其他特定因素組合而定的一個範圍，例如：

* 國家 - 涵蓋全國的社區或聯邦政府（如：衛生部/衛生福利部）；
* 省份或州 （社區或政府）；
* 業務 （跨越整個企業）；
* 業務範圍 - 如疾病管制署（CDC）或食品藥物管理署（FDA）；
* 業務部門 - 如英國的藥局。

這個 resource 被多個其他 FHIR resources 參照，包括[使用上下文/情境（UsageContext）](https://hl7.org/fhir/R4/metadatatypes.html#UsageContext)、[帳戶（Account）](https://hl7.org/fhir/R4/account.html#Account)、[活動定義（ActivityDefinition）](https://hl7.org/fhir/R4/activitydefinition.html#ActivityDefinition)、[醫療不良事件（AdverseEvent）](https://hl7.org/fhir/R4/adverseevent.html#AdverseEvent)、[預約（Appointment）](https://hl7.org/fhir/R4/appointment.html#Appointment)、[預約回應（AppointmentResponse）](https://hl7.org/fhir/R4/appointmentresponse.html#AppointmentResponse)等。

### 註釋（Notes）

* 多個機構（Organization）或健康照護服務提供者（Practitioner）可能在同一個地點（Location）提供服務。這些參照資訊不會被保存在Location resource中，而是可以在[機構（Organization）](StructureDefinition-Organization-twcore.md)和[健康照護服務提供者（Practitioner）](StructureDefinition-Practitioner-twcore.md)的模型中找到。
* 地點可以範圍從整棟建築到小櫃子；使用地點的partOf資料項目可以將較小的地點與包含它的較大地點關聯起來。
* 地點的位置（`Location.position`）使用與Google Earth的KML文件相同的語法、基準和參照系統表示，詳見[Google/OGS的KML](http://www.opengeospatial.org/standards/kml)標準。

#### Location Mode

`Location.mode`資料項目可以用來指示一個 Location resource 是代表一個特定的（可能可識別的）地點（「`instance`」），還是某類地點（「`kind`」）。特別是在涉及醫令、排程、計劃和定義的時，可能會參照處於「`kind`」mode的地點。在這些領域，往往不需要指向一個具體的地點，而是指向某類地點。這在計劃時尤其明顯，比如我們需要為一位病人分配「一間隔離室」，或者在特定時間派遣「一輛救護車」。在這些情況下，沒有必要確切識別哪一個隔離室或哪一輛救護車被分配，只需指出是一種地點的「`kind`」就足夠了。

需要注意的是：當你有一個具體的地點參與，但缺少該地點的具體識別資訊時，應該使用「`instance`」mode，即使無法提供該地點的完整識別資訊。這是因為「`instance`」模式用於表示一個具體的、特定的地點實例，即使某些具體細節（如`identifier`）未知。

而「kind」 mode則不應用於試圖填補關於具體地點實例缺失資訊的情況，而是用於表示某類地點，即一個通用類別或地點的類型，而不是指向一個具體的、可識別的單一地點。

所以，如果我們知道某個具體事件（如病人乘救護車到達）涉及一個具體的地點實例，但我們不知道是哪一輛救護車，我們仍然應該使用「instance」mode並嘗試提供盡可能多的資料，而不是使用「`kind`」mode。「`kind`」是用於當我們需要參用一個廣泛的地點類別，而不是特定的地點實例時。

當mode為「`instance`」時，一些資料項目才適用；當mode為「`kind`」時以下這些資料項目通常不使用：**（不過，如果某些資訊對於描述某類地點來說仍然有意義，即使它是特定於某個範圍的通用而非全球通用的，例如：代表Burgers Medical Centre的某一輛救護車，這時這些資料項目還是可以被包含進來的。）**

* 地點的唯一識別碼（`Location.identifier`）
* 地點的聯絡方式（`Location.telecom`）
* 地點的地址（`Location.address`）
* 地點的位置（`Location.position`）
* 地點的狀態（`Location.status`）
* 管理地點的機構（`Location.managingOrganization`）

**Usages:**

* Refer to this Profile: [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md), [TW Core Composition](StructureDefinition-Composition-twcore.md), [TW Core Implantable Device](StructureDefinition-Device-twcore.md), [TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md)...Show 14 more,[TW Core Encounter](StructureDefinition-Encounter-twcore.md),[TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md),[TW Core Immunization](StructureDefinition-Immunization-twcore.md),[TW Core Location](StructureDefinition-Location-twcore.md),[TW Core Media](StructureDefinition-Media-twcore.md),[TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation Screening Assessment](StructureDefinition-Observation-screening-assessment-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core PractitionerRole](StructureDefinition-PractitionerRole-twcore.md),[TW Core Procedure](StructureDefinition-Procedure-twcore.md),[TW Core Provenance](StructureDefinition-Provenance-twcore.md),[TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)and[TW Core Specimen](StructureDefinition-Specimen-twcore.md)
* Examples for this Profile: [衛生福利部臺北醫院耳鼻喉科](Location-loc-ent-example.md), [衛生福利部臺北醫院急診室](Location-loc-er-example.md), [衛生福利部臺北醫院X光室](Location-loc-hrad-example.md), [明捷眼科診所](Location-loc-oph-example.md) and [第二藥局](Location-loc-pharm-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Location-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Location-twcore.csv), [Excel](StructureDefinition-Location-twcore.xlsx), [Schematron](StructureDefinition-Location-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Location-id.md)**查詢所有Location：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Location?_id=[id]`
`GET [base]/Location/[id]`例子：
(1) GET [base]/Location?_id=loc-ent-example
(2) GET [base]/Location/loc-ent-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`address`](SearchParameter-Location-address.md)**查詢所有Location：
([如何透過string查詢](http://hl7.org/fhir/R4/search.html#string))
`GET [base]/Location?address=[string]`例子：
(1) GET [base]/Location?address=新北市
1. **建議應該（SHOULD）**支援透過查詢參數**[`name`](SearchParameter-Location-name.md)**查詢所有Location：
([如何透過string查詢](http://hl7.org/fhir/R4/search.html#string))
`GET [base]/Location?name=[string]`例子：
(1) GET [base]/Location?name=衛生福利部臺北醫院



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Location-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreLocation",
  "title" : "TW Core  Location",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-地點（TW Core  Location） Profile說明本IG如何進一步定義FHIR的Location Resource以呈現地點的詳細資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Location",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Location",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Location",
        "path" : "Location",
        "short" : "用於描述一個實體地點的詳細資訊和位置資訊",
        "definition" : "提供服務的實體地點的詳細和位置資訊，包括可以儲存、查找、容納或安置 resources和參與者的地點的資訊。"
      },
      {
        "id" : "Location.id",
        "path" : "Location.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的Location紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "Location.meta",
        "path" : "Location.meta",
        "short" : "此Location Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "Location.implicitRules",
        "path" : "Location.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "Location.language",
        "path" : "Location.language",
        "short" : "用以表述Location Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "Location.text",
        "path" : "Location.text",
        "short" : "Location Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "Location.identifier",
        "path" : "Location.identifier",
        "short" : "地點的唯一識別號",
        "definition" : "這是唯一的識別號，用來幫助使用者識別該地點",
        "requirements" : "機構會在註冊檔中給地點貼上標籤，我們需要記錄並追蹤這些被標記的地點。"
      },
      {
        "id" : "Location.status",
        "path" : "Location.status",
        "definition" : "這裡的狀態屬性是指 resource 是否一般可用，而不是指它當前的具體狀態。當前的具體狀態可能會由 operationStatus 作描述，或者如果這個地點設有排程或時段的話，則由這些排程或時段來描述。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "LocationStatus"
            }
          ],
          "strength" : "required",
          "description" : "地點的狀態，指明該地點是否目前正在使用中；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/location-status|4.0.1"
        }
      },
      {
        "id" : "Location.operationalStatus",
        "path" : "Location.operationalStatus",
        "short" : "地點的運營狀態（通常僅適用於床位 / 房間）",
        "definition" : "運營狀態主要描述與床位相關的運營情況（但也可以用於房間、單位、椅子等，例如：隔離區或透析椅）。這通常包括床位是否受到污染、需要房間清潔，或者正在進行維修等情況。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "OperationalStatus"
            }
          ],
          "strength" : "preferred",
          "description" : "鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0116"
        }
      },
      {
        "id" : "Location.name",
        "path" : "Location.name",
        "short" : "人們使用的地點名稱",
        "definition" : "人們常用的地點名稱。不需要是唯一的。",
        "comment" : "如果某地點的名稱發生變更，可以考慮將舊名稱放入別名(alias)資料項目，這樣在查詢時仍然可以找到此地點。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Location.alias",
        "path" : "Location.alias",
        "short" : "這是一份地點過去或現在所使用的其他名稱的清單",
        "definition" : "這是一份地點過去或現在所使用的其他名稱的清單",
        "comment" : "別名或過去的名稱並不附帶具體的日期，因為這不是用來記錄名稱使用的時間。其主要目的是幫助查詢，讓人們用舊名稱也能找到對應的地點。",
        "requirements" : "隨著時間的流逝，地點和機構會有很多變化，它們可能會有不同的名稱。在查詢資料時，知道一個地點之前的名稱可能會很有幫助。"
      },
      {
        "id" : "Location.description",
        "path" : "Location.description",
        "short" : "關於地點的額外資訊，除了名稱之外，還可以提供更多的細節來幫助識別這個地點。",
        "definition" : "對地點的描述，可以幫助人們找到或者識別這個地點。",
        "requirements" : "人們需要額外資訊來確保找到的是正確的地點"
      },
      {
        "id" : "Location.mode",
        "path" : "Location.mode",
        "definition" : "表明這個 resource 實例是指一個具體的地點，還是指一種地點的類別。",
        "comment" : "之所以將此資料項目標記為修飾用(modifier)，是因為地點是否屬於某一類的地點類別會改變其使用和理解方式。",
        "requirements" : "當在排程或下醫令中使用Location resource時，我們需要能夠參照某類地點，而不是一個具體的地點。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "LocationMode"
            }
          ],
          "strength" : "required",
          "description" : "表明為一個地點或是一個地點的類別；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/location-mode|4.0.1"
        }
      },
      {
        "id" : "Location.type",
        "path" : "Location.type",
        "short" : "執行的功能類型",
        "definition" : "指明此地點執行的功能類型",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ServiceDeliveryLocationRoleType"
        }
      },
      {
        "id" : "Location.telecom",
        "path" : "Location.telecom",
        "short" : "地點的聯絡細節",
        "definition" : "此地點提供的通訊設備聯絡方式。這可能包括電話號碼、傳真號碼、手機號碼、電子郵件地址和網站。",
        "mustSupport" : true
      },
      {
        "id" : "Location.telecom.system",
        "path" : "Location.telecom.system",
        "definition" : "聯絡方式的通訊形式－需要什麼通訊系統進行聯絡",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ContactPointSystem"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/contact-point-system|4.0.1"
        }
      },
      {
        "id" : "Location.telecom.value",
        "path" : "Location.telecom.value",
        "short" : "實際的聯絡方式之細節",
        "definition" : "實際的聯絡方式之細節，針對指定的通訊系統提供有意義的形式（電話號碼或是電子郵件位址）",
        "comment" : "額外的文字資料，例如電話分機號碼、或關於聯絡人的說明，有時也包括於此值。",
        "requirements" : "需支援非嚴格格式控制之舊有號碼",
        "mustSupport" : true
      },
      {
        "id" : "Location.telecom.use",
        "path" : "Location.telecom.use",
        "short" : "home | work | temp | old | mobile",
        "definition" : "確定聯絡方式的用途",
        "comment" : "應用程式可以假定一個聯絡方法是目前使用中，除非它明確說它是暫時的或舊的。",
        "requirements" : "需要追蹤此人使用這種聯絡的方式，使用者可以選擇適合他們用途的聯絡方式。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ContactPointUse"
            }
          ],
          "strength" : "required",
          "description" : "此聯絡方式的用途；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/contact-point-use|4.0.1"
        }
      },
      {
        "id" : "Location.telecom.rank",
        "path" : "Location.telecom.rank",
        "short" : "具體說明偏好的使用順序（1=最高優先順序）",
        "definition" : "具體說明使用一組聯繫方式的優先順序，較小排名序位的聯絡方式比較大排名序位的聯絡方式之序位還要前面。",
        "comment" : "請注意，排名序位沒有一定要遵循聯絡方式在實例中呈現的順序。"
      },
      {
        "id" : "Location.telecom.period",
        "path" : "Location.telecom.period",
        "short" : "此聯絡方式的使用效期",
        "definition" : "此聯絡方式的使用效期",
        "mustSupport" : true
      },
      {
        "id" : "Location.address",
        "path" : "Location.address",
        "short" : "實體地點",
        "definition" : "實體地點",
        "comment" : "額外的地址應使用另一個Location resource 實例或透過 Organiztion 進行記錄",
        "requirements" : "如果可以訪問地點，我們需要記錄其地址。",
        "type" : [
          {
            "code" : "Address",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Address-tw"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Location.physicalType",
        "path" : "Location.physicalType",
        "short" : "絕對的地理位置",
        "definition" : "地點的實體形態，如建築物、房間、車輛、道路。",
        "requirements" : "為了在查詢中顯示相關地點，我們需要對地點進行分類。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "PhysicalType"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/location-physical-type"
        }
      },
      {
        "id" : "Location.position",
        "path" : "Location.position",
        "short" : "絕對地理位置",
        "definition" : "地點的絕對地理位置，使用 WGS84 基準表示（這與 KML 中使用的坐標系相同）。",
        "requirements" : "對於行動應用和自動導航來說，需要知道地點的確切位置。"
      },
      {
        "id" : "Location.position.longitude",
        "path" : "Location.position.longitude",
        "short" : "以 WGS84 為基準的經度",
        "definition" : "經度，值域和解釋與 KML 中經度資料項目文字表述相同（見下文註釋）。"
      },
      {
        "id" : "Location.position.latitude",
        "path" : "Location.position.latitude",
        "short" : "以 WGS84 為基準的緯度",
        "definition" : "緯度，值域和解釋與 KML 中緯度資料項目文字表述相同（見下文註釋）。"
      },
      {
        "id" : "Location.position.altitude",
        "path" : "Location.position.altitude",
        "short" : "以 WGS84 為基準的海拔高度",
        "definition" : "海拔高度，值域和解釋與 KML 中高度資料項目的文字表述相同（見下文註釋）。"
      },
      {
        "id" : "Location.managingOrganization",
        "path" : "Location.managingOrganization",
        "short" : "負責地點的提供與維護之機構",
        "definition" : "負責地點的提供與維護之機構",
        "comment" : "這也可以用來指出此地點隸屬於哪個機構，以及提供哪些服務。這些服務可以透過HealthcareService resource來具體定義。",
        "requirements" : "需要知道誰負責管理此地點",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Location.partOf",
        "path" : "Location.partOf",
        "short" : "此地點是另一個地點的一部分",
        "definition" : "此地點是另一個地點的一部分",
        "requirements" : "為了方便查找地點、顯示地點以及識別地點，知道哪些地點位於其他地點之內是重要的。",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Location.hoursOfOperation",
        "path" : "Location.hoursOfOperation",
        "short" : "這個地點通常在一個星期的哪些日子/時間開放？",
        "definition" : "這個地點通常在一個星期的哪些日子/時間開放？",
        "comment" : "這種資訊通常可以在目錄和網站上找到，以告知客戶機構的開放時間。此地點內的特定服務可能有自己的營業時間，這些時間可能會比此地點的整體營業時間短或長。"
      },
      {
        "id" : "Location.hoursOfOperation.daysOfWeek",
        "path" : "Location.hoursOfOperation.daysOfWeek",
        "definition" : "在規定的開始和結束時間內，一週中哪些天是開放的。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DaysOfWeek"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/days-of-week|4.0.1"
        }
      },
      {
        "id" : "Location.hoursOfOperation.allDay",
        "path" : "Location.hoursOfOperation.allDay",
        "short" : "此地點全天開放",
        "definition" : "此地點全天開放"
      },
      {
        "id" : "Location.hoursOfOperation.openingTime",
        "path" : "Location.hoursOfOperation.openingTime",
        "short" : "此地點的開放時間",
        "definition" : "此地點的開放時間"
      },
      {
        "id" : "Location.hoursOfOperation.closingTime",
        "path" : "Location.hoursOfOperation.closingTime",
        "short" : "此地點的關閉時間",
        "definition" : "此地點的關閉時間"
      },
      {
        "id" : "Location.availabilityExceptions",
        "path" : "Location.availabilityExceptions",
        "short" : "可用性例外情況說明",
        "definition" : "描述地點開放時間與正常情況不同的情形，例如國定假日。簡明扼要地描述所有可能的異常情況，這些異常情況在開放時間的時間表中有詳細說明。"
      },
      {
        "id" : "Location.endpoint",
        "path" : "Location.endpoint",
        "short" : "提供用於此地點運營服務的技術端點",
        "definition" : "提供用於此地點運營服務的技術端點",
        "requirements" : "機構在不同地點有提供各種服務的不同系統，需要明確怎樣以及為了什麼目的來連接這些系統的技術詳情。"
      }
    ]
  }
}

```
